/* Module:          SQLSetCursorName.c
 *
 * Description:     Associates a cursor name with an active statement.
 *
 * Classes:         
 *
 * API functions:   SQLSetCursorName
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLSetCursorName(
        SQLHSTMT     hDrvStmt,
        SQLCHAR *szCursor,
        SQLSMALLINT     nCursorLength)
{
static char *func="SQLSetCursorName";
StatementClass *stmt = (StatementClass *) hDrvStmt;
int len;

mylog("SQLSetCursorName: hDrvStmt=%u, szCursor=%u, cbCursorMax=%d\n", hDrvStmt, szCursor, nCursorLength);

	if ( ! stmt) {
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}

	len = (nCursorLength == SQL_NTS) ? strlen(szCursor) : nCursorLength;

	if (len <= 0 || len > sizeof(stmt->cursor_name) - 1) {
		stmt->errornumber = STMT_INVALID_CURSOR_NAME;
		stmt->errormsg = "Invalid Cursor Name";
		SC_log_error(func, "", stmt);
		return SQL_ERROR;
	}

	strncpy_null(stmt->cursor_name, szCursor, len+1);
	return SQL_SUCCESS;
}
