#!/bin/sh

# Quality Assurance script -- it should pass without errors

dir=".."
opt="-v -d"
if [ ! -z "$1" ] ; then
	slave_h="-h $1"
	slave_sh="--slavehost $1"
	echo "using slave host $1"
fi

dropdb master
dropdb $slave_h slave
createdb master
createdb $slave_h slave
psql master < rep-demo.sql
psql $slave_h slave < rep-demo.sql
$dir/bin/MasterInit $opt master
$dir/bin/SlaveInit $slave_sh $opt master slave
$dir/bin/MasterAddTable $opt master a id
$dir/bin/MasterAddTable $opt master b id
$dir/bin/MasterAddTable $opt master a_b a_id
$dir/bin/MasterAddTable $opt master c foo
$dir/bin/SlaveAddTable $slave_sh $opt slave a id
$dir/bin/SlaveAddTable $slave_sh $opt slave b id
$dir/bin/SlaveAddTable $slave_sh $opt slave a_b b_id
$dir/bin/SlaveAddTable $slave_sh $opt slave c bar
$dir/bin/Replicate $slave_sh $opt master slave

loop=5
nr=0
while [ $nr != $loop ] ; do
	nr=`expr $nr + 1`
	echo "Pass $nr"

	$dir/misc/rserv_test.pl master a foo
	$dir/bin/Replicate $slave_sh $opt master slave
done
