
# check for postgres
AC_ARG_WITH(postgres-root,
	[	--with-postgres-root=DIR  postgres tree located in DIR],
	POSTGRES_ROOT="$withval",
	POSTGRES_ROOT=)

if test ".${POSTGRES_ROOT}" != . ; then
   POSTGRES_ROOT=`cd ${POSTGRES_ROOT} && pwd`
   LIBS="${LIBS} -L$POSTGRES_ROOT/lib -lecpg -lpq"
   INCLUDES="${INCLUDES} -I$POSTGRES_ROOT/include"
else
	for i in /usr/bin /usr/local/bin /usr/local/postgres/bin ; do
		if test -f "$i/pg_config" ; then
			POSTGRES_CONFIG="$i/pg_config"
		fi
	done
	if test "$POSTGRES_CONFIG" = "" ; then
		AC_MSG_ERROR(["could not find pg_config"])
	else
		AC_MSG_RESULT(["$POSTGRES_CONFIG"])
		LIBS="${LIBS} -L`$POSTGRES_CONFIG --libdir` -lecpg -lpq"
		INCLUDES="${INCLUDES} -I`$POSTGRES_CONFIG --includedir`"
    fi
	POSTGRES_BINDIR=`$POSTGRES_CONFIG --bindir`
	if test ! -x $POSTGRES_BINDIR/ecpg ; then
		AC_MSG_ERROR(["could not find ecpg - need to install libecpg-dev for debian or postgress embedded SQL dev"])
	fi
fi
