/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Jar
extends Zip {
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private boolean mergeManifests = false;
    private boolean mergeManifestsMain = false;
    private Manifest manifest;
    private File manifestFile;
    private boolean index = false;

    public Jar() {
        this.archiveType = "jar";
        this.emptyBehavior = "create";
        this.setEncoding("UTF8");
    }

    public void setWhenempty(Zip.WhenEmpty we) {
        this.log("JARs are never empty, they contain at least a manifest file", 1);
    }

    public void setJarfile(File jarFile) {
        this.setDestFile(jarFile);
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) {
        if (!manifestFile.exists()) {
            throw new BuildException("Manifest file: " + manifestFile + " does not exist.", this.getLocation());
        }
        this.manifestFile = manifestFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File manifestFile) {
        Manifest newManifest = null;
        FileReader r = null;
        try {
            try {
                r = new FileReader(manifestFile);
                newManifest = this.getManifest(r);
            }
            catch (IOException e) {
                throw new BuildException("Unable to read manifest file: " + manifestFile + " (" + e.getMessage() + ")", e);
            }
            Object var6_4 = null;
            if (r == null) return newManifest;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (r == null) throw throwable;
            try {
                ((Reader)r).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        ((Reader)r).close();
        return newManifest;
    }

    private Manifest getManifest(Reader r) {
        Manifest newManifest = null;
        try {
            newManifest = new Manifest(r);
        }
        catch (ManifestException e) {
            this.log("Manifest is invalid: " + e.getMessage(), 0);
            throw new BuildException("Invalid Manifest: " + this.manifestFile, e, this.getLocation());
        }
        catch (IOException e) {
            throw new BuildException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
        return newManifest;
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        String filesetManifestConfig = config.getValue();
        this.mergeManifests = !"skip".equals(filesetManifestConfig);
        this.mergeManifestsMain = "merge".equals(filesetManifestConfig);
    }

    public void addMetainf(ZipFileSet fs) {
        fs.setPrefix("META-INF/");
        super.addFileset(fs);
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        String ls = System.getProperty("line.separator");
        try {
            try {
                Manifest finalManifest = Manifest.getDefaultManifest();
                if (this.manifest == null) {
                    if (this.manifestFile != null) {
                        this.manifest = this.getManifest(this.manifestFile);
                        finalManifest.merge(this.filesetManifest);
                        finalManifest.merge(this.configuredManifest);
                        finalManifest.merge(this.manifest, !this.mergeManifestsMain);
                    } else if (this.configuredManifest != null) {
                        finalManifest.merge(this.filesetManifest);
                        finalManifest.merge(this.configuredManifest, !this.mergeManifestsMain);
                    } else if (this.filesetManifest != null) {
                        finalManifest.merge(this.filesetManifest, !this.mergeManifestsMain);
                    }
                } else {
                    finalManifest.merge(this.filesetManifest);
                    finalManifest.merge(this.configuredManifest);
                    finalManifest.merge(this.manifest, !this.mergeManifestsMain);
                }
                Enumeration e = finalManifest.getWarnings();
                while (e.hasMoreElements()) {
                    this.log("Manifest warning: " + (String)e.nextElement(), 1);
                }
                System.getProperties().put("line.separator", "\r\n");
                this.zipDir(null, zOut, "META-INF/");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(baos);
                finalManifest.write(writer);
                writer.flush();
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                super.zipFile(bais, zOut, "META-INF/MANIFEST.MF", System.currentTimeMillis(), null);
                super.initZipOutputStream(zOut);
            }
            catch (ManifestException e) {
                this.log("Manifest is invalid: " + e.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e, this.getLocation());
            }
            Object var9_9 = null;
            System.getProperties().put("line.separator", ls);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            System.getProperties().put("line.separator", ls);
            throw throwable;
        }
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, BuildException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.zipFile.getName());
        Enumeration enumeration = this.addedDirs.keys();
        while (enumeration.hasMoreElements()) {
            String dir = (String)enumeration.nextElement();
            int pos = (dir = dir.replace('\\', '/')).lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            if (dir.startsWith("META-INF")) continue;
            writer.println(dir);
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null);
    }

    protected void zipFile(File file, ZipOutputStream zOut, String vPath) throws IOException {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(vPath)) {
            this.filesetManifest(file, null);
        } else {
            super.zipFile(file, zOut, vPath);
        }
    }

    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File file) throws IOException {
        if ("META-INF/MANIFEST.MF".equalsIgnoreCase(vPath)) {
            this.filesetManifest(file, is);
        } else {
            super.zipFile(is, zOut, vPath, lastModified, null);
        }
    }

    private void filesetManifest(File file, InputStream is) {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.log("Found manifest " + file, 3);
            this.manifest = is != null ? this.getManifest(new InputStreamReader(is)) : this.getManifest(file);
        } else if (this.mergeManifests) {
            this.log("Found manifest to merge in file " + file, 3);
            try {
                Manifest newManifest = this.getManifest(new InputStreamReader(is));
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                }
                this.filesetManifest.merge(newManifest);
            }
            catch (ManifestException e) {
                this.log("Manifest in file " + file + " is invalid: " + e.getMessage(), 0);
                throw new BuildException("Invalid Manifest", e, this.getLocation());
            }
        } else {
            this.log("File " + file + " includes a META-INF/MANIFEST.MF which will be ignored. " + "To include this file, set filesetManifest to a value other " + "than 'skip'.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isUpToDate(FileScanner[] scanners, File zipFile) throws BuildException {
        block15: {
            block16: {
                block14: {
                    if (this.configuredManifest == null && this.manifestFile != null) {
                        if (this.manifestFile.lastModified() <= zipFile.lastModified()) return super.isUpToDate(scanners, zipFile);
                        return false;
                    }
                    theZipFile = null;
                    try {
                        try {
                            theZipFile = new ZipFile(zipFile);
                            entry = theZipFile.getEntry("META-INF/MANIFEST.MF");
                            if (entry == null) {
                                this.log("Updating jar since the current jar has no manifest", 3);
                                var5_6 = false;
                                var8_9 = null;
                                if (theZipFile == null) return var5_6;
                                break block14;
                            }
                            currentManifest = new Manifest(new InputStreamReader(theZipFile.getInputStream(entry)));
                            if (this.configuredManifest == null) {
                                this.configuredManifest = Manifest.getDefaultManifest();
                            }
                            if (currentManifest.equals(this.configuredManifest)) break block15;
                            this.log("Updating jar since jar manifest has changed", 3);
                            var6_19 = false;
                            break block16;
                        }
                        catch (Exception e) {
                            this.log("Updating jar since cannot read current jar manifest: " + e.getClass().getName() + " - " + e.getMessage(), 3);
                            var5_8 = false;
                            var8_12 = null;
                            if (theZipFile == null) return var5_8;
                            try {
                                theZipFile.close();
                                return var5_8;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            return var5_8;
                        }
                    }
                    catch (Throwable var7_20) {
                        var8_13 = null;
                        if (theZipFile == null) throw var7_20;
                        ** try [egrp 2[TRYBLOCK] [6 : 193->200)] { 
lbl41:
                        // 1 sources

                        theZipFile.close();
                        throw var7_20;
lbl43:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        throw var7_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [6 : 193->200)] { 
lbl48:
                // 1 sources

                theZipFile.close();
                return var5_6;
lbl50:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var5_6;
            }
            var8_10 = null;
            if (theZipFile == null) return var6_19;
            ** try [egrp 2[TRYBLOCK] [6 : 193->200)] { 
lbl57:
            // 1 sources

            theZipFile.close();
            return var6_19;
lbl59:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var6_19;
        }
        var8_11 = null;
        if (theZipFile == null) return super.isUpToDate(scanners, zipFile);
        try {}
        catch (IOException e) {}
        theZipFile.close();
        return super.isUpToDate(scanners, zipFile);
        return super.isUpToDate(scanners, zipFile);
    }

    protected boolean createEmptyZip(File zipFile) {
        return true;
    }

    protected void cleanUp() {
        super.cleanUp();
        this.manifest = null;
        this.configuredManifest = this.savedConfiguredManifest;
        this.filesetManifest = null;
    }

    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.mergeManifests = false;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    static {
        INDEX_NAME = INDEX_NAME;
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

