/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.File;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.FileUtils;

public class JavaEnvUtils {
    private static final boolean isDos = Os.isFamily("dos");
    private static final boolean isNetware = Os.isName("netware");
    private static final boolean isAix = Os.isName("aix");
    private static final String javaHome = System.getProperty("java.home");
    private static final FileUtils fileUtils = FileUtils.newFileUtils();
    private static String javaVersion;
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";

    public static String getJavaVersion() {
        return javaVersion;
    }

    public static boolean isJavaVersion(String version) {
        return javaVersion == version;
    }

    public static String getJreExecutable(String command) {
        if (isNetware) {
            return command;
        }
        File jExecutable = JavaEnvUtils.findInDir(javaHome + "/bin", command);
        if (jExecutable == null && isAix) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/sh", command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        return JavaEnvUtils.addExtension(command);
    }

    public static String getJdkExecutable(String command) {
        if (isNetware) {
            return command;
        }
        File jExecutable = JavaEnvUtils.findInDir(javaHome + "/../bin", command);
        if (jExecutable == null && isAix) {
            jExecutable = JavaEnvUtils.findInDir(javaHome + "/../sh", command);
        }
        if (jExecutable != null) {
            return jExecutable.getAbsolutePath();
        }
        return JavaEnvUtils.getJreExecutable(command);
    }

    private static String addExtension(String command) {
        return command + (isDos ? ".exe" : "");
    }

    private static File findInDir(String dirName, String commandName) {
        File dir = fileUtils.normalize(dirName);
        File executable = null;
        if (dir.exists() && !(executable = new File(dir, JavaEnvUtils.addExtension(commandName))).exists()) {
            executable = null;
        }
        return executable;
    }

    static {
        JAVA_1_0 = JAVA_1_0;
        JAVA_1_1 = JAVA_1_1;
        JAVA_1_2 = JAVA_1_2;
        JAVA_1_3 = JAVA_1_3;
        JAVA_1_4 = JAVA_1_4;
        try {
            javaVersion = JAVA_1_0;
            Class.forName("java.lang.Void");
            javaVersion = JAVA_1_1;
            Class.forName("java.lang.ThreadLocal");
            javaVersion = JAVA_1_2;
            Class.forName("java.lang.StrictMath");
            javaVersion = JAVA_1_3;
            Class.forName("java.lang.CharSequence");
            javaVersion = JAVA_1_4;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

