/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseStatement;
import java.sql.SQLException;

public class BaseQueryTimeoutEnforcer
extends Thread {
    private static final String footprint = "$Revision:   1.1  $";
    private BaseStatement statement;
    private int timeout = 0;
    private boolean continueRunning = true;

    BaseQueryTimeoutEnforcer() {
        this.setDaemon(true);
        this.setName("DataDirect Connect Query Timeout-Thread");
        this.start();
    }

    synchronized void exit() {
        this.continueRunning = false;
        this.timeout = 0;
        this.notify();
    }

    synchronized void resetTimeoutPeriod() {
        this.timeout = 0;
        this.statement = null;
        this.notify();
    }

    public synchronized void run() {
        while (this.continueRunning) {
            if (this.timeout == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                this.wait(this.timeout * 1000);
            }
            catch (InterruptedException interruptedException) {}
            if (this.timeout == 0) continue;
            try {
                this.statement.timeoutEnforcerCanceledExecution = true;
                this.statement.cancel();
            }
            catch (SQLException sQLException) {}
            this.timeout = 0;
        }
    }

    synchronized void startTimeoutPeriod(BaseStatement baseStatement, int n) {
        this.statement = baseStatement;
        this.timeout = n;
        this.notify();
    }
}

