/*
 * Decompiled with CFR 0.152.
 */
package xcodegen.parser;

import java.util.HashMap;
import xcodegen.structure.AbstractXObject;

public class ParserError {
    public static final String INVALID_FILE_FORMAT = "INVALID_FILE_FORMAT";
    public static final String DUPLICATE_CLASS = "DUPLICATE_CLASS";
    public static final String SUPERCLASS_NOT_FOUND = "SUPERCLASS_NOT_FOUND";
    public static final String INVALID_SUPERCLASS = "INVALID_SUPERCLASS";
    public static final String MISSING_PK = "MISSING_PK";
    public static final String SUBCLASS_WITH_PK = "SUBCLASS_WITH_PK";
    public static final String PK_NOT_FOUND = "PK_NOT_FOUND";
    public static final String DUPLICATE_FIELD = "DUPLICATE_FIELD";
    public static final String FIELD_SIZE_FORMAT = "FIELD_SIZE_FORMAT";
    public static final String INVALID_REFERENCE = "INVALID_REFERENCE";
    public static final String DUPLICATE_FINDER = "DUPLICATE_FINDER";
    public static final String PARAMETER_COUNT = "PARAMETER_COUNT";
    public static final String DUPLICATE_PARAMETER = "DUPLICATE_PARAMETER";
    private String _code;
    private AbstractXObject _source;
    private Object _msg;
    private static HashMap __codemsg = new HashMap();

    public ParserError(String string, AbstractXObject abstractXObject) {
        this._code = string;
        this._source = abstractXObject;
    }

    public ParserError(String string, Object object, AbstractXObject abstractXObject) {
        this._code = string;
        this._source = abstractXObject;
        this._msg = object;
    }

    public String toString() {
        String string = (String)__codemsg.get(this._code);
        if (string == null) {
            string = this._code;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.path(this._source)).append(" - ").append(string);
        if (this._msg != null) {
            stringBuffer.append(" : " + this._msg);
        }
        return stringBuffer.toString();
    }

    private String path(AbstractXObject abstractXObject) {
        if (abstractXObject == null) {
            return "";
        }
        String string = this.path(abstractXObject.getParent());
        String string2 = abstractXObject.getName();
        return string == null ? string2 : string + "." + string2;
    }

    static {
        __codemsg.put(INVALID_FILE_FORMAT, "Invalid file format");
        __codemsg.put(DUPLICATE_CLASS, "Duplicate class");
        __codemsg.put(DUPLICATE_CLASS, "Duplicate class");
        __codemsg.put(SUPERCLASS_NOT_FOUND, "Superclass not found");
        __codemsg.put(INVALID_SUPERCLASS, "Invalid superclass");
        __codemsg.put(MISSING_PK, "Primary key is missing");
        __codemsg.put(SUBCLASS_WITH_PK, "A subclass cannot have a PrimaryKey field defined");
        __codemsg.put(PK_NOT_FOUND, "PrimaryKey field not found");
        __codemsg.put(DUPLICATE_FIELD, "Duplicate field");
        __codemsg.put(FIELD_SIZE_FORMAT, "The field size must be numeric");
        __codemsg.put(INVALID_REFERENCE, "Invalid reference");
        __codemsg.put(DUPLICATE_FINDER, "Duplicate finder");
        __codemsg.put(PARAMETER_COUNT, "Bad parameter count");
        __codemsg.put(DUPLICATE_PARAMETER, "Duplicate parameter");
    }
}

