/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS DropDB v 0.1                                                   
* Descripcion:
* Esta clase se encarga mostrar un dialogo donde la persona escoge 
* la base de datos a eliminar.            
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import java.beans.*;
import java.awt.*;
import java.awt.event.*;

class DropDB extends JDialog {
 String comboText = null;
 private JOptionPane optionPane;
 Language  idiom;
 JComboBox combo1;
 boolean doIt = false;

 /**
  * METODO Constructor DropDB
  *
  */
 public DropDB (Frame aFrame, Language lang, Vector dbnames) 
  {
   super(aFrame, true);
   idiom = lang;
   setTitle(idiom.getWord("DROPDB"));

   Vector dataB = new Vector();
   for(int i=0;i<dbnames.size();i++)
   {
    Vector o = (Vector) dbnames.elementAt(i);
    String db = (String) o.elementAt(0);
    dataB.addElement(db);
   }
   combo1 = new JComboBox(dataB);

   final String msgString1 = idiom.getWord("QDROPDB");
   final JTextField textField = new JTextField(20);
   Object[] array = {msgString1, combo1};

   final String btnString1 = idiom.getWord("DROP");
   final String btnString2 = idiom.getWord("CANCEL");
   Object[] options = {btnString1, btnString2};

   optionPane = new JOptionPane(array, 
                                JOptionPane.QUESTION_MESSAGE,
                                JOptionPane.YES_NO_OPTION,
                                null,
                                options,
                                options[0]);
   setContentPane(optionPane);
   addWindowListener(new WindowAdapter() 
    {
     public void windowClosing(WindowEvent we) 
      {
        optionPane.setValue(new Integer(JOptionPane.CLOSED_OPTION));
      }
    });

  optionPane.addPropertyChangeListener(new PropertyChangeListener() 
   {
     public void propertyChange(PropertyChangeEvent e) 
      {
       String prop = e.getPropertyName();
       if (isVisible() && (e.getSource() == optionPane)
           && (prop.equals(JOptionPane.VALUE_PROPERTY) ||
           prop.equals(JOptionPane.INPUT_VALUE_PROPERTY))) 
        {   
         Object value = optionPane.getValue();
         if (value == JOptionPane.UNINITIALIZED_VALUE) 
           return;

         if (value.equals(btnString1)) 
          {
           comboText = (String)combo1.getSelectedItem();
           doIt = true;
           setVisible(false);
          } 
         else 
            setVisible(false);
       }
     }
   });
 }

 public boolean confirmDropDB()
  {
    return doIt;
  }

} //Fin de la Clase

