/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS Querys v 0.1                                                   
* Descripcion:
* Esta clase se encarga del manejo la pestaa de consultas, incluye 
* mtodos para realizar, guardar, exportar una consulta.           
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import javax.swing.table.*;
import java.lang.String;
import java.io.*;
import java.util.Vector;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.*;
import javax.swing.border.TitledBorder;
import java.net.URL;

public class Querys extends JPanel implements ActionListener,SwingConstants,FocusListener,KeyListener {

 JToolBar QueryBar;
 JSplitPane splitQuerys;  //Panel redimensionable para consultas
 JMenuBar menuQry;	
 JPanel upBlock;
 JTextField title;
 JTextArea queryX, LogWin;
 JButton newQuery,loadQuery,saveQuery,runQuery,exportResult,functions;
 final JPopupMenu popup = new JPopupMenu();
 final JPopupMenu popup1 = new JPopupMenu();
 PGConnection pgConn;
 JTable table;
 JPanel downComponent;
 JScrollPane windowX;
 Vector resultGlobal;
 Vector columnNamesG;
 Object[] columnNames;
 Object[][] data;
 TitledBorder title1, title2;
 JRadioButton toFile,toReport;
 int exportTo = -1;
 Color currentColor;
 Vector columnas = new Vector();
 Vector datos = new Vector();
 String select = "";
 JFrame app;
 Language idiom;
 String ghostText="";
 boolean copy = false;
 boolean control = false;
 SQLFunctionDataStruc[] funcList;

 /**
  * METODO CONSTRUCTOR 
  *
  */
  public Querys (JFrame frame,Language glossary,JTextArea monitor) 
  {
   app = frame;
   idiom = glossary;
   LogWin = monitor;
   setLayout(new BorderLayout());

   QueryBar = new JToolBar(SwingConstants.VERTICAL);
   menuQry = new JMenuBar();    
   CreateToolBar();

   title = new JTextField(idiom.getWord("QUERYS"),39);  
   title.setHorizontalAlignment(JTextField.CENTER); 
   title.setEditable(false);
   upBlock = new JPanel();
   upBlock.setLayout(new FlowLayout(FlowLayout.CENTER));  
   JPanel auxBar = new JPanel();        // Panel donde va el toolbar de querys y el menu de funciones
   auxBar.setLayout(new BorderLayout());
   Border margin = BorderFactory.createBevelBorder(BevelBorder.LOWERED);
   auxBar.setBorder(margin);

   QueryBar.setFloatable(false);
   JPanel Space = new JPanel();
   Space.setLayout(new FlowLayout());
   Space.add(QueryBar);

   auxBar.add(Space,BorderLayout.NORTH);
   exportResult = new JButton(idiom.getWord("OK"));
   exportResult.setActionCommand("ButtonExport");
   exportResult.addActionListener(this);
   exportResult.setEnabled(false);
   JPanel tmp = new JPanel();
   tmp.setLayout(new CardLayout());

   toFile = new JRadioButton(idiom.getWord("FILE"));
   toFile.setMnemonic(idiom.getNemo("NEMO-FILE")); 
   toFile.setActionCommand("ExportToFile");
   toFile.addActionListener(this);

   toReport = new JRadioButton(idiom.getWord("REP"));
   toReport.setMnemonic(idiom.getNemo("NEMO-REP")); 
   toReport.setActionCommand("ExportToReport");
   toReport.addActionListener(this);

   JPanel tmp2 = new JPanel();
   tmp2.setLayout(new BoxLayout(tmp2, BoxLayout.Y_AXIS));

   tmp2.add(toFile);
   tmp2.add(toReport);

   tmp.add("Check1",exportResult); 

   JPanel altern = new JPanel();
   altern.setLayout(new BorderLayout());
   altern.add(tmp2,BorderLayout.CENTER);
   altern.add(tmp,BorderLayout.SOUTH);

   Border etched1 = BorderFactory.createEtchedBorder();
   title1 = BorderFactory.createTitledBorder(etched1,idiom.getWord("EXPTO"));
   currentColor = title1.getTitleColor();
   altern.setBorder(title1);

   auxBar.add(altern,BorderLayout.SOUTH);
   upBlock.add(title);
   SplitQuery();
   add(upBlock,BorderLayout.NORTH);
   add(auxBar,BorderLayout.EAST);
 }

 /**
  * METODO SplitQuery 
  * Hace el Split Panel de Consultas 
  */
 public void SplitQuery ()
  {  
   queryX = new JTextArea("");
   queryX.setEditable(true);
   queryX.addFocusListener(this); 

   JScrollPane component = new JScrollPane(queryX);
   splitQuerys = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
   splitQuerys.setTopComponent(component);
   showQueryResult(new Vector(),new Vector());   
   splitQuerys.setBottomComponent(downComponent);
   splitQuerys.setOneTouchExpandable(true); //el SplitPane muestra controles que permiten al 					   
   add(splitQuerys,BorderLayout.CENTER);

  splitQuerys.setDividerLocation(135); //Selecciona u obtiene la posicin actual del divisor. 
  splitQuerys.setPreferredSize(new Dimension(400,200));
 }

 /**
  * Metodo funcDataStruct
  * Organiza la definicion de las funciones
  */
 public SQLFunctionDataStruc[] funcDataStruct()
  {
    SQLFunctionDataStruc[] funcList = new SQLFunctionDataStruc[100];
    int[] funcSets = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
                       1, 1, 1, 1, 1, 1, 2, 1, 2, 1, 2, 2, 1, 1, 2, 1, 2, 1, 4,
                       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2,
                       2, 1, 3, 4, 1, 1, 1, 1, 2, 1, 2, 1 };
    
    String[][] descriptFunc = { 
    {"COALESCE(list)","non-NULL","COALESCE(rle, c2 + 5, 0)"},
    {"NULLIF(input,value)","input or NULL","NULLIF(c1, 'N/A')"},
    {"CASE WHEN expr THEN expr [...] ELSE expr END","expr","CASE WHEN c1 = 1 THEN 'match'<br>ELSE 'no match' END"},
    {"abs(float8)","float8","abs(-17.4)"},
    {"degrees(float8)","float8","degrees(0.5)"},
    {"exp(float8)","float8","exp(2.0)"},
    {"ln(float8)","float8","ln(2.0)"},
    {"log(float8)","float8","log(2.0)"},
    {"pi()","float8","pi()"},
    {"pow(float8,float8)","float8","pow(2.0, 16.0)"},
    {"radians(float8)","float8","radians(45.0)"},
    {"round(float8)","float8","round(42.4)"},
    {"sqrt(float8)","float8","sqrt(2.0)"},
    {"cbrt(float8)","float8","cbrt(27.0)"},
    {"trunc(float8)","float8","trunc(42.4)"},
    {"float(int)","float8","float(2)"},
    {"float4(int)","float4","float4(2)"},
    {"integer(float)","int","integer(2.0)"},
    {"acos(float8)","float8","acos(10.0)"},
    {"asin(float8)","float8","asin(10.0)"},
    {"atan(float8)","float8","atan(10.0)"},
    {"atan2(float8,float8)","float8","atan3(10.0,20.0)"},
    {"cos(float8)","float8","cos(0.4)"},
    {"cot(float8)","float8","cot(20.0)"},
    {"sin(float8)","float8","cos(0.4)"},
    {"tan(float8)","float8","tan(0.4)"},
    {"char_length(string)","int4","char_length('jose')"},
    {"character_length(string)","int4","character_length('jose')"},
    {"lower(string)","string","lower('TOM')"},
    {"octet_length(string)","int4","octet_length('jose')"},
    {"position(string in string)","int4","position('o' in 'Tom')"},
    {"substring(string [from int] [for int])","string","substring('Tom' from 2 for 2)"},
    {"trim([leading|trailing|both] [string] from string)","string","trim(both 'x' from 'xTomx')"},
    {"upper(text)","text","upper('tom')"},
    {"char(text)","char","char('text string')"},
    {"char(varchar)","char","char(varchar 'varchar string')"},
    {"initcap(text)","text","initcap('thomas')"},
    {"lpad(text,int,text)","text","lpad('hi',4,'??')"},
    {"ltrim(text,text)","text","ltrim('xxxxtrim','x')"},
    {"textpos(text,text)","text","position('high','ig')"},
    {"rpad(text,int,text)","text","rpad('hi',4,'x')"},
    {"rtrim(text,text)","text","rtrim('trimxxxx','x')"},
    {"substr(text,int[,int])","text","substr('hi there',3,5)"},
    {"text(char)","text","text('char string')"},
    {"text(varchar)","text","text(varchar 'varchar string')"},
    {"translate(text,from,to)","text","translate('12345', '1', 'a')"},
    {"varchar(char)","varchar","varchar('char string')"},
    {"varchar(text)","varchar","varchar('text string')"},
    {"abstime(timestamp)","abstime","abstime(timestamp 'now')"},
    {"age(timestamp)","interval","age(timestamp '1957-06-13')"},
    {"age(timestamp,timestamp)","interval","age('now', timestamp '1957-06-13')"},
    {"date_part(text,timestamp)","float8","date_part('dow',timestamp 'now')"},
    {"date_part(text,interval)","float8","date_part('hour',interval '4 hrs 3 mins')"},
    {"date_trunc(text,timestamp)","timestamp","date_trunc('month',abstime 'now')"},
    {"interval(reltime)","interval","interval(reltime '4 hours')"},
    {"isfinite(timestamp)","bool","isfinite(timestamp 'now')"},
    {"isfinite(interval)","bool","isfinite(interval '4 hrs')"},
    {"reltime(interval)","reltime","reltime(interval '4 hrs')"},
    {"timestamp(date)","timestamp","timestamp(date 'today')"},
    {"timestamp(date,time)","timestamp","timestamp(timestamp '1998-02-24',time '23:07');"},
    {"to_char(timestamp,text)","text","to_char(timestamp '1998-02-24','DD');"},
    {"to_char(timestamp, text)","text","to_char(timestamp 'now','HH12:MI:SS')"},
    {"to_char(int, text)","text","to_char(125, '999')"},
    {"to_char(float, text)","text","to_char(125.8, '999D9')"},
    {"to_char(numeric, text)","text","to_char(numeric '-125.8', '999D99S')"},
    {"to_date(text, text)","date","to_date('05 Dec 2000', 'DD Mon YYYY')"},
    {"to_timestamp(text, text)","date","to_timestamp('05 Dec 2000', 'DD Mon YYYY')"},
    {"to_number(text, text)","numeric","to_number('12,454.8-', '99G999D9S')"},
    {"area(object)","float8","area(box '((0,0),(1,1))')"},
    {"box(box,box)","box","box(box '((0,0),(1,1))',box '((0.5,0.5),(2,2))')"},
    {"center(object)","point","center(box '((0,0),(1,2))')"},
    {"diameter(circle)","float8","diameter(circle '((0,0),2.0)')"},
    {"height(box)","float8","height(box '((0,0),(1,1))')"},
    {"isclosed(path)","bool","isclosed(path '((0,0),(1,1),(2,0))')"},
    {"isopen(path)","bool","isopen(path '[(0,0),(1,1),(2,0)]')"},
    {"length(object)","float8","length(path '((-1,0),(1,0))')"},
    {"pclose(path)","path","popen(path '[(0,0),(1,1),(2,0)]')"},
    {"npoint(path)","int4","npoints(path '[(0,0),(1,1),(2,0)]')"},
    {"popen(path)","path","popen(path '((0,0),(1,1),(2,0))')"},
    {"radius(circle)","float","radius(circle '((0,0),2.0)')"},
    {"width(box)","float8","width(box '((0,0),(1,1))')"},
    {"box(circle)","box","box('((0,0),2.0)'::circle)"},
    {"box(point,point)","box","box('(0,0)'::point,'(1,1)'::point)"},
    {"box(polygon)","box","box('((0,0),(1,1),(2,0))'::polygon)"},
    {"circle(box)","box","circle('((0,0),(1,1))'::box)"},
    {"circle(point,float8)","circle","circle('(0,0)'::point,2.0)"},
    {"lseg(box)","lseg","lseg('((-1,0),(1,0))'::box)"},
    {"lseg(point,point)","lseg","lseg('(-1,0)'::point,'(1,0)'::point)"},
    {"path(polygon)","point","path('((0,0),(1,1),(2,0))'::polygon)"},
    {"point(circle)","point","point('((0,0),2.0)'::circle)"},
    {"point(lseg,lseg)","point","point('((-1,0),(1,0))'::lseg, '((-2,-2),(2,2))'::lseg)"},
    {"point(polygon)","point","point('((0,0),(1,1),(2,0))'::polygon)"},
    {"polygon(box)","polygon","polygon('((0,0),(1,1))'::box)"},
    {"polygon(circle)","polygon","polygon('((0,0),2.0)'::circle)"},
    {"polygon(npts,circle)","polygon","polygon(12,'((0,0),2.0)'::circle)"},
    {"polygon(path)","polygon","polygon('((0,0),(1,1),(2,0))'::path)"},
    {"isoldpath(path)","path","isoldpath('(1,3,0,0,1,1,2,0)'::path)"},
    {"revertpoly(polygon)","polygon","revertpoly('((0,0),(1,1),(2,0))'::polygon)"},
    {"upgradepath(path)","path","upgradepath('(1,3,0,0,1,1,2,0)'::path)"},
    {"upgradepoly(polygon)","polygon","upgradepoly('(0,1,2,0,1,0)'::polygon)"},
    {"broadcast(cidr)","text","broadcast('192.168.1.5/24')"},
    {"broadcast(inet)","text","broadcast('192.168.1.5/24')"},
    {"host(inet)","text","host('192.168.1.5/24')"},
    {"masklen(cidr)","int4","masklen('192.168.1.5/24')"},
    {"masklen(inet)","int4","masklen('192.168.1.5/24')"},
    {"netmask(inet)","text","netmask('192.168.1.5/24')"}
    };

    int counter = 0;
    int index = 0;
    SQLFunctionDataStruc func;

    for(int i=0;i<funcSets.length;i++)
     {
      if(funcSets[i] == 1)
       {
         int word = index + 1;
         func = new SQLFunctionDataStruc(idiom,descriptFunc[index][0],descriptFunc[index][1],
                                         idiom.getWord("FD" + word),descriptFunc[index][2]);    
         index++;
       }
      else
       {
         func = new SQLFunctionDataStruc(idiom);
         for(int j=0;j<funcSets[i];j++) 
          {
           int word = index + 1;
           func.addItem(descriptFunc[index][0],descriptFunc[index][1],idiom.getWord("FD" + word),
                        descriptFunc[index][2]);
           index++;
          }
       }
      funcList[counter] = func;
      counter++;
     }

    return funcList;
  }


 /**
  * METODO CreateToolBar
  * Crea Barra de Iconos 
  */
 public void CreateToolBar()
 {
  URL imgURL = getClass().getResource(idiom.getWord("ICONNEW"));
  newQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  newQuery.setActionCommand("ButtonNewQuery");
  newQuery.addActionListener(this);
  newQuery.setToolTipText(idiom.getWord("NEWQ"));
  QueryBar.add(newQuery);

  funcList = funcDataStruct(); 

  imgURL = getClass().getResource(idiom.getWord("ICONFUNC"));
  functions = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  functions.setToolTipText(idiom.getWord("FUNC"));

  JMenu menuSQL = new JMenu(idiom.getWord("FSQL")); 

  String[] funcSQL = {"COALESCE","NULLIF","CASE"};

  int counter = 0;

  for(int m=0;m<3;m++)
  {
   JMenuItem Item = new JMenuItem(funcSQL[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuSQL.add(Item);
  }

  popup.add(menuSQL);

  JMenu menuMath = new JMenu(idiom.getWord("FMATH"));

  JMenu menuNoTrans = new JMenu(idiom.getWord("FNTR")); 

  String[] funcNoTrans = {"ABS","DEGREES","EXP","LN","LOG","PI","POW","RADIANS","ROUND","SQRT","CBRT","TRUNC","FLOAT","FLOAT4","INTEGER"};

  for(int m=0;m<15;m++)
  {
   JMenuItem Item = new JMenuItem(funcNoTrans[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuNoTrans.add(Item);
  }

  JMenu menuTrans = new JMenu(idiom.getWord("FTR"));

  String[] funcTrans = {"ACOS","ASIN","ATAN","ATAN2","COS","COT","SIN","TAN"};

  for(int m=0;m<8;m++)
  {
   JMenuItem Item = new JMenuItem(funcTrans[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuTrans.add(Item);
  }

  menuMath.add(menuNoTrans);
  menuMath.add(menuTrans);
  popup.add(menuMath);

  JMenu menuString = new JMenu(idiom.getWord("FSTR"));

  JMenu menu92 = new JMenu(idiom.getWord("FSTR1"));

  String[] funcStrings = {"CHAR_LENGTH","CHARACTER_LENGTH","LOWER","OCTECT_LENGTH","POSITION","SUBSTRING","TRIM","UPPER"};

  for(int m=0;m<8;m++)
  {
   JMenuItem Item = new JMenuItem(funcStrings[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menu92.add(Item);
  }

  JMenu menuOther = new JMenu(idiom.getWord("FSTR2"));

  String[] funcOthers = {"CHAR","INITCAP","LPAD","LTRIM","TEXTPOS","RPAD","RTRIM","SUBSTR","TEXT","TRANSLATE","VARCHAR"};

  for(int m=0;m<11;m++)
  {
   JMenuItem Item = new JMenuItem(funcOthers[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuOther.add(Item);
  }

  menuString.add(menu92);
  menuString.add(menuOther);
  popup.add(menuString);

  JMenu menuDate = new JMenu(idiom.getWord("FDATE"));

  String[] funcDate = {"ABSTIME","AGE","DATE_PART","DATE_TRUNC","INTERVAL","ISFINITE","RELTIME","TIMESTAMP","TO_CHAR"};

  for(int m=0;m<9;m++)
  {
   JMenuItem Item = new JMenuItem(funcDate[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuDate.add(Item);
  }

  popup.add(menuDate);

  JMenu menuFormat = new JMenu(idiom.getWord("FDATEF"));

  String[] funcFormat = {"TO_CHAR","TO_DATE","TO_TIMESTAMP","TO_NUMBER"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcFormat[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuFormat.add(Item);
  }

  popup.add(menuFormat);

  JMenu menuGeo = new JMenu(idiom.getWord("FGEO"));

  JMenu menuBasic = new JMenu(idiom.getWord("FGEO1"));

  String[] funcBasic = {"AREA","BOX","CENTER","DIAMETER","HEIGHT","ISCLOSED","ISOPEN","LENGTH","PCLOSE","NPOINT","POPEN","RADIUS","WIDTH"};

  for(int m=0;m<13;m++)
  {
   JMenuItem Item = new JMenuItem(funcBasic[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuBasic.add(Item);
  }

  JMenu menuTC = new JMenu(idiom.getWord("FGEO2"));

  String[] funcTC = {"BOX","CIRCLE","LSEG","PATH","POINT","POLYGON"};

  for(int m=0;m<6;m++)
  {
   JMenuItem Item = new JMenuItem(funcTC[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuTC.add(Item);
  }

  JMenu menuUpgrade = new JMenu(idiom.getWord("FGEO3"));

  String[] funcUpgrade = {"ISOLDPATH","REVERTPOLY","UPGRADEPATH","UPGRADEPOLY"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcUpgrade[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuUpgrade.add(Item);
  }

  menuGeo.add(menuBasic);
  menuGeo.add(menuTC);
  menuGeo.add(menuUpgrade);

  popup.add(menuGeo);

  JMenu menuIP = new JMenu(idiom.getWord("FIPV4"));

  String[] funcIP = {"BROADCAST","HOST","MASKLEN","NETMASK"};

  for(int m=0;m<4;m++)
  {
   JMenuItem Item = new JMenuItem(funcIP[m]);
   String action = "POP" + counter;
   counter++;
   Item.setActionCommand(action);
   Item.addActionListener(this);
   menuIP.add(Item);
  }

  popup.add(menuIP);

  MouseListener mouseListener = new MouseAdapter() 
     {
       public void mousePressed(MouseEvent e) 
        {
          if (!popup.isVisible())
             popup.show(e.getComponent(),63,0);
        }
     };

  functions.addMouseListener(mouseListener);
  QueryBar.add(functions);

  imgURL = getClass().getResource(idiom.getWord("ICONOPEN"));
  loadQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  loadQuery.setActionCommand("ButtonLoadQuery");
  loadQuery.addActionListener(this);
  loadQuery.setToolTipText(idiom.getWord("OPENQ"));
  QueryBar.add(loadQuery);

  imgURL = getClass().getResource(idiom.getWord("ICONSAVE"));  
  saveQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  saveQuery.setActionCommand("ButtonSaveQuery");
  saveQuery.addActionListener(this);
  saveQuery.setToolTipText(idiom.getWord("SAVEQ"));
  QueryBar.add(saveQuery);
		
  imgURL = getClass().getResource(idiom.getWord("ICONRUN"));
  runQuery = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  runQuery.setActionCommand("ButtonRunQuery");
  runQuery.addActionListener(this);
  runQuery.setToolTipText(idiom.getWord("RUNQ"));
  QueryBar.add(runQuery);
 }		

 public void setNullPanel()
 { 
  newQuery.setEnabled(false); 
  saveQuery.setEnabled(false);
  runQuery.setEnabled(false); 
  exportResult.setEnabled(false);
  queryX.setText("");
  queryX.setEditable(false);
  showQueryResult(new Vector(),new Vector());
 } 

 public void showQueryResult(Vector rowData,Vector columnNames)
 {
   columnas = columnNames;
   datos = rowData;

   String[] colNames = new String[columnNames.size()];
   Object[][] rowD = new Object[rowData.size()][columnNames.size()];
   String title = "";

   if(columnNames.size()>0)
   {
     for(int p=0;p<columnNames.size();p++)
      {
       Object o = columnNames.elementAt(p);
       colNames[p] = o.toString();
      }

     for(int p=0;p<rowData.size();p++)
     { 
       Vector tempo = (Vector) rowData.elementAt(p);
       for(int j=0;j<columnNames.size();j++)
        {
         Object o = tempo.elementAt(j);
         rowD[p][j] = o;
        }
      }
      title = idiom.getWord("RES2") + " (" + rowData.size() + " " + idiom.getWord("RECS") + ")";
   }
   else 
     title = idiom.getWord("NORES");
	 
   MyTableModel myModel = new MyTableModel(rowD,colNames);
   table = new JTable(myModel);
   downComponent = new JPanel();
   JLabel titleResult = new JLabel(title,JLabel.CENTER);
   if(title.equals(idiom.getWord("NORES"))) 
    {
      titleResult.setEnabled(false);
      title1.setTitleColor(new Color(153,153,153));
      toFile.setSelected(false);
      toReport.setSelected(false);
      toFile.setEnabled(false);
      toReport.setEnabled(false);
    }
   else 
    {
      title1.setTitleColor(currentColor);
      titleResult.setEnabled(true);
      toFile.setEnabled(true);
      toReport.setEnabled(true);
    }

   updateUI();           
   JPanel upPan = new JPanel();  
   upPan.setLayout(new BorderLayout());
   upPan.add(titleResult,BorderLayout.CENTER);
   JButton buttonEmpty = new JButton(); 
   buttonEmpty.setPreferredSize(new Dimension (132,2)); 
   upPan.add(buttonEmpty,BorderLayout.SOUTH); 
   downComponent.setLayout(new BorderLayout());
   downComponent.add(upPan,BorderLayout.NORTH);
   windowX = new JScrollPane(table); 
   downComponent.add(windowX,BorderLayout.CENTER);
   splitQuerys.setBottomComponent(downComponent);
   splitQuerys.setDividerLocation(135);
  } 

 public void actionPerformed(java.awt.event.ActionEvent e) {

 if(e.getActionCommand().equals("ExportToFile"))
  {
   if(toFile.isSelected())
     {
      exportTo = 1;
      toReport.setSelected(false);
      exportResult.setEnabled(true);
    }
   else
      toReport.setSelected(true);
   return;
  }

 if(e.getActionCommand().equals("ExportToReport"))
  {
   if(toReport.isSelected())
    {
     exportTo = 2;
     toFile.setSelected(false);
     exportResult.setEnabled(true);
    }
   else 
     toFile.setSelected(true);
   return;
  }

 if(e.getActionCommand().equals("ButtonNewQuery") )
  {
   NewQuery();
   return;
  }

 if(e.getActionCommand().equals("ButtonLoadQuery") )
  {
   LoadQuery();
   return;
  }
 
 if(e.getActionCommand().equals("ButtonSaveQuery") )
  {
    String instructions =  new String (queryX.getText());
    String s = "file:" + System.getProperty("user.dir");
    File file;
    boolean Rewrite = true;
    String FileName = "";

    JFileChooser fc = new JFileChooser(s);
    ExtensionFilter filter = new ExtensionFilter("sql",idiom.getWord("SQLF"));
    fc.addChoosableFileFilter(filter);

    int returnVal = fc.showDialog(app,idiom.getWord("SAVEQ"));

    if (returnVal == JFileChooser.APPROVE_OPTION) {
           file = fc.getSelectedFile();
           FileName = file.getAbsolutePath(); // Camino Absoluto
           if(file.exists())
            { 
              BoolOption win = new BoolOption(app,idiom.getWord("YES"),idiom.getWord("No"),idiom.getWord("ADV"),
                        idiom.getWord("FILE") + " \"" + FileName + "\" " + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
              win.pack();
              win.setLocationRelativeTo(app);
              win.show();
              Rewrite = win.getSelecction();
            } 
           if(Rewrite)
           { 

	     try 
              {
                if(!FileName.endsWith(".sql"))
                  FileName += ".sql";

	        PrintStream saveFile = new PrintStream(new FileOutputStream(FileName));
                QuerySaver(saveFile,instructions);
	      }
             catch(Exception ex) { }
           } // fin if
        } // fin if 

  return;
 }

 if(e.getActionCommand().equals("ButtonRunQuery") )
  {
    RunQuery(queryX.getText());
    return;
  }

 if(e.getActionCommand().equals("ButtonExport"))
  {
    if(exportTo == 1) {
    ExportSeparatorField little = new ExportSeparatorField(app,idiom);
    little.setSize(260,150);
    little.pack();
    little.setLocationRelativeTo(app);
    little.show();
    if(little.isDone()) 
      {
        String limiter = little.getLimiter();
          
        String s = "file:" + System.getProperty("user.dir");
        File file;
        boolean Rewrite = true;
        String FileName = "";
        JFileChooser fc = new JFileChooser(s);                 
        if(limiter.equals("csv"))
         {
           ExtensionFilter filter = new ExtensionFilter("csv",idiom.getWord("REPCSV")); 
           fc.addChoosableFileFilter(filter);
         }
        int returnVal = fc.showDialog(app,idiom.getWord("EXPTO"));

        if (returnVal == JFileChooser.APPROVE_OPTION) 
          {
           file = fc.getSelectedFile();
           FileName = file.getAbsolutePath(); // Camino Absoluto
           if(file.exists())
             { 
               BoolOption win = new BoolOption(app,idiom.getWord("YES"),idiom.getWord("NO"),idiom.getWord("ADV"),
               idiom.getWord("FILE") + " \"" + FileName + "\" " + idiom.getWord("SEQEXIS2") + " " + idiom.getWord("OVWR"));
               win.pack();
               win.setLocationRelativeTo(app);
               win.show();
               Rewrite = win.getSelecction();
             } 
           if(Rewrite)
             { 
               try {
                     if(limiter.equals("csv") && !FileName.endsWith(".csv"))
                        FileName += ".csv"; 
                     PrintStream exportFile = new PrintStream(new FileOutputStream(FileName));
          	     printFile(exportFile,resultGlobal,columnNamesG,limiter);
	           }
               catch(Exception ex) 
                   {  
                     System.out.println("Error: " + ex);
                     ex.printStackTrace();
                   }
             }
              
          } 
          else 
           {
            toFile.setSelected(false);
            exportTo = -1;
            exportResult.setEnabled(false);
           }
        }
       else {
             toFile.setSelected(false);
             exportTo = -1;
             exportResult.setEnabled(false);
            }
     }
    else {
           if(exportTo == 2)
            {
             ReportDesigner format = new ReportDesigner(app,columnas,datos,idiom,LogWin,
                                                        getTablesN(select),pgConn);
             exportTo = -1;
             toReport.setSelected(false);
             exportResult.setEnabled(false);
            }
         }

     return;
    }

 if(e.getActionCommand().startsWith("POP")) 
  {
   String number = e.getActionCommand().substring(3);
   int m = new Integer(number).intValue();

   setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
   String html = funcList[m].getHtml(); 
   SQLFunctionDisplay showHelp = new SQLFunctionDisplay(idiom,app,html);
   showHelp.pack();
   showHelp.setLocationRelativeTo(app);
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
   showHelp.show();

   if(showHelp.isUsed())
     {
      String text = queryX.getText();
      int lengthText = text.length();

      String funcName = showHelp.getFuncName();
      int pos = queryX.getCaretPosition();
      queryX.insert(funcName,pos);

      if(lengthText < 1)
         newQuery.setEnabled(true);
     } 

   return;
  }

 }

 public static String clearSpaces (String inS)
  {
   String valid = "";

   if((inS.indexOf("  ") != -1) || (inS.indexOf("\t") != -1) || (inS.indexOf("\n") != -1))
    {
     int x = 0;
     while (x < inS.length()-1)      
      {
        char w = inS.charAt(x);
        if (w == '\t'  && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n' ) && (x!=0) && ( inS.charAt(x+1) != ';'))
          valid = valid + " ";
	if (w == '\t'  && (( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) == '\n') || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
        if ( w == ' ' && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n') && (x!=0) && ( inS.charAt(x+1) != ';'))
          valid = valid + w;
	if (w == ' '  && ( (x==0) || ( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) != '\n') || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
	if ( w == '\n' && ( inS.charAt(x+1) != ' ') && ( inS.charAt(x+1) != '\t') && ( inS.charAt(x+1) != '\n' ) && ( inS.charAt(x+1) != ';'))
	  valid = valid + " ";
	if ( w == '\n' && (( inS.charAt(x+1) == ' ') || ( inS.charAt(x+1) == '\t') || ( inS.charAt(x+1) == '\n' ) || ( inS.charAt(x+1) == ';')))
	  valid = valid + "";
	if ( w != ' ' && w != '\t' && w != '\n')
	  valid = valid + w;
        x++;
      }
      char w = inS.charAt(inS.length()-1);
      if((w != '\n') && (w != '\t') && (w != ' '))
          valid = valid + w;
     }
     else
       valid = inS;

    while(valid.startsWith(" "))
      valid = valid.substring(1,valid.length());
				       
    return valid; 
 }

 public void setTextLabel(String mxg)
  {
    popup.setEnabled(false);
    title.setText(mxg);
  }

 public void setLabel(String dbName)
  {
   popup.setEnabled(true);
   String mesg = "";
   if(dbName.length()>0)
    mesg = idiom.getWord("QUERYS") + idiom.getWord("IN") + idiom.getWord("DB: "); 
   else
    mesg = idiom.getWord("QUERYS");

    title.setText(mesg + dbName);
  }

 public void focusGained(FocusEvent e) 
  {
    Component tmp = e.getComponent();
    tmp.addKeyListener(this);
  }

 public void focusLost(FocusEvent e) 
  {
    Component tmp = e.getComponent();
    tmp.removeKeyListener(this);
  } 

 public void keyTyped(KeyEvent e) 
  {
  }   

 public void keyPressed(KeyEvent e) 
  {
   String queryString = queryX.getText();

   if(runQuery.isEnabled())
    {
     int keyC = e.getKeyCode();
     String keyS = KeyEvent.getKeyText(keyC);

     if(keyS.equals("F9"))
       RunQuery(queryString);
    }
  
   int width = queryString.length(); 
   if(width > 15)
    { 
     newQuery.setEnabled(true);
     saveQuery.setEnabled(true);
     runQuery.setEnabled(true);
    } 
   else 
    {  
     saveQuery.setEnabled(false);
     runQuery.setEnabled(false);
     if(width > 0) 
       newQuery.setEnabled(true);
     else
       newQuery.setEnabled(false); 
    } 
  } 

 public void keyReleased(KeyEvent e) 
  {
  } 

 class MyTableModel extends AbstractTableModel 
  {

  public MyTableModel(Object[][] xdata,String[] colN) 
   {
    data = xdata;
    columnNames = colN;
   }
	     
  public String getColumnName(int col) 
   { 
    return columnNames[col].toString(); 
   }

  public int getRowCount() 
   { 
    return data.length; 
   }

  public int getColumnCount() 
   { 
    return columnNames.length; 
   }

  public Object getValueAt(int row, int col) 
   {
    return data[row][col]; 
   }

  public boolean isCellEditable(int row, int col) 
   { 
    return false; 
   }

  public void setValueAt(Object value, int row, int col) 
   {
    data[row][col] = value;
    fireTableCellUpdated(row, col);
   }
 }

public void printFile(PrintStream xfile,Vector registers,Vector FieldNames,String Separator)
 {
   String limit = "";
   boolean isCSV = false; 
   try {
        int TableWidth = FieldNames.size();
        if(Separator.equals("csv"))
         {
           limit = ",";
           isCSV = true;
         }
        else 
         {
          limit = Separator;
          for(int p=0;p<TableWidth;p++) 
           {
            String column = (String) FieldNames.elementAt(p);
            xfile.print(column);
            if(p<TableWidth-1)
              xfile.print(limit);
           }
          xfile.print("\n");
         }

        for(int p=0;p<registers.size();p++) 
          {
           Vector rData = (Vector) registers.elementAt(p); 
           for(int i=0;i<TableWidth;i++) 
            {
             Object o = rData.elementAt(i);
	     String field = o.toString();

             if(isCSV)
	      xfile.print("\"" + field + "\"");
             else
              xfile.print(field);

             if(i<TableWidth-1)
              xfile.print(limit);
            }
           xfile.print("\n");
          }

       }
       catch(Exception e) 
        { 
        }
 }

 public void QuerySaver(PrintStream saveFile,String instructions)
  {
     instructions = clearSpaces(instructions); 
     int k=0;
     int i=0;
     String oneQ = "";
     while(k != -1)
       { 
         k = instructions.indexOf(";",i);	
         if(k!=-1)
           {
            oneQ = instructions.substring(i,k+1);
	    i = k + 1;
            oneQ = oneQ.trim();
           }
          else
            oneQ = instructions.substring(i,instructions.length());
          saveFile.println(oneQ);
       }
  }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg)
 {
  LogWin.append(msg + "\n");	
  int longiT = LogWin.getDocument().getLength();
  if(longiT > 0)
    LogWin.setCaretPosition(longiT - 1);
 }	

 public void RunQuery(String querys) 
  {
    String prueba = clearSpaces(querys);
    int j;
    Vector oneI = new Vector();
    if ( prueba.endsWith(";"))
     {
       j = 0;
       int k = 0;
       while(true)
        {
          k = prueba.indexOf(";",j);
          if ( k == -1 )
             break;
          oneI.addElement(prueba.substring(j,k+1));			     
          j = k + 1;
        } 
     }
    else
     {
      JOptionPane.showMessageDialog(Querys.this,                               
      idiom.getWord("IVIC"),                       
      idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);               
     }
    boolean noMore = false;
    int numSelect = 0;
    for ( int i=0; i < oneI.size(); i++)
    {
      Object o = oneI.elementAt(i);
      String Stmp = o.toString();
      Stmp = Stmp.trim();
      String sentence = Stmp.toLowerCase();
      String val = "OK";
      if(sentence.startsWith("select")) 
       {
        resultGlobal = pgConn.TableQuery(sentence);
        if(pgConn.queryFail()) 
         {
          val = pgConn.problem;
          val = val.substring(0,val.length()-1);
         }
       }
      else 
       {
        String result = pgConn.SQL_Instruction(sentence);
        if(!result.equals("OK")) 
            result = result.substring(0,result.length()-1);
        val = result;
       }

      addTextLogMonitor(idiom.getWord("EXEC") + sentence + "\"");
      addTextLogMonitor(idiom.getWord("RES") + val);

      if(sentence.startsWith("select"))
       {
          numSelect++;
	  if(!noMore)
	  { 
           select = sentence;
           columnNamesG = pgConn.TableHeader;
           showQueryResult(resultGlobal,columnNamesG);
	   noMore = true;
	  }
       }
    }
    if(numSelect>1)
     {
       JOptionPane.showMessageDialog(Querys.this,
       idiom.getWord("SSQ"),
       idiom.getWord("INFO"),JOptionPane.INFORMATION_MESSAGE);
     }
  }

public void NewQuery()
  {
     queryX.setText("");
     exportResult.setEnabled(false);
     showQueryResult(new Vector(),new Vector());
     newQuery.setEnabled(false);
     saveQuery.setEnabled(false);
     runQuery.setEnabled(false);
     queryX.requestFocus();
  }

public void LoadQuery()
  {
   String xt = "file:" + System.getProperty("user.dir");
   JFileChooser fc = new JFileChooser(xt);
   int returnVal = fc.showOpenDialog(app);
   String s = "file:" + System.getProperty("user.dir") + System.getProperty("file.separator");
   if (returnVal == JFileChooser.APPROVE_OPTION)
    {
      File file = fc.getSelectedFile();
      SQLCompiler analitic = new SQLCompiler(file);
      Vector QueryText = analitic.Instructions;
      queryX.setText("");
      for(int m=0;m<QueryText.size();m++)
       {
        String tmpQ = "";
        if ( m == QueryText.size()-1)
          tmpQ = (String) QueryText.elementAt(m);
        else
          tmpQ = (String) QueryText.elementAt(m) + "\n";
        int newpos = 0;
        int k = 1;
        queryX.append(tmpQ);
       }
      newQuery.setEnabled(true);
      saveQuery.setEnabled(true);
      runQuery.setEnabled(true);
    }
 }

String getTablesN(String sqlSel)
  {
     String tmp = sqlSel.substring(6);
     if(tmp.indexOf("select") == -1)
      {
        int p = tmp.indexOf("from");
        int k = tmp.indexOf("where");
        if (k != -1)
         tmp = tmp.substring(p+5,k);
        else
         tmp = tmp.substring(p+5,tmp.length()-1);
      }

     tmp = tmp.trim();
     return tmp;
  }

} //Fin de la Clase
