/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS Registers v 0.1                                                   
* Descripcion:
* Esta clase se encarga de manejar el panel de Registros
* en la interfaz principal. A traves de este panel, se
* pueden realizar operaciones como ingresar, modificar y
* eliminar registros de una tabla.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*          Angela Sandobal  - angesand@libertad.univalle.edu.co     
*/

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.event.*;
import java.util.Vector;
import javax.swing.table.*;
import java.net.URL;

public class Registers extends JPanel implements ActionListener,SwingConstants {

 JToolBar StructureBar;
 JScrollPane tablaScroll;
 JPanel General;
 Language idiom;
 JTextField title;
 JScrollPane windowX;
 JPanel first;
 JPanel base;
 JButton insertRecord,delRecord,updateRecord,reportBut;
 JCheckBox rectangle,rectangle2;
 JComboBox combo1,combo2;
 JTextField combo3,numRegTextField,limitText; 
 JLabel men1,men2;
 JButton boton,advanced;
 JTable table;
 JPanel up;
 boolean primera = true;
 JFrame frame;
 String currentTable = "";
 String operator = "";
 String field = "";
 Table tableStruct;
 PGConnection connReg;
 final JPopupMenu popup = new JPopupMenu();
 String sentence;
 int numReg = 0;
 String firstField;

 Vector columnas = new Vector();
 Vector datos = new Vector(); 

 Object[] columnNames;
 Object[][] data;

 JTextArea LogWin;

 /******************** METODO CONSTRUCTOR ********************/
 public Registers (Language glossary,JFrame xframe,JTextArea log) {

  frame = xframe;
  idiom = glossary;
  LogWin = log;
  setLayout(new BorderLayout());
  StructureBar = new JToolBar(SwingConstants.VERTICAL);
  StructureBar.setFloatable(false);
  CreateToolBar();
  title = new JTextField("",39);
  title.setHorizontalAlignment(JTextField.CENTER);
  title.setEditable(false);
  JPanel top = new JPanel();
  top.setLayout(new FlowLayout(FlowLayout.CENTER));
  top.add(title);
  add(top,BorderLayout.NORTH); 

  setLabel("","",0,"");
  showQueryResult(new Vector(),new Vector());
  add(StructureBar,BorderLayout.WEST);
  pieDatos();
  add(first,BorderLayout.SOUTH);
  setSize(500,500);
}

/******************** METODO Filter() : Panel Filtro de Inf. ********************/

public void Filter() {
  base = new JPanel();
  base.setLayout(new BoxLayout(base, BoxLayout.Y_AXIS));
  JPanel row1 = new JPanel();
  row1.setLayout(new FlowLayout(FlowLayout.LEFT));
  JPanel row2 = new JPanel();
  row2.setLayout(new FlowLayout(FlowLayout.LEFT));
  CheckBoxListener myListener = new CheckBoxListener();
  String[] datmp = {""};
  String[] ig = {"=","!=","<",">","<=",">=","like","not like","~","~*","!~","!~*"};
  rectangle = new JCheckBox(idiom.getWord("FILTER")+":");
  rectangle.setMnemonic('F'); 
  rectangle.addItemListener(myListener);

  rectangle2 = new JCheckBox(idiom.getWord("LIMIT")+":");
  rectangle2.setMnemonic('L'); 
  rectangle2.addItemListener(myListener);

  combo1 = new JComboBox(datmp);
  combo2 = new JComboBox(ig);
  combo3 = new JTextField(10);

  combo1.setActionCommand("combo1");
  combo1.addActionListener(this);
  combo2.setActionCommand("combo2");
  combo2.addActionListener(this);

  JLabel space = new JLabel(" ");
  advanced = new JButton(idiom.getWord("OPC"));
  advanced.setActionCommand("Options");
  advanced.addActionListener(this);

  JMenuItem Item = new JMenuItem(idiom.getWord("ADF")); 
  Item.setActionCommand("ItemAdvanced");
  Item.addActionListener(this);
  popup.add(Item);

  Item = new JMenuItem(idiom.getWord("CUF")); 
  Item.setActionCommand("ItemCustomize");
  Item.addActionListener(this);
  popup.add(Item);

  MouseListener mouseListener = new MouseAdapter() {
	public void mousePressed(MouseEvent e) {
         if (!popup.isVisible() && advanced.isEnabled())
             popup.show(e.getComponent(),90,0);
 					       }
  };
  advanced.addMouseListener(mouseListener);

  JPanel panel1 = new JPanel();
  panel1.setLayout(new FlowLayout(FlowLayout.CENTER));
  panel1.add(advanced);

  row1.add(rectangle); 
  row1.add(combo1);
  row1.add(combo2);
  row1.add(combo3);
  row1.add(space);

  row1.add(advanced);

  numRegTextField = new JTextField(7);
  men1 = new JLabel(idiom.getWord("STARTR")+":"); 
  limitText = new JTextField(7);
  men2 = new JLabel(idiom.getWord("LRW"));

  boton = new JButton(idiom.getWord("UPDT"));
  boton.setActionCommand("boton");
  boton.addActionListener(this);
     
  JPanel panelbot = new JPanel();
  panelbot.add(boton);
  row2.add(rectangle2);
  row2.add(men1);
  row2.add(numRegTextField);
  row2.add(men2);
  row2.add(limitText);

  setRow1(false);
  setRow2(false);

  JPanel right = new JPanel();
  right.setLayout(new BorderLayout());
  right.add(row2,BorderLayout.WEST);
  right.add(panelbot,BorderLayout.EAST);
  base.add(row1); 
  base.add(right);
}

/******************** METODO pieDatos() : Texto de Operacion ********************/
public void pieDatos() {
   first = new JPanel();
   first.setLayout(new BorderLayout());
   Filter();
   first.add(base,BorderLayout.CENTER);
}

/******************** METODO CreateToolBar() : Crea Barra de Iconos ********************/
public void CreateToolBar() {
 
  URL imgURL = getClass().getResource("icons/16_InsertRecord.gif"); 
  insertRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  insertRecord.setActionCommand("ButtonInsertRecord");
  insertRecord.addActionListener(this);
  insertRecord.setToolTipText(idiom.getWord("INSREC"));
  StructureBar.add(insertRecord);

  imgURL = getClass().getResource("icons/16_DelRecord.gif");
  delRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  delRecord.setActionCommand("ButtonDelRecord");
  delRecord.addActionListener(this);
  delRecord.setToolTipText(idiom.getWord("DELREC"));
  delRecord.setEnabled(false);
  StructureBar.add(delRecord);

  imgURL = getClass().getResource("icons/16_UpdateRecord.gif");
  updateRecord = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  updateRecord.setActionCommand("ButtonUpdateRecord");
  updateRecord.addActionListener(this);
  updateRecord.setToolTipText(idiom.getWord("UPDREC"));
  updateRecord.setEnabled(false);
  StructureBar.add(updateRecord);

  imgURL = getClass().getResource("icons/16_NewTable.gif");
  reportBut = new JButton(new ImageIcon(Toolkit.getDefaultToolkit().getImage(imgURL)));
  reportBut.setActionCommand("ExportToReport");
  reportBut.addActionListener(this);
  reportBut.setToolTipText("Export to Report");
  reportBut.setEnabled(false);
  StructureBar.add(reportBut);
    
}

/******************** METODO actionPerformed() : Manejador de Eventos ********************/
public void actionPerformed(java.awt.event.ActionEvent e) {

if(e.getActionCommand().equals("ButtonInsertRecord") )
 {
   setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
   InsertData insert = new InsertData(tableStruct,frame,idiom);
   setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

   if(insert.wasOk())
     {
      addTextLogMonitor(idiom.getWord("EXEC")+ insert.getSQLString() + "\"");
      String result = connReg.SQL_Instruction(insert.getSQLString());
      if(result.equals("OK")) {	   
        Vector res = connReg.TableQuery("SELECT * FROM " + tableStruct.getName());
        Vector col = connReg.getTableHeader();
        int oldNum = numReg;
        numReg = res.size();
        if(!connReg.queryFail()) 
          {
           String owner = connReg.getOwner(tableStruct.getName()); 
           setLabel(connReg.DBdata.Database,tableStruct.getName(),numReg,owner);
           showQueryResult(res,col);
           if(oldNum==0)
            {
             rectangle.setEnabled(true);
             rectangle2.setEnabled(true);
             advanced.setEnabled(true);
            }
           updateUI(); 
          }    
                              }
        else
        {
     	 result = result.substring(0,result.length()-1);
         ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
         showError.pack();
         showError.setLocationRelativeTo(frame); 
         showError.show();
        }
      addTextLogMonitor(idiom.getWord("RES") + result);

     }
 }
    
 if(e.getActionCommand().equals("ButtonDelRecord") )
  {
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    DropTableRecord Eraser = new DropTableRecord(tableStruct,frame,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    if(Eraser.wellDone)
     {
      addTextLogMonitor(idiom.getWord("EXEC")+ Eraser.delete + "\"");
      String result = connReg.SQL_Instruction(Eraser.delete);
      if(result.equals("OK")) {
        Vector res = connReg.TableQuery("select * from " + tableStruct.Name);
        Vector col = connReg.getTableHeader();
        numReg = res.size();
        if(!connReg.queryFail()) 
          {
           String owner = connReg.getOwner(tableStruct.Name);
           setLabel(connReg.DBdata.Database,tableStruct.Name,numReg,owner);
           showQueryResult(res,col);
           if(numReg==0)
            {
             rectangle.setEnabled(false);
             rectangle2.setEnabled(false);
             advanced.setEnabled(false);
            }
           updateUI(); 
          }    
     }
      else
        {          
     	 result = result.substring(0,result.length()-1);
         ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
         showError.pack();
         showError.setLocationRelativeTo(frame);

         showError.show();
        }
        addTextLogMonitor(idiom.getWord("RES") + result);
    }
 }

 if(e.getActionCommand().equals("ButtonUpdateRecord") )
  {
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    UpdateTable upper = new UpdateTable(tableStruct,frame,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    if(upper.wellDone)
     {
      addTextLogMonitor(idiom.getWord("EXEC")+ upper.update + "\"");
      String result = connReg.SQL_Instruction(upper.update);
      if(result.equals("OK")) 
       {
        Vector res = connReg.TableQuery("select * from " + tableStruct.Name);
        Vector col = connReg.getTableHeader();
        if(!connReg.queryFail()) 
          {
           showQueryResult(res,col);
           updateUI(); 
          }    
       }
      else
        {
      	  result = result.substring(0,result.length()-1);
          ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
          showError.pack();
          showError.setLocationRelativeTo(frame);

          showError.show();
        }
      addTextLogMonitor(idiom.getWord("RES") + result);
    }
 }

 if(e.getActionCommand().equals("ExportToReport") )
  {
   ReportDesigner format = new ReportDesigner(frame,columnas,datos,idiom,LogWin,currentTable,connReg);
  }

 if(e.getActionCommand().equals("combo1"))
  {
    JComboBox cb = (JComboBox)e.getSource();
    field = (String) cb.getSelectedItem();
    if(field == null)
     {
      field = firstField; 
      cb.setSelectedItem(field);
     }
  } 

 if(e.getActionCommand().equals("combo2"))	
  {
    JComboBox cb = (JComboBox)e.getSource();
    operator = (String) cb.getSelectedItem();
  }

 if(e.getActionCommand().equals("ItemAdvanced"))
  {
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    AdvancedFilter button = new AdvancedFilter(tableStruct,frame,idiom);
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    if(button.wellDone)
     {
      Vector res = connReg.TableQuery(button.select);
      Vector col = connReg.getTableHeader();
      addTextLogMonitor(idiom.getWord("EXEC") + button.select + "\"");
      String str = "OK";
      if(!connReg.queryFail()) 
         {
          showQueryResult(res,col);
          updateUI(); 
         }
      else 
          {
          str = connReg.getProblemString().substring(0,connReg.getProblemString().length()-1);
          ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(),idiom);
          showError.pack();
          showError.setLocationRelativeTo(frame);

          showError.show();
          }     
      addTextLogMonitor(idiom.getWord("RES") + str);
     }
 } 

 if(e.getActionCommand().equals("ItemCustomize"))
  {
    CustomizeFilter custim = new CustomizeFilter(tableStruct,frame,idiom);
    if(custim.wellDone)
     {
      Vector res = connReg.TableQuery(custim.select);
      Vector col = connReg.getTableHeader();
      String str = "OK";
      addTextLogMonitor(idiom.getWord("EXEC") + custim.select + "\"");
      if(!connReg.queryFail()) 
         {
          showQueryResult(res,col);
          updateUI(); 
         }    
      else
        {
          str = connReg.problem.substring(0,connReg.problem.length()-1);
          ErrorDialog showError = new ErrorDialog(new JDialog(),connReg.getErrorMessage(), idiom);
          showError.pack();
          showError.setLocationRelativeTo(Registers.this);
          showError.show();
        }

      addTextLogMonitor(idiom.getWord("RES") + str);
     }
  }

 if(e.getActionCommand().equals("boton"))
  {
    sentence = "SELECT * FROM " + currentTable;
    if(rectangle.isSelected()) 
     {
        String var = combo3.getText();
        //String type = tableStruct.base.getType(field);

        if(var.length()==0) 
          {
              JOptionPane.showMessageDialog(frame,                               
              idiom.getWord("ERRFIL"),                       
              idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
              return;
          }
        else 
          {
            String type = tableStruct.base.getType(field);
            int code = getTypeCode(type);
            switch(code)
               {
                 case 1:
                        if(!var.startsWith("'"))
                          var = "'" + var;

                        if(!var.endsWith("'"))
                          var = var + "'";

                        combo3.setText(var);
                        break;
                 case 2:
                        if(!isNum(var))
                          {
                           JOptionPane.showMessageDialog(frame,
                           idiom.getWord("FINTIV"),
                           idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                           return;
                          }
                        break;
                 case 3:
                        var = var.toLowerCase();
                        if(!var.equals("true") && !var.equals("false"))
                          {
                           JOptionPane.showMessageDialog(frame,
                           idiom.getWord("IBT"),
                           idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                           return;
                          }
               }

            sentence += " where " + field + " " + operator + " " + var;
          }
     }

    if(rectangle2.isSelected()) 
     {
        int fail = 0;
        boolean firstvalid = false;
        boolean secondvalid = false;
        String num = numRegTextField.getText();
        String limit = limitText.getText();
        if(num.length()>0)
         {
          if(isNum(num))
               firstvalid = true;
          else
            {
             JOptionPane.showMessageDialog(frame,                               
             idiom.getWord("ERRLIM") + " 1 " + idiom.getWord("ERRLIM2"),                       
             idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             return;
            }
         }
        else
          fail += 1;

        if(limit.length()>0) 
         {
          if(isNum(limit))
               secondvalid = true;
          else
            {
             JOptionPane.showMessageDialog(frame,                               
             idiom.getWord("ERRLIM") + " 2 " + idiom.getWord("ERRLIM2"),                       
             idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
             return;
            }
         }
        else
          fail += 1;

        if(fail==2)
             {
              JOptionPane.showMessageDialog(frame,                               
              idiom.getWord("LIMUS"),                       
              idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
              return;
      	     }
        else 
             {
              if(fail==1)
               {
                JOptionPane.showMessageDialog(frame,                               
                idiom.getWord("LIM1US"),                       
                idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                return;
               }
              else
                 if(firstvalid && secondvalid)
                  {
                   int a = Integer.parseInt(num);
                   int b = Integer.parseInt(limit);
                   if(a <= b)
                     {
                       int numrows = (b - a) + 1;
                       sentence += " LIMIT " + numrows + "," + num;
                     }
                   else
                     {
                       JOptionPane.showMessageDialog(frame,                               
                       idiom.getWord("MORELIM"),                       
                       idiom.getWord("ERROR!"),JOptionPane.ERROR_MESSAGE);
                       return;
                     }
                 }
           } 
    
     }
    sentence += ";";
    Vector res = connReg.TableQuery(sentence);
    addTextLogMonitor(idiom.getWord("EXEC") + sentence + "\"");
    Vector col = connReg.getTableHeader();
    if(!connReg.queryFail()) 
        {
         showQueryResult(res,col);
         updateUI(); 
         addTextLogMonitor(idiom.getWord("RES") + "OK");
        }
    else
        {
         String resStr = connReg.problem;
         addTextLogMonitor(idiom.getWord("ERRONRUN") + resStr.substring(0,resStr.length()-1));
        }
 }
}

 /**
  * METODO activeButtons()  
  * Activa o desactiva los botones
  */ 
 public void activeButtons(boolean value) {
   insertRecord.setEnabled(value);
   updateRecord.setEnabled(value);
   rectangle.setEnabled(value);
   rectangle2.setEnabled(value);
   boton.setEnabled(value);
 }                                                                              

 public void setLabel(String dbName,String table,int NumR,String owner)
  {
   currentTable = table;
   String mesg = "";
   if(dbName.length()>0)
    mesg =  NumR + " " + idiom.getWord("RECS") + " " + idiom.getWord("INTA") + " '" + table + "' (DB:" + dbName + " / " + idiom.getWord("OWNER") + ": " + owner + ")"; 
   else
    mesg = "No Table Selected";

    title.setText(mesg);
  }

 public void activeBox(boolean state)
  {
   rectangle.setEnabled(state);
   rectangle2.setEnabled(state);
   advanced.setEnabled(state);
  }

 public boolean updateTable(PGConnection conn, String TableN, Table structT)
  {
    String sentence = "SELECT * FROM " + TableN + ";";

    int tuples = Count(TableN,conn);

    if(tuples == -1)
      return false;

    if(tuples > 50)
      sentence = "SELECT * FROM " + TableN + " LIMIT 50;";

    connReg = conn;
    tableStruct = structT;
    currentTable = TableN;
    rectangle.setSelected(false);
    rectangle2.setSelected(false);
    combo3.setText("");
    numRegTextField.setText("");
    limitText.setText("");
    Vector result = connReg.TableQuery(sentence);
    Vector columnNames = connReg.getTableHeader();
    numReg = tuples;
    if(!connReg.queryFail()) 
      {
        String owner = connReg.getOwner(TableN);
        setLabel(connReg.DBdata.Database,TableN,tuples,owner);
        if(result.size()==0) 
            activeBox(false);
        else 
            activeBox(true);

        combo1.removeAllItems();
        firstField = "";
        for(int t=0;t<columnNames.size();t++)
         {
          String element = (String) columnNames.elementAt(t);
          combo1.insertItemAt(element, t); 
          if(t == 0)
            firstField = element; 
         }
        updateUI();
 
        showQueryResult(result,columnNames);
        insertRecord.setEnabled(true);
	if(tuples>50)
	  {
	  addTextLogMonitor(idiom.getWord("EX0"));
          addTextLogMonitor(idiom.getWord("EX1"));
	  addTextLogMonitor(idiom.getWord("EX2"));
	  }
       }
      else
        {
         rectangle.setEnabled(false);
         rectangle2.setEnabled(false);
         insertRecord.setEnabled(false);
         combo1.removeAllItems();
         combo1.insertItemAt("",0);
         showQueryResult(new Vector(),new Vector());
         title.setText(idiom.getWord("NRE"));
         ErrorDialog showError = new ErrorDialog(new JDialog(), conn.getErrorMessage(),idiom);
         showError.pack();
         showError.setLocationRelativeTo(frame);
         showError.show();
        }
   updateUI();

   return true;
   }

public void showQueryResult(Vector rowData,Vector columnNames)
{
   columnas = columnNames;
   datos = rowData;

   String[] colNames = new String[columnNames.size()];
   Object[][] rowD = new Object[rowData.size()][columnNames.size()];

   if(columnNames.size()>0)
   {
     for(int p=0;p<columnNames.size();p++)
      {
       Object o = columnNames.elementAt(p);
       colNames[p] = o.toString();
      }

     for(int p=0;p<rowData.size();p++)
     {
       Vector tempo = (Vector) rowData.elementAt(p);
       for(int j=0;j<columnNames.size();j++)
        {
         Object o = tempo.elementAt(j);
         rowD[p][j] = o;
        }
      }
    }
  if(rowData.size() > 0) 
   {
    MyTableModel myModel = new MyTableModel(rowD,colNames);
    table = new JTable(myModel);
    delRecord.setEnabled(true);
    updateRecord.setEnabled(true);
    reportBut.setEnabled(true);
   }
   else {
          delRecord.setEnabled(false);
          updateRecord.setEnabled(false);
	  reportBut.setEnabled(false);
          table = new JTable(rowData,columnNames);
        }
   if(!primera)
    remove(windowX);
   else
     primera = false;
   windowX = new JScrollPane(table);
   add(windowX,BorderLayout.CENTER);
}

 class MyTableModel extends AbstractTableModel {
     public MyTableModel(Object[][] xdata,String[] colN) 
      {
        data = xdata;
        columnNames = colN;
      }
 
  public String getColumnName(int col) 
      {
        return columnNames[col].toString();
      }

  public int getRowCount() 
      { 
        return data.length; 
      }

  public int getColumnCount() 
      { 
        return columnNames.length; 
      }

  public Object getValueAt(int row, int col) 
      {
        return data[row][col];
      }

  public boolean isCellEditable(int row, int col) 
      { 
        return false;
      }

  public void setValueAt(Object value, int row, int col) 
      {
        data[row][col] = value;
        fireTableCellUpdated(row, col); 
      }

  }

  public void setRow1(boolean state) 
   {
     combo1.setEnabled(state);  
     combo2.setEnabled(state);
     combo3.setEnabled(state);
   }

  public void setRow2(boolean state) 
   {
     numRegTextField.setEnabled(state);
     men1.setEnabled(state);
     limitText.setEnabled(state);
     men2.setEnabled(state);
   }

  class CheckBoxListener implements ItemListener 
  {
     public void itemStateChanged(ItemEvent e) {
        Object source = e.getItemSelectable();
        if (source == rectangle)
        { 
          if(rectangle.isSelected()) 
            {
             setRow1(true);
             combo1.setSelectedItem(firstField);
            }
          else
             setRow1(false);

          //combo1.setSelectedIndex(0);
          combo2.setSelectedIndex(0);
        } 
        if (source == rectangle2)
        { 
          if(rectangle2.isSelected()) 
             setRow2(true);
          else 
           {
             setRow2(false);
             numRegTextField.setText("");
             limitText.setText("");
            }

        }
    }
 }

 public boolean isNum(String word)
 { 
   for(int i=0;i<word.length();i++)
    {
      char c = word.charAt(i);
      if(!Character.isDigit(c))
        return false;
    }
   return true;
 }

 public int Count(String TableN,PGConnection konn)
  {
   int val = -1;
   String counting = "SELECT count(*) FROM " + TableN + ";";
   String answer = "OK";
   addTextLogMonitor(idiom.getWord("EXEC")+ counting + "\"");
   Vector result = new Vector();
   result = konn.TableQuery(counting);
   if(konn.queryFail())
    {
      answer = konn.getProblemString().substring(0,konn.getProblemString().length()-1);
      ErrorDialog showError = new ErrorDialog(new JDialog(),konn.getErrorMessage(),idiom);
      showError.pack();
      showError.setLocationRelativeTo(frame);
      showError.show();
    }
   else
    {
     Vector value = (Vector) result.elementAt(0);
     try {
           Long entero = (Long) value.elementAt(0);   
           val = entero.intValue();
      }
     catch(Exception ex){
            Integer entero = (Integer) value.elementAt(0);
            val = entero.intValue();
      }
    }

   addTextLogMonitor(idiom.getWord("RES") + answer);

   return val;
  }


 public int getTypeCode(String typeStr)
  {
   if(typeStr.startsWith("varchar") || typeStr.startsWith("char") || typeStr.startsWith("text") || typeStr.startsWith("name") || typeStr.startsWith("date") || typeStr.startsWith("time"))
     return 1;

   if(typeStr.startsWith("int") || typeStr.equals("serial") || typeStr.equals("smallint") || typeStr.equals("real") || typeStr.equals("double"))
     return 2;

   if(typeStr.startsWith("bool"))
     return 3;
   else
     return 4;
 }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
  public void addTextLogMonitor(String msg)
   {
    LogWin.append(msg + "\n");
    int longiT = LogWin.getDocument().getLength();
    if(longiT > 0)
        LogWin.setCaretPosition(longiT - 1);
   }

 /**
  * Metodo getNumRegs
  * Retorna el numero de registros de la tabla
  */
  public int getNumRegs()
   {
     return numReg;
   }

} // Fin de la Clase
