/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ReportMaker v 0.1                                                   
* Descripcion:
* Clase encargada de manejar el dialogo que permite visualizar,
* salvar e imprimir un reporte.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class ReportMaker {

 String pageData = "";
 HtmlProperties html;
 JTextArea LogWin; 
 Language idiom;

 public ReportMaker(Language leng,Vector nombres,Vector data,int[] posic,Vector combox,HtmlProperties prop,JTextArea lw)
  {
   html = prop;
   LogWin = lw;
   idiom = leng;
   String Data = formatter(nombres,data,posic,combox,html);
   String OS = System.getProperty("os.name");
   String path = "";
   if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
     path = System.getProperty("user.home") + System.getProperty("file.separator") + ".xpg" + System.getProperty("file.separator") + "reports" + System.getProperty("file.separator");  

   if(OS.startsWith("Windows"))
     path = System.getProperty("xpgHome") + System.getProperty("file.separator") 
            + "reports" + System.getProperty("file.separator");

   String fileName = path + "tmp-" + DateLogName(getTime()) + ".html"; 

   try {
        addTextLogMonitor(idiom.getWord("REPCR") + fileName);
        PrintStream fileLog = new PrintStream(new FileOutputStream(fileName));
        fileLog.print("<!-- " + idiom.getWord("HCRE") + " -->\n");
        fileLog.print(Data);
        fileLog.close();
       }
   catch(Exception ex) 
       {
         System.out.println("Error: " + ex);
         ex.printStackTrace();
       }

  try {
        addTextLogMonitor(idiom.getWord("OBR"));
        if(OS.equals("Linux") || OS.equals("Solaris") || OS.equals("FreeBSD"))
         try {
              Runtime.getRuntime().exec("netscape " + fileName);
             }
          catch(Exception xp) {
                 try {
                 Runtime.getRuntime().exec("mozilla" + fileName);
                     }
                   catch(Exception xp2) {
                      try {
                      Runtime.getRuntime().exec("konqueror" + fileName);
                          }
                        catch(Exception xp3) {
                           System.out.println("No Browsers Found");
                                             }
                                        }
                              }

        if(OS.startsWith("Windows"))
          try {
                Runtime.getRuntime().exec("start netscape " + fileName);
              }
           catch(Exception xp) {
                 try {
                 Runtime.getRuntime().exec("start iexplore " + fileName);
                     }
                   catch(Exception xp2) {
                       System.out.println("No Browsers Found");
                                        }
                               }
      }
    catch(Exception ex) {
                          System.out.println("Error: " + ex);
                          ex.printStackTrace();
                         } 
 }


 public String formatter(Vector columnas,Vector data,int[] posic,Vector combox,HtmlProperties prop)
 {
  boolean Results = false;
  for(int m=0;m<combox.size();m++)
   {
    String opera = (String) combox.elementAt(m);
    if(!opera.equals("0"))
     {
      Results = true;
      break;
     }
   }
  String font = "<font face=arial,helvetica size=3>";
  pageData = "<html><body bgcolor=white><br>\n";
  if(prop.HEADER.length()>0)
     pageData += "<b>" + prop.HEADER + "</b><p>";
  pageData +="<center>" + prop.TableConfig + "\n<tr>";
  for(int i=0;i<columnas.size();i++)
   { 
     String fieldName = (String) columnas.elementAt(i);
     pageData += "<td bgcolor=\"" + prop.THBackground + "\"><center>" + prop.THFontSettings + "<b>" + fieldName + "</td>\n";
   }
  int[] cuentas = new int[columnas.size()];
  for(int i=0;i<data.size();i++)
   {
    Vector row = (Vector) data.elementAt(i);
    pageData += "<tr>\n";
    for(int m=0;m<columnas.size();m++)
     {
      String value;
      String opera = (String) combox.elementAt(m);
      Object o = row.elementAt(posic[m]);
      if (o != null)
        value = o.toString();
      else
        value = "NULL";
      pageData += "<td bgcolor=\"" + prop.TCBackground + "\"><center>" + prop.TCFontSettings + value + "</td>\n";
      if(opera.equals("0"))
         cuentas[m] = -1;
      if(opera.equals("1") || opera.equals("2"))
         cuentas[m] += Integer.parseInt(value);
     }
   }

  if(Results) {
  pageData += "<tr>\n";
  for(int m=0;m<combox.size();m++)
   {
    String opera = (String) combox.elementAt(m);

    if(opera.equals("0")) 
      pageData += "<td>" + "</td>\n";

    if(opera.equals("1")) 
      pageData += "<td><center>" + font + "Total: " + cuentas[m] + "</td>\n";

    if(opera.equals("2")) 
      pageData += "<td><center>" + font + "Average: " + cuentas[m]/data.size() + "</td>\n";

   } // fin for
	      } // fin if

  pageData += "</table>";
  if(prop.FOOTER.length()>0)
     pageData += prop.FOOTER;
  pageData += "</body></html>"; 
  return pageData;
}

 /**
  * METODO DateLogName
  * Crea el nombre del archivo de logs segun la fecha
  */
  public String DateLogName(String[] val) 
  {
   String dformat = val[0] + "-" + val[1] + "-" + val[2] + "_" + val[3] + "-" + val[4];
   return dformat;
  }

 /**
  * METODO getTime
  * Retorna la hora
  */
 public String[] getTime() 
  {
   Calendar today = Calendar.getInstance();
   String[] val = new String[5];
   int monthInt = today.get(Calendar.MONTH);
   int minuteInt = today.get(Calendar.MINUTE);
   String zero = "";
   String min = "";
   if(monthInt < 10)
       zero = "0";
   if(minuteInt < 10)
       min = "0";

   val[0] = "" + today.get(Calendar.DAY_OF_MONTH);
   val[1] = zero + monthInt;
   val[2] = "" + today.get(Calendar.YEAR);
   val[3] = "" + today.get(Calendar.HOUR_OF_DAY);
   val[4] = min + today.get(Calendar.MINUTE);
   return val;
  }

 /**
  * Metodo addTextLogMonitor
  * Imprime mensajes en el Monitor de Eventos
  */
 public void addTextLogMonitor(String msg){
  LogWin.append(msg + "\n");
  int longiT = LogWin.getDocument().getLength();
  if(longiT > 0)
    LogWin.setCaretPosition(longiT - 1);
                                           }

}
