/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;
import org.postgresql.Field;
import org.postgresql.PG_Stream;
import org.postgresql.ResultSet;
import org.postgresql.core.Encoding;
import org.postgresql.core.QueryExecutor;
import org.postgresql.fastpath.Fastpath;
import org.postgresql.largeobject.LargeObjectManager;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PGobject;
import org.postgresql.util.PSQLException;
import org.postgresql.util.Serialize;
import org.postgresql.util.UnixCrypt;

public abstract class Connection {
    public PG_Stream pg_stream;
    private String PG_HOST;
    private int PG_PORT;
    private String PG_USER;
    private String PG_PASSWORD;
    private String PG_DATABASE;
    private boolean PG_STATUS;
    private String compatible;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    protected static final int PG_PROTOCOL_LATEST_MAJOR = 2;
    protected static final int PG_PROTOCOL_LATEST_MINOR = 0;
    private static final int SM_DATABASE = 64;
    private static final int SM_USER = 32;
    private static final int SM_OPTIONS = 64;
    private static final int SM_UNUSED = 64;
    private static final int SM_TTY = 64;
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private String salt;
    private static Hashtable sqlTypeCache = new Hashtable();
    private static Hashtable pgTypeCache = new Hashtable();
    private static Hashtable typeOidCache = new Hashtable();
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    public int pid;
    public int ckey;
    private Fastpath fastpath = null;
    private LargeObjectManager largeobject = null;
    private Hashtable objectTypes = new Hashtable();
    private static final String[][] defaultObjectTypes = new String[][]{{"box", "org.postgresql.geometric.PGbox"}, {"circle", "org.postgresql.geometric.PGcircle"}, {"line", "org.postgresql.geometric.PGline"}, {"lseg", "org.postgresql.geometric.PGlseg"}, {"path", "org.postgresql.geometric.PGpath"}, {"point", "org.postgresql.geometric.PGpoint"}, {"polygon", "org.postgresql.geometric.PGpolygon"}, {"money", "org.postgresql.util.PGmoney"}};

    public java.sql.ResultSet ExecSQL(String string) throws SQLException {
        return this.ExecSQL(string, null);
    }

    public java.sql.ResultSet ExecSQL(String string, Statement statement) throws SQLException {
        return new QueryExecutor(string, statement, this.pg_stream, this).execute();
    }

    public void addDataType(String string, String string2) {
        this.objectTypes.put(string, string2);
    }

    public void addWarning(String string) {
        DriverManager.println(string);
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
        } else {
            this.firstWarning = new SQLWarning(string);
        }
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void close() throws SQLException {
        if (this.pg_stream != null) {
            try {
                this.pg_stream.SendChar(88);
                this.pg_stream.flush();
                this.pg_stream.close();
            }
            catch (IOException iOException) {}
            this.pg_stream = null;
        }
    }

    public void commit() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("commit;begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("commit");
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
    }

    public abstract Statement createStatement() throws SQLException;

    private static String extractVersionNumber(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    public String getCatalog() throws SQLException {
        return this.PG_DATABASE;
    }

    public String getCursorName() throws SQLException {
        return this.cursor;
    }

    public String getDBVersionNumber() {
        return this.dbVersionNumber;
    }

    public Encoding getEncoding() throws SQLException {
        return this.encoding;
    }

    public Fastpath getFastpathAPI() throws SQLException {
        if (this.fastpath == null) {
            this.fastpath = new Fastpath(this, this.pg_stream);
        }
        return this.fastpath;
    }

    protected String getIsolationLevelSQL() throws SQLException {
        if (this.haveMinimumServerVersion("7.1")) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("SET TRANSACTION ISOLATION LEVEL");
        switch (this.isolationLevel) {
            case 2: {
                stringBuffer.append(" READ COMMITTED");
                break;
            }
            case 8: {
                stringBuffer.append(" SERIALIZABLE");
                break;
            }
            default: {
                throw new PSQLException("postgresql.con.isolevel", new Integer(this.isolationLevel));
            }
        }
        return stringBuffer.toString();
    }

    public LargeObjectManager getLargeObjectAPI() throws SQLException {
        if (this.largeobject == null) {
            this.largeobject = new LargeObjectManager(this);
        }
        return this.largeobject;
    }

    public int getOID(String string) throws SQLException {
        int n = -1;
        if (string != null) {
            Integer n2 = (Integer)typeOidCache.get(string);
            if (n2 != null) {
                n = n2;
            } else {
                ResultSet resultSet = (ResultSet)((Object)this.ExecSQL("select oid from pg_type where typname='" + string + "'"));
                if (resultSet.getColumnCount() != 1 || resultSet.getTupleCount() != 1) {
                    throw new PSQLException("postgresql.unexpected");
                }
                resultSet.next();
                n = Integer.parseInt(resultSet.getString(1));
                typeOidCache.put(string, new Integer(n));
                resultSet.close();
            }
        }
        return n;
    }

    public Object getObject(String string, String string2) throws SQLException {
        try {
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.fetch(Integer.parseInt(string2));
            }
            if (v instanceof String) {
                PGobject pGobject = null;
                pGobject = (PGobject)Class.forName((String)v).newInstance();
                pGobject.setType(string);
                pGobject.setValue(string2);
                return pGobject;
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).fetch(Integer.parseInt(string2));
            }
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.creobj", (Object)string, (Object)exception);
        }
        return null;
    }

    public String getPGType(int n) throws SQLException {
        String string = (String)pgTypeCache.get(new Integer(n));
        if (string == null) {
            this.getSQLType(n);
            string = (String)pgTypeCache.get(new Integer(n));
        }
        return string;
    }

    public abstract java.sql.ResultSet getResultSet(Connection var1, Statement var2, Field[] var3, Vector var4, String var5, int var6, long var7, boolean var9) throws SQLException;

    public int getSQLType(int n) throws SQLException {
        Integer n2 = (Integer)sqlTypeCache.get(new Integer(n));
        if (n2 == null) {
            ResultSet resultSet = (ResultSet)((Object)this.ExecSQL("select typname from pg_type where oid = " + n));
            if (resultSet.getColumnCount() != 1 || resultSet.getTupleCount() != 1) {
                throw new PSQLException("postgresql.unexpected");
            }
            resultSet.next();
            String string = resultSet.getString(1);
            Integer n3 = new Integer(n);
            n2 = new Integer(this.getSQLType(resultSet.getString(1)));
            sqlTypeCache.put(n3, n2);
            pgTypeCache.put(n3, string);
            resultSet.close();
        }
        return n2;
    }

    public abstract int getSQLType(String var1);

    public int getTransactionIsolation() throws SQLException {
        this.clearWarnings();
        this.ExecSQL("show xactisolevel");
        SQLWarning sQLWarning = this.getWarnings();
        if (sQLWarning != null) {
            String string = sQLWarning.getMessage();
            this.clearWarnings();
            if (string.indexOf("READ COMMITTED") != -1) {
                return 2;
            }
            if (string.indexOf("READ UNCOMMITTED") != -1) {
                return 1;
            }
            if (string.indexOf("REPEATABLE READ") != -1) {
                return 4;
            }
            if (string.indexOf("SERIALIZABLE") != -1) {
                return 8;
            }
        }
        return 2;
    }

    public String getURL() throws SQLException {
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        return this.PG_USER;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public boolean haveMinimumCompatibleVersion(String string) throws SQLException {
        return this.compatible.compareTo(string) >= 0;
    }

    public boolean haveMinimumServerVersion(String string) throws SQLException {
        return this.getDBVersionNumber().compareTo(string) >= 0;
    }

    private void initObjectTypes() {
        int n = 0;
        while (n < defaultObjectTypes.length) {
            this.objectTypes.put(defaultObjectTypes[n][0], defaultObjectTypes[n][1]);
            ++n;
        }
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void openConnection(String var1_1, int var2_2, Properties var3_3, String var4_4, String var5_5, Driver var6_6) throws SQLException {
        if (var3_3.getProperty("user") == null) {
            throw new PSQLException("postgresql.con.user");
        }
        this.this_driver = var6_6;
        this.this_url = var5_5;
        this.PG_DATABASE = var4_4;
        this.PG_USER = var3_3.getProperty("user");
        this.PG_PASSWORD = var3_3.getProperty("password", "");
        this.PG_PORT = var2_2;
        this.PG_HOST = var1_1;
        this.PG_STATUS = this.CONNECTION_BAD;
        this.compatible = var3_3.getProperty("compatible") == null ? String.valueOf(var6_6.getMajorVersion()) + "." + var6_6.getMinorVersion() : var3_3.getProperty("compatible");
        try {
            this.pg_stream = new PG_Stream(var1_1, var2_2);
        }
        catch (ConnectException v0) {
            throw new PSQLException("postgresql.con.refused");
        }
        catch (IOException var7_7) {
            throw new PSQLException("postgresql.con.failed", var7_7);
        }
        try {
            this.pg_stream.SendInteger(296, 4);
            this.pg_stream.SendInteger(2, 2);
            this.pg_stream.SendInteger(0, 2);
            this.pg_stream.Send(var4_4.getBytes(), 64);
            this.pg_stream.Send(this.PG_USER.getBytes(), 224);
            this.pg_stream.flush();
            var7_8 = -1;
            block25: while (true) lbl-1000:
            // 3 sources

            {
                var8_10 = this.pg_stream.ReceiveChar();
                switch (var8_10) {
                    case 69: {
                        throw new SQLException(this.pg_stream.ReceiveString(this.encoding));
                    }
                    case 82: {
                        var7_8 = this.pg_stream.ReceiveIntegerR(4);
                        if (var7_8 == 4) {
                            var9_12 /* !! */  = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String(var9_12 /* !! */ , 0, 2);
                            DriverManager.println("Crypt salt=" + this.salt);
                        }
                        if (var7_8 == 5) {
                            var9_12 /* !! */  = new byte[]{(byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar(), (byte)this.pg_stream.ReceiveChar()};
                            this.salt = new String(var9_12 /* !! */ , 0, 4);
                            DriverManager.println("MD5 salt=" + this.salt);
                        }
                        switch (var7_8) {
                            case 1: {
                                DriverManager.println("postgresql: KRB4");
                                throw new PSQLException("postgresql.con.kerb4");
                            }
                            case 2: {
                                DriverManager.println("postgresql: KRB5");
                                throw new PSQLException("postgresql.con.kerb5");
                            }
                            case 3: {
                                DriverManager.println("postgresql: PASSWORD");
                                this.pg_stream.SendInteger(5 + this.PG_PASSWORD.length(), 4);
                                this.pg_stream.Send(this.PG_PASSWORD.getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            case 4: {
                                DriverManager.println("postgresql: CRYPT");
                                var9_12 /* !! */  = (byte[])UnixCrypt.crypt(this.salt, this.PG_PASSWORD);
                                this.pg_stream.SendInteger(5 + var9_12 /* !! */ .length(), 4);
                                this.pg_stream.Send(var9_12 /* !! */ .getBytes());
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            case 5: {
                                DriverManager.println("postgresql: MD5");
                                var10_13 /* !! */  = MD5Digest.encode(this.PG_USER, this.PG_PASSWORD, this.salt);
                                this.pg_stream.SendInteger(5 + var10_13 /* !! */ .length, 4);
                                this.pg_stream.Send(var10_13 /* !! */ );
                                this.pg_stream.SendInteger(0, 1);
                                this.pg_stream.flush();
                                ** break;
                            }
                            default: {
                                throw new PSQLException("postgresql.con.auth", new Integer(var7_8));
                            }
                            case 0: {
                                if (var7_8 != 0) continue block25;
                            }
                        }
                    }
                    default: {
                        throw new PSQLException("postgresql.con.authfail");
                    }
                }
lbl78:
                // 3 sources

                if (var7_8 != 0) ** GOTO lbl-1000
                break;
            }
        }
        catch (IOException var7_9) {
            throw new PSQLException("postgresql.con.failed", var7_9);
        }
        var7_8 = this.pg_stream.ReceiveChar();
        switch (var7_8) {
            case 75: {
                this.pid = this.pg_stream.ReceiveInteger(4);
                this.ckey = this.pg_stream.ReceiveInteger(4);
                break;
            }
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.encoding));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
        }
        var7_8 = this.pg_stream.ReceiveChar();
        switch (var7_8) {
            case 69: 
            case 78: {
                throw new SQLException(this.pg_stream.ReceiveString(this.encoding));
            }
            default: {
                throw new PSQLException("postgresql.con.setup");
            }
            case 90: 
        }
        this.firstWarning = null;
        var8_11 = "case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end";
        var9_12 /* !! */  = this.ExecSQL("set datestyle to 'ISO'; select version(), case when pg_encoding_to_char(1) = 'SQL_ASCII' then 'UNKNOWN' else getdatabaseencoding() end;");
        if (!var9_12 /* !! */ .next()) {
            throw new PSQLException("postgresql.con.failed", (Object)"failed getting backend encoding");
        }
        var10_13 /* !! */  = (byte[])var9_12 /* !! */ .getString(1);
        this.dbVersionNumber = Connection.extractVersionNumber((String)var10_13 /* !! */ );
        var11_14 = var9_12 /* !! */ .getString(2);
        this.encoding = Encoding.getEncoding(var11_14, var3_3.getProperty("charSet"));
        this.initObjectTypes();
        this.firstWarning = null;
        this.PG_STATUS = this.CONNECTION_OK;
    }

    public int putObject(Object object) throws SQLException {
        return (int)this.storeObject(object);
    }

    public void rollback() throws SQLException {
        if (this.autoCommit) {
            return;
        }
        if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("rollback; begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("rollback");
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.autoCommit == bl) {
            return;
        }
        if (bl) {
            this.ExecSQL("end");
        } else if (this.haveMinimumServerVersion("7.1")) {
            this.ExecSQL("begin;" + this.getIsolationLevelSQL());
        } else {
            this.ExecSQL("begin");
            this.ExecSQL(this.getIsolationLevelSQL());
        }
        this.autoCommit = bl;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        this.cursor = string;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        String string;
        this.isolationLevel = n;
        if (!this.haveMinimumServerVersion("7.1")) {
            string = this.getIsolationLevelSQL();
        } else {
            string = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL ";
            switch (this.isolationLevel) {
                case 2: {
                    string = String.valueOf(string) + "READ COMMITTED";
                    break;
                }
                case 8: {
                    string = String.valueOf(string) + "SERIALIZABLE";
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.con.isolevel", new Integer(this.isolationLevel));
                }
            }
        }
        this.ExecSQL(string);
    }

    public long storeObject(Object object) throws SQLException {
        try {
            String string = object.getClass().getName();
            Object v = this.objectTypes.get(string);
            if (v == null) {
                Serialize serialize = new Serialize(this, string);
                this.objectTypes.put(string, serialize);
                return serialize.storeObject(object);
            }
            if (v instanceof Serialize) {
                return ((Serialize)v).storeObject(object);
            }
            throw new PSQLException("postgresql.con.strobj");
        }
        catch (SQLException sQLException) {
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (Exception exception) {
            throw new PSQLException("postgresql.con.strobjex", exception);
        }
    }
}

