#!/bin/bash

echo "starting.."
echo

# check user
if [ `id -u` -ne 0 ];then
	echo 'This command in only executed by root'
    exit 1
fi

echo "recommend you to start bulkloading with the postmaster option \"-F\"."
echo

PWD=`pwd`

echo "input directory name or file name"
read TRG
echo

echo " list of loading files "
echo "-----------------------"
echo `ls -sh1 ${TRG} | grep "\.xml$"`
echo

echo "input database name in roman"
read DBNAME
echo

echo "input database username"
read USER
echo

echo "input the user password"
read PASS
echo

echo "enables strip_space ? (Get detail on XSLT reference page)"
select input in true false
do
	case $input in
	    true)
	        SPACES="-s"
			break
			;;
	    false)
	        SPACES=""
	        break
	        ;;
	    *)
	        echo 'input argument is invalid'
	        echo 'please choose'
	        ;;
	esac
done

TRGLIST=`find ${TRG} | grep "\.xml$"`

echo "preparing for bulkloading..."
su - postgres -c "psql ${DBNAME} < ${PWD}/before.sql"
echo

for i in ${TRGLIST}
do
	echo "now loading..." ${i}
	./pgxload -u ${USER} -p ${PASS} -d ${DBNAME} ${SPACES} ${i}
	echo "done"
done

echo "preparing for finishing..."
su - postgres -c "psql ${DBNAME} < ${PWD}/after.sql"
echo

echo "finish!"

