<?php

require_once('DB.php');

/**
* DB access manager class.
*
* Usage:
*  you should use as follows,
*  	$DBA =& DBAccess::getInstance();
*  else, $DBA is a copy of the newed object.
*
* @author Makoto Yui <yuin@bb.din.or.jp>
*/
class DBAccess {
	var $conn;
	
	function DBAccess($dsn=ENV_DSN){
		$GLOBALS['logger']->log('entering DBAccess()', PEAR_LOG_DEBUG);
		static $isConn_;
		$this->conn = &$idConn_;	// copy reference.
		
		if($this->conn == NULL)
		{
			$this->conn = DB::connect($dsn);
			/* 
			 * regist as deconstructor
			 * 
			 * this way can also considerble.
			 * 	$obj = new object();
			 * 	register_shutdown_function(array(&$obj,'shutdown')); 
             */
            if(DB::isError($this->conn))
            	die ($this->conn->getMessage());
            else
				register_shutdown_function(array(&$this, 'close'));
		}
		
		if(ENV_DEBUG && $this->conn == NULL)
			die('ͥ󤬳ΩǤޤǤ');
	
		if(DB::isError($this->conn))
			die ($this->conn->getMessage());
	}
	
	function getInstance(){
		$GLOBALS['logger']->log('entering getInstance()', PEAR_LOG_DEBUG);
		$_instance = new DBAccess();
		return $_instance->conn;
	}
	
	function close(){
		if($this->conn)
		{
			$this->conn->disconnect();
			$this->conn = null;
		}
	}

	/**
	* Get connection object
	*
	* @access private
	*/
	function getConnection(){
		return $this->conn;
	}
}



?>