--
-- PostgreSQL database dump
--

SET client_encoding = 'LATIN1';
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: new_customer(character varying, character varying, character varying, character varying, character varying, character varying, integer, character varying, integer, character varying, character varying, integer, character varying, character varying, character varying, character varying, integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: chriskl
--

CREATE FUNCTION new_customer(firstname_in character varying, lastname_in character varying, address1_in character varying, address2_in character varying, city_in character varying, state_in character varying, zip_in integer, country_in character varying, region_in integer, email_in character varying, phone_in character varying, creditcardtype_in integer, creditcard_in character varying, creditcardexpiration_in character varying, username_in character varying, password_in character varying, age_in integer, income_in integer, gender_in character varying, OUT customerid_out integer) RETURNS integer
    AS '
  DECLARE
    rows_returned INT;
  BEGIN
    SELECT COUNT(*) INTO rows_returned FROM CUSTOMERS WHERE USERNAME = username_in;
    IF rows_returned = 0 THEN
	    INSERT INTO CUSTOMERS
	      (
	      FIRSTNAME,
	      LASTNAME,
	      EMAIL,
	      PHONE,
	      USERNAME,
	      PASSWORD,
	      ADDRESS1,
	      ADDRESS2,
	      CITY,
	      STATE,
	      ZIP,
	      COUNTRY,
	      REGION,
	      CREDITCARDTYPE,
	      CREDITCARD,
	      CREDITCARDEXPIRATION,
	      AGE,
	      INCOME,
	      GENDER
	      )
	    VALUES
	      (
	      firstname_in,
	      lastname_in,
	      email_in,
	      phone_in,
	      username_in,
	      password_in,
	      address1_in,
	      address2_in,
	      city_in,
	      state_in,
	      zip_in,
	      country_in,
	      region_in,
	      creditcardtype_in,
	      creditcard_in,
	      creditcardexpiration_in,
	      age_in,
	      income_in,
	      gender_in
	      )
	     ;
    select currval(pg_get_serial_sequence(''customers'', ''customerid'')) into customerid_out;
  ELSE 
  	customerid_out := 0;
  END IF;
END
'
    LANGUAGE plpgsql;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: categories; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE categories (
    category serial NOT NULL,
    categoryname character varying(50) NOT NULL
);


--
-- Name: categories_category_seq; Type: SEQUENCE SET; Schema: public; Owner: chriskl
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('categories', 'category'), 16, true);


--
-- Name: cust_hist; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE cust_hist (
    customerid integer NOT NULL,
    orderid integer NOT NULL,
    prod_id integer NOT NULL
);


--
-- Name: customers; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE customers (
    customerid serial NOT NULL,
    firstname character varying(50) NOT NULL,
    lastname character varying(50) NOT NULL,
    address1 character varying(50) NOT NULL,
    address2 character varying(50),
    city character varying(50) NOT NULL,
    state character varying(50),
    zip integer,
    country character varying(50) NOT NULL,
    region smallint NOT NULL,
    email character varying(50),
    phone character varying(50),
    creditcardtype integer NOT NULL,
    creditcard character varying(50) NOT NULL,
    creditcardexpiration character varying(50) NOT NULL,
    username character varying(50) NOT NULL,
    "password" character varying(50) NOT NULL,
    age smallint,
    income integer,
    gender character varying(1)
);


--
-- Name: customers_customerid_seq; Type: SEQUENCE SET; Schema: public; Owner: chriskl
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('customers', 'customerid'), 20000, true);


--
-- Name: inventory; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE inventory (
    prod_id integer NOT NULL,
    quan_in_stock integer NOT NULL,
    sales integer NOT NULL
);


--
-- Name: orderlines; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE orderlines (
    orderlineid integer NOT NULL,
    orderid integer NOT NULL,
    prod_id integer NOT NULL,
    quantity smallint NOT NULL,
    orderdate date NOT NULL
);


--
-- Name: orders; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE orders (
    orderid serial NOT NULL,
    orderdate date NOT NULL,
    customerid integer,
    netamount numeric(12,2) NOT NULL,
    tax numeric(12,2) NOT NULL,
    totalamount numeric(12,2) NOT NULL
);


--
-- Name: orders_orderid_seq; Type: SEQUENCE SET; Schema: public; Owner: chriskl
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('orders', 'orderid'), 12000, true);


--
-- Name: products; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE products (
    prod_id serial NOT NULL,
    category integer NOT NULL,
    title character varying(50) NOT NULL,
    actor character varying(50) NOT NULL,
    price numeric(12,2) NOT NULL,
    special smallint,
    common_prod_id integer NOT NULL
);


--
-- Name: products_prod_id_seq; Type: SEQUENCE SET; Schema: public; Owner: chriskl
--

SELECT pg_catalog.setval(pg_catalog.pg_get_serial_sequence('products', 'prod_id'), 10000, true);


--
-- Name: reorder; Type: TABLE; Schema: public; Owner: chriskl; Tablespace: 
--

CREATE TABLE reorder (
    prod_id integer NOT NULL,
    date_low date NOT NULL,
    quan_low integer NOT NULL,
    date_reordered date,
    quan_reordered integer,
    date_expected date
);


--
-- Data for Name: categories; Type: TABLE DATA; Schema: public; Owner: chriskl
--

COPY categories (category, categoryname) FROM stdin;
1	Action
2	Animation
3	Children
4	Classics
5	Comedy
6	Documentary
7	Drama
8	Family
9	Foreign
10	Games
11	Horror
12	Music
13	New
14	Sci-Fi
15	Sports
16	Travel
\.


--
-- Data for Name: cust_hist; Type: TABLE DATA; Schema: public; Owner: chriskl
--

COPY cust_hist (customerid, orderid, prod_id) FROM stdin;
7888	1	9117
7888	1	3353
7888	1	2778
7888	1	4774
7888	1	3648
7888	1	9523
7888	1	6358
7888	1	1417
4858	2	1567
4858	2	1298
4858	2	9990
4858	2	5130
4858	2	6127
4858	2	6376
4858	2	4936
4858	2	2926
15399	3	2834
15399	3	8078
15399	3	698
15399	3	5260
15399	3	1923
15399	3	8903
15399	3	642
15399	3	4578
15399	3	2383
17019	4	3753
17019	4	5126
17019	4	5317
17019	4	4377
17019	4	9309
14771	5	6879
14771	5	4402
14771	5	8293
14771	5	2290
13734	6	6574
13734	6	4396
13734	6	3985
13734	6	6843
13734	6	4825
13734	6	9503
17622	7	6196
17622	7	7861
17622	7	4471
17622	7	1876
8331	8	1032
8331	8	4955
8331	8	9848
8331	8	6845
8331	8	7498
8331	8	2942
8331	8	5845
8331	8	1524
8331	8	1255
14902	9	526
14902	9	1763
14902	9	7978
14902	9	6566
14902	9	6395
14902	9	935
14902	9	5203
14902	9	700
14902	9	4615
15112	10	10000
15112	10	8900
1082	11	42
3608	12	9131
3608	12	3591
3608	12	5795
3608	12	6874
15146	13	5770
15146	13	7479
15146	13	355
15146	13	8333
15146	13	8733
15146	13	9795
15146	13	9034
15146	13	6669
15146	13	1640
1540	14	6295
1540	14	7007
1540	14	3288
12662	15	5107
12662	15	2801
12662	15	7193
12662	15	4715
12662	15	9444
12662	15	3364
65	16	8333
65	16	6755
65	16	4820
65	16	7121
65	16	6219
65	16	4140
12753	17	6092
12753	17	7308
4045	18	6532
4045	18	5325
4045	18	2605
4045	18	6862
4045	18	1113
4045	18	5767
4045	18	6666
5768	19	9844
5768	19	8274
8730	20	7649
8730	20	1212
8730	20	3839
8730	20	9431
8730	20	8620
8730	20	7937
8730	20	2973
8730	20	9097
8730	20	4982
5479	21	4637
5479	21	4960
5479	21	1805
5479	21	7276
5479	21	6032
14486	22	4986
14486	22	1383
18638	23	8369
18638	23	4961
18638	23	3944
18638	23	6089
18638	23	1513
18638	23	1079
5766	24	4274
5310	25	4875
5310	25	8831
5310	25	5178
5310	25	5576
5310	25	8300
5310	25	2444
5310	25	7294
6765	26	4108
6765	26	7833
2294	27	492
2294	27	9865
2294	27	2109
2294	27	8652
2294	27	996
2294	27	3018
2294	27	8091
1069	28	6921
1069	28	1192
1069	28	5787
1069	28	5951
1069	28	3043
1069	28	4766
1069	28	6098
1069	28	6190
16597	29	9238
4510	30	3572
4510	30	3443
4510	30	6592
15566	31	3082
15566	31	1981
15566	31	1098
15566	31	7823
15566	31	2004
15566	31	3157
15566	31	2310
15566	31	5329
292	32	3055
292	32	2605
292	32	5524
292	32	6860
6240	33	5330
12854	34	3622
12854	34	8019
12854	34	1529
12854	34	636
12380	35	12
12380	35	3053
12380	35	6554
12380	35	1812
12380	35	6674
12380	35	6534
3726	36	8290
3726	36	9042
3726	36	3946
3726	36	8690
3726	36	7390
18532	37	4945
18532	37	9392
18532	37	8142
18532	37	6573
18532	37	9359
18532	37	8744
18532	37	6378
18532	37	7755
18532	37	2628
3340	38	8731
3340	38	4125
3340	38	5969
3340	38	5386
3340	38	5791
3340	38	7010
3340	38	8327
3340	38	1127
970	39	6377
970	39	1440
970	39	2471
970	39	175
16259	40	4774
16259	40	588
16259	40	6408
16259	40	2227
16259	40	6303
9258	41	9527
9258	41	8991
9258	41	3336
9258	41	2192
9258	41	9499
9258	41	8844
9258	41	1838
9258	41	7803
5152	42	3319
5152	42	5608
5152	42	6222
5152	42	4780
5152	42	6539
5152	42	2107
5152	42	8655
5152	42	3736
5152	42	6466
11927	43	5637
11927	43	190
11927	43	91
11927	43	6015
11927	43	8872
11927	43	1731
15905	44	1554
15905	44	8823
15905	44	8995
15905	44	4759
15905	44	9467
15905	44	8657
15905	44	7187
15905	44	1841
15905	44	1672
3525	45	9470
3525	45	1609
3525	45	4619
2018	46	3938
5864	47	5662
5864	47	348
5864	47	8140
5864	47	3564
5864	47	357
5864	47	2010
5864	47	6998
5864	47	8894
5864	47	3415
16067	48	9042
16067	48	7525
16067	48	8094
16067	48	5912
16067	48	1015
16067	48	2442
16067	48	5892
18911	49	4691
18911	49	5871
18911	49	5846
18911	49	8156
18911	49	5266
18911	49	7294
18911	49	2642
18911	49	5382
18911	49	9316
10453	50	6800
10453	50	4434
10453	50	7032
15185	51	162
15185	51	8525
15185	51	3215
15185	51	5269
15185	51	2503
15185	51	733
15185	51	8899
16427	52	3440
16427	52	440
16427	52	51
16427	52	2929
16427	52	8202
16427	52	4675
16427	52	1910
868	53	7114
868	53	929
868	53	8675
15146	54	5787
18452	55	9465
18452	55	2749
18452	55	8098
18452	55	7468
18452	55	1734
18452	55	7609
18452	55	9812
18452	55	3416
8688	56	6005
8688	56	813
8688	56	1370
17614	57	6684
17614	57	3124
2442	58	3993
2442	58	4527
2442	58	3083
2442	58	55
2442	58	1263
15606	59	9103
15606	59	627
15606	59	5271
15606	59	9279
15606	59	3880
15606	59	6385
15606	59	5395
11554	60	7893
11554	60	3819
7747	61	8493
7747	61	7145
7747	61	5162
7747	61	5025
7747	61	6719
7747	61	7560
7747	61	1391
7747	61	1959
7747	61	8443
13335	62	8885
5407	63	6577
5407	63	2220
5407	63	7785
5893	64	8735
5893	64	6740
5893	64	8326
5893	64	7734
5893	64	5905
5893	64	7638
1536	65	1790
1536	65	4431
2014	66	6077
2014	66	8058
2014	66	3988
2014	66	3943
2014	66	5997
2014	66	9016
2014	66	8813
2014	66	4607
4489	67	3012
4489	67	7495
4489	67	4859
4489	67	8589
4489	67	2932
4489	67	29
16173	68	1755
16173	68	9598
16173	68	1130
16173	68	2073
16173	68	5362
16173	68	4659
16173	68	8924
3870	69	6737
3870	69	3472
12808	70	5412
12808	70	2687
12808	70	6934
12808	70	2364
12808	70	2192
8529	71	944
19733	72	1802
19733	72	4390
19733	72	6831
2807	73	6005
17382	74	3132
17382	74	4557
17382	74	7451
17382	74	9588
17382	74	206
17382	74	8979
17382	74	398
17382	74	1839
12456	75	4090
12456	75	6019
12456	75	5634
12456	75	8033
12456	75	714
7691	76	9169
7691	76	9009
7691	76	1918
7691	76	9287
7691	76	8210
7691	76	5088
7691	76	1883
7691	76	6276
7691	76	7487
7011	77	5528
7011	77	9578
7011	77	6379
19921	78	993
19921	78	8011
19921	78	1861
19921	78	3808
19921	78	6981
19921	78	117
19921	78	1768
19921	78	1483
19921	78	6757
10955	79	2230
10955	79	4527
10955	79	5458
10955	79	8569
10955	79	3867
10955	79	1742
10955	79	2472
10955	79	9174
12310	80	5019
12310	80	180
12310	80	6195
12310	80	5202
13507	81	7883
13507	81	3252
13507	81	6380
13507	81	2436
13507	81	1382
7706	82	132
7706	82	7452
4940	83	8971
4940	83	2355
4940	83	7395
4940	83	925
4940	83	9413
5329	84	4485
5329	84	3026
5329	84	8760
13076	85	7988
13076	85	5156
13076	85	6367
13076	85	8642
13076	85	5843
13076	85	9509
13076	85	5765
13076	85	7872
13076	85	9242
2777	86	5972
2777	86	8192
2777	86	5228
3345	87	5570
3345	87	2480
3345	87	317
3345	87	7273
3345	87	2118
3345	87	9397
3345	87	7216
3345	87	3060
3345	87	1542
17189	88	8674
17189	88	8547
17189	88	9328
17189	88	5573
2284	89	3078
2284	89	2671
9578	90	2672
9578	90	3141
9578	90	804
9578	90	6633
9578	90	3277
9578	90	2465
2023	91	826
19791	92	1445
19791	92	8008
19791	92	5993
19791	92	8905
19791	92	356
19791	92	7473
19791	92	7307
7879	93	3799
7879	93	3404
18507	94	677
18507	94	1123
5134	95	6683
5134	95	3554
5134	95	8002
5134	95	7162
5134	95	7405
5134	95	3750
5134	95	8409
5134	95	7036
5134	95	65
931	96	1692
931	96	6336
931	96	3610
4986	97	7370
4986	97	7650
9623	98	9281
9623	98	6918
7907	99	4393
7907	99	5798
7907	99	142
7907	99	4453
7907	99	304
11368	100	7747
10792	101	208
10792	101	5632
10792	101	8731
10792	101	7176
14140	102	4248
8779	103	866
8779	103	7493
8779	103	8606
8779	103	5084
8779	103	5970
8779	103	1749
8779	103	9745
8779	103	3401
8779	103	1443
17236	104	5688
17236	104	5323
17236	104	592
17236	104	4325
10381	105	9932
10381	105	5271
10381	105	1091
10381	105	464
10381	105	503
10381	105	4795
10381	105	5586
7022	106	7939
7022	106	7627
16437	107	1429
16437	107	9993
16437	107	517
16437	107	2300
16437	107	4939
10804	108	5611
10804	108	1433
10804	108	7262
10804	108	4707
10804	108	9631
10804	108	2659
10804	108	5907
18937	109	2762
18937	109	4467
18937	109	7854
18937	109	9066
18937	109	157
18937	109	8194
18937	109	3622
10107	110	2520
10107	110	6789
10107	110	2353
10107	110	9409
10107	110	2583
1041	111	8451
12608	112	9096
12608	112	8924
12608	112	9567
13955	113	1651
13955	113	5801
13955	113	2269
13955	113	7886
13955	113	6412
13955	113	6561
16702	114	4607
16702	114	5743
16702	114	1225
16702	114	808
16702	114	2127
16702	114	2693
16702	114	7352
16702	114	9314
16702	114	408
5352	115	4353
5352	115	5795
5352	115	3818
5352	115	9264
5352	115	6223
3929	116	6802
3929	116	8212
3929	116	2681
3929	116	2148
3929	116	1194
3929	116	9034
3929	116	6576
3929	116	4278
17259	117	9543
17259	117	4380
17259	117	1784
17259	117	2677
17259	117	2566
17259	117	6685
17259	117	6482
18326	118	9195
16458	119	4704
16458	119	8323
16458	119	1501
16458	119	4101
16458	119	1182
16458	119	9850
16458	119	9082
16458	119	1586
16542	120	3167
16542	120	2345
16542	120	9754
3318	121	140
3318	121	7427
3318	121	976
3318	121	6305
3318	121	9971
19640	122	2346
19640	122	4284
19640	122	307
6946	123	2440
6946	123	6111
6946	123	6021
6946	123	2954
6946	123	351
2652	124	6402
19913	125	2593
19913	125	897
19913	125	488
19913	125	2173
19913	125	4676
19913	125	7287
19913	125	1143
19913	125	5514
16933	126	8846
16933	126	952
16933	126	8868
16933	126	7430
16933	126	7310
16933	126	6139
16933	126	7968
16933	126	6778
16933	126	8237
5824	127	27
5824	127	1854
5824	127	4036
5824	127	4006
5824	127	757
5824	127	5300
5824	127	1003
5824	127	9062
12742	128	6273
12742	128	4618
12742	128	1381
12742	128	2000
12742	128	5766
12742	128	1008
12742	128	4604
17278	129	5996
17278	129	8188
17278	129	6456
17278	129	5463
17278	129	7622
5159	130	5505
5159	130	1209
5159	130	1961
5159	130	9437
5159	130	938
5159	130	3519
5159	130	3305
5159	130	4180
351	131	1471
351	131	7563
351	131	4014
351	131	3841
351	131	7764
351	131	4060
351	131	7438
351	131	155
19182	132	35
19182	132	4955
19182	132	5493
19182	132	634
19182	132	9309
19182	132	4051
19182	132	1173
19182	132	7713
19182	132	6798
9124	133	7831
9124	133	413
9124	133	6721
9124	133	7576
9124	133	8302
6511	134	2389
6511	134	5660
6511	134	4259
6511	134	2477
6511	134	1325
6511	134	618
6511	134	1743
6511	134	2684
6511	134	6849
14524	135	6150
14524	135	9513
14524	135	3685
14524	135	7706
14524	135	3983
14524	135	6217
952	136	5908
952	136	4459
952	136	8799
952	136	8229
10156	137	2340
10156	137	2441
10156	137	6569
10156	137	2940
10156	137	5955
10156	137	4888
10156	137	741
5066	138	6802
5066	138	9611
5066	138	4013
5066	138	7461
5066	138	9892
5066	138	7320
5066	138	2061
5066	138	2383
5066	138	8148
2176	139	1734
2176	139	2348
2176	139	5197
13554	140	4265
13554	140	3070
1060	141	5817
1060	141	659
1060	141	7497
1060	141	2379
1060	141	1992
1060	141	6733
1060	141	1243
1060	141	5289
971	142	7262
971	142	7757
971	142	6848
971	142	9804
971	142	1356
971	142	4499
10315	143	8198
10315	143	1302
10315	143	6262
10315	143	1387
10315	143	6501
10315	143	1093
13220	144	2987
13220	144	5949
13220	144	1972
13220	144	5563
123	145	5219
123	145	9891
123	145	2977
123	145	3607
9986	146	1669
9986	146	3169
9986	146	4444
9986	146	3253
9986	146	7705
9986	146	7266
5657	147	2890
16216	148	1525
16216	148	6344
16216	148	1266
16216	148	124
16216	148	1298
8933	149	1025
17457	150	8405
17457	150	7810
17457	150	9054
17457	150	4909
17457	150	8808
663	151	5462
663	151	1379
663	151	5261
663	151	7377
663	151	7143
663	151	1387
18206	152	4085
18206	152	2970
18206	152	6707
18206	152	2594
18206	152	6338
11606	153	1612
11606	153	8817
8154	154	5179
13131	155	5669
19505	156	1647
19505	156	9958
19505	156	1491
19505	156	5641
19505	156	2098
19505	156	8628
19505	156	4567
19505	156	6699
4730	157	5174
4730	157	3265
4730	157	5674
4730	157	4019
4730	157	8685
4730	157	8572
4730	157	7064
17109	158	5620
8495	159	1692
8495	159	9496
13993	160	2648
13993	160	1016
13993	160	2109
13993	160	8959
13993	160	2223
18573	161	7841
18573	161	5906
18573	161	7803
18573	161	7707
18573	161	5640
18573	161	5761
10908	162	321
10908	162	5697
10908	162	3100
4117	163	9588
4117	163	7878
4117	163	5415
4117	163	6529
4117	163	9178
4117	163	4809
4117	163	2764
4117	163	6282
17784	164	1413
17784	164	2493
17784	164	5633
17784	164	4913
17784	164	7651
17784	164	593
17784	164	3230
17289	165	9965
17289	165	3745
17289	165	250
17289	165	5222
17289	165	5032
17289	165	5423
17289	165	8518
17289	165	3307
17289	165	3943
17710	166	2364
17710	166	1492
17710	166	5
17710	166	4238
8405	167	8976
8405	167	4042
8405	167	4337
8405	167	5001
8405	167	8082
8405	167	6594
8405	167	4530
2265	168	5386
2265	168	2802
5612	169	6998
5612	169	5789
9528	170	8961
9528	170	5692
9528	170	6457
9528	170	7480
9528	170	5163
9528	170	3588
5957	171	4734
5957	171	5404
5957	171	2366
5957	171	3668
5957	171	1703
5957	171	3918
5957	171	4220
5957	171	900
13183	172	365
13183	172	2484
13183	172	6629
13183	172	1017
13183	172	9050
13183	172	8296
13183	172	7334
13183	172	5865
13183	172	358
4120	173	6340
4120	173	9259
4120	173	6389
7059	174	8150
7059	174	9722
7059	174	223
7059	174	4548
5688	175	6543
5688	175	5544
5688	175	8454
5688	175	8961
5688	175	7585
5688	175	651
14079	176	569
14079	176	565
14079	176	4897
14079	176	3498
14079	176	1025
14079	176	4392
14895	177	6368
14895	177	4333
14895	177	5532
14895	177	2264
14895	177	8594
14895	177	9960
14895	177	9953
1044	178	9241
1044	178	8354
1044	178	9798
1044	178	783
1044	178	8916
1044	178	1637
1044	178	9103
1044	178	5223
1509	179	3871
1509	179	8003
1509	179	6454
1509	179	2866
1509	179	8478
15435	180	455
2474	181	2908
2474	181	2968
2474	181	954
2474	181	5446
2474	181	8944
2474	181	8868
2474	181	7495
2474	181	6644
19018	182	2157
19018	182	1020
19018	182	305
119	183	8730
119	183	867
119	183	7630
119	183	9887
119	183	5600
119	183	5249
119	183	1645
119	183	1337
12324	184	9464
12324	184	4525
12324	184	9435
12324	184	1958
12324	184	4888
7233	185	5313
7233	185	6645
7233	185	993
7233	185	4029
7233	185	6710
16093	186	4208
16093	186	273
16093	186	1709
16093	186	4156
16093	186	9626
16093	186	7184
2282	187	5965
5219	188	4853
5219	188	6221
5219	188	8342
5219	188	9609
5219	188	882
5219	188	4058
5219	188	7489
5219	188	5952
5219	188	6910
8185	189	5233
8185	189	9607
8185	189	1660
8185	189	3807
8185	189	8572
8185	189	2969
8185	189	222
8185	189	9997
1756	190	2032
1756	190	3435
1756	190	2779
1756	190	3560
1756	190	4436
1756	190	9074
1756	190	1866
7051	191	3825
7051	191	3333
7051	191	636
7051	191	8103
7051	191	3385
14063	192	8167
14063	192	1526
14063	192	3161
14063	192	1481
1108	193	9234
13013	194	2351
13013	194	4741
13013	194	9691
13013	194	3619
13013	194	4558
13013	194	107
13013	194	8672
13013	194	6757
19836	195	7515
9560	196	2912
11433	197	1854
11433	197	2330
11433	197	4266
11433	197	4619
11433	197	1078
11433	197	2762
11433	197	2998
11433	197	9946
11433	197	9437
13901	198	1731
13901	198	4654
13901	198	2585
13901	198	359
4424	199	3756
4424	199	9268
4424	199	3776
13076	200	6057
13076	200	8314
13076	200	5265
13076	200	2443
13076	200	5396
13076	200	8354
1876	201	204
1876	201	1386
1876	201	6005
1876	201	5846
1876	201	3516
1876	201	5618
1876	201	6159
1876	201	2713
1876	201	5750
2028	202	5518
7742	203	4809
7742	203	2313
7742	203	2081
16170	204	3358
16170	204	1370
15058	205	9744
15058	205	2709
9924	206	2612
9924	206	836
9924	206	5065
9924	206	9705
9924	206	656
9924	206	1076
9924	206	9870
6453	207	2201
6453	207	7206
6453	207	2921
6453	207	7320
6453	207	4402
6453	207	591
6453	207	5733
6453	207	3930
6453	207	3512
6431	208	5000
6431	208	9428
6431	208	7361
19260	209	868
7578	210	9418
7578	210	3269
7578	210	7974
7578	210	3210
7578	210	5570
15564	211	650
15564	211	4716
15564	211	9804
15564	211	7813
15564	211	1707
15564	211	8195
15564	211	9843
2822	212	7381
2822	212	5788
2822	212	2145
2822	212	7257
2822	212	5718
2822	212	5496
12290	213	6223
8069	214	9259
8069	214	6497
8069	214	1860
8069	214	513
15785	215	3246
15785	215	3424
15785	215	4739
15785	215	8657
8160	216	4219
8160	216	5773
8160	216	6635
8160	216	356
8160	216	547
4814	217	4143
4814	217	3400
4814	217	2777
4814	217	6047
4814	217	7148
11609	218	9884
8205	219	537
8205	219	5349
11791	220	8302
11791	220	3027
11791	220	5804
11791	220	1467
11791	220	3071
11791	220	4780
11791	220	8298
18631	221	6712
18631	221	9
18631	221	7054
18631	221	3339
18631	221	1437
18631	221	8298
13199	222	9044
13199	222	2834
13199	222	1018
13199	222	8023
13199	222	6122
13199	222	5917
12340	223	1937
12340	223	9055
12340	223	8603
78	224	9219
78	224	6289
78	224	8046
78	224	8290
78	224	5842
78	224	6783
78	224	5105
78	224	185
78	224	5048
6196	225	1156
6196	225	8118
6196	225	9615
6196	225	9797
6196	225	9199
6196	225	9508
6196	225	4868
6196	225	819
6196	225	8434
10432	226	8121
10432	226	8589
10432	226	6528
10432	226	6266
10432	226	4906
10432	226	1916
10432	226	7180
13953	227	5992
13953	227	7218
16074	228	4697
16074	228	111
16074	228	4049
16074	228	5929
16074	228	1399
15328	229	5086
15328	229	6346
15328	229	595
19989	230	8902
19989	230	6091
19989	230	5864
19989	230	257
19989	230	6587
1271	231	3273
1271	231	4166
2634	232	383
2634	232	5009
2634	232	235
1686	233	8670
1686	233	5236
1686	233	5680
1686	233	5093
1686	233	5859
1686	233	2902
1686	233	2582
1686	233	4451
1686	233	7864
5751	234	4233
5751	234	9424
5751	234	4113
5751	234	5310
5751	234	268
5751	234	9168
5751	234	8511
5751	234	995
13707	235	1309
11518	236	7868
11518	236	6926
11518	236	317
11518	236	2584
13392	237	291
18916	238	4305
18916	238	7027
18916	238	3755
18916	238	1430
15234	239	1667
15234	239	4235
15234	239	1411
7989	240	691
7989	240	6308
7989	240	4831
7989	240	439
7989	240	4644
3340	241	3173
3340	241	6455
14552	242	5966
14552	242	5464
14552	242	2884
14552	242	1370
14552	242	588
14552	242	1603
14552	242	3041
6958	243	8221
6958	243	4430
6958	243	6201
5311	244	9932
5311	244	4044
5311	244	1762
5311	244	3272
5311	244	4721
5311	244	1821
5311	244	6702
19485	245	3221
2884	246	5821
2884	246	5111
2884	246	692
2884	246	4960
2884	246	7874
2884	246	6519
2884	246	8511
6463	247	8540
6463	247	9524
6463	247	876
6463	247	1065
6463	247	6406
6463	247	5538
2718	248	9147
2718	248	1208
2718	248	7590
2718	248	3110
2718	248	8717
2718	248	3899
2718	248	4851
6782	249	4136
6782	249	8000
6782	249	4437
6782	249	9345
6782	249	2645
6782	249	1334
6782	249	7763
6782	249	5889
6957	250	7587
6957	250	9316
6957	250	9765
6957	250	9817
6957	250	7557
6957	250	7482
6957	250	9622
8116	251	4033
8116	251	7236
8116	251	1452
8116	251	5846
8116	251	3968
8116	251	818
16809	252	9890
16809	252	1610
16809	252	7412
16809	252	8988
16809	252	859
16809	252	374
16809	252	2667
13398	253	2065
13398	253	6220
376	254	2207
376	254	802
376	254	3915
11048	255	4691
11048	255	1849
11048	255	7993
11048	255	3299
11048	255	2481
11048	255	7358
11048	255	8509
9456	256	4916
14245	257	8116
14245	257	4979
14245	257	1583
14245	257	4615
12926	258	8685
12926	258	3413
12926	258	2406
1829	259	5642
1829	259	7031
1829	259	3198
1829	259	7681
1829	259	4804
1829	259	1401
5965	260	9255
5965	260	4533
5965	260	2673
5965	260	6197
5965	260	4383
5965	260	6856
5965	260	9517
5965	260	6760
7581	261	4307
7581	261	3112
7581	261	9192
7581	261	8893
7581	261	7495
7581	261	717
7581	261	3970
13285	262	2728
13285	262	2624
13285	262	3666
13285	262	6631
2405	263	8972
2405	263	6411
2405	263	7632
13048	264	575
13048	264	838
13048	264	4214
13048	264	1188
7830	265	3498
7830	265	7449
7830	265	9619
7830	265	1331
7830	265	7761
8342	266	9773
8342	266	6510
8342	266	3068
8342	266	6986
8342	266	1630
8342	266	2569
8342	266	3880
8342	266	6732
8342	266	563
16022	267	2758
16022	267	2055
16022	267	1990
16022	267	4689
16022	267	4394
16022	267	3353
16022	267	2482
16022	267	7987
19232	268	2433
19232	268	8149
19232	268	3956
5117	269	780
5117	269	1439
5117	269	9997
5117	269	7243
5117	269	7802
5117	269	9146
5117	269	2539
5117	269	7575
5117	269	1094
3521	270	6307
3521	270	1738
3521	270	7657
8757	271	3858
8757	271	6434
8757	271	5747
8757	271	8539
15368	272	9311
15368	272	8375
15368	272	179
15368	272	2164
15368	272	1089
15368	272	9921
15368	272	8733
15368	272	3956
9672	273	7155
9672	273	9666
9672	273	5262
9672	273	6449
9672	273	5889
9672	273	8423
13593	274	5312
13593	274	4581
13593	274	6237
13593	274	9226
6361	275	8017
6361	275	9844
6361	275	3259
6361	275	8071
9038	276	5670
9038	276	8801
9038	276	4312
9038	276	2703
14566	277	1784
14566	277	3373
14566	277	8429
14566	277	7893
14566	277	1566
14566	277	1615
14566	277	7246
14566	277	3345
4875	278	9953
4875	278	8970
4875	278	1764
4875	278	3889
4875	278	8955
4875	278	2336
4875	278	5160
4875	278	4598
4875	278	5601
14331	279	1990
14331	279	1334
11075	280	5411
8761	281	6053
10014	282	5745
10014	282	2093
10014	282	4537
10014	282	2832
10014	282	4859
10014	282	6218
15101	283	3088
15101	283	3953
15101	283	7677
19331	284	5543
19331	284	3938
19331	284	2860
19331	284	2280
19331	284	24
19331	284	2646
19331	284	1386
19331	284	5914
19331	284	4352
13066	285	6486
13066	285	6740
13066	285	5663
13066	285	3827
13066	285	8550
13066	285	4562
13066	285	700
13066	285	2170
4387	286	5049
4387	286	2523
4387	286	8785
4387	286	7404
4387	286	3407
19784	287	4054
19784	287	8537
19784	287	3912
19784	287	7248
19784	287	9574
19784	287	5895
19784	287	927
19784	287	3937
19784	287	3286
11617	288	2682
12178	289	5981
12178	289	5722
12178	289	144
12178	289	7913
12178	289	1345
12178	289	2529
12178	289	3108
8069	290	4757
8069	290	5584
8069	290	5785
8069	290	7347
8069	290	2880
8069	290	4556
1072	291	569
1072	291	8755
1072	291	5556
1072	291	3642
1072	291	1019
7361	292	279
7361	292	3175
7361	292	2201
19095	293	1519
19095	293	1308
19095	293	2517
19095	293	4791
7090	294	3645
7090	294	7802
7090	294	1959
7090	294	8343
7090	294	7507
7090	294	8284
7090	294	4483
7090	294	9641
7090	294	31
3099	295	1843
3099	295	4114
16553	296	7995
16553	296	1424
16553	296	8485
16553	296	106
16553	296	6125
16553	296	5449
19862	297	5804
19862	297	4999
19862	297	6471
19862	297	7398
19862	297	5609
19862	297	4947
19862	297	9788
19862	297	6472
15789	298	1276
15789	298	4259
15789	298	1295
15789	298	1808
15789	298	9638
15789	298	7521
15789	298	1620
16181	299	6404
16181	299	298
16181	299	2430
16181	299	6475
16181	299	7868
16181	299	6796
16181	299	2853
16181	299	5129
12847	300	6012
12847	300	3977
12847	300	1898
12847	300	6052
12847	300	3688
12847	300	2073
12847	300	4790
14440	301	6121
14440	301	3336
14440	301	1770
14440	301	987
14440	301	3299
14440	301	3322
14440	301	3737
14440	301	6573
16940	302	1756
16940	302	1533
16940	302	7089
16940	302	6198
16940	302	3542
16940	302	6445
16940	302	8978
16940	302	2578
16940	302	5969
18535	303	9384
11914	304	4427
11914	304	2078
11914	304	1781
17738	305	7398
17738	305	4861
17738	305	3136
17738	305	3623
17738	305	4585
17738	305	9278
18602	306	3061
18602	306	4198
18602	306	6652
18602	306	9317
18602	306	4807
18602	306	2338
18602	306	9966
18602	306	1024
11769	307	9723
11769	307	4592
11769	307	4419
11769	307	6535
11769	307	3171
11769	307	1517
11769	307	3218
11769	307	764
160	308	1177
160	308	3961
160	308	3206
160	308	8507
160	308	868
160	308	7826
160	308	4541
160	308	4896
160	308	6287
18914	309	5687
18914	309	9465
18914	309	4246
18914	309	6530
15413	310	8849
15413	310	1892
15413	310	5933
15413	310	7068
15413	310	3349
15413	310	6176
15413	310	566
5599	311	6549
12027	312	9816
12027	312	2297
12027	312	8291
12027	312	9672
12027	312	3060
12027	312	4495
12027	312	4322
12027	312	2751
12027	312	3170
7472	313	6535
7472	313	6423
7472	313	913
7472	313	9097
7472	313	1085
7472	313	5553
7687	314	983
7687	314	2911
14465	315	4903
14465	315	3186
14465	315	3946
14465	315	6407
5659	316	4460
5659	316	3762
5659	316	1574
5659	316	8925
5659	316	3158
5659	316	4598
5659	316	897
5659	316	9618
13315	317	6867
13315	317	460
13315	317	4424
13315	317	1292
13315	317	9696
13315	317	1100
13315	317	7516
13315	317	9700
13315	317	4176
14667	318	1474
14667	318	4444
14667	318	306
14667	318	7749
14667	318	8826
14667	318	6819
14667	318	5427
13437	319	1574
13437	319	5
13437	319	9510
13437	319	8178
13437	319	8327
13437	319	1019
4985	320	3584
4985	320	1079
19809	321	9191
19809	321	8567
19809	321	8091
19809	321	1192
19809	321	6764
19809	321	8753
19809	321	899
18452	322	4557
15575	323	1324
15575	323	8384
15575	323	7776
15575	323	9153
15575	323	5703
15575	323	2309
15575	323	9835
13195	324	2870
13195	324	9141
13173	325	1484
13173	325	7165
13173	325	4324
13173	325	6148
13173	325	316
13173	325	7037
13173	325	890
13173	325	7187
13173	325	6533
19981	326	2201
19981	326	6990
3622	327	1188
3622	327	391
3622	327	7688
7671	328	7759
7671	328	6623
7671	328	7198
7671	328	1847
7671	328	830
7671	328	3721
7671	328	9941
13861	329	8741
19857	330	8281
19857	330	8472
19857	330	6122
19857	330	2275
17795	331	2706
17795	331	1278
17795	331	2921
17795	331	7982
17795	331	919
17795	331	9791
17795	331	9165
5064	332	6289
5064	332	255
5064	332	1861
5064	332	653
5064	332	257
5064	332	3033
5064	332	8552
5064	332	7160
160	333	2941
160	333	6172
160	333	3927
160	333	1264
160	333	7869
160	333	5264
160	333	6464
16649	334	2460
16649	334	574
16649	334	4934
16649	334	1231
16649	334	8954
16649	334	2174
16649	334	7761
16649	334	9527
16649	334	7846
18217	335	8832
18217	335	1294
18217	335	1529
18217	335	3620
18217	335	9782
18217	335	5572
18217	335	1572
5606	336	3308
5606	336	2215
5606	336	9887
5606	336	4999
5606	336	5195
5606	336	6840
5606	336	1404
5606	336	1955
6967	337	6906
6967	337	667
6967	337	3044
6967	337	2984
6967	337	5042
16697	338	9416
16697	338	4913
16697	338	7973
9626	339	485
2904	340	6039
2904	340	8379
2904	340	872
2904	340	8944
2904	340	3946
2904	340	9438
19587	341	35
19587	341	6163
9688	342	4929
9688	342	7150
9688	342	4757
9688	342	3400
9688	342	7032
9688	342	7501
9688	342	3201
9688	342	1759
9688	342	430
5526	343	4512
1349	344	5519
1349	344	5349
1349	344	5157
1349	344	8158
1349	344	1136
1349	344	708
16417	345	4653
16417	345	3681
16417	345	9024
16417	345	7845
16417	345	5852
16417	345	1037
136	346	1920
136	346	8996
136	346	3010
136	346	6989
136	346	8711
136	346	2312
136	346	5905
136	346	8580
4522	347	7990
4522	347	5245
4522	347	5841
4522	347	2801
4522	347	6349
16536	348	5344
16536	348	3570
16536	348	5632
16536	348	29
16536	348	4325
16536	348	6325
5066	349	7765
5066	349	5612
2905	350	324
2905	350	7762
2905	350	3907
2905	350	4160
2905	350	7726
2905	350	1583
2905	350	9
2905	350	1301
2905	350	7543
8064	351	6161
8064	351	5557
8064	351	932
444	352	5861
444	352	1292
444	352	6348
444	352	9017
1199	353	2210
1199	353	7523
1199	353	6354
13022	354	4433
13022	354	1716
13022	354	5272
13022	354	5586
13022	354	8488
13022	354	7729
13022	354	1214
13022	354	5230
13022	354	8149
11155	355	4307
11155	355	2791
11155	355	3882
2088	356	3763
2088	356	6969
5109	357	4001
5109	357	1439
13337	358	5078
13337	358	2184
13337	358	9312
13337	358	5798
13337	358	7151
13337	358	8676
10388	359	3427
10388	359	3520
10388	359	5448
10388	359	8261
10388	359	4557
6030	360	9622
3611	361	8296
3611	361	7792
3611	361	3600
3611	361	9768
3611	361	1662
3611	361	8808
4654	362	2501
4654	362	3484
4654	362	9649
4654	362	72
19387	363	1499
19387	363	321
19387	363	9504
19387	363	5241
19387	363	4580
12482	364	1329
12482	364	8559
12482	364	3324
12482	364	2967
12482	364	8116
12482	364	4952
6405	365	7833
6405	365	1676
6405	365	9174
6405	365	6265
6405	365	4283
6405	365	9424
250	366	9414
250	366	1431
250	366	7555
250	366	9543
250	366	7011
250	366	3858
250	366	7697
250	366	1733
6817	367	4588
17740	368	577
17740	368	4255
17740	368	6286
17740	368	5011
5131	369	8236
5131	369	441
5131	369	4765
5131	369	3833
5131	369	3666
5131	369	9906
8987	370	3364
8987	370	4079
8987	370	5951
8987	370	2454
8987	370	2002
8987	370	9953
8987	370	30
8987	370	4353
8987	370	1189
11905	371	2450
11905	371	9142
11905	371	3941
11905	371	6849
424	372	4152
424	372	6746
424	372	7497
424	372	4069
424	372	7153
424	372	9515
424	372	2364
424	372	6299
18458	373	5825
18458	373	1460
18458	373	440
18458	373	996
18458	373	8521
18458	373	3186
18458	373	5565
18458	373	9277
18458	373	8679
11663	374	7337
7270	375	2864
7270	375	6487
7270	375	5499
7270	375	8453
7270	375	6255
7270	375	712
7270	375	9753
10634	376	8378
10634	376	71
10634	376	8338
10634	376	8912
10634	376	7322
10634	376	9309
10634	376	7020
7012	377	1452
7012	377	733
7012	377	8761
7012	377	2482
7012	377	5342
18339	378	1676
18339	378	1095
13	379	9645
13	379	1411
1411	380	5499
1411	380	7340
1411	380	9328
1411	380	7676
1411	380	4614
1411	380	1739
1411	380	2186
1411	380	652
3493	381	1753
3493	381	913
3493	381	4555
3493	381	8061
3493	381	3029
3493	381	9749
3493	381	9851
3493	381	4759
3493	381	3189
15605	382	6246
15605	382	1119
15605	382	1496
10739	383	4929
18966	384	1204
18966	384	8082
18966	384	379
18966	384	8041
18966	384	7111
18966	384	7571
18966	384	9031
18966	384	824
18966	384	657
4305	385	7522
4900	386	1933
4900	386	2857
4900	386	935
2625	387	6450
2625	387	3357
4774	388	7664
4774	388	6844
4774	388	9850
4774	388	655
4774	388	8781
18084	389	8126
18084	389	4889
17953	390	1105
17953	390	3516
17953	390	842
17953	390	6848
17953	390	2496
17953	390	5581
17953	390	4349
10005	391	6870
10005	391	2181
10005	391	4374
18524	392	8239
18524	392	5670
18524	392	6559
18524	392	3803
18524	392	6779
18524	392	5284
18524	392	5162
18524	392	8613
5942	393	6110
5942	393	1715
5942	393	3122
5942	393	8597
5942	393	5350
5942	393	724
5942	393	7701
5942	393	2931
5942	393	5579
4714	394	1631
4714	394	7806
4714	394	2055
4714	394	3214
4714	394	3193
4714	394	7948
4714	394	7614
12422	395	4174
12422	395	9933
12422	395	777
12422	395	6133
12422	395	9596
12422	395	8712
683	396	585
683	396	6639
683	396	8145
12185	397	7163
1644	398	5206
1644	398	2992
18249	399	6916
18249	399	1445
18249	399	1390
18249	399	4189
18249	399	2546
1381	400	6783
1381	400	9629
1381	400	1126
1381	400	4767
1381	400	7693
1381	400	5210
1381	400	5954
1381	400	9809
1381	400	4546
11980	401	6958
19006	402	194
19006	402	7367
19006	402	9439
19006	402	921
19006	402	3568
19006	402	3766
19006	402	5659
19006	402	1945
3507	403	8478
3507	403	9591
3507	403	9969
3507	403	9411
5596	404	6842
5596	404	3220
5596	404	5505
5596	404	6844
5596	404	9827
5596	404	333
4556	405	4031
4556	405	2242
4556	405	6241
4556	405	9358
4556	405	8380
4556	405	8879
4556	405	1567
4556	405	673
7784	406	8032
7784	406	3109
7784	406	2142
7784	406	3342
877	407	7438
877	407	2258
877	407	4441
877	407	9887
877	407	384
877	407	7249
877	407	8788
877	407	359
877	407	1814
19690	408	7703
19690	408	7905
19690	408	446
19690	408	1483
19690	408	3373
11260	409	7246
11260	409	681
11260	409	1250
11260	409	9580
11260	409	5851
11260	409	7357
11260	409	4984
11260	409	7510
10423	410	6256
15476	411	6658
15476	411	3707
15476	411	2822
15476	411	1740
15476	411	8581
15476	411	1431
15476	411	3026
15476	411	8098
6162	412	4643
6162	412	7667
6162	412	3352
16111	413	6132
16111	413	2150
16111	413	7573
16111	413	791
16111	413	8474
16111	413	2301
16111	413	7532
11258	414	8710
11258	414	4588
4508	415	6176
15671	416	6153
15671	416	4452
15671	416	8236
15671	416	3037
15671	416	4613
4289	417	7773
4289	417	5932
4289	417	1178
4289	417	9835
16219	418	2035
16219	418	6784
16219	418	1773
16219	418	6413
16219	418	6661
16219	418	1466
16219	418	1358
16219	418	5034
16219	418	8223
11991	419	2478
11991	419	8220
11991	419	1501
11991	419	421
11991	419	9941
11991	419	7338
11991	419	5605
4034	420	6666
4034	420	6017
4034	420	2878
4034	420	5994
4034	420	6749
4034	420	7096
19147	421	1885
19147	421	4676
19147	421	3748
19147	421	4762
731	422	2383
18096	423	7071
18096	423	4386
18096	423	6305
18096	423	828
12583	424	9975
12583	424	5594
18682	425	426
18682	425	2291
9346	426	3721
9346	426	2258
9346	426	3680
9346	426	3856
9346	426	7779
9346	426	3385
9346	426	974
9346	426	9757
9346	426	1218
16763	427	308
16763	427	5469
16763	427	5737
16763	427	7271
16763	427	5995
16504	428	4895
16504	428	4023
16504	428	321
16504	428	406
326	429	5513
326	429	3365
326	429	2706
326	429	5321
326	429	6270
7080	430	4532
7080	430	9493
8776	431	7061
8776	431	8770
5072	432	7519
5072	432	3652
5072	432	3347
5072	432	4555
5072	432	4532
5072	432	9724
5332	433	5968
5332	433	5210
5332	433	4900
5332	433	4670
5332	433	9434
5332	433	9427
5332	433	5976
5332	433	8811
5332	433	199
7090	434	2212
7090	434	9754
7090	434	3130
7090	434	4602
7090	434	3012
7090	434	4661
7090	434	3876
7090	434	5383
7090	434	1521
1896	435	8005
1896	435	1454
1896	435	9090
1896	435	1748
1896	435	4761
1896	435	1261
1896	435	5895
1896	435	8632
3288	436	9865
3288	436	2760
3288	436	3486
10941	437	3431
10941	437	4508
10941	437	1436
10941	437	715
10941	437	1508
10941	437	7142
10941	437	9990
10941	437	7157
11390	438	8894
11390	438	9535
11390	438	5377
11390	438	5934
11390	438	8491
3841	439	6805
3841	439	1426
3841	439	9013
3841	439	2994
3841	439	5700
3841	439	9191
3841	439	1605
3841	439	8551
14889	440	9098
14889	440	9872
14889	440	2816
14889	440	6194
14889	440	283
14889	440	3962
14889	440	6418
10861	441	1586
10861	441	583
10861	441	6875
10861	441	3498
10861	441	4058
10861	441	2870
10861	441	7667
15076	442	5900
15076	442	2383
15076	442	3779
15076	442	3269
15076	442	1732
15076	442	5627
14423	443	7988
14423	443	8244
14423	443	6368
14423	443	2299
14423	443	8359
14423	443	1204
16402	444	1392
16402	444	9585
16402	444	6766
16402	444	5366
1985	445	8204
1985	445	2258
1985	445	3559
1985	445	7676
1985	445	2804
1985	445	9163
732	446	8567
732	446	845
732	446	1413
732	446	5129
732	446	3283
732	446	6676
732	446	1487
19381	447	5881
19381	447	2972
19381	447	1324
972	448	852
972	448	911
972	448	880
972	448	9377
9010	449	5000
9010	449	9479
9010	449	2369
9010	449	6177
9010	449	2160
10263	450	906
10263	450	3413
10263	450	2612
7046	451	5279
7046	451	901
7046	451	7564
7046	451	2932
7046	451	8517
7046	451	9049
7046	451	2100
7046	451	1093
5393	452	5624
5393	452	2038
5393	452	8138
11735	453	4477
11735	453	40
11735	453	913
11735	453	6749
11735	453	166
11735	453	6254
11735	453	6151
14486	454	9940
14486	454	4615
13304	455	1301
18945	456	2922
7669	457	7679
7669	457	8171
7669	457	1903
12683	458	8062
12683	458	6899
12683	458	7066
12683	458	9329
12683	458	9633
11873	459	6717
11873	459	9362
11873	459	6857
11873	459	5779
7897	460	8270
7897	460	2817
7897	460	5646
7897	460	1337
7897	460	3555
7897	460	1741
2748	461	7311
2748	461	4071
2748	461	6636
2748	461	6900
2748	461	5318
2748	461	8027
2748	461	6626
2748	461	6367
2748	461	7243
5776	462	5432
5776	462	4468
5776	462	6499
5776	462	8546
5776	462	4163
5776	462	3624
517	463	3750
517	463	9459
517	463	6874
517	463	8269
517	463	979
517	463	2424
517	463	8399
7660	464	1003
7660	464	773
7660	464	2610
7660	464	5404
7660	464	3169
7660	464	6491
482	465	2018
482	465	7609
17174	466	4294
17174	466	6841
17174	466	8026
17174	466	2305
6156	467	8014
6156	467	4383
6156	467	9264
6156	467	6018
6156	467	1115
6156	467	2856
6156	467	6529
6156	467	3417
18428	468	3409
18428	468	9410
18428	468	2599
18428	468	462
18073	469	3015
18073	469	3988
18073	469	1545
5317	470	5790
5317	470	6928
5317	470	2831
5317	470	8421
5317	470	9323
5317	470	5306
15807	471	6043
15807	471	2761
15807	471	8046
15807	471	3002
9092	472	7205
9092	472	8127
10109	473	1033
10109	473	2728
10109	473	2450
10109	473	9087
10109	473	5936
10109	473	9438
10109	473	4774
5637	474	4852
5637	474	1856
5637	474	7689
5637	474	6770
5637	474	2055
5637	474	870
5637	474	8099
1652	475	8859
1652	475	3039
1652	475	877
1652	475	6773
1652	475	4673
1652	475	8468
1652	475	8391
493	476	9307
493	476	2175
493	476	7999
493	476	5617
493	476	4947
493	476	6924
11564	477	576
14697	478	8429
14697	478	649
14697	478	6859
14697	478	7066
14697	478	5680
14697	478	4049
14697	478	7734
14697	478	899
11691	479	3048
11691	479	850
11691	479	2514
11691	479	1015
11691	479	8774
14405	480	4022
14405	480	3817
14405	480	3553
14405	480	7459
14405	480	7351
16500	481	4095
16500	481	2861
16500	481	4040
16500	481	8736
16500	481	5136
16500	481	2397
16500	481	5837
16500	481	1112
10265	482	6219
10265	482	4055
10265	482	3100
10265	482	8869
10265	482	9656
7500	483	893
7500	483	7113
7500	483	382
7500	483	9379
10431	484	677
10431	484	2402
10431	484	4324
10431	484	8121
10431	484	2297
10431	484	9784
10431	484	3970
9022	485	7914
9022	485	2192
9022	485	3710
9022	485	7275
9022	485	5352
9022	485	8303
9022	485	702
9022	485	4141
16929	486	6843
16929	486	943
16929	486	5184
16929	486	6065
16929	486	9423
16929	486	2120
16929	486	3334
16929	486	2362
16929	486	6885
4473	487	6612
4473	487	7413
4473	487	6872
4473	487	9216
4473	487	8737
4473	487	2612
4473	487	2684
4473	487	4591
8026	488	1349
8026	488	7982
8026	488	8377
8026	488	3346
12829	489	184
12829	489	4465
12829	489	3366
12829	489	5649
16522	490	6056
16522	490	1171
16522	490	384
3465	491	5442
3465	491	4124
3465	491	7388
3465	491	5202
3465	491	4939
3465	491	8680
3465	491	2441
3465	491	3085
3465	491	4148
11856	492	2300
11856	492	14
11856	492	5587
12183	493	4972
12183	493	8645
12183	493	5900
12183	493	6687
12183	493	9232
12183	493	242
12183	493	7411
12183	493	9763
12183	493	6149
2788	494	7810
2788	494	2468
2788	494	9826
2788	494	9488
2788	494	6740
2788	494	5050
2788	494	6819
2788	494	9231
2788	494	1787
4056	495	5353
4056	495	7841
4056	495	6012
4056	495	2895
4056	495	5112
4056	495	3067
5784	496	3268
5784	496	8048
5784	496	6587
5784	496	9267
2107	497	3082
2107	497	3524
2107	497	4313
2107	497	9936
2107	497	6691
2107	497	4856
2107	497	3534
15268	498	1222
15268	498	5045
15268	498	2399
15268	498	4135
5011	499	9748
5011	499	6141
906	500	777
906	500	6999
906	500	3127
906	500	3554
8735	501	8449
8735	501	8656
8735	501	3025
8735	501	2513
8735	501	5295
8735	501	2199
8735	501	1031
8735	501	8314
8735	501	8792
19136	502	5200
19136	502	6963
19136	502	9908
19136	502	3121
19136	502	4516
19136	502	7651
1350	503	1147
1350	503	160
1350	503	6298
1350	503	1684
1350	503	6454
11774	504	2318
11774	504	9234
18281	505	5397
18281	505	8686
18281	505	2096
18281	505	3723
18281	505	6030
18281	505	9312
18281	505	8214
19795	506	373
19795	506	9718
19795	506	9612
19795	506	5658
19308	507	6770
19308	507	4651
19308	507	6430
19308	507	6556
19308	507	4803
19308	507	5022
6470	508	3132
6470	508	9982
6470	508	7721
6470	508	3919
6470	508	1736
6470	508	6179
8328	509	7547
8328	509	1455
8328	509	176
8328	509	4129
8328	509	596
8328	509	9093
17630	510	8757
17630	510	9020
17630	510	5201
17630	510	3811
17630	510	2515
3490	511	7745
3490	511	2198
3490	511	5675
3490	511	7210
3490	511	7352
3490	511	8953
3490	511	7174
3490	511	5259
8031	512	493
8031	512	8811
8031	512	331
8031	512	4292
8031	512	3071
8031	512	9088
2569	513	3658
2569	513	5620
2569	513	5030
2569	513	7453
2569	513	5909
2569	513	4896
6177	514	6483
6177	514	1523
6177	514	8770
6177	514	7133
6177	514	4257
6177	514	2656
6177	514	7504
2323	515	2171
2323	515	405
2323	515	7128
2323	515	2335
2323	515	9075
2323	515	5111
3187	516	8406
3187	516	3616
3187	516	5763
3187	516	1757
3187	516	2271
3187	516	1089
3187	516	422
3187	516	8318
17446	517	5036
17446	517	5057
17446	517	3611
19783	518	7694
19783	518	891
19783	518	5705
19783	518	9182
19783	518	5070
19783	518	6722
19783	518	3938
4511	519	978
4511	519	6084
4511	519	6501
223	520	3
223	520	8910
19599	521	6452
19599	521	6401
19599	521	9640
19599	521	7680
19599	521	266
19599	521	5833
19599	521	7870
19599	521	1952
19599	521	2825
5896	522	4889
5896	522	9470
5896	522	6261
5896	522	3598
5896	522	1644
5896	522	3454
6187	523	6671
6187	523	4072
6187	523	1433
6187	523	9314
6187	523	5894
6187	523	1836
6187	523	5086
6187	523	7389
6187	523	8963
10448	524	490
10448	524	7418
10448	524	9251
10448	524	7037
10448	524	8239
10448	524	1849
10448	524	6211
11048	525	7662
5494	526	2721
5494	526	5379
5494	526	3084
5494	526	3862
5494	526	6148
5494	526	7517
5494	526	268
5494	526	5816
15328	527	945
15328	527	9995
15328	527	5212
15328	527	6108
15328	527	403
6246	528	9616
6953	529	4756
6953	529	6730
5091	530	209
5091	530	4321
5091	530	9412
5091	530	8761
5091	530	1971
5091	530	967
5091	530	9872
5091	530	5497
5091	530	6072
2509	531	2586
2509	531	5240
2509	531	8367
2509	531	1861
2509	531	6680
2509	531	6241
2509	531	3222
2509	531	5316
14574	532	9661
14574	532	7071
6284	533	4397
6284	533	6345
6284	533	2199
6284	533	6297
6284	533	8414
6284	533	2462
6284	533	226
6284	533	6095
2821	534	8697
2821	534	5871
2821	534	9003
2821	534	3514
2821	534	6083
959	535	7461
959	535	4530
959	535	5402
15725	536	6564
15725	536	5588
2034	537	3297
2034	537	2595
2034	537	4359
2034	537	760
14721	538	306
14721	538	7362
14721	538	2139
8105	539	6192
8105	539	9945
8105	539	8107
8105	539	2796
8105	539	9724
8105	539	5071
18858	540	9870
18858	540	6512
18858	540	842
18858	540	9171
18858	540	1651
18858	540	967
18858	540	5361
18858	540	5243
18858	540	8780
13774	541	541
13774	541	2221
13774	541	2715
13774	541	5041
13774	541	9764
13774	541	9457
595	542	8501
595	542	6179
595	542	4170
595	542	1058
595	542	3092
12847	543	2551
12847	543	5670
12847	543	2876
12847	543	5384
12847	543	9525
17962	544	9279
17962	544	3396
17962	544	9254
17962	544	7246
17962	544	1114
17962	544	2835
17962	544	8141
17962	544	629
6358	545	7951
6358	545	6761
6358	545	2922
6358	545	8482
6358	545	5266
6358	545	4274
6358	545	4415
6358	545	2323
19138	546	7872
19138	546	2562
19138	546	7360
19138	546	879
19138	546	6369
19138	546	8443
19138	546	8014
19138	546	7653
12268	547	6037
12268	547	1297
12268	547	8626
12268	547	4118
12268	547	3189
12268	547	4226
12268	547	1133
16984	548	8558
16984	548	960
16984	548	665
16984	548	2202
16984	548	9909
16984	548	4452
16984	548	442
16984	548	7548
12346	549	2042
12346	549	6264
12346	549	9608
12346	549	3054
12346	549	5888
8890	550	1445
8890	550	4565
8890	550	8358
8890	550	7335
8890	550	1064
8890	550	3296
8467	551	9289
8467	551	3421
8467	551	3093
8467	551	2948
8467	551	9709
8682	552	9932
8682	552	8593
8682	552	8370
8682	552	8969
8682	552	9758
8682	552	3481
8682	552	8643
8682	552	7287
13151	553	2128
13151	553	4317
8051	554	8366
8051	554	7220
8051	554	1913
8051	554	2794
8051	554	2761
8051	554	5985
8051	554	1794
8051	554	5572
5717	555	9434
3122	556	6636
3122	556	9960
3122	556	5616
3122	556	7735
3122	556	6624
3122	556	8647
2815	557	3926
2815	557	5378
2815	557	3409
2815	557	2356
2815	557	8167
2815	557	1386
17689	558	5794
17689	558	531
17689	558	4003
17689	558	4245
17689	558	7911
17689	558	43
17689	558	4299
17689	558	3752
17689	558	4193
15201	559	4872
12514	560	5102
12514	560	5200
12514	560	6311
12514	560	2304
12514	560	3995
3811	561	9745
6991	562	2625
6991	562	3994
6991	562	9759
6991	562	4724
6991	562	5122
6991	562	6839
4075	563	7768
4075	563	6896
4075	563	9969
4075	563	3668
4075	563	8815
4075	563	3145
10212	564	4788
10212	564	9123
10212	564	265
10212	564	6171
10212	564	3486
10212	564	5609
10212	564	5046
10212	564	342
10212	564	147
231	565	9523
231	565	1654
231	565	4901
231	565	7773
231	565	8092
231	565	3709
231	565	7108
231	565	1060
9089	566	8303
9089	566	1694
9089	566	4145
9089	566	5882
9089	566	1956
2956	567	4145
2956	567	7176
2956	567	2047
2956	567	4479
2956	567	2480
2956	567	9729
2956	567	4863
2956	567	8084
12773	568	5031
12773	568	7590
12773	568	5343
12773	568	1865
12773	568	1023
12773	568	920
16189	569	3361
16189	569	4244
16189	569	3148
16189	569	9380
16189	569	3059
16189	569	9158
16189	569	3850
16189	569	2864
905	570	9997
905	570	5908
905	570	8359
905	570	6187
6543	571	4834
6543	571	4123
6543	571	1504
6543	571	5992
6543	571	966
6543	571	1677
6543	571	6787
6543	571	3695
6973	572	5142
6973	572	6009
6973	572	1386
6973	572	8302
6973	572	5467
600	573	8282
600	573	2215
600	573	5190
600	573	9423
600	573	7996
600	573	1406
600	573	1257
600	573	5177
637	574	3820
637	574	9591
637	574	2159
637	574	3712
637	574	5357
637	574	5460
637	574	3462
17302	575	5517
17302	575	3543
17302	575	542
17302	575	3321
17302	575	4708
17302	575	6037
17302	575	2104
3388	576	6751
3388	576	3932
3388	576	8522
3388	576	5745
3388	576	7066
3388	576	634
3388	576	989
9064	577	9332
9064	577	3030
9064	577	1101
9064	577	3212
9064	577	8921
9064	577	4897
9064	577	5421
18703	578	8743
18703	578	7090
18703	578	3154
18703	578	3728
18703	578	3874
13892	579	3339
13892	579	2044
13892	579	9905
13892	579	7642
13892	579	3493
13892	579	9722
13892	579	4186
13892	579	8265
14013	580	2814
14013	580	6225
14013	580	4733
14013	580	7040
14013	580	7044
14013	580	1412
14013	580	5689
14013	580	4821
4925	581	5001
4925	581	1118
18763	582	6388
18763	582	360
13168	583	6682
13168	583	3291
13168	583	7631
13168	583	4108
13168	583	8159
13168	583	8912
13168	583	1391
13168	583	9075
13168	583	7469
15830	584	9773
15830	584	7264
15830	584	5162
1807	585	3685
1807	585	7124
1807	585	293
1807	585	4634
7090	586	6874
7090	586	7942
7036	587	6220
7036	587	121
7036	587	2162
7036	587	5898
16394	588	3787
16394	588	1184
16394	588	629
16394	588	2531
16394	588	9362
16394	588	2338
16394	588	2249
16394	588	579
16394	588	3797
32	589	3499
32	589	6399
5168	590	2453
5168	590	7576
5168	590	5459
5168	590	9455
5168	590	8992
5168	590	5841
5168	590	5052
5168	590	1607
10807	591	5420
10807	591	7039
10807	591	359
10807	591	8313
10807	591	6021
10807	591	4441
4033	592	221
4033	592	731
4033	592	381
10865	593	1063
10865	593	7550
5938	594	1886
5938	594	5984
5938	594	9483
7848	595	5941
7848	595	6130
7848	595	4152
7848	595	5372
11823	596	8058
11823	596	7680
11823	596	557
11823	596	8576
11823	596	5734
11823	596	6638
11823	596	661
11823	596	3721
8395	597	6786
8395	597	2146
8395	597	3143
8395	597	5470
8395	597	3430
8395	597	4668
4695	598	5535
4695	598	436
4695	598	6132
4695	598	2984
4695	598	3194
4695	598	3557
4695	598	902
15373	599	8624
15373	599	8888
4634	600	3804
4634	600	6723
4634	600	3005
4634	600	6567
5396	601	9490
5396	601	3212
5396	601	6946
5396	601	6755
5396	601	1799
5396	601	7539
12853	602	8743
12853	602	3962
12853	602	28
12853	602	3444
12853	602	2942
12853	602	6473
12853	602	2708
12853	602	2974
12853	602	692
15275	603	3807
15275	603	8742
17239	604	8206
17239	604	1073
17239	604	9061
17239	604	2852
17239	604	4133
17239	604	2514
17239	604	2260
10467	605	1419
10467	605	5919
10467	605	4656
10467	605	3812
10467	605	1070
10467	605	2016
10467	605	3362
10467	605	5356
8833	606	6920
8833	606	1034
8833	606	271
8833	606	4654
8833	606	8527
19890	607	1661
19890	607	1785
5708	608	1696
5708	608	5019
5708	608	9598
5708	608	1468
5708	608	2647
7361	609	6974
7361	609	2929
7361	609	4544
7361	609	5445
7361	609	1130
5828	610	5768
5828	610	6236
2507	611	8660
2507	611	4273
2507	611	4368
2507	611	4987
2507	611	4139
2507	611	4661
2507	611	7460
2507	611	6136
2507	611	8477
14267	612	8572
14267	612	6966
14267	612	3410
15847	613	3904
15847	613	6026
15847	613	8992
15847	613	459
15847	613	2972
862	614	3335
862	614	3598
862	614	9933
862	614	5929
862	614	9724
862	614	3311
18741	615	4090
18741	615	4975
18741	615	3232
18741	615	1128
18741	615	7097
14586	616	3626
14586	616	5932
14586	616	1208
14273	617	31
18868	618	4487
18868	618	9870
18868	618	1255
18868	618	3428
18868	618	6791
11201	619	8733
9329	620	529
9796	621	2577
9796	621	6685
9796	621	9151
9796	621	765
9796	621	631
9796	621	2122
9796	621	4402
1766	622	1894
1766	622	3840
1766	622	7909
16876	623	3336
16876	623	5323
16876	623	6791
16876	623	5538
16876	623	3177
16876	623	4961
16876	623	8323
16876	623	7866
4894	624	4845
17368	625	1187
17368	625	98
6866	626	9345
9766	627	1186
9766	627	9508
9766	627	680
9766	627	2232
9766	627	9820
9766	627	7179
1859	628	2589
1859	628	4731
1859	628	7889
1859	628	6119
1859	628	443
1859	628	6488
1859	628	347
3064	629	1040
3064	629	5547
3064	629	6074
3064	629	9109
3064	629	32
3064	629	4182
3064	629	8056
3064	629	7915
11607	630	9597
11607	630	1039
11607	630	6119
11607	630	1208
11607	630	2917
11607	630	2959
17012	631	3873
17012	631	8655
17012	631	6782
17012	631	7284
17012	631	9606
18124	632	4637
11351	633	7060
11351	633	4391
11351	633	7819
11351	633	3932
11351	633	5856
11351	633	2550
11351	633	7493
11351	633	3633
11351	633	4040
7290	634	2707
7290	634	7068
7290	634	7716
7290	634	3020
7290	634	160
7290	634	2288
7290	634	55
7973	635	5144
7973	635	7485
7973	635	1008
7973	635	6911
7973	635	2034
7973	635	8692
7973	635	2756
19648	636	378
19648	636	7379
19648	636	1840
3790	637	5881
3790	637	4745
3790	637	6831
3790	637	3661
3790	637	3345
3790	637	2885
3790	637	6593
18697	638	9173
18697	638	1774
18697	638	3477
18697	638	88
18697	638	8819
18697	638	7211
18697	638	2165
18697	638	5619
4897	639	287
4897	639	8346
4897	639	7861
4897	639	4746
4897	639	4287
4897	639	180
4897	639	9435
5823	640	8227
5823	640	8273
5823	640	8516
8267	641	6582
8267	641	419
8267	641	8967
13655	642	8215
13655	642	2504
13655	642	1449
13655	642	346
13655	642	4850
6154	643	8515
6154	643	6264
6154	643	4023
6154	643	9686
6154	643	95
6154	643	7473
15021	644	2295
15021	644	562
15021	644	2497
5685	645	4293
5685	645	4664
6356	646	221
6356	646	9718
6356	646	185
6356	646	11
6356	646	8873
6356	646	5168
14924	647	2261
14924	647	4022
976	648	4507
976	648	4162
976	648	8426
976	648	460
976	648	9300
976	648	8552
976	648	9989
976	648	7141
4616	649	9770
4616	649	906
4616	649	3845
4616	649	1027
4616	649	5416
4616	649	6541
4616	649	6859
4616	649	4274
4616	649	422
19442	650	9205
19442	650	1045
19442	650	3760
14763	651	9867
14763	651	452
14763	651	3212
14763	651	1757
14763	651	3090
14763	651	8550
14763	651	9000
14763	651	5233
18327	652	1646
18327	652	7365
18327	652	4691
6685	653	1765
6685	653	6840
6685	653	2082
6685	653	3694
6685	653	8679
6685	653	2135
6685	653	6732
6685	653	51
15212	654	72
15212	654	8043
15212	654	5463
15212	654	8560
15212	654	6076
15212	654	5194
15212	654	5435
15212	654	55
15212	654	2084
1524	655	7989
1524	655	4623
1524	655	9228
1524	655	5645
11433	656	3153
11433	656	5652
11433	656	5229
843	657	2454
843	657	1725
843	657	3370
843	657	5299
6576	658	1327
6576	658	6367
2483	659	4160
2483	659	2464
2483	659	7552
2483	659	1538
2206	660	724
8188	661	7996
18320	662	9552
18320	662	1988
18320	662	701
18320	662	4172
18320	662	517
16136	663	4395
16136	663	7311
16136	663	3005
16136	663	7191
16136	663	2128
16136	663	8510
4400	664	7217
4400	664	6985
4400	664	9132
4400	664	3881
4400	664	2544
4400	664	9938
4400	664	2464
13717	665	1789
17958	666	1508
11882	667	3467
902	668	8135
902	668	1567
902	668	3221
902	668	7893
902	668	5767
902	668	2543
902	668	2046
902	668	2174
19974	669	6311
19974	669	758
19974	669	3020
19974	669	574
19974	669	4675
5619	670	3489
5619	670	3488
18508	671	1722
18508	671	118
18508	671	5553
18508	671	3882
18508	671	8243
18508	671	9979
5997	672	5151
5997	672	1116
5997	672	709
5997	672	7551
5997	672	3018
5997	672	5578
16545	673	3014
16545	673	5909
19580	674	9983
19580	674	2836
19580	674	8800
19580	674	607
3445	675	7179
3445	675	8863
3445	675	8105
3445	675	6459
3445	675	2713
11451	676	4292
11451	676	6108
11451	676	102
11451	676	5916
11451	676	1098
11451	676	8997
5909	677	7621
5909	677	5251
5909	677	802
5909	677	923
5909	677	1752
5909	677	5768
5909	677	9360
5909	677	8479
9173	678	676
9173	678	5746
9173	678	4397
6125	679	1246
6125	679	7510
6125	679	1799
6125	679	9851
6125	679	5571
6125	679	6356
6125	679	3764
4484	680	6828
15007	681	9277
15007	681	3784
15007	681	272
15007	681	9659
15007	681	6797
15007	681	8013
15007	681	5479
15007	681	1316
15007	681	9466
6458	682	5471
4598	683	9803
4598	683	2991
4598	683	5905
4598	683	1833
2983	684	8659
2983	684	3646
2983	684	3570
2983	684	5186
2983	684	2632
12035	685	8769
12035	685	4034
7671	686	2915
7671	686	2105
7671	686	5428
7671	686	6239
7671	686	5410
18110	687	4016
18110	687	5432
18110	687	1793
19062	688	7922
19062	688	6085
18862	689	8682
18862	689	8961
18862	689	8054
18862	689	7231
12116	690	8455
12116	690	3350
12116	690	3182
12116	690	5582
12116	690	4673
12116	690	7279
12116	690	6476
12116	690	2855
12116	690	2794
2952	691	5585
5631	692	8873
5631	692	5370
5631	692	6709
5631	692	1214
5631	692	3861
5631	692	5736
6029	693	6378
6029	693	57
6029	693	2427
17133	694	2760
17133	694	9048
17133	694	5377
17133	694	592
17133	694	5248
17133	694	9466
6654	695	1861
6654	695	5940
6654	695	1344
2800	696	3444
2800	696	7963
2800	696	8367
2800	696	5571
2800	696	1139
2800	696	5334
2800	696	1694
2800	696	9030
2800	696	7041
592	697	9358
592	697	9334
592	697	7400
592	697	2100
592	697	5699
592	697	1023
18778	698	6803
18778	698	8494
18778	698	7251
18778	698	2717
18778	698	1347
18778	698	2499
18778	698	54
18821	699	111
18821	699	7814
7025	700	7173
7025	700	3424
7025	700	7277
7025	700	7076
8653	701	606
8653	701	4837
8653	701	3137
8653	701	4747
8653	701	4300
8821	702	6622
8821	702	8153
8821	702	2642
8821	702	4105
8821	702	6880
7911	703	8282
7911	703	3733
7911	703	415
7911	703	1992
7911	703	3458
7911	703	8867
7911	703	8210
7911	703	2169
17579	704	3164
17579	704	3810
17579	704	1120
17579	704	8651
17579	704	4645
17579	704	6065
17579	704	8913
17579	704	1814
7612	705	545
7612	705	9581
3498	706	539
3498	706	6256
3498	706	26
3498	706	971
3498	706	755
3498	706	8557
3498	706	5423
8671	707	3663
13084	708	8287
13084	708	3243
13084	708	5936
13084	708	3496
13084	708	772
1595	709	1943
1595	709	767
12380	710	526
12380	710	4434
12380	710	2322
12380	710	730
18033	711	4742
18033	711	1910
18033	711	3524
18033	711	7989
18033	711	3480
18033	711	4847
11227	712	1803
11227	712	8641
11227	712	582
11227	712	6517
14492	713	6262
14492	713	429
14492	713	7996
14492	713	9240
14457	714	5033
14457	714	3921
14457	714	5679
14457	714	7755
14457	714	885
14457	714	9810
14457	714	9469
14457	714	4370
8402	715	5147
8402	715	837
8402	715	8007
8402	715	4662
8402	715	7305
8402	715	1525
8402	715	9947
8402	715	5746
8402	715	5289
12347	716	7640
12347	716	9242
12347	716	283
11045	717	1191
11045	717	4500
18322	718	9042
17977	719	4614
17977	719	2447
17977	719	655
17977	719	637
17977	719	1703
17977	719	304
17977	719	2692
17977	719	7509
17977	719	7871
4740	720	1531
4740	720	3243
4740	720	3865
6117	721	7540
6117	721	1895
6117	721	176
6117	721	6488
13583	722	3306
13583	722	439
13583	722	71
13583	722	3546
13583	722	1639
9761	723	1324
9761	723	5007
5091	724	740
5091	724	3808
12433	725	1317
3511	726	1014
3511	726	9872
15910	727	9903
15910	727	7978
15910	727	5568
230	728	4837
230	728	5421
230	728	8660
230	728	1901
230	728	6762
230	728	1732
230	728	5643
230	728	7305
8851	729	7195
8851	729	1786
8851	729	8281
11470	730	3929
11470	730	3610
4539	731	2246
4539	731	9378
4539	731	808
4539	731	6722
4539	731	535
4539	731	2539
19465	732	4904
19465	732	4187
19465	732	1392
19465	732	8602
19465	732	3959
19465	732	4668
19465	732	4481
13452	733	702
13452	733	7740
13452	733	7923
922	734	194
922	734	1423
922	734	5309
922	734	2532
922	734	7263
2442	735	8921
2442	735	142
2442	735	4551
2442	735	4982
2442	735	8953
2442	735	2675
2442	735	995
6545	736	2926
6545	736	2626
6545	736	3837
6545	736	4935
6545	736	6291
6545	736	2321
6545	736	3641
7564	737	2925
7564	737	7262
19873	738	2153
19873	738	5472
16794	739	6631
16794	739	1400
16794	739	2122
16794	739	8519
16794	739	7325
16794	739	5683
18371	740	7670
18371	740	743
18371	740	3991
18371	740	1074
18371	740	5582
18371	740	5101
18371	740	4943
18371	740	5441
13680	741	4530
13680	741	9873
13680	741	3818
13680	741	6639
13680	741	4741
4819	742	1284
4819	742	8862
4819	742	7619
4819	742	8903
4819	742	3642
4819	742	5006
4819	742	5419
4819	742	5922
4819	742	3746
7237	743	9174
7237	743	3790
7237	743	2375
7237	743	6323
15213	744	9964
17732	745	2711
17732	745	7812
17732	745	4994
17732	745	6686
17732	745	4184
17732	745	2358
17732	745	932
17732	745	5433
15616	746	7668
15616	746	9374
18674	747	8203
18674	747	3378
18674	747	6312
18674	747	9043
18674	747	4922
18212	748	5595
18212	748	3934
18212	748	8282
10835	749	4335
10835	749	5508
10835	749	9855
10835	749	8545
10835	749	3099
10835	749	8971
16026	750	3741
16026	750	7139
16026	750	3164
16026	750	9930
16026	750	3762
16026	750	6475
16026	750	3629
16026	750	9100
9214	751	8073
9214	751	6049
9214	751	2328
9214	751	582
9214	751	3033
9214	751	3473
9214	751	2058
9214	751	3143
6145	752	1284
6145	752	9703
6145	752	6412
6145	752	2877
6145	752	3409
6145	752	2540
6145	752	5141
14936	753	2907
14936	753	4532
14936	753	3413
13111	754	9628
1823	755	5825
1823	755	5945
1823	755	3880
1823	755	3437
1823	755	836
1823	755	5008
1823	755	6046
17905	756	5331
17905	756	7843
19306	757	3782
19306	757	5762
19306	757	7239
19306	757	6035
19306	757	286
7445	758	2300
7445	758	6861
7445	758	9956
7445	758	7298
5257	759	4949
5257	759	2331
5257	759	3950
19423	760	1297
19423	760	8122
19423	760	8764
19423	760	5305
19423	760	4031
1782	761	4474
1782	761	1605
1782	761	5876
1782	761	1987
1782	761	4582
1782	761	8429
12255	762	1066
12255	762	2094
12255	762	1122
12852	763	4031
12852	763	4766
12852	763	8789
12852	763	3228
18207	764	9928
16711	765	4483
16711	765	8528
16711	765	6770
16711	765	4735
16711	765	1479
14868	766	9828
14868	766	8328
14868	766	2459
14868	766	9011
14868	766	659
14868	766	1542
14868	766	5344
14868	766	8942
6848	767	8972
7413	768	8285
7413	768	9738
7413	768	8888
14431	769	8771
14431	769	3423
14431	769	2079
14844	770	1755
14844	770	2380
14844	770	3240
14844	770	1651
14844	770	5058
14844	770	6368
14844	770	8416
14844	770	82
14844	770	5670
7703	771	1044
7703	771	2719
7703	771	841
4397	772	5234
4397	772	5615
4397	772	5421
958	773	3822
958	773	5010
958	773	859
958	773	3942
958	773	4531
958	773	8666
958	773	2273
958	773	8696
958	773	4118
11614	774	9876
10593	775	5775
10593	775	460
10938	776	6149
10938	776	9345
10938	776	3837
10938	776	6253
9896	777	4187
9896	777	9320
9896	777	5078
9896	777	2872
14573	778	6841
19902	779	3919
19902	779	802
19902	779	8405
19902	779	1275
1339	780	4182
1339	780	4501
1339	780	9513
1339	780	2696
1339	780	3673
1339	780	9670
1339	780	7453
1339	780	5432
1339	780	6462
760	781	3644
760	781	6116
13726	782	6831
13726	782	1193
13726	782	3271
13726	782	909
13726	782	3088
13726	782	3153
13726	782	3904
18670	783	6344
18670	783	6109
18670	783	74
18670	783	4219
18670	783	4671
18670	783	3052
19765	784	1214
4245	785	6704
4245	785	7158
4245	785	3022
4245	785	9943
12573	786	7365
12573	786	8017
12573	786	5798
12573	786	3599
12573	786	2945
12573	786	8732
12573	786	3623
12573	786	6269
11065	787	7949
11065	787	9379
11065	787	2920
11065	787	1911
11065	787	5607
11065	787	3339
11065	787	1055
11065	787	4556
16307	788	1168
16307	788	9957
16307	788	4378
16307	788	9726
16307	788	1758
16307	788	5216
16307	788	5556
16951	789	3550
16951	789	4032
16951	789	2494
14099	790	5203
14099	790	9269
14099	790	2074
12902	791	2896
16223	792	2706
16223	792	3980
16223	792	173
16223	792	6143
16223	792	4417
5320	793	4944
5320	793	8869
1884	794	7393
1884	794	9307
1884	794	6092
1884	794	8400
1884	794	4760
1884	794	592
1884	794	7726
1884	794	6267
1368	795	3344
1368	795	5488
1368	795	9080
1368	795	2498
11868	796	4820
11868	796	2978
11868	796	3320
16157	797	6817
16157	797	5271
16157	797	4076
16157	797	3768
16157	797	4498
19970	798	4341
19970	798	188
19970	798	3830
19970	798	2328
10611	799	6683
10611	799	408
10611	799	7982
6506	800	3492
6506	800	28
6506	800	1187
6506	800	7974
4629	801	1952
4629	801	3782
4629	801	6957
4629	801	9586
4629	801	5121
4629	801	9992
4629	801	5432
4629	801	2754
6122	802	7137
6122	802	2708
6122	802	3075
6122	802	4906
6122	802	2996
9895	803	9227
9895	803	7133
9895	803	1166
9895	803	5080
1022	804	5314
7125	805	1839
9827	806	6636
9827	806	3345
9827	806	6406
9827	806	1536
17336	807	922
17336	807	8010
17336	807	34
17336	807	9239
17336	807	7498
17336	807	8910
17336	807	3567
5242	808	6581
5242	808	275
5242	808	9493
5242	808	962
5242	808	2312
5242	808	9696
5242	808	3501
5242	808	6280
12626	809	1661
12626	809	1394
12626	809	8721
12626	809	1319
12626	809	7582
12626	809	7891
12626	809	9278
12626	809	4087
10098	810	1698
10098	810	3913
10098	810	111
10098	810	6708
10098	810	6505
10098	810	7991
10098	810	1507
454	811	9301
14384	812	5357
14384	812	5081
14384	812	5224
14384	812	7359
14384	812	4371
14384	812	2119
17652	813	4185
17652	813	6133
17652	813	1286
17652	813	5918
17652	813	4921
17652	813	7556
17652	813	2411
17652	813	8264
6688	814	8222
6688	814	5960
6688	814	6600
6688	814	7074
6688	814	6904
6688	814	6031
6688	814	2888
6688	814	6780
6688	814	7031
3903	815	3905
3903	815	1001
3903	815	8093
3903	815	5513
3903	815	3857
3903	815	1390
3903	815	6327
6799	816	4385
6799	816	5887
6799	816	4246
6799	816	1445
6799	816	5363
6557	817	3605
6557	817	9302
6557	817	4424
6557	817	7759
6557	817	8548
6557	817	8097
6557	817	7138
6380	818	5273
6380	818	9930
6380	818	9343
9411	819	7984
9411	819	1156
9411	819	835
9411	819	3285
2086	820	191
2086	820	8693
2086	820	7625
2086	820	519
11581	821	5309
11581	821	927
11581	821	9138
11581	821	126
11581	821	4778
11581	821	8709
11581	821	1739
11581	821	870
11581	821	3036
6453	822	555
6453	822	6487
6453	822	2080
6453	822	6864
6453	822	5663
6453	822	1603
6453	822	8275
6453	822	139
6453	822	7862
13141	823	8564
13141	823	8430
18516	824	8779
18516	824	5511
15181	825	4761
15181	825	5488
15181	825	3627
7529	826	8680
7529	826	1536
7529	826	3266
7529	826	605
7529	826	1698
13046	827	1903
13046	827	4998
13046	827	1354
13046	827	1673
13046	827	3409
13046	827	2479
13046	827	923
13046	827	799
13046	827	4548
12168	828	6183
12168	828	9892
12168	828	5698
12168	828	4404
12168	828	577
12168	828	7714
12168	828	4663
12168	828	1946
10708	829	2389
10708	829	7243
10708	829	7503
10708	829	2667
10708	829	7874
10708	829	630
10708	829	643
12681	830	292
12681	830	2647
12681	830	7517
12681	830	7073
12681	830	3644
12681	830	4816
14409	831	392
14409	831	8947
14409	831	1490
14409	831	4411
14409	831	878
14409	831	2640
14409	831	1394
3369	832	9690
3369	832	9111
5509	833	9892
5509	833	4944
5509	833	6088
5509	833	503
5509	833	8394
5509	833	1856
5509	833	4112
13502	834	756
13502	834	934
13502	834	6506
13502	834	166
13502	834	7384
13502	834	8371
13502	834	830
13502	834	5331
13502	834	9708
420	835	2203
420	835	2306
420	835	1041
420	835	3064
420	835	9411
420	835	1291
420	835	522
420	835	967
420	835	3413
3565	836	44
3565	836	381
3565	836	1499
3565	836	9962
3565	836	992
6595	837	3460
6595	837	3888
6595	837	5360
6595	837	3214
6595	837	2975
6595	837	6568
6595	837	2531
14561	838	7362
14561	838	7964
14561	838	6820
14561	838	6812
14561	838	88
14561	838	1109
14561	838	370
14561	838	105
10929	839	1346
15826	840	8258
15826	840	4643
15826	840	5177
15826	840	8539
15826	840	865
15826	840	1065
15826	840	3171
8558	841	8847
8558	841	5374
9618	842	7219
9618	842	4543
9618	842	9130
9618	842	2979
9618	842	6009
9618	842	5777
13281	843	4317
13281	843	3514
13281	843	7355
12404	844	2487
12404	844	6362
7161	845	9595
7161	845	2310
7161	845	4092
7161	845	730
7161	845	2865
7161	845	6509
7161	845	4387
7161	845	5847
7161	845	5888
4133	846	3619
4133	846	2517
4133	846	1311
4133	846	3561
6312	847	5730
6312	847	7619
6312	847	6781
6312	847	8485
6312	847	3254
6312	847	4113
6312	847	771
6312	847	2302
6312	847	2067
11371	848	5666
11371	848	6081
11371	848	7405
11371	848	2383
11371	848	2374
11371	848	7137
11371	848	4571
11371	848	476
7459	849	2830
7459	849	1319
6769	850	9070
6769	850	3273
6769	850	5332
6769	850	3962
6769	850	2425
9596	851	4790
10530	852	8995
10530	852	2537
7709	853	7239
7709	853	7970
7709	853	4218
19097	854	2284
19097	854	1349
19097	854	7817
19097	854	5339
19097	854	4830
13820	855	4915
13820	855	8690
13820	855	6961
13820	855	2909
13820	855	9434
13820	855	507
13820	855	2120
5429	856	5734
5429	856	725
5429	856	3706
5429	856	6156
5429	856	5416
11971	857	9092
12104	858	251
12104	858	3759
12104	858	8308
3013	859	6989
3013	859	6762
3013	859	7875
3013	859	3777
3013	859	9003
3013	859	8057
3013	859	5178
3013	859	4806
9558	860	7660
9558	860	8411
9558	860	1329
9558	860	7296
11776	861	213
11776	861	2927
11776	861	9724
11776	861	2119
11776	861	5895
2144	862	5341
2144	862	2757
2144	862	1405
2144	862	6233
2144	862	1834
2144	862	6535
2144	862	1197
2144	862	5018
10460	863	3318
10460	863	9602
10460	863	1397
9138	864	2547
9138	864	2386
9138	864	7571
9138	864	5720
9138	864	3606
280	865	4900
280	865	6253
280	865	6930
495	866	5683
495	866	2869
495	866	7838
495	866	6027
495	866	1347
495	866	5688
495	866	2202
11615	867	5948
11615	867	6645
11615	867	7343
11615	867	5719
6980	868	863
6980	868	7238
6980	868	1497
6980	868	3169
9030	869	3431
9030	869	2554
3029	870	7158
3029	870	739
3029	870	9775
3029	870	8773
3029	870	9947
3029	870	5842
3029	870	3496
3029	870	4541
3029	870	8155
7227	871	4760
7227	871	6586
7227	871	1805
7227	871	8829
7227	871	422
7227	871	8916
7227	871	487
7227	871	7617
15126	872	8372
15126	872	9484
15126	872	1039
15126	872	621
15126	872	1251
15126	872	2002
17175	873	9118
19077	874	698
19077	874	9947
1018	875	6913
12792	876	4034
12792	876	1075
12792	876	624
12792	876	1295
12792	876	1664
12792	876	9425
12792	876	6771
9819	877	3535
2837	878	1854
2837	878	9454
2837	878	6785
2837	878	5859
2837	878	4394
10034	879	4140
10034	879	2014
10034	879	2454
10034	879	5329
10034	879	3694
10034	879	3789
10034	879	1318
9588	880	5183
3934	881	2785
3934	881	1628
3934	881	3802
3934	881	6281
3934	881	3310
11526	882	8536
11526	882	5184
11526	882	8000
11526	882	5443
11526	882	1295
11526	882	7146
11526	882	1546
11874	883	4722
11874	883	113
12785	884	4686
12785	884	3014
12785	884	4800
12785	884	2535
12785	884	3873
12785	884	6484
12785	884	7179
8648	885	306
8648	885	565
8648	885	3925
8648	885	3288
8648	885	3809
543	886	8239
543	886	6879
543	886	9041
543	886	3021
543	886	9948
14253	887	1450
14253	887	9939
14253	887	4233
14253	887	2739
14253	887	5790
19198	888	9870
19198	888	7738
19198	888	5226
8533	889	7180
8533	889	3670
8533	889	1104
8533	889	4719
9314	890	5161
9314	890	4875
9314	890	3073
9314	890	549
9314	890	9691
9314	890	4060
9314	890	8527
19345	891	3839
19345	891	52
19345	891	139
19345	891	8460
19345	891	3708
19345	891	9514
9349	892	5625
9349	892	9607
9349	892	4462
17044	893	7807
17044	893	4792
17044	893	4845
17044	893	2090
17044	893	6139
9197	894	5545
9197	894	7773
9197	894	1273
9197	894	5747
9197	894	971
9197	894	3071
9197	894	4652
9197	894	3954
9197	894	4783
19149	895	8205
19149	895	9888
19149	895	7437
19149	895	8942
19149	895	5694
6933	896	6302
6933	896	9290
6933	896	8795
6892	897	4823
6892	897	8419
6892	897	6381
6892	897	9963
6892	897	6747
6892	897	8929
15740	898	2356
15740	898	4947
2497	899	8521
2497	899	3868
11783	900	2699
18158	901	3664
18158	901	5336
18158	901	8768
18158	901	462
18158	901	2603
15100	902	8798
15100	902	1019
15100	902	8639
15100	902	8543
15100	902	778
15100	902	4921
15100	902	2725
15100	902	2554
15100	902	5929
2529	903	2387
2529	903	1385
2529	903	2088
2529	903	2539
2673	904	8655
2673	904	4097
2673	904	4315
2673	904	3621
2673	904	8349
2673	904	9680
2673	904	6908
2673	904	7121
2673	904	6873
18518	905	4248
18518	905	6033
18518	905	2242
18518	905	8123
18518	905	3436
18518	905	3496
18518	905	3974
15190	906	3940
1695	907	2902
1695	907	4708
1695	907	8466
1695	907	6222
1695	907	7196
1695	907	9499
1695	907	6480
1695	907	2987
12965	908	4293
12965	908	5966
12965	908	609
12965	908	8066
12965	908	754
12965	908	1045
12965	908	9606
12965	908	2525
17492	909	1001
17492	909	2293
17492	909	7903
4601	910	672
4601	910	4697
4601	910	7394
4601	910	6544
4601	910	7571
17230	911	4367
17230	911	3534
17230	911	2222
17230	911	2883
17230	911	4598
5001	912	4801
5001	912	2940
5001	912	8269
5001	912	2110
5001	912	2941
5001	912	1120
5001	912	5950
5001	912	9126
6984	913	3519
6984	913	289
6984	913	5821
6984	913	1576
6984	913	7387
6984	913	4619
15117	914	5194
15117	914	8173
15117	914	8423
8744	915	1273
8744	915	1263
8744	915	4680
8744	915	4249
8744	915	1181
8744	915	9855
8744	915	6591
2418	916	8768
2418	916	1539
2418	916	6858
2418	916	2095
2418	916	9004
2418	916	9652
2418	916	8510
2418	916	3980
2418	916	2574
13644	917	6891
13644	917	8489
13644	917	725
13644	917	4690
13644	917	2300
13644	917	7242
8197	918	9378
8197	918	252
8197	918	7825
8197	918	9953
8197	918	8533
8197	918	464
8197	918	9349
8197	918	8817
8197	918	7574
16595	919	8451
16595	919	7866
16595	919	6715
16595	919	9790
18335	920	8196
18335	920	3807
18335	920	2448
18335	920	675
18335	920	5422
8477	921	1543
8477	921	2872
8477	921	390
8477	921	4996
8477	921	7013
13605	922	5970
13605	922	3377
13605	922	5437
13605	922	2313
13605	922	9521
13605	922	795
13605	922	3011
13605	922	9181
1447	923	2843
1447	923	6563
1447	923	3897
1447	923	9548
1447	923	377
12693	924	511
12693	924	6324
12693	924	9638
12693	924	5811
12693	924	788
12693	924	8228
12693	924	8094
12693	924	692
12693	924	5839
4802	925	5976
4802	925	320
4802	925	2443
17519	926	513
17519	926	6033
17519	926	7394
16362	927	8149
16362	927	9408
16362	927	2105
16362	927	2375
16362	927	7648
16362	927	3980
16362	927	4665
16362	927	9976
5348	928	5884
5348	928	7157
5348	928	6531
5348	928	3761
5348	928	2731
5348	928	5924
10664	929	578
10664	929	6383
10664	929	5840
10664	929	1848
10664	929	4661
10086	930	651
10086	930	9858
10086	930	2297
10086	930	2358
10176	931	5968
10176	931	4757
10176	931	8955
10176	931	7782
10176	931	3560
10176	931	5699
10176	931	4125
10176	931	7230
10176	931	5401
12103	932	3859
12103	932	1461
12103	932	460
12103	932	1304
12103	932	4388
18289	933	4479
18289	933	8897
18289	933	4361
18289	933	3446
1351	934	2402
9018	935	8912
18743	936	313
18743	936	5053
18743	936	463
18743	936	8479
18743	936	8751
18743	936	2981
18743	936	1971
18743	936	1597
3636	937	7254
3636	937	4011
3636	937	3948
3636	937	9731
3636	937	2294
3636	937	8208
3636	937	7981
3636	937	7525
3636	937	1272
46	938	3134
46	938	2791
46	938	2275
46	938	6548
46	938	9394
46	938	3237
14368	939	7610
14368	939	7955
11869	940	4378
11869	940	4755
11869	940	374
11869	940	4127
11869	940	3484
11869	940	8238
11869	940	6809
11869	940	5311
17094	941	5731
6681	942	9158
6681	942	5331
6681	942	4532
6681	942	8587
6681	942	7470
6681	942	7419
6681	942	2468
6681	942	8514
6681	942	6660
3941	943	517
3941	943	4226
3941	943	7062
3941	943	9588
17491	944	6982
11138	945	4529
11138	945	9167
11138	945	9534
11138	945	7701
11138	945	3003
11138	945	8164
11138	945	7267
2984	946	7159
2984	946	4333
2984	946	3261
484	947	5811
484	947	286
484	947	3499
6065	948	9226
6065	948	8228
6065	948	4661
6065	948	6070
6065	948	6987
8291	949	6367
8291	949	9093
8291	949	9014
8291	949	1698
8291	949	7614
8291	949	5164
8291	949	1437
17138	950	8705
17138	950	759
17138	950	1258
17138	950	3681
13427	951	4079
13427	951	2109
13427	951	7738
13427	951	5918
7063	952	4644
17575	953	2158
17575	953	6910
16334	954	6411
16334	954	3888
16334	954	907
16334	954	7555
16334	954	1136
16334	954	4138
16334	954	4729
12296	955	9004
12296	955	4016
12296	955	5949
12296	955	556
12296	955	9089
17667	956	6403
17667	956	6234
17667	956	3077
17667	956	325
17667	956	9082
17667	956	1266
17667	956	4545
11476	957	541
11476	957	9389
11476	957	7265
11476	957	9347
11476	957	3994
11476	957	5187
11476	957	7805
11476	957	328
11476	957	8899
18447	958	3685
18447	958	718
18447	958	731
18447	958	3968
18447	958	9636
18447	958	8900
18447	958	998
688	959	715
688	959	8178
688	959	9294
16386	960	7417
2202	961	9331
2202	961	8685
2202	961	6943
2202	961	7806
2202	961	7344
2202	961	2007
2202	961	9147
2202	961	9272
14898	962	5954
14898	962	9716
14264	963	8233
14264	963	6624
14264	963	4927
14264	963	861
14264	963	3628
14264	963	7711
14264	963	7469
14264	963	7282
13106	964	4002
13106	964	7995
13106	964	5795
13106	964	7819
13106	964	4842
13106	964	5731
4709	965	7663
4709	965	7790
4709	965	163
4709	965	2261
4709	965	5219
4709	965	4248
1449	966	5582
2753	967	8493
2753	967	3076
2753	967	9551
2753	967	6579
2753	967	9992
2753	967	1684
2753	967	5531
2753	967	3283
17002	968	7962
17002	968	4450
17002	968	3526
17002	968	7820
18911	969	5933
18911	969	4124
18911	969	8595
18911	969	5670
18911	969	4942
18911	969	6368
18911	969	9201
18911	969	8264
18911	969	8151
12225	970	6
12225	970	6885
12225	970	6129
12225	970	7281
12225	970	8192
12225	970	2102
12225	970	8696
8731	971	1719
8731	971	8431
8731	971	5299
8731	971	9598
8731	971	2291
8731	971	9562
8731	971	8856
8731	971	3866
19988	972	7571
19988	972	7886
19988	972	4537
19988	972	368
19988	972	946
5330	973	3584
5330	973	638
5330	973	4045
5330	973	5184
8078	974	9778
8078	974	8102
8078	974	5238
8078	974	6031
8078	974	5345
8078	974	9704
8078	974	8121
8078	974	5361
1316	975	1254
1316	975	80
1316	975	1141
1316	975	8904
1316	975	9302
1316	975	3492
1316	975	2642
15760	976	1003
15760	976	9486
15760	976	8323
15760	976	1355
15760	976	1240
15760	976	4341
15760	976	1567
15760	976	7029
15760	976	893
19594	977	1874
19594	977	5289
19594	977	8636
19594	977	2395
19594	977	7095
19594	977	8511
13666	978	516
13666	978	127
13666	978	4241
13666	978	452
13666	978	3338
492	979	6456
492	979	32
492	979	7529
19847	980	3321
19847	980	3597
19847	980	9911
19847	980	2882
19847	980	3209
19847	980	5283
19847	980	4701
16076	981	8284
16076	981	1144
16076	981	1232
16076	981	6484
16076	981	9841
16076	981	8684
16076	981	3420
16076	981	7485
14791	982	7822
14791	982	5317
14791	982	5456
8347	983	2328
8347	983	4134
8347	983	1078
8347	983	4645
8347	983	4126
8347	983	3965
14770	984	4401
14770	984	3774
14770	984	6550
14770	984	7207
14770	984	4699
14770	984	1883
19874	985	6275
19874	985	2634
19874	985	8953
19874	985	4913
19874	985	1764
19874	985	5888
19874	985	6262
19874	985	7035
19874	985	4941
2980	986	3356
2980	986	9731
2980	986	639
2980	986	5175
2980	986	5728
2980	986	3679
2980	986	8802
7429	987	2592
7429	987	8060
7429	987	2296
7429	987	9516
7429	987	5902
7429	987	8727
7429	987	6446
12352	988	2741
12352	988	6135
12352	988	3945
12352	988	6830
12352	988	2443
12352	988	6461
18105	989	7906
18105	989	3027
18105	989	9280
18105	989	6799
18105	989	7233
18105	989	88
18105	989	9420
18105	989	8681
9629	990	4627
9629	990	6595
9629	990	9928
9629	990	5222
9937	991	7012
12582	992	4297
12582	992	7476
12582	992	9557
12582	992	1792
3390	993	5543
3390	993	7143
3390	993	4747
3390	993	5193
3390	993	6870
3390	993	4936
3390	993	7312
3390	993	5360
3390	993	8239
5070	994	6919
5070	994	3348
5070	994	9758
5070	994	406
5070	994	2087
5070	994	485
10462	995	5199
10462	995	577
10462	995	7770
6257	996	8175
279	997	1661
279	997	8484
279	997	3813
279	997	4226
279	997	4837
279	997	5128
279	997	9941
279	997	6199
279	997	4595
4728	998	5493
4728	998	7674
4728	998	8909
4728	998	3806
4728	998	301
4728	998	8381
4728	998	6884
2218	999	5820
2218	999	5431
2218	999	4647
18482	1000	1605
18482	1000	3527
18482	1000	367
18482	1000	764
18482	1000	1729
18482	1000	6246
19356	1001	4380
19356	1001	3538
19356	1001	2678
19356	1001	4440
19356	1001	1777
19356	1001	5667
19356	1001	2599
19356	1001	9182
19356	1001	8996
9043	1002	9276
9043	1002	1402
9043	1002	7382
9043	1002	594
9043	1002	2636
9043	1002	6816
9043	1002	7872
9043	1002	8425
403	1003	5819
403	1003	5462
403	1003	2676
403	1003	753
403	1003	8979
16509	1004	9171
16509	1004	769
16509	1004	6597
16509	1004	4738
16509	1004	9576
16509	1004	2906
16509	1004	4920
10292	1005	7971
10292	1005	9020
10292	1005	8072
10292	1005	8465
8489	1006	1426
8489	1006	6997
7186	1007	7006
7186	1007	1585
7186	1007	3173
7186	1007	2607
7186	1007	1651
7186	1007	5394
7186	1007	4376
7186	1007	268
7186	1007	4186
17328	1008	711
17328	1008	9275
17328	1008	6596
17328	1008	1300
17328	1008	2490
8149	1009	579
4458	1010	1851
4458	1010	1719
4458	1010	8405
4458	1010	851
4458	1010	4568
4458	1010	2702
4458	1010	8229
9649	1011	7017
9649	1011	2589
9649	1011	2054
9649	1011	4919
13660	1012	4136
13660	1012	9165
13660	1012	8830
19359	1013	3507
19359	1013	1605
19359	1013	147
19359	1013	6560
19359	1013	8873
19359	1013	3616
11339	1014	8302
11339	1014	9706
11339	1014	7096
12519	1015	3828
12519	1015	8383
12519	1015	7780
12519	1015	7467
12519	1015	3624
12519	1015	3973
12519	1015	3250
12519	1015	3760
3433	1016	4592
3433	1016	458
3433	1016	4000
3433	1016	8139
3433	1016	3813
3433	1016	2577
1918	1017	2848
1918	1017	6450
1918	1017	2017
1918	1017	6655
1918	1017	3268
1918	1017	2133
1918	1017	2130
13443	1018	1019
13443	1018	2154
13443	1018	3377
13443	1018	6991
13443	1018	3605
1083	1019	4944
1083	1019	6230
1083	1019	216
1083	1019	2227
1083	1019	3297
1083	1019	1056
1083	1019	9026
1083	1019	2148
1083	1019	9799
3904	1020	7918
3904	1020	3362
3904	1020	5591
3904	1020	2064
3904	1020	31
3904	1020	8726
3904	1020	3968
12389	1021	553
12389	1021	7866
12389	1021	8678
16953	1022	429
16953	1022	5550
16953	1022	4818
16953	1022	9868
16953	1022	9183
16953	1022	9341
16953	1022	8939
16953	1022	5473
9231	1023	7055
9231	1023	2909
9231	1023	9232
9231	1023	4935
9231	1023	63
9231	1023	1480
9231	1023	3619
9231	1023	8836
9231	1023	5939
10243	1024	4335
10243	1024	6250
10243	1024	2479
10243	1024	4423
10243	1024	2687
10243	1024	1232
10243	1024	6398
10243	1024	7181
14487	1025	7734
14487	1025	2310
14487	1025	1503
14487	1025	5273
14487	1025	3371
15410	1026	7512
15410	1026	8037
15410	1026	9538
15410	1026	3411
15410	1026	6318
6997	1027	742
6997	1027	316
6997	1027	3654
6997	1027	5044
6997	1027	875
8489	1028	1949
8489	1028	8813
8489	1028	9660
8489	1028	1394
9608	1029	4612
9608	1029	7387
9608	1029	6234
9608	1029	6340
19986	1030	5150
19986	1030	1961
16366	1031	9885
16366	1031	5703
16366	1031	345
16366	1031	8742
16366	1031	1900
16366	1031	1804
18380	1032	7318
18380	1032	2689
18380	1032	8596
18380	1032	5565
18380	1032	1913
18380	1032	4397
18161	1033	2577
18161	1033	5137
18161	1033	5246
18161	1033	837
18161	1033	2585
18161	1033	3657
11841	1034	4524
11841	1034	3066
11841	1034	3182
11841	1034	6865
11841	1034	6155
11841	1034	1299
11841	1034	342
11841	1034	7455
11841	1034	1896
14282	1035	4286
14282	1035	9314
14282	1035	1543
14282	1035	3863
14282	1035	290
14282	1035	1491
14282	1035	1505
16738	1036	9630
16738	1036	2
16738	1036	4811
16738	1036	2889
16738	1036	46
16738	1036	3848
16738	1036	5401
16738	1036	5565
14214	1037	7279
14214	1037	8324
14214	1037	9503
14214	1037	3442
14214	1037	8197
14214	1037	9627
14214	1037	4272
14214	1037	7797
14214	1037	7083
14256	1038	3641
14256	1038	7769
14256	1038	9527
14256	1038	6312
14256	1038	3782
14256	1038	1532
14256	1038	2360
14256	1038	1933
14256	1038	2522
4296	1039	1775
4296	1039	2363
4296	1039	6437
11696	1040	660
11696	1040	8830
11696	1040	9400
11696	1040	5570
11696	1040	8731
11696	1040	5286
11696	1040	8135
11696	1040	6891
11696	1040	7347
10604	1041	1054
10604	1041	3436
10604	1041	9691
10604	1041	3338
10604	1041	9046
15751	1042	3016
15751	1042	5613
15751	1042	6852
9973	1043	5643
9973	1043	5625
9973	1043	764
9973	1043	3026
9973	1043	6343
9973	1043	9308
9973	1043	5882
9973	1043	3511
9973	1043	6643
1648	1044	575
1648	1044	7565
1648	1044	5486
1648	1044	2413
1648	1044	127
1648	1044	9064
19654	1045	1645
19654	1045	5989
19654	1045	2930
19654	1045	3598
19654	1045	6798
19654	1045	2983
19654	1045	1064
19654	1045	5419
19654	1045	6546
4062	1046	5632
4062	1046	9534
12070	1047	5562
12070	1047	6711
12070	1047	7119
12070	1047	3420
12070	1047	6080
12070	1047	955
12070	1047	9818
12070	1047	1020
12070	1047	3657
5442	1048	4199
5442	1048	5112
8744	1049	4187
8744	1049	610
8744	1049	6879
8744	1049	537
13232	1050	5678
13232	1050	1416
13232	1050	5568
13232	1050	4263
13232	1050	7793
13232	1050	5388
13232	1050	9086
13232	1050	5723
13232	1050	4871
18115	1051	9955
18115	1051	1789
18115	1051	7995
18115	1051	7108
5570	1052	9483
7490	1053	7603
7490	1053	5902
7490	1053	4083
7490	1053	5696
18294	1054	3208
18294	1054	5627
18294	1054	8456
18294	1054	5228
18294	1054	2131
18294	1054	8348
18294	1054	5902
18294	1054	5383
7157	1055	7162
7157	1055	5867
7157	1055	3454
7157	1055	198
7157	1055	710
7157	1055	8498
7157	1055	6174
7157	1055	8913
7157	1055	7745
19751	1056	848
19751	1056	6370
19751	1056	6918
19751	1056	9808
19751	1056	7124
19751	1056	4676
19751	1056	8214
19751	1056	4552
10522	1057	9178
10522	1057	1318
10522	1057	7422
10522	1057	2231
10522	1057	8938
10522	1057	6154
10522	1057	6127
6089	1058	5891
6089	1058	2791
6089	1058	581
6089	1058	8696
6089	1058	9417
6089	1058	394
19142	1059	7662
19142	1059	4964
19142	1059	3864
19142	1059	1120
19142	1059	3685
19142	1059	2541
6017	1060	600
6017	1060	6747
6017	1060	9316
6017	1060	6314
6017	1060	2834
6017	1060	4768
7192	1061	9846
7192	1061	3830
7192	1061	2182
7192	1061	3727
12535	1062	9276
12535	1062	8666
12535	1062	9396
17422	1063	7443
17422	1063	4076
17422	1063	1106
17422	1063	5806
17422	1063	4292
17422	1063	2706
17422	1063	9361
6176	1064	9355
6176	1064	7750
6176	1064	7404
6176	1064	8506
6176	1064	1829
5367	1065	6372
5367	1065	5162
5367	1065	1359
11299	1066	3771
11299	1066	9495
11299	1066	9066
11299	1066	2106
11299	1066	6568
7941	1067	769
7941	1067	5118
7941	1067	783
7941	1067	9231
7941	1067	3053
7941	1067	4631
13064	1068	1139
13064	1068	7954
14040	1069	5441
14040	1069	2631
14040	1069	1420
4377	1070	8467
4377	1070	5212
4377	1070	4937
19135	1071	6099
19135	1071	9422
19135	1071	6568
19135	1071	7871
19135	1071	4395
19135	1071	14
19135	1071	6202
15242	1072	9810
16553	1073	5974
16553	1073	7013
16553	1073	835
16553	1073	5508
16553	1073	2426
16553	1073	4170
16553	1073	2304
16553	1073	6231
12489	1074	8890
12489	1074	4616
12489	1074	9230
12489	1074	8984
12489	1074	2701
12489	1074	1515
12489	1074	6581
14830	1075	4348
14830	1075	7172
14830	1075	9634
11729	1076	2109
11729	1076	8345
5920	1077	7385
171	1078	8760
171	1078	3597
171	1078	9727
171	1078	7738
171	1078	2455
4177	1079	7953
4177	1079	4499
4177	1079	3259
9638	1080	5609
9638	1080	2909
9638	1080	3274
4066	1081	7528
4066	1081	9644
4066	1081	4750
4066	1081	175
4066	1081	4187
4066	1081	489
4066	1081	5114
4066	1081	2199
6514	1082	5749
6514	1082	6822
6514	1082	7963
6514	1082	7296
16491	1083	8922
16491	1083	4921
16491	1083	1769
16491	1083	1012
16491	1083	9654
16491	1083	8094
16491	1083	6487
16491	1083	3139
16491	1083	3549
18594	1084	7954
18594	1084	4867
18594	1084	5287
18594	1084	3494
18594	1084	6650
3141	1085	6666
3141	1085	2708
3141	1085	8597
3141	1085	1086
3141	1085	1093
3141	1085	9401
3141	1085	552
11359	1086	8770
11359	1086	7141
1269	1087	3050
18272	1088	6233
18272	1088	5190
18272	1088	4614
18272	1088	9913
18272	1088	499
18272	1088	348
18272	1088	6664
18272	1088	6730
10998	1089	9555
10998	1089	3953
10998	1089	396
5202	1090	1472
5202	1090	8195
5202	1090	7200
5202	1090	2936
6869	1091	4485
6869	1091	3149
6869	1091	1875
6869	1091	6713
6869	1091	2645
6869	1091	7413
6869	1091	5191
6869	1091	3600
19473	1092	2107
19473	1092	8542
2954	1093	4911
2954	1093	1229
2954	1093	5929
15606	1094	5454
15606	1094	3589
15606	1094	2946
15606	1094	676
15606	1094	7246
15606	1094	6282
15606	1094	2966
3014	1095	2984
3014	1095	7353
3014	1095	6951
3014	1095	7290
3014	1095	2958
13324	1096	3011
13324	1096	9003
13324	1096	7589
13324	1096	2502
13324	1096	763
13324	1096	4928
12126	1097	1049
12126	1097	8974
12126	1097	6113
12126	1097	6982
12126	1097	8804
18972	1098	5622
18972	1098	5333
18972	1098	5569
18972	1098	4302
18972	1098	7756
18972	1098	6852
8044	1099	8886
8044	1099	2244
8044	1099	8195
8044	1099	3784
5174	1100	2073
5174	1100	9583
5174	1100	1330
13796	1101	4967
13796	1101	1682
13796	1101	8275
13796	1101	5841
13796	1101	4499
13796	1101	6813
10016	1102	185
10016	1102	8955
10016	1102	9917
10016	1102	7019
10016	1102	8721
10016	1102	4416
4505	1103	7845
12237	1104	3138
12237	1104	2598
12237	1104	1053
12237	1104	4959
12237	1104	1549
12237	1104	3007
12237	1104	444
12237	1104	1530
501	1105	1289
501	1105	9092
501	1105	1271
501	1105	8285
501	1105	3054
501	1105	1175
501	1105	2408
6920	1106	9611
5234	1107	5541
5234	1107	4149
5234	1107	2785
5234	1107	4804
5234	1107	1017
5234	1107	3020
5234	1107	830
7766	1108	74
7766	1108	536
7766	1108	5269
7766	1108	7315
7766	1108	9991
7766	1108	7496
7766	1108	242
8781	1109	4350
8781	1109	388
8781	1109	9698
8781	1109	7654
8781	1109	4712
8781	1109	4411
8968	1110	699
16025	1111	1569
3621	1112	6201
3621	1112	863
3621	1112	3403
3621	1112	5917
3621	1112	4658
18737	1113	3481
18737	1113	2522
18737	1113	7366
18737	1113	590
18737	1113	1233
18737	1113	7422
18737	1113	219
18737	1113	4611
1624	1114	1362
1624	1114	5101
1624	1114	919
1624	1114	850
15328	1115	4486
15328	1115	2008
15328	1115	8326
19116	1116	2359
19116	1116	5111
19116	1116	6290
19116	1116	7781
19116	1116	1949
19116	1116	8525
19116	1116	6421
14541	1117	4934
14541	1117	8541
14541	1117	1681
14541	1117	1271
14541	1117	3145
14541	1117	9564
3843	1118	8891
3843	1118	398
3843	1118	8866
14780	1119	6834
14780	1119	9505
14780	1119	2138
1356	1120	1226
1356	1120	9084
1356	1120	5648
1356	1120	6767
1356	1120	568
1356	1120	5137
1356	1120	6797
1356	1120	6129
1356	1120	7882
14555	1121	3481
14555	1121	709
14555	1121	8119
14555	1121	6296
14555	1121	7184
14555	1121	7104
14555	1121	1891
14555	1121	4914
14555	1121	5588
1449	1122	6259
1449	1122	9752
1449	1122	3010
1449	1122	1418
9797	1123	517
9797	1123	1504
9797	1123	961
9797	1123	4334
12447	1124	4881
12447	1124	5348
12447	1124	7125
12447	1124	6265
12447	1124	1355
12447	1124	7524
12447	1124	8820
12447	1124	1550
12447	1124	3840
8712	1125	1169
8712	1125	5096
8712	1125	426
8712	1125	1725
8712	1125	9917
8712	1125	7641
9531	1126	8149
9531	1126	1059
9531	1126	1269
9531	1126	4614
9531	1126	1387
12585	1127	2702
12585	1127	8999
12585	1127	9478
12585	1127	7847
12585	1127	664
12585	1127	7808
13172	1128	1629
13172	1128	5482
13172	1128	6890
13172	1128	2566
13172	1128	9568
13172	1128	9956
13172	1128	245
13172	1128	1439
875	1129	9862
875	1129	7422
875	1129	6353
875	1129	8829
875	1129	1815
875	1129	7956
6874	1130	187
19508	1131	4556
19508	1131	4228
1938	1132	7188
1938	1132	5173
1938	1132	6818
1938	1132	9838
1938	1132	904
1938	1132	7544
1316	1133	663
1316	1133	9921
5138	1134	5463
5138	1134	2786
5138	1134	8830
5138	1134	7885
5138	1134	5510
5138	1134	626
5138	1134	4582
10970	1135	4344
10970	1135	6174
10970	1135	8433
10970	1135	9121
10970	1135	9006
5279	1136	501
5279	1136	7687
5279	1136	149
5279	1136	5347
5279	1136	8629
5279	1136	7986
11916	1137	1474
11916	1137	5758
11916	1137	9678
11916	1137	4484
11916	1137	2545
11916	1137	154
11916	1137	6129
11916	1137	9851
15075	1138	3109
15075	1138	5039
15075	1138	7279
15075	1138	4947
15075	1138	8982
15075	1138	2263
15075	1138	6680
15075	1138	8103
15075	1138	2212
9511	1139	8222
9511	1139	3609
9511	1139	8833
9511	1139	5610
9511	1139	2222
14521	1140	285
14521	1140	7089
14521	1140	9044
14521	1140	9722
15648	1141	411
15648	1141	4338
15648	1141	2544
15648	1141	8690
15648	1141	632
15648	1141	8994
15648	1141	2315
15648	1141	4960
15648	1141	8475
17518	1142	8025
17518	1142	8226
17518	1142	5582
17518	1142	5570
17518	1142	5180
17518	1142	4898
17518	1142	2465
17518	1142	2077
5417	1143	8950
5417	1143	3802
5417	1143	9403
2377	1144	63
16577	1145	3886
16577	1145	3243
16577	1145	8354
16577	1145	8583
16577	1145	5582
16577	1145	1973
1300	1146	1641
1300	1146	6227
1300	1146	7840
17750	1147	7935
17750	1147	582
17750	1147	1268
9019	1148	2650
9019	1148	6285
9019	1148	2775
9019	1148	7406
9019	1148	8907
1095	1149	1591
1095	1149	236
1095	1149	1447
1095	1149	6115
1095	1149	1612
5758	1150	7389
5758	1150	6700
5970	1151	1243
5970	1151	5728
5970	1151	4842
5970	1151	697
5970	1151	8873
5970	1151	2145
5970	1151	6108
5970	1151	5033
5970	1151	2972
14184	1152	8325
10050	1153	8010
10050	1153	1175
13805	1154	1089
13805	1154	5305
13805	1154	2384
13805	1154	9069
13805	1154	1040
13805	1154	713
19262	1155	9713
8981	1156	6080
8981	1156	9345
8981	1156	1715
8981	1156	4157
10492	1157	5207
10492	1157	8719
19517	1158	3770
19517	1158	2431
19517	1158	9391
13139	1159	697
13139	1159	1218
13139	1159	9967
13139	1159	275
13139	1159	4047
13139	1159	9369
13139	1159	7511
13139	1159	8855
1883	1160	3741
1883	1160	6351
1883	1160	4631
1883	1160	8314
1883	1160	2310
1883	1160	7687
1883	1160	7659
15251	1161	1749
15251	1161	9563
15251	1161	1142
19993	1162	938
19993	1162	1773
19993	1162	9045
19993	1162	850
19993	1162	3863
12344	1163	9178
4450	1164	5547
10219	1165	2182
10219	1165	8055
10219	1165	2496
10219	1165	4771
10219	1165	3670
10219	1165	2391
10219	1165	7491
10219	1165	3683
15583	1166	9559
15583	1166	3828
18750	1167	4485
18750	1167	5598
18750	1167	303
18750	1167	2149
18750	1167	2644
18750	1167	7067
18750	1167	735
16451	1168	8323
16451	1168	2306
16451	1168	9738
16451	1168	8302
16451	1168	816
1815	1169	3259
1815	1169	4091
1815	1169	5713
1815	1169	6359
1815	1169	3158
1815	1169	4669
1815	1169	2882
17184	1170	6727
12930	1171	31
12930	1171	6379
12930	1171	5908
12930	1171	395
12930	1171	4903
12930	1171	2727
12930	1171	724
7763	1172	7775
7763	1172	9139
7763	1172	3983
7763	1172	333
18972	1173	6941
18972	1173	660
18972	1173	175
18972	1173	6162
18972	1173	5733
18972	1173	5055
11557	1174	9660
14868	1175	7326
14868	1175	2579
14868	1175	136
14868	1175	7144
8170	1176	7404
7131	1177	4630
7131	1177	1131
7131	1177	6092
11502	1178	3185
11502	1178	4667
14491	1179	1299
14491	1179	1039
14491	1179	9397
14491	1179	1382
16641	1180	992
16641	1180	5814
16641	1180	1304
16641	1180	795
16641	1180	7655
1679	1181	1350
1679	1181	1413
1679	1181	1013
1679	1181	4831
8455	1182	1028
8455	1182	3423
8455	1182	3347
8455	1182	6390
8455	1182	6536
14661	1183	6851
14661	1183	9559
14661	1183	9621
14661	1183	7823
14661	1183	426
14661	1183	3744
14661	1183	888
14661	1183	9484
1023	1184	1906
1023	1184	404
1023	1184	8844
1023	1184	5988
1023	1184	4270
1023	1184	8627
16369	1185	9093
16369	1185	8046
16369	1185	8319
16369	1185	4774
16369	1185	9253
16369	1185	7698
16369	1185	4768
13347	1186	4969
13347	1186	5153
13347	1186	2472
13347	1186	2896
13347	1186	543
13347	1186	9283
13347	1186	7301
13347	1186	1687
11	1187	9212
11	1187	6923
11	1187	8208
12033	1188	4230
12033	1188	7229
12033	1188	4288
12033	1188	8805
12033	1188	799
161	1189	8455
161	1189	118
161	1189	3242
161	1189	9012
161	1189	3640
3695	1190	7864
4187	1191	1475
4187	1191	1901
5398	1192	2780
5398	1192	3034
5398	1192	4413
5398	1192	7580
5398	1192	404
5398	1192	107
5398	1192	2526
5398	1192	5891
7510	1193	5848
7510	1193	6947
7510	1193	9064
7510	1193	7602
7510	1193	1547
8651	1194	5559
8651	1194	4300
9407	1195	8748
9276	1196	8393
9276	1196	4568
9276	1196	4001
9276	1196	1563
9276	1196	362
9276	1196	2918
9276	1196	6392
9276	1196	6234
9276	1196	2181
12961	1197	1184
12961	1197	8658
12961	1197	6917
12961	1197	4569
12961	1197	8524
12961	1197	7867
12961	1197	7202
12961	1197	4606
9934	1198	6875
9934	1198	8881
9934	1198	9115
9934	1198	4900
9934	1198	7541
9934	1198	4807
9934	1198	4491
9934	1198	8655
6447	1199	6184
6771	1200	2150
6771	1200	3355
6771	1200	3241
6771	1200	4398
6771	1200	3337
6771	1200	3182
6771	1200	239
6771	1200	8066
5112	1201	3963
5112	1201	1325
5112	1201	1368
5112	1201	3288
5112	1201	894
5112	1201	3539
5112	1201	9142
5112	1201	3120
15035	1202	1030
2536	1203	6313
2536	1203	9314
2536	1203	5954
2536	1203	5498
2536	1203	7968
2536	1203	4787
2536	1203	2016
11109	1204	2447
11109	1204	6527
11109	1204	9359
11109	1204	26
17436	1205	5476
17436	1205	4973
17436	1205	2790
17436	1205	8065
17436	1205	8204
17436	1205	5153
17436	1205	7287
4582	1206	6436
4582	1206	9233
4582	1206	4738
4582	1206	3993
4582	1206	8981
4582	1206	3481
4582	1206	9825
9594	1207	5723
9594	1207	9683
9670	1208	2004
9670	1208	7420
9670	1208	2978
9670	1208	9896
9670	1208	6819
1622	1209	3517
1622	1209	420
1622	1209	1833
1622	1209	8138
1622	1209	420
1622	1209	7388
1622	1209	7787
1622	1209	4937
1622	1209	359
15558	1210	1635
15558	1210	5477
15558	1210	6196
11184	1211	8468
11184	1211	6121
11184	1211	5506
11851	1212	6027
11851	1212	8495
11851	1212	609
1797	1213	4165
1797	1213	1133
1797	1213	6720
1797	1213	5921
1797	1213	2920
1797	1213	8763
1797	1213	8464
1797	1213	1688
1797	1213	9142
14521	1214	3166
14521	1214	6885
14521	1214	8178
14521	1214	4673
14521	1214	4358
14521	1214	3076
19592	1215	5779
19592	1215	6382
19592	1215	7126
19592	1215	9426
17134	1216	5827
17134	1216	4629
17134	1216	6533
17134	1216	2768
17134	1216	6302
17134	1216	9519
17134	1216	6277
17134	1216	6150
17935	1217	4706
17935	1217	2711
17935	1217	382
17935	1217	645
17935	1217	704
17935	1217	7904
17935	1217	4232
17935	1217	5523
16580	1218	5730
4012	1219	6762
4012	1219	6122
4012	1219	8146
4012	1219	1454
4012	1219	2659
4012	1219	2994
4012	1219	1030
17867	1220	1466
17867	1220	5321
17867	1220	4039
17867	1220	5858
17867	1220	5787
6746	1221	3350
6746	1221	4452
6746	1221	967
6746	1221	2353
6746	1221	7739
6746	1221	6929
6746	1221	9042
6746	1221	7703
18336	1222	4679
18336	1222	7927
18336	1222	8822
18336	1222	7400
18336	1222	7085
18336	1222	9130
18336	1222	1557
5048	1223	6150
5048	1223	9627
5048	1223	5993
5048	1223	332
4285	1224	9275
4285	1224	2006
4285	1224	8077
10953	1225	6894
10953	1225	8433
10953	1225	4132
10953	1225	975
10953	1225	4644
10953	1225	840
10953	1225	201
10953	1225	2939
1749	1226	3826
1749	1226	928
1749	1226	9149
1749	1226	6659
16161	1227	8631
16161	1227	9825
1598	1228	7923
1598	1228	5769
17415	1229	9582
17415	1229	7961
17415	1229	3277
17415	1229	9239
17415	1229	7893
4746	1230	3747
7142	1231	4370
7142	1231	5394
7142	1231	8964
7142	1231	415
18139	1232	398
18139	1232	2857
18139	1232	4433
18139	1232	6099
18139	1232	7992
18139	1232	4698
18139	1232	9135
18139	1232	4576
18139	1232	2015
12770	1233	8677
12770	1233	6625
12770	1233	3668
12770	1233	8162
12770	1233	5943
17599	1234	894
17599	1234	3555
16505	1235	6697
16505	1235	2226
16505	1235	5375
16505	1235	5096
16505	1235	7758
16505	1235	7723
2781	1236	2643
18880	1237	670
18880	1237	148
14130	1238	3117
14130	1238	1680
14130	1238	7885
14130	1238	7638
14130	1238	4121
14130	1238	6754
19237	1239	644
457	1240	2045
457	1240	9597
457	1240	211
5376	1241	1862
5376	1241	7715
5376	1241	9975
8192	1242	5940
8192	1242	9098
8192	1242	1176
8192	1242	5051
8192	1242	9971
8192	1242	1730
8192	1242	6354
8192	1242	4207
8192	1242	6319
15120	1243	481
15120	1243	860
7173	1244	3067
7173	1244	175
7173	1244	9665
7173	1244	1906
7173	1244	9995
7173	1244	5084
7173	1244	3891
7173	1244	3051
7173	1244	8002
14510	1245	8369
14510	1245	950
14510	1245	7865
14510	1245	2815
14510	1245	9505
14510	1245	2907
14510	1245	8045
19902	1246	1827
11435	1247	3815
11435	1247	5168
11435	1247	9064
11435	1247	2774
11435	1247	9505
11435	1247	6661
18952	1248	5357
18952	1248	2760
18952	1248	5264
5101	1249	4921
5101	1249	896
5101	1249	3359
5101	1249	536
5101	1249	86
5719	1250	6583
318	1251	3240
318	1251	9974
318	1251	1926
318	1251	9787
318	1251	7788
318	1251	457
318	1251	2158
11034	1252	4043
11034	1252	1570
17201	1253	2293
17201	1253	5749
17201	1253	9571
17201	1253	3985
17201	1253	4986
17201	1253	4782
5139	1254	5277
5139	1254	2998
18120	1255	5208
8431	1256	9805
11108	1257	4542
11108	1257	1949
11108	1257	6498
15373	1258	9332
15373	1258	5198
15373	1258	1287
15373	1258	1388
13191	1259	811
13191	1259	9628
13191	1259	212
13191	1259	6169
13191	1259	4865
13191	1259	7402
13191	1259	238
13191	1259	3545
13191	1259	1585
1832	1260	3245
1832	1260	5648
1832	1260	8675
1832	1260	1228
4076	1261	2654
4076	1261	150
4076	1261	4987
4076	1261	9533
4076	1261	1828
4076	1261	6287
4076	1261	4307
5028	1262	5919
5028	1262	4343
5028	1262	6664
5028	1262	544
5028	1262	1911
5028	1262	9929
5164	1263	1405
5164	1263	1457
5164	1263	5418
5164	1263	707
5164	1263	8657
5164	1263	9575
16723	1264	393
16723	1264	5012
16723	1264	9868
16723	1264	4947
9751	1265	7458
17723	1266	9798
17723	1266	1637
17723	1266	9845
17723	1266	5518
17723	1266	7165
17723	1266	7781
17723	1266	6492
17723	1266	6523
12780	1267	8168
19634	1268	9510
19634	1268	1368
19634	1268	6920
17113	1269	8850
12028	1270	5687
12028	1270	5589
12028	1270	8228
12028	1270	8599
12028	1270	991
12028	1270	6505
12028	1270	6583
12184	1271	8325
12184	1271	1082
12184	1271	2220
12184	1271	8915
12184	1271	9941
12184	1271	7084
12184	1271	5965
12184	1271	6899
12184	1271	4978
7152	1272	342
7152	1272	9402
7152	1272	5092
7152	1272	3017
2682	1273	38
2682	1273	1698
2682	1273	8787
2682	1273	7502
2682	1273	1812
2682	1273	8640
2682	1273	5020
2682	1273	3835
2682	1273	7193
15070	1274	4459
14951	1275	8816
14951	1275	4909
14951	1275	1304
14951	1275	7806
14951	1275	8243
14951	1275	5961
9200	1276	8217
9200	1276	1182
9200	1276	6845
9200	1276	2945
14806	1277	4878
7388	1278	2548
706	1279	5660
706	1279	5952
706	1279	7887
706	1279	8227
706	1279	7313
706	1279	1513
8913	1280	1860
8913	1280	3600
8913	1280	8767
8913	1280	431
5956	1281	3331
5956	1281	4346
5956	1281	2546
5956	1281	3425
5956	1281	5012
5956	1281	6535
5956	1281	1060
5956	1281	6481
17285	1282	5063
17285	1282	1099
17285	1282	9162
17285	1282	8528
921	1283	9720
921	1283	6829
921	1283	3044
921	1283	2697
921	1283	1904
921	1283	379
921	1283	7278
921	1283	5362
2363	1284	601
19526	1285	9717
19526	1285	3380
19526	1285	9115
11885	1286	6195
11885	1286	1963
11885	1286	7292
11885	1286	1061
12844	1287	7604
12844	1287	5264
12844	1287	3731
12844	1287	7967
12844	1287	2575
11909	1288	9054
8836	1289	2479
8836	1289	1125
8836	1289	4877
8153	1290	8777
8153	1290	7180
8153	1290	4414
8153	1290	3696
8153	1290	1410
8153	1290	64
8153	1290	2225
8153	1290	4077
1819	1291	3937
1819	1291	5637
1819	1291	7947
4573	1292	976
4573	1292	2062
4573	1292	7407
4573	1292	9065
4573	1292	8856
4573	1292	7373
19195	1293	876
19195	1293	8647
19195	1293	413
19195	1293	4748
19195	1293	7643
19195	1293	6562
19195	1293	4980
11911	1294	4110
11911	1294	9277
11911	1294	3026
795	1295	9995
795	1295	5046
795	1295	9146
795	1295	7442
795	1295	6275
795	1295	5607
795	1295	4883
19726	1296	5818
19726	1296	2347
19726	1296	9760
19726	1296	3102
19726	1296	9756
19726	1296	3182
19726	1296	4060
19726	1296	8642
19726	1296	4046
2976	1297	3678
2976	1297	2988
2976	1297	5120
2976	1297	8423
2976	1297	1338
2976	1297	6275
2976	1297	4168
2976	1297	5307
2976	1297	8819
4000	1298	5176
4000	1298	7183
4000	1298	8298
4000	1298	710
4000	1298	9051
4000	1298	8594
4000	1298	2947
4000	1298	3832
10337	1299	8852
10337	1299	4461
10337	1299	7045
10337	1299	9220
10337	1299	5280
10337	1299	9141
10337	1299	1599
10337	1299	9677
773	1300	4774
773	1300	7392
773	1300	7845
773	1300	9089
773	1300	6391
10485	1301	9401
10485	1301	6163
10485	1301	2579
3439	1302	8042
3439	1302	1205
13485	1303	874
13485	1303	4453
13485	1303	8310
13485	1303	8714
13485	1303	8238
13485	1303	9943
13485	1303	20
12365	1304	7624
12365	1304	8524
12365	1304	8982
12365	1304	1094
12365	1304	910
12365	1304	6929
12365	1304	9786
8477	1305	7779
8477	1305	704
8477	1305	2370
8477	1305	8726
8477	1305	9990
8477	1305	8572
12391	1306	5716
12391	1306	4846
12391	1306	4794
12391	1306	9862
12391	1306	6361
12391	1306	9524
12391	1306	3887
12391	1306	57
1519	1307	1406
1519	1307	6034
1519	1307	9359
1519	1307	9348
9948	1308	9582
9948	1308	3324
9948	1308	7995
9948	1308	6098
9948	1308	2834
9948	1308	8409
16930	1309	9224
16930	1309	6584
16930	1309	2473
3661	1310	945
3661	1310	6345
11853	1311	303
11853	1311	1045
11853	1311	2929
11853	1311	2021
11853	1311	598
11853	1311	9802
11853	1311	6623
11853	1311	5048
15040	1312	9350
15040	1312	3049
18787	1313	5320
18787	1313	3457
18787	1313	7787
18787	1313	2022
18787	1313	8379
18787	1313	2053
3709	1314	880
3709	1314	7555
3709	1314	526
3709	1314	2214
10524	1315	4656
10524	1315	3081
10524	1315	8016
10524	1315	5597
10524	1315	1039
10524	1315	6517
10524	1315	1660
18771	1316	3734
18771	1316	9357
18771	1316	1838
18771	1316	4665
18771	1316	9757
18771	1316	9313
7936	1317	3943
7936	1317	8185
18447	1318	8641
18447	1318	7632
18447	1318	8203
18447	1318	3386
18447	1318	9357
18447	1318	3225
18447	1318	2625
18447	1318	5245
18447	1318	8972
15075	1319	9185
14738	1320	6592
10466	1321	2268
10466	1321	5076
10466	1321	8120
10466	1321	8396
10466	1321	5627
10466	1321	9232
10466	1321	3401
11416	1322	6745
11416	1322	6420
11416	1322	2294
11416	1322	4854
8489	1323	1267
8489	1323	1755
8489	1323	2038
8489	1323	775
8489	1323	1218
8489	1323	1453
9707	1324	562
9707	1324	6652
9707	1324	9317
3219	1325	495
3219	1325	930
3219	1325	4661
3219	1325	997
3219	1325	8538
3219	1325	6290
3219	1325	3468
9840	1326	9774
9840	1326	5685
9840	1326	998
629	1327	1924
629	1327	6157
629	1327	5997
629	1327	7030
629	1327	9281
629	1327	7073
629	1327	1061
629	1327	7131
629	1327	868
17645	1328	5429
17645	1328	9556
17645	1328	3852
17645	1328	6741
17645	1328	6667
17645	1328	6167
17645	1328	1082
17645	1328	9908
17645	1328	2821
19786	1329	3255
19786	1329	1726
19786	1329	6982
19786	1329	2945
19786	1329	394
19786	1329	4327
19786	1329	4799
3079	1330	204
3079	1330	6633
3079	1330	5767
3079	1330	9397
11070	1331	2734
11070	1331	6873
11070	1331	5856
17601	1332	7173
17601	1332	5976
17601	1332	9169
17601	1332	3511
17601	1332	6930
17601	1332	209
11951	1333	4562
11951	1333	9931
11951	1333	8566
11951	1333	4775
1262	1334	9431
1262	1334	8783
1262	1334	6950
12238	1335	2725
12238	1335	5799
1596	1336	5194
1596	1336	4302
1596	1336	6512
1596	1336	7788
1596	1336	8306
1596	1336	1917
1596	1336	7668
1596	1336	3556
1012	1337	6625
1012	1337	8611
1012	1337	3889
1012	1337	2282
1012	1337	5208
1012	1337	728
10058	1338	7896
10058	1338	2457
8747	1339	5721
8747	1339	2340
8747	1339	7861
8747	1339	197
8747	1339	2630
8747	1339	3834
12231	1340	7306
12231	1340	8824
12231	1340	4531
12231	1340	3136
12231	1340	7661
12231	1340	8628
12231	1340	9966
12231	1340	1775
8228	1341	7661
8228	1341	2126
8228	1341	8360
8228	1341	6809
8228	1341	2075
8228	1341	9999
8228	1341	5086
19233	1342	2043
19233	1342	72
19233	1342	6714
19233	1342	3097
19233	1342	5723
10159	1343	4632
5983	1344	4567
5983	1344	2944
5983	1344	56
5983	1344	3388
5983	1344	7646
5983	1344	5880
5983	1344	7388
8203	1345	2590
8203	1345	6331
8203	1345	6791
8203	1345	5454
12011	1346	3366
12011	1346	8770
12011	1346	3546
12011	1346	4338
12011	1346	226
12011	1346	3492
12011	1346	1671
12011	1346	2057
16091	1347	9757
16091	1347	2761
16091	1347	8662
16091	1347	7970
16091	1347	4220
16091	1347	6246
16091	1347	1364
9819	1348	1843
9819	1348	213
9819	1348	171
9819	1348	6214
9819	1348	3912
9819	1348	272
9819	1348	8765
9819	1348	1208
19738	1349	8022
19738	1349	6927
19738	1349	1544
19738	1349	9282
19738	1349	3199
10084	1350	376
10084	1350	5763
10084	1350	9585
10084	1350	7785
13098	1351	8075
15628	1352	1773
15628	1352	2433
15628	1352	6220
15628	1352	8752
15628	1352	4836
15628	1352	4460
15628	1352	6298
15628	1352	9379
17927	1353	8820
17927	1353	5759
17927	1353	1081
17927	1353	5163
17927	1353	1647
17927	1353	9392
17927	1353	4096
17927	1353	6736
17927	1353	3538
16746	1354	395
16746	1354	9028
16746	1354	6263
16746	1354	8737
15112	1355	6260
15112	1355	9254
15112	1355	1107
15112	1355	7588
15112	1355	4321
2111	1356	6543
2111	1356	4234
2111	1356	5922
2111	1356	8650
2111	1356	4402
2111	1356	5403
10131	1357	487
10131	1357	1594
5402	1358	3200
5402	1358	7645
5402	1358	6017
5402	1358	1382
5402	1358	1372
5402	1358	7007
11314	1359	570
11314	1359	7783
11314	1359	2712
11314	1359	5193
11314	1359	5431
7611	1360	9768
7611	1360	8541
7611	1360	8209
7611	1360	7055
16853	1361	5720
16853	1361	9781
16853	1361	92
16853	1361	5610
16641	1362	1519
16641	1362	5810
16641	1362	5587
16641	1362	8036
16641	1362	7984
16641	1362	2768
16641	1362	1135
16641	1362	5783
16641	1362	8249
7937	1363	1932
7937	1363	2508
12678	1364	5362
2344	1365	6469
2344	1365	3476
2344	1365	6449
2344	1365	645
2344	1365	6065
2344	1365	5835
2344	1365	7415
2344	1365	8282
426	1366	7754
426	1366	9215
426	1366	5532
16131	1367	6187
16131	1367	2700
16131	1367	6670
14629	1368	3742
14629	1368	6282
9125	1369	4775
9125	1369	4022
6472	1370	7813
6472	1370	3759
6472	1370	9964
6472	1370	5777
6472	1370	9607
6472	1370	1812
17086	1371	1109
17086	1371	4659
17086	1371	8323
17086	1371	3031
14104	1372	288
14104	1372	903
14104	1372	8903
14104	1372	1660
14104	1372	4605
8422	1373	9721
8422	1373	1884
8422	1373	3147
8422	1373	960
18563	1374	2379
18563	1374	4961
18563	1374	7728
18563	1374	9771
18563	1374	3348
18563	1374	3290
18563	1374	7539
18563	1374	2445
4656	1375	1972
4656	1375	9025
19969	1376	9266
19969	1376	71
10061	1377	279
7252	1378	8634
7252	1378	451
7252	1378	4695
14207	1379	1396
14207	1379	497
14207	1379	3390
14207	1379	842
14207	1379	3814
13449	1380	7363
13449	1380	3363
13449	1380	9847
13449	1380	9188
19277	1381	2194
19277	1381	8876
543	1382	8952
543	1382	2258
543	1382	6025
543	1382	706
543	1382	2795
543	1382	4269
543	1382	2869
543	1382	6789
11952	1383	5614
11952	1383	7933
11952	1383	3719
11952	1383	4382
11952	1383	7080
11952	1383	898
6310	1384	9226
6310	1384	4080
6310	1384	3178
6310	1384	2178
17932	1385	4942
17932	1385	1222
17932	1385	713
17932	1385	8363
17932	1385	5964
6086	1386	9074
6086	1386	543
6086	1386	8594
6086	1386	1429
6086	1386	1788
6086	1386	1022
6086	1386	653
18830	1387	9373
18830	1387	8427
18830	1387	2441
18830	1387	4516
18830	1387	9533
18830	1387	1447
18830	1387	8394
18830	1387	1475
135	1388	2741
135	1388	1453
135	1388	4455
135	1388	765
135	1388	1520
135	1388	5258
135	1388	6114
17107	1389	6957
17107	1389	6499
17107	1389	6643
17107	1389	8923
17107	1389	3828
5060	1390	3020
14950	1391	4861
14950	1391	8280
14950	1391	7156
14950	1391	3802
14950	1391	2947
19806	1392	8306
14457	1393	1569
14457	1393	1375
14457	1393	8150
14457	1393	5396
14457	1393	1869
14457	1393	8290
14457	1393	6403
14457	1393	6847
1297	1394	4923
1297	1394	3811
1297	1394	5443
1297	1394	125
18329	1395	6389
9078	1396	7377
9078	1396	9204
9078	1396	3671
9078	1396	2235
9078	1396	9165
9078	1396	1167
9078	1396	7104
9078	1396	6174
9078	1396	5292
10832	1397	4580
10832	1397	3287
10832	1397	2060
14265	1398	4074
14265	1398	8549
14265	1398	830
19988	1399	850
19988	1399	5518
19988	1399	1996
19988	1399	8640
19988	1399	6225
19988	1399	7399
19988	1399	2097
19988	1399	1773
19988	1399	7640
7319	1400	8883
7319	1400	3107
7319	1400	9495
7319	1400	9706
7319	1400	798
12630	1401	7124
12630	1401	1577
12630	1401	6933
12630	1401	4152
12630	1401	9659
12630	1401	3186
8947	1402	9835
8947	1402	2079
8947	1402	9551
8947	1402	4310
10214	1403	1422
10214	1403	6154
10214	1403	3605
10214	1403	1892
10214	1403	6704
10214	1403	9567
10214	1403	1967
10214	1403	3661
10214	1403	7225
14119	1404	1
8620	1405	9417
8620	1405	6836
8620	1405	464
8620	1405	9383
8620	1405	719
8620	1405	4606
8620	1405	7317
18566	1406	4453
18566	1406	2065
18566	1406	1206
18566	1406	3602
18566	1406	531
18566	1406	5516
18566	1406	3021
19713	1407	2846
19713	1407	1403
19713	1407	6426
19713	1407	986
19713	1407	179
19713	1407	3025
19713	1407	2217
8562	1408	803
8562	1408	3660
8562	1408	9854
5750	1409	2732
5750	1409	9335
1475	1410	6746
1475	1410	5195
16438	1411	5696
16438	1411	1395
16438	1411	7727
16438	1411	227
16438	1411	3531
16438	1411	561
16438	1411	2955
11373	1412	1263
11373	1412	732
11373	1412	1024
11373	1412	529
11373	1412	4401
11373	1412	4437
11373	1412	2539
11373	1412	3699
11373	1412	6293
13039	1413	6600
13039	1413	8320
13039	1413	8041
13039	1413	5241
13039	1413	8973
13039	1413	2155
13039	1413	6906
13039	1413	7180
13039	1413	9395
7662	1414	3963
7662	1414	9332
7662	1414	5130
7662	1414	6775
7662	1414	5122
6881	1415	2419
6881	1415	1938
6881	1415	4672
6881	1415	1095
6881	1415	7269
6881	1415	9012
6881	1415	9855
6881	1415	494
6881	1415	7271
13204	1416	2063
13204	1416	6636
13204	1416	4861
13204	1416	625
13204	1416	7304
13204	1416	5958
13204	1416	4434
13204	1416	3333
1203	1417	7265
1203	1417	3090
720	1418	6962
720	1418	5776
720	1418	8414
720	1418	6209
720	1418	362
720	1418	1063
720	1418	9877
8621	1419	9839
7282	1420	7298
7282	1420	5864
7282	1420	4524
7282	1420	7896
7282	1420	5006
7282	1420	509
7282	1420	6084
7282	1420	6693
15512	1421	4776
15512	1421	7737
15512	1421	1257
15512	1421	2281
6710	1422	7519
6710	1422	9328
6710	1422	4144
6710	1422	3527
6710	1422	896
6710	1422	2569
6710	1422	753
6710	1422	3425
15071	1423	8553
15071	1423	4219
12999	1424	9854
12999	1424	2769
12999	1424	8173
12999	1424	9414
5880	1425	6975
15454	1426	2029
19516	1427	5223
19516	1427	6514
19516	1427	2822
19516	1427	2518
19516	1427	526
19516	1427	47
19516	1427	7382
13401	1428	6915
13401	1428	6514
13401	1428	7101
18260	1429	8888
18260	1429	9585
18260	1429	8546
2733	1430	4042
2733	1430	177
2733	1430	3741
2733	1430	3549
2733	1430	4258
2345	1431	5281
2345	1431	3556
2345	1431	1554
2345	1431	2886
4941	1432	8569
4941	1432	5809
4941	1432	1815
4941	1432	8128
3736	1433	6623
3736	1433	3435
3736	1433	4979
3736	1433	7605
3736	1433	1182
3736	1433	266
3736	1433	4834
1462	1434	5173
1462	1434	4654
1462	1434	7275
1462	1434	831
1462	1434	8459
1462	1434	7270
1462	1434	2255
11378	1435	4447
11378	1435	7051
11378	1435	6513
11378	1435	8365
11378	1435	468
11378	1435	2078
11378	1435	9272
7849	1436	393
7849	1436	2957
7849	1436	3830
7849	1436	6858
7849	1436	4118
7849	1436	1773
7849	1436	5461
5022	1437	9827
5022	1437	5078
5022	1437	1756
5022	1437	6384
13326	1438	4217
13326	1438	1697
13326	1438	4194
2101	1439	9720
2101	1439	3381
1199	1440	4331
1199	1440	1663
6836	1441	4444
6836	1441	858
6836	1441	3602
6836	1441	4737
17861	1442	9981
17861	1442	1161
17861	1442	5816
17861	1442	4882
17861	1442	5142
17861	1442	6867
17861	1442	91
17861	1442	8879
17861	1442	1947
12782	1443	5786
12782	1443	8030
12782	1443	5306
12258	1444	8563
12258	1444	9134
12258	1444	5625
12258	1444	9796
12258	1444	6588
12258	1444	238
12258	1444	5192
12258	1444	4580
12258	1444	4557
1926	1445	970
1926	1445	9837
1926	1445	7937
1926	1445	2404
1926	1445	8722
1926	1445	8942
1926	1445	5345
1926	1445	1870
1926	1445	5333
11139	1446	4686
11139	1446	4132
11139	1446	6390
11139	1446	205
11139	1446	6976
11139	1446	3681
11139	1446	7449
19705	1447	819
19705	1447	2677
19705	1447	2985
19705	1447	1302
19705	1447	3003
16274	1448	7850
16274	1448	7814
16274	1448	1889
16274	1448	260
16274	1448	9192
16274	1448	5676
16274	1448	5559
16274	1448	6493
14622	1449	3474
14622	1449	3820
14622	1449	4756
14622	1449	7879
14622	1449	4959
14622	1449	7215
14622	1449	2203
14622	1449	7048
14622	1449	3046
4474	1450	8877
4474	1450	406
4474	1450	1841
4474	1450	2681
4474	1450	6276
4474	1450	1732
4474	1450	929
4474	1450	6918
3754	1451	4686
3754	1451	7370
3754	1451	3075
12057	1452	4659
10127	1453	2066
10127	1453	4229
10127	1453	5732
10127	1453	8437
10127	1453	2447
10127	1453	5468
10127	1453	7232
10127	1453	9918
10127	1453	1233
8614	1454	335
8614	1454	2980
8614	1454	1882
17559	1455	8357
17559	1455	463
17800	1456	4255
17800	1456	9221
18276	1457	6425
18276	1457	4005
18276	1457	9746
18276	1457	4481
18276	1457	9333
18276	1457	2800
18276	1457	5141
18276	1457	1511
18276	1457	5050
8498	1458	5895
8498	1458	4553
8498	1458	6615
8498	1458	4254
8498	1458	2716
8498	1458	7072
8498	1458	4806
8498	1458	1061
787	1459	9782
787	1459	4153
787	1459	4286
3745	1460	208
3745	1460	9266
3745	1460	4462
3745	1460	7778
986	1461	7214
986	1461	9788
986	1461	3485
18263	1462	9919
18263	1462	9742
18263	1462	5026
18263	1462	6077
18263	1462	7146
18263	1462	7823
18263	1462	1044
18263	1462	2291
16378	1463	1159
1892	1464	276
1892	1464	7207
1892	1464	1917
1892	1464	7771
1892	1464	1330
1892	1464	4665
1892	1464	1274
1892	1464	3691
9469	1465	3556
5738	1466	9396
5738	1466	805
5738	1466	5437
5738	1466	7665
5738	1466	3027
5738	1466	9768
5738	1466	1240
5738	1466	3594
5738	1466	8504
4389	1467	6929
4389	1467	6447
4389	1467	7721
4389	1467	3353
4389	1467	5006
4389	1467	7853
6578	1468	5931
6578	1468	4192
6578	1468	714
6578	1468	6796
6578	1468	1335
18098	1469	4984
18098	1469	8481
18098	1469	4906
16515	1470	1006
16515	1470	7391
8561	1471	4197
8561	1471	9463
8561	1471	2182
8561	1471	9217
16782	1472	1529
16782	1472	3473
16782	1472	8978
16782	1472	6210
16782	1472	6635
16782	1472	7135
16782	1472	7448
16782	1472	5591
16782	1472	8806
6004	1473	7912
6004	1473	4768
6004	1473	601
6004	1473	5518
6004	1473	5375
6004	1473	714
6004	1473	7055
6004	1473	7224
7718	1474	1499
7718	1474	6904
7718	1474	8897
15885	1475	6451
2436	1476	7543
2436	1476	992
2436	1476	6314
2436	1476	1764
2436	1476	1396
2436	1476	6634
2436	1476	2846
2436	1476	9019
11845	1477	1632
11845	1477	3254
11845	1477	6818
11845	1477	6966
11845	1477	923
16930	1478	1382
16930	1478	4566
16930	1478	9666
12599	1479	9100
12599	1479	9323
12599	1479	7542
12599	1479	827
12599	1479	7432
8498	1480	8292
8498	1480	7197
8498	1480	3173
8498	1480	3022
8498	1480	3477
8498	1480	7700
19665	1481	4811
19665	1481	7767
19665	1481	4056
19665	1481	4891
19665	1481	4481
19665	1481	8963
5497	1482	7457
5497	1482	5025
5497	1482	4853
5497	1482	5184
5497	1482	5633
18360	1483	5328
6190	1484	8403
6190	1484	8390
6190	1484	8873
6190	1484	6881
14717	1485	5032
14717	1485	8186
14717	1485	3377
14717	1485	8214
14717	1485	6253
14717	1485	8189
14717	1485	596
95	1486	3555
95	1486	4705
95	1486	7898
95	1486	9296
95	1486	9022
95	1486	2136
95	1486	6953
95	1486	4660
16073	1487	7046
16073	1487	4951
16073	1487	3729
16073	1487	8750
16073	1487	5595
18297	1488	1092
18297	1488	6661
18297	1488	3050
10370	1489	2353
10370	1489	1876
10370	1489	7706
10370	1489	4672
10370	1489	5144
10370	1489	9985
10370	1489	5169
1526	1490	9912
1526	1490	558
1526	1490	2741
1526	1490	1392
1526	1490	2900
1526	1490	975
1526	1490	7913
19576	1491	171
19576	1491	37
19576	1491	7025
19576	1491	4187
19576	1491	8756
5702	1492	7320
5702	1492	3872
5702	1492	8532
2862	1493	9342
2862	1493	152
2862	1493	4138
2862	1493	2208
2862	1493	286
2862	1493	9623
2862	1493	2266
2043	1494	3872
2043	1494	5329
2043	1494	9161
15384	1495	9123
15384	1495	3927
15384	1495	5250
15384	1495	5386
15384	1495	6961
15384	1495	3695
15384	1495	9838
4206	1496	3125
4206	1496	6520
4206	1496	2063
4206	1496	8188
18881	1497	6543
18881	1497	6411
18881	1497	6503
18881	1497	4548
18881	1497	1046
9479	1498	8056
9479	1498	1421
9479	1498	7368
9479	1498	9396
9479	1498	1541
9479	1498	5737
9479	1498	2683
9479	1498	9169
9479	1498	2296
17411	1499	365
17411	1499	8027
17411	1499	2236
17411	1499	6149
17411	1499	6826
17411	1499	4297
3330	1500	5553
3330	1500	239
3330	1500	4062
3330	1500	8074
3330	1500	4520
3330	1500	8942
3330	1500	9074
3330	1500	295
16643	1501	5829
16643	1501	9074
16643	1501	1201
16643	1501	902
16643	1501	5035
16643	1501	9365
16643	1501	8027
16643	1501	1876
19898	1502	318
19898	1502	1200
19898	1502	9382
19898	1502	8830
19898	1502	9815
19898	1502	3317
19898	1502	6674
15749	1503	8460
15749	1503	2894
15749	1503	1383
15749	1503	7428
15749	1503	3008
15749	1503	3207
15749	1503	6996
15749	1503	2586
15749	1503	2916
3490	1504	1422
3490	1504	5147
3490	1504	2905
3490	1504	5970
3490	1504	2644
3490	1504	9460
3490	1504	2253
3490	1504	6458
3490	1504	4101
14615	1505	832
14615	1505	4823
14615	1505	2345
14615	1505	5492
14615	1505	4014
14615	1505	59
5927	1506	1628
2176	1507	1931
2176	1507	7339
2176	1507	6708
2176	1507	3338
2176	1507	3598
2176	1507	4877
2176	1507	7917
6817	1508	322
6817	1508	6105
6817	1508	9787
6817	1508	6309
6817	1508	3957
6817	1508	2503
6817	1508	9375
13428	1509	3684
13428	1509	3192
13428	1509	7970
13428	1509	5703
13428	1509	5290
13428	1509	9295
13428	1509	5578
13428	1509	8878
17329	1510	79
17329	1510	2972
4694	1511	9061
5489	1512	26
5489	1512	1025
5489	1512	5133
8855	1513	4044
8855	1513	1621
8855	1513	5911
8855	1513	248
8855	1513	6358
8855	1513	8571
8855	1513	5566
8855	1513	6518
8855	1513	3060
8673	1514	3583
8673	1514	3125
8673	1514	6576
8673	1514	3143
8673	1514	7424
8673	1514	2191
8673	1514	6178
12849	1515	9644
12849	1515	2858
12849	1515	8245
12849	1515	9836
12849	1515	5657
12849	1515	5641
12849	1515	4602
15452	1516	5212
15452	1516	6675
17731	1517	6967
17731	1517	870
17731	1517	148
17731	1517	3719
17731	1517	5723
11115	1518	2763
11115	1518	2931
11115	1518	8132
11115	1518	5091
11115	1518	9817
11115	1518	7152
11115	1518	2937
11115	1518	5356
4645	1519	3380
14196	1520	9061
14196	1520	2526
14196	1520	919
14196	1520	1237
14196	1520	2653
14196	1520	1936
14196	1520	5439
5181	1521	8010
15746	1522	8606
15746	1522	443
15746	1522	6397
10916	1523	7787
10916	1523	4634
10916	1523	8596
10916	1523	8392
10916	1523	5029
10916	1523	2282
10916	1523	6422
10916	1523	4054
10916	1523	4122
83	1524	9341
11475	1525	1196
11475	1525	6926
11475	1525	2555
11475	1525	8006
11475	1525	8845
11475	1525	1681
11475	1525	228
13298	1526	1080
6766	1527	4292
6766	1527	6284
6766	1527	3727
9845	1528	3904
9845	1528	1118
9845	1528	1780
9845	1528	8307
9845	1528	3837
9845	1528	7422
9845	1528	5184
9845	1528	1784
9845	1528	515
18328	1529	7154
18328	1529	8990
18328	1529	2228
18328	1529	5803
19413	1530	1616
19413	1530	2263
19413	1530	6172
7187	1531	5501
7187	1531	9902
7187	1531	1100
7187	1531	5180
4666	1532	3213
4666	1532	4095
4666	1532	1271
4406	1533	4915
2173	1534	4680
2173	1534	2353
2173	1534	1486
2173	1534	6197
2173	1534	1800
2173	1534	9364
2173	1534	3709
2173	1534	7755
3699	1535	7126
9404	1536	4541
9404	1536	8548
9404	1536	3969
9404	1536	3297
9404	1536	3409
9404	1536	8576
9404	1536	7368
13463	1537	4836
13463	1537	1612
13463	1537	5262
13463	1537	4253
13463	1537	2207
14405	1538	2457
14405	1538	2106
10806	1539	185
10806	1539	9050
10806	1539	1697
10806	1539	4284
10806	1539	4720
10806	1539	767
10806	1539	3029
10806	1539	3879
10806	1539	8415
11005	1540	7131
11005	1540	1152
11005	1540	2169
11005	1540	4640
11005	1540	6633
11005	1540	6236
11005	1540	2377
11005	1540	5712
861	1541	6761
861	1541	2079
861	1541	6089
861	1541	6726
861	1541	5996
861	1541	8511
19324	1542	6850
19324	1542	2841
19324	1542	1827
19324	1542	9164
19324	1542	7008
19324	1542	864
19324	1542	5305
19324	1542	8345
848	1543	917
848	1543	1707
434	1544	9879
434	1544	3127
434	1544	9404
434	1544	210
434	1544	5044
4103	1545	4345
4103	1545	2939
4103	1545	1617
4103	1545	3114
4103	1545	9927
4103	1545	3752
6389	1546	8395
3043	1547	7489
3043	1547	4016
3043	1547	8038
4569	1548	1836
4569	1548	1618
4569	1548	7072
4569	1548	7774
4569	1548	8761
4569	1548	8631
4569	1548	4720
4569	1548	684
4569	1548	2208
1326	1549	9328
1326	1549	4656
18479	1550	8168
18479	1550	4744
18479	1550	4937
18479	1550	4517
18479	1550	8814
18479	1550	4235
17909	1551	2069
17909	1551	7728
17909	1551	793
17909	1551	8828
6966	1552	2723
6966	1552	1822
6966	1552	8619
6966	1552	676
6966	1552	8381
6966	1552	6266
1001	1553	9455
1001	1553	5111
5677	1554	7418
5677	1554	3604
5677	1554	536
5677	1554	8624
890	1555	7010
890	1555	397
890	1555	16
890	1555	2584
890	1555	7162
890	1555	9932
890	1555	9780
4940	1556	5953
4940	1556	3418
4940	1556	8159
4940	1556	646
4940	1556	7213
4940	1556	7228
8474	1557	9627
8474	1557	2770
8474	1557	4684
8474	1557	9430
8474	1557	6548
8474	1557	9656
15070	1558	2832
15070	1558	7189
15070	1558	8423
15070	1558	7773
15070	1558	6703
15070	1558	6995
15070	1558	9236
17725	1559	1072
17725	1559	1221
15536	1560	2454
15536	1560	5867
15536	1560	9022
15536	1560	7973
15536	1560	9688
15536	1560	4045
15536	1560	2030
15536	1560	2460
3392	1561	558
3392	1561	2971
8383	1562	1960
8383	1562	2652
8383	1562	3231
8383	1562	7918
11782	1563	2286
11782	1563	4364
11782	1563	3255
11782	1563	3339
11782	1563	8519
11782	1563	8097
11782	1563	7122
5529	1564	7084
5529	1564	4677
5529	1564	1632
19098	1565	5440
19098	1565	2372
19098	1565	1129
19098	1565	2040
19098	1565	3559
4154	1566	1154
4154	1566	9964
4154	1566	804
4154	1566	4696
4154	1566	2441
4154	1566	7623
4154	1566	7279
4154	1566	3621
4154	1566	1343
7429	1567	450
7429	1567	1572
7429	1567	4202
7429	1567	6085
7429	1567	1268
7429	1567	3160
7429	1567	9097
7584	1568	3164
7584	1568	2967
7584	1568	5348
7584	1568	7879
7584	1568	5648
7584	1568	405
7584	1568	1125
7584	1568	1257
7584	1568	4862
1892	1569	8184
1892	1569	7565
1892	1569	7701
1892	1569	1072
1892	1569	2913
1892	1569	9024
8742	1570	1061
8742	1570	6494
8742	1570	547
3606	1571	7261
3606	1571	8126
3606	1571	1715
3606	1571	1577
3606	1571	3589
3606	1571	3298
3606	1571	8828
15702	1572	2222
15702	1572	6129
15702	1572	2671
15702	1572	4748
14134	1573	4247
4745	1574	8682
4745	1574	6927
4745	1574	973
4745	1574	6932
4745	1574	6435
4745	1574	7651
4745	1574	9400
11056	1575	8150
11056	1575	8968
11056	1575	4969
11056	1575	8942
11056	1575	6268
11056	1575	1588
538	1576	2540
538	1576	9674
538	1576	8855
538	1576	5298
538	1576	4632
538	1576	6377
538	1576	225
538	1576	3463
538	1576	7432
4801	1577	1616
4801	1577	580
4801	1577	9073
4801	1577	3472
4801	1577	2552
4801	1577	6210
10128	1578	1569
15890	1579	7475
15890	1579	4075
15890	1579	6570
15890	1579	7307
15890	1579	6541
15890	1579	5673
9489	1580	1899
9489	1580	1608
9489	1580	4999
9489	1580	3173
9489	1580	7868
9489	1580	6296
13945	1581	1112
15362	1582	668
15362	1582	1296
15362	1582	7616
15675	1583	611
15675	1583	1093
15675	1583	7713
11159	1584	8923
11159	1584	2210
11159	1584	1850
11159	1584	1083
11159	1584	1002
3339	1585	8010
18189	1586	2079
18189	1586	3647
18189	1586	7205
12292	1587	1384
12292	1587	8128
12292	1587	3826
12292	1587	6914
12292	1587	6894
12292	1587	9945
10952	1588	8623
10952	1588	6689
10952	1588	3798
10952	1588	1201
10952	1588	1937
10952	1588	8804
10952	1588	4551
11868	1589	9527
11868	1589	3915
11868	1589	337
11868	1589	4355
7877	1590	1533
7877	1590	4533
7877	1590	3985
7877	1590	6987
17847	1591	8294
17847	1591	320
17847	1591	4075
17847	1591	8041
17847	1591	7351
15373	1592	7967
15373	1592	8333
15373	1592	3511
15373	1592	8102
4172	1593	7271
4172	1593	3996
4172	1593	6725
4172	1593	9001
4172	1593	6393
8866	1594	6388
8866	1594	4003
8866	1594	1111
8866	1594	8902
8866	1594	5694
8866	1594	9308
14786	1595	2465
14786	1595	8977
14786	1595	4012
14786	1595	8750
14786	1595	2746
14786	1595	6089
14786	1595	9575
11924	1596	5111
11924	1596	4002
19389	1597	3490
19389	1597	6733
19389	1597	3710
19389	1597	2521
19389	1597	5658
19389	1597	8388
19389	1597	9546
19389	1597	9549
19389	1597	2846
1747	1598	2905
1747	1598	8467
1747	1598	4208
1747	1598	6601
1747	1598	7840
1747	1598	7513
1747	1598	9460
1747	1598	3770
18855	1599	3835
18855	1599	3430
18855	1599	3693
4180	1600	9967
4180	1600	7786
4180	1600	6959
4180	1600	6933
4180	1600	2626
4180	1600	3649
4180	1600	9345
6229	1601	2542
6229	1601	7565
6229	1601	1660
6229	1601	9759
6229	1601	7268
8831	1602	4469
8831	1602	5843
8831	1602	9633
8831	1602	4986
8831	1602	7548
8831	1602	2395
8831	1602	1743
13662	1603	432
13662	1603	8924
13662	1603	7581
9696	1604	9264
9696	1604	2295
9696	1604	8440
9696	1604	5159
9696	1604	913
16922	1605	5353
16922	1605	6479
16922	1605	7353
15568	1606	9876
15568	1606	5513
15568	1606	4517
15568	1606	2205
15568	1606	7260
15568	1606	7512
15568	1606	2636
7097	1607	2009
7097	1607	6825
7097	1607	2114
7097	1607	2721
1256	1608	7459
5943	1609	9431
5943	1609	8859
5943	1609	1146
5943	1609	2390
5943	1609	9040
3707	1610	3446
3707	1610	6700
3707	1610	388
3707	1610	5025
3707	1610	48
3707	1610	85
3707	1610	9400
3707	1610	477
3707	1610	5726
9169	1611	955
9169	1611	5418
5494	1612	2085
5494	1612	2493
5494	1612	853
5494	1612	8204
5494	1612	2072
4314	1613	2804
4314	1613	1395
4314	1613	6141
4314	1613	3114
4314	1613	3521
4314	1613	1725
4314	1613	4063
11822	1614	1204
11822	1614	2553
11822	1614	7652
11822	1614	7934
12173	1615	3638
12173	1615	998
12173	1615	3213
12173	1615	6916
12173	1615	9876
3199	1616	8471
3199	1616	368
3199	1616	4827
3199	1616	5522
3199	1616	3629
3125	1617	7649
3125	1617	1906
3125	1617	9462
3125	1617	6317
3125	1617	41
3125	1617	9001
3125	1617	3668
6083	1618	4099
6083	1618	736
6083	1618	5791
6083	1618	6305
6083	1618	9431
6083	1618	981
6083	1618	1582
6083	1618	7106
6083	1618	9915
12463	1619	9464
12463	1619	6346
12463	1619	7637
12463	1619	6173
12463	1619	7847
12463	1619	5707
2995	1620	917
2995	1620	9941
2995	1620	6597
2995	1620	526
2995	1620	5010
2799	1621	7830
2799	1621	7755
2799	1621	9266
2799	1621	2036
2799	1621	6879
2799	1621	5711
2799	1621	8463
2799	1621	4083
2799	1621	409
700	1622	1872
700	1622	7870
700	1622	7862
700	1622	8281
12220	1623	285
12220	1623	798
12220	1623	5372
12220	1623	2201
12220	1623	262
8689	1624	9344
8689	1624	6748
8689	1624	5702
8689	1624	3661
8689	1624	5502
8689	1624	1712
18728	1625	4771
18728	1625	6656
18728	1625	2496
18728	1625	3245
18728	1625	3110
18728	1625	5360
18728	1625	7850
14386	1626	3432
14386	1626	865
14386	1626	132
3686	1627	1207
3686	1627	1391
3686	1627	215
3686	1627	1546
3686	1627	74
6366	1628	2283
6366	1628	2089
6366	1628	3337
13537	1629	3860
4947	1630	7142
4947	1630	7442
4947	1630	8665
4947	1630	6578
4947	1630	366
4947	1630	5000
4947	1630	9834
4232	1631	9896
4232	1631	5571
4232	1631	9544
6807	1632	5877
6807	1632	5467
6807	1632	8883
6807	1632	1550
6807	1632	564
6807	1632	7757
6807	1632	4779
6807	1632	8700
18469	1633	1858
18469	1633	8265
18469	1633	6543
18469	1633	2505
18469	1633	1212
14177	1634	107
3313	1635	9784
3313	1635	5283
3313	1635	358
3313	1635	9174
11802	1636	2524
11802	1636	2502
11802	1636	7970
11802	1636	6417
11802	1636	2226
11282	1637	7938
11282	1637	8032
11282	1637	859
11282	1637	5383
11282	1637	2377
11282	1637	123
6678	1638	8413
6678	1638	4205
6678	1638	9039
6678	1638	5921
16294	1639	3788
16294	1639	4000
16294	1639	6507
16294	1639	9507
16294	1639	9847
16294	1639	3506
16294	1639	628
5550	1640	6819
5550	1640	1195
467	1641	5689
467	1641	362
8298	1642	5874
8298	1642	8208
8298	1642	6850
8298	1642	268
8298	1642	277
8298	1642	3984
1901	1643	6331
5250	1644	4840
5250	1644	9262
5250	1644	5364
5250	1644	9351
5250	1644	7614
11643	1645	3875
11643	1645	5031
11643	1645	1768
11643	1645	8199
11643	1645	9964
12589	1646	8920
12589	1646	2147
12589	1646	9018
12589	1646	8961
12589	1646	2846
12589	1646	2723
12589	1646	3536
8281	1647	5013
13560	1648	2218
13560	1648	5974
13560	1648	5526
8889	1649	8204
8889	1649	9138
8889	1649	5935
8889	1649	5476
8889	1649	2442
8889	1649	9206
8889	1649	3152
16328	1650	4944
16328	1650	5689
16328	1650	3183
17416	1651	3153
2711	1652	8520
2711	1652	9737
2711	1652	6251
2711	1652	3007
2711	1652	901
2711	1652	9886
2711	1652	4323
18533	1653	6428
18533	1653	312
18533	1653	412
18533	1653	2621
18533	1653	7984
18533	1653	4919
18533	1653	8992
18533	1653	7236
6972	1654	8942
17654	1655	3397
3835	1656	3621
3835	1656	8349
3835	1656	1388
3835	1656	7596
3835	1656	2207
3835	1656	9014
12499	1657	9736
12499	1657	3827
12499	1657	2640
12499	1657	7504
1800	1658	2818
1800	1658	8151
12998	1659	7468
12998	1659	6235
12998	1659	579
12998	1659	872
12998	1659	1498
12998	1659	9917
12998	1659	1629
8536	1660	8493
8536	1660	8313
8536	1660	7051
8536	1660	9233
8536	1660	7568
8536	1660	1700
8536	1660	1574
15616	1661	3057
15616	1661	3212
15616	1661	510
15616	1661	5788
15616	1661	6872
15616	1661	6406
15616	1661	3110
2846	1662	2553
2846	1662	8808
2846	1662	6105
2846	1662	8157
8518	1663	940
8518	1663	8230
8518	1663	3097
8518	1663	7280
8518	1663	877
8518	1663	4581
8518	1663	5191
8518	1663	2180
8685	1664	5738
8685	1664	1786
19885	1665	4201
19885	1665	2863
19885	1665	3546
19885	1665	9292
13141	1666	721
11824	1667	7659
6026	1668	7175
3689	1669	6190
3689	1669	6614
319	1670	6802
319	1670	5505
319	1670	684
319	1670	2433
319	1670	2138
319	1670	8844
319	1670	7138
319	1670	2809
319	1670	3606
11393	1671	7306
11393	1671	876
11393	1671	7069
11393	1671	4079
11393	1671	9452
11393	1671	7188
15743	1672	6545
15743	1672	5867
15743	1672	3115
15743	1672	8745
15743	1672	8716
15743	1672	5907
15468	1673	5751
15468	1673	9272
15468	1673	2552
15468	1673	33
15468	1673	4230
14871	1674	3074
14871	1674	1460
14871	1674	7025
14871	1674	1944
14871	1674	497
14871	1674	8119
14871	1674	5446
14871	1674	4137
19776	1675	2708
5480	1676	9960
5480	1676	5802
5480	1676	8295
5480	1676	6688
5480	1676	7816
5480	1676	4327
5480	1676	9481
5480	1676	419
11727	1677	2467
11727	1677	5251
11727	1677	6068
11727	1677	2295
11727	1677	698
1315	1678	5709
1315	1678	3249
1315	1678	3690
1315	1678	6108
11176	1679	3187
11176	1679	7105
19143	1680	677
19143	1680	2635
19143	1680	8501
19143	1680	8459
19143	1680	3990
19396	1681	2094
19396	1681	5758
19396	1681	9743
19396	1681	3789
19396	1681	7823
9854	1682	4498
9854	1682	753
9854	1682	4451
9854	1682	8145
9854	1682	6720
9854	1682	24
2937	1683	6162
2937	1683	468
2937	1683	701
2937	1683	8501
2937	1683	2792
2937	1683	1464
2937	1683	1250
2937	1683	5514
12533	1684	9654
12533	1684	8944
12533	1684	5670
12533	1684	7082
12533	1684	435
12533	1684	5114
11163	1685	5791
17166	1686	8023
17166	1686	2028
17166	1686	337
17166	1686	9803
17166	1686	9562
17166	1686	324
11985	1687	2366
11985	1687	398
11985	1687	4502
6036	1688	35
6036	1688	7435
6036	1688	2887
6036	1688	7963
6036	1688	8993
6036	1688	8483
6036	1688	9557
6036	1688	8250
8158	1689	6989
8158	1689	1925
8158	1689	5716
8158	1689	7772
17688	1690	5092
17688	1690	2853
17688	1690	518
17688	1690	2892
17688	1690	9115
17688	1690	8304
17688	1690	9418
17688	1690	8550
17688	1690	633
15243	1691	5008
15243	1691	8337
15563	1692	7261
15563	1692	9838
15563	1692	4693
15563	1692	928
15563	1692	9865
16336	1693	4722
16336	1693	4343
16336	1693	1683
16336	1693	2975
16336	1693	6238
16336	1693	2713
16336	1693	763
16336	1693	2357
19233	1694	9729
19233	1694	4830
19233	1694	1377
19233	1694	700
19233	1694	2862
15167	1695	2937
15167	1695	7380
15167	1695	2696
10817	1696	5270
10817	1696	7044
10817	1696	165
10817	1696	4382
10817	1696	9937
2625	1697	1647
2625	1697	662
14669	1698	5690
14669	1698	3199
14669	1698	4408
14669	1698	3794
14669	1698	1751
14669	1698	3149
14669	1698	8970
6704	1699	2564
6704	1699	6186
6704	1699	5008
6704	1699	3236
6704	1699	8190
3199	1700	2389
3199	1700	7078
3199	1700	5165
3199	1700	9396
3199	1700	9934
3199	1700	5710
3199	1700	5857
3199	1700	2256
9638	1701	1288
9638	1701	9539
15456	1702	9327
15456	1702	5194
15456	1702	5052
15456	1702	8512
15456	1702	3143
15456	1702	7132
5683	1703	3488
5683	1703	5371
5683	1703	9055
5683	1703	713
5683	1703	6020
5683	1703	4865
13947	1704	3954
13947	1704	9021
13947	1704	3482
13947	1704	9223
13947	1704	5439
13947	1704	9701
13947	1704	9196
5366	1705	1691
5366	1705	5757
5366	1705	5313
5366	1705	2654
5366	1705	1294
5366	1705	7151
5366	1705	7939
13918	1706	4492
13918	1706	8628
16655	1707	8
16655	1707	7564
16655	1707	5578
16655	1707	894
16655	1707	1657
8622	1708	4944
8622	1708	1715
8622	1708	4638
8622	1708	9841
8663	1709	4261
158	1710	8092
158	1710	5126
158	1710	1464
158	1710	5003
158	1710	2225
158	1710	7432
158	1710	2515
158	1710	2141
158	1710	5256
10192	1711	9428
10192	1711	7572
10192	1711	5369
10192	1711	3767
10192	1711	5968
10192	1711	2224
10192	1711	5527
1058	1712	8641
1058	1712	7943
1058	1712	6613
1058	1712	5385
1058	1712	6861
1058	1712	6964
1058	1712	6554
1058	1712	3989
1058	1712	79
7691	1713	5703
7691	1713	7950
7691	1713	5281
7691	1713	1758
7691	1713	4396
7691	1713	6326
7691	1713	1555
13878	1714	6789
13878	1714	7667
13878	1714	8162
13878	1714	7467
13878	1714	1013
13878	1714	2086
13878	1714	5216
13878	1714	1978
13878	1714	9018
1551	1715	1174
1551	1715	4959
1551	1715	8610
6831	1716	5186
6831	1716	9797
6831	1716	5984
6831	1716	1587
6831	1716	5621
6831	1716	7380
18714	1717	6615
11920	1718	1631
11920	1718	5155
11920	1718	7186
7695	1719	8176
7695	1719	2188
7695	1719	8336
7695	1719	1156
7695	1719	7446
7695	1719	4793
7695	1719	7892
7695	1719	9383
1270	1720	3062
1270	1720	5673
1270	1720	2338
1270	1720	3036
1270	1720	6706
1270	1720	4834
14043	1721	796
14043	1721	7676
14043	1721	8731
14043	1721	7147
13059	1722	7165
13059	1722	8148
13059	1722	3694
12062	1723	2024
12062	1723	5788
2343	1724	4890
2343	1724	7503
2343	1724	2917
2343	1724	5033
2343	1724	2856
2343	1724	6593
2343	1724	8575
13443	1725	542
13443	1725	5306
13443	1725	3901
13443	1725	605
13443	1725	4188
13443	1725	860
13443	1725	6177
13443	1725	2742
13443	1725	8314
6694	1726	9641
6694	1726	6753
6694	1726	6070
104	1727	2476
104	1727	2697
104	1727	4243
104	1727	6064
104	1727	2172
16696	1728	2027
16696	1728	4895
16696	1728	4333
16696	1728	4706
16696	1728	2928
16696	1728	2187
16696	1728	3791
16696	1728	9049
16696	1728	2600
10592	1729	8597
10592	1729	4983
10592	1729	886
10592	1729	9116
10592	1729	715
10592	1729	4544
17751	1730	2848
17751	1730	9243
17751	1730	8148
17751	1730	2157
17751	1730	8431
17751	1730	8720
17751	1730	52
17751	1730	7295
4555	1731	3756
4555	1731	5024
19134	1732	8443
19134	1732	539
19134	1732	5454
7201	1733	797
7201	1733	3238
7201	1733	1987
7201	1733	6135
7201	1733	1937
7201	1733	1559
7201	1733	8183
7201	1733	9884
19115	1734	2311
19115	1734	6166
19115	1734	2506
19115	1734	2630
19115	1734	5220
19115	1734	7312
19115	1734	6688
19115	1734	5532
19115	1734	3838
11549	1735	7127
11549	1735	4827
11549	1735	9769
11549	1735	6568
11549	1735	4474
11549	1735	3758
11549	1735	1727
11549	1735	2259
11549	1735	5094
4810	1736	2954
4810	1736	5160
4810	1736	690
4810	1736	2565
4810	1736	2627
4810	1736	5634
10805	1737	7945
10805	1737	2147
10805	1737	7176
18867	1738	6912
18867	1738	5463
18867	1738	4515
19348	1739	2788
10828	1740	2867
10828	1740	225
10828	1740	7434
10828	1740	1466
10828	1740	9871
15672	1741	894
15672	1741	9711
8450	1742	3899
8450	1742	4938
8450	1742	7751
8450	1742	2100
8450	1742	8949
18347	1743	7343
18347	1743	6392
18347	1743	1
18347	1743	5050
18347	1743	1526
18347	1743	3060
18347	1743	2300
14143	1744	7051
14143	1744	6046
14143	1744	2331
14143	1744	16
14143	1744	3111
14143	1744	453
14143	1744	6205
14143	1744	4366
14143	1744	5009
117	1745	6002
117	1745	5203
117	1745	3948
117	1745	5372
4845	1746	7224
4845	1746	4215
4845	1746	9029
4845	1746	6633
4845	1746	331
4845	1746	7277
4570	1747	2343
4570	1747	1839
4570	1747	7000
4570	1747	6645
4570	1747	7705
4570	1747	8162
4570	1747	4439
4570	1747	3798
16024	1748	5338
11337	1749	365
11337	1749	9402
11337	1749	1678
11337	1749	927
11337	1749	88
11337	1749	557
11337	1749	8873
14069	1750	616
14069	1750	4850
14069	1750	7799
6272	1751	8804
6272	1751	9261
17323	1752	406
17323	1752	6652
17323	1752	7446
12637	1753	3353
12637	1753	9162
12637	1753	1247
12637	1753	5914
12637	1753	7762
12637	1753	2181
1969	1754	153
1969	1754	8284
1969	1754	9295
1969	1754	8266
1969	1754	9183
1969	1754	3156
1969	1754	2030
1969	1754	2383
1969	1754	85
2663	1755	376
2663	1755	3482
2663	1755	361
2663	1755	3541
2663	1755	3466
3499	1756	439
19242	1757	6030
19242	1757	8242
19242	1757	3826
19242	1757	9956
19242	1757	9657
19242	1757	8440
19242	1757	8826
19242	1757	2589
19242	1757	5764
18459	1758	979
18459	1758	5982
18459	1758	2965
18459	1758	1038
18459	1758	2059
599	1759	8625
599	1759	4826
6530	1760	5186
6530	1760	8955
6530	1760	7033
6530	1760	179
6530	1760	8669
6530	1760	9117
6530	1760	2574
6530	1760	7092
6530	1760	1461
18568	1761	934
18568	1761	1590
18568	1761	6356
18568	1761	9024
18568	1761	2302
18568	1761	5574
5213	1762	9462
5213	1762	6493
5213	1762	7775
5213	1762	659
5213	1762	2678
6711	1763	9512
6711	1763	1539
6711	1763	8095
6711	1763	3635
11871	1764	7192
11871	1764	743
11871	1764	1821
11871	1764	4775
11871	1764	8783
11871	1764	7380
11871	1764	7416
11871	1764	1561
5927	1765	5300
5927	1765	4025
5927	1765	4329
13784	1766	5029
13784	1766	8325
291	1767	8459
291	1767	9759
291	1767	4200
291	1767	5896
291	1767	8606
291	1767	8724
291	1767	2232
12513	1768	3916
12513	1768	1157
12513	1768	9770
12513	1768	8295
1459	1769	7938
1459	1769	2691
1459	1769	2537
1459	1769	4870
1459	1769	2651
1459	1769	7742
1459	1769	6977
1459	1769	5396
5627	1770	744
1026	1771	8607
1026	1771	6678
1026	1771	8408
1026	1771	3544
1026	1771	2312
1026	1771	7989
1278	1772	2013
1278	1772	2228
1278	1772	4547
11449	1773	8058
13154	1774	7052
10919	1775	6558
9093	1776	5186
14395	1777	4606
14395	1777	4007
14395	1777	1552
14395	1777	5791
14395	1777	8865
2138	1778	9951
2138	1778	8697
2138	1778	4753
2612	1779	2373
2612	1779	5896
2612	1779	2183
13577	1780	1615
13577	1780	7861
13577	1780	4163
13577	1780	4672
13577	1780	7794
15490	1781	1194
15490	1781	7537
15490	1781	2359
9463	1782	427
9463	1782	5770
9463	1782	1294
9463	1782	6923
9463	1782	3326
9463	1782	313
9463	1782	1508
9463	1782	7837
2844	1783	3704
2844	1783	4359
2844	1783	8691
2780	1784	9984
11508	1785	4526
11508	1785	9605
11508	1785	5252
11508	1785	5340
11508	1785	4901
11508	1785	6061
11508	1785	4598
16602	1786	9541
16602	1786	6288
16602	1786	1427
16602	1786	9016
16602	1786	9612
16602	1786	7164
16602	1786	1117
16602	1786	3626
16602	1786	9542
9763	1787	8057
9763	1787	7446
9763	1787	4802
9763	1787	956
9763	1787	2228
17032	1788	6252
17032	1788	9021
17032	1788	2048
17032	1788	9020
17032	1788	7875
17032	1788	3886
17032	1788	1521
14312	1789	8852
7307	1790	9801
7307	1790	4460
7307	1790	911
7307	1790	3596
5233	1791	8801
5233	1791	5912
5233	1791	4690
12421	1792	3367
12421	1792	6741
12421	1792	1894
12421	1792	5871
12421	1792	3712
12421	1792	4455
10730	1793	2527
10730	1793	7869
10730	1793	4690
10730	1793	7597
10730	1793	3344
14867	1794	3821
14867	1794	9104
14867	1794	4081
14867	1794	310
14867	1794	3059
15026	1795	2878
15026	1795	2531
15026	1795	5377
15026	1795	957
15026	1795	7068
15026	1795	668
15026	1795	839
18670	1796	1198
18670	1796	2226
5070	1797	6556
5070	1797	6458
5070	1797	8129
5070	1797	2183
5070	1797	4740
5070	1797	1058
5070	1797	7626
5070	1797	4249
5070	1797	8535
12757	1798	8043
12757	1798	31
12757	1798	897
12757	1798	2803
12757	1798	4861
2635	1799	653
2635	1799	5762
2635	1799	7848
2635	1799	1088
2635	1799	4944
6957	1800	9857
6957	1800	8266
6957	1800	463
2719	1801	7484
8917	1802	9562
8917	1802	8722
8917	1802	6434
8917	1802	2142
8917	1802	2042
8917	1802	2856
8917	1802	564
8917	1802	8931
14393	1803	5493
14393	1803	9944
14393	1803	7454
14393	1803	8777
14393	1803	1886
14393	1803	6215
14393	1803	209
14393	1803	6770
17823	1804	5997
17823	1804	9354
17823	1804	296
17823	1804	6979
10595	1805	1783
18473	1806	7018
18473	1806	8620
18473	1806	7705
18473	1806	8167
18473	1806	5470
18473	1806	3386
18473	1806	3218
18473	1806	6649
18473	1806	5942
5841	1807	8218
5841	1807	7308
5841	1807	9308
5841	1807	9237
5841	1807	7438
5841	1807	9938
15285	1808	2117
15285	1808	7323
15285	1808	9987
15285	1808	4884
15285	1808	3112
15285	1808	3581
15285	1808	3746
3926	1809	1963
3926	1809	5595
3926	1809	4291
3926	1809	7453
3926	1809	9090
3926	1809	1871
3926	1809	4588
3820	1810	2450
3820	1810	954
3820	1810	5198
3820	1810	9528
19659	1811	7440
19659	1811	5390
19659	1811	4067
19659	1811	6065
19659	1811	3909
11558	1812	9766
11558	1812	4954
11558	1812	7778
17462	1813	3265
17462	1813	7766
17462	1813	2322
17462	1813	1518
17462	1813	1538
17462	1813	2794
17462	1813	6588
17462	1813	7124
11159	1814	8623
11159	1814	6603
11159	1814	5295
17842	1815	7745
17842	1815	6436
17842	1815	3115
17842	1815	4180
11436	1816	1323
11436	1816	169
8363	1817	7324
8363	1817	939
8363	1817	6224
8363	1817	8307
8363	1817	5154
5797	1818	8408
5797	1818	6338
5797	1818	5540
5797	1818	8306
5797	1818	6164
5797	1818	5206
5797	1818	8074
4197	1819	4746
4197	1819	1763
4197	1819	5897
4197	1819	8172
4197	1819	1488
4197	1819	3949
4197	1819	6898
4197	1819	190
11460	1820	2809
11460	1820	2877
11460	1820	585
2196	1821	8935
1395	1822	767
1395	1822	7179
1395	1822	6253
1395	1822	1537
1395	1822	3484
1395	1822	6386
8948	1823	8727
18622	1824	409
18686	1825	40
1614	1826	3061
1614	1826	5351
1614	1826	1449
1614	1826	6323
7558	1827	4043
7558	1827	3494
7558	1827	345
7558	1827	2440
7558	1827	7551
7558	1827	96
7558	1827	4043
7558	1827	9010
7558	1827	943
8007	1828	8601
9846	1829	8702
9846	1829	5696
9846	1829	1976
9846	1829	5065
9846	1829	8186
9846	1829	3073
9846	1829	629
9342	1830	5758
9342	1830	9699
9342	1830	8249
9342	1830	1728
9342	1830	9855
9342	1830	1772
9342	1830	7978
9342	1830	9432
2814	1831	3727
2814	1831	5785
2814	1831	6784
2814	1831	9968
2814	1831	1085
2814	1831	5062
2814	1831	7518
2814	1831	7909
19273	1832	859
19273	1832	2157
19273	1832	4861
19273	1832	2509
10741	1833	6418
10741	1833	3521
10741	1833	8558
10741	1833	9620
10741	1833	6760
10741	1833	6484
10741	1833	9442
6509	1834	6921
6509	1834	7045
6509	1834	3723
12463	1835	1602
12463	1835	380
12463	1835	8485
12463	1835	1220
1678	1836	5520
1678	1836	8425
1678	1836	7560
1678	1836	8216
10273	1837	4214
10273	1837	74
10273	1837	6428
10273	1837	8537
10273	1837	6396
10273	1837	6049
10273	1837	2817
10273	1837	1923
17214	1838	1774
17214	1838	8589
17214	1838	1246
17214	1838	921
14791	1839	7592
14791	1839	1030
14791	1839	668
14791	1839	2050
14791	1839	8483
14791	1839	1944
7733	1840	2473
7733	1840	7102
7733	1840	8636
7733	1840	3580
9002	1841	1896
9002	1841	585
9002	1841	3401
9002	1841	3507
11113	1842	3654
11113	1842	963
11113	1842	6941
11113	1842	2495
11113	1842	8325
11113	1842	3661
11113	1842	5285
11113	1842	6840
11113	1842	1741
7273	1843	3124
7273	1843	4410
7273	1843	9348
957	1844	3553
957	1844	4861
957	1844	8683
957	1844	9908
957	1844	6951
957	1844	3967
1612	1845	9896
1612	1845	6185
1612	1845	5017
18851	1846	5016
18851	1846	6879
18851	1846	3967
18851	1846	6485
18851	1846	926
18851	1846	6182
6264	1847	5367
6264	1847	6946
6264	1847	7757
6264	1847	7602
6264	1847	8615
6264	1847	3249
18376	1848	7314
18376	1848	7327
18376	1848	9378
18376	1848	107
18376	1848	8978
18376	1848	1136
18376	1848	9421
9575	1849	167
9575	1849	1076
9575	1849	2442
9575	1849	385
4856	1850	9486
4856	1850	6371
4856	1850	3471
4856	1850	624
4856	1850	6052
4856	1850	9867
4856	1850	752
16084	1851	2277
16084	1851	1969
16084	1851	2008
16084	1851	3043
16799	1852	5824
16799	1852	7170
16799	1852	1118
16799	1852	7943
16799	1852	4218
8169	1853	3371
8169	1853	135
4824	1854	5765
4824	1854	3752
4824	1854	6085
4824	1854	7206
4824	1854	8830
4824	1854	5211
4824	1854	5224
4824	1854	6640
4824	1854	8070
18823	1855	1505
18823	1855	2245
18823	1855	5757
18823	1855	4051
18823	1855	8958
18823	1855	1135
18823	1855	8622
18823	1855	6560
10780	1856	1389
10780	1856	9662
10780	1856	7246
10780	1856	8886
7655	1857	2140
7655	1857	286
7655	1857	4605
7655	1857	5339
7655	1857	4152
7655	1857	6271
7655	1857	3692
7655	1857	8599
14910	1858	1535
14910	1858	7637
14910	1858	2542
14910	1858	3184
14910	1858	350
14910	1858	8331
14910	1858	917
14910	1858	387
14910	1858	2953
14207	1859	9876
14207	1859	8184
14207	1859	7704
14207	1859	5930
14207	1859	6012
7298	1860	172
1043	1861	3011
1043	1861	6834
1043	1861	1792
1043	1861	9122
1043	1861	6890
1043	1861	6229
1043	1861	7207
1043	1861	5239
2335	1862	8631
2335	1862	476
2335	1862	5628
2335	1862	4301
2335	1862	1169
2335	1862	3734
2335	1862	5927
15437	1863	8593
15437	1863	8015
15437	1863	4007
15437	1863	9233
15437	1863	131
15437	1863	413
15437	1863	6875
14700	1864	7998
14700	1864	4458
14700	1864	7872
14700	1864	3345
14700	1864	8758
14700	1864	1517
14700	1864	7618
14700	1864	6353
14700	1864	4930
8325	1865	4210
2168	1866	8434
2168	1866	1133
11179	1867	3780
11179	1867	2862
11179	1867	9861
11179	1867	1648
11179	1867	4487
11179	1867	3111
11179	1867	8359
11179	1867	3579
11179	1867	4948
7645	1868	6013
7645	1868	10
7645	1868	3737
7645	1868	2735
7645	1868	264
7645	1868	8274
7645	1868	9051
1396	1869	8697
1396	1869	1405
9966	1870	2771
9966	1870	1456
9966	1870	28
9966	1870	8948
9966	1870	4614
9966	1870	1238
9966	1870	2017
580	1871	8425
580	1871	3609
580	1871	4119
11046	1872	506
11046	1872	3079
11046	1872	7371
11046	1872	4919
11046	1872	2003
13231	1873	3963
13231	1873	176
13231	1873	8858
13231	1873	735
13231	1873	6932
13231	1873	1318
13231	1873	6649
13231	1873	6573
14157	1874	355
14157	1874	7134
14157	1874	5156
5183	1875	1265
5183	1875	4257
5183	1875	7537
5183	1875	6243
5183	1875	396
5183	1875	2615
18527	1876	5274
11320	1877	3418
11320	1877	3503
11320	1877	4178
11320	1877	1165
11320	1877	8332
11320	1877	9643
11320	1877	3869
11320	1877	5702
12194	1878	7810
12194	1878	7329
12194	1878	8306
12194	1878	8909
12194	1878	8262
12194	1878	4411
12194	1878	1860
12194	1878	252
2831	1879	3844
2831	1879	1474
2831	1879	2789
2831	1879	7823
2831	1879	3273
2831	1879	6304
2831	1879	8616
2831	1879	4680
7176	1880	405
7176	1880	6173
7176	1880	5425
7176	1880	8303
7176	1880	7840
3368	1881	9396
3368	1881	3514
3368	1881	905
3368	1881	8327
3368	1881	7868
3368	1881	840
14145	1882	1567
14145	1882	4478
14145	1882	8804
14145	1882	4164
14145	1882	5882
14145	1882	1376
14145	1882	3687
6165	1883	302
17255	1884	5570
17255	1884	7799
17255	1884	9945
17255	1884	6398
17255	1884	472
18552	1885	6383
18552	1885	5417
18552	1885	7406
18552	1885	9012
5862	1886	7756
5862	1886	1115
5862	1886	7726
11049	1887	9458
11049	1887	4114
11049	1887	3388
8330	1888	824
8330	1888	3345
8330	1888	1298
8330	1888	2720
8330	1888	5286
8330	1888	5971
14170	1889	3769
14170	1889	3533
14170	1889	8090
14170	1889	2398
14170	1889	2919
14170	1889	5568
14170	1889	9950
14170	1889	7710
2108	1890	3409
2108	1890	9321
2108	1890	9531
2108	1890	1736
2108	1890	2376
2108	1890	7822
2708	1891	4344
2708	1891	344
2708	1891	4210
2708	1891	9385
2708	1891	8256
2708	1891	4933
2708	1891	8149
2708	1891	8632
15905	1892	3243
15905	1892	5000
15905	1892	6553
15905	1892	1763
15905	1892	4175
17036	1893	5780
17036	1893	999
17036	1893	4585
17036	1893	2259
17036	1893	2050
1363	1894	8634
1363	1894	4296
1363	1894	4205
1363	1894	7495
1363	1894	2117
1363	1894	7361
1363	1894	7047
1363	1894	4809
1363	1894	7192
16381	1895	7445
16381	1895	7788
16381	1895	8418
16381	1895	176
16381	1895	349
16381	1895	2599
16381	1895	685
16381	1895	3941
12114	1896	2348
12114	1896	7025
12114	1896	7744
12114	1896	7743
12114	1896	2407
19704	1897	9346
19704	1897	8727
19704	1897	306
19704	1897	8330
19704	1897	3721
19704	1897	9708
19704	1897	7193
9256	1898	9110
9256	1898	3220
9256	1898	3431
9256	1898	8283
9256	1898	4457
9256	1898	5689
10069	1899	4556
10069	1899	3272
10069	1899	9095
10069	1899	1899
18181	1900	3719
18181	1900	4434
18181	1900	7473
18181	1900	9682
18181	1900	8616
18181	1900	6741
18181	1900	5947
18181	1900	9035
9840	1901	1110
9840	1901	4904
13603	1902	5892
19220	1903	2438
19220	1903	986
19220	1903	1710
16900	1904	879
16900	1904	7445
16900	1904	6628
16900	1904	361
16900	1904	1941
16900	1904	7942
13894	1905	2023
13894	1905	7567
13894	1905	576
13894	1905	6164
13894	1905	2124
13894	1905	1163
13894	1905	6323
13894	1905	8235
11359	1906	8736
11359	1906	9908
15698	1907	4796
15698	1907	1189
15698	1907	4082
9315	1908	6219
9315	1908	6211
9315	1908	3089
9315	1908	1217
9315	1908	9734
9315	1908	7003
9315	1908	8931
9315	1908	1180
4692	1909	5578
4692	1909	1746
4692	1909	8300
4692	1909	5521
4692	1909	485
13406	1910	4084
13406	1910	7555
13406	1910	9576
13406	1910	2060
13406	1910	2565
7489	1911	6091
7489	1911	3640
7489	1911	7995
7489	1911	8433
7489	1911	1213
7489	1911	6768
7489	1911	8234
7489	1911	8401
4968	1912	7784
4968	1912	5442
4968	1912	7802
4968	1912	834
4968	1912	1751
4968	1912	8850
4968	1912	7175
4968	1912	9508
15882	1913	1895
15882	1913	784
15882	1913	3808
15882	1913	3525
15882	1913	1668
15882	1913	2560
15882	1913	6397
15882	1913	9296
15882	1913	6007
15515	1914	5598
15515	1914	5654
15515	1914	3133
9190	1915	2824
9190	1915	5068
9190	1915	2582
9190	1915	1038
9190	1915	3765
321	1916	4359
321	1916	3125
321	1916	5362
1919	1917	6065
1919	1917	1021
1919	1917	9605
1919	1917	4050
1919	1917	7034
1919	1917	9060
1919	1917	7710
2947	1918	1634
2947	1918	562
2947	1918	2896
2947	1918	4666
2947	1918	7602
2947	1918	9217
2947	1918	3998
10036	1919	8654
10036	1919	6524
10036	1919	7559
10036	1919	5303
18335	1920	6734
18335	1920	4665
18335	1920	4367
18335	1920	983
18335	1920	5818
18335	1920	5537
18335	1920	8064
18335	1920	316
18335	1920	4552
6409	1921	8892
6409	1921	8756
6409	1921	5974
5429	1922	1089
10911	1923	4487
10911	1923	6956
10911	1923	6886
10911	1923	9557
10911	1923	7572
10911	1923	1908
10911	1923	7312
10911	1923	7392
12294	1924	583
12294	1924	4448
11073	1925	992
11073	1925	9613
13135	1926	1586
13135	1926	4837
13135	1926	9165
13135	1926	3377
13135	1926	1799
13135	1926	2679
13135	1926	6915
14993	1927	1888
14993	1927	9277
14993	1927	1924
14993	1927	3651
8802	1928	2037
8802	1928	6306
10941	1929	1947
10941	1929	2989
19807	1930	7400
19807	1930	6007
19807	1930	5216
14280	1931	8676
14280	1931	2091
14280	1931	2547
14280	1931	6467
14280	1931	1002
14280	1931	4323
14280	1931	7533
1043	1932	425
1043	1932	5276
1043	1932	3128
16688	1933	5484
16688	1933	8841
1863	1934	5060
1863	1934	4814
1863	1934	2716
1863	1934	679
1863	1934	5404
1863	1934	770
2388	1935	9018
2388	1935	279
2388	1935	6366
2388	1935	7279
2388	1935	8962
2388	1935	6007
2388	1935	7051
2388	1935	8339
2388	1935	4348
14125	1936	7311
14125	1936	9561
14125	1936	3990
14125	1936	9273
14125	1936	2278
14125	1936	6905
14125	1936	4419
14125	1936	9401
16725	1937	740
16725	1937	8068
4830	1938	9477
4830	1938	3996
4830	1938	2208
4830	1938	4867
4830	1938	6838
18231	1939	1672
18231	1939	5254
744	1940	1496
744	1940	1231
744	1940	9253
744	1940	1979
744	1940	3355
744	1940	5999
16414	1941	4404
16414	1941	7247
16414	1941	6859
17061	1942	9603
17061	1942	7094
17061	1942	1433
17061	1942	9211
17061	1942	8153
17061	1942	871
17061	1942	9946
11889	1943	4151
11889	1943	2936
11889	1943	225
11889	1943	8039
11889	1943	9858
11889	1943	5614
11889	1943	6228
11889	1943	1452
11889	1943	4253
6928	1944	1927
3745	1945	7817
3745	1945	1608
9087	1946	4726
9087	1946	2009
9087	1946	8067
9087	1946	965
9087	1946	2838
14182	1947	555
14182	1947	9591
14182	1947	7266
14182	1947	4354
14182	1947	1565
14182	1947	128
14182	1947	4138
14182	1947	7716
14182	1947	9754
3525	1948	9385
3525	1948	5580
6390	1949	2722
6390	1949	6553
6390	1949	2349
6390	1949	2096
6390	1949	1726
6390	1949	8871
6016	1950	7667
6016	1950	6989
6016	1950	8198
6016	1950	2172
6016	1950	2000
4809	1951	8109
4809	1951	8984
4809	1951	5979
4809	1951	8479
4809	1951	8034
4809	1951	1735
4809	1951	2058
4809	1951	9912
4809	1951	3115
207	1952	4115
207	1952	953
207	1952	8387
207	1952	8519
13255	1953	1289
13255	1953	189
13255	1953	7051
13255	1953	9971
13255	1953	5127
13255	1953	7353
13255	1953	767
13255	1953	2618
2164	1954	1718
2164	1954	800
2164	1954	1020
2164	1954	9437
2164	1954	5946
14468	1955	7000
14468	1955	8161
14468	1955	7248
14468	1955	8999
14468	1955	8326
14468	1955	5067
14468	1955	5706
14468	1955	2025
14468	1955	323
2244	1956	440
2244	1956	7193
2244	1956	5719
2244	1956	3619
2244	1956	6880
2244	1956	5593
5682	1957	7441
5682	1957	6352
5682	1957	7595
5682	1957	8146
5682	1957	7075
5682	1957	3361
14414	1958	490
12415	1959	3338
17861	1960	1772
17861	1960	4829
17861	1960	9688
17861	1960	1721
17861	1960	3238
17861	1960	6900
17861	1960	8333
17861	1960	2666
2641	1961	7167
2641	1961	4164
2641	1961	4399
2641	1961	9624
2641	1961	6432
2641	1961	3292
2641	1961	7367
2641	1961	7416
18271	1962	9001
18271	1962	2850
18271	1962	1494
17921	1963	6917
17921	1963	7571
17921	1963	3958
7161	1964	7912
7161	1964	3215
7161	1964	8433
7161	1964	2332
7161	1964	9765
17531	1965	6099
17531	1965	8635
17531	1965	8355
10541	1966	6350
10541	1966	4098
2236	1967	1430
2236	1967	199
2236	1967	3785
2236	1967	7595
2236	1967	9196
14192	1968	6490
14192	1968	9766
14192	1968	5089
14192	1968	114
14192	1968	6454
14192	1968	7990
14192	1968	1394
14192	1968	1669
6197	1969	2960
1109	1970	8419
1109	1970	8940
10858	1971	272
10858	1971	6642
10858	1971	8671
13320	1972	1659
13320	1972	9577
13320	1972	8413
13320	1972	1697
13320	1972	2341
13320	1972	1927
13320	1972	6189
13320	1972	8304
1711	1973	3173
1711	1973	2880
1711	1973	1214
1711	1973	2909
1711	1973	8210
1711	1973	6305
1711	1973	1870
1711	1973	1447
6286	1974	7488
6286	1974	6453
6286	1974	3928
7352	1975	2445
7352	1975	188
7352	1975	8600
7352	1975	6874
7352	1975	9465
7352	1975	8063
7352	1975	4951
7352	1975	1650
7352	1975	215
3739	1976	5452
3739	1976	704
3739	1976	5094
3739	1976	3055
3739	1976	8867
3739	1976	9491
3739	1976	824
15394	1977	2780
15394	1977	5689
15394	1977	7593
15394	1977	4128
15394	1977	8934
15394	1977	9676
15394	1977	695
15394	1977	3156
15394	1977	4506
15120	1978	3059
15120	1978	8826
15120	1978	6536
15120	1978	1579
15120	1978	9200
15120	1978	3795
15120	1978	2090
15120	1978	2226
15120	1978	9194
17740	1979	3997
17005	1980	6062
17005	1980	2654
17005	1980	2782
18636	1981	5452
18636	1981	8940
18636	1981	4848
18636	1981	633
18636	1981	7247
14263	1982	7712
14263	1982	9341
9443	1983	9058
9443	1983	6376
9443	1983	6705
9443	1983	1157
9443	1983	3959
9443	1983	7424
9443	1983	5853
12970	1984	6311
12970	1984	8306
12033	1985	5706
12033	1985	3844
12033	1985	6148
12033	1985	3504
12033	1985	4740
12033	1985	1901
12033	1985	7673
12033	1985	2504
12033	1985	8759
5372	1986	3860
5372	1986	4284
5372	1986	6159
5372	1986	8182
5372	1986	3189
5372	1986	2748
5372	1986	2165
11337	1987	5877
11337	1987	570
11337	1987	9179
11337	1987	8645
11337	1987	1431
12544	1988	7424
12544	1988	6648
12544	1988	1071
12544	1988	7438
12544	1988	8716
1762	1989	6549
1762	1989	5900
12938	1990	9543
12938	1990	932
12938	1990	631
6703	1991	356
6703	1991	8250
6703	1991	7513
6703	1991	5686
6703	1991	5872
9903	1992	5449
9903	1992	6083
9903	1992	572
9903	1992	2259
6380	1993	4744
6380	1993	657
6380	1993	2998
6380	1993	3464
6380	1993	2439
6380	1993	6934
6380	1993	7205
8628	1994	7972
8628	1994	7409
8628	1994	2470
9456	1995	7918
9456	1995	92
9456	1995	7512
1018	1996	1756
1018	1996	7881
1018	1996	2324
1018	1996	1495
1018	1996	9400
1018	1996	732
1018	1996	2457
9851	1997	9654
9851	1997	322
9851	1997	3397
9851	1997	232
9851	1997	1162
9851	1997	1418
9851	1997	577
16915	1998	3543
16915	1998	6871
16915	1998	2609
16915	1998	313
16915	1998	5743
16915	1998	9991
16915	1998	9274
16915	1998	6081
16915	1998	7214
14892	1999	1119
14892	1999	4092
2426	2000	658
2426	2000	196
2426	2000	6638
2426	2000	5130
2426	2000	7869
2426	2000	8688
2426	2000	2737
931	2001	9702
931	2001	3782
931	2001	2714
931	2001	4178
931	2001	4
14397	2002	7109
14397	2002	8084
14397	2002	4034
14397	2002	6602
14397	2002	7593
14397	2002	7983
14397	2002	5038
14397	2002	503
409	2003	8385
409	2003	1965
409	2003	6491
409	2003	8342
409	2003	9167
409	2003	1545
409	2003	1012
409	2003	556
14315	2004	2115
14315	2004	3555
14315	2004	4071
14315	2004	2985
14589	2005	4317
14589	2005	5209
14589	2005	70
18473	2006	5511
18473	2006	5469
18473	2006	6883
18473	2006	3223
18473	2006	4909
18473	2006	9068
6276	2007	1352
6276	2007	2768
6276	2007	9427
6276	2007	5591
6276	2007	7891
4374	2008	8027
4374	2008	847
4374	2008	6473
4374	2008	4888
4374	2008	1712
4374	2008	5033
4374	2008	8260
4374	2008	3918
4374	2008	2995
11524	2009	2847
11524	2009	1621
11524	2009	4007
11524	2009	2924
11524	2009	8816
11524	2009	9311
11524	2009	4446
18666	2010	9130
18666	2010	9881
18666	2010	8034
18666	2010	8168
18666	2010	9067
18666	2010	6790
18666	2010	2714
18666	2010	170
18666	2010	373
6593	2011	4247
6593	2011	2616
6593	2011	8173
7303	2012	4164
7303	2012	4543
7303	2012	2787
7303	2012	3224
7303	2012	8439
7303	2012	3676
7303	2012	9650
44	2013	3319
44	2013	2579
44	2013	3490
44	2013	6257
44	2013	5201
44	2013	5314
44	2013	1436
44	2013	3296
44	2013	1673
9794	2014	4911
9794	2014	8279
9794	2014	5454
9794	2014	4582
9794	2014	3389
9794	2014	4575
9794	2014	5464
3441	2015	6002
3441	2015	670
3441	2015	4516
3441	2015	3415
3441	2015	46
3441	2015	1086
11992	2016	556
11992	2016	1275
11992	2016	8516
11992	2016	3036
11992	2016	631
11992	2016	1155
11992	2016	220
12442	2017	3658
12442	2017	2788
12442	2017	6625
12442	2017	9177
12442	2017	813
12442	2017	3706
12442	2017	5919
12442	2017	5442
7915	2018	7048
7915	2018	932
7915	2018	4279
4866	2019	1257
4866	2019	5437
4866	2019	8101
4866	2019	6877
4866	2019	9771
6952	2020	7737
6952	2020	8797
1305	2021	3139
1305	2021	2738
1305	2021	1649
1305	2021	9850
1305	2021	6821
4515	2022	4319
4515	2022	5427
4515	2022	9717
4515	2022	7564
4515	2022	2716
4515	2022	1337
4515	2022	2434
4515	2022	2165
10607	2023	2721
10607	2023	7919
10607	2023	3164
10607	2023	3677
10607	2023	6997
10607	2023	1362
13577	2024	7901
1231	2025	2128
1231	2025	8537
1231	2025	2699
1231	2025	9596
1231	2025	7997
1231	2025	9338
1231	2025	4886
1231	2025	654
1231	2025	5714
14151	2026	3864
14151	2026	8810
14151	2026	7335
14151	2026	2379
14151	2026	6896
14151	2026	6301
14151	2026	8799
14151	2026	7329
10651	2027	1241
10651	2027	6032
10651	2027	4158
10651	2027	9545
17019	2028	2877
17019	2028	4448
17019	2028	5781
5353	2029	8108
5353	2029	1111
10607	2030	8834
10607	2030	4830
10607	2030	3897
10607	2030	6612
10607	2030	534
10607	2030	1950
10607	2030	8117
10607	2030	8918
10607	2030	5037
1697	2031	2961
8142	2032	9374
8142	2032	8615
8142	2032	3683
8142	2032	3073
8142	2032	2433
8142	2032	1019
8142	2032	5117
8142	2032	3286
8142	2032	7795
5663	2033	3680
5663	2033	5912
5663	2033	9758
5663	2033	711
5663	2033	6147
9524	2034	8207
9524	2034	3618
9524	2034	1050
9524	2034	3605
9524	2034	7605
9524	2034	9398
10390	2035	383
10390	2035	270
10390	2035	8550
10390	2035	3060
10390	2035	703
10390	2035	9346
15275	2036	9003
15275	2036	2814
12836	2037	3308
12836	2037	354
12836	2037	810
12836	2037	8395
12836	2037	493
18086	2038	8304
15297	2039	5286
15297	2039	5895
15297	2039	4265
15297	2039	4341
1115	2040	6172
1115	2040	835
1115	2040	5507
1115	2040	8173
1115	2040	7893
1115	2040	5043
1115	2040	6203
1115	2040	5977
16859	2041	9979
16859	2041	568
16859	2041	4276
16859	2041	5859
16859	2041	5465
16859	2041	7836
17339	2042	7898
17339	2042	858
17339	2042	2449
17339	2042	2375
17339	2042	9245
478	2043	6518
478	2043	9846
478	2043	1002
478	2043	1994
14918	2044	9096
14918	2044	28
15852	2045	3717
15852	2045	255
15852	2045	5605
15852	2045	4442
2443	2046	7980
2443	2046	3342
2443	2046	8454
2443	2046	5843
2443	2046	2794
2443	2046	3336
6727	2047	1289
6727	2047	1623
6727	2047	1061
6727	2047	1096
6727	2047	1376
6727	2047	6875
6727	2047	6759
9477	2048	3721
19126	2049	4694
19126	2049	728
19126	2049	2821
19126	2049	5731
19126	2049	4438
19126	2049	9116
19126	2049	9229
19126	2049	2164
18076	2050	399
18076	2050	7245
18076	2050	9796
11683	2051	4680
11683	2051	5818
11683	2051	3684
11683	2051	5738
11683	2051	2749
11683	2051	6767
11991	2052	6600
11991	2052	6875
11991	2052	329
11991	2052	7403
11991	2052	3365
11991	2052	8538
11991	2052	3040
11991	2052	9961
11557	2053	4417
11557	2053	7384
11557	2053	9040
11557	2053	9028
11557	2053	146
11557	2053	2551
11557	2053	8924
11557	2053	5062
4929	2054	9664
5406	2055	423
5406	2055	9404
5406	2055	6684
5406	2055	2414
2908	2056	6167
17435	2057	8143
9682	2058	4904
9682	2058	1479
9682	2058	5000
9682	2058	2193
9682	2058	4621
9682	2058	8972
2771	2059	2840
2771	2059	6414
2771	2059	1952
2771	2059	7724
2771	2059	7566
2771	2059	7229
19724	2060	2159
19724	2060	4179
19724	2060	356
19724	2060	2580
19724	2060	7968
19724	2060	6282
3307	2061	5243
3307	2061	4782
3307	2061	3726
3307	2061	4254
3307	2061	8371
3307	2061	8148
2237	2062	5568
2237	2062	660
2237	2062	5238
2237	2062	900
14362	2063	8834
14362	2063	3504
14362	2063	2571
14362	2063	1272
14362	2063	790
14362	2063	7587
14362	2063	7007
16701	2064	1853
16701	2064	1792
16701	2064	8343
18485	2065	6423
10514	2066	9334
10514	2066	57
1693	2067	7
1693	2067	5381
1693	2067	1487
1693	2067	1170
1693	2067	4653
1693	2067	5851
1693	2067	9990
1693	2067	2238
1693	2067	2144
826	2068	2185
4483	2069	3088
4483	2069	7710
4483	2069	3122
4483	2069	1338
4483	2069	5323
4483	2069	7948
4483	2069	5468
4483	2069	2971
10416	2070	3868
10416	2070	7957
10416	2070	2964
10416	2070	1036
10416	2070	2383
10416	2070	7030
10416	2070	4877
15996	2071	2606
15996	2071	2409
15996	2071	3126
15996	2071	4352
15996	2071	3334
15996	2071	1304
15996	2071	7296
15996	2071	1739
15996	2071	2957
7985	2072	8884
7985	2072	3244
7985	2072	5437
7985	2072	1758
7985	2072	1709
7985	2072	6416
7985	2072	4917
18536	2073	9020
18536	2073	4340
18536	2073	2113
18536	2073	1566
18536	2073	781
8898	2074	5147
8898	2074	1705
8898	2074	9782
8898	2074	3848
8898	2074	7825
8898	2074	5607
8898	2074	9805
8898	2074	2009
2057	2075	7343
2057	2075	3341
2057	2075	9565
2057	2075	5867
2057	2075	8570
2057	2075	6571
2057	2075	8574
16710	2076	9845
16710	2076	8410
16710	2076	2302
16710	2076	3050
16710	2076	3655
16710	2076	5340
16710	2076	3237
16710	2076	533
195	2077	8723
195	2077	8056
195	2077	2984
195	2077	3569
195	2077	4984
195	2077	5430
195	2077	4866
14335	2078	1478
14335	2078	9303
14335	2078	1745
4556	2079	2375
2196	2080	6391
2196	2080	3232
2196	2080	9349
2196	2080	5264
2196	2080	3044
2196	2080	8618
1340	2081	6377
1340	2081	5591
1340	2081	8494
1340	2081	400
1340	2081	6180
1340	2081	7424
1340	2081	3872
1340	2081	1330
9122	2082	2776
9122	2082	2697
9122	2082	5614
9122	2082	9142
9122	2082	1984
9122	2082	1683
9122	2082	1748
9122	2082	6483
13763	2083	9655
13763	2083	3270
13763	2083	1781
13763	2083	3789
13763	2083	9161
13763	2083	8271
13763	2083	9495
13763	2083	7754
13790	2084	2688
13790	2084	2626
13790	2084	6974
13790	2084	4677
5055	2085	7803
5055	2085	9170
5055	2085	5749
5055	2085	9935
5055	2085	6969
5055	2085	6844
9195	2086	1493
9195	2086	5718
16686	2087	7451
16686	2087	5600
16686	2087	5819
16686	2087	9083
16686	2087	4629
16686	2087	3205
6277	2088	1343
6277	2088	4643
6277	2088	6726
6277	2088	1968
6277	2088	5803
6277	2088	2398
6277	2088	6029
6277	2088	1355
13910	2089	434
10124	2090	5439
10124	2090	86
10124	2090	3641
10124	2090	2851
10124	2090	1943
10124	2090	4497
10124	2090	7793
380	2091	1202
380	2091	1102
380	2091	3700
380	2091	5627
380	2091	4018
380	2091	9196
380	2091	6318
12806	2092	7832
12806	2092	5656
12806	2092	7782
12806	2092	3684
12806	2092	451
12806	2092	5765
12806	2092	2903
8007	2093	2022
8007	2093	420
8007	2093	7469
8007	2093	4310
8007	2093	4249
8007	2093	188
16039	2094	7793
2954	2095	6756
2954	2095	7512
196	2096	6385
196	2096	4469
196	2096	1723
196	2096	6420
196	2096	5722
196	2096	4073
18971	2097	554
18971	2097	3678
18971	2097	3199
18971	2097	3443
18971	2097	1778
18971	2097	9612
18971	2097	1052
18971	2097	2047
13031	2098	8452
8347	2099	84
8024	2100	5734
17864	2101	8886
17864	2101	6992
17864	2101	5663
17864	2101	1771
17864	2101	5480
17864	2101	4225
5353	2102	6850
5353	2102	8902
5353	2102	3309
5353	2102	945
5353	2102	9992
5353	2102	6358
5353	2102	5610
5353	2102	8624
11232	2103	3660
18278	2104	8859
18278	2104	4826
3352	2105	8609
3352	2105	3087
3352	2105	7246
3352	2105	6231
3682	2106	6337
3682	2106	9905
3682	2106	2937
3682	2106	4095
19171	2107	6484
19171	2107	798
3484	2108	5994
3484	2108	7674
3484	2108	1580
3484	2108	6843
3484	2108	5746
3484	2108	1533
3484	2108	7733
3484	2108	1412
11012	2109	5092
11012	2109	9263
11012	2109	2379
11012	2109	3073
11012	2109	1802
11012	2109	12
11012	2109	6990
17139	2110	5814
17139	2110	2890
17139	2110	9417
17139	2110	8784
17139	2110	1292
17139	2110	6335
17139	2110	1486
17139	2110	7365
19486	2111	1634
19486	2111	4561
19486	2111	405
19486	2111	9330
19486	2111	120
19486	2111	9318
4414	2112	2830
4414	2112	8500
4414	2112	5847
4414	2112	6944
4414	2112	6260
4414	2112	8081
4414	2112	4051
11368	2113	7329
11368	2113	1444
11368	2113	3342
11368	2113	7578
11368	2113	7496
11368	2113	4866
11368	2113	3504
11368	2113	2839
11368	2113	1816
17519	2114	3068
17519	2114	2355
17519	2114	2987
8968	2115	6386
19454	2116	2386
19454	2116	199
19454	2116	8858
19454	2116	4946
13522	2117	5521
13522	2117	5637
13522	2117	496
6964	2118	7966
6964	2118	8637
6964	2118	2283
6964	2118	4078
6964	2118	9792
6964	2118	951
6964	2118	3715
6964	2118	3693
18794	2119	1938
18794	2119	8282
17555	2120	2260
17555	2120	3739
17555	2120	4501
17555	2120	4576
17555	2120	7800
15183	2121	7582
2548	2122	671
2548	2122	3798
4158	2123	856
4158	2123	8611
4158	2123	6987
4158	2123	3340
15831	2124	6569
15831	2124	114
15831	2124	8526
17872	2125	850
17872	2125	917
17872	2125	2246
17872	2125	6726
17872	2125	8146
17872	2125	8172
17872	2125	697
17872	2125	9105
7656	2126	6350
7656	2126	2840
7656	2126	205
7656	2126	4158
7656	2126	301
2299	2127	5797
2299	2127	4412
2299	2127	7438
2299	2127	104
2299	2127	9314
2299	2127	767
2299	2127	4837
2299	2127	2246
2299	2127	2330
10337	2128	6533
10337	2128	6233
10337	2128	2343
10337	2128	7983
10337	2128	4604
18030	2129	1572
18030	2129	3165
18030	2129	7204
18030	2129	9303
18030	2129	1345
18030	2129	8828
18030	2129	143
10402	2130	4418
10402	2130	2208
10402	2130	840
10402	2130	1868
10402	2130	3968
537	2131	6673
537	2131	6914
537	2131	6640
537	2131	5917
537	2131	7764
537	2131	1657
997	2132	5873
997	2132	4406
997	2132	4284
997	2132	8269
997	2132	688
997	2132	8138
997	2132	2506
997	2132	1174
16175	2133	4304
16175	2133	5011
16175	2133	3715
16175	2133	9972
16175	2133	7166
16175	2133	1121
16175	2133	603
9772	2134	1037
9772	2134	1623
9772	2134	6604
9772	2134	6855
9772	2134	3306
9772	2134	5865
9772	2134	4269
9772	2134	5331
9772	2134	2235
4413	2135	5285
4413	2135	6149
4413	2135	8285
18112	2136	515
18112	2136	984
15677	2137	5080
15677	2137	2069
15677	2137	928
15677	2137	8628
15677	2137	6444
15677	2137	5369
1306	2138	6540
1306	2138	1098
1306	2138	8183
1306	2138	9123
213	2139	7945
213	2139	4135
213	2139	1469
213	2139	2373
213	2139	3603
213	2139	5559
213	2139	5574
213	2139	8129
17942	2140	8098
17942	2140	5432
17942	2140	5938
17942	2140	4977
17942	2140	4661
17942	2140	388
17942	2140	1499
17942	2140	5629
16003	2141	9002
16003	2141	4374
16003	2141	1850
16003	2141	7833
9845	2142	3111
9845	2142	5851
9845	2142	1535
9845	2142	1010
9845	2142	1617
9845	2142	8799
9845	2142	5920
9845	2142	6083
9845	2142	2429
2859	2143	6004
2859	2143	7850
2859	2143	7649
2859	2143	8759
2859	2143	8894
9488	2144	5570
9488	2144	3906
9488	2144	3323
9488	2144	302
9488	2144	7132
9488	2144	5888
9488	2144	7832
403	2145	4422
403	2145	829
403	2145	9381
403	2145	1268
403	2145	1456
403	2145	3018
403	2145	5156
18123	2146	1766
18123	2146	6863
18123	2146	2460
18123	2146	8457
18123	2146	9611
18123	2146	492
18123	2146	6438
14532	2147	6853
14532	2147	9532
5100	2148	1138
13823	2149	2987
13823	2149	575
18061	2150	8476
18061	2150	3642
11036	2151	6776
11036	2151	6375
11036	2151	7340
11036	2151	8858
11036	2151	2919
11036	2151	2998
11036	2151	6907
11036	2151	4508
10163	2152	4112
10163	2152	9093
10163	2152	7303
10163	2152	7500
10163	2152	8252
10163	2152	6567
10163	2152	8710
12098	2153	4069
14132	2154	2663
14132	2154	6986
14132	2154	347
14132	2154	4992
14132	2154	3398
14132	2154	7046
14132	2154	6818
10138	2155	97
10138	2155	8651
10138	2155	8982
10138	2155	1623
10138	2155	1589
10138	2155	116
5557	2156	500
5557	2156	8210
5557	2156	2418
5557	2156	9575
5557	2156	2308
5557	2156	4008
16463	2157	1165
16463	2157	2988
9221	2158	6419
10641	2159	1207
18833	2160	1024
18833	2160	855
9724	2161	3094
9724	2161	1066
9724	2161	7749
9724	2161	4404
9724	2161	8664
9724	2161	8276
9724	2161	911
9724	2161	403
9724	2161	2695
3338	2162	3060
3338	2162	7327
3338	2162	5379
3338	2162	8776
3338	2162	4882
3338	2162	2099
19696	2163	7066
10682	2164	7020
10682	2164	6043
10682	2164	5756
10682	2164	1383
10682	2164	5304
10682	2164	8828
10682	2164	8357
10682	2164	8003
10682	2164	4366
12929	2165	6312
12929	2165	5660
12929	2165	7493
12929	2165	8719
12929	2165	2832
17748	2166	8507
17748	2166	7920
13495	2167	954
13495	2167	6766
13495	2167	7326
13495	2167	1785
13495	2167	896
13495	2167	4986
13495	2167	1474
13495	2167	346
13495	2167	3717
18202	2168	241
18202	2168	8216
18985	2169	9126
11782	2170	1658
11782	2170	8728
11782	2170	1061
5068	2171	2726
5068	2171	2633
5068	2171	9009
5068	2171	37
5068	2171	5241
5068	2171	7409
5068	2171	7745
5068	2171	413
5068	2171	8176
18712	2172	2320
18712	2172	6973
18712	2172	674
18712	2172	5914
17279	2173	7295
17279	2173	2853
17279	2173	5031
17279	2173	5584
17279	2173	7701
17279	2173	4754
17279	2173	198
17279	2173	3774
4011	2174	8966
4011	2174	7985
4011	2174	431
4011	2174	6504
4011	2174	2538
19664	2175	7164
19664	2175	5084
19664	2175	6528
19664	2175	6075
19664	2175	898
19664	2175	4210
19664	2175	9231
13216	2176	957
13216	2176	5280
13216	2176	2981
13216	2176	7355
13216	2176	5061
13216	2176	5351
5027	2177	5261
5027	2177	6349
5027	2177	6016
5027	2177	7608
13678	2178	3447
13678	2178	4235
13678	2178	6902
13678	2178	5791
13678	2178	1298
13678	2178	5401
13678	2178	4638
13678	2178	477
17369	2179	3419
17369	2179	9860
17369	2179	278
17369	2179	9661
17369	2179	4306
17369	2179	788
17369	2179	4199
17369	2179	2156
15892	2180	1092
15892	2180	2191
15892	2180	7133
15892	2180	8848
15892	2180	1351
15892	2180	8922
17561	2181	6248
17561	2181	1035
17561	2181	245
17561	2181	8306
17561	2181	6844
17561	2181	5543
17561	2181	8407
17561	2181	7211
18803	2182	2068
6837	2183	8189
6837	2183	8138
6837	2183	7008
6837	2183	6257
6837	2183	4939
6837	2183	9865
6837	2183	944
6837	2183	3705
6837	2183	8087
10594	2184	4698
10594	2184	5957
10594	2184	910
10594	2184	185
10594	2184	5750
10594	2184	8682
11378	2185	3732
11378	2185	3523
11378	2185	6454
11378	2185	305
11378	2185	953
11378	2185	2269
11378	2185	3688
16771	2186	5151
16771	2186	2230
16771	2186	2136
16771	2186	3708
16771	2186	1866
16771	2186	6506
475	2187	3834
475	2187	9482
475	2187	9957
475	2187	2529
475	2187	4397
8555	2188	114
8555	2188	8437
8555	2188	5087
8555	2188	322
8555	2188	1390
8555	2188	3265
8555	2188	2324
11340	2189	5470
11340	2189	6104
17264	2190	4848
17264	2190	8361
17264	2190	569
17264	2190	9200
8571	2191	3079
8571	2191	3325
11296	2192	1318
11296	2192	8960
11296	2192	127
11296	2192	2213
11296	2192	3696
11296	2192	3898
11296	2192	3618
8372	2193	3192
8372	2193	1475
8372	2193	2688
8372	2193	3735
8372	2193	897
8372	2193	1661
8372	2193	9590
17099	2194	3613
17099	2194	2812
17099	2194	1841
10916	2195	9644
10916	2195	1030
10916	2195	1249
10916	2195	5604
18676	2196	1934
18676	2196	9952
18676	2196	4587
18676	2196	73
18676	2196	5822
18676	2196	6327
18676	2196	994
18676	2196	5342
8618	2197	4008
8618	2197	6104
8618	2197	4217
2548	2198	9228
2548	2198	751
2548	2198	4502
2548	2198	2003
2548	2198	9687
2548	2198	8259
2548	2198	6456
2548	2198	4180
2548	2198	6096
13558	2199	8492
5416	2200	3982
5416	2200	3706
5416	2200	2905
5416	2200	2389
5416	2200	9792
18956	2201	5491
19340	2202	7474
19340	2202	2364
19340	2202	6688
19340	2202	5722
19340	2202	3563
19340	2202	6622
654	2203	4782
654	2203	4840
654	2203	7531
654	2203	4051
654	2203	7057
654	2203	8415
654	2203	9211
13369	2204	5231
13369	2204	5348
13369	2204	4200
13369	2204	5557
13369	2204	6454
14412	2205	347
14412	2205	503
14412	2205	9180
14412	2205	7622
14412	2205	4095
14412	2205	2781
9821	2206	9404
9501	2207	3661
9501	2207	7536
9501	2207	1817
9501	2207	7320
9501	2207	4614
9501	2207	1699
9501	2207	5544
6331	2208	9202
6331	2208	7071
6331	2208	4805
6331	2208	4492
14012	2209	3721
14012	2209	183
14012	2209	2732
14012	2209	9940
14012	2209	1338
14012	2209	7717
14012	2209	9670
14012	2209	3915
2055	2210	922
2055	2210	9745
2055	2210	7234
2055	2210	9933
2055	2210	1242
2055	2210	7968
16301	2211	150
16301	2211	4291
16301	2211	711
16301	2211	4524
16877	2212	9466
16877	2212	7317
14122	2213	1297
5076	2214	7500
5076	2214	5863
5076	2214	685
5076	2214	9875
5076	2214	7500
5076	2214	6983
5076	2214	965
1368	2215	3507
1368	2215	314
1368	2215	8316
1368	2215	6734
1368	2215	2471
1368	2215	2151
1368	2215	4191
1368	2215	3851
1368	2215	3368
6485	2216	3828
6485	2216	5589
6485	2216	8742
6485	2216	5477
17966	2217	5486
17966	2217	2718
17966	2217	1864
17966	2217	8699
17966	2217	2594
17966	2217	3664
14062	2218	273
14062	2218	2573
14062	2218	6984
14062	2218	8893
14062	2218	4212
14062	2218	8406
14062	2218	3351
14062	2218	6481
14062	2218	4593
12912	2219	470
12912	2219	2645
12912	2219	3423
12912	2219	1164
12912	2219	4593
12912	2219	4894
12912	2219	5536
12912	2219	5326
12912	2219	7602
12014	2220	8348
12014	2220	984
4081	2221	1796
4081	2221	6767
4081	2221	3998
4081	2221	26
4081	2221	4593
4081	2221	6597
4081	2221	1784
4081	2221	1363
4081	2221	6561
10714	2222	7504
10714	2222	2578
10714	2222	6258
10714	2222	528
10714	2222	7769
10714	2222	5518
19031	2223	4676
19031	2223	1407
19031	2223	8804
19031	2223	3405
19031	2223	299
19031	2223	9129
19031	2223	5323
5652	2224	1314
5652	2224	3875
5652	2224	9328
5652	2224	4164
5652	2224	6180
5652	2224	4361
18072	2225	309
18072	2225	2311
18072	2225	9191
18072	2225	3679
18072	2225	9555
18072	2225	2419
18072	2225	1828
18072	2225	8765
18072	2225	3510
5675	2226	7683
5675	2226	72
5675	2226	1367
5675	2226	1079
5675	2226	6908
5675	2226	614
5675	2226	5101
5675	2226	1829
5675	2226	8124
1084	2227	378
1084	2227	2748
1084	2227	5658
1084	2227	6725
1084	2227	6875
1084	2227	402
1084	2227	6451
1084	2227	4734
1084	2227	3356
7940	2228	3774
7940	2228	2796
7940	2228	4071
7940	2228	2440
5633	2229	6704
5633	2229	661
5633	2229	6940
14683	2230	9109
14683	2230	1815
14683	2230	857
14683	2230	6435
417	2231	2106
417	2231	8119
417	2231	6800
417	2231	7361
417	2231	1234
417	2231	5142
417	2231	7493
10655	2232	9613
10655	2232	3128
10655	2232	997
10655	2232	2157
13807	2233	4446
5128	2234	866
5128	2234	3519
5128	2234	5714
5128	2234	3994
5128	2234	742
327	2235	8695
327	2235	9573
327	2235	4449
327	2235	7121
327	2235	8633
327	2235	252
327	2235	4504
327	2235	5642
13015	2236	8607
13015	2236	6387
13015	2236	9361
13015	2236	6024
13015	2236	7292
13015	2236	6040
13015	2236	3825
16545	2237	8421
16545	2237	7556
16545	2237	9052
9387	2238	1201
9387	2238	9438
11648	2239	2952
11648	2239	4702
11648	2239	1791
11648	2239	6229
11648	2239	6354
11648	2239	3888
11648	2239	4701
4514	2240	4317
4514	2240	3414
4514	2240	194
4514	2240	6460
4514	2240	4421
4514	2240	5455
4514	2240	714
4514	2240	5259
14099	2241	2665
14099	2241	6782
14099	2241	6207
14099	2241	8860
14099	2241	3739
16110	2242	3222
16110	2242	2623
16110	2242	8146
16110	2242	3588
16110	2242	3871
16110	2242	2006
16110	2242	9717
16110	2242	6178
17684	2243	5394
17684	2243	3795
17684	2243	466
10123	2244	3071
10123	2244	931
10123	2244	8492
4159	2245	6381
4159	2245	5737
4159	2245	5336
4159	2245	1972
4159	2245	757
4159	2245	3181
13951	2246	4509
13951	2246	476
13951	2246	6910
13951	2246	8908
13951	2246	9239
3952	2247	8584
3952	2247	4273
3952	2247	1958
3952	2247	6234
3952	2247	476
3952	2247	4286
3952	2247	3140
3952	2247	631
3952	2247	4648
10245	2248	8668
10245	2248	2786
10245	2248	1545
10245	2248	9883
10245	2248	9292
7129	2249	3173
7129	2249	2770
7129	2249	6009
7129	2249	7304
7129	2249	6289
7129	2249	2690
7129	2249	3075
7129	2249	6058
9451	2250	2632
9451	2250	8157
9451	2250	5024
9451	2250	980
9451	2250	1013
9451	2250	747
9451	2250	2784
9451	2250	7833
10272	2251	3071
10272	2251	7795
10272	2251	1355
10272	2251	4456
10272	2251	8578
10272	2251	5483
10272	2251	913
11873	2252	7843
11873	2252	8468
11873	2252	6286
11873	2252	2106
11873	2252	44
15967	2253	8613
15967	2253	8468
15967	2253	1184
19521	2254	970
19521	2254	6116
19521	2254	6684
9052	2255	3116
9052	2255	9114
9052	2255	9708
9052	2255	7899
9052	2255	7141
9052	2255	1285
9052	2255	4767
9052	2255	5721
5428	2256	5191
5428	2256	3258
5428	2256	1372
1533	2257	8630
1533	2257	3404
1533	2257	2805
1533	2257	6901
1533	2257	2072
1533	2257	8139
1533	2257	9794
1533	2257	3109
11570	2258	8296
11570	2258	1243
11570	2258	4723
11570	2258	1495
11570	2258	3381
4019	2259	9753
4019	2259	7561
4019	2259	7052
4019	2259	694
4019	2259	2988
12194	2260	1882
12194	2260	1512
12194	2260	7645
12194	2260	1731
12194	2260	5368
12194	2260	5600
12194	2260	9186
5460	2261	9078
12259	2262	1319
12259	2262	8343
12259	2262	7373
12259	2262	6361
12259	2262	8571
12259	2262	9431
12259	2262	625
12259	2262	8582
8364	2263	828
8364	2263	6301
8364	2263	6006
8364	2263	580
17736	2264	144
17736	2264	2240
17736	2264	3709
4558	2265	8494
4558	2265	7362
4558	2265	3089
4558	2265	1257
4558	2265	5318
4558	2265	3324
18658	2266	2497
18658	2266	3455
18658	2266	1332
18658	2266	2886
18658	2266	1115
15769	2267	4085
15769	2267	5739
15769	2267	4441
15769	2267	3193
15769	2267	6655
15769	2267	7781
15769	2267	129
15769	2267	9307
3605	2268	5322
3605	2268	3429
3605	2268	534
3605	2268	4801
3605	2268	2427
3605	2268	1347
3605	2268	1040
3605	2268	7958
3605	2268	5912
5133	2269	2544
5133	2269	746
5133	2269	6914
5133	2269	3652
5133	2269	6952
5133	2269	9507
5133	2269	7180
5133	2269	4923
5133	2269	2745
8183	2270	1177
8183	2270	2173
8183	2270	2968
8183	2270	9655
8183	2270	2307
8183	2270	2415
8183	2270	4048
15399	2271	6673
15399	2271	7505
15399	2271	1418
15399	2271	5833
15399	2271	9778
15399	2271	8253
15399	2271	8180
704	2272	3701
704	2272	1049
704	2272	8371
704	2272	9060
704	2272	2791
704	2272	117
704	2272	6358
704	2272	6040
14914	2273	1619
14914	2273	7961
14914	2273	9706
14914	2273	9302
14914	2273	6492
14914	2273	3584
9265	2274	8095
1771	2275	5548
1771	2275	9686
1771	2275	4712
2005	2276	7070
13550	2277	1936
13550	2277	5654
13550	2277	7584
13550	2277	151
13550	2277	8007
13550	2277	9041
13550	2277	9132
13550	2277	3682
13550	2277	4380
18184	2278	94
18184	2278	5971
18184	2278	5256
18184	2278	3939
18184	2278	6340
3986	2279	9638
3986	2279	4916
7912	2280	7488
7912	2280	3599
7912	2280	5478
7912	2280	959
7912	2280	5172
7912	2280	9666
7912	2280	8216
7912	2280	7646
7912	2280	1078
9254	2281	5760
9254	2281	965
9254	2281	3260
9254	2281	4631
9254	2281	9674
9254	2281	3801
9254	2281	3985
9254	2281	3136
9254	2281	8449
16229	2282	3036
16229	2282	6366
16229	2282	1079
16229	2282	8740
8999	2283	5174
8999	2283	5532
8999	2283	7622
8999	2283	1922
8999	2283	8478
3227	2284	9920
3227	2284	7263
3227	2284	1056
3227	2284	6462
3227	2284	4411
3227	2284	1815
3227	2284	4597
3227	2284	7650
3227	2284	406
11875	2285	1143
19241	2286	1234
19241	2286	2090
19241	2286	8149
18409	2287	6626
18409	2287	4523
18409	2287	7212
18409	2287	4068
18409	2287	6387
18409	2287	7685
18409	2287	411
3107	2288	1174
3107	2288	5591
3107	2288	6621
9538	2289	3974
9538	2289	1063
9538	2289	744
9538	2289	9039
6212	2290	7580
15980	2291	9543
1433	2292	3123
1433	2292	7003
1433	2292	2379
1433	2292	762
1433	2292	719
1433	2292	6951
1433	2292	7409
1433	2292	9418
1433	2292	9095
13348	2293	4664
13348	2293	4962
13348	2293	9221
13348	2293	4923
16090	2294	4726
16090	2294	9054
16090	2294	6550
16090	2294	7311
16090	2294	1235
1305	2295	2887
1305	2295	5257
1305	2295	3912
1305	2295	9170
1305	2295	4126
1305	2295	7567
1305	2295	8600
1305	2295	7093
3638	2296	7306
3638	2296	9427
3638	2296	6666
3638	2296	9335
3638	2296	1314
3638	2296	4737
3638	2296	6198
3638	2296	9823
3638	2296	9913
8077	2297	3087
8077	2297	2130
8077	2297	2401
8077	2297	1998
8077	2297	2386
8077	2297	2183
17697	2298	5003
17697	2298	9420
17697	2298	7989
15621	2299	6802
15621	2299	3683
15621	2299	1255
15621	2299	164
15621	2299	6948
15621	2299	6116
15621	2299	1581
15621	2299	8249
15621	2299	313
5573	2300	6574
5573	2300	7353
5573	2300	460
5573	2300	2373
5573	2300	6729
5573	2300	894
5573	2300	3356
7039	2301	6083
7039	2301	3073
7039	2301	149
7039	2301	1426
8074	2302	1651
8074	2302	3756
8074	2302	4383
8074	2302	6088
8074	2302	401
8074	2302	5928
8074	2302	3226
8074	2302	3442
8074	2302	2804
17771	2303	6548
17771	2303	8925
17771	2303	1231
17771	2303	2011
17771	2303	1327
17771	2303	4298
17771	2303	2664
17503	2304	1567
17503	2304	991
17503	2304	646
17503	2304	5197
17503	2304	3408
17503	2304	2335
17503	2304	7331
17503	2304	4800
17503	2304	6856
17732	2305	2527
17732	2305	5077
17732	2305	3486
17732	2305	3942
17732	2305	4071
17732	2305	281
17732	2305	300
17732	2305	9494
17732	2305	4376
13419	2306	5592
13419	2306	8810
13419	2306	7761
16537	2307	3074
16537	2307	9030
16537	2307	6925
16537	2307	5478
11517	2308	6685
11517	2308	4275
11517	2308	8449
11517	2308	7770
11517	2308	2053
11517	2308	7109
11517	2308	5807
11517	2308	8342
11632	2309	8368
11632	2309	2770
11632	2309	2958
11632	2309	6287
11632	2309	4006
11632	2309	214
8976	2310	3986
8976	2310	1718
8976	2310	2880
8976	2310	6901
8976	2310	3696
8976	2310	5806
13528	2311	6751
13528	2311	4716
13528	2311	4060
13528	2311	1144
13528	2311	3344
13528	2311	8756
13528	2311	5845
13528	2311	7573
13528	2311	26
5811	2312	1593
5811	2312	8010
5811	2312	8645
3375	2313	7500
3119	2314	9625
3119	2314	3121
17932	2315	8797
17932	2315	5650
17932	2315	1818
17932	2315	7433
17932	2315	5579
17932	2315	808
9940	2316	5882
9940	2316	6208
9940	2316	4969
9188	2317	2975
9188	2317	351
18294	2318	3812
18294	2318	2527
18294	2318	6000
18294	2318	6688
18294	2318	2329
18294	2318	1778
18294	2318	4198
18294	2318	1648
13234	2319	1211
13234	2319	3811
13234	2319	5541
17303	2320	7412
17303	2320	9408
17303	2320	8365
17303	2320	8045
17303	2320	2216
17303	2320	6248
17303	2320	8611
518	2321	6876
518	2321	8237
518	2321	457
518	2321	2271
518	2321	6209
518	2321	4649
4120	2322	1999
4120	2322	9950
4120	2322	53
4120	2322	416
4120	2322	6158
15619	2323	3622
15619	2323	9265
15619	2323	4248
15619	2323	3906
15619	2323	5718
15619	2323	4835
15619	2323	9632
12538	2324	1271
12538	2324	4467
12538	2324	6626
12538	2324	7624
8737	2325	1964
8737	2325	9355
8737	2325	6073
19956	2326	92
19956	2326	7031
19956	2326	4923
19956	2326	5993
19956	2326	3880
19956	2326	3893
1038	2327	3303
1038	2327	577
1038	2327	332
1038	2327	8110
1038	2327	3768
1038	2327	3288
6816	2328	8362
6816	2328	3975
6816	2328	7867
6816	2328	2717
13220	2329	7129
13220	2329	2023
13220	2329	460
13220	2329	4326
13220	2329	5139
13220	2329	477
7530	2330	7173
11068	2331	8818
11068	2331	8966
11068	2331	3026
11068	2331	8144
11068	2331	2009
11068	2331	6439
11068	2331	5702
11068	2331	6629
11068	2331	7689
16331	2332	1930
16331	2332	9851
16331	2332	9297
16331	2332	4636
16331	2332	3875
16331	2332	3989
16331	2332	4987
16331	2332	9034
16331	2332	132
13140	2333	3468
13140	2333	4132
13140	2333	3468
13140	2333	9322
2502	2334	353
2502	2334	396
2502	2334	443
2502	2334	8441
2502	2334	7109
12285	2335	7184
12285	2335	8147
3229	2336	2771
3229	2336	9788
3229	2336	1565
3	2337	7735
3	2337	8682
3	2337	5642
3	2337	2610
8110	2338	5632
8110	2338	2065
8110	2338	8331
8110	2338	5393
8110	2338	4323
8110	2338	9710
8110	2338	254
7191	2339	7290
11943	2340	3093
11943	2340	306
11943	2340	3851
11943	2340	747
11943	2340	5275
11943	2340	3260
11943	2340	3940
16525	2341	2372
16525	2341	6876
16525	2341	664
16525	2341	2480
16525	2341	7161
16525	2341	3925
14035	2342	659
14035	2342	1454
14035	2342	7477
1474	2343	9389
1474	2343	6420
1474	2343	1828
1474	2343	3271
1474	2343	728
1474	2343	6854
1474	2343	1887
1474	2343	7601
19101	2344	1806
19101	2344	502
19101	2344	4893
18220	2345	7267
7372	2346	2477
7372	2346	7078
7372	2346	1512
7372	2346	6412
7372	2346	7946
7372	2346	9210
7372	2346	3563
7372	2346	8816
18635	2347	7296
12023	2348	4116
12023	2348	480
12023	2348	3857
12023	2348	6000
12023	2348	6160
12023	2348	4865
12023	2348	909
237	2349	2156
15360	2350	8097
15360	2350	2757
15360	2350	559
15360	2350	4417
9791	2351	7851
8022	2352	6583
8022	2352	9640
8022	2352	7633
8022	2352	3315
8022	2352	6693
8022	2352	7468
8022	2352	2972
11456	2353	7420
11456	2353	3723
11456	2353	2499
11456	2353	5624
11456	2353	5913
11456	2353	4361
11456	2353	4417
11456	2353	33
11456	2353	4110
14848	2354	6253
14848	2354	3451
14848	2354	485
14848	2354	4953
14848	2354	991
14848	2354	1275
14848	2354	6966
14848	2354	1532
14848	2354	4122
16965	2355	9425
16965	2355	8648
16965	2355	7659
16965	2355	958
16965	2355	968
8837	2356	6360
14702	2357	2065
14702	2357	9234
14702	2357	3313
14702	2357	1040
14702	2357	1838
2525	2358	4797
2525	2358	8191
2525	2358	3767
2525	2358	2965
2525	2358	3577
2525	2358	4314
2525	2358	787
9091	2359	5270
9091	2359	2947
9091	2359	6550
9091	2359	2071
9091	2359	4989
9091	2359	9650
9091	2359	6882
9091	2359	4639
9091	2359	200
6329	2360	2564
6329	2360	7745
6329	2360	5016
6329	2360	7895
6329	2360	4383
6329	2360	2172
6329	2360	1746
6329	2360	1317
12609	2361	2289
12609	2361	1204
12609	2361	5924
12609	2361	5333
12609	2361	4568
12609	2361	7963
12609	2361	4052
18135	2362	8044
18135	2362	1539
18135	2362	2451
18135	2362	8936
18135	2362	7101
18135	2362	72
18135	2362	2802
18135	2362	1920
15687	2363	7998
15687	2363	2155
15687	2363	7107
15687	2363	1667
15687	2363	5274
6635	2364	3533
6635	2364	783
6635	2364	3744
6635	2364	8513
6635	2364	8953
6635	2364	6175
6635	2364	5319
1456	2365	704
1456	2365	2673
1456	2365	8443
1456	2365	5397
1456	2365	6744
1456	2365	7034
1456	2365	8857
19279	2366	7523
19279	2366	1805
19279	2366	2860
19279	2366	7349
19279	2366	3441
19279	2366	8906
19279	2366	2778
19279	2366	5759
8403	2367	7917
8403	2367	4173
8403	2367	801
10092	2368	3036
10092	2368	94
10092	2368	6667
10092	2368	2819
10092	2368	1132
10092	2368	79
10092	2368	9782
10092	2368	9647
14131	2369	9882
14131	2369	4627
14131	2369	2608
14131	2369	7083
14131	2369	473
14131	2369	6672
14131	2369	9942
14131	2369	8347
2331	2370	7425
14412	2371	2746
4974	2372	145
4974	2372	1533
4974	2372	12
4974	2372	876
4974	2372	8367
4974	2372	3992
4974	2372	4313
8062	2373	4880
8062	2373	6241
8062	2373	8133
8062	2373	6299
8062	2373	1664
3246	2374	6208
3246	2374	6263
3246	2374	1522
3246	2374	6703
1389	2375	3033
1389	2375	3028
1389	2375	8652
1389	2375	7463
1389	2375	3674
1389	2375	4692
1389	2375	6474
1389	2375	3868
1389	2375	7978
8372	2376	405
8372	2376	6749
8372	2376	9558
8372	2376	7802
8372	2376	432
8372	2376	867
8372	2376	7370
8372	2376	1367
8372	2376	4411
18206	2377	5459
18206	2377	6739
18206	2377	4122
18206	2377	7622
18206	2377	9698
18206	2377	1940
18206	2377	5135
5873	2378	3771
5873	2378	1771
5873	2378	9636
5873	2378	5972
5873	2378	8178
5873	2378	3149
5873	2378	3299
5873	2378	2071
12384	2379	8462
12384	2379	7692
12384	2379	6268
12384	2379	1898
12384	2379	5762
12384	2379	2460
12384	2379	1265
12384	2379	672
12384	2379	7367
11088	2380	8734
11088	2380	6702
11088	2380	6377
11088	2380	6996
11088	2380	8410
11088	2380	6322
11088	2380	5858
11088	2380	8927
9375	2381	4220
9375	2381	3427
9375	2381	1069
9375	2381	1534
9375	2381	6337
9375	2381	4110
9375	2381	915
9375	2381	5875
9375	2381	9556
15932	2382	4067
5985	2383	7680
5985	2383	8635
5985	2383	1013
5985	2383	6790
5985	2383	2853
5985	2383	8096
5985	2383	2899
5985	2383	4260
5985	2383	3016
5144	2384	538
5144	2384	5006
5144	2384	5515
5144	2384	7596
5144	2384	7144
11556	2385	7838
11556	2385	1392
11556	2385	2288
11556	2385	9880
11556	2385	1692
11556	2385	8999
11556	2385	4272
11556	2385	7280
11556	2385	4995
20000	2386	7706
20000	2386	1575
20000	2386	5293
20000	2386	627
16929	2387	9155
18069	2388	3174
18069	2388	6463
7485	2389	1560
7485	2389	7999
7485	2389	7443
7485	2389	3997
7485	2389	553
7485	2389	8891
7485	2389	1755
7485	2389	9644
17597	2390	7833
17597	2390	469
17597	2390	3711
17597	2390	8451
17597	2390	675
17597	2390	4713
17597	2390	6494
17597	2390	6214
419	2391	9498
419	2391	146
419	2391	9919
419	2391	9439
419	2391	8587
419	2391	7283
419	2391	7151
419	2391	7425
419	2391	4683
10714	2392	7591
10714	2392	5000
10714	2392	9475
4856	2393	4272
4856	2393	4764
4856	2393	2314
4856	2393	2759
81	2394	7791
81	2394	8557
81	2394	619
81	2394	7831
81	2394	8421
81	2394	5202
81	2394	9224
6473	2395	6747
6473	2395	1739
6473	2395	5565
6473	2395	5712
6473	2395	4954
6473	2395	8364
6473	2395	3951
6473	2395	7017
6473	2395	8628
12916	2396	1879
12916	2396	480
12916	2396	7176
12916	2396	4339
12916	2396	6527
12916	2396	5655
12916	2396	2595
16613	2397	4562
16613	2397	9544
16613	2397	4060
16613	2397	1019
16613	2397	4196
16613	2397	9146
16613	2397	6717
14393	2398	4510
14393	2398	5451
2211	2399	2325
3735	2400	9774
3735	2400	1523
3735	2400	4991
18374	2401	682
18374	2401	6689
18374	2401	6111
18374	2401	5848
18374	2401	5277
18374	2401	1656
1911	2402	2573
1911	2402	6596
1911	2402	4426
1911	2402	9891
1911	2402	202
13445	2403	2388
18153	2404	7890
18153	2404	6333
18153	2404	6573
18153	2404	5991
18153	2404	8943
18153	2404	3705
600	2405	6669
600	2405	746
600	2405	7748
600	2405	3593
600	2405	9920
19043	2406	5234
19043	2406	1269
19043	2406	6114
19043	2406	9553
19043	2406	6818
19043	2406	1060
2863	2407	6229
2863	2407	5851
2863	2407	4362
15908	2408	3935
15908	2408	5649
15908	2408	7976
15908	2408	1939
15908	2408	2447
15908	2408	7086
7806	2409	4425
7806	2409	2646
17749	2410	5849
17749	2410	2940
17749	2410	5053
17749	2410	8183
17749	2410	337
17749	2410	7979
17749	2410	4713
17749	2410	7555
17749	2410	7969
16246	2411	9338
16246	2411	160
16246	2411	8215
16246	2411	858
16246	2411	2991
16246	2411	8051
16246	2411	8761
16246	2411	4286
16246	2411	2090
137	2412	9985
137	2412	2647
137	2412	5128
137	2412	6077
137	2412	1460
3238	2413	5269
3238	2413	5804
3238	2413	4960
3238	2413	4190
3238	2413	6956
18091	2414	9114
18091	2414	6925
19143	2415	1377
19143	2415	5315
3904	2416	6804
3904	2416	4192
3904	2416	7982
3904	2416	6461
3904	2416	2871
3904	2416	647
7486	2417	9772
7486	2417	674
15450	2418	853
15450	2418	5681
15450	2418	5200
4006	2419	4610
4006	2419	8674
4006	2419	10
4006	2419	4486
4006	2419	5078
4006	2419	4398
4006	2419	8522
4006	2419	1947
4006	2419	459
16783	2420	1639
16783	2420	7167
16783	2420	2074
16783	2420	8841
16783	2420	2021
16783	2420	9769
16783	2420	4521
18012	2421	5953
18012	2421	7366
18012	2421	9000
18012	2421	3671
18012	2421	2727
18012	2421	7850
18012	2421	8363
11058	2422	8027
11058	2422	4928
11058	2422	8616
6272	2423	2142
6272	2423	293
6272	2423	9736
17471	2424	8194
17471	2424	6830
17471	2424	8682
17471	2424	5531
17471	2424	722
17471	2424	2603
15062	2425	2227
15062	2425	8773
15062	2425	2513
15062	2425	1605
15062	2425	9010
15062	2425	463
14865	2426	7129
14865	2426	4312
14865	2426	9841
14865	2426	5415
14865	2426	1698
14865	2426	9310
14865	2426	5549
14865	2426	4356
6258	2427	4044
6105	2428	4631
6105	2428	851
6105	2428	5760
6105	2428	7097
13874	2429	7499
13874	2429	7222
13874	2429	329
13874	2429	4912
13874	2429	544
13874	2429	7813
13874	2429	2701
13874	2429	1095
13874	2429	4909
19079	2430	1989
19079	2430	7905
19079	2430	1834
19079	2430	6022
19079	2430	897
19079	2430	3357
19079	2430	328
19079	2430	887
19079	2430	8369
12363	2431	8038
5891	2432	2485
5891	2432	5147
5891	2432	3819
5891	2432	3558
5891	2432	4744
11280	2433	3758
9288	2434	6074
9288	2434	8989
9288	2434	6944
6180	2435	8311
6180	2435	8171
6180	2435	6929
6180	2435	6509
6180	2435	7641
6180	2435	66
6331	2436	6592
10515	2437	1712
10515	2437	3888
7900	2438	66
7900	2438	1482
7900	2438	3514
7900	2438	225
7900	2438	8898
7900	2438	1274
7900	2438	2905
7900	2438	2129
7900	2438	8815
8215	2439	5474
8215	2439	4000
6109	2440	2081
6109	2440	6144
6109	2440	1613
6109	2440	1973
6109	2440	9679
6109	2440	9702
5213	2441	1304
5213	2441	681
9315	2442	346
9315	2442	6875
9315	2442	9258
9315	2442	777
9315	2442	3562
9315	2442	4900
9315	2442	6578
12511	2443	7207
12511	2443	9319
12511	2443	9535
12511	2443	4256
12511	2443	857
12511	2443	4873
12511	2443	3808
1364	2444	868
1364	2444	9861
1364	2444	7603
1364	2444	9603
1364	2444	1633
1364	2444	435
1364	2444	3326
1364	2444	6949
12967	2445	6699
12967	2445	4516
12967	2445	7185
12967	2445	6789
12967	2445	9006
12967	2445	4972
12967	2445	7377
12967	2445	4302
7808	2446	517
7808	2446	599
15094	2447	4031
15094	2447	9423
7877	2448	2262
2535	2449	1140
2535	2449	7313
2535	2449	8136
14588	2450	6888
14588	2450	3703
14588	2450	6274
14588	2450	5323
14588	2450	9942
14588	2450	1033
14588	2450	8684
14588	2450	4877
14588	2450	2420
16401	2451	1358
16401	2451	8793
16401	2451	9085
16401	2451	6788
7350	2452	7797
7350	2452	1889
3660	2453	5647
3660	2453	6881
3660	2453	7494
3660	2453	2910
15554	2454	9957
15554	2454	8352
15554	2454	9987
15554	2454	6254
15554	2454	8814
15554	2454	9685
15554	2454	4407
15554	2454	9730
15189	2455	4143
15189	2455	9573
15189	2455	6652
15189	2455	1343
15189	2455	260
15189	2455	3010
15189	2455	6251
15189	2455	9258
15189	2455	6500
10625	2456	1922
10625	2456	5479
10625	2456	9033
10625	2456	9246
6776	2457	5025
6776	2457	9986
6776	2457	7660
6776	2457	768
6776	2457	461
6776	2457	2029
6776	2457	3256
14955	2458	1384
14955	2458	5043
14955	2458	7413
13317	2459	47
13317	2459	1178
13317	2459	3944
13317	2459	1438
4411	2460	9224
4411	2460	1587
13630	2461	9748
13630	2461	2428
13630	2461	8202
13630	2461	8866
13630	2461	6500
13630	2461	7620
17596	2462	9961
17596	2462	8427
17596	2462	5259
17596	2462	3238
17596	2462	4996
17596	2462	6961
17596	2462	1639
2772	2463	6176
2772	2463	6758
2772	2463	404
2772	2463	7486
2772	2463	9803
2772	2463	6821
2772	2463	7191
11234	2464	6314
11234	2464	4214
11234	2464	6212
11234	2464	9132
11234	2464	8092
11234	2464	9237
11234	2464	538
11234	2464	2807
11234	2464	454
15879	2465	8306
10992	2466	1113
10992	2466	5978
10992	2466	4375
10992	2466	8736
10992	2466	1366
10992	2466	8438
15347	2467	3086
15347	2467	9321
19747	2468	229
19747	2468	1109
19747	2468	5280
12784	2469	3818
12784	2469	4418
12784	2469	3893
12784	2469	421
3817	2470	3934
6509	2471	3128
6509	2471	4533
11283	2472	1586
11283	2472	9560
11283	2472	7832
4497	2473	8031
4497	2473	45
4497	2473	8259
4497	2473	4317
4497	2473	3137
4497	2473	5447
4497	2473	5451
19967	2474	5625
19967	2474	8925
19967	2474	893
19967	2474	7728
19967	2474	1861
19967	2474	972
18005	2475	2274
18005	2475	9358
18005	2475	4590
18005	2475	563
18005	2475	2259
18005	2475	8610
18005	2475	5997
18005	2475	5885
18005	2475	7827
17438	2476	7443
17438	2476	8109
17438	2476	2943
17438	2476	7417
17438	2476	6684
17438	2476	9482
8143	2477	4108
8143	2477	2854
8143	2477	922
8143	2477	3257
8143	2477	471
8143	2477	1615
8143	2477	9803
14490	2478	5659
14490	2478	1343
14490	2478	86
14490	2478	2764
18084	2479	5883
18084	2479	3400
18084	2479	463
7440	2480	4804
7440	2480	7359
7440	2480	7648
7440	2480	1851
7440	2480	7188
7440	2480	710
7440	2480	584
7440	2480	6558
1252	2481	3231
1252	2481	1746
1252	2481	7007
1252	2481	950
4153	2482	4817
4929	2483	172
4929	2483	4696
4929	2483	8943
4929	2483	1676
4929	2483	8625
4929	2483	6126
4929	2483	6037
15564	2484	9990
15564	2484	884
15564	2484	9012
15564	2484	6648
15564	2484	3538
15564	2484	6293
12928	2485	7345
12928	2485	9143
12928	2485	1618
12928	2485	1057
14187	2486	4875
14187	2486	4358
14187	2486	21
14187	2486	782
14187	2486	8773
14187	2486	2861
14187	2486	9412
14187	2486	9073
12494	2487	2365
12494	2487	1982
12494	2487	9358
16278	2488	6205
16278	2488	1912
16278	2488	9871
16278	2488	5803
16278	2488	964
16278	2488	8081
16278	2488	6885
16278	2488	2979
17191	2489	1558
17191	2489	110
17191	2489	8551
17191	2489	6578
17191	2489	7606
17191	2489	9103
17191	2489	1716
17191	2489	4372
348	2490	4749
348	2490	7735
348	2490	7812
348	2490	7589
19584	2491	4360
5821	2492	3187
4580	2493	3304
4580	2493	993
4580	2493	7944
4580	2493	160
4580	2493	3550
4580	2493	4325
4580	2493	8607
4580	2493	5248
4580	2493	1705
12129	2494	8975
12129	2494	4167
12129	2494	1742
10280	2495	2910
10280	2495	4005
10280	2495	5486
10280	2495	3546
10280	2495	2059
10280	2495	397
10280	2495	9784
2976	2496	7552
2976	2496	546
2976	2496	5622
2976	2496	8687
2976	2496	6570
2976	2496	2503
2976	2496	893
9794	2497	9062
9794	2497	4607
9794	2497	7682
9794	2497	1786
9794	2497	648
9794	2497	8953
13009	2498	3031
13009	2498	2986
13009	2498	398
13009	2498	4855
13009	2498	7387
13009	2498	8312
13009	2498	644
13009	2498	3044
15301	2499	2654
15301	2499	9535
16974	2500	4992
16044	2501	9739
16044	2501	1518
17809	2502	6377
17809	2502	3880
17809	2502	690
17809	2502	7072
17809	2502	338
17809	2502	4126
17809	2502	3026
17809	2502	8359
17809	2502	7807
13568	2503	8747
13568	2503	719
13568	2503	5704
12090	2504	7030
12090	2504	4967
12090	2504	3161
12090	2504	9234
12090	2504	1763
9577	2505	5061
9577	2505	5078
12897	2506	7559
12897	2506	4063
12897	2506	5050
12897	2506	9307
12673	2507	4056
12673	2507	5782
12673	2507	7614
12673	2507	6649
14219	2508	5377
14219	2508	7385
14219	2508	4236
14219	2508	4225
14219	2508	3344
14219	2508	5057
14219	2508	1518
590	2509	4039
590	2509	9526
590	2509	8045
590	2509	7363
590	2509	8123
1667	2510	8621
1667	2510	7605
1667	2510	4476
1667	2510	4651
1667	2510	116
1667	2510	6212
1667	2510	4070
9538	2511	9524
9538	2511	5786
9538	2511	2742
9538	2511	2260
9538	2511	2843
9538	2511	1698
637	2512	3175
637	2512	673
637	2512	6696
637	2512	7531
637	2512	2422
637	2512	3574
637	2512	6369
637	2512	317
12205	2513	9252
12205	2513	8859
12205	2513	9782
12205	2513	2024
12205	2513	875
12205	2513	9864
12205	2513	5301
12205	2513	1873
18808	2514	1004
18808	2514	8097
18808	2514	8127
18808	2514	3266
13452	2515	2446
13452	2515	5861
13452	2515	788
13452	2515	3248
6222	2516	3648
6222	2516	1606
6222	2516	6987
6222	2516	8719
6222	2516	4987
6222	2516	5364
6222	2516	5229
6222	2516	6492
6222	2516	5355
15602	2517	28
15602	2517	7257
15602	2517	545
15602	2517	6386
15602	2517	1174
15602	2517	3838
15602	2517	5005
15602	2517	9289
15602	2517	8816
8360	2518	2809
8360	2518	5512
8360	2518	1743
8360	2518	5965
8360	2518	8396
8360	2518	8721
18531	2519	5520
18531	2519	5685
18531	2519	1170
18531	2519	183
18531	2519	4414
18531	2519	4734
4241	2520	6000
4241	2520	4151
4241	2520	5254
4241	2520	7581
4241	2520	6106
4241	2520	9301
13034	2521	4908
12154	2522	6536
2537	2523	3389
2537	2523	8788
2537	2523	3713
17933	2524	2616
17933	2524	1011
17933	2524	4530
17933	2524	8433
17933	2524	7663
16211	2525	8731
16211	2525	1471
16211	2525	7220
16211	2525	1156
16211	2525	5717
16211	2525	9997
16211	2525	2881
16211	2525	8396
16211	2525	1838
5697	2526	9425
5697	2526	5173
5697	2526	4698
5697	2526	5192
5697	2526	7095
5697	2526	65
5697	2526	2277
5697	2526	6800
5697	2526	7894
15780	2527	5017
15780	2527	2188
15780	2527	1351
15780	2527	9702
15780	2527	6899
15780	2527	5635
664	2528	4446
664	2528	5328
15207	2529	1035
15207	2529	4481
12850	2530	6765
12850	2530	9449
12850	2530	131
14058	2531	9100
14058	2531	8357
14058	2531	5896
14058	2531	5206
14058	2531	7313
14058	2531	8826
14058	2531	2336
14058	2531	8796
12747	2532	8969
12747	2532	7787
12747	2532	8119
12747	2532	7568
12747	2532	4946
8092	2533	2651
8092	2533	9693
8092	2533	7452
8092	2533	8227
8092	2533	6112
8092	2533	6139
8092	2533	7377
1234	2534	621
17479	2535	9249
17479	2535	2077
17479	2535	39
17479	2535	4673
17479	2535	8640
17479	2535	546
17545	2536	9335
17545	2536	2389
17545	2536	8916
17545	2536	7328
17545	2536	3918
17545	2536	7389
17545	2536	6688
11872	2537	3718
16782	2538	2756
16782	2538	8032
800	2539	8907
800	2539	2520
800	2539	7665
800	2539	2081
800	2539	7797
800	2539	4166
5962	2540	3873
5962	2540	6800
5962	2540	2529
10568	2541	9409
10568	2541	7547
10568	2541	3942
10568	2541	5012
10568	2541	4275
10568	2541	6310
10568	2541	4259
16847	2542	1405
16847	2542	6060
16847	2542	3147
16847	2542	2451
3131	2543	8712
3131	2543	6606
3131	2543	1383
3131	2543	2711
3131	2543	7009
3131	2543	9070
3131	2543	3340
3131	2543	7424
12026	2544	5022
12026	2544	8432
12026	2544	1808
17244	2545	7095
17244	2545	5169
17244	2545	7417
17244	2545	4247
17244	2545	2946
4031	2546	5344
14189	2547	250
14189	2547	1453
14189	2547	1201
10087	2548	9845
10087	2548	3169
1170	2549	712
1170	2549	8178
1170	2549	6525
1170	2549	8274
1170	2549	4749
1170	2549	8963
1170	2549	392
3690	2550	5105
3690	2550	2035
3690	2550	9467
3690	2550	5963
3690	2550	6892
3690	2550	3221
3690	2550	5560
7474	2551	6488
7474	2551	1358
7474	2551	7916
7474	2551	3996
7474	2551	9532
7474	2551	152
7474	2551	6778
7474	2551	4881
7474	2551	2244
16411	2552	6843
16411	2552	6039
16411	2552	4134
16411	2552	6139
16411	2552	8493
16411	2552	5916
16411	2552	3864
15718	2553	7646
15718	2553	7125
15718	2553	7548
15718	2553	3236
15718	2553	6352
15718	2553	7996
15718	2553	1510
15718	2553	3535
15718	2553	7241
6759	2554	6006
6759	2554	4893
6759	2554	3304
6759	2554	7729
6759	2554	4763
3775	2555	3893
3775	2555	5071
3775	2555	6960
3775	2555	3577
3775	2555	7906
10292	2556	8526
10292	2556	7610
10292	2556	7808
2222	2557	6554
2222	2557	7503
14599	2558	332
14599	2558	8350
14599	2558	7704
14599	2558	5761
14599	2558	9037
14599	2558	755
14599	2558	4344
14599	2558	2152
19919	2559	1071
19919	2559	340
19919	2559	4347
19919	2559	1910
19919	2559	5142
19919	2559	6668
19919	2559	6112
19919	2559	2765
17050	2560	302
17050	2560	9796
17050	2560	9458
17050	2560	6598
17050	2560	1907
17050	2560	1481
3640	2561	9662
3640	2561	5979
3640	2561	3985
3640	2561	277
3640	2561	7663
3640	2561	3911
3640	2561	1566
3735	2562	6512
6219	2563	4162
6219	2563	7211
6219	2563	9539
6219	2563	4651
1259	2564	3275
1259	2564	4400
1259	2564	7321
1259	2564	5544
12257	2565	6509
12257	2565	8126
12257	2565	374
12257	2565	3069
12257	2565	2083
3242	2566	822
3242	2566	7049
3242	2566	2713
3242	2566	9105
3242	2566	1261
3242	2566	5422
14130	2567	2221
14130	2567	3328
14130	2567	8277
14130	2567	4709
14130	2567	8237
14130	2567	1625
19428	2568	8123
19428	2568	4058
19428	2568	3795
19428	2568	7947
19428	2568	9586
19428	2568	1860
19428	2568	433
19428	2568	958
19428	2568	4233
5018	2569	3855
5018	2569	4499
5018	2569	6228
5018	2569	5193
5018	2569	2143
5018	2569	6123
5018	2569	4150
4193	2570	5465
4193	2570	3842
4193	2570	1624
4193	2570	8550
4193	2570	9085
4193	2570	8366
4193	2570	9256
4193	2570	3293
4193	2570	7699
5781	2571	6206
5781	2571	5005
5781	2571	8210
5781	2571	2452
5781	2571	3312
5781	2571	14
5781	2571	3813
5781	2571	1953
2074	2572	8108
2074	2572	8078
2074	2572	6919
2074	2572	921
2074	2572	8667
2074	2572	2388
14785	2573	1758
14785	2573	2776
14785	2573	5594
14785	2573	2223
14785	2573	4427
14785	2573	1768
14785	2573	5212
14785	2573	7778
14785	2573	8843
11522	2574	9343
11522	2574	8731
11522	2574	5169
11522	2574	9123
11522	2574	9709
11522	2574	8074
7334	2575	3072
7334	2575	2347
7334	2575	1620
7334	2575	517
7334	2575	878
7334	2575	5254
7334	2575	5120
7334	2575	1236
19933	2576	82
19933	2576	2747
19933	2576	6196
4291	2577	318
4291	2577	7249
4291	2577	2398
4291	2577	224
4291	2577	8267
4291	2577	2272
4291	2577	6697
15865	2578	7899
15865	2578	9937
15865	2578	3361
15865	2578	7770
15865	2578	3504
15865	2578	1702
15865	2578	7594
9685	2579	3711
9685	2579	859
9685	2579	6008
9685	2579	5497
9685	2579	522
9685	2579	636
9685	2579	3487
9685	2579	420
7561	2580	3337
7561	2580	4329
7561	2580	7600
7561	2580	7057
3482	2581	6648
5311	2582	5359
5311	2582	3849
5311	2582	7977
5311	2582	4530
5311	2582	759
5311	2582	2177
5311	2582	5328
5311	2582	6475
8148	2583	7221
8148	2583	9349
8148	2583	8816
8148	2583	263
8148	2583	8652
8148	2583	9216
8148	2583	945
17842	2584	7317
17842	2584	5579
17842	2584	8024
17842	2584	5007
17842	2584	563
4281	2585	482
4281	2585	4106
4281	2585	8511
4281	2585	566
4281	2585	9711
4281	2585	1173
2355	2586	5712
2355	2586	4405
2355	2586	6386
2784	2587	6950
2784	2587	4900
2784	2587	1294
10799	2588	9767
10799	2588	8301
18947	2589	651
18947	2589	1119
18947	2589	6600
18947	2589	7653
18947	2589	7953
18947	2589	4377
18947	2589	2608
18947	2589	381
3349	2590	7074
3349	2590	5208
3349	2590	2812
3349	2590	6318
12899	2591	6157
12899	2591	9995
12899	2591	2351
12899	2591	5741
235	2592	1444
5768	2593	6953
4320	2594	5669
17300	2595	2282
17300	2595	1248
17300	2595	2830
17300	2595	9923
14835	2596	7520
14835	2596	4649
14835	2596	3016
14835	2596	5625
14835	2596	6198
14835	2596	2128
14835	2596	4562
14835	2596	4817
14835	2596	6445
17453	2597	1002
17453	2597	2539
17453	2597	209
17453	2597	8342
17453	2597	5524
17453	2597	9029
17453	2597	990
17453	2597	2059
17453	2597	2011
8276	2598	1934
8276	2598	8136
8276	2598	9155
8276	2598	7104
8276	2598	4768
14611	2599	3745
14611	2599	8707
14611	2599	3232
14611	2599	9441
14611	2599	9779
14611	2599	837
14611	2599	9755
14611	2599	5928
14611	2599	6002
8275	2600	9965
8275	2600	2896
8275	2600	1448
8275	2600	2038
8275	2600	2307
2027	2601	8749
17055	2602	317
17055	2602	7276
17055	2602	1104
17055	2602	4104
17055	2602	7414
17055	2602	1815
9421	2603	7208
9421	2603	5609
9421	2603	9932
9421	2603	528
9421	2603	4536
19674	2604	5974
19674	2604	1211
19674	2604	4363
19674	2604	6526
19674	2604	9196
2021	2605	5721
2021	2605	7624
2021	2605	7577
15016	2606	2491
15016	2606	2245
15016	2606	1060
14067	2607	283
14067	2607	956
14067	2607	996
14067	2607	747
14067	2607	1162
14067	2607	2296
14067	2607	5494
14067	2607	9810
4503	2608	5220
4503	2608	1061
4503	2608	5034
4503	2608	7512
4503	2608	9154
4503	2608	1105
4503	2608	8208
4503	2608	6243
4503	2608	2211
6745	2609	255
6745	2609	1223
8747	2610	4211
8747	2610	1264
8747	2610	5000
8747	2610	7392
8747	2610	8761
8747	2610	8190
8747	2610	5981
8747	2610	1925
8272	2611	7508
8272	2611	5913
8272	2611	2815
8272	2611	7826
8272	2611	1509
11439	2612	991
11439	2612	6188
11439	2612	5187
11439	2612	4928
11439	2612	4813
11439	2612	9773
11439	2612	3132
11439	2612	873
11439	2612	9984
11792	2613	3032
11792	2613	3859
11792	2613	4110
11792	2613	259
2500	2614	9633
2500	2614	3513
2500	2614	3022
2500	2614	5468
2500	2614	5063
2500	2614	8169
2500	2614	943
2500	2614	4316
917	2615	4427
917	2615	1619
917	2615	1327
917	2615	321
917	2615	3127
917	2615	2268
917	2615	4427
14897	2616	243
14897	2616	1385
14897	2616	5103
18838	2617	9877
8607	2618	2840
8607	2618	1185
8607	2618	2732
8607	2618	7941
8607	2618	7070
8607	2618	781
8607	2618	9815
8607	2618	7174
8607	2618	4054
18312	2619	8575
18312	2619	5643
18312	2619	3629
18312	2619	2755
18312	2619	2640
7648	2620	8135
7648	2620	8093
7648	2620	9061
17751	2621	8933
17751	2621	5323
17751	2621	6967
17751	2621	2435
17751	2621	973
17751	2621	3993
17751	2621	1410
8098	2622	7873
8098	2622	9386
8098	2622	7789
8098	2622	1211
8098	2622	6350
8098	2622	5725
9315	2623	2060
9315	2623	9097
9315	2623	426
8835	2624	1164
8835	2624	8029
8835	2624	6898
8835	2624	4599
4774	2625	9236
4774	2625	3922
4774	2625	218
16272	2626	3021
16272	2626	6170
17481	2627	2721
17481	2627	8821
17481	2627	2531
17481	2627	6651
17481	2627	2001
17481	2627	9517
17481	2627	1678
17481	2627	5872
12179	2628	4225
12179	2628	5005
12179	2628	4945
16982	2629	6708
16982	2629	7580
16982	2629	3385
16982	2629	1246
16982	2629	7241
16982	2629	8593
16982	2629	9007
16982	2629	5509
18440	2630	2549
18440	2630	4426
18440	2630	2438
6257	2631	1682
6257	2631	1277
6257	2631	97
6257	2631	9372
6257	2631	4695
6257	2631	4589
6257	2631	3369
6257	2631	3558
18852	2632	2384
18852	2632	4634
18852	2632	8197
18852	2632	6179
18852	2632	200
18852	2632	5565
18852	2632	8608
18852	2632	1142
18852	2632	1502
12392	2633	9483
12392	2633	8231
12392	2633	9370
12392	2633	2466
12392	2633	6145
1557	2634	7850
1557	2634	3230
1557	2634	1876
1557	2634	9930
1557	2634	5635
1557	2634	9188
18468	2635	3869
18468	2635	9203
18468	2635	5855
18468	2635	8803
18468	2635	6037
18468	2635	3170
18468	2635	5725
18468	2635	452
7361	2636	2475
7361	2636	5021
7361	2636	2623
7361	2636	5246
7361	2636	3442
14621	2637	9410
14621	2637	690
13452	2638	871
13452	2638	3565
13452	2638	2458
13452	2638	5003
13452	2638	766
13452	2638	5632
13452	2638	5586
13452	2638	9995
6873	2639	747
6873	2639	7497
6873	2639	8048
6873	2639	8367
6873	2639	4912
11564	2640	7104
11564	2640	2145
11564	2640	6945
11564	2640	9583
11564	2640	8696
11564	2640	832
6587	2641	8672
6587	2641	6208
6587	2641	3029
6587	2641	4353
6587	2641	7871
448	2642	6141
448	2642	6193
448	2642	4256
7677	2643	9006
7677	2643	8580
7677	2643	9839
7677	2643	412
7677	2643	3579
7677	2643	4677
7677	2643	875
7677	2643	8002
7677	2643	8294
6680	2644	5490
6680	2644	3395
6680	2644	3580
6680	2644	3584
6680	2644	4480
6120	2645	3766
6120	2645	4186
6120	2645	4625
6120	2645	3951
6120	2645	7893
6120	2645	4245
6427	2646	8323
6427	2646	7565
6427	2646	4762
6427	2646	6307
6427	2646	437
6427	2646	935
6427	2646	3847
15224	2647	4956
15224	2647	4999
15224	2647	6659
15224	2647	858
15224	2647	9078
15224	2647	4117
4878	2648	4157
4878	2648	9563
4878	2648	6725
4878	2648	1250
4878	2648	6274
4878	2648	6188
4878	2648	2708
4878	2648	4361
18719	2649	2251
2655	2650	9931
2655	2650	7998
2655	2650	432
2655	2650	1930
2655	2650	2618
2655	2650	9992
12530	2651	4489
12530	2651	5224
12530	2651	9335
11809	2652	3332
8982	2653	6504
8982	2653	5265
14388	2654	5849
14388	2654	3282
14388	2654	3185
14388	2654	4663
14388	2654	3916
14388	2654	6522
14388	2654	8991
14388	2654	9155
14388	2654	5189
13947	2655	8689
13947	2655	1009
13947	2655	415
13947	2655	1148
13947	2655	7220
13947	2655	4262
14893	2656	5119
14893	2656	3707
14893	2656	9911
14893	2656	6371
3118	2657	8533
14443	2658	1175
14443	2658	6230
14443	2658	9767
14443	2658	9319
14443	2658	3950
14443	2658	1475
14443	2658	2296
14443	2658	3355
6531	2659	2331
6531	2659	6165
6531	2659	1080
6531	2659	2411
6531	2659	1918
6185	2660	5415
6185	2660	6600
6185	2660	641
4231	2661	8709
4231	2661	1506
4231	2661	3864
4231	2661	1549
4231	2661	234
2627	2662	9810
2627	2662	6907
2627	2662	7419
5666	2663	7566
5666	2663	7029
5666	2663	3118
5666	2663	6277
5666	2663	4871
5666	2663	8770
637	2664	8032
637	2664	9534
637	2664	7489
637	2664	4767
637	2664	6073
637	2664	8146
637	2664	5018
637	2664	2432
18922	2665	3733
18922	2665	4454
18922	2665	7416
10806	2666	3623
10806	2666	7265
10806	2666	2012
13557	2667	8964
13557	2667	4524
13557	2667	5801
13557	2667	6565
13557	2667	6416
13557	2667	7938
13557	2667	9555
13557	2667	8751
12174	2668	8350
12174	2668	726
12174	2668	9153
12174	2668	368
12174	2668	9517
12174	2668	223
12174	2668	6809
12174	2668	2461
12174	2668	1701
16234	2669	8266
16234	2669	8249
16234	2669	5473
16234	2669	3103
16234	2669	3016
16234	2669	3843
5990	2670	4647
5990	2670	6950
5990	2670	4475
5990	2670	9614
5990	2670	6368
5990	2670	5961
5990	2670	9432
15393	2671	4713
15393	2671	2257
15393	2671	6728
15393	2671	9268
15393	2671	9014
15393	2671	3565
15393	2671	3768
15393	2671	1487
11923	2672	2897
11923	2672	4008
11923	2672	5132
10555	2673	3673
10555	2673	6055
10555	2673	3663
10555	2673	1201
10555	2673	3353
10555	2673	9265
10555	2673	5706
14385	2674	3154
14385	2674	899
14385	2674	9068
14385	2674	4907
14385	2674	8345
14385	2674	9477
14385	2674	5844
14385	2674	5328
17980	2675	1921
2370	2676	4217
2370	2676	3389
2370	2676	8284
2370	2676	6191
2370	2676	2592
2370	2676	4089
4867	2677	1913
4867	2677	2082
4867	2677	3912
4867	2677	6230
4867	2677	1436
4867	2677	6626
4867	2677	9335
4867	2677	8124
4867	2677	1653
19873	2678	9119
19873	2678	2966
19873	2678	8145
19873	2678	5640
19873	2678	1357
19873	2678	6326
19873	2678	4793
2045	2679	9172
2045	2679	7960
2045	2679	7029
2045	2679	2058
2045	2679	7595
2045	2679	8618
15472	2680	943
15472	2680	6671
15472	2680	8753
15472	2680	4136
17856	2681	9950
17856	2681	2094
17856	2681	9596
17856	2681	7629
17856	2681	6136
17856	2681	5307
7847	2682	1660
7847	2682	8790
7847	2682	114
7847	2682	9185
7847	2682	3487
9902	2683	1012
9902	2683	3399
9902	2683	1320
9902	2683	3158
9902	2683	9620
9902	2683	8634
9902	2683	3023
9902	2683	8849
9902	2683	6436
10452	2684	687
10452	2684	7053
10452	2684	5616
10452	2684	9124
10452	2684	252
10452	2684	61
10452	2684	3241
10452	2684	6646
12530	2685	1191
12530	2685	855
12530	2685	1114
12530	2685	548
12530	2685	2517
12530	2685	7376
12530	2685	5953
12530	2685	7376
12530	2685	5424
11352	2686	9327
11352	2686	872
11352	2686	6274
11352	2686	2237
11352	2686	161
11352	2686	676
11352	2686	3466
11352	2686	8306
11352	2686	977
16705	2687	2781
16705	2687	5190
16705	2687	7900
16705	2687	3880
6413	2688	9178
6413	2688	6182
6413	2688	2647
6413	2688	4840
6413	2688	7357
11325	2689	6485
11325	2689	4442
11325	2689	3610
11325	2689	1910
11325	2689	5426
11325	2689	3420
15061	2690	2513
15061	2690	9438
15061	2690	3103
15061	2690	5037
15061	2690	5408
15061	2690	6249
15061	2690	8055
15061	2690	6609
2099	2691	8272
2099	2691	963
8765	2692	1913
8765	2692	9867
18610	2693	1390
13595	2694	7317
13595	2694	3064
13595	2694	3144
13595	2694	4975
13595	2694	3781
9488	2695	9126
9488	2695	3030
5794	2696	2202
5794	2696	2971
5794	2696	6740
14578	2697	5893
14578	2697	1630
14578	2697	399
14578	2697	7227
14578	2697	9850
14578	2697	8923
14578	2697	4295
14650	2698	222
14650	2698	4862
15663	2699	9051
15663	2699	7164
15663	2699	4105
15663	2699	3550
15663	2699	2091
15663	2699	2338
15663	2699	8127
15663	2699	1695
15663	2699	8980
11435	2700	7915
11435	2700	8737
11435	2700	5959
11435	2700	608
19317	2701	4427
19317	2701	1966
19317	2701	8210
19317	2701	1923
19317	2701	3374
19317	2701	2734
19317	2701	7099
19317	2701	1059
19317	2701	7431
10691	2702	8122
10691	2702	6991
10691	2702	5838
10691	2702	8387
10691	2702	7647
19224	2703	3669
19224	2703	5440
19224	2703	2761
19224	2703	2111
19224	2703	9886
14633	2704	2662
14633	2704	3559
14633	2704	9317
14633	2704	9511
14633	2704	9286
14633	2704	9362
14633	2704	711
14633	2704	6545
425	2705	7255
425	2705	4550
425	2705	6830
425	2705	2535
425	2705	1753
425	2705	7325
1767	2706	1432
1767	2706	9997
1767	2706	2605
1767	2706	7650
1767	2706	5404
12684	2707	2719
12684	2707	5993
12684	2707	1027
12684	2707	1705
12684	2707	1708
12684	2707	3637
12684	2707	7871
12684	2707	9915
12684	2707	4005
8002	2708	3360
17527	2709	5105
17527	2709	7528
17527	2709	9977
17527	2709	5093
17527	2709	6342
17527	2709	4564
17527	2709	255
17527	2709	7081
13991	2710	8343
13991	2710	5368
17454	2711	7490
17454	2711	1540
17454	2711	2345
4643	2712	3325
4643	2712	2310
4643	2712	6978
4643	2712	6087
4643	2712	689
3760	2713	845
3760	2713	9803
3760	2713	8909
3760	2713	3221
3760	2713	3953
3760	2713	8994
3760	2713	3828
3760	2713	8619
3760	2713	4924
14465	2714	9797
14465	2714	6379
14465	2714	9366
8361	2715	4363
8361	2715	3396
8361	2715	6553
1010	2716	6802
1010	2716	8076
1010	2716	1618
1010	2716	7363
1010	2716	232
1010	2716	9283
1010	2716	3109
1010	2716	513
5754	2717	6086
5754	2717	6550
5754	2717	4288
5754	2717	6097
5754	2717	3608
5754	2717	2622
5754	2717	2677
5754	2717	5830
5754	2717	3697
7856	2718	3956
8936	2719	7345
8936	2719	9212
8936	2719	3636
8936	2719	2911
8936	2719	8864
8936	2719	1882
8936	2719	6481
8936	2719	2881
8936	2719	5202
17795	2720	2826
17795	2720	5244
17795	2720	5779
17795	2720	1249
17795	2720	732
19887	2721	5705
19887	2721	5924
19887	2721	3941
19887	2721	7040
19887	2721	2309
19887	2721	9578
19887	2721	8631
19887	2721	6407
18465	2722	6013
18465	2722	4418
18465	2722	343
9413	2723	2706
9413	2723	2810
9413	2723	5366
9413	2723	6434
9413	2723	7172
9413	2723	2325
9413	2723	6252
9413	2723	9777
15021	2724	488
15021	2724	2907
15021	2724	5165
15021	2724	55
10296	2725	5945
2620	2726	3715
2620	2726	4467
2620	2726	2377
2620	2726	6994
2620	2726	3377
2620	2726	9664
303	2727	5056
303	2727	8947
303	2727	9355
303	2727	259
303	2727	7565
303	2727	9956
16823	2728	4039
16823	2728	7266
8519	2729	2742
8519	2729	6409
19159	2730	7915
19159	2730	8551
19159	2730	7079
19159	2730	5520
10950	2731	3887
10950	2731	3751
10950	2731	1123
17773	2732	28
17773	2732	1142
17773	2732	3549
9556	2733	4954
9556	2733	1199
9556	2733	325
9556	2733	6675
16345	2734	2249
16345	2734	4004
16345	2734	2626
16345	2734	2258
16345	2734	1253
16345	2734	5916
18928	2735	4242
18928	2735	8663
18928	2735	6400
18928	2735	1229
18928	2735	6580
17544	2736	4851
17544	2736	1528
17544	2736	1695
17544	2736	7198
17544	2736	2052
17544	2736	6237
17544	2736	844
17544	2736	7432
17544	2736	9690
16705	2737	8214
16705	2737	769
16705	2737	10000
16705	2737	3565
16831	2738	7270
16831	2738	8425
16831	2738	46
16831	2738	2917
7519	2739	6522
7519	2739	7549
7519	2739	9280
7519	2739	8213
7519	2739	515
7519	2739	2286
11701	2740	4266
11701	2740	8826
11701	2740	7083
11701	2740	6001
11701	2740	7728
12343	2741	2047
12343	2741	5575
12343	2741	3366
12343	2741	8014
12343	2741	2347
9266	2742	484
9266	2742	6922
9266	2742	6621
7406	2743	831
7406	2743	1201
7406	2743	6897
17886	2744	8539
17886	2744	9315
17886	2744	8019
17886	2744	5081
17886	2744	6294
13554	2745	1526
13554	2745	3615
13554	2745	80
13554	2745	92
13554	2745	7337
13554	2745	5150
13554	2745	5170
13554	2745	3176
3429	2746	8267
3429	2746	9473
3429	2746	1283
3429	2746	7471
3429	2746	2544
3429	2746	95
3429	2746	3604
3429	2746	1878
3939	2747	3262
3939	2747	1891
3939	2747	3780
3939	2747	6677
3939	2747	6781
3939	2747	89
3939	2747	4067
10697	2748	7577
10697	2748	3092
10697	2748	1941
10697	2748	1381
10697	2748	378
10697	2748	5788
18098	2749	7481
18098	2749	6315
6189	2750	8142
13072	2751	2401
13072	2751	3619
13072	2751	181
13072	2751	2187
13072	2751	9378
13072	2751	3262
5240	2752	3869
5240	2752	742
5240	2752	5852
2741	2753	956
2741	2753	7955
711	2754	5848
711	2754	7713
14182	2755	2256
14182	2755	6021
14182	2755	382
14182	2755	8165
8032	2756	5386
8032	2756	4768
8032	2756	7790
8032	2756	2230
1254	2757	9206
1254	2757	6959
1254	2757	3280
1254	2757	2746
1254	2757	5691
1254	2757	2006
1254	2757	8655
1254	2757	7196
1254	2757	4186
19143	2758	5912
19143	2758	9565
19143	2758	8944
19143	2758	8768
19143	2758	1566
19143	2758	3610
19143	2758	7319
127	2759	8830
127	2759	7843
10077	2760	4868
10077	2760	8357
10077	2760	5129
10077	2760	2319
10077	2760	2410
10077	2760	7335
10077	2760	8683
10077	2760	9152
12939	2761	6533
12939	2761	5275
12939	2761	6035
12939	2761	2846
18114	2762	7343
18114	2762	2721
18114	2762	2047
8912	2763	5634
8912	2763	3398
8912	2763	7274
8912	2763	1254
8912	2763	4324
19196	2764	2715
19196	2764	4729
19196	2764	5051
19196	2764	3893
13226	2765	1652
13226	2765	8429
13226	2765	6526
13226	2765	2935
418	2766	6663
9444	2767	8816
7089	2768	7694
7089	2768	4475
18677	2769	1367
15785	2770	7816
15785	2770	1502
16329	2771	2886
16329	2771	3957
16329	2771	5672
7844	2772	6065
7844	2772	2561
7844	2772	6881
16494	2773	6139
16494	2773	4877
16494	2773	9193
16494	2773	2514
12280	2774	4432
12280	2774	9130
12280	2774	2090
12280	2774	4025
12280	2774	7315
12280	2774	2700
12280	2774	4909
268	2775	3718
268	2775	8466
268	2775	7920
268	2775	4972
19028	2776	6942
19028	2776	134
19028	2776	1107
19028	2776	446
19028	2776	7381
19028	2776	5220
19028	2776	7636
19028	2776	9660
19028	2776	263
7960	2777	2574
7960	2777	3993
7960	2777	9804
7960	2777	7059
7960	2777	4907
7960	2777	7381
16974	2778	3618
17676	2779	8966
17676	2779	9577
17676	2779	1869
17676	2779	3208
17676	2779	3780
17676	2779	2691
4989	2780	8871
12502	2781	4738
12502	2781	4974
12502	2781	5502
12502	2781	7193
12502	2781	9164
17479	2782	6185
17479	2782	9795
17479	2782	4376
17479	2782	7736
17479	2782	4979
17479	2782	8088
4946	2783	6930
4946	2783	4393
4946	2783	3193
4946	2783	5155
8636	2784	3058
8636	2784	1201
8636	2784	525
8636	2784	9205
8636	2784	3480
16917	2785	2308
4815	2786	7245
874	2787	822
874	2787	1468
874	2787	928
874	2787	9297
874	2787	3767
874	2787	3123
874	2787	4722
14649	2788	8014
14649	2788	6497
14649	2788	9777
14649	2788	1268
14649	2788	4483
14649	2788	7458
14649	2788	414
14649	2788	6769
15391	2789	9824
15391	2789	4764
15391	2789	3144
15391	2789	9549
15391	2789	6810
9646	2790	5999
9646	2790	6080
9646	2790	8775
9646	2790	530
9646	2790	1130
9646	2790	4512
9646	2790	2824
9646	2790	5593
10832	2791	8362
10832	2791	9348
10832	2791	5601
10832	2791	2519
10832	2791	981
10832	2791	4677
10832	2791	6250
10832	2791	4245
10832	2791	1320
4897	2792	346
4897	2792	5924
4897	2792	7771
4897	2792	1354
4897	2792	886
4897	2792	9720
10641	2793	2211
13774	2794	7644
17925	2795	1411
17925	2795	2938
17925	2795	7625
17925	2795	7695
17925	2795	9884
17925	2795	2568
17925	2795	8764
12777	2796	6532
12777	2796	4764
12777	2796	6705
12777	2796	2062
12777	2796	7707
12777	2796	3311
12777	2796	5146
16166	2797	6945
16166	2797	3177
16166	2797	3220
16166	2797	7598
16166	2797	8031
16166	2797	8371
16166	2797	5992
16166	2797	5456
4321	2798	6508
4321	2798	6112
4321	2798	8647
4321	2798	4540
4321	2798	9340
4321	2798	6587
4321	2798	5188
4321	2798	3112
1418	2799	9308
1418	2799	9176
1418	2799	3663
1418	2799	6054
11842	2800	3494
11842	2800	3118
11842	2800	5240
9159	2801	863
9159	2801	7296
9159	2801	2269
9159	2801	4684
9159	2801	6340
9159	2801	1419
9159	2801	9291
10688	2802	1265
10688	2802	237
10688	2802	6675
10688	2802	6900
10688	2802	1010
10688	2802	6494
10688	2802	5377
5344	2803	5474
5344	2803	8470
5344	2803	6
5344	2803	7329
5344	2803	4971
5344	2803	4640
11808	2804	663
11808	2804	8002
11808	2804	1070
11808	2804	5407
11808	2804	8695
4476	2805	8050
4476	2805	2267
4476	2805	742
4476	2805	6409
4476	2805	1567
4476	2805	5546
19915	2806	4606
19915	2806	2806
19915	2806	334
19915	2806	1619
627	2807	2551
627	2807	2612
627	2807	8906
627	2807	7120
627	2807	7149
627	2807	7718
6526	2808	3221
6526	2808	9725
6526	2808	9801
6526	2808	434
6526	2808	6405
6526	2808	5874
4792	2809	2374
4792	2809	5517
4792	2809	1692
4792	2809	927
4792	2809	6163
2139	2810	7145
2139	2810	9505
2139	2810	2953
6773	2811	5439
6773	2811	3648
6773	2811	7709
6773	2811	2720
6773	2811	4666
6773	2811	1361
4574	2812	931
4574	2812	8104
4574	2812	5228
4574	2812	7965
4574	2812	2119
4574	2812	4038
4574	2812	4304
19484	2813	7546
532	2814	8502
532	2814	9842
532	2814	229
532	2814	6408
9024	2815	9761
9024	2815	7751
9024	2815	2879
14365	2816	6925
8941	2817	4736
6476	2818	2611
6476	2818	8871
6476	2818	6465
6476	2818	3530
6580	2819	5168
6580	2819	9221
6580	2819	2484
6580	2819	9280
6580	2819	8541
6580	2819	3879
6580	2819	1471
10921	2820	9292
10921	2820	6611
6151	2821	3537
6151	2821	301
6151	2821	1937
6151	2821	1261
6151	2821	4032
6151	2821	5643
6151	2821	3153
14062	2822	5646
14062	2822	1209
14062	2822	814
14062	2822	1960
14062	2822	8663
14062	2822	501
8073	2823	9996
8073	2823	8221
8073	2823	1085
13455	2824	911
13455	2824	5183
13455	2824	5590
13455	2824	3697
13455	2824	8326
13455	2824	7299
13455	2824	1935
13455	2824	5727
16356	2825	930
16356	2825	7368
16356	2825	7722
16356	2825	1404
16356	2825	5180
16356	2825	874
16356	2825	6811
4800	2826	9198
4800	2826	8485
4800	2826	5495
4800	2826	2457
3809	2827	9344
3809	2827	5792
3809	2827	9479
3809	2827	5164
3809	2827	6235
3809	2827	7851
3809	2827	6432
3809	2827	3164
3809	2827	7061
12517	2828	2755
12517	2828	9587
12517	2828	1972
12517	2828	7115
12517	2828	1766
12517	2828	1698
12517	2828	3169
12517	2828	1071
12517	2828	2060
19820	2829	4571
19820	2829	1816
19820	2829	7624
19820	2829	7890
19820	2829	1668
2509	2830	3695
2509	2830	6973
2509	2830	9427
2509	2830	3019
2509	2830	9847
2509	2830	927
19202	2831	4708
19202	2831	3384
19202	2831	8018
19202	2831	9023
19202	2831	3887
19202	2831	6550
4808	2832	5373
4808	2832	1100
4808	2832	8763
4808	2832	7394
4808	2832	8208
4808	2832	515
4661	2833	8717
4661	2833	9152
4661	2833	9799
7370	2834	1202
7370	2834	1594
7370	2834	6447
7370	2834	4414
7370	2834	1766
7370	2834	1665
7370	2834	1785
7370	2834	7480
7370	2834	9474
9764	2835	3674
9764	2835	81
9764	2835	5356
9764	2835	7157
16717	2836	2680
16717	2836	470
16717	2836	9021
16717	2836	269
4107	2837	4353
4107	2837	4276
4107	2837	4912
4107	2837	2330
4107	2837	9487
4107	2837	2058
4107	2837	5130
4107	2837	9063
8180	2838	5564
9169	2839	5270
9169	2839	9666
9169	2839	3516
9169	2839	5856
9169	2839	3001
9169	2839	97
9169	2839	9352
2818	2840	623
2818	2840	9909
2818	2840	7578
6283	2841	7726
6283	2841	3402
6283	2841	9355
6283	2841	8822
6283	2841	7086
6283	2841	662
1517	2842	342
1517	2842	6205
1517	2842	6026
1517	2842	8256
1517	2842	5022
6934	2843	9257
6934	2843	2562
6934	2843	9697
6934	2843	5726
6934	2843	4787
6934	2843	3194
6934	2843	2898
6934	2843	6207
13097	2844	1317
13097	2844	6464
13097	2844	3430
13097	2844	5406
13097	2844	4952
13097	2844	7664
13097	2844	1082
13097	2844	6866
13097	2844	2142
13856	2845	2377
13856	2845	1126
13856	2845	6613
16168	2846	5580
16168	2846	6019
16168	2846	2144
16168	2846	8824
16168	2846	5806
16168	2846	1302
16334	2847	758
16334	2847	5781
16334	2847	9448
16334	2847	4457
16334	2847	6740
16334	2847	5132
16334	2847	9154
16334	2847	8318
8672	2848	5761
8672	2848	9223
1050	2849	8692
1050	2849	4617
1050	2849	3075
1050	2849	5607
1050	2849	8555
1050	2849	3096
16455	2850	7554
15079	2851	9668
15079	2851	1327
15079	2851	7144
15079	2851	9416
15079	2851	6143
15079	2851	1712
15079	2851	7555
15079	2851	1158
19425	2852	5006
4341	2853	7652
4341	2853	3725
4341	2853	8427
4341	2853	3047
4341	2853	2283
4341	2853	133
12550	2854	7035
12550	2854	2282
12550	2854	521
12550	2854	7905
12550	2854	9995
12550	2854	8105
12550	2854	5081
5464	2855	201
5464	2855	1929
5464	2855	595
5464	2855	3438
5464	2855	5909
5464	2855	7002
5464	2855	6718
5464	2855	3072
7185	2856	7338
10884	2857	8192
10884	2857	855
10884	2857	559
10884	2857	1448
10884	2857	4303
10884	2857	6698
10884	2857	2770
10884	2857	6962
7360	2858	2680
7360	2858	4983
4640	2859	7762
4640	2859	7333
4640	2859	9088
4640	2859	6560
4640	2859	9242
4640	2859	2133
4640	2859	50
4640	2859	1285
4640	2859	1436
19509	2860	1145
19509	2860	2432
19509	2860	5875
19509	2860	8446
19509	2860	7809
19509	2860	2794
3762	2861	1527
3762	2861	6727
3762	2861	6115
3762	2861	2490
3762	2861	9595
3762	2861	5645
3762	2861	3679
3762	2861	8580
2023	2862	9611
2023	2862	3779
2023	2862	5603
2023	2862	2560
2023	2862	8452
2023	2862	6482
2023	2862	8458
2023	2862	3638
12254	2863	52
12254	2863	1763
12254	2863	5187
12254	2863	8554
12254	2863	1354
12254	2863	5412
12254	2863	8898
12254	2863	8382
12254	2863	5762
8426	2864	4192
8426	2864	1953
8426	2864	9859
8426	2864	3957
8426	2864	1516
8426	2864	9446
8426	2864	7739
8426	2864	3620
9946	2865	5936
9946	2865	6595
9946	2865	9191
9946	2865	5260
9946	2865	6569
9946	2865	196
9946	2865	7377
14471	2866	9065
14471	2866	6554
14471	2866	8878
4994	2867	7470
4994	2867	2540
4994	2867	1068
4994	2867	7724
4994	2867	1490
16118	2868	8819
16118	2868	4055
16279	2869	3739
16279	2869	7258
16279	2869	798
16279	2869	5113
16279	2869	5533
16279	2869	7758
16279	2869	5988
16279	2869	7207
17393	2870	6755
11148	2871	2982
11148	2871	4896
11148	2871	2643
11148	2871	9443
11148	2871	1251
11148	2871	299
11148	2871	1621
18756	2872	8203
18756	2872	8644
18756	2872	9806
18756	2872	8081
18756	2872	7102
2628	2873	5210
2628	2873	8052
2628	2873	1068
2628	2873	7753
2628	2873	7734
18708	2874	8732
18708	2874	2560
18708	2874	8895
18708	2874	4221
18708	2874	6540
18708	2874	5260
18708	2874	3083
1241	2875	3054
8243	2876	6440
8243	2876	3819
8243	2876	5141
8243	2876	2748
8243	2876	5486
8243	2876	806
10052	2877	7327
10052	2877	6689
10052	2877	5732
16482	2878	8801
16482	2878	8204
16482	2878	5589
16482	2878	2641
15562	2879	1653
15562	2879	7818
15562	2879	6973
102	2880	8390
102	2880	5219
102	2880	5708
102	2880	2363
102	2880	331
17068	2881	3177
17068	2881	2332
17068	2881	8439
183	2882	2550
183	2882	7596
183	2882	9055
14889	2883	1566
7857	2884	5092
7857	2884	5173
7857	2884	2517
7857	2884	3768
7857	2884	1290
7857	2884	4288
12639	2885	5324
12639	2885	4880
12639	2885	2576
12639	2885	1823
12639	2885	9784
12186	2886	2732
12186	2886	8207
12186	2886	5518
12186	2886	6254
12186	2886	5572
12186	2886	1491
12186	2886	4284
12186	2886	6179
3003	2887	5880
3003	2887	3236
3003	2887	6084
3003	2887	1091
16814	2888	816
16814	2888	9749
12005	2889	3546
12005	2889	5416
12005	2889	895
12005	2889	2122
12005	2889	3095
12005	2889	3042
12554	2890	9296
12554	2890	7013
12554	2890	6173
12554	2890	252
12554	2890	7327
14621	2891	2867
14621	2891	6044
14621	2891	7378
14621	2891	9875
14621	2891	6466
14621	2891	3516
14621	2891	1945
14621	2891	5784
14621	2891	6577
7179	2892	1655
7179	2892	9547
7179	2892	3740
19485	2893	9291
19485	2893	7439
19485	2893	4786
19485	2893	6168
19485	2893	283
19485	2893	759
19485	2893	1688
19485	2893	847
19485	2893	1622
10218	2894	8848
10218	2894	2490
10218	2894	2205
10218	2894	2330
3241	2895	8289
3241	2895	2689
3241	2895	7892
3241	2895	4139
3241	2895	5199
12091	2896	3278
12091	2896	1922
12091	2896	9454
12091	2896	2408
12091	2896	3358
12091	2896	724
12091	2896	8621
953	2897	7118
953	2897	51
953	2897	9696
953	2897	3659
953	2897	17
953	2897	940
8435	2898	7287
8435	2898	8356
8435	2898	1450
8435	2898	4307
8435	2898	7399
8435	2898	834
8435	2898	3404
1042	2899	5530
18377	2900	8039
18377	2900	8666
18377	2900	1341
18377	2900	1288
18377	2900	8225
19350	2901	1848
19350	2901	5556
19350	2901	3461
7523	2902	4114
7523	2902	434
7523	2902	4199
7523	2902	3213
7523	2902	3741
7523	2902	5940
7523	2902	597
7523	2902	3708
7523	2902	6871
16453	2903	6981
883	2904	4203
16631	2905	6971
367	2906	2062
5318	2907	1481
5318	2907	1326
5318	2907	8361
5318	2907	321
5318	2907	6193
5318	2907	5783
5318	2907	3920
5318	2907	4015
5318	2907	8301
10542	2908	5454
15032	2909	175
15032	2909	5955
15032	2909	5064
15032	2909	1631
15032	2909	3261
15032	2909	8766
9096	2910	4533
9096	2910	2854
9096	2910	6508
9096	2910	8104
9096	2910	7202
9096	2910	7673
9096	2910	1073
9096	2910	4928
9096	2910	4268
18662	2911	2755
18662	2911	6484
18662	2911	877
18662	2911	6068
18662	2911	995
7696	2912	491
15384	2913	5962
1779	2914	1772
1779	2914	3686
1779	2914	4845
1779	2914	1356
4463	2915	7926
4463	2915	4627
4463	2915	7950
4463	2915	3487
13127	2916	7313
13127	2916	852
13127	2916	2983
13127	2916	1755
13127	2916	8576
6839	2917	4747
6839	2917	8273
6839	2917	3866
6839	2917	1955
6839	2917	8651
6839	2917	6551
12289	2918	831
12289	2918	6569
12289	2918	3412
12289	2918	9945
12289	2918	4305
17982	2919	5033
17982	2919	2323
17982	2919	4540
12990	2920	6399
12990	2920	291
12990	2920	7375
12990	2920	9218
12990	2920	5002
12990	2920	9888
12990	2920	5337
12990	2920	3579
8366	2921	6668
17980	2922	5178
17980	2922	8013
8823	2923	9154
8823	2923	3906
8823	2923	6669
8823	2923	4157
8823	2923	7320
1796	2924	5081
1796	2924	5035
1796	2924	1430
1796	2924	738
1796	2924	3531
3087	2925	5955
3087	2925	4415
3087	2925	5324
3087	2925	3478
3087	2925	7228
3087	2925	8549
3087	2925	7128
3087	2925	5445
3087	2925	9681
9429	2926	6728
9429	2926	3856
9429	2926	8926
9429	2926	1801
9429	2926	8226
5281	2927	961
5281	2927	8876
5281	2927	3975
5281	2927	2735
5281	2927	2363
5281	2927	7363
5281	2927	8704
1953	2928	3986
1953	2928	3742
1953	2928	9430
1953	2928	7610
18338	2929	6052
18338	2929	2500
18338	2929	9444
18338	2929	2352
18338	2929	7575
18338	2929	356
18119	2930	36
18119	2930	6996
18119	2930	3875
18119	2930	6933
9084	2931	3711
9084	2931	5736
9084	2931	2512
9084	2931	4690
9084	2931	4709
9084	2931	4133
9084	2931	1754
9084	2931	7220
9084	2931	3548
7167	2932	7605
7167	2932	9754
7167	2932	3897
7167	2932	9080
7167	2932	5610
7167	2932	6113
7167	2932	2552
7167	2932	9580
7167	2932	580
9423	2933	9200
9423	2933	4544
9423	2933	7337
9423	2933	6331
9423	2933	5581
9423	2933	4648
17090	2934	3402
17090	2934	341
17090	2934	8322
17090	2934	8139
17090	2934	134
17090	2934	2189
17090	2934	3429
5257	2935	5376
5257	2935	1557
5257	2935	3943
5257	2935	5641
5257	2935	2472
7677	2936	815
18271	2937	7037
18271	2937	6906
18271	2937	9447
18271	2937	7985
18271	2937	2963
18271	2937	4889
18271	2937	423
18271	2937	44
11370	2938	9798
11370	2938	9892
11370	2938	625
11370	2938	3467
11370	2938	9842
11370	2938	8864
11539	2939	6104
11539	2939	2738
11539	2939	4623
10090	2940	9409
10090	2940	3133
10090	2940	3707
10090	2940	2452
10090	2940	4392
10090	2940	4305
10090	2940	3752
5230	2941	8385
5230	2941	2460
5230	2941	1214
5230	2941	3555
5230	2941	2823
5230	2941	881
5230	2941	8407
5230	2941	4548
5230	2941	2653
10209	2942	8181
10209	2942	6719
10209	2942	303
10209	2942	4548
10209	2942	2558
10209	2942	8453
10209	2942	7420
10209	2942	214
6073	2943	9931
6073	2943	6673
6073	2943	1878
6073	2943	2732
6073	2943	4431
6073	2943	5208
3852	2944	4866
14845	2945	2439
5304	2946	5688
5304	2946	2375
5304	2946	2685
5304	2946	96
5304	2946	8374
5304	2946	910
12234	2947	8043
12234	2947	9198
12234	2947	9048
12234	2947	331
12234	2947	2393
12234	2947	510
12234	2947	5421
12234	2947	8874
2496	2948	296
2496	2948	518
2496	2948	9649
2496	2948	1472
2496	2948	7544
2496	2948	5214
8823	2949	5980
8823	2949	6960
8823	2949	1594
8823	2949	1254
8823	2949	8394
8823	2949	8123
9697	2950	1671
9697	2950	338
3619	2951	8696
3619	2951	2694
3619	2951	8004
3619	2951	1429
3619	2951	12
3619	2951	2356
3619	2951	5859
8505	2952	5917
8505	2952	1590
8505	2952	6779
8505	2952	1674
8505	2952	4579
8505	2952	8926
8505	2952	8345
2077	2953	2227
2077	2953	8538
2077	2953	2977
2077	2953	3844
2077	2953	4502
16474	2954	3346
16474	2954	2540
16474	2954	4052
16474	2954	7241
16474	2954	5450
16474	2954	1588
16474	2954	3787
16474	2954	4833
16474	2954	2692
2457	2955	2122
2457	2955	3343
2457	2955	5602
2457	2955	4860
2457	2955	5433
15946	2956	2186
15946	2956	8277
15946	2956	1736
15946	2956	1430
15946	2956	8002
15946	2956	2467
15946	2956	3321
15946	2956	1921
15946	2956	8508
3700	2957	8280
3700	2957	6164
3520	2958	1407
3520	2958	7629
18729	2959	4887
18729	2959	9198
18729	2959	8242
324	2960	4204
324	2960	1709
324	2960	2253
324	2960	392
324	2960	3700
324	2960	176
324	2960	6179
324	2960	9255
324	2960	1267
1629	2961	8364
1629	2961	5411
1629	2961	5411
1629	2961	6767
1629	2961	6621
1629	2961	1441
1629	2961	5839
1629	2961	8317
4034	2962	7402
4034	2962	3868
4034	2962	337
7016	2963	1566
13952	2964	3738
13952	2964	9961
13952	2964	8654
13952	2964	8688
13952	2964	5095
13952	2964	722
13952	2964	9022
13952	2964	9489
13952	2964	7602
15877	2965	1447
6024	2966	9988
6024	2966	5022
6024	2966	7352
6024	2966	4084
6024	2966	6384
6024	2966	497
2436	2967	2291
2436	2967	5221
2436	2967	1527
2436	2967	7831
2436	2967	8793
2436	2967	4457
2436	2967	2289
2436	2967	6006
2055	2968	6010
4787	2969	3871
4787	2969	7947
4787	2969	1433
4787	2969	722
4787	2969	129
4787	2969	4953
4787	2969	2265
13444	2970	9931
13444	2970	1802
13444	2970	1176
13444	2970	3035
13444	2970	7890
13444	2970	9578
13444	2970	5996
13444	2970	3381
13444	2970	6001
13445	2971	8971
13445	2971	2268
13445	2971	164
13445	2971	7957
15775	2972	695
7459	2973	2997
7459	2973	7271
7459	2973	5841
7459	2973	2935
7459	2973	5465
7459	2973	8564
15067	2974	8769
15067	2974	3193
15067	2974	7818
15067	2974	4613
10615	2975	9037
10615	2975	8212
10965	2976	6134
10965	2976	786
10965	2976	1075
10965	2976	8530
10965	2976	6883
10965	2976	6186
10965	2976	5392
10965	2976	2377
10965	2976	1600
9304	2977	6340
9304	2977	4094
9304	2977	3367
9304	2977	33
12333	2978	7766
12333	2978	6278
12333	2978	1924
12333	2978	8174
12333	2978	8811
12333	2978	7487
12333	2978	6774
4509	2979	5635
19458	2980	6928
19458	2980	9565
19458	2980	826
19458	2980	10000
19458	2980	7346
18539	2981	7379
18539	2981	6625
18539	2981	9435
15223	2982	8085
15223	2982	7767
15223	2982	1016
15223	2982	5063
15223	2982	7053
15223	2982	1013
15223	2982	2545
19780	2983	9160
19780	2983	4416
2080	2984	4438
2080	2984	2021
2080	2984	3044
2080	2984	1378
4786	2985	336
4786	2985	9684
4786	2985	8135
4786	2985	2361
4786	2985	2118
2554	2986	7815
18435	2987	4572
18435	2987	5945
18435	2987	7884
18435	2987	8425
18435	2987	9715
18435	2987	2934
5235	2988	4846
13927	2989	8241
12110	2990	5273
12110	2990	8231
12110	2990	4672
5109	2991	432
5109	2991	7512
5109	2991	1260
5109	2991	5984
5109	2991	9415
5109	2991	6416
19645	2992	9606
19645	2992	2087
19645	2992	7960
19645	2992	7632
19645	2992	7204
19645	2992	366
3724	2993	3073
3724	2993	8655
3724	2993	7454
3724	2993	6990
3724	2993	5467
6518	2994	9291
6518	2994	1112
6518	2994	3573
6518	2994	8737
6518	2994	5262
11254	2995	7489
11254	2995	3652
11254	2995	9207
11254	2995	4894
11254	2995	6945
11254	2995	3529
11254	2995	5289
11254	2995	5670
9921	2996	6338
10150	2997	1015
10150	2997	1036
10150	2997	7995
10150	2997	2765
10150	2997	9086
7960	2998	5864
2305	2999	9669
2305	2999	3939
2305	2999	7633
2305	2999	5940
2305	2999	5351
2305	2999	3188
2305	2999	1696
2305	2999	7983
2305	2999	2748
3666	3000	5813
3666	3000	6185
3666	3000	3509
3666	3000	2828
3666	3000	8471
12411	3001	9972
12411	3001	3979
11537	3002	8151
11537	3002	8161
11537	3002	5191
11537	3002	4900
11537	3002	1942
11537	3002	7829
11537	3002	9029
11537	3002	5604
7620	3003	15
7620	3003	5458
7620	3003	1266
7620	3003	8393
4492	3004	5820
4492	3004	7032
4492	3004	6455
4492	3004	8548
12752	3005	2414
12752	3005	371
12752	3005	5613
12752	3005	1073
13061	3006	5968
13061	3006	7457
13061	3006	6252
13061	3006	4528
3118	3007	3490
3118	3007	5237
3118	3007	8005
3118	3007	1654
3118	3007	3239
3118	3007	7263
3118	3007	9739
4076	3008	5603
6118	3009	2900
6574	3010	128
6574	3010	7129
6574	3010	9639
6574	3010	6800
6574	3010	5550
5625	3011	1148
5625	3011	5092
5625	3011	3459
15110	3012	7904
15110	3012	5382
15110	3012	9940
15110	3012	5823
15110	3012	5054
15110	3012	5432
15110	3012	8083
15110	3012	5983
18597	3013	2353
18597	3013	4525
15965	3014	5538
6882	3015	3764
6882	3015	8154
6882	3015	8553
6882	3015	2536
6882	3015	7899
7763	3016	3180
7763	3016	9642
7763	3016	8288
7763	3016	2977
7763	3016	2148
7763	3016	2343
7763	3016	3007
7763	3016	1126
9778	3017	4474
9778	3017	7685
9778	3017	2572
9778	3017	7628
9778	3017	9464
5287	3018	8176
5287	3018	1077
5287	3018	2752
5287	3018	2267
5287	3018	910
5287	3018	6737
5287	3018	6825
13720	3019	5449
13720	3019	8407
12069	3020	7912
969	3021	1344
8192	3022	9191
8192	3022	9778
8192	3022	8231
8192	3022	8988
8192	3022	3462
17819	3023	6929
17819	3023	994
17819	3023	2821
17819	3023	7811
17819	3023	9389
1465	3024	4829
1465	3024	3563
1465	3024	2343
1465	3024	9946
1465	3024	9941
1465	3024	5728
1465	3024	5458
1465	3024	2312
1465	3024	7239
16463	3025	7137
16463	3025	8310
16463	3025	9583
886	3026	6590
886	3026	6104
12097	3027	4981
877	3028	7644
877	3028	5984
877	3028	2983
877	3028	9978
877	3028	9745
877	3028	6644
877	3028	3417
15208	3029	5353
15208	3029	5292
15208	3029	8138
15208	3029	7472
15208	3029	30
15208	3029	3557
2400	3030	8601
2400	3030	3588
2400	3030	5394
2400	3030	6866
2400	3030	2659
4857	3031	8788
4857	3031	4012
4298	3032	5268
4298	3032	9054
4298	3032	6446
4298	3032	24
4298	3032	2328
4298	3032	4014
4298	3032	7202
8133	3033	4348
8133	3033	4334
6242	3034	7200
6242	3034	5463
6242	3034	2301
2708	3035	9053
2708	3035	163
8352	3036	3583
8352	3036	9468
8352	3036	8447
8352	3036	2405
8352	3036	6049
3041	3037	6671
3041	3037	9174
3041	3037	1212
1529	3038	342
1529	3038	758
1529	3038	9915
1529	3038	3943
1529	3038	4594
1529	3038	8522
1529	3038	7227
1529	3038	5819
1529	3038	2632
15303	3039	8134
15303	3039	438
1526	3040	141
1526	3040	9457
1526	3040	8992
1526	3040	8951
7089	3041	6584
7089	3041	2314
9891	3042	2597
9891	3042	3109
7093	3043	4309
8899	3044	5348
8899	3044	3618
8899	3044	2558
8899	3044	7843
8852	3045	6829
1899	3046	9889
1899	3046	8458
1899	3046	7618
1899	3046	3890
1899	3046	8715
1899	3046	6376
1899	3046	2927
13088	3047	3029
13088	3047	431
5808	3048	2225
5808	3048	6067
5808	3048	3948
5808	3048	7259
5808	3048	8773
5324	3049	1342
5324	3049	8999
5324	3049	4900
5324	3049	812
5324	3049	9498
5324	3049	4784
5324	3049	4741
5324	3049	2832
5324	3049	8190
8512	3050	211
8512	3050	8402
8512	3050	377
8512	3050	1645
8512	3050	8991
8512	3050	356
10511	3051	6177
10511	3051	1904
10511	3051	5385
10511	3051	4033
10511	3051	2473
10511	3051	3272
10511	3051	6478
10511	3051	516
17834	3052	8256
17834	3052	4571
17834	3052	300
17834	3052	5235
17834	3052	182
17834	3052	5618
17834	3052	6650
4068	3053	250
4068	3053	3572
98	3054	6737
98	3054	591
17692	3055	6092
17692	3055	8942
17692	3055	7575
17692	3055	2519
18337	3056	1202
18337	3056	4147
18337	3056	1516
5348	3057	4348
9876	3058	3784
9876	3058	5522
8927	3059	3586
8927	3059	7421
8927	3059	2887
8927	3059	1864
12020	3060	3728
12020	3060	7201
12020	3060	522
12020	3060	5999
12020	3060	6486
539	3061	144
539	3061	4074
539	3061	425
539	3061	5063
539	3061	6726
539	3061	5980
539	3061	2038
539	3061	4599
539	3061	3518
1437	3062	2267
1437	3062	1194
1437	3062	8729
1437	3062	9021
1437	3062	4893
1437	3062	4467
1437	3062	508
1437	3062	6626
6704	3063	1941
6704	3063	7707
6704	3063	3135
6704	3063	4866
6704	3063	1942
6704	3063	9836
6704	3063	507
6704	3063	2960
3961	3064	1145
3961	3064	172
13595	3065	149
13595	3065	8316
13595	3065	6299
13595	3065	8629
13595	3065	7246
13595	3065	657
13595	3065	8181
13595	3065	3395
13595	3065	1521
15665	3066	9037
15665	3066	7400
15665	3066	1132
15665	3066	6005
15665	3066	3863
4357	3067	8201
4357	3067	4826
4357	3067	365
4357	3067	4633
4357	3067	5974
14988	3068	5326
14988	3068	584
14988	3068	2194
14988	3068	3571
14988	3068	2247
12218	3069	8288
12975	3070	1933
13130	3071	4591
13130	3071	9942
13130	3071	2139
5443	3072	705
5443	3072	7204
5443	3072	2775
5443	3072	9060
14694	3073	3835
14694	3073	6816
14694	3073	4520
14694	3073	2332
14694	3073	5738
14694	3073	1253
6782	3074	6113
6782	3074	1458
6782	3074	3776
6782	3074	9768
6782	3074	7543
6782	3074	5054
6782	3074	6174
15	3075	5774
15	3075	3126
15	3075	9630
15	3075	5028
15	3075	4543
15	3075	4274
15	3075	8500
15	3075	6066
15	3075	7203
13939	3076	5796
13939	3076	3359
13939	3076	8971
13939	3076	1977
13939	3076	6216
13939	3076	5172
9604	3077	5685
19917	3078	344
15092	3079	4516
15092	3079	5040
15092	3079	1978
15092	3079	2281
15092	3079	4779
15092	3079	761
15092	3079	2008
15092	3079	335
17078	3080	1287
17078	3080	6377
17078	3080	854
17078	3080	3824
17078	3080	4267
17078	3080	9994
10067	3081	3432
16420	3082	9204
16420	3082	8119
17704	3083	5271
17704	3083	4796
17704	3083	8885
17704	3083	8367
5266	3084	1415
5266	3084	1791
5266	3084	9651
5266	3084	1880
5266	3084	3432
5266	3084	3262
5266	3084	5146
1292	3085	4892
19376	3086	5337
19376	3086	1205
19376	3086	8149
19376	3086	8858
19376	3086	1053
19376	3086	70
19376	3086	5870
19376	3086	1779
10082	3087	6421
10082	3087	5251
10082	3087	4357
10082	3087	2155
10082	3087	9830
10333	3088	7267
10333	3088	5549
10333	3088	2531
10333	3088	6773
5285	3089	1944
5285	3089	4124
5285	3089	8613
5285	3089	7988
5285	3089	7196
5285	3089	4004
5285	3089	6313
5285	3089	8654
5285	3089	9000
12533	3090	2391
12533	3090	4596
12533	3090	1571
12533	3090	1806
12533	3090	982
12533	3090	129
12533	3090	7629
12533	3090	5649
5688	3091	2195
5688	3091	440
5688	3091	3050
5688	3091	4321
5688	3091	5706
5688	3091	3491
16171	3092	9985
16171	3092	7423
15102	3093	6292
17788	3094	5500
17788	3094	8295
17788	3094	7605
17788	3094	5379
2168	3095	9181
12881	3096	5506
12881	3096	9367
12881	3096	8694
12881	3096	8766
12881	3096	7157
12881	3096	3878
12881	3096	8848
12881	3096	8476
12162	3097	8006
1383	3098	3109
13655	3099	7970
13655	3099	1228
13655	3099	7276
8863	3100	6151
8863	3100	4903
8863	3100	807
8863	3100	707
8863	3100	917
5393	3101	3657
2114	3102	3964
2114	3102	8655
2114	3102	3972
2114	3102	5184
2114	3102	362
2114	3102	1144
2114	3102	3668
8950	3103	3768
8950	3103	558
19922	3104	2473
19922	3104	4592
19922	3104	9822
19922	3104	9120
6183	3105	8710
6183	3105	8932
6183	3105	1279
6183	3105	5899
6183	3105	7075
6183	3105	4262
6183	3105	9347
6183	3105	9228
6183	3105	4779
14503	3106	9063
14503	3106	5906
14503	3106	9190
14503	3106	1274
14503	3106	8581
14503	3106	8364
14503	3106	9835
11467	3107	7898
11467	3107	8029
11467	3107	1138
11467	3107	6470
11467	3107	5143
11467	3107	3168
11467	3107	6580
4970	3108	2136
4970	3108	9534
4970	3108	1668
4970	3108	8230
4970	3108	7539
4970	3108	7236
10267	3109	2378
10267	3109	812
10267	3109	2969
10267	3109	8076
9310	3110	7140
9310	3110	4674
9310	3110	463
9310	3110	9992
9310	3110	2104
9310	3110	3633
9310	3110	6562
9310	3110	9239
10309	3111	2207
10309	3111	7226
10309	3111	2412
10309	3111	1311
10309	3111	9956
10309	3111	3136
10309	3111	8454
10309	3111	6370
12722	3112	4582
12722	3112	3762
12722	3112	5545
12722	3112	3233
17756	3113	5335
15492	3114	2146
15492	3114	6525
15492	3114	9503
15492	3114	3089
15492	3114	3893
15492	3114	2233
15492	3114	9225
5973	3115	5987
5973	3115	6707
5973	3115	67
5973	3115	4504
5973	3115	3782
12468	3116	8642
12468	3116	573
12468	3116	8390
12468	3116	4016
12468	3116	8766
15981	3117	977
15981	3117	1996
15981	3117	2208
15981	3117	1106
15981	3117	5333
15981	3117	7675
15981	3117	5649
5072	3118	5948
5072	3118	2133
5072	3118	347
5072	3118	6619
7677	3119	674
7677	3119	6477
7677	3119	5043
7677	3119	1372
7677	3119	957
17262	3120	9452
17262	3120	9940
17262	3120	5156
17262	3120	2250
17262	3120	224
17262	3120	3437
17262	3120	1709
17622	3121	6890
17622	3121	4024
10789	3122	2099
10789	3122	6038
10789	3122	7238
10789	3122	9084
10789	3122	1054
10789	3122	3064
10789	3122	1529
9930	3123	798
9930	3123	6419
9930	3123	2163
9930	3123	9855
9930	3123	5240
9930	3123	1581
9930	3123	3711
19495	3124	5237
12580	3125	9594
10986	3126	3101
10986	3126	4853
10986	3126	4299
10986	3126	2828
16135	3127	1385
16135	3127	8460
16135	3127	3915
16135	3127	4926
16135	3127	735
11310	3128	2103
11310	3128	526
11310	3128	1080
11310	3128	5727
11310	3128	3147
11948	3129	4041
11948	3129	928
11948	3129	8801
11948	3129	9962
11948	3129	9442
11948	3129	1866
14610	3130	2338
5727	3131	6490
5727	3131	4545
5727	3131	7202
5727	3131	5610
5727	3131	3638
5727	3131	6014
5727	3131	5076
5727	3131	3951
6784	3132	3569
6784	3132	6700
6784	3132	7801
6784	3132	7333
6784	3132	1900
6784	3132	3948
6784	3132	5960
6784	3132	8025
6784	3132	5982
19238	3133	4184
16268	3134	1526
16268	3134	2292
16268	3134	624
16849	3135	3759
16849	3135	608
13134	3136	9729
13134	3136	9974
13134	3136	1798
13134	3136	4823
13134	3136	1616
13134	3136	4115
11280	3137	733
11280	3137	4372
11280	3137	7381
11280	3137	7051
11280	3137	2327
1285	3138	6983
1285	3138	7222
1285	3138	8222
1285	3138	214
1285	3138	5001
18229	3139	4755
18229	3139	1705
18229	3139	4131
18229	3139	713
18229	3139	8475
18229	3139	2651
2993	3140	6539
2993	3140	3597
2993	3140	5383
2993	3140	2780
2993	3140	4862
2993	3140	7426
2993	3140	6894
2993	3140	4420
2993	3140	9442
7144	3141	5084
7144	3141	5610
7144	3141	1476
7144	3141	9231
7144	3141	674
7144	3141	1346
7144	3141	9529
7144	3141	6088
1898	3142	9045
1898	3142	4016
1898	3142	8629
1898	3142	9589
1898	3142	7029
1898	3142	3611
1898	3142	2464
1898	3142	9846
1898	3142	249
1844	3143	5192
1844	3143	4932
1844	3143	6682
1844	3143	2228
1844	3143	7004
1844	3143	3750
1844	3143	4738
1844	3143	4476
3009	3144	3616
3009	3144	971
2438	3145	2141
2438	3145	7581
2438	3145	1755
2438	3145	8612
2438	3145	9766
2438	3145	5205
2438	3145	2113
2438	3145	7788
2438	3145	1332
18944	3146	1223
18944	3146	5870
18944	3146	845
18944	3146	3412
18944	3146	7764
18944	3146	763
18944	3146	2885
2992	3147	2335
2992	3147	4390
2992	3147	5111
2992	3147	1297
2992	3147	4441
2992	3147	5914
2992	3147	9765
11267	3148	4021
11267	3148	9817
11267	3148	8293
11267	3148	7128
11267	3148	3095
11267	3148	2672
10014	3149	9454
10014	3149	9169
10014	3149	1756
10014	3149	3224
10014	3149	1817
10014	3149	4805
10014	3149	8621
5283	3150	4426
5283	3150	4238
5283	3150	6343
5283	3150	6535
18274	3151	6129
18274	3151	6899
17308	3152	6323
17308	3152	437
17308	3152	8129
17308	3152	5261
17308	3152	1699
17308	3152	5631
17308	3152	7301
7287	3153	2658
7287	3153	3348
7287	3153	165
7287	3153	155
8760	3154	1829
8760	3154	4399
8760	3154	3167
8760	3154	1323
6042	3155	9145
13642	3156	1032
13642	3156	5780
13642	3156	843
13642	3156	3856
13642	3156	3008
13642	3156	5377
13642	3156	2305
13407	3157	9231
13407	3157	2356
13407	3157	3814
13407	3157	3858
7711	3158	1054
7711	3158	6449
7711	3158	5191
18092	3159	7674
18092	3159	4509
18092	3159	869
18092	3159	6682
18092	3159	9200
18092	3159	1132
9890	3160	7903
9890	3160	7353
9890	3160	7537
9890	3160	8493
7366	3161	2729
7366	3161	3801
7366	3161	3227
7366	3161	380
7366	3161	3580
7366	3161	4435
7366	3161	2973
7366	3161	4335
17613	3162	4058
17613	3162	6095
17613	3162	1868
17613	3162	5578
17613	3162	8270
17613	3162	5124
17613	3162	6416
17613	3162	1400
3558	3163	8840
3625	3164	4425
3625	3164	6733
3625	3164	2660
3625	3164	3997
3625	3164	2384
3625	3164	3342
3625	3164	2972
3625	3164	4815
2460	3165	871
2460	3165	5786
2460	3165	5064
2460	3165	2778
13029	3166	761
6842	3167	2176
6842	3167	1258
6842	3167	4448
6842	3167	7127
6842	3167	2323
18682	3168	3592
18682	3168	5970
17495	3169	5262
12045	3170	9443
12045	3170	8245
12045	3170	7792
4479	3171	1501
4479	3171	3995
4479	3171	5395
4479	3171	3355
18648	3172	8071
18648	3172	2009
6927	3173	6315
6927	3173	7350
6927	3173	415
6927	3173	4062
6927	3173	7381
6927	3173	1810
11609	3174	3541
11609	3174	8226
11609	3174	3552
11609	3174	2222
11609	3174	817
11609	3174	4955
11609	3174	7694
11609	3174	5702
11609	3174	3106
7042	3175	1070
7042	3175	421
7042	3175	4455
10656	3176	9556
10656	3176	3028
10656	3176	7598
16829	3177	8072
16829	3177	3992
16829	3177	1181
16829	3177	6825
16829	3177	619
16829	3177	2377
16829	3177	591
16829	3177	4566
16829	3177	7063
1137	3178	2300
1137	3178	3035
1137	3178	3748
1137	3178	8311
1137	3178	7447
1137	3178	401
1137	3178	156
1137	3178	8537
1137	3178	1329
7411	3179	6502
7411	3179	7635
7411	3179	8657
8257	3180	2628
8257	3180	6329
8257	3180	8735
8257	3180	9603
8257	3180	1022
8257	3180	7621
12314	3181	5312
12314	3181	6619
12314	3181	2746
761	3182	8388
12647	3183	7295
12647	3183	3350
12647	3183	8215
12647	3183	2210
12647	3183	2955
12647	3183	413
12647	3183	5987
2596	3184	7452
2596	3184	7190
2596	3184	1852
2596	3184	9234
7162	3185	556
7162	3185	5515
7459	3186	2965
7459	3186	1925
15821	3187	9208
15821	3187	5873
6125	3188	6937
6125	3188	4236
6125	3188	8488
6125	3188	3565
18159	3189	2809
18159	3189	6636
18159	3189	9618
18159	3189	9151
18159	3189	6470
11355	3190	2337
11355	3190	4707
3287	3191	3270
3287	3191	2948
15206	3192	2144
15206	3192	3204
15206	3192	4496
15206	3192	7339
7616	3193	9486
7616	3193	4206
7616	3193	432
16688	3194	493
16688	3194	4156
16688	3194	660
13148	3195	5297
13148	3195	1966
13148	3195	4026
1631	3196	3377
1631	3196	4696
1631	3196	4419
1631	3196	6495
1631	3196	3471
1631	3196	7001
1631	3196	876
1631	3196	7404
16892	3197	1633
16892	3197	4967
16892	3197	3197
16892	3197	2901
12025	3198	8609
12025	3198	767
12025	3198	4637
16215	3199	2071
16215	3199	5434
16215	3199	6723
16215	3199	7920
19104	3200	3150
19104	3200	8914
19104	3200	8068
19104	3200	2063
19104	3200	1905
19104	3200	2393
19104	3200	3698
19104	3200	9932
19104	3200	5137
14414	3201	6681
9200	3202	4152
9200	3202	6755
9200	3202	656
9200	3202	3352
9200	3202	4389
9200	3202	1606
9200	3202	6085
19563	3203	756
19563	3203	3139
19563	3203	3371
19563	3203	6692
19563	3203	8721
19563	3203	4651
19563	3203	5402
19563	3203	8927
19563	3203	6104
18910	3204	4869
18910	3204	8504
14935	3205	6363
14935	3205	1100
14935	3205	7497
14935	3205	2069
14935	3205	4522
18346	3206	7976
18346	3206	314
18346	3206	9003
18346	3206	3534
18346	3206	348
18346	3206	7217
18346	3206	9355
18346	3206	6319
5361	3207	2181
5361	3207	1632
5361	3207	3262
5361	3207	5040
5361	3207	5327
5361	3207	4176
5361	3207	4955
7913	3208	1264
16961	3209	9606
16961	3209	8759
16961	3209	822
16961	3209	2828
16961	3209	9410
16961	3209	7252
16961	3209	614
16961	3209	8689
5728	3210	7352
5728	3210	6735
5728	3210	7538
13707	3211	5524
13707	3211	2912
13707	3211	1751
13707	3211	4618
13707	3211	6735
7973	3212	6278
7973	3212	5592
7973	3212	8251
7973	3212	6881
7973	3212	1458
7973	3212	5579
7973	3212	1614
7973	3212	5848
7973	3212	3298
12418	3213	9942
12418	3213	505
12418	3213	4296
12418	3213	663
12418	3213	9195
12418	3213	6381
9261	3214	233
9261	3214	1537
9261	3214	73
9261	3214	4338
9261	3214	1242
9261	3214	7292
9261	3214	3844
9261	3214	1343
3696	3215	1391
3696	3215	8502
3696	3215	8065
3696	3215	5372
3696	3215	9513
3696	3215	7029
3696	3215	6071
12286	3216	2064
12286	3216	7529
12286	3216	8374
12286	3216	2298
12286	3216	5158
12286	3216	1565
12286	3216	3018
12286	3216	6745
12286	3216	3540
17823	3217	3904
17823	3217	5659
17823	3217	9509
17823	3217	6117
17823	3217	1108
17823	3217	4181
5108	3218	2271
5108	3218	5341
5108	3218	786
5108	3218	6789
5108	3218	9878
5108	3218	2339
5108	3218	9240
5108	3218	2192
5108	3218	7198
13413	3219	7930
13413	3219	7414
13413	3219	8809
13413	3219	4664
13413	3219	4780
13413	3219	3984
13413	3219	768
13413	3219	8479
13413	3219	2300
9278	3220	893
9278	3220	267
9278	3220	4677
9278	3220	4798
9278	3220	2618
9278	3220	3914
9278	3220	4837
19001	3221	6434
19001	3221	9879
19001	3221	294
19001	3221	4758
19001	3221	6714
19001	3221	7232
19001	3221	9766
19001	3221	8175
19001	3221	6216
2026	3222	3740
2026	3222	6065
2026	3222	3228
2026	3222	8077
2026	3222	802
2026	3222	292
1170	3223	3178
1170	3223	9110
1170	3223	7099
1170	3223	8534
1170	3223	8907
1170	3223	8124
9432	3224	5222
9432	3224	8078
9432	3224	5463
9432	3224	3217
9432	3224	664
9432	3224	6946
9432	3224	4093
9432	3224	8844
9432	3224	1735
17667	3225	4107
17667	3225	962
17667	3225	8056
17667	3225	6947
17667	3225	6224
17667	3225	830
12586	3226	2558
12586	3226	7341
12586	3226	3494
12586	3226	5487
14442	3227	6055
14442	3227	2595
14442	3227	2850
14442	3227	2392
14442	3227	280
14442	3227	7316
16291	3228	4439
16291	3228	5954
6589	3229	4728
6589	3229	8209
6589	3229	9207
6589	3229	9813
6589	3229	5614
6589	3229	5422
15627	3230	7151
15627	3230	2746
15627	3230	4830
15627	3230	777
15627	3230	4809
15627	3230	6265
5526	3231	4749
5526	3231	8182
5526	3231	9763
5526	3231	9216
5526	3231	401
12728	3232	2607
12728	3232	9894
12728	3232	8258
18070	3233	5766
18070	3233	897
18070	3233	3019
18070	3233	542
17448	3234	6718
17448	3234	360
17448	3234	5576
17448	3234	3483
17448	3234	7409
14604	3235	2025
14604	3235	4921
14604	3235	4053
14604	3235	6272
14604	3235	6476
14604	3235	8903
8245	3236	9105
8245	3236	9717
8245	3236	9578
8245	3236	3664
8245	3236	3319
8245	3236	9150
8245	3236	8374
8245	3236	6834
3508	3237	2440
3508	3237	9933
3508	3237	1977
3508	3237	5934
3508	3237	2957
4124	3238	1527
4124	3238	2821
4124	3238	6773
4124	3238	6262
4124	3238	7087
4124	3238	6512
4124	3238	5034
2897	3239	4135
2897	3239	7028
2897	3239	1193
2897	3239	5144
2897	3239	4636
2897	3239	6212
2897	3239	485
2897	3239	2482
18509	3240	5176
18509	3240	3824
18509	3240	451
18509	3240	9130
18509	3240	305
18509	3240	4236
18509	3240	3914
18509	3240	550
18509	3240	4225
17720	3241	7630
17720	3241	3205
17720	3241	2440
17720	3241	9366
17720	3241	5320
18287	3242	8000
18287	3242	4989
18287	3242	6913
18287	3242	2744
18287	3242	488
18287	3242	5932
18287	3242	8987
18287	3242	3572
2403	3243	1313
2403	3243	9991
2403	3243	1094
2403	3243	5219
2893	3244	6804
2893	3244	758
2893	3244	2585
6144	3245	7784
2711	3246	2557
2711	3246	175
2711	3246	9398
2711	3246	4547
2711	3246	5475
2711	3246	9999
16743	3247	1732
16743	3247	1731
16743	3247	6640
16743	3247	7389
16743	3247	6746
16743	3247	9215
16743	3247	6528
16743	3247	8722
17793	3248	9061
17793	3248	2709
5414	3249	1078
5414	3249	6489
5414	3249	9984
5414	3249	7126
5414	3249	4490
5414	3249	58
5414	3249	9686
5414	3249	3642
4726	3250	1259
4726	3250	6942
4726	3250	5748
4726	3250	4856
4726	3250	2357
6869	3251	6244
6869	3251	6192
6869	3251	2772
6869	3251	7884
6869	3251	1917
6869	3251	2101
6869	3251	3782
6869	3251	7920
18358	3252	9499
18358	3252	5321
18358	3252	6086
18358	3252	3674
18358	3252	1112
18358	3252	5544
3470	3253	2417
3470	3253	1586
3470	3253	6177
3470	3253	9890
3470	3253	7691
3470	3253	9037
3470	3253	6989
3470	3253	2091
14823	3254	5089
14823	3254	3096
14823	3254	4352
14823	3254	3556
14823	3254	375
5581	3255	7123
14026	3256	4823
14026	3256	8475
1131	3257	7977
1131	3257	9386
1131	3257	3653
1131	3257	9265
5640	3258	7100
5640	3258	4285
2816	3259	8421
2816	3259	4535
2816	3259	6129
1101	3260	4412
1101	3260	2490
1101	3260	4615
1101	3260	6279
14798	3261	8894
14798	3261	9923
14798	3261	3785
5668	3262	905
5668	3262	6249
5668	3262	8059
3266	3263	3183
3266	3263	5793
4142	3264	9470
4142	3264	9920
4142	3264	2175
4142	3264	1542
4142	3264	7880
4142	3264	8793
4142	3264	9133
10763	3265	6684
10763	3265	3137
12640	3266	4117
12640	3266	4172
7282	3267	2004
7282	3267	8960
7282	3267	2303
7282	3267	9672
7282	3267	5235
7282	3267	792
7282	3267	4186
7282	3267	185
7282	3267	1836
16289	3268	246
8833	3269	8058
8833	3269	764
19448	3270	6563
19448	3270	3464
19448	3270	2082
12535	3271	7136
18681	3272	25
18681	3272	7384
18681	3272	6419
18681	3272	4121
9770	3273	4609
2342	3274	2969
2342	3274	810
2342	3274	9770
2342	3274	4109
2342	3274	6199
2342	3274	6245
12538	3275	8743
12538	3275	6038
12538	3275	853
12538	3275	7748
12538	3275	7418
12538	3275	3532
12538	3275	3527
12538	3275	7063
12538	3275	8455
16447	3276	5129
16447	3276	2143
16447	3276	4612
16447	3276	7642
12769	3277	9248
12769	3277	5694
12769	3277	7187
12769	3277	9352
12769	3277	3620
12769	3277	5671
12769	3277	9374
12769	3277	8555
12769	3277	2349
14953	3278	8850
14953	3278	9368
14953	3278	4849
14953	3278	2875
14953	3278	1328
14042	3279	132
14042	3279	5497
14042	3279	1348
14042	3279	4433
14042	3279	5293
15282	3280	5117
15282	3280	8908
15282	3280	7947
15282	3280	457
6663	3281	5454
6663	3281	8952
18167	3282	2834
18167	3282	7624
18167	3282	5110
18167	3282	254
18167	3282	557
18167	3282	8546
14906	3283	5728
14906	3283	660
14906	3283	3427
14906	3283	8262
14906	3283	5430
14906	3283	3452
14906	3283	6297
14906	3283	2845
937	3284	3384
937	3284	1134
937	3284	8903
937	3284	9613
937	3284	7132
937	3284	6686
14691	3285	6594
14691	3285	1654
14691	3285	4665
1923	3286	93
1923	3286	1726
10220	3287	9050
10220	3287	9278
10220	3287	864
10220	3287	7915
10220	3287	9269
10220	3287	4894
10220	3287	35
10220	3287	5910
10220	3287	3512
3848	3288	3182
3848	3288	867
3848	3288	8117
3848	3288	17
3848	3288	8931
3848	3288	3299
3848	3288	7729
3848	3288	4618
7773	3289	2345
7773	3289	8094
7773	3289	4628
7773	3289	8828
7773	3289	3529
7773	3289	9812
1356	3290	10
17880	3291	7149
17880	3291	8825
17880	3291	4071
17880	3291	5653
17880	3291	7142
10469	3292	6839
10469	3292	5962
10469	3292	5442
10469	3292	7076
10469	3292	6450
12919	3293	5400
12919	3293	3564
12919	3293	9453
12919	3293	4314
12919	3293	2925
12919	3293	497
12919	3293	7963
12919	3293	5300
12919	3293	4950
1822	3294	6683
1822	3294	2165
1822	3294	8273
1822	3294	9592
1822	3294	8606
4339	3295	4558
4339	3295	2597
4339	3295	1817
4339	3295	7548
4339	3295	3503
4339	3295	3993
4339	3295	4986
4339	3295	9363
4339	3295	8018
366	3296	9886
366	3296	3940
366	3296	3761
366	3296	661
366	3296	2636
10464	3297	8325
10464	3297	4747
10464	3297	3095
10464	3297	280
10464	3297	2024
83	3298	224
83	3298	7983
83	3298	3636
14794	3299	8696
14794	3299	4479
14794	3299	3351
14794	3299	6813
14794	3299	7427
14794	3299	3503
14794	3299	298
14794	3299	8602
14794	3299	3424
18222	3300	3977
18222	3300	2696
18222	3300	6716
4400	3301	319
4400	3301	5551
4400	3301	2215
4400	3301	5345
17694	3302	2628
17694	3302	6541
17694	3302	2935
17694	3302	5162
18277	3303	6751
18277	3303	5479
18277	3303	3456
18277	3303	5465
2031	3304	3379
2031	3304	2926
2031	3304	1635
8525	3305	314
8525	3305	6965
8525	3305	4532
8525	3305	4613
8525	3305	2635
8525	3305	327
8525	3305	3123
8525	3305	4150
10441	3306	8506
10441	3306	7788
10441	3306	284
10441	3306	4519
10441	3306	3684
7994	3307	9472
7994	3307	5282
7994	3307	4756
7994	3307	5448
7994	3307	6031
7994	3307	8865
7994	3307	7159
13523	3308	9743
13523	3308	5336
13523	3308	8630
13523	3308	1831
3392	3309	8526
3392	3309	3062
3392	3309	9868
3392	3309	1725
3392	3309	2900
3392	3309	3886
3392	3309	7934
6668	3310	7239
6668	3310	8815
6668	3310	7575
6668	3310	2429
6668	3310	9758
6668	3310	1101
6668	3310	6028
6668	3310	1852
6668	3310	3434
10317	3311	2913
10317	3311	1569
10317	3311	1963
10317	3311	4181
10317	3311	9360
10317	3311	7317
10317	3311	3993
10317	3311	5618
10317	3311	4295
10791	3312	5022
16911	3313	3614
16911	3313	6899
16911	3313	2965
16911	3313	7373
16911	3313	8221
16911	3313	4696
16911	3313	2972
13930	3314	3386
13930	3314	6746
16380	3315	1486
16380	3315	69
7364	3316	209
7364	3316	2209
7364	3316	6438
7364	3316	9135
4212	3317	9071
4212	3317	5131
4212	3317	1245
4212	3317	915
948	3318	222
948	3318	8051
13190	3319	8105
13190	3319	990
13190	3319	3443
13190	3319	5675
17639	3320	8867
17639	3320	3757
9343	3321	5146
9343	3321	3838
9343	3321	6916
233	3322	3526
233	3322	6252
233	3322	1129
13606	3323	5623
13606	3323	8168
13606	3323	6696
13606	3323	4600
13606	3323	6596
13606	3323	1200
13606	3323	9944
13719	3324	6976
13719	3324	2776
13719	3324	1994
13719	3324	5016
13719	3324	8721
13719	3324	9926
13719	3324	6522
13719	3324	6218
13719	3324	36
9271	3325	7182
9271	3325	4949
9271	3325	8064
9977	3326	395
4778	3327	5512
4778	3327	6129
4778	3327	1980
4778	3327	984
4778	3327	7341
4778	3327	1111
5877	3328	5966
5877	3328	9961
5877	3328	4166
11520	3329	130
11520	3329	1801
11520	3329	2840
11520	3329	5643
11520	3329	2749
11520	3329	1619
11520	3329	5820
11520	3329	4752
11520	3329	2913
148	3330	2185
148	3330	9864
148	3330	7147
148	3330	2110
148	3330	8294
148	3330	8415
2508	3331	222
2508	3331	9030
9699	3332	1780
9699	3332	9044
9699	3332	3785
9699	3332	7484
9699	3332	5488
9699	3332	2319
9699	3332	6228
9699	3332	4685
6199	3333	4353
6199	3333	3839
6199	3333	2176
12124	3334	4700
12124	3334	924
12124	3334	1146
12124	3334	6028
12124	3334	678
12124	3334	5976
12124	3334	4149
17668	3335	1933
17668	3335	6522
17668	3335	3361
17668	3335	861
14550	3336	4488
10824	3337	121
10824	3337	215
12379	3338	8393
12379	3338	564
4993	3339	8783
4993	3339	2188
10829	3340	6358
10829	3340	3247
10829	3340	6818
10829	3340	8384
10829	3340	9353
10829	3340	7736
10829	3340	4788
6360	3341	8297
6360	3341	1724
6360	3341	9879
6360	3341	4570
6360	3341	148
6360	3341	7481
6360	3341	6872
6360	3341	8470
6360	3341	636
18040	3342	7618
18040	3342	9690
18040	3342	1489
8467	3343	2285
8467	3343	8634
8467	3343	9809
8467	3343	4230
3419	3344	5548
3419	3344	114
3419	3344	779
3419	3344	5203
3419	3344	6273
3419	3344	2964
3419	3344	5224
3419	3344	4315
3419	3344	8685
1939	3345	3133
1939	3345	6525
1939	3345	964
15971	3346	3477
15971	3346	802
15971	3346	3276
15971	3346	7259
15971	3346	8824
8096	3347	4856
8096	3347	1721
8096	3347	4327
8096	3347	2867
8096	3347	3926
8096	3347	4821
8096	3347	9041
8096	3347	2874
8096	3347	8511
18624	3348	5317
18624	3348	1269
13559	3349	6605
13559	3349	6118
13559	3349	2589
10909	3350	4846
10909	3350	57
10909	3350	6616
10909	3350	2573
10909	3350	9282
19776	3351	7753
19776	3351	3894
19776	3351	785
19776	3351	8599
19776	3351	5126
19776	3351	5714
19776	3351	5160
19776	3351	3168
19776	3351	2126
4364	3352	5113
4364	3352	7527
4364	3352	5489
16452	3353	2232
16452	3353	7873
12943	3354	1187
12943	3354	532
12943	3354	3076
10401	3355	7383
10401	3355	7595
10401	3355	8085
10401	3355	6889
10401	3355	7086
17608	3356	4416
17608	3356	7047
17608	3356	7548
17608	3356	4928
10919	3357	9159
10919	3357	1846
10919	3357	9682
10919	3357	4485
10919	3357	1723
10919	3357	2398
18966	3358	8287
18966	3358	1973
18966	3358	4062
18966	3358	4811
18966	3358	6470
18966	3358	345
18966	3358	5197
18966	3358	6685
17060	3359	7758
17060	3359	6872
17060	3359	2281
17060	3359	8091
17060	3359	8752
17060	3359	6366
17060	3359	858
17060	3359	9740
17060	3359	7358
7656	3360	3867
7656	3360	2298
7656	3360	3839
7656	3360	9081
7656	3360	1807
7656	3360	8776
7656	3360	6318
8818	3361	2281
8818	3361	3735
8818	3361	4184
8818	3361	8057
8818	3361	8024
8818	3361	5369
8818	3361	1458
7510	3362	5966
7510	3362	4697
7510	3362	5707
7510	3362	6450
7510	3362	4528
7510	3362	6433
17428	3363	1852
17428	3363	8302
17428	3363	5577
17428	3363	4494
17428	3363	8635
856	3364	6060
856	3364	8837
856	3364	3444
856	3364	4228
856	3364	6568
856	3364	4288
856	3364	2763
856	3364	1714
856	3364	208
17019	3365	4835
17019	3365	3173
17019	3365	3918
7247	3366	9295
7247	3366	712
7247	3366	6703
7247	3366	2631
7247	3366	3694
7247	3366	6270
7247	3366	2299
7247	3366	9070
7247	3366	1549
10045	3367	2989
10045	3367	9319
10045	3367	4471
10045	3367	530
10045	3367	3172
10045	3367	9953
13311	3368	9925
13311	3368	2110
13311	3368	8970
13311	3368	4178
13311	3368	6915
15860	3369	3780
15860	3369	2820
14582	3370	5085
14582	3370	997
7118	3371	8751
7118	3371	4703
7345	3372	1712
7345	3372	7716
16928	3373	2201
16928	3373	6991
16928	3373	7283
16928	3373	4017
10028	3374	8573
10028	3374	8346
10028	3374	713
10028	3374	8183
10028	3374	6721
10028	3374	514
16458	3375	6693
16458	3375	9635
16458	3375	1064
16458	3375	1737
16458	3375	9929
16458	3375	712
16230	3376	7210
16230	3376	6663
16230	3376	270
16230	3376	6447
16230	3376	8295
16230	3376	5422
16230	3376	5189
16230	3376	9669
16230	3376	395
2917	3377	9805
2917	3377	8265
2917	3377	8576
14902	3378	4672
14902	3378	3763
14902	3378	9879
14902	3378	1931
14902	3378	7170
14902	3378	2099
3535	3379	1072
3535	3379	8528
3535	3379	7526
3535	3379	2858
3535	3379	8848
3535	3379	4823
3535	3379	8884
7111	3380	8496
7111	3380	7290
7111	3380	6280
7111	3380	7779
7111	3380	6818
7111	3380	145
7111	3380	1522
99	3381	8381
99	3381	9386
99	3381	2506
99	3381	4706
16047	3382	5104
16047	3382	3736
16047	3382	3867
16047	3382	6853
16047	3382	8393
16047	3382	6098
15239	3383	7669
12099	3384	3278
12099	3384	7987
12099	3384	2936
12099	3384	6006
2220	3385	3504
2220	3385	4769
2220	3385	6830
2220	3385	4027
2220	3385	1698
2902	3386	9420
2902	3386	4265
2902	3386	7723
2902	3386	8
2902	3386	5524
2902	3386	1097
2902	3386	823
2902	3386	2640
12286	3387	6500
12286	3387	4796
12987	3388	7945
12987	3388	5845
12987	3388	2775
12987	3388	5825
12987	3388	7651
12987	3388	6207
12987	3388	8776
19196	3389	1739
19196	3389	3487
19196	3389	7919
19196	3389	3222
19196	3389	512
19196	3389	9207
19196	3389	7936
7561	3390	3890
7561	3390	1894
16200	3391	5403
16200	3391	4546
16200	3391	6764
16200	3391	1103
16200	3391	5351
17145	3392	8878
13627	3393	594
13627	3393	558
13627	3393	2948
13627	3393	6024
13627	3393	551
13627	3393	4069
13627	3393	159
13627	3393	773
13627	3393	4899
497	3394	8821
497	3394	8156
497	3394	3571
497	3394	4511
497	3394	7856
497	3394	4271
497	3394	9588
11223	3395	6351
11223	3395	7368
16280	3396	15
16280	3396	4168
16280	3396	8009
16280	3396	3540
14220	3397	8773
14220	3397	301
14220	3397	1128
14220	3397	262
14220	3397	5500
3700	3398	8359
3577	3399	2390
3577	3399	9837
3577	3399	7101
3577	3399	6563
3577	3399	485
3577	3399	2983
3577	3399	4136
3577	3399	2301
3577	3399	3171
17342	3400	521
17758	3401	668
6114	3402	3455
6114	3402	2482
6114	3402	1145
6114	3402	1438
6114	3402	2224
6114	3402	7410
6114	3402	836
6114	3402	7088
6114	3402	9251
19543	3403	8651
18636	3404	2375
18636	3404	8902
18636	3404	6378
18636	3404	5846
18636	3404	4350
18636	3404	1650
18636	3404	2856
18636	3404	1098
18636	3404	9640
17781	3405	8662
14625	3406	6630
14625	3406	1029
19859	3407	1313
19859	3407	5153
19859	3407	7962
19859	3407	2235
19859	3407	5862
19859	3407	4510
19859	3407	1517
11903	3408	2806
11903	3408	366
11903	3408	8763
19583	3409	9721
19583	3409	1392
19583	3409	1511
19583	3409	6695
17858	3410	2261
17858	3410	4709
17858	3410	1090
17858	3410	9730
17858	3410	2153
17858	3410	5438
17858	3410	6812
17858	3410	9513
17858	3410	3992
7425	3411	4745
7425	3411	1017
7425	3411	7326
7425	3411	368
7425	3411	3571
16557	3412	7378
16557	3412	1413
16557	3412	8670
16557	3412	2047
3118	3413	7071
3118	3413	8754
3118	3413	2357
3118	3413	1268
3118	3413	4938
10610	3414	7934
10610	3414	9585
13924	3415	6492
13924	3415	389
13924	3415	4625
13924	3415	97
14335	3416	581
14335	3416	8733
14335	3416	3039
14335	3416	441
14335	3416	8976
13818	3417	1248
13818	3417	8628
10237	3418	3657
10237	3418	2766
18493	3419	4481
18493	3419	1893
18493	3419	3349
7580	3420	439
7580	3420	2768
7580	3420	9454
7580	3420	3110
7580	3420	5738
7580	3420	3199
13711	3421	609
13711	3421	7388
13711	3421	9238
13711	3421	3031
13711	3421	5082
13711	3421	6062
13711	3421	169
13711	3421	7825
1186	3422	4609
1186	3422	7090
1186	3422	3477
1186	3422	6950
1186	3422	7144
1186	3422	6993
1186	3422	6055
1186	3422	9282
1186	3422	6249
2660	3423	3296
2660	3423	4254
2660	3423	9468
11573	3424	5215
11573	3424	6668
11573	3424	196
11573	3424	7544
11573	3424	2660
11573	3424	5091
8743	3425	6683
8743	3425	6494
8743	3425	2916
8743	3425	4235
8743	3425	910
5247	3426	8945
5247	3426	3703
5247	3426	3395
5247	3426	9228
3776	3427	603
3776	3427	697
3776	3427	9553
3776	3427	5040
3776	3427	2754
3776	3427	5836
13491	3428	9369
13491	3428	9897
13491	3428	4881
13491	3428	3925
13491	3428	7497
13491	3428	9212
9370	3429	9074
9370	3429	252
9370	3429	3135
9370	3429	4673
9370	3429	3247
9370	3429	2876
7131	3430	3744
7131	3430	4935
7131	3430	7966
7131	3430	6899
7131	3430	2012
7131	3430	4195
18505	3431	5007
18505	3431	8495
18505	3431	8238
18505	3431	4030
18505	3431	3674
18505	3431	9855
18505	3431	471
18505	3431	7549
18505	3431	8693
13317	3432	2121
13317	3432	5846
13317	3432	407
13317	3432	5567
13317	3432	6510
13317	3432	6047
13317	3432	8715
13317	3432	8171
13317	3432	5768
11244	3433	9947
17278	3434	5297
17278	3434	6908
17278	3434	7501
17278	3434	3732
17278	3434	9395
17278	3434	1007
17278	3434	9873
17175	3435	1332
17175	3435	923
17175	3435	2727
17175	3435	1102
17175	3435	4014
17175	3435	1313
17175	3435	2608
17175	3435	963
17175	3435	4027
15517	3436	7057
15517	3436	7569
16953	3437	7555
16953	3437	2869
16953	3437	7829
16953	3437	2172
16953	3437	8269
16953	3437	4367
13949	3438	6490
13949	3438	2429
13949	3438	7974
13949	3438	423
15982	3439	6467
8044	3440	2500
8044	3440	4830
8044	3440	1083
8044	3440	856
8044	3440	2679
8044	3440	2423
8044	3440	7824
8044	3440	9083
8044	3440	7672
16188	3441	6085
16188	3441	5825
16188	3441	1524
16188	3441	6574
16188	3441	1426
12511	3442	9354
12511	3442	4531
12511	3442	8457
12511	3442	899
12511	3442	5867
12511	3442	6531
12511	3442	7039
12511	3442	1632
12511	3442	804
13256	3443	8819
13256	3443	544
13256	3443	5914
13256	3443	6499
13256	3443	7626
4313	3444	9110
4313	3444	8990
4313	3444	8765
11607	3445	4930
16206	3446	2800
16206	3446	4972
16206	3446	7594
16206	3446	1887
16206	3446	541
16206	3446	9944
16206	3446	1669
16206	3446	7506
12989	3447	2015
12989	3447	1178
12989	3447	4415
12989	3447	5020
12989	3447	4210
14019	3448	353
14019	3448	6263
14019	3448	2586
14019	3448	1752
14019	3448	1599
18208	3449	5599
18208	3449	2342
18208	3449	4221
18208	3449	729
18208	3449	9626
18208	3449	911
18208	3449	9300
402	3450	8695
402	3450	3437
10377	3451	8609
10377	3451	464
12124	3452	3675
12124	3452	6995
12124	3452	5614
12124	3452	152
18904	3453	9653
18904	3453	2496
11864	3454	1121
11864	3454	8616
11864	3454	7606
11864	3454	2535
11864	3454	5142
11864	3454	2216
11864	3454	2272
15770	3455	4409
15770	3455	2823
15770	3455	7584
15770	3455	6786
8561	3456	1536
304	3457	9232
304	3457	234
4898	3458	1659
4898	3458	4845
4898	3458	9779
4898	3458	3774
4898	3458	1503
4898	3458	5077
4898	3458	1435
14892	3459	4577
14892	3459	4257
14892	3459	1732
14892	3459	831
11036	3460	2477
14642	3461	6574
14642	3461	9838
14642	3461	8690
14642	3461	6365
14642	3461	814
14642	3461	7571
14642	3461	3038
14588	3462	782
14588	3462	1096
14588	3462	9931
14588	3462	9692
14588	3462	1581
14588	3462	9729
14588	3462	4385
14588	3462	2475
14588	3462	4379
1486	3463	9676
1486	3463	7114
1486	3463	1007
1486	3463	7
1486	3463	3646
1486	3463	9003
1486	3463	9431
1486	3463	250
1486	3463	1341
2137	3464	7371
3497	3465	2491
3497	3465	3966
3497	3465	761
3497	3465	4880
9774	3466	5676
9774	3466	3979
9774	3466	4292
9774	3466	4229
9774	3466	6060
9774	3466	6701
9774	3466	1155
9774	3466	2479
9774	3466	5820
16621	3467	477
16621	3467	5092
16621	3467	7520
16621	3467	244
11838	3468	1025
11838	3468	8128
11838	3468	9159
11838	3468	5752
13813	3469	2939
13813	3469	2788
13813	3469	4059
13813	3469	6999
13813	3469	3532
13813	3469	9893
13813	3469	2774
13813	3469	4927
13813	3469	6055
14159	3470	2333
14159	3470	8910
14159	3470	2704
14159	3470	4991
14159	3470	5826
17228	3471	6394
17228	3471	6977
17228	3471	4
5556	3472	5473
5556	3472	65
5556	3472	138
5556	3472	6791
5556	3472	4598
5556	3472	555
11091	3473	3475
11091	3473	6268
11091	3473	758
11091	3473	2304
11091	3473	2587
11091	3473	4603
11091	3473	5086
1116	3474	2626
1116	3474	7283
1116	3474	7274
1116	3474	5117
1116	3474	9182
1116	3474	3374
1116	3474	4599
1116	3474	7433
1116	3474	1238
7082	3475	5849
7082	3475	9676
7082	3475	2133
7082	3475	1492
7082	3475	8673
7082	3475	1601
17749	3476	6703
17749	3476	5594
17749	3476	6132
17749	3476	6923
17749	3476	1059
17749	3476	1754
17749	3476	1702
17749	3476	699
748	3477	9516
16375	3478	4143
16375	3478	7607
16375	3478	6272
16375	3478	8993
16375	3478	4385
16375	3478	2058
16375	3478	8688
16375	3478	9468
2338	3479	8718
2338	3479	8773
2338	3479	6657
2338	3479	7174
2338	3479	6476
2338	3479	2522
2338	3479	8887
2338	3479	2595
3175	3480	6712
3175	3480	130
3175	3480	2196
3175	3480	5841
3175	3480	766
3175	3480	8296
3175	3480	280
3175	3480	6683
7713	3481	5120
7713	3481	2450
10088	3482	6631
10088	3482	6634
10088	3482	5267
10088	3482	8742
10088	3482	6359
10088	3482	7359
10088	3482	8541
10088	3482	6608
6581	3483	7147
6581	3483	9910
6581	3483	9725
6581	3483	6272
6581	3483	7403
6581	3483	911
6581	3483	1621
6581	3483	7376
12235	3484	699
18479	3485	8060
18479	3485	7686
18479	3485	8163
18479	3485	295
39	3486	3119
39	3486	8803
39	3486	1867
39	3486	1572
11754	3487	6541
11754	3487	3368
1459	3488	814
1459	3488	7172
1459	3488	1242
1459	3488	7049
14959	3489	5313
14358	3490	6421
14358	3490	2079
14358	3490	9904
14358	3490	7838
14358	3490	2949
14358	3490	4001
9628	3491	3791
9628	3491	1129
9628	3491	7663
9628	3491	8318
7259	3492	808
7259	3492	50
7259	3492	9057
7259	3492	9009
13692	3493	9981
13692	3493	5370
13692	3493	1046
13692	3493	136
2528	3494	9877
18187	3495	2941
18187	3495	499
18187	3495	5657
18187	3495	5120
18187	3495	8515
18187	3495	1511
18187	3495	9565
18187	3495	6977
18187	3495	7964
16198	3496	9363
16198	3496	1600
2815	3497	1094
3185	3498	1148
3185	3498	8889
3185	3498	5251
3185	3498	409
14771	3499	5407
14771	3499	7954
14771	3499	9296
14771	3499	6794
14771	3499	6556
14771	3499	2303
14771	3499	9455
14771	3499	6163
14771	3499	4989
12273	3500	5800
12273	3500	1536
6853	3501	3281
6853	3501	7757
6853	3501	7264
6853	3501	8552
6853	3501	7949
6853	3501	3371
6853	3501	9996
6853	3501	3648
6853	3501	848
6189	3502	4230
6189	3502	1453
6189	3502	6780
6189	3502	9192
6189	3502	950
6189	3502	9371
13268	3503	691
13268	3503	7365
13268	3503	3958
15210	3504	6241
15210	3504	829
15210	3504	6496
15210	3504	1586
15210	3504	824
15210	3504	9276
15210	3504	8737
16215	3505	4741
16215	3505	8451
16215	3505	8396
16215	3505	9494
16215	3505	3176
16215	3505	9957
12396	3506	7212
12396	3506	2
12396	3506	1240
12396	3506	7162
12396	3506	840
6652	3507	9519
6652	3507	4360
6652	3507	4177
6652	3507	3786
6652	3507	5108
6652	3507	50
6652	3507	3656
6652	3507	1262
6652	3507	9107
18217	3508	9934
18217	3508	5499
18217	3508	329
18217	3508	4099
18217	3508	5910
539	3509	3025
539	3509	926
539	3509	2334
539	3509	3196
539	3509	5140
539	3509	6440
539	3509	2931
402	3510	4632
402	3510	4061
402	3510	6902
5622	3511	3081
5622	3511	9628
5622	3511	8737
2140	3512	7059
2140	3512	1890
2140	3512	915
2140	3512	3680
2140	3512	5022
2140	3512	7557
2140	3512	9509
12820	3513	9221
12820	3513	6280
12820	3513	4918
12820	3513	8406
5285	3514	75
5285	3514	4658
5285	3514	5280
5285	3514	6786
5285	3514	9841
5285	3514	7805
5285	3514	1459
5285	3514	9015
17583	3515	346
17583	3515	5245
17583	3515	2166
17253	3516	6616
17253	3516	5424
17253	3516	8332
17253	3516	6845
13369	3517	4081
13369	3517	4780
13369	3517	4455
13369	3517	1887
13369	3517	1446
13369	3517	692
13369	3517	7495
12824	3518	54
12824	3518	3000
12824	3518	9371
12824	3518	6180
12824	3518	6449
12824	3518	2900
13961	3519	76
13961	3519	6590
13961	3519	641
13961	3519	4194
13961	3519	4725
13961	3519	4190
13961	3519	8101
13961	3519	1698
9394	3520	6029
9394	3520	9357
9394	3520	5650
17916	3521	7046
17916	3521	3810
17916	3521	1273
17916	3521	1669
17916	3521	5783
17916	3521	7155
17916	3521	1458
6310	3522	7852
6310	3522	2556
6310	3522	6847
6310	3522	6358
6310	3522	4167
6310	3522	1455
6310	3522	9809
6310	3522	2713
6310	3522	2134
7606	3523	196
7606	3523	3824
7606	3523	1862
7606	3523	4808
5319	3524	6540
5319	3524	3348
15029	3525	916
15029	3525	1604
15029	3525	8530
13196	3526	450
13196	3526	3672
13196	3526	9390
13196	3526	3742
13196	3526	804
13196	3526	6857
13196	3526	4061
14817	3527	4923
14817	3527	7020
14817	3527	6307
14817	3527	9467
14161	3528	4146
14161	3528	7637
14161	3528	6158
14161	3528	3352
14161	3528	1223
14161	3528	2523
14161	3528	7265
14161	3528	1476
14161	3528	3991
17826	3529	4752
8436	3530	1299
8436	3530	1350
17973	3531	6012
17973	3531	9682
17973	3531	767
17973	3531	5315
17973	3531	8786
17973	3531	7562
17973	3531	4559
17973	3531	1690
17973	3531	1471
1117	3532	2007
1117	3532	1243
1117	3532	7401
1117	3532	2343
1117	3532	4651
1117	3532	7275
1117	3532	5589
1117	3532	6536
1117	3532	6073
7268	3533	4640
7268	3533	5975
7268	3533	6228
13771	3534	8842
13771	3534	2031
13771	3534	781
13771	3534	6904
13771	3534	2728
13771	3534	9763
13771	3534	2219
13771	3534	9220
13824	3535	9164
13824	3535	9504
13824	3535	2675
13824	3535	306
13824	3535	2616
13824	3535	8017
13824	3535	888
13824	3535	7699
13824	3535	4421
14296	3536	5465
14296	3536	3159
14296	3536	9290
14296	3536	1596
14296	3536	4495
14296	3536	7779
14296	3536	5896
12402	3537	1177
12402	3537	3803
12402	3537	7859
4558	3538	9427
9781	3539	9574
2338	3540	1928
15646	3541	4024
15646	3541	6197
15646	3541	2220
15646	3541	7264
1991	3542	1827
1991	3542	2484
1991	3542	6673
1991	3542	369
1991	3542	3532
1991	3542	7416
1991	3542	6121
485	3543	4094
485	3543	3099
485	3543	6389
485	3543	288
485	3543	5396
485	3543	4647
485	3543	9390
485	3543	9534
12414	3544	2454
12414	3544	2357
12414	3544	3682
12414	3544	9212
12414	3544	8719
12414	3544	6448
19092	3545	4864
19092	3545	7606
19092	3545	5177
19092	3545	8011
15088	3546	3751
15088	3546	1076
15088	3546	442
15088	3546	6073
15088	3546	1909
1254	3547	3439
1254	3547	7875
1254	3547	3181
1254	3547	9929
1254	3547	2998
1254	3547	3039
1254	3547	9671
1254	3547	8551
4604	3548	8506
4604	3548	987
4604	3548	7349
4604	3548	9863
4604	3548	3522
4604	3548	7560
4604	3548	751
7864	3549	4718
7864	3549	8534
7864	3549	2177
7864	3549	9521
12002	3550	3556
12002	3550	322
12002	3550	6113
12002	3550	7438
12002	3550	6901
12002	3550	7499
12002	3550	7920
2841	3551	4850
2841	3551	9236
2841	3551	4656
2841	3551	1588
2841	3551	2140
2841	3551	178
2841	3551	2997
2841	3551	6703
5631	3552	8791
5631	3552	6673
5631	3552	2350
5631	3552	4539
5631	3552	6014
5631	3552	310
19091	3553	958
19091	3553	2451
19091	3553	1734
19091	3553	8266
19091	3553	6361
19091	3553	8050
19091	3553	7784
19091	3553	350
14046	3554	1616
14046	3554	1521
14046	3554	4120
14046	3554	8492
14046	3554	1376
14046	3554	6012
14046	3554	8570
14046	3554	5430
14046	3554	1090
14900	3555	2087
14900	3555	2121
14900	3555	3019
11761	3556	3281
14800	3557	5138
14800	3557	9931
14800	3557	5382
14800	3557	9611
14800	3557	8804
14800	3557	4505
14800	3557	8150
471	3558	2672
471	3558	8089
471	3558	8511
471	3558	3205
471	3558	6259
471	3558	9191
471	3558	9102
471	3558	982
471	3558	5477
10173	3559	5786
10173	3559	174
10173	3559	4847
10173	3559	4171
10173	3559	6136
10173	3559	7089
11197	3560	7389
11197	3560	4084
6371	3561	2218
6371	3561	2175
6371	3561	1469
6371	3561	6087
6371	3561	1028
6371	3561	1191
10722	3562	2204
10722	3562	3715
10722	3562	3019
10722	3562	3353
10722	3562	1248
10722	3562	6987
10722	3562	622
10722	3562	1887
10722	3562	4276
11490	3563	3000
11490	3563	4936
11490	3563	312
11490	3563	9551
11490	3563	7780
11490	3563	8065
11490	3563	2930
11490	3563	5846
14188	3564	3171
14188	3564	6372
14188	3564	7178
14188	3564	9119
14188	3564	6393
14188	3564	8442
14188	3564	6965
14188	3564	3582
6265	3565	4887
6265	3565	941
6265	3565	7068
6265	3565	4098
6265	3565	3881
6265	3565	7037
6265	3565	2155
6265	3565	2108
6265	3565	4056
896	3566	9840
896	3566	918
896	3566	7995
896	3566	6553
896	3566	2032
896	3566	1899
896	3566	9255
6704	3567	1167
6704	3567	691
6704	3567	7970
6704	3567	2653
3503	3568	9292
3503	3568	8495
3503	3568	5733
3503	3568	2795
3503	3568	2404
3503	3568	3724
3503	3568	7799
15116	3569	1198
3777	3570	4687
3777	3570	5350
3777	3570	5222
9028	3571	4723
9028	3571	1471
9028	3571	8153
9028	3571	2343
9028	3571	8176
2888	3572	2237
2888	3572	8682
18999	3573	2970
18999	3573	4182
18999	3573	4088
18999	3573	2706
18999	3573	5650
14240	3574	994
14240	3574	118
14240	3574	7430
14240	3574	613
14240	3574	6157
14240	3574	4026
14240	3574	441
14240	3574	4337
14614	3575	5499
14614	3575	5131
14614	3575	5930
14614	3575	5633
14614	3575	7900
17787	3576	8063
17787	3576	9350
17787	3576	423
17787	3576	1525
3929	3577	3320
3929	3577	1987
3929	3577	4005
3929	3577	2648
3929	3577	5690
2643	3578	1899
2643	3578	6709
2643	3578	3234
2643	3578	5059
2643	3578	3446
2643	3578	8089
2643	3578	9930
2643	3578	6934
506	3579	1193
506	3579	2584
506	3579	1869
506	3579	2418
506	3579	9595
2986	3580	1257
2986	3580	1078
2986	3580	1686
2986	3580	1796
2986	3580	9492
2986	3580	8205
2634	3581	6416
2634	3581	2378
2634	3581	1711
2634	3581	7272
2634	3581	6031
2634	3581	1141
2634	3581	8359
2634	3581	1937
2634	3581	6112
15595	3582	7571
15595	3582	9452
15595	3582	3454
15595	3582	7093
15595	3582	10
15595	3582	8002
15595	3582	2507
19557	3583	6645
19557	3583	8295
19557	3583	1990
16203	3584	5899
6939	3585	9245
6939	3585	8091
6939	3585	1396
6939	3585	9845
6939	3585	487
6939	3585	9110
6939	3585	2129
17546	3586	3776
17546	3586	8311
17546	3586	8021
17546	3586	8943
17546	3586	2339
17546	3586	7389
17546	3586	4942
17546	3586	1414
5619	3587	2207
5619	3587	5165
5619	3587	8739
17048	3588	6604
17048	3588	2115
270	3589	4054
270	3589	4395
270	3589	8959
270	3589	8075
270	3589	2368
270	3589	3182
270	3589	3859
18048	3590	6317
18048	3590	2381
18048	3590	3167
18048	3590	2225
920	3591	7638
4065	3592	1368
4065	3592	8509
4065	3592	32
4065	3592	7235
4065	3592	7079
4065	3592	2914
4065	3592	6210
4065	3592	4756
15845	3593	3204
15845	3593	4297
15845	3593	1840
15845	3593	8090
18003	3594	7988
18003	3594	9070
18003	3594	9352
18003	3594	1909
18003	3594	8658
9733	3595	3456
9733	3595	2892
9733	3595	9502
9733	3595	2501
9733	3595	4715
5609	3596	1806
5609	3596	5032
5609	3596	2172
5609	3596	7812
5609	3596	406
5609	3596	7954
5609	3596	4543
5609	3596	3930
5609	3596	3137
12056	3597	2123
12056	3597	7558
12056	3597	5254
12056	3597	9642
2895	3598	1241
2895	3598	2120
2895	3598	8815
2895	3598	8773
2895	3598	1589
2895	3598	4935
2895	3598	1909
2895	3598	2902
2632	3599	2230
2632	3599	3059
2632	3599	773
2632	3599	8093
2632	3599	4148
2632	3599	1778
7795	3600	6423
7795	3600	6085
7795	3600	6527
7795	3600	3528
7795	3600	9090
7795	3600	4601
7795	3600	7746
7795	3600	9410
7795	3600	2011
5566	3601	6542
5566	3601	8763
5566	3601	4705
5566	3601	2217
5566	3601	8584
9337	3602	5688
9337	3602	7317
9337	3602	6608
9337	3602	7966
9337	3602	6445
9337	3602	4328
9337	3602	9844
9337	3602	1238
15560	3603	6100
15560	3603	5364
15560	3603	8180
15560	3603	6956
15560	3603	8616
15560	3603	9419
13472	3604	8654
10196	3605	3553
10196	3605	856
10196	3605	9277
10196	3605	2571
10196	3605	4288
10196	3605	2641
10196	3605	6986
10196	3605	3600
10196	3605	1357
1551	3606	7511
1551	3606	1719
12924	3607	5533
12924	3607	1329
12924	3607	9606
12924	3607	4578
12924	3607	4211
12924	3607	846
12924	3607	8518
4233	3608	4332
4233	3608	9803
4233	3608	645
4233	3608	6448
4233	3608	3478
4233	3608	8825
4233	3608	6156
4233	3608	9556
4233	3608	745
10644	3609	4188
10644	3609	9151
10644	3609	13
3567	3610	1100
3567	3610	1
3567	3610	2966
3567	3610	4108
3567	3610	5539
3567	3610	1184
3567	3610	7290
3567	3610	9178
3567	3610	9901
2475	3611	3420
2475	3611	247
2475	3611	5537
2475	3611	5216
2475	3611	4219
2475	3611	7037
2475	3611	8060
4334	3612	5099
4334	3612	7900
4334	3612	8368
4334	3612	422
4334	3612	4343
4334	3612	9505
5848	3613	6357
5848	3613	6633
1703	3614	5070
1703	3614	6582
1703	3614	8113
1703	3614	1943
1703	3614	656
1703	3614	5600
12042	3615	9798
12042	3615	5169
15580	3616	5948
15580	3616	7647
15580	3616	167
15580	3616	2070
15580	3616	1479
15580	3616	973
5831	3617	2757
5831	3617	1358
5831	3617	4423
8441	3618	5337
8441	3618	3895
8441	3618	1234
8441	3618	7335
8441	3618	5332
8441	3618	4413
11784	3619	5483
11784	3619	6626
11784	3619	67
11784	3619	6688
2220	3620	5330
2220	3620	6100
2220	3620	672
2220	3620	8687
2220	3620	9835
2220	3620	786
2220	3620	3523
2220	3620	2568
2220	3620	1091
13147	3621	4859
13147	3621	5978
13147	3621	7844
13147	3621	2656
13147	3621	5030
13147	3621	3427
8198	3622	6005
8198	3622	3361
8198	3622	6124
8198	3622	1989
8198	3622	3143
8198	3622	7312
8198	3622	9653
9023	3623	6058
9023	3623	722
9023	3623	5843
9023	3623	6699
9023	3623	6880
9023	3623	3368
18744	3624	6163
18744	3624	2934
18744	3624	3774
18744	3624	1231
18744	3624	9188
18744	3624	4751
9670	3625	2763
9670	3625	165
13726	3626	2215
13726	3626	5935
13726	3626	614
13726	3626	956
13726	3626	9977
13726	3626	4927
13726	3626	9965
13726	3626	4836
19172	3627	4421
19172	3627	3885
19172	3627	7931
17968	3628	6917
17968	3628	4904
17968	3628	8031
17968	3628	7745
15441	3629	1471
15441	3629	3375
15441	3629	1992
15441	3629	5892
15441	3629	2847
15441	3629	2667
15441	3629	7495
6566	3630	6945
6566	3630	4816
5692	3631	1832
5692	3631	4813
5692	3631	6875
5692	3631	7547
5692	3631	2589
5692	3631	664
5692	3631	9576
4485	3632	2840
4485	3632	9569
4485	3632	2711
4485	3632	8918
4485	3632	8360
4485	3632	372
4407	3633	6911
8913	3634	3994
8913	3634	7521
8913	3634	6680
8913	3634	5811
8913	3634	2597
8913	3634	7941
8913	3634	1072
8913	3634	8677
8913	3634	8177
17096	3635	752
17096	3635	3783
17096	3635	398
17096	3635	2118
12223	3636	9681
12223	3636	3108
12223	3636	9673
12223	3636	4142
12223	3636	7869
12223	3636	8264
12223	3636	5202
6914	3637	7070
6914	3637	4486
6914	3637	3402
6914	3637	1087
6914	3637	7786
6914	3637	1631
2622	3638	6802
1887	3639	6157
1887	3639	384
1887	3639	8600
1887	3639	4815
3768	3640	2736
3768	3640	9677
3768	3640	8249
3768	3640	4186
3768	3640	1321
15862	3641	4213
15862	3641	8936
15862	3641	1420
15862	3641	268
15862	3641	6451
15862	3641	5769
15862	3641	2456
15862	3641	3149
11769	3642	9707
7784	3643	5237
7784	3643	7261
7784	3643	1823
7784	3643	4429
7784	3643	9582
7784	3643	5851
7784	3643	7651
7784	3643	8717
7784	3643	3566
13429	3644	2599
4610	3645	6197
4610	3645	8253
4610	3645	6698
4610	3645	8281
4610	3645	6988
4610	3645	9280
4610	3645	8558
4610	3645	6418
4610	3645	7431
1993	3646	7711
1993	3646	9490
1993	3646	6726
1993	3646	2615
1993	3646	9326
1993	3646	9821
1993	3646	245
1993	3646	3093
1993	3646	5039
8636	3647	9448
8636	3647	6001
8636	3647	8201
8636	3647	7875
8636	3647	4751
8636	3647	3766
8636	3647	5895
8636	3647	4643
8636	3647	7445
14529	3648	3783
14529	3648	6089
14529	3648	4719
14529	3648	3140
14529	3648	7116
14529	3648	4433
14529	3648	9466
14681	3649	2926
14681	3649	7735
14681	3649	1395
14681	3649	7330
9298	3650	2213
9298	3650	2533
9298	3650	8708
9298	3650	5626
9298	3650	8618
9298	3650	4434
9298	3650	5858
9298	3650	5683
5642	3651	3725
5642	3651	2985
5642	3651	8209
5642	3651	3959
124	3652	9948
124	3652	5477
124	3652	2231
124	3652	502
124	3652	3843
124	3652	3899
124	3652	8833
143	3653	4236
143	3653	8229
143	3653	1245
10405	3654	5265
10405	3654	9671
10405	3654	8419
1300	3655	1498
1300	3655	9303
1300	3655	9791
1300	3655	4977
14756	3656	3504
14756	3656	9663
14756	3656	1155
4293	3657	5586
4293	3657	426
4293	3657	4511
4293	3657	4655
4293	3657	8661
15926	3658	6098
8608	3659	6746
8608	3659	5938
14185	3660	9239
14185	3660	7316
15483	3661	2034
15483	3661	7930
15483	3661	9635
15483	3661	8658
15483	3661	9419
15483	3661	7706
15483	3661	9059
11609	3662	2213
11609	3662	8400
15276	3663	2462
2581	3664	4773
8815	3665	5590
8815	3665	4463
8815	3665	9222
8815	3665	4902
8815	3665	9325
8815	3665	5898
8815	3665	5078
8815	3665	7354
8815	3665	1935
8794	3666	5688
8794	3666	7602
8794	3666	4060
8794	3666	4868
8794	3666	8360
8794	3666	4785
8794	3666	3752
17307	3667	2567
17307	3667	7205
17307	3667	8793
17307	3667	5987
17307	3667	1026
17307	3667	5124
1622	3668	1271
1622	3668	8410
1622	3668	225
1622	3668	6595
1622	3668	9592
1622	3668	9015
1622	3668	8999
1622	3668	1602
1622	3668	2107
1798	3669	1626
1798	3669	106
1798	3669	3657
1798	3669	7561
1798	3669	2018
854	3670	7197
13575	3671	2721
13575	3671	2481
13575	3671	2475
13575	3671	3128
13575	3671	5487
14225	3672	3863
14225	3672	9246
14225	3672	4648
14225	3672	255
14225	3672	1691
14225	3672	6114
14225	3672	6789
17398	3673	9608
17398	3673	2716
17398	3673	3905
17398	3673	3767
17398	3673	2336
17398	3673	6504
17398	3673	7631
17398	3673	7757
4810	3674	7674
4810	3674	7268
8112	3675	2755
8112	3675	2784
8112	3675	1907
8112	3675	4445
16422	3676	8857
16422	3676	6897
16422	3676	2071
16422	3676	3364
3006	3677	1333
3006	3677	8519
3006	3677	7226
3006	3677	4438
3006	3677	6863
17538	3678	4580
17538	3678	4998
17538	3678	7743
17538	3678	1487
17538	3678	342
17538	3678	9293
17538	3678	7417
6639	3679	6489
6639	3679	6589
6639	3679	3874
6639	3679	3695
6639	3679	8248
6639	3679	9505
8169	3680	3866
8169	3680	1678
8169	3680	7414
8169	3680	8910
8169	3680	5724
8169	3680	3059
8169	3680	9647
8169	3680	7471
8119	3681	5086
8119	3681	8353
8119	3681	9583
8119	3681	4303
8119	3681	1942
8119	3681	231
8119	3681	2110
19048	3682	6231
18577	3683	3430
18577	3683	2177
18577	3683	2110
18577	3683	4790
18577	3683	5572
18577	3683	530
9664	3684	4167
9664	3684	8747
9664	3684	9700
7253	3685	3277
7253	3685	1319
9497	3686	1922
9497	3686	6616
9497	3686	1213
9497	3686	9853
9497	3686	7341
9803	3687	2693
4786	3688	6019
4786	3688	4847
4786	3688	8788
2398	3689	5788
2398	3689	9075
2398	3689	9545
2398	3689	4590
2398	3689	2029
17204	3690	9343
17204	3690	6576
17204	3690	1916
17204	3690	9175
8043	3691	187
2200	3692	3935
2200	3692	9612
2200	3692	4800
2200	3692	2876
2200	3692	6131
2200	3692	5430
2200	3692	7162
7475	3693	2756
7475	3693	2336
7475	3693	4327
7475	3693	4414
11669	3694	3044
11669	3694	9898
11669	3694	3027
11669	3694	6857
11669	3694	1525
13910	3695	1727
13910	3695	9926
13910	3695	2834
13910	3695	3163
13910	3695	6872
13910	3695	4735
9362	3696	66
9362	3696	7163
9362	3696	2817
9362	3696	4660
9362	3696	6091
9362	3696	2660
9362	3696	3140
9733	3697	7724
9733	3697	3910
1563	3698	2066
1563	3698	4461
1563	3698	7993
1563	3698	9348
1563	3698	4489
1563	3698	5344
1563	3698	1838
1563	3698	5333
1563	3698	6552
15710	3699	9084
5987	3700	3775
5987	3700	4847
5987	3700	699
5987	3700	5026
5987	3700	3833
16642	3701	7469
16642	3701	626
16642	3701	2872
16642	3701	1274
16642	3701	5032
16642	3701	6124
16642	3701	5674
16642	3701	7109
16642	3701	1213
12119	3702	5367
12119	3702	7333
12119	3702	6123
12119	3702	7520
12119	3702	371
12119	3702	1034
12119	3702	7790
12119	3702	8172
6407	3703	7319
6407	3703	2150
6407	3703	6969
6407	3703	5310
6407	3703	9422
6407	3703	3552
1769	3704	2064
1769	3704	2565
1769	3704	6493
1769	3704	3430
1769	3704	7502
1769	3704	3346
1769	3704	4805
1769	3704	3387
1769	3704	6370
6676	3705	8249
6676	3705	3893
15351	3706	7581
15351	3706	8600
15351	3706	7182
15351	3706	3742
15351	3706	9375
15351	3706	2212
15351	3706	8626
4024	3707	7549
4024	3707	9448
4024	3707	7546
4024	3707	4768
4024	3707	9497
4024	3707	9113
13386	3708	6837
13386	3708	8662
13386	3708	4721
13386	3708	1821
892	3709	2458
12	3710	6453
12	3710	3751
12	3710	7755
12	3710	9097
12	3710	5428
12	3710	3560
793	3711	975
793	3711	4335
793	3711	8119
793	3711	3241
793	3711	5589
793	3711	5151
7845	3712	240
7845	3712	3378
4949	3713	6542
8356	3714	477
8356	3714	682
8356	3714	2587
8356	3714	9902
8356	3714	865
8356	3714	1526
8356	3714	7685
8356	3714	9938
8356	3714	9387
5527	3715	5238
5527	3715	3852
5527	3715	1454
543	3716	63
543	3716	1244
543	3716	5857
543	3716	8478
543	3716	6636
543	3716	2737
5349	3717	2852
5349	3717	9382
5349	3717	1364
5349	3717	4056
5349	3717	6398
5349	3717	2096
16943	3718	5528
16943	3718	8493
16943	3718	1176
16943	3718	8105
16943	3718	6973
16943	3718	2131
4767	3719	569
4767	3719	7390
4767	3719	4824
4767	3719	7148
4767	3719	6955
4767	3719	3576
4726	3720	2394
4726	3720	4627
4726	3720	4040
2023	3721	5216
2023	3721	5894
2023	3721	3456
2023	3721	6243
2131	3722	2287
2131	3722	4787
2131	3722	1980
2131	3722	8225
2131	3722	5745
742	3723	3103
742	3723	2677
15785	3724	3931
15785	3724	1435
15785	3724	8065
15785	3724	1238
15785	3724	5374
320	3725	2662
320	3725	2136
19523	3726	1427
19523	3726	7984
19523	3726	8555
4636	3727	9538
4636	3727	6098
4636	3727	3298
4636	3727	7957
4636	3727	861
4636	3727	8831
2985	3728	9898
2985	3728	1034
4919	3729	6562
4919	3729	3550
4919	3729	1426
4919	3729	4482
4919	3729	9052
4919	3729	8564
13042	3730	4078
13042	3730	9022
13042	3730	1343
13042	3730	4486
13042	3730	2967
13042	3730	9915
13042	3730	7979
13042	3730	7959
3017	3731	7092
12286	3732	8493
19025	3733	9363
19025	3733	4339
17649	3734	4343
17649	3734	5182
17649	3734	2328
17649	3734	6861
19914	3735	7534
19914	3735	7883
12750	3736	5887
12750	3736	3562
12750	3736	472
2433	3737	4928
2433	3737	9762
2433	3737	3389
2433	3737	3249
2433	3737	3992
2433	3737	206
2433	3737	9638
2433	3737	1759
14298	3738	9586
14298	3738	1795
14298	3738	5032
14298	3738	1048
14298	3738	3483
16819	3739	8519
16819	3739	739
16819	3739	2477
16819	3739	9665
16819	3739	1625
16819	3739	422
16819	3739	6822
16819	3739	532
235	3740	3266
8626	3741	2085
8626	3741	4993
8626	3741	4052
8626	3741	3152
8626	3741	5278
8626	3741	9521
2291	3742	4528
2291	3742	2583
2291	3742	1780
2291	3742	5177
2291	3742	2458
2291	3742	7806
2291	3742	2755
2291	3742	2143
14270	3743	646
14270	3743	8566
14270	3743	4543
14270	3743	865
10216	3744	6173
10216	3744	8819
10216	3744	5790
10216	3744	230
16070	3745	2355
16070	3745	32
16070	3745	3084
16070	3745	5853
16070	3745	4710
18505	3746	2106
7380	3747	7857
7380	3747	9748
19954	3748	8012
733	3749	2444
733	3749	1767
733	3749	8460
733	3749	2715
733	3749	5729
733	3749	8627
8500	3750	6046
8500	3750	6766
8500	3750	3026
9840	3751	620
9840	3751	4147
9840	3751	7736
9840	3751	7000
10919	3752	3571
10919	3752	2822
10919	3752	9543
10919	3752	6447
10919	3752	2228
10919	3752	446
10919	3752	8284
8107	3753	7834
8107	3753	1656
8107	3753	1279
8107	3753	8571
8107	3753	8894
8107	3753	3738
8107	3753	1060
8107	3753	6582
8107	3753	9505
11901	3754	8442
11901	3754	4878
11901	3754	1106
11901	3754	779
11901	3754	8839
11901	3754	8508
19572	3755	8065
19572	3755	2619
19572	3755	3652
19572	3755	9110
19572	3755	7559
19572	3755	6357
19572	3755	4564
19572	3755	7101
19572	3755	1180
4570	3756	1782
578	3757	75
578	3757	8875
578	3757	8922
578	3757	9941
578	3757	5171
578	3757	2807
578	3757	7664
578	3757	3945
578	3757	2708
7773	3758	6172
7773	3758	5471
7773	3758	3712
7773	3758	8242
7773	3758	4305
6357	3759	4672
6357	3759	5606
6357	3759	5447
6220	3760	5337
6220	3760	7562
6220	3760	4168
6220	3760	5531
6220	3760	4533
6220	3760	8293
13069	3761	4851
13069	3761	3076
13069	3761	9356
13069	3761	7703
13069	3761	7589
13069	3761	3373
13069	3761	6258
13069	3761	6677
13069	3761	1229
10793	3762	5736
10793	3762	8696
10793	3762	7600
10793	3762	562
10793	3762	4187
10793	3762	6137
10793	3762	6719
8842	3763	7570
8842	3763	2758
8842	3763	4773
12002	3764	1398
12002	3764	5279
12002	3764	7850
12002	3764	1161
12002	3764	8263
12002	3764	5263
12002	3764	7135
7707	3765	8274
7707	3765	7316
7707	3765	1168
7707	3765	9671
7707	3765	9508
6359	3766	1675
6359	3766	472
6359	3766	1930
6359	3766	4974
472	3767	1634
17048	3768	5867
17048	3768	8459
17048	3768	4458
7931	3769	7145
7931	3769	8255
7931	3769	3854
7931	3769	8343
7931	3769	358
7422	3770	4200
7422	3770	967
7422	3770	3711
7422	3770	1156
7422	3770	2420
7422	3770	6611
7422	3770	7744
7422	3770	843
15976	3771	6807
15976	3771	1482
15976	3771	6501
4952	3772	1092
4952	3772	7205
1829	3773	491
1829	3773	9060
1829	3773	9390
1829	3773	6687
1829	3773	7769
1829	3773	8220
1829	3773	3945
1829	3773	5350
1829	3773	176
17282	3774	659
17282	3774	2563
17282	3774	7475
15133	3775	79
15133	3775	6370
15133	3775	6160
15133	3775	9700
15133	3775	4246
15133	3775	8560
15133	3775	2945
15133	3775	3615
15133	3775	5759
169	3776	5502
169	3776	283
169	3776	7108
14809	3777	6761
5842	3778	6850
5842	3778	7706
5842	3778	190
5842	3778	9318
5842	3778	3771
5842	3778	4684
5842	3778	5162
5842	3778	7952
5842	3778	4632
3478	3779	9143
3478	3779	4800
3478	3779	322
3478	3779	8825
11348	3780	1083
11348	3780	3031
11348	3780	4073
17513	3781	7133
3528	3782	3503
3528	3782	9118
3528	3782	1435
3528	3782	8549
3528	3782	8804
6954	3783	5857
6954	3783	180
6954	3783	4531
6954	3783	5689
6954	3783	3009
6954	3783	646
6954	3783	8306
6954	3783	1905
6954	3783	6884
12002	3784	9918
12002	3784	5827
12002	3784	3974
12002	3784	2198
16108	3785	6942
16108	3785	4
16108	3785	5689
16108	3785	652
16108	3785	3152
16108	3785	8280
10328	3786	1165
10328	3786	2485
10328	3786	5115
10328	3786	9803
10328	3786	3971
10328	3786	6110
10328	3786	54
10328	3786	5294
10593	3787	8308
10593	3787	4963
10593	3787	9232
10593	3787	6516
10593	3787	8407
10593	3787	3427
10593	3787	5492
10593	3787	654
911	3788	2455
911	3788	7736
911	3788	3064
911	3788	9502
911	3788	8325
911	3788	4633
911	3788	9401
911	3788	8092
9213	3789	1584
9213	3789	817
2940	3790	1925
2940	3790	5398
2940	3790	3179
2940	3790	6888
2940	3790	6161
2940	3790	2247
2940	3790	5515
9831	3791	3549
9831	3791	3815
9831	3791	560
9831	3791	4264
9831	3791	2475
9831	3791	2846
9831	3791	4451
9831	3791	7532
9831	3791	9150
12074	3792	2426
12074	3792	3627
12074	3792	6078
12074	3792	2856
12074	3792	3953
12074	3792	1867
12074	3792	3597
12074	3792	3167
12074	3792	3802
13293	3793	1417
13293	3793	9405
13293	3793	4038
13293	3793	6603
13293	3793	1527
13293	3793	188
13293	3793	6968
13293	3793	9898
13293	3793	8819
1370	3794	3111
1370	3794	7683
1370	3794	426
1370	3794	3558
1370	3794	2345
1370	3794	9549
1370	3794	5540
1370	3794	4135
1370	3794	4576
9526	3795	1029
9526	3795	7961
9526	3795	4562
9526	3795	532
9526	3795	4010
9526	3795	964
9526	3795	554
9526	3795	4481
13650	3796	8574
13650	3796	744
13650	3796	6768
13650	3796	8369
13650	3796	82
13650	3796	6076
13650	3796	9894
8910	3797	635
8910	3797	5131
11367	3798	9794
11367	3798	5231
11367	3798	7756
11367	3798	3504
11367	3798	6513
11367	3798	3819
11367	3798	8208
11367	3798	4063
7912	3799	8411
7912	3799	7456
7912	3799	8776
7912	3799	643
7912	3799	8270
7912	3799	1107
12675	3800	142
12675	3800	482
8599	3801	8200
8599	3801	3206
8599	3801	9554
8599	3801	9177
8599	3801	8066
8599	3801	7009
8599	3801	9219
8599	3801	9542
8599	3801	1282
11018	3802	7491
11018	3802	2937
11018	3802	3783
10635	3803	915
937	3804	8433
937	3804	9489
937	3804	2212
3507	3805	2402
3507	3805	9884
3507	3805	4236
3507	3805	6517
598	3806	5617
598	3806	8088
598	3806	9180
598	3806	7000
598	3806	4623
598	3806	1854
598	3806	874
7934	3807	8343
7934	3807	755
7934	3807	7608
7934	3807	5601
7934	3807	2162
7934	3807	4424
7934	3807	8565
7934	3807	6385
7934	3807	6571
7141	3808	9003
7141	3808	7153
7141	3808	7966
7566	3809	2003
7566	3809	412
12024	3810	6959
12024	3810	9872
12024	3810	8197
12024	3810	2174
12024	3810	1820
12024	3810	8338
12024	3810	3634
1573	3811	757
1573	3811	9516
1573	3811	3245
1573	3811	9472
1573	3811	1128
1573	3811	9668
13252	3812	2148
8644	3813	4915
8644	3813	2895
8644	3813	1662
8644	3813	9335
8644	3813	6395
8644	3813	9938
8644	3813	9827
8644	3813	7428
8644	3813	6838
13011	3814	3132
13011	3814	5526
13011	3814	7654
13011	3814	9601
13011	3814	1761
9310	3815	5317
9310	3815	8497
9310	3815	2487
9310	3815	7621
9310	3815	1616
9310	3815	1612
9310	3815	3604
9310	3815	4959
9310	3815	9679
10409	3816	7938
10409	3816	4749
5413	3817	2325
1642	3818	9255
1642	3818	7743
1642	3818	4048
1642	3818	9323
1642	3818	4460
8277	3819	9343
8277	3819	9246
8277	3819	8707
8277	3819	6979
8277	3819	6701
8277	3819	6735
8277	3819	1001
8277	3819	9847
18201	3820	9970
18201	3820	2204
18201	3820	3080
15507	3821	5887
15507	3821	1679
15507	3821	7425
15507	3821	9126
15507	3821	6574
15507	3821	5736
13474	3822	9117
13474	3822	3798
13474	3822	942
13474	3822	5925
13474	3822	3059
13262	3823	2572
8501	3824	4635
8501	3824	2584
8501	3824	2726
8501	3824	4518
8501	3824	5056
8501	3824	2274
8501	3824	5596
8501	3824	4669
1188	3825	9598
1188	3825	9528
1188	3825	102
1713	3826	9036
1713	3826	3673
1713	3826	2194
1713	3826	9938
1713	3826	3975
1713	3826	4214
1713	3826	9166
7669	3827	4428
7669	3827	5056
9167	3828	6683
9167	3828	6480
9167	3828	6150
9167	3828	4017
9167	3828	7135
9167	3828	6220
387	3829	6442
387	3829	6945
387	3829	5064
387	3829	920
387	3829	9322
387	3829	3517
387	3829	558
14481	3830	273
14481	3830	2461
14481	3830	9245
14481	3830	500
14481	3830	6667
14481	3830	5658
14481	3830	555
14998	3831	790
14998	3831	4517
14998	3831	7754
14998	3831	4954
14998	3831	1929
10405	3832	4626
10405	3832	115
10405	3832	4420
10405	3832	9335
10405	3832	4034
10405	3832	9818
19559	3833	4805
19559	3833	9730
19559	3833	2988
19559	3833	7354
19559	3833	5795
19559	3833	3360
19559	3833	4484
19559	3833	7171
14570	3834	7899
14570	3834	6056
14570	3834	7305
14570	3834	6521
14570	3834	5653
913	3835	9777
913	3835	9559
10707	3836	6699
10707	3836	1495
10707	3836	5
10707	3836	1155
10707	3836	7013
10707	3836	5298
5204	3837	6998
5204	3837	6113
5204	3837	5049
5204	3837	1419
5204	3837	2068
5204	3837	1955
5204	3837	6331
6059	3838	6899
6059	3838	3790
1604	3839	3869
1604	3839	149
1604	3839	5596
1604	3839	7402
1604	3839	6489
1604	3839	9306
1604	3839	7276
18460	3840	7596
18460	3840	8245
18460	3840	7850
18460	3840	6124
18460	3840	3197
603	3841	8392
603	3841	9120
603	3841	3215
603	3841	5696
603	3841	8971
603	3841	7612
12993	3842	1712
12993	3842	8331
12993	3842	9930
12105	3843	4426
12105	3843	8597
12105	3843	6572
12105	3843	6415
12105	3843	976
12105	3843	2212
12105	3843	9333
12105	3843	1672
16091	3844	273
16091	3844	5976
16091	3844	5107
412	3845	8502
412	3845	2865
412	3845	6729
6287	3846	2773
6287	3846	1732
6287	3846	8522
6287	3846	9049
6287	3846	1449
3442	3847	324
3442	3847	736
3442	3847	2952
3442	3847	7711
3442	3847	9076
11610	3848	8948
11610	3848	7697
11610	3848	2478
1999	3849	6950
1999	3849	5361
1999	3849	6001
12649	3850	1432
12649	3850	4062
6274	3851	8942
6274	3851	1333
6274	3851	4870
6274	3851	9610
6274	3851	8457
6274	3851	8347
6274	3851	6306
6274	3851	5568
3135	3852	7892
3135	3852	3101
14324	3853	299
14324	3853	7950
14324	3853	7916
14324	3853	7130
14324	3853	8312
14324	3853	132
14324	3853	173
14324	3853	8056
14324	3853	3774
9745	3854	6605
9745	3854	3218
9745	3854	2406
1744	3855	9057
1744	3855	6406
1744	3855	8805
1744	3855	9757
1744	3855	274
1744	3855	3884
1744	3855	8367
4280	3856	7013
4280	3856	7878
4280	3856	3835
4280	3856	3322
4280	3856	3418
9982	3857	4514
9982	3857	3140
9982	3857	7293
9982	3857	434
9982	3857	2784
9982	3857	8013
9874	3858	6
9874	3858	2570
12808	3859	2644
12808	3859	7428
12808	3859	7388
12808	3859	5923
12808	3859	8538
12808	3859	5219
12808	3859	1959
9485	3860	5893
9485	3860	6346
12701	3861	4234
6426	3862	5610
6426	3862	9415
6426	3862	2849
6426	3862	4898
6426	3862	4400
6426	3862	7217
6426	3862	5769
6426	3862	1101
6426	3862	2022
16733	3863	4717
17902	3864	2164
17902	3864	7292
17902	3864	7770
17902	3864	770
17902	3864	2044
17902	3864	2004
17902	3864	5784
3104	3865	7290
3104	3865	896
3104	3865	221
3104	3865	9257
19747	3866	7506
19747	3866	1492
18523	3867	9879
18523	3867	260
18523	3867	9990
18523	3867	1103
18523	3867	7595
9768	3868	4136
9768	3868	4662
9768	3868	7948
9768	3868	3266
9768	3868	9182
9768	3868	7887
9768	3868	5569
14145	3869	619
14145	3869	1696
14145	3869	2605
14145	3869	3401
14145	3869	3735
14145	3869	5083
14145	3869	7685
14145	3869	9534
14145	3869	2611
11752	3870	6647
11752	3870	9591
11752	3870	8913
11752	3870	9288
11752	3870	9338
11752	3870	1777
11752	3870	516
11752	3870	3832
11752	3870	4580
19326	3871	8881
19326	3871	4041
7555	3872	2696
4572	3873	1811
4572	3873	1752
4572	3873	5422
4572	3873	2183
4572	3873	7909
4572	3873	9853
7725	3874	5557
7725	3874	1294
7725	3874	2524
7725	3874	3375
7725	3874	2820
7725	3874	3904
7725	3874	8356
333	3875	1315
333	3875	2260
333	3875	7007
333	3875	9512
333	3875	2657
333	3875	722
333	3875	762
333	3875	5840
16726	3876	8253
16726	3876	5320
16726	3876	7718
16726	3876	2289
16726	3876	3841
16726	3876	3430
16726	3876	9006
16726	3876	8653
16726	3876	5858
17028	3877	3322
17028	3877	9872
17028	3877	4071
17028	3877	7524
11552	3878	7933
442	3879	8157
442	3879	2987
442	3879	7332
442	3879	3176
442	3879	9803
442	3879	1703
442	3879	9640
442	3879	3074
14289	3880	5669
14289	3880	7484
10832	3881	5637
10832	3881	2393
10832	3881	4835
10832	3881	956
10832	3881	7020
13645	3882	7880
13645	3882	2082
13645	3882	9329
13645	3882	8098
13645	3882	7974
13645	3882	4842
13645	3882	5232
423	3883	3404
423	3883	303
423	3883	7747
423	3883	406
423	3883	5389
423	3883	1588
18935	3884	421
18935	3884	1167
18935	3884	9299
18935	3884	2284
18935	3884	4598
10941	3885	1980
10941	3885	1892
10941	3885	9369
10941	3885	3539
10941	3885	4404
10941	3885	5535
10941	3885	4494
10941	3885	5459
10941	3885	3253
8840	3886	3560
8840	3886	8028
8840	3886	4196
8840	3886	3628
11214	3887	7888
11214	3887	8635
11214	3887	2195
11214	3887	355
11214	3887	9030
11214	3887	6082
11214	3887	4726
11214	3887	367
11214	3887	3755
14629	3888	5472
14629	3888	8809
11827	3889	4909
7087	3890	6581
7087	3890	2959
7087	3890	9224
7087	3890	98
7087	3890	8375
4259	3891	9444
4259	3891	7697
4259	3891	2312
4259	3891	4015
4259	3891	2419
4259	3891	488
7044	3892	8751
7044	3892	9710
7044	3892	3062
7044	3892	750
7044	3892	2882
12291	3893	2612
12291	3893	5524
12291	3893	5612
12291	3893	6815
12291	3893	7710
12291	3893	8347
12291	3893	6561
12291	3893	1719
939	3894	2179
939	3894	3639
939	3894	1104
939	3894	2052
939	3894	2666
10555	3895	5586
10555	3895	6939
10555	3895	9240
10555	3895	1633
10555	3895	2845
10555	3895	7248
10555	3895	5624
10555	3895	5033
10555	3895	6950
1177	3896	7109
1177	3896	4279
1177	3896	5495
1177	3896	5052
1177	3896	6960
1177	3896	9110
1177	3896	3037
1177	3896	8546
1177	3896	5936
6366	3897	5427
6366	3897	8991
6366	3897	8197
6366	3897	2964
6366	3897	6992
6366	3897	525
6366	3897	9846
6366	3897	9128
12174	3898	9986
12174	3898	2975
12174	3898	3240
12174	3898	9922
12174	3898	2092
15036	3899	9894
15036	3899	1015
15036	3899	3391
15036	3899	2929
5549	3900	7671
5549	3900	4491
5549	3900	75
5549	3900	1775
5549	3900	3007
5549	3900	1958
5549	3900	1114
5549	3900	8803
11327	3901	720
11327	3901	4318
14493	3902	21
14493	3902	5974
14493	3902	3409
14493	3902	896
14493	3902	4939
14493	3902	6532
14493	3902	7683
17593	3903	4496
17593	3903	5339
17593	3903	5568
17593	3903	4059
17593	3903	169
17593	3903	7132
17593	3903	9925
17593	3903	6153
17593	3903	4843
11477	3904	8408
11477	3904	9246
237	3905	9794
10264	3906	1190
2716	3907	9552
2716	3907	4445
2716	3907	5386
2716	3907	5266
2716	3907	5027
2716	3907	3049
2716	3907	7886
11902	3908	6555
11902	3908	3792
11902	3908	7338
11902	3908	1542
3408	3909	8997
3408	3909	3203
3408	3909	5141
3408	3909	2730
15512	3910	1190
15512	3910	5680
15512	3910	2554
15512	3910	5125
17832	3911	5859
17832	3911	6163
17832	3911	3618
17832	3911	3726
17832	3911	5485
17832	3911	6057
17832	3911	5518
11707	3912	9239
11707	3912	6351
11707	3912	8446
11707	3912	3009
11707	3912	8012
11707	3912	2486
11707	3912	942
11707	3912	299
11707	3912	8354
4159	3913	9008
4159	3913	9262
4159	3913	1374
4159	3913	379
4159	3913	42
4159	3913	5647
4159	3913	4534
4159	3913	5297
6617	3914	1693
3981	3915	5907
3981	3915	8923
3981	3915	683
3981	3915	5024
3981	3915	2456
3981	3915	237
3981	3915	4312
19918	3916	4051
19918	3916	4526
19918	3916	5275
19918	3916	1860
19918	3916	7166
19918	3916	8958
19918	3916	7194
12234	3917	4047
12234	3917	8736
12234	3917	8722
12234	3917	9336
12234	3917	9251
12234	3917	2992
12234	3917	8768
12234	3917	7887
6323	3918	128
18170	3919	3949
18170	3919	4276
18170	3919	8796
18170	3919	3574
18170	3919	4825
18170	3919	6503
18170	3919	5328
18170	3919	5945
9425	3920	8006
9425	3920	2721
9425	3920	4732
9425	3920	2510
9425	3920	1933
9425	3920	3856
9425	3920	4409
9425	3920	7131
9425	3920	6455
2558	3921	5439
2558	3921	2989
2558	3921	6643
2558	3921	6095
2558	3921	4220
2558	3921	6121
2558	3921	775
6568	3922	7689
6568	3922	7602
9464	3923	5435
9464	3923	6269
9464	3923	3272
9464	3923	6757
9464	3923	3090
18368	3924	3285
18368	3924	2081
18368	3924	2375
18368	3924	7343
18368	3924	3590
2383	3925	5924
2383	3925	2855
2383	3925	8465
2383	3925	9790
2383	3925	831
2383	3925	7997
2383	3925	9945
2383	3925	3104
12776	3926	447
12776	3926	8008
12776	3926	8169
12776	3926	2821
12776	3926	2789
12776	3926	5361
16432	3927	7339
16339	3928	2089
10385	3929	1581
10385	3929	9691
10385	3929	7814
10385	3929	9817
5275	3930	2588
5275	3930	796
1732	3931	726
1732	3931	2564
1732	3931	8968
1732	3931	3482
10360	3932	3749
10360	3932	3452
6537	3933	5906
6537	3933	783
6537	3933	9865
6537	3933	3460
6537	3933	2445
6537	3933	1315
6537	3933	7661
6537	3933	301
7564	3934	8962
7564	3934	9800
7564	3934	8808
7564	3934	4273
7564	3934	6520
7564	3934	6909
7564	3934	2842
7564	3934	919
8756	3935	3648
8756	3935	4885
10370	3936	8967
10370	3936	1723
10370	3936	129
10370	3936	639
9821	3937	6728
9821	3937	3720
9277	3938	9016
5327	3939	3972
5327	3939	2800
5327	3939	1003
5327	3939	4934
5327	3939	9695
5327	3939	4248
5327	3939	3999
2289	3940	5199
2289	3940	1539
7625	3941	5711
7625	3941	354
7625	3941	8306
7625	3941	6204
7625	3941	6233
7625	3941	2872
7625	3941	9932
8359	3942	3202
7036	3943	7554
7036	3943	3514
7036	3943	5462
7036	3943	3919
7036	3943	2164
7036	3943	9722
11851	3944	3132
11851	3944	5996
11851	3944	7011
11851	3944	7243
11851	3944	2451
7643	3945	391
7643	3945	9809
7643	3945	7745
7643	3945	5378
7643	3945	6443
7643	3945	5935
7643	3945	8011
7643	3945	2090
10443	3946	8285
10443	3946	7579
10443	3946	950
10443	3946	5973
10443	3946	3851
8483	3947	8146
8483	3947	2236
8483	3947	858
8483	3947	1065
8483	3947	4844
8483	3947	1324
8483	3947	8661
5382	3948	3732
9363	3949	3680
9363	3949	1874
6648	3950	2519
6648	3950	3408
6648	3950	8718
6648	3950	168
6648	3950	3548
6648	3950	494
6648	3950	2175
6648	3950	4899
6648	3950	3087
18106	3951	992
18106	3951	2975
18106	3951	7828
18106	3951	6188
18106	3951	4598
16010	3952	2477
16010	3952	7946
16010	3952	3740
16010	3952	8233
6262	3953	1761
6262	3953	3225
6262	3953	1436
6262	3953	2063
19780	3954	5520
19780	3954	1975
19780	3954	1726
8405	3955	227
8405	3955	1957
8405	3955	5959
8405	3955	1590
6702	3956	8423
972	3957	376
972	3957	5003
13953	3958	1032
13953	3958	659
13953	3958	6173
13953	3958	7382
13953	3958	9345
13953	3958	1172
16771	3959	8824
16771	3959	6948
16771	3959	3193
16771	3959	5212
16771	3959	9847
16771	3959	9465
16771	3959	7190
16771	3959	1035
16771	3959	9202
10750	3960	3505
10750	3960	6280
10750	3960	2856
14280	3961	9848
14280	3961	5363
1148	3962	788
1148	3962	9383
1148	3962	2620
1148	3962	6199
1148	3962	2110
9375	3963	6609
18929	3964	6605
18929	3964	321
18929	3964	5981
18929	3964	9492
18929	3964	6257
18929	3964	5743
18929	3964	2174
18929	3964	5022
2441	3965	2978
2441	3965	2339
2441	3965	4511
2441	3965	8652
2441	3965	8412
2441	3965	8323
2441	3965	9192
10343	3966	6110
3705	3967	6978
3705	3967	4026
3705	3967	3869
3705	3967	172
3705	3967	4450
3705	3967	4521
3705	3967	1457
3705	3967	8847
3705	3967	2506
3393	3968	6868
3393	3968	7311
3393	3968	722
3393	3968	4830
3393	3968	3602
3393	3968	998
9733	3969	1713
9733	3969	7009
9733	3969	1676
9733	3969	9404
9733	3969	8334
6436	3970	9570
6436	3970	3642
6436	3970	3451
6436	3970	1250
9703	3971	2479
9703	3971	8577
9703	3971	8914
9703	3971	3461
10272	3972	5658
10272	3972	7835
10272	3972	5938
10272	3972	6852
10272	3972	1913
10272	3972	2388
7274	3973	8489
7274	3973	1280
7274	3973	8145
7274	3973	1712
7274	3973	145
7274	3973	2980
7274	3973	308
11931	3974	9314
12331	3975	6659
12331	3975	9141
12331	3975	7555
12331	3975	9086
731	3976	222
731	3976	1716
731	3976	3892
731	3976	7032
731	3976	2062
4295	3977	8171
4295	3977	5644
4295	3977	5689
4295	3977	3619
4295	3977	3819
4295	3977	7612
4295	3977	7216
4295	3977	3270
4295	3977	8783
996	3978	5194
996	3978	1038
996	3978	512
996	3978	9402
996	3978	681
996	3978	2471
996	3978	7273
1783	3979	2065
1783	3979	5350
1783	3979	4725
7015	3980	4005
7015	3980	3289
7015	3980	6858
7015	3980	6453
7015	3980	5528
7015	3980	7929
798	3981	8559
3095	3982	2148
3095	3982	2936
3095	3982	7574
3095	3982	380
8769	3983	3583
8769	3983	507
8769	3983	9880
8769	3983	5890
8769	3983	2242
8769	3983	8207
13531	3984	8313
13531	3984	5261
16393	3985	4637
16393	3985	5749
16393	3985	2096
16393	3985	3710
16393	3985	3913
16393	3985	5714
3206	3986	919
3206	3986	7265
3206	3986	6573
9771	3987	5345
9771	3987	5996
9771	3987	7285
9771	3987	389
9771	3987	8162
9771	3987	4435
9771	3987	8162
9771	3987	6086
12671	3988	8827
12671	3988	3548
12671	3988	7330
12671	3988	9286
4035	3989	3239
1047	3990	3557
1047	3990	5900
1047	3990	4329
1047	3990	6339
16957	3991	2219
16957	3991	9810
16957	3991	1666
16957	3991	5888
1786	3992	1244
1786	3992	8339
1786	3992	6732
1786	3992	7687
1786	3992	5094
18843	3993	9836
18843	3993	3097
18843	3993	8997
18843	3993	2161
18843	3993	1082
13937	3994	7861
13937	3994	7625
13937	3994	3956
1374	3995	975
18508	3996	3872
18508	3996	7877
18508	3996	9534
3390	3997	5522
3390	3997	332
3390	3997	4574
3390	3997	8047
4005	3998	2689
7327	3999	2917
7327	3999	8673
7327	3999	6514
7327	3999	3756
7327	3999	3423
7327	3999	7742
6527	4000	3563
6527	4000	7925
6527	4000	7497
6527	4000	3612
6527	4000	5893
6527	4000	2419
6527	4000	9965
6527	4000	4004
6527	4000	6435
14005	4001	306
14005	4001	4226
14005	4001	7657
14005	4001	3611
14005	4001	1378
14005	4001	4489
14005	4001	6552
12910	4002	1755
12910	4002	1662
7707	4003	9977
7707	4003	9950
7707	4003	7019
2489	4004	3803
2489	4004	9037
2489	4004	9028
2489	4004	434
2489	4004	7482
2489	4004	2034
7577	4005	3961
35	4006	9694
35	4006	3643
35	4006	5174
35	4006	7956
35	4006	8746
15563	4007	1306
15563	4007	1307
15563	4007	5627
15563	4007	2299
15563	4007	7128
15563	4007	6109
2069	4008	5936
2069	4008	7301
2069	4008	7511
10934	4009	7225
8326	4010	1535
8326	4010	8565
8326	4010	3678
8326	4010	2198
8326	4010	6255
8326	4010	1894
8326	4010	9341
8326	4010	6050
8326	4010	3798
2617	4011	6775
2617	4011	7488
2617	4011	5734
2617	4011	8163
2617	4011	5735
2617	4011	5105
2617	4011	6858
18110	4012	7362
18110	4012	5083
2264	4013	4483
2264	4013	9587
2264	4013	3633
2264	4013	2735
2264	4013	361
2264	4013	7079
2264	4013	3235
2264	4013	8220
10154	4014	4132
10154	4014	3688
10154	4014	8190
5341	4015	948
1069	4016	6895
14511	4017	5779
14511	4017	1654
14511	4017	7465
14511	4017	9074
14511	4017	1038
14511	4017	1294
14511	4017	4699
14511	4017	3494
6791	4018	7779
6791	4018	3636
6791	4018	719
4961	4019	1322
4961	4019	4911
4961	4019	7562
4961	4019	1741
4961	4019	6960
4961	4019	9841
9078	4020	7433
1001	4021	578
1001	4021	4637
9057	4022	313
9057	4022	8508
9057	4022	8072
9057	4022	7597
9057	4022	2704
5087	4023	7083
9029	4024	5015
9029	4024	7647
9029	4024	57
9029	4024	6888
9029	4024	6812
14248	4025	2347
19887	4026	4500
19887	4026	1980
19887	4026	6324
19887	4026	7857
19887	4026	3576
19887	4026	2888
19887	4026	1724
19887	4026	4183
19887	4026	2818
19260	4027	6754
19260	4027	1818
17101	4028	7987
17101	4028	1198
17101	4028	853
17101	4028	9028
17101	4028	4933
15641	4029	8355
15641	4029	508
15641	4029	6447
15641	4029	803
15641	4029	654
15641	4029	5671
15641	4029	6656
15641	4029	1022
18016	4030	8974
18016	4030	679
18016	4030	8804
11614	4031	4535
11614	4031	7175
7243	4032	1801
7243	4032	1316
7243	4032	7669
7243	4032	4464
12846	4033	9580
12846	4033	3006
12846	4033	4672
10551	4034	7074
10551	4034	1084
10551	4034	7191
10551	4034	7870
10551	4034	7801
10551	4034	6931
10551	4034	7141
10551	4034	7088
10551	4034	3289
1972	4035	7657
1972	4035	7864
1972	4035	8484
1972	4035	7603
1972	4035	3030
1972	4035	8249
1972	4035	8924
13586	4036	6463
13586	4036	5069
13586	4036	8704
13586	4036	5208
13586	4036	2914
13586	4036	2978
1268	4037	2962
1268	4037	2436
1268	4037	7840
1268	4037	5240
1268	4037	9578
1268	4037	1528
1268	4037	957
1268	4037	3684
17505	4038	909
17505	4038	3500
12954	4039	7111
143	4040	636
143	4040	6908
12971	4041	4216
15798	4042	6651
15798	4042	3869
15798	4042	5664
10254	4043	5431
10254	4043	5448
1699	4044	4091
1699	4044	7537
15150	4045	8570
15150	4045	1387
15150	4045	6195
15150	4045	6418
4162	4046	7208
4162	4046	8764
4162	4046	2231
4162	4046	7075
4162	4046	5060
4162	4046	4919
4162	4046	5744
10033	4047	8505
10033	4047	681
10033	4047	5582
10033	4047	7930
10033	4047	6938
10033	4047	4080
10033	4047	504
18535	4048	3478
18535	4048	1130
18535	4048	3955
18535	4048	7689
18535	4048	8503
18535	4048	4714
18535	4048	7107
18535	4048	7132
5426	4049	4712
17583	4050	79
17583	4050	4337
17583	4050	9483
17583	4050	5002
17583	4050	6353
8081	4051	4300
8081	4051	3694
8081	4051	6587
8081	4051	9194
8081	4051	3538
16498	4052	7041
16498	4052	372
16498	4052	3029
16498	4052	1122
16498	4052	2523
17750	4053	2916
17750	4053	4944
17750	4053	7101
17750	4053	8621
17750	4053	9462
17750	4053	3384
17750	4053	1669
17750	4053	1248
17750	4053	9421
19585	4054	4501
19585	4054	4081
14407	4055	6986
14407	4055	1463
14407	4055	6028
14407	4055	565
14407	4055	2251
14407	4055	2463
14407	4055	3025
8543	4056	2559
8543	4056	8966
8543	4056	1364
8543	4056	4493
8543	4056	489
8543	4056	2648
8543	4056	4873
8543	4056	5200
8543	4056	1561
4251	4057	2152
4251	4057	2783
4251	4057	2471
4251	4057	9447
4251	4057	1708
4251	4057	3517
4251	4057	9971
8926	4058	1606
8926	4058	1015
8926	4058	2603
8926	4058	2814
8926	4058	7442
6638	4059	1658
6638	4059	3616
6638	4059	179
6638	4059	7852
6638	4059	5068
6638	4059	2560
6638	4059	6248
6638	4059	9502
2214	4060	7586
2214	4060	8554
2214	4060	6308
5193	4061	1037
5193	4061	619
5193	4061	5101
5903	4062	4320
5903	4062	7821
5903	4062	1942
6534	4063	5607
6534	4063	8823
6534	4063	6414
6534	4063	156
6534	4063	7727
6534	4063	7500
6534	4063	442
11084	4064	8494
11084	4064	3913
3467	4065	9056
3467	4065	2049
3467	4065	7194
3467	4065	3498
3467	4065	1816
3467	4065	1146
3467	4065	4437
3467	4065	1441
3764	4066	7424
11834	4067	8730
11834	4067	7826
11834	4067	6188
11834	4067	2624
11834	4067	4365
11834	4067	5893
15415	4068	9678
15415	4068	5850
15415	4068	4147
15415	4068	3000
15415	4068	4534
15415	4068	3167
15415	4068	6340
10138	4069	7177
19600	4070	9617
19600	4070	9738
15023	4071	9722
15023	4071	9958
15023	4071	1760
15023	4071	8067
15023	4071	3380
15023	4071	3006
15023	4071	4965
15023	4071	4788
3929	4072	1765
3929	4072	5829
3929	4072	444
3929	4072	6830
18512	4073	7532
18512	4073	6666
18512	4073	1358
9474	4074	4456
9474	4074	4401
9474	4074	7034
9474	4074	1208
9474	4074	4795
9474	4074	9450
9474	4074	4353
9474	4074	6189
18531	4075	2064
18531	4075	6344
18531	4075	7260
18531	4075	3463
18531	4075	2439
18531	4075	1432
18531	4075	360
18531	4075	6138
14690	4076	317
14690	4076	2091
16557	4077	7544
16557	4077	4636
16557	4077	4258
16557	4077	8337
16557	4077	8681
16557	4077	4360
16557	4077	1227
3174	4078	8980
3174	4078	1494
3174	4078	9763
3174	4078	4136
2662	4079	8025
2662	4079	8620
2662	4079	7282
11236	4080	7416
11236	4080	3439
11236	4080	4545
12333	4081	4462
12333	4081	6043
12333	4081	8905
12333	4081	6077
12333	4081	1509
12333	4081	7715
12333	4081	3883
12333	4081	2194
12333	4081	9212
7213	4082	2360
7213	4082	2841
7213	4082	3042
7213	4082	3071
15065	4083	1757
15065	4083	8500
15065	4083	23
15065	4083	4041
15065	4083	9542
15065	4083	4072
15065	4083	9088
15065	4083	7567
11439	4084	7310
11439	4084	6154
11439	4084	5977
11439	4084	8992
11439	4084	6757
11439	4084	6578
11439	4084	9365
11439	4084	6346
11439	4084	5086
9253	4085	6361
9253	4085	4479
2736	4086	617
2736	4086	6239
2736	4086	7308
12600	4087	1026
12600	4087	1265
12600	4087	2127
14424	4088	1839
14424	4088	8098
14424	4088	3702
14424	4088	2127
14424	4088	3944
14424	4088	298
14424	4088	8731
12078	4089	2339
12078	4089	77
12078	4089	6272
12078	4089	3755
12078	4089	8951
12078	4089	5610
12078	4089	435
17064	4090	1108
17064	4090	3918
17064	4090	9547
17064	4090	9612
17064	4090	752
17064	4090	4317
17064	4090	8269
16691	4091	9687
16691	4091	3396
16691	4091	7307
16691	4091	5583
16691	4091	6452
4197	4092	9872
4197	4092	2433
4197	4092	3919
4197	4092	7697
4197	4092	2987
4197	4092	4174
4197	4092	8668
17374	4093	2462
17374	4093	7923
17374	4093	296
17374	4093	7509
17374	4093	2339
17374	4093	8846
17374	4093	1163
17374	4093	7827
17374	4093	8136
11664	4094	7845
11664	4094	9879
11664	4094	3489
11664	4094	5200
11664	4094	8764
11664	4094	2677
11664	4094	7428
11664	4094	191
5058	4095	652
5058	4095	7284
5058	4095	3475
5058	4095	224
5058	4095	1251
5058	4095	7738
5058	4095	7230
5058	4095	5608
1613	4096	8467
1613	4096	2544
1613	4096	7753
1613	4096	831
1613	4096	5263
1613	4096	6039
6644	4097	8741
6644	4097	2017
6644	4097	1257
16974	4098	9206
16974	4098	5501
16974	4098	321
16974	4098	6091
16974	4098	9861
1384	4099	241
19339	4100	2573
19339	4100	5783
14079	4101	5526
14079	4101	3191
14079	4101	6175
14079	4101	6041
14079	4101	2658
14079	4101	9360
14079	4101	5975
14079	4101	3211
6901	4102	3120
6901	4102	3756
6901	4102	4739
8297	4103	2645
8297	4103	6336
8297	4103	6836
8297	4103	4526
8297	4103	9006
16730	4104	3322
18274	4105	1727
18274	4105	8238
18274	4105	5175
10912	4106	80
10912	4106	3702
1074	4107	3413
16840	4108	9402
16840	4108	9927
16840	4108	8752
16840	4108	589
16840	4108	5773
16840	4108	5961
16840	4108	1802
17851	4109	8694
17851	4109	2897
17851	4109	6817
17851	4109	4425
17851	4109	9751
17851	4109	8649
16100	4110	5723
16100	4110	4968
16100	4110	4890
16100	4110	5136
16100	4110	1688
16100	4110	1831
16100	4110	5862
16100	4110	4573
14939	4111	9291
14939	4111	7735
14939	4111	5012
14939	4111	5085
14939	4111	4434
14939	4111	2440
14939	4111	5157
92	4112	897
92	4112	8538
8799	4113	8955
8799	4113	9967
8799	4113	5329
6127	4114	9447
6127	4114	9855
6127	4114	4127
6127	4114	4035
6127	4114	9703
6127	4114	9330
451	4115	2952
174	4116	7911
174	4116	1798
174	4116	7331
174	4116	6303
11499	4117	9629
11499	4117	1121
11499	4117	2421
11499	4117	4163
11499	4117	8673
11499	4117	1975
11499	4117	6903
11499	4117	1966
146	4118	8146
146	4118	6164
146	4118	611
19164	4119	8408
19058	4120	352
19058	4120	7421
19058	4120	1934
19058	4120	5382
19058	4120	4321
19058	4120	778
13424	4121	4444
13424	4121	1042
13424	4121	887
13424	4121	4636
13424	4121	2260
13424	4121	6946
16906	4122	4123
16906	4122	1949
16906	4122	7998
4636	4123	1651
4636	4123	2383
4636	4123	7662
4636	4123	2328
4636	4123	1881
4636	4123	849
6218	4124	8620
6218	4124	7716
6218	4124	5056
6218	4124	8405
6218	4124	7895
6218	4124	4333
6218	4124	8720
6218	4124	8460
6218	4124	1105
17532	4125	7469
17532	4125	9821
17532	4125	6065
17532	4125	1426
17532	4125	1400
17532	4125	7755
5620	4126	9813
5620	4126	4654
5620	4126	1636
5620	4126	3155
5620	4126	3744
5620	4126	937
5620	4126	3025
5620	4126	4628
8896	4127	6585
8896	4127	9841
8896	4127	281
8896	4127	7100
16106	4128	6901
17072	4129	8631
17072	4129	1776
17072	4129	8172
17072	4129	8172
17072	4129	5293
17072	4129	7247
17072	4129	542
764	4130	7977
764	4130	4746
764	4130	6969
764	4130	8598
764	4130	6159
5130	4131	2715
1772	4132	3685
1772	4132	5096
1772	4132	6448
1772	4132	4763
1772	4132	6019
1772	4132	5403
1772	4132	5494
1772	4132	2376
1948	4133	3934
1948	4133	1996
1948	4133	9768
1948	4133	6664
1948	4133	5596
1948	4133	9141
1948	4133	6062
1948	4133	211
1948	4133	9874
11784	4134	9888
11784	4134	8843
11784	4134	9507
11784	4134	3237
11784	4134	1547
11784	4134	4571
11784	4134	1582
11784	4134	8252
7695	4135	3127
7695	4135	8084
7695	4135	532
7695	4135	8310
19721	4136	6905
19721	4136	5999
19721	4136	3479
19721	4136	2248
13637	4137	1157
13637	4137	6233
13637	4137	666
13637	4137	9711
13637	4137	6217
13637	4137	7130
13637	4137	5751
13637	4137	573
6185	4138	4455
6185	4138	8616
1726	4139	7681
1726	4139	2959
1726	4139	8343
1726	4139	4702
1726	4139	7385
7203	4140	350
7203	4140	5369
7203	4140	7556
7203	4140	4016
7203	4140	2873
7203	4140	222
7203	4140	6403
7203	4140	2351
7203	4140	3760
13437	4141	5909
13437	4141	8234
13437	4141	7983
13437	4141	6895
13437	4141	964
13437	4141	8146
13437	4141	8167
13437	4141	7001
13437	4141	6591
13623	4142	5600
13623	4142	6415
13623	4142	3743
13623	4142	6078
13623	4142	6525
13623	4142	6181
13623	4142	5280
4349	4143	9419
4349	4143	3088
4349	4143	8198
4349	4143	9767
4349	4143	9962
4349	4143	1600
4349	4143	7474
7776	4144	1187
7776	4144	1387
7776	4144	4623
7776	4144	2471
7776	4144	1730
7776	4144	2076
7776	4144	5019
7776	4144	8579
13553	4145	1564
13553	4145	9265
13553	4145	9479
13553	4145	362
13553	4145	626
13553	4145	3288
13553	4145	9556
13553	4145	9525
3989	4146	257
3989	4146	52
3989	4146	7650
3989	4146	3381
3150	4147	9731
3150	4147	134
3150	4147	1578
3150	4147	3721
3150	4147	7415
3150	4147	4016
3150	4147	1682
7845	4148	7893
7845	4148	1381
7845	4148	1066
7845	4148	6575
7845	4148	5759
2667	4149	6173
2667	4149	4960
2667	4149	9579
2667	4149	9954
2667	4149	5688
2667	4149	3963
10219	4150	335
10219	4150	8833
10219	4150	7128
7404	4151	5683
7404	4151	7837
7404	4151	6116
7404	4151	3717
7404	4151	1760
7404	4151	9755
10886	4152	2812
10886	4152	9360
10886	4152	6231
10886	4152	3287
828	4153	4116
828	4153	8659
12990	4154	504
12990	4154	6859
12990	4154	1442
12990	4154	3976
12990	4154	2056
12990	4154	5980
10678	4155	5034
10678	4155	4137
10678	4155	2670
10678	4155	8599
10678	4155	8400
10678	4155	6583
10678	4155	3753
10678	4155	3851
10678	4155	9160
1203	4156	2331
16619	4157	3649
16619	4157	2068
16619	4157	5470
16278	4158	4924
16278	4158	983
16278	4158	1767
16278	4158	2520
3360	4159	2282
3360	4159	6004
3360	4159	3024
3360	4159	2921
3360	4159	9147
2428	4160	7418
2428	4160	4089
2428	4160	4103
2428	4160	6418
2428	4160	519
2428	4160	9819
17619	4161	4319
644	4162	6475
644	4162	4064
644	4162	1102
644	4162	6834
644	4162	494
644	4162	6731
644	4162	6970
6773	4163	1571
6773	4163	7152
6773	4163	4546
6773	4163	5498
18540	4164	6066
258	4165	4673
258	4165	2468
258	4165	2365
258	4165	9749
258	4165	31
258	4165	2721
8582	4166	9663
8582	4166	6479
8582	4166	5093
8582	4166	4430
8582	4166	5831
1689	4167	6960
1689	4167	9330
3389	4168	1029
7498	4169	8040
15404	4170	2862
15404	4170	7443
6546	4171	4117
6546	4171	3038
4734	4172	4062
4734	4172	4380
4734	4172	7785
4734	4172	8839
13756	4173	4580
13756	4173	6651
13756	4173	8797
13756	4173	4731
13756	4173	7365
2964	4174	2558
2964	4174	7907
2964	4174	8802
2964	4174	2191
2964	4174	7057
11791	4175	2773
14705	4176	4793
14705	4176	5353
5436	4177	4200
5436	4177	9745
5436	4177	7598
5436	4177	9819
4018	4178	1984
4018	4178	2571
4018	4178	749
4018	4178	5384
4018	4178	2696
4018	4178	6620
4018	4178	8633
671	4179	4541
671	4179	2016
671	4179	5647
671	4179	1936
671	4179	6013
671	4179	7475
671	4179	8229
671	4179	6287
671	4179	3805
18376	4180	6798
18376	4180	6325
18376	4180	985
18376	4180	5766
18376	4180	2385
18376	4180	4565
18376	4180	4591
18376	4180	4014
53	4181	5619
53	4181	2609
53	4181	7107
6496	4182	2085
6496	4182	346
2662	4183	7006
2662	4183	3900
2662	4183	8529
2662	4183	1782
14917	4184	609
14917	4184	9404
14917	4184	93
18065	4185	366
18065	4185	7629
18065	4185	252
18065	4185	2043
18065	4185	9051
5901	4186	1441
5901	4186	7193
5901	4186	9859
5901	4186	9552
5901	4186	7948
16079	4187	7072
16079	4187	8546
16079	4187	7067
14635	4188	9313
10870	4189	86
10870	4189	2260
10870	4189	1529
10870	4189	7039
10870	4189	2587
10870	4189	36
10870	4189	3025
10870	4189	9586
10870	4189	725
15581	4190	5108
15581	4190	5875
15581	4190	6620
15581	4190	9855
15581	4190	4974
15581	4190	5324
13704	4191	7932
13704	4191	9242
13704	4191	8210
13704	4191	3469
8385	4192	1983
8385	4192	5581
8385	4192	6169
8385	4192	1511
8385	4192	6570
8385	4192	3040
8385	4192	1306
8385	4192	8778
8385	4192	5215
6294	4193	1114
6294	4193	4288
13303	4194	6549
13303	4194	2231
16799	4195	1188
16799	4195	724
16799	4195	1697
16799	4195	2590
16799	4195	552
16799	4195	8603
16799	4195	951
16799	4195	5352
16799	4195	6948
6041	4196	5019
6041	4196	6178
6041	4196	4968
6041	4196	5649
6041	4196	3383
8212	4197	6135
13371	4198	16
13371	4198	8147
13371	4198	4472
13371	4198	5008
13371	4198	8115
13371	4198	6539
13371	4198	4138
13371	4198	383
13371	4198	6741
247	4199	4230
247	4199	6760
247	4199	7582
247	4199	7049
247	4199	7108
247	4199	1445
11831	4200	7034
11831	4200	8739
11831	4200	1595
11831	4200	6287
11831	4200	1983
11831	4200	8009
11831	4200	3151
14759	4201	7743
14759	4201	389
14759	4201	1423
5734	4202	8783
5734	4202	1729
5734	4202	1558
5734	4202	9387
11346	4203	8700
11346	4203	4965
11346	4203	4013
11346	4203	9230
11346	4203	3720
8218	4204	1605
8218	4204	5492
8218	4204	7908
19273	4205	104
19273	4205	2162
19273	4205	5148
19273	4205	8774
19273	4205	429
19273	4205	5697
19273	4205	4701
19273	4205	3259
19273	4205	1899
7325	4206	7282
7325	4206	8488
7325	4206	6850
7325	4206	4826
9859	4207	8377
9859	4207	4399
9859	4207	5407
9859	4207	888
9859	4207	9269
9859	4207	6030
9859	4207	4009
13077	4208	673
13077	4208	6648
13077	4208	4063
13077	4208	5099
92	4209	7154
92	4209	8407
92	4209	9344
92	4209	6380
92	4209	4917
92	4209	5820
92	4209	8174
10322	4210	9233
11760	4211	9377
11760	4211	2290
11760	4211	1344
11760	4211	6658
10128	4212	8877
10128	4212	7877
10128	4212	2076
10128	4212	4739
10128	4212	3525
10128	4212	5411
10128	4212	4079
6836	4213	6819
6836	4213	4428
6836	4213	9710
12734	4214	1431
12734	4214	1162
12734	4214	745
12734	4214	4099
17675	4215	2451
17675	4215	6151
17675	4215	3123
17675	4215	9948
17675	4215	6213
17675	4215	3543
6503	4216	9618
2096	4217	1355
2096	4217	4807
2096	4217	8561
2096	4217	4291
2096	4217	3800
2096	4217	111
6466	4218	6877
6466	4218	9985
6466	4218	9885
12591	4219	6975
12591	4219	4336
12591	4219	7324
4260	4220	9671
4260	4220	7902
4260	4220	2176
4260	4220	3420
4260	4220	1246
4260	4220	8665
17297	4221	4507
17297	4221	1876
17297	4221	5498
17297	4221	3011
17297	4221	820
17297	4221	5523
13331	4222	2100
13331	4222	5604
18047	4223	5476
18047	4223	82
17244	4224	833
17244	4224	2996
12012	4225	6340
12012	4225	6825
12012	4225	8351
12012	4225	938
12012	4225	4329
12012	4225	4725
12012	4225	5566
12012	4225	7004
14170	4226	5707
14170	4226	1405
14170	4226	7589
14170	4226	2869
14170	4226	406
14170	4226	3360
14170	4226	716
14170	4226	5550
14170	4226	1810
12277	4227	1182
12277	4227	8685
12277	4227	9634
12277	4227	5270
1952	4228	7515
1952	4228	7183
1952	4228	3460
13638	4229	7003
17626	4230	4952
17626	4230	2952
17626	4230	7992
17626	4230	4318
17626	4230	3151
17626	4230	9471
17626	4230	563
17626	4230	7312
8989	4231	2083
8989	4231	8952
11910	4232	4768
11910	4232	5914
11910	4232	2065
11910	4232	5852
11910	4232	502
11910	4232	7682
11910	4232	9756
638	4233	8397
638	4233	9988
638	4233	8237
638	4233	4733
638	4233	8486
9566	4234	7450
9566	4234	7629
9566	4234	4718
9566	4234	9571
9566	4234	3649
9566	4234	8872
9566	4234	4405
9566	4234	3724
4240	4235	8978
4240	4235	4606
4240	4235	3362
13010	4236	4415
13010	4236	2239
13010	4236	4838
13010	4236	5524
13010	4236	2176
13010	4236	1661
12129	4237	7899
12129	4237	8420
12129	4237	3183
12129	4237	2009
12129	4237	1107
12129	4237	878
17503	4238	4075
17503	4238	8334
17503	4238	3135
17503	4238	3321
17503	4238	3029
17503	4238	6357
8914	4239	5104
8914	4239	4780
8914	4239	7721
8914	4239	6074
8914	4239	2160
8914	4239	6381
8914	4239	5703
8914	4239	325
8914	4239	6500
19268	4240	4944
19268	4240	6992
16075	4241	6982
16075	4241	3378
16075	4241	9147
10440	4242	2171
15747	4243	7651
15747	4243	3726
15747	4243	2760
15747	4243	8350
15747	4243	1785
5868	4244	5988
5868	4244	5620
5868	4244	2122
5868	4244	463
5868	4244	9985
4311	4245	29
4311	4245	1189
4311	4245	6445
4311	4245	4019
4311	4245	1156
4311	4245	6907
11818	4246	668
12574	4247	1052
12574	4247	4240
12574	4247	2076
12574	4247	3192
6441	4248	900
6441	4248	7843
6441	4248	7737
9287	4249	552
9287	4249	6084
9287	4249	9673
9287	4249	7507
9287	4249	1101
10682	4250	960
10682	4250	3432
10682	4250	6007
10682	4250	5627
10682	4250	4053
3580	4251	6433
3580	4251	4104
3580	4251	2216
3580	4251	8205
3580	4251	7719
3580	4251	2787
3580	4251	4269
3580	4251	4160
3580	4251	35
6932	4252	8986
6932	4252	9563
6932	4252	6913
18760	4253	3785
18760	4253	8246
12901	4254	2161
12901	4254	1321
12901	4254	6048
12166	4255	9549
12166	4255	9598
12166	4255	1861
12166	4255	1573
12166	4255	545
12166	4255	8154
12166	4255	7661
11814	4256	2357
9035	4257	947
9035	4257	9723
9035	4257	8632
9035	4257	8180
15555	4258	6937
14963	4259	8520
14963	4259	9463
14963	4259	8254
14963	4259	4575
14963	4259	3226
14963	4259	5128
14963	4259	1738
2920	4260	1782
1039	4261	1118
1039	4261	4086
1039	4261	7688
1039	4261	8016
1039	4261	1119
1039	4261	364
9876	4262	2434
9876	4262	7830
9876	4262	1184
9876	4262	5631
9876	4262	1013
9876	4262	3989
9876	4262	7931
9876	4262	5899
19969	4263	8757
19969	4263	1360
19969	4263	5032
19969	4263	9246
19969	4263	6661
18189	4264	3265
18189	4264	5948
18189	4264	4016
18189	4264	6307
18189	4264	7059
18189	4264	5262
5452	4265	7878
5452	4265	379
5452	4265	1572
1635	4266	45
1635	4266	6716
1635	4266	9175
1635	4266	9901
1635	4266	8877
1635	4266	2082
1635	4266	1920
14362	4267	9907
14362	4267	5532
14362	4267	6735
16613	4268	9124
16613	4268	5605
16613	4268	9972
16613	4268	3550
16613	4268	2302
16613	4268	4268
16613	4268	7366
16613	4268	6361
11561	4269	8487
11561	4269	2624
11561	4269	4157
11561	4269	9928
11561	4269	7665
11561	4269	9162
11561	4269	7888
15720	4270	7006
15720	4270	2955
15720	4270	566
15720	4270	7624
15720	4270	9606
15720	4270	2707
15720	4270	699
15720	4270	2444
15720	4270	5211
10276	4271	6386
8547	4272	2133
8547	4272	2594
8547	4272	8181
17493	4273	5673
17493	4273	1148
17493	4273	1546
17493	4273	9571
17493	4273	5167
17493	4273	590
17493	4273	9919
17493	4273	8191
10646	4274	8411
10646	4274	5809
10646	4274	1849
10646	4274	6552
10646	4274	2736
10646	4274	296
10646	4274	7895
18880	4275	3430
18880	4275	1138
18880	4275	6302
18880	4275	2389
18880	4275	7361
18880	4275	9815
16451	4276	9229
11562	4277	8201
11562	4277	5653
11562	4277	6494
11562	4277	5535
11562	4277	8796
11562	4277	8237
11562	4277	2984
10743	4278	3069
10743	4278	6287
10743	4278	7069
10743	4278	8302
10743	4278	9430
10743	4278	2079
10743	4278	57
10743	4278	9237
11462	4279	5513
11462	4279	872
7710	4280	9227
7710	4280	6216
7710	4280	6158
7710	4280	76
7710	4280	9437
7710	4280	9524
7710	4280	1188
7710	4280	3053
4579	4281	8021
4579	4281	163
4579	4281	2046
4579	4281	7281
4579	4281	4889
4579	4281	6789
4579	4281	2881
4579	4281	6410
12969	4282	4861
12969	4282	3810
12969	4282	3390
12969	4282	7293
12969	4282	9152
14344	4283	704
14344	4283	4722
14344	4283	316
14344	4283	3551
12862	4284	5469
15466	4285	9522
15466	4285	7529
9642	4286	9067
16829	4287	9808
16829	4287	6243
16829	4287	9725
16829	4287	7227
16829	4287	6224
16829	4287	3585
16829	4287	2950
16829	4287	9425
17892	4288	1857
17892	4288	4032
17892	4288	9489
17892	4288	1745
17892	4288	1513
17892	4288	5301
17892	4288	7253
17892	4288	1443
17892	4288	1336
15117	4289	9251
15117	4289	4214
15117	4289	2460
15117	4289	7622
18956	4290	9517
18956	4290	2238
18956	4290	5972
18956	4290	8399
18956	4290	5071
18956	4290	2814
18956	4290	2629
18956	4290	5181
18956	4290	1708
1916	4291	9633
1916	4291	7178
4569	4292	1424
4569	4292	1301
4569	4292	7509
11815	4293	1559
11815	4293	8994
11815	4293	5506
14427	4294	8171
14427	4294	5591
14427	4294	8090
14427	4294	5058
3578	4295	8037
3578	4295	137
3578	4295	1964
3578	4295	1453
3578	4295	28
3578	4295	1863
14738	4296	4582
14738	4296	8751
14738	4296	4048
14738	4296	557
11228	4297	7403
11228	4297	8636
17543	4298	6319
17543	4298	3709
17543	4298	5448
5292	4299	7087
5292	4299	7116
5292	4299	276
5292	4299	178
5292	4299	3299
5292	4299	6446
5292	4299	9446
5292	4299	3004
8486	4300	7446
2309	4301	6727
2309	4301	803
2309	4301	3446
2309	4301	7190
2309	4301	3726
2309	4301	1724
2309	4301	8297
2309	4301	1189
1269	4302	8715
1269	4302	8723
1269	4302	8150
1269	4302	8737
1269	4302	7323
8099	4303	3717
8099	4303	7707
8099	4303	7142
8099	4303	8371
8099	4303	5336
8099	4303	3887
8099	4303	1411
8099	4303	7159
8099	4303	9845
17136	4304	4737
17136	4304	6888
17136	4304	8430
17136	4304	6108
17136	4304	5720
17136	4304	8147
10577	4305	4154
10577	4305	5769
10577	4305	6718
10577	4305	3405
10577	4305	7180
10577	4305	9749
10577	4305	1817
10577	4305	1087
10577	4305	1366
19590	4306	1360
19590	4306	4544
19590	4306	3022
19590	4306	4795
19590	4306	4374
285	4307	7321
285	4307	8665
285	4307	3641
285	4307	9559
285	4307	9603
1936	4308	763
4245	4309	1629
4245	4309	5157
4245	4309	2992
4245	4309	5370
4245	4309	9673
4245	4309	5852
4245	4309	2748
4245	4309	1494
4245	4309	2929
5062	4310	3499
5062	4310	4476
5062	4310	2813
5062	4310	6383
16023	4311	4434
16023	4311	4385
16023	4311	4070
16023	4311	2160
16023	4311	1051
5088	4312	3597
5088	4312	9897
5088	4312	6995
5088	4312	5611
5088	4312	7656
5088	4312	1285
5088	4312	3326
6683	4313	6349
6683	4313	6286
6683	4313	4279
6683	4313	339
6683	4313	3352
6683	4313	7873
2937	4314	6762
2937	4314	5431
6172	4315	7124
6172	4315	8518
6172	4315	7463
6172	4315	5656
6172	4315	4577
6172	4315	4228
6172	4315	386
7475	4316	8384
7475	4316	3524
571	4317	2658
571	4317	2033
571	4317	4739
571	4317	7574
571	4317	8330
571	4317	7612
571	4317	8846
571	4317	5926
571	4317	1043
10452	4318	7281
10452	4318	8462
10452	4318	4603
10452	4318	1091
10452	4318	926
10452	4318	2759
10452	4318	7201
9548	4319	9810
17311	4320	1729
18738	4321	6350
18738	4321	5146
18738	4321	4908
18738	4321	6790
18738	4321	5304
18738	4321	9745
18738	4321	674
5578	4322	3234
5578	4322	4680
5578	4322	184
5578	4322	8018
5578	4322	6829
5578	4322	1282
15262	4323	2442
15262	4323	6292
15262	4323	8658
15262	4323	6946
15262	4323	9658
15262	4323	5348
14134	4324	8596
14134	4324	1305
14134	4324	1445
14134	4324	692
3946	4325	9604
3946	4325	1947
3946	4325	2337
3946	4325	1276
3946	4325	9833
18982	4326	4709
18982	4326	1812
18982	4326	9890
18982	4326	2452
18982	4326	9186
19755	4327	1851
19755	4327	9927
19755	4327	3769
19755	4327	3499
19755	4327	111
19888	4328	9435
19888	4328	1242
19888	4328	5082
19888	4328	383
19888	4328	3460
19888	4328	6165
13362	4329	1204
13362	4329	2989
13362	4329	5828
13362	4329	3003
13362	4329	2863
13362	4329	4100
13362	4329	3058
13362	4329	6460
13362	4329	5928
2017	4330	5979
2017	4330	9851
2017	4330	6860
2017	4330	8824
2017	4330	5476
2017	4330	3756
2017	4330	1157
8319	4331	7274
8319	4331	8047
8319	4331	102
8319	4331	2823
8319	4331	2206
8319	4331	7038
8319	4331	6475
8319	4331	7174
8065	4332	3415
8065	4332	4008
8065	4332	6844
8065	4332	6754
11325	4333	8671
11325	4333	6928
11325	4333	2700
11325	4333	4802
11325	4333	9208
11325	4333	7865
10076	4334	9071
4970	4335	9655
4970	4335	3166
4970	4335	2197
4970	4335	2071
4970	4335	9086
4970	4335	539
4970	4335	9515
4970	4335	5764
9943	4336	654
9943	4336	1046
9943	4336	1020
9943	4336	7570
9943	4336	2601
9943	4336	3015
12359	4337	8669
12359	4337	5532
12359	4337	1476
1980	4338	5306
1980	4338	4503
1980	4338	3458
1980	4338	2468
1980	4338	7816
1980	4338	4619
1980	4338	8501
1980	4338	6245
1980	4338	9474
16275	4339	8872
16275	4339	4116
16275	4339	2024
16275	4339	1338
16275	4339	7414
16275	4339	8781
4477	4340	6742
2720	4341	8579
2720	4341	4072
2720	4341	3753
8349	4342	128
8349	4342	5409
8349	4342	126
8349	4342	3482
8349	4342	3388
2980	4343	2060
2980	4343	1415
2980	4343	2601
2980	4343	8674
2980	4343	8206
2980	4343	9232
10843	4344	483
10843	4344	4883
10843	4344	8411
3785	4345	4154
3785	4345	7514
3785	4345	8531
3785	4345	9895
3785	4345	5690
3785	4345	1634
19678	4346	1797
19678	4346	8327
19678	4346	4261
18286	4347	4151
18286	4347	4492
18286	4347	3358
1743	4348	445
1743	4348	7178
1743	4348	9689
1743	4348	498
1743	4348	8651
1743	4348	6268
1743	4348	9228
6977	4349	2631
6977	4349	5164
6977	4349	5436
17588	4350	9665
17588	4350	9415
13185	4351	5404
13185	4351	5845
13185	4351	4348
7150	4352	7064
7150	4352	5441
7150	4352	8211
7294	4353	2441
7294	4353	2138
7294	4353	4161
7294	4353	2215
7294	4353	8144
7294	4353	9436
7294	4353	5198
7294	4353	7602
7294	4353	7393
8198	4354	4208
4837	4355	6066
4837	4355	6309
4837	4355	9845
4837	4355	611
4837	4355	9998
4837	4355	960
792	4356	5676
792	4356	6025
792	4356	1393
792	4356	7167
792	4356	9328
792	4356	6792
15633	4357	9101
15633	4357	8364
15633	4357	311
15633	4357	2951
15633	4357	1800
15633	4357	8450
15633	4357	4307
15633	4357	9563
15633	4357	9429
1643	4358	7194
7971	4359	1802
7971	4359	5243
7971	4359	684
7971	4359	9847
7971	4359	2581
8761	4360	7463
8761	4360	9888
8761	4360	997
8761	4360	2612
8761	4360	138
8761	4360	4265
8761	4360	1401
8761	4360	1316
8761	4360	1241
12967	4361	90
12967	4361	5159
12967	4361	6663
12967	4361	7051
9026	4362	1538
9026	4362	5414
9026	4362	9428
9026	4362	1491
9026	4362	2882
9026	4362	9549
1579	4363	7273
14725	4364	33
14167	4365	1596
14167	4365	9125
14167	4365	4995
8845	4366	8115
8845	4366	1664
8845	4366	7168
8845	4366	8452
8845	4366	255
8845	4366	5815
8845	4366	3087
8845	4366	5816
5267	4367	5661
5267	4367	7714
5267	4367	4931
5267	4367	9323
5267	4367	7131
5267	4367	984
5267	4367	2380
5267	4367	2908
2718	4368	7083
2718	4368	7577
6784	4369	6026
6784	4369	1827
6784	4369	5289
6784	4369	6471
11585	4370	5203
11585	4370	4624
11585	4370	6063
11585	4370	7130
11585	4370	8889
11585	4370	50
11585	4370	1002
11585	4370	6142
11585	4370	1018
14085	4371	8729
14085	4371	6948
14085	4371	8430
14085	4371	991
14085	4371	8575
14085	4371	4276
14085	4371	3776
1811	4372	2064
1811	4372	5589
1811	4372	5943
1811	4372	4921
1811	4372	1160
1811	4372	4003
1811	4372	7910
1811	4372	2291
1811	4372	7929
17840	4373	5114
17840	4373	5826
17840	4373	6195
8924	4374	2779
8924	4374	4923
19686	4375	345
19686	4375	8730
19686	4375	2414
19686	4375	3111
19686	4375	1739
6638	4376	9175
6638	4376	3265
6638	4376	2170
6638	4376	9832
5220	4377	1332
5220	4377	9683
5220	4377	8235
5220	4377	6696
5220	4377	8281
5220	4377	7984
5220	4377	9452
5220	4377	8554
5220	4377	3042
4434	4378	7586
4434	4378	9414
4434	4378	4469
4434	4378	28
4434	4378	4172
4434	4378	8153
12776	4379	3352
12776	4379	4174
12776	4379	3551
12776	4379	1059
12776	4379	2339
10857	4380	1783
10857	4380	537
10857	4380	1321
10857	4380	5528
19398	4381	3553
19398	4381	4112
19398	4381	6142
19398	4381	9594
19398	4381	8799
19398	4381	3941
19398	4381	5248
11391	4382	103
1279	4383	5645
1279	4383	6845
1279	4383	9913
1279	4383	2940
1279	4383	627
13536	4384	7083
2047	4385	7303
2047	4385	4578
2047	4385	7404
2047	4385	2500
2047	4385	5320
2047	4385	7079
2047	4385	7400
2047	4385	6180
18239	4386	6171
18239	4386	869
18239	4386	2166
18239	4386	3998
14338	4387	4298
14338	4387	5286
14338	4387	3940
14338	4387	3282
14338	4387	4971
14338	4387	223
12805	4388	5522
12805	4388	1858
12805	4388	2134
12805	4388	2377
12805	4388	677
12805	4388	98
12805	4388	3543
15680	4389	9540
15680	4389	8998
7936	4390	6338
7936	4390	3861
7936	4390	5221
7936	4390	6479
7936	4390	1074
7936	4390	9804
7936	4390	2910
6016	4391	7788
6016	4391	1207
6016	4391	7271
6016	4391	9805
14082	4392	4500
14082	4392	4212
14082	4392	2593
14082	4392	7743
14082	4392	6510
14082	4392	7683
14082	4392	2267
4182	4393	5459
4182	4393	2983
4182	4393	3214
4182	4393	7412
4182	4393	6520
4182	4393	59
4182	4393	7728
3879	4394	1372
3879	4394	4992
3879	4394	9478
3879	4394	4195
3879	4394	3268
3879	4394	3835
18586	4395	5958
6739	4396	4349
6739	4396	4421
6739	4396	9104
6739	4396	4016
6739	4396	3670
6739	4396	2683
6739	4396	3268
14924	4397	8450
14924	4397	1471
14924	4397	7031
14924	4397	7256
14924	4397	1195
11363	4398	227
18661	4399	1353
18661	4399	2184
18661	4399	569
18661	4399	6195
18661	4399	2914
18661	4399	6508
18661	4399	7837
9736	4400	7856
9736	4400	3383
9736	4400	4580
9736	4400	4920
9736	4400	9941
16356	4401	85
16356	4401	9524
16356	4401	2134
16356	4401	2558
16356	4401	5818
7308	4402	8522
7308	4402	9114
7308	4402	3647
7308	4402	591
11020	4403	3211
11020	4403	66
301	4404	804
301	4404	7900
7434	4405	7371
7434	4405	2112
7434	4405	4220
7434	4405	2269
7434	4405	3722
7434	4405	6093
7434	4405	8370
7434	4405	7557
15245	4406	7773
15245	4406	1132
15245	4406	203
15245	4406	1937
15245	4406	2748
15245	4406	9751
15245	4406	3834
15245	4406	6010
15245	4406	3088
13619	4407	2479
13619	4407	1136
14859	4408	6380
15023	4409	6543
15023	4409	6031
15023	4409	305
15023	4409	9409
10836	4410	3697
9670	4411	4343
10860	4412	5807
10860	4412	3142
10860	4412	2579
10860	4412	4120
10860	4412	3089
10860	4412	8412
10860	4412	5932
7151	4413	4307
7151	4413	7836
7151	4413	1769
7151	4413	1867
7151	4413	9216
7151	4413	1541
7151	4413	9634
7151	4413	2970
7151	4413	7209
2657	4414	1479
2657	4414	6405
2657	4414	900
8274	4415	1071
8274	4415	7139
8274	4415	9456
8274	4415	8951
8274	4415	926
1118	4416	3334
1118	4416	5093
1118	4416	6376
1118	4416	6267
1118	4416	2842
1118	4416	5265
1118	4416	6609
1118	4416	7879
1118	4416	1541
17359	4417	7684
17359	4417	9896
12941	4418	6015
12941	4418	4116
12941	4418	5759
12941	4418	869
12941	4418	8346
12941	4418	4697
12941	4418	7452
12941	4418	9860
12941	4418	1576
6688	4419	4568
6688	4419	6806
6688	4419	6373
6688	4419	935
6688	4419	7104
6688	4419	8045
7606	4420	5828
7606	4420	2635
7606	4420	3667
7606	4420	1829
7606	4420	5416
7606	4420	4927
7606	4420	6748
7606	4420	5761
7606	4420	2769
18283	4421	4683
18283	4421	3662
18283	4421	8925
18283	4421	6530
18283	4421	643
18283	4421	692
18283	4421	2882
9421	4422	8115
9421	4422	8473
9421	4422	7816
9421	4422	6178
9421	4422	6799
9421	4422	9726
9421	4422	8670
9421	4422	5105
8057	4423	4664
8057	4423	6022
8057	4423	7970
8057	4423	9715
15198	4424	410
15198	4424	6589
5532	4425	4722
5532	4425	7016
5532	4425	2944
5532	4425	5723
5532	4425	6148
5532	4425	3743
5532	4425	4464
5532	4425	6168
5532	4425	8666
4556	4426	4005
4556	4426	2461
4556	4426	2116
4556	4426	3359
16161	4427	1472
16161	4427	4029
353	4428	988
353	4428	5987
353	4428	3864
353	4428	3037
353	4428	6930
353	4428	1506
7931	4429	9243
7931	4429	3448
7931	4429	2965
8872	4430	1631
17194	4431	28
17194	4431	8393
2859	4432	7947
2859	4432	2516
8083	4433	8926
8083	4433	369
8083	4433	7231
8083	4433	6326
8083	4433	6488
8083	4433	332
8693	4434	4347
8693	4434	472
8693	4434	7797
8693	4434	582
8693	4434	5015
8693	4434	4097
9946	4435	9296
9946	4435	7954
9946	4435	5020
9946	4435	9067
9946	4435	2236
9946	4435	8244
12437	4436	2586
12437	4436	7090
12437	4436	7831
12437	4436	6126
12437	4436	768
12437	4436	4850
12437	4436	5195
12437	4436	3968
3842	4437	6200
3842	4437	8220
3842	4437	9480
3842	4437	7224
3842	4437	2682
3842	4437	1315
3842	4437	8434
12528	4438	9110
12528	4438	1997
14382	4439	1682
14382	4439	635
14382	4439	5452
14382	4439	2780
14382	4439	5270
14382	4439	134
14382	4439	5484
14382	4439	5087
7039	4440	9784
7039	4440	5504
7039	4440	8118
7039	4440	2852
19795	4441	8637
19795	4441	9070
19795	4441	9047
19795	4441	7758
19795	4441	4110
19795	4441	6811
3794	4442	5416
3794	4442	2516
3794	4442	2868
3794	4442	4092
3794	4442	5519
3794	4442	3849
3794	4442	6841
3794	4442	6581
11300	4443	7499
11300	4443	1002
11300	4443	5213
11300	4443	1201
11300	4443	9708
11300	4443	4704
11300	4443	9183
4099	4444	3034
4099	4444	1357
4099	4444	966
4099	4444	2308
19890	4445	6630
19890	4445	559
19890	4445	2303
7007	4446	1094
7007	4446	274
7007	4446	3612
7007	4446	2326
7007	4446	5011
12736	4447	4565
16476	4448	1475
16476	4448	2007
8618	4449	7812
8618	4449	9345
8618	4449	5885
8618	4449	9182
3014	4450	6866
3014	4450	1595
3014	4450	8522
3014	4450	3654
3014	4450	4397
11744	4451	7906
11744	4451	4265
11744	4451	2216
11744	4451	5202
11744	4451	982
11744	4451	1180
11744	4451	581
11744	4451	1670
11744	4451	6622
16431	4452	4375
16431	4452	2035
16431	4452	9441
16431	4452	4643
16431	4452	9941
8409	4453	6281
8409	4453	507
8409	4453	4544
8409	4453	7425
8409	4453	3082
8409	4453	4051
8409	4453	7630
8409	4453	7918
8409	4453	6323
16716	4454	8342
16716	4454	4716
16716	4454	8254
16716	4454	2487
16716	4454	392
16716	4454	9969
9025	4455	9638
9025	4455	2548
9025	4455	5369
9025	4455	4614
1874	4456	9295
1874	4456	8020
5470	4457	4181
9144	4458	5471
9144	4458	1592
9144	4458	6653
9144	4458	3721
9144	4458	4917
9144	4458	9377
9144	4458	2375
15906	4459	4594
15906	4459	7398
15906	4459	7593
15906	4459	7542
15906	4459	1721
15906	4459	6345
15906	4459	1731
15906	4459	2092
15906	4459	9870
7180	4460	2678
7180	4460	8999
7180	4460	2146
7180	4460	3005
7180	4460	9227
7180	4460	3841
7180	4460	4540
7180	4460	9942
7180	4460	3206
19102	4461	1366
19102	4461	1787
19102	4461	1390
19102	4461	4825
19102	4461	5805
19102	4461	6655
19102	4461	2555
19102	4461	4269
6991	4462	121
6991	4462	3057
12526	4463	5814
12526	4463	4976
12526	4463	4925
12526	4463	8415
12526	4463	3100
12526	4463	5648
4603	4464	1101
4603	4464	8855
4603	4464	1471
3183	4465	1653
3183	4465	9828
3183	4465	6003
3183	4465	5655
1158	4466	6893
1158	4466	4474
10429	4467	8510
10429	4467	1427
10429	4467	4826
10429	4467	9378
18179	4468	8580
18179	4468	9519
18179	4468	4367
18179	4468	5562
18179	4468	5752
18179	4468	8422
5789	4469	8109
5789	4469	7338
5789	4469	5968
5789	4469	3983
6721	4470	2450
6721	4470	2292
6721	4470	3751
6721	4470	5612
6721	4470	6984
6721	4470	5304
7450	4471	6620
7450	4471	2504
7450	4471	590
7450	4471	1346
7450	4471	8606
7450	4471	7352
7450	4471	8688
7450	4471	6418
17419	4472	520
17419	4472	372
17419	4472	8951
6853	4473	2044
6853	4473	6182
6853	4473	747
6853	4473	4389
6853	4473	3329
6853	4473	7419
12213	4474	7244
12213	4474	8387
12213	4474	4918
12213	4474	7187
12213	4474	6408
12213	4474	964
12213	4474	9564
12213	4474	2263
12213	4474	6383
14258	4475	9220
13277	4476	2745
13277	4476	6476
13277	4476	6047
13277	4476	9397
13277	4476	3768
13277	4476	6253
13277	4476	2721
4568	4477	3891
4568	4477	7526
4568	4477	1092
4568	4477	589
4568	4477	1283
4568	4477	6950
4568	4477	924
4568	4477	3889
4568	4477	9682
18157	4478	5662
18157	4478	6204
18157	4478	4369
18157	4478	666
18157	4478	2107
18157	4478	5912
14006	4479	7315
14006	4479	9317
14006	4479	4160
14006	4479	3958
14006	4479	7639
19798	4480	5927
19798	4480	6034
19798	4480	6762
19798	4480	5153
19798	4480	2350
19798	4480	1983
19798	4480	6891
19798	4480	5264
5156	4481	6842
1599	4482	4440
1599	4482	8867
1599	4482	1990
1599	4482	5537
1599	4482	6922
1599	4482	8425
1599	4482	9724
1599	4482	9334
1599	4482	9035
8598	4483	6877
7437	4484	4518
7437	4484	1451
7437	4484	3709
11397	4485	3721
11397	4485	3948
7344	4486	5378
7344	4486	9662
7344	4486	6253
7344	4486	3731
9767	4487	7366
9767	4487	9626
9767	4487	322
9767	4487	9133
9767	4487	9033
9767	4487	8086
9767	4487	6271
9767	4487	4898
9767	4487	5705
2166	4488	4750
2166	4488	8622
2166	4488	9151
2166	4488	3364
1459	4489	9546
17355	4490	2919
17355	4490	5940
17355	4490	4237
19884	4491	1025
19884	4491	6852
19884	4491	4446
19884	4491	4255
15236	4492	8348
15236	4492	9655
15236	4492	4639
15236	4492	6570
15236	4492	6995
15236	4492	961
15236	4492	8677
15236	4492	3771
4850	4493	849
4850	4493	1937
4850	4493	3942
4850	4493	8891
4850	4493	3808
4850	4493	418
145	4494	3881
1750	4495	3809
1750	4495	4992
1750	4495	3024
1750	4495	5
1750	4495	6293
1750	4495	3111
1750	4495	6147
1750	4495	4420
1750	4495	8635
18104	4496	9125
18104	4496	9040
18104	4496	7048
18104	4496	3880
18104	4496	7670
18104	4496	7936
18104	4496	5268
18104	4496	2793
18104	4496	5601
17422	4497	5763
17422	4497	7309
17422	4497	9961
686	4498	773
686	4498	5578
686	4498	6705
8748	4499	7036
8748	4499	9869
8748	4499	7685
8748	4499	8913
8748	4499	4181
8748	4499	6080
8748	4499	7960
8748	4499	4341
8748	4499	4218
8015	4500	2837
8015	4500	6856
8015	4500	5398
8015	4500	3915
8015	4500	6740
8015	4500	4955
8015	4500	778
8015	4500	2078
8015	4500	6448
5056	4501	5916
5056	4501	1795
5056	4501	8331
5056	4501	4140
13953	4502	6518
13953	4502	3777
13953	4502	2573
13953	4502	1383
13953	4502	7124
13953	4502	167
13229	4503	9142
13229	4503	1642
13229	4503	2201
13229	4503	5190
13229	4503	3494
13229	4503	9224
13229	4503	6306
5647	4504	3255
5647	4504	2825
5647	4504	3988
8308	4505	769
8308	4505	6414
8308	4505	6267
8308	4505	4967
8308	4505	1492
8308	4505	8998
8308	4505	9486
8308	4505	7570
12204	4506	8411
12204	4506	2426
12204	4506	6507
12204	4506	1183
12204	4506	567
12204	4506	1951
16729	4507	6420
16729	4507	9671
17337	4508	6890
17337	4508	1645
17337	4508	6568
17337	4508	4934
17337	4508	2128
17337	4508	6213
14790	4509	7726
14790	4509	5674
14790	4509	2252
14790	4509	3868
7077	4510	2207
7077	4510	5351
7077	4510	9945
7077	4510	8064
7077	4510	7253
7077	4510	1490
7077	4510	356
7077	4510	8014
7077	4510	5097
5644	4511	5485
5644	4511	1060
5644	4511	4760
5644	4511	2891
10194	4512	4193
10194	4512	6032
10194	4512	7276
10194	4512	5253
10194	4512	2664
10194	4512	6467
10194	4512	9737
10194	4512	628
10194	4512	4385
19739	4513	9222
19739	4513	7593
19739	4513	6654
19739	4513	7209
2803	4514	3658
2803	4514	9632
2803	4514	4279
2803	4514	4519
2803	4514	2973
2803	4514	2308
13384	4515	6562
13384	4515	8207
13384	4515	3929
13384	4515	7895
13384	4515	7079
14790	4516	3743
14790	4516	1807
14790	4516	9073
14790	4516	5670
14790	4516	6830
14790	4516	7847
612	4517	5109
6630	4518	9114
6630	4518	3434
6630	4518	1171
15351	4519	7838
15351	4519	704
15351	4519	5675
15351	4519	502
15351	4519	5016
15351	4519	1642
15351	4519	8655
7526	4520	7078
7526	4520	9336
7526	4520	4100
7526	4520	2383
7526	4520	4258
7526	4520	2947
1568	4521	7695
1568	4521	377
1568	4521	9809
1568	4521	6545
10399	4522	8963
12079	4523	2231
12079	4523	8802
12079	4523	6183
12079	4523	583
12079	4523	5100
12079	4523	9913
15213	4524	5803
15213	4524	3655
15213	4524	5291
15213	4524	7547
15213	4524	6517
15213	4524	2989
15213	4524	2549
15213	4524	9246
16095	4525	1107
16095	4525	6023
16095	4525	3857
16095	4525	2936
16095	4525	3542
16095	4525	5
16095	4525	811
12202	4526	311
12202	4526	5747
12202	4526	9693
12202	4526	3101
12202	4526	3074
12202	4526	6986
12202	4526	708
12202	4526	2439
12202	4526	4299
14468	4527	4203
14468	4527	5550
14468	4527	1700
14468	4527	1115
14468	4527	6479
14468	4527	8142
15668	4528	6772
15668	4528	1637
15668	4528	6058
15668	4528	1849
15668	4528	9075
15668	4528	4791
15668	4528	3381
15668	4528	7945
6990	4529	736
6990	4529	4229
6990	4529	5136
19720	4530	7685
19720	4530	3553
19720	4530	733
19720	4530	1666
19720	4530	8107
19720	4530	8729
19720	4530	2479
19720	4530	5724
19720	4530	9693
4580	4531	6001
4580	4531	1867
4580	4531	5757
4580	4531	997
4580	4531	1266
9636	4532	4429
9636	4532	6249
9636	4532	407
9636	4532	5433
2314	4533	7748
2314	4533	9069
2314	4533	1878
2314	4533	292
2314	4533	6206
2314	4533	5051
2314	4533	2008
9885	4534	8610
9885	4534	3551
9885	4534	8098
9885	4534	9835
13840	4535	3699
5534	4536	7837
5534	4536	2996
5534	4536	5680
5534	4536	1244
5534	4536	4361
5534	4536	2630
5534	4536	1010
5534	4536	1056
5534	4536	6097
11862	4537	2851
11862	4537	5507
11862	4537	9806
11862	4537	9317
11862	4537	2131
10252	4538	3171
10252	4538	2145
10252	4538	9564
10252	4538	3025
10252	4538	6013
4218	4539	8040
4218	4539	9011
4218	4539	3288
4218	4539	7440
13512	4540	3909
13512	4540	4654
13512	4540	5475
13512	4540	7540
13512	4540	5356
13512	4540	2392
13512	4540	7677
13512	4540	2462
13512	4540	513
17104	4541	9443
17104	4541	9990
17104	4541	7991
17104	4541	3638
17104	4541	6915
3137	4542	9394
3137	4542	4339
3137	4542	7291
3137	4542	3130
3137	4542	5134
3137	4542	7777
3137	4542	1285
5792	4543	7794
5792	4543	523
5792	4543	7086
5792	4543	6014
14520	4544	3981
14520	4544	4542
14520	4544	9711
14520	4544	5049
365	4545	5829
365	4545	8813
365	4545	2612
365	4545	3667
365	4545	8221
10612	4546	9306
10612	4546	9463
6886	4547	1762
6886	4547	783
6886	4547	2385
6886	4547	6993
6886	4547	2155
6886	4547	531
6886	4547	2848
6886	4547	9490
6886	4547	3548
19473	4548	1940
19473	4548	9105
19473	4548	7196
19473	4548	4846
19473	4548	2464
19473	4548	6576
19473	4548	3418
19473	4548	827
19473	4548	9776
613	4549	3449
613	4549	2591
613	4549	1148
613	4549	6732
613	4549	2344
613	4549	6486
7362	4550	711
7362	4550	1526
7362	4550	673
7362	4550	6247
7362	4550	5353
17166	4551	4661
17166	4551	1867
17166	4551	6772
17166	4551	545
17166	4551	7179
17166	4551	2175
17166	4551	4337
17166	4551	7345
16111	4552	5342
16111	4552	3637
16111	4552	8895
16111	4552	7610
16111	4552	7572
16111	4552	1804
16111	4552	3714
16111	4552	9484
56	4553	2916
56	4553	7528
56	4553	8411
56	4553	6550
6547	4554	670
6547	4554	9857
6547	4554	6896
6547	4554	2939
6547	4554	1404
6547	4554	6700
6547	4554	8413
6547	4554	5602
19180	4555	5752
19180	4555	6379
19180	4555	1361
19180	4555	9740
19180	4555	6201
19180	4555	2557
19180	4555	1919
19180	4555	6434
19180	4555	9879
2565	4556	6400
2565	4556	6165
2565	4556	7624
2565	4556	1591
2565	4556	1502
2565	4556	3074
2565	4556	1505
2565	4556	808
2565	4556	8722
2556	4557	3691
2556	4557	5988
2556	4557	9684
2556	4557	4852
2556	4557	9250
2556	4557	6325
2556	4557	3252
9685	4558	2185
9685	4558	7171
9685	4558	8041
9685	4558	4934
9685	4558	4986
9685	4558	8040
9685	4558	7363
9685	4558	9175
9685	4558	5300
302	4559	1402
302	4559	7283
10144	4560	4363
10144	4560	7068
10144	4560	5369
10144	4560	9510
8990	4561	3359
8990	4561	1641
8990	4561	1204
8990	4561	1392
8990	4561	7091
8990	4561	5691
8990	4561	3029
8990	4561	3145
8990	4561	8045
4815	4562	3941
4815	4562	1596
4815	4562	9991
4815	4562	7945
4815	4562	3377
4815	4562	8336
19077	4563	3361
19077	4563	9277
19077	4563	7539
19077	4563	2024
19077	4563	8263
15362	4564	4168
15362	4564	7331
15362	4564	9867
15362	4564	9229
15362	4564	7803
15362	4564	9114
15362	4564	7622
19158	4565	8627
19158	4565	8088
19158	4565	9759
19158	4565	6849
19158	4565	180
19158	4565	5702
19158	4565	7814
19158	4565	9073
19158	4565	5632
9719	4566	7465
10173	4567	4666
10173	4567	1117
18408	4568	9315
18408	4568	2223
18408	4568	6476
18408	4568	2151
2446	4569	162
2446	4569	8283
2446	4569	2163
2446	4569	2774
3174	4570	8577
3174	4570	8790
3174	4570	967
3174	4570	7223
3174	4570	4551
2052	4571	5315
2052	4571	3149
6621	4572	221
6621	4572	2616
6621	4572	7371
6621	4572	4581
6621	4572	8948
6621	4572	9780
6621	4572	6179
6803	4573	2847
433	4574	5378
433	4574	1620
433	4574	9187
433	4574	832
433	4574	7066
433	4574	2403
433	4574	6897
11688	4575	3582
11688	4575	2979
11688	4575	9721
5134	4576	2783
5134	4576	8533
304	4577	8413
304	4577	2007
304	4577	6404
6600	4578	9144
6600	4578	4600
6600	4578	7851
15142	4579	138
15142	4579	4048
15142	4579	3924
14670	4580	9934
14670	4580	6161
14670	4580	6622
13073	4581	8904
13073	4581	9270
13073	4581	7733
13073	4581	1081
13073	4581	4691
13073	4581	2412
13073	4581	9052
5951	4582	311
5951	4582	2035
5951	4582	2912
5951	4582	2183
5951	4582	760
5951	4582	6070
5951	4582	6269
5951	4582	1631
18727	4583	9386
18727	4583	2220
18727	4583	2179
18727	4583	8255
18727	4583	4247
18727	4583	8756
18727	4583	9060
18727	4583	4800
18727	4583	8986
19490	4584	6368
19490	4584	2547
19490	4584	7320
19490	4584	7362
19490	4584	580
19490	4584	7329
19490	4584	8544
13595	4585	4089
13595	4585	2872
13595	4585	8980
13595	4585	5119
13595	4585	4654
13595	4585	7710
13595	4585	4197
13595	4585	1948
18536	4586	9247
18536	4586	6184
18536	4586	1144
18536	4586	6083
18536	4586	1524
18536	4586	3530
18536	4586	3706
18536	4586	8761
18536	4586	4073
17453	4587	8893
17453	4587	2435
17453	4587	1441
17453	4587	109
17453	4587	3947
17453	4587	7552
17453	4587	5932
17453	4587	4857
12761	4588	1993
12761	4588	3839
12761	4588	3920
12761	4588	4634
12761	4588	6638
12761	4588	2927
12761	4588	9834
2550	4589	482
2550	4589	5837
2550	4589	3948
2550	4589	6728
2550	4589	3782
2550	4589	5185
14355	4590	7931
14355	4590	9823
12921	4591	1991
12921	4591	9321
12921	4591	8809
12921	4591	4843
1357	4592	2446
1357	4592	5762
1357	4592	4685
1357	4592	7538
1357	4592	8123
1357	4592	4670
1357	4592	6549
15163	4593	1541
15163	4593	3852
15163	4593	1305
15163	4593	52
15163	4593	1950
15163	4593	6825
18540	4594	5497
18540	4594	6724
18540	4594	763
18540	4594	3118
18540	4594	900
18540	4594	9924
1750	4595	3818
1750	4595	9648
1750	4595	2348
1750	4595	1268
1750	4595	2760
1750	4595	3569
1750	4595	7362
1750	4595	8556
10559	4596	126
10559	4596	1089
10559	4596	8677
10559	4596	543
10559	4596	1887
10559	4596	4712
8719	4597	4059
8719	4597	2710
8719	4597	185
8719	4597	9596
8719	4597	3168
8719	4597	405
8719	4597	3431
8719	4597	3720
9616	4598	5820
9616	4598	9908
9616	4598	1502
9616	4598	3411
8472	4599	6329
8472	4599	9855
8472	4599	4967
16269	4600	6197
16269	4600	760
16269	4600	4588
16269	4600	4724
16269	4600	52
19918	4601	4578
19918	4601	3358
19918	4601	5897
19918	4601	6593
19918	4601	8026
19918	4601	8738
5591	4602	7258
5591	4602	4531
5591	4602	7239
5591	4602	4085
8272	4603	4095
8272	4603	8369
8272	4603	2415
16622	4604	536
16622	4604	5268
16622	4604	2080
16622	4604	2069
16622	4604	4665
16622	4604	529
16622	4604	7344
16622	4604	8314
13198	4605	9175
13198	4605	2986
13198	4605	8330
1116	4606	9379
9292	4607	5812
9292	4607	4705
10467	4608	3000
10467	4608	3685
10467	4608	4583
7515	4609	1301
7515	4609	3346
7515	4609	7794
7515	4609	902
7515	4609	1304
7515	4609	1818
7515	4609	1820
7515	4609	411
10648	4610	7581
10648	4610	5759
10648	4610	7485
10648	4610	514
10648	4610	4099
10648	4610	390
10648	4610	6655
8896	4611	1620
8896	4611	7191
8896	4611	6919
8896	4611	1065
8896	4611	5535
8896	4611	2653
8896	4611	6944
5404	4612	3043
5404	4612	1979
5404	4612	1431
5404	4612	2540
5404	4612	6105
5404	4612	2534
5404	4612	5377
5404	4612	8994
5404	4612	7589
17308	4613	7823
17308	4613	4404
17308	4613	6128
17308	4613	7467
17308	4613	5987
17308	4613	9638
17308	4613	7650
379	4614	8697
379	4614	3337
379	4614	5839
379	4614	6641
379	4614	8242
379	4614	2082
19807	4615	4669
19807	4615	6185
19807	4615	1130
19807	4615	2645
19807	4615	138
19807	4615	1835
19807	4615	484
19807	4615	6912
19807	4615	2674
17026	4616	1941
17026	4616	8114
17026	4616	2302
17026	4616	3925
17026	4616	3175
17026	4616	3182
17026	4616	729
17026	4616	1532
17026	4616	5078
13824	4617	7900
13824	4617	3332
13824	4617	9301
13824	4617	9086
2052	4618	5048
2052	4618	8036
2052	4618	4676
2052	4618	7565
2052	4618	570
4202	4619	3770
4202	4619	4157
4202	4619	9484
4202	4619	4964
4202	4619	2629
4202	4619	9401
4202	4619	6142
17676	4620	3836
17676	4620	6760
17676	4620	9722
17676	4620	6367
17676	4620	2617
17676	4620	2392
17676	4620	5779
17676	4620	9616
18198	4621	1914
18198	4621	1300
18198	4621	6333
18198	4621	7196
18198	4621	6279
18198	4621	6861
18198	4621	6181
11804	4622	6193
11804	4622	3525
11804	4622	4842
11804	4622	4746
11804	4622	9238
2454	4623	5846
2454	4623	6784
2454	4623	2594
2454	4623	1251
2454	4623	1649
15658	4624	3731
15658	4624	2602
15658	4624	233
15658	4624	8508
15658	4624	5430
15658	4624	9532
15658	4624	71
7848	4625	9077
7848	4625	3916
10333	4626	3277
10014	4627	4680
10014	4627	2449
10014	4627	5868
2594	4628	5964
2594	4628	2605
2594	4628	8203
2594	4628	3595
2594	4628	6499
2594	4628	8950
2594	4628	2677
2594	4628	6782
2594	4628	9023
12326	4629	5905
12326	4629	554
12326	4629	1505
12326	4629	3070
12326	4629	58
12326	4629	9991
16386	4630	5472
16386	4630	1995
16386	4630	6138
16386	4630	3915
16386	4630	626
3174	4631	7228
3174	4631	7146
3174	4631	6778
3174	4631	8321
3174	4631	4363
3174	4631	8880
19538	4632	4253
19538	4632	5185
19538	4632	2439
19538	4632	920
19538	4632	4240
5470	4633	9331
5470	4633	3396
5470	4633	8141
5470	4633	5126
5470	4633	20
5470	4633	4840
5470	4633	3841
5470	4633	8668
5841	4634	9168
5841	4634	7250
5841	4634	3197
5841	4634	1633
5841	4634	4225
5841	4634	878
8546	4635	4446
8546	4635	9727
8546	4635	4644
16970	4636	4872
16970	4636	4951
8236	4637	4206
8236	4637	5860
8236	4637	1802
8236	4637	604
11457	4638	8994
11457	4638	8825
11457	4638	5862
11457	4638	3287
7468	4639	4925
7468	4639	6101
7468	4639	323
7468	4639	6415
7468	4639	1535
7468	4639	367
7468	4639	2357
11991	4640	9664
11991	4640	4364
11991	4640	4413
15397	4641	1433
15397	4641	736
15397	4641	6909
15397	4641	8402
9632	4642	7090
18893	4643	5442
18893	4643	2908
18893	4643	5486
18893	4643	3594
18893	4643	7496
18893	4643	7597
18893	4643	9462
18893	4643	7649
18893	4643	5386
7575	4644	8603
7575	4644	6681
7575	4644	5674
7575	4644	5138
7575	4644	547
7575	4644	8563
8097	4645	3947
8097	4645	4829
8097	4645	5166
8097	4645	572
8097	4645	4488
8097	4645	7372
8097	4645	9745
8097	4645	7612
8097	4645	2708
16762	4646	7150
16762	4646	9757
16762	4646	8898
16762	4646	9760
16762	4646	4718
16762	4646	7843
16762	4646	5250
16762	4646	3836
16762	4646	5822
6388	4647	2354
6388	4647	9871
7818	4648	3086
7818	4648	2090
7818	4648	6303
7818	4648	8283
7818	4648	610
7818	4648	9769
10037	4649	840
10037	4649	4705
10037	4649	475
10037	4649	4142
10037	4649	2006
10037	4649	7890
2663	4650	1922
16449	4651	4287
16449	4651	5131
15352	4652	4058
15352	4652	1277
15352	4652	2533
15352	4652	3312
10634	4653	9071
10634	4653	3802
10634	4653	9612
6921	4654	5591
6921	4654	9517
6921	4654	2290
6921	4654	8397
6921	4654	6049
14651	4655	9078
14651	4655	482
14651	4655	9844
14651	4655	6128
19858	4656	5653
19858	4656	2845
19858	4656	5774
19858	4656	7834
19858	4656	9156
19858	4656	7344
19858	4656	1486
19858	4656	6
19858	4656	718
19590	4657	3453
19590	4657	8219
19590	4657	4507
19590	4657	9509
19590	4657	7376
19590	4657	3232
19590	4657	4761
5189	4658	2717
5189	4658	5362
5189	4658	5032
5189	4658	6964
5189	4658	6589
5189	4658	5545
5189	4658	587
5189	4658	7929
4871	4659	5326
4871	4659	3247
4871	4659	4392
4871	4659	7562
4871	4659	602
4871	4659	856
4871	4659	3497
4871	4659	7521
8968	4660	8019
8968	4660	511
8968	4660	8820
8968	4660	7410
8968	4660	875
8968	4660	5482
8968	4660	8378
8968	4660	4757
4636	4661	4175
4636	4661	655
4636	4661	2889
4636	4661	6201
4636	4661	2659
4636	4661	2648
4636	4661	302
18243	4662	6518
18243	4662	897
18243	4662	8673
18243	4662	729
18243	4662	2044
18243	4662	5747
18243	4662	4801
10912	4663	3631
10912	4663	1891
10912	4663	4272
10912	4663	6967
10912	4663	7696
10912	4663	3695
10912	4663	2939
7670	4664	3110
10307	4665	3013
10307	4665	9535
10307	4665	661
10307	4665	4959
10307	4665	921
10307	4665	581
10307	4665	1387
10307	4665	9766
10307	4665	3794
13465	4666	568
7354	4667	8831
7354	4667	4063
7354	4667	4433
7354	4667	9384
7354	4667	725
3290	4668	6837
3290	4668	7511
3290	4668	1662
3290	4668	63
3290	4668	8037
3290	4668	180
3290	4668	9620
3290	4668	2280
3290	4668	5210
18543	4669	2869
18543	4669	7197
13160	4670	6544
13160	4670	449
13160	4670	8677
13160	4670	5359
13160	4670	2148
13160	4670	2474
13160	4670	1998
13160	4670	3089
16596	4671	7570
16596	4671	311
16596	4671	676
16596	4671	4030
16596	4671	4088
16596	4671	5224
16596	4671	1340
16596	4671	4686
87	4672	3438
87	4672	2259
87	4672	3322
87	4672	9713
87	4672	3645
87	4672	2065
87	4672	3439
87	4672	1651
87	4672	9883
7940	4673	4601
7940	4673	2363
7940	4673	6303
7940	4673	9330
7940	4673	76
7940	4673	6286
7940	4673	8202
15827	4674	3013
15827	4674	2539
8378	4675	9869
8378	4675	1756
8378	4675	8723
8378	4675	1102
8378	4675	5643
8378	4675	1231
8378	4675	2461
8378	4675	7738
11878	4676	3853
11878	4676	2645
10367	4677	9373
10367	4677	3032
10367	4677	5913
10367	4677	4057
10367	4677	1144
13571	4678	1757
13571	4678	8258
13571	4678	3770
13571	4678	5434
13571	4678	3218
13571	4678	3938
13571	4678	6151
18933	4679	3347
18519	4680	3894
18519	4680	8874
18519	4680	2274
18519	4680	6566
9645	4681	6720
19874	4682	5799
19874	4682	7568
19874	4682	3861
19874	4682	7262
19874	4682	3652
19874	4682	6467
722	4683	9975
722	4683	944
722	4683	9788
722	4683	1363
722	4683	7632
722	4683	2271
722	4683	8018
722	4683	6269
722	4683	4909
17540	4684	5978
17540	4684	4843
17540	4684	9577
17540	4684	2805
17540	4684	4986
17540	4684	8819
17540	4684	9319
17540	4684	3333
1927	4685	945
1927	4685	4703
1927	4685	597
1927	4685	1049
17955	4686	559
17955	4686	6803
17955	4686	9500
17955	4686	3196
4029	4687	620
4029	4687	2386
2295	4688	7928
2295	4688	2868
2295	4688	1041
2295	4688	9782
2295	4688	2893
2295	4688	3780
1165	4689	189
1165	4689	6970
1165	4689	8796
18830	4690	1953
18830	4690	7812
18830	4690	1496
18830	4690	108
18830	4690	4264
18830	4690	8278
2341	4691	4621
2341	4691	4931
2341	4691	8475
2341	4691	4988
7565	4692	3198
7565	4692	8636
12893	4693	2186
12893	4693	5658
7870	4694	5106
7870	4694	2
7870	4694	9491
7870	4694	7933
7870	4694	52
7870	4694	3409
12473	4695	195
12473	4695	5050
12473	4695	4799
12473	4695	1289
12473	4695	2815
12473	4695	3432
12473	4695	881
12473	4695	3551
12473	4695	7426
13832	4696	4881
13832	4696	6564
13832	4696	6280
13832	4696	4526
9440	4697	4714
9440	4697	7093
9440	4697	6130
9440	4697	2947
9440	4697	7805
9440	4697	3487
9440	4697	9813
9440	4697	4906
6779	4698	1924
6779	4698	998
6779	4698	8997
4323	4699	376
4323	4699	7694
4323	4699	958
4323	4699	7375
4323	4699	3385
4323	4699	7732
4323	4699	6533
4323	4699	7783
11221	4700	8319
11221	4700	7969
11221	4700	4955
18309	4701	7702
18309	4701	39
18309	4701	6970
18309	4701	9219
18309	4701	4902
5266	4702	178
5266	4702	7492
5266	4702	2868
5266	4702	5483
5266	4702	9070
5266	4702	503
10684	4703	425
10684	4703	9046
10684	4703	6276
10684	4703	1460
10684	4703	359
10684	4703	8098
10684	4703	8994
10684	4703	5935
10684	4703	4831
15397	4704	8885
15397	4704	1351
15397	4704	8838
15397	4704	4729
15397	4704	1311
15397	4704	2895
15397	4704	5616
15397	4704	6371
13460	4705	6611
13460	4705	335
13460	4705	1602
8037	4706	1918
8037	4706	6529
10731	4707	7380
10731	4707	1015
10731	4707	6703
10731	4707	9444
10731	4707	3706
10731	4707	9804
12828	4708	8958
12828	4708	2368
12828	4708	5193
12828	4708	6643
12828	4708	6978
12828	4708	380
12828	4708	8537
11833	4709	6191
11833	4709	1620
11833	4709	1540
11833	4709	9741
11833	4709	2469
4082	4710	3216
4082	4710	1643
4082	4710	1409
4082	4710	5519
4082	4710	1457
4082	4710	6499
4082	4710	1314
6152	4711	1542
6152	4711	7733
14947	4712	4082
14947	4712	6918
14947	4712	8895
14947	4712	4071
14947	4712	8541
8118	4713	9957
2539	4714	4346
2539	4714	8280
2539	4714	3382
2539	4714	8968
2539	4714	3485
2539	4714	666
15167	4715	7716
15167	4715	5004
15167	4715	5010
15167	4715	315
15167	4715	4106
8755	4716	558
17674	4717	4849
17674	4717	5546
17674	4717	4130
17674	4717	5901
17674	4717	3796
17674	4717	4169
17674	4717	891
17674	4717	7767
17674	4717	2999
14207	4718	1481
14207	4718	4090
14207	4718	5777
14207	4718	876
11449	4719	4058
11449	4719	1979
11449	4719	2119
11449	4719	1319
11449	4719	7285
11449	4719	5458
16912	4720	5560
16912	4720	6898
16912	4720	1377
14306	4721	4701
14306	4721	5678
14306	4721	7439
14306	4721	5404
14306	4721	9694
14306	4721	5190
14306	4721	3808
14306	4721	3221
14306	4721	7526
1316	4722	2143
1316	4722	321
1316	4722	2100
7102	4723	5223
7102	4723	8359
7102	4723	4765
7102	4723	2078
7102	4723	1284
10184	4724	4358
10184	4724	21
10184	4724	7924
10184	4724	5361
10184	4724	5346
10184	4724	3585
10184	4724	5081
10184	4724	997
12438	4725	8880
12438	4725	1748
12438	4725	8684
12438	4725	8225
12438	4725	8124
12438	4725	2844
12438	4725	5232
12438	4725	4561
19843	4726	5603
19843	4726	9889
19843	4726	1061
1375	4727	8674
1375	4727	8802
1375	4727	6941
1375	4727	3453
1375	4727	1638
8963	4728	7345
8963	4728	1518
8963	4728	8540
8963	4728	6886
8963	4728	1544
8963	4728	4825
8963	4728	7659
8963	4728	3292
3930	4729	2386
3930	4729	802
3930	4729	2852
11964	4730	4344
11964	4730	93
17264	4731	2774
17264	4731	2367
17264	4731	4749
17264	4731	7538
17264	4731	4788
17264	4731	6
4783	4732	8231
4783	4732	8610
4783	4732	2054
4783	4732	7120
4783	4732	9795
4783	4732	2260
5719	4733	5003
5719	4733	6216
5719	4733	6486
5719	4733	7792
5719	4733	5805
5719	4733	6807
5719	4733	189
5719	4733	7344
11907	4734	1483
11907	4734	4551
11907	4734	8394
11907	4734	9779
11907	4734	9669
11907	4734	2855
11907	4734	332
11907	4734	4423
4429	4735	12
4429	4735	9801
4429	4735	4924
4429	4735	8618
4429	4735	3098
4429	4735	9175
4429	4735	3864
4429	4735	5858
11273	4736	9509
19682	4737	6658
19682	4737	1511
19682	4737	9868
19682	4737	9645
19682	4737	1721
19682	4737	6813
19682	4737	5591
19682	4737	3019
19682	4737	4491
697	4738	5985
697	4738	9228
697	4738	4981
697	4738	5334
697	4738	3398
697	4738	4639
697	4738	6740
697	4738	6431
697	4738	4175
1974	4739	897
1974	4739	1307
1974	4739	8391
1974	4739	5736
1974	4739	8822
1974	4739	3162
16286	4740	1542
16286	4740	4540
16286	4740	457
13774	4741	5039
13774	4741	5847
13774	4741	5157
13774	4741	5037
13774	4741	2131
15734	4742	9588
15734	4742	3130
15734	4742	2260
15734	4742	9350
15734	4742	827
2566	4743	8170
6416	4744	6736
6416	4744	8118
497	4745	8115
497	4745	4407
497	4745	271
497	4745	4505
497	4745	2816
497	4745	6331
497	4745	7744
497	4745	4925
497	4745	6979
5012	4746	3880
5012	4746	3790
5012	4746	4810
5012	4746	2245
5012	4746	6180
5012	4746	6161
5012	4746	8062
5132	4747	6420
8326	4748	7075
8326	4748	2599
8326	4748	1087
8326	4748	5
8326	4748	1938
8326	4748	6963
8326	4748	648
8326	4748	6754
8326	4748	9567
15258	4749	195
15258	4749	6472
15258	4749	3596
15258	4749	778
15258	4749	556
6308	4750	2054
6308	4750	9832
6308	4750	4467
6308	4750	738
6308	4750	6002
11138	4751	3198
11138	4751	4888
11138	4751	8054
11138	4751	8
11138	4751	2412
11138	4751	6848
11138	4751	8637
11138	4751	6121
11138	4751	5493
10649	4752	2119
10649	4752	9558
10649	4752	394
10649	4752	3690
13774	4753	280
13774	4753	7100
13774	4753	249
13774	4753	1072
13774	4753	2477
13774	4753	7723
6429	4754	8539
6429	4754	3434
6429	4754	1840
6429	4754	8778
6429	4754	4491
6429	4754	3031
6429	4754	9354
6429	4754	1082
6429	4754	2176
4848	4755	9520
14484	4756	457
14484	4756	8702
14484	4756	4475
14484	4756	9652
14484	4756	5128
14484	4756	8547
14484	4756	895
14484	4756	4960
14484	4756	5153
14657	4757	9753
14657	4757	792
14657	4757	2081
14657	4757	6514
14657	4757	1202
14657	4757	6383
14657	4757	5964
14657	4757	2039
14657	4757	7171
11434	4758	7294
11434	4758	5187
11434	4758	7785
11434	4758	9775
11434	4758	4869
11322	4759	7152
11322	4759	6846
11322	4759	2281
11322	4759	8257
11322	4759	4085
11322	4759	3860
15808	4760	2843
15808	4760	5986
15808	4760	6712
15808	4760	3098
15932	4761	3627
15932	4761	5696
15932	4761	122
15932	4761	9131
15932	4761	5769
15932	4761	648
15932	4761	7682
15932	4761	1108
15932	4761	2411
10506	4762	3282
10506	4762	9140
10506	4762	5541
10506	4762	4345
10506	4762	4612
614	4763	2848
614	4763	8887
614	4763	5268
614	4763	8470
614	4763	4041
614	4763	8091
14951	4764	2846
3971	4765	6902
3971	4765	6148
3971	4765	3682
3971	4765	1820
3971	4765	8995
15763	4766	7415
15763	4766	8527
15763	4766	1332
15763	4766	7907
15763	4766	4093
15763	4766	8989
16089	4767	2640
16089	4767	1673
16089	4767	7338
16089	4767	1299
16089	4767	7785
16089	4767	3826
14219	4768	8864
14219	4768	7044
14219	4768	8816
14219	4768	9184
14219	4768	4562
14219	4768	9846
17537	4769	4593
17537	4769	7644
17537	4769	2149
17537	4769	1088
17537	4769	9235
17537	4769	8029
17537	4769	2023
17537	4769	2997
80	4770	4990
80	4770	5624
80	4770	8439
9310	4771	3512
9310	4771	625
9310	4771	762
9310	4771	97
18663	4772	6740
19471	4773	9775
19471	4773	9051
19471	4773	1019
19471	4773	4316
19471	4773	145
19471	4773	4112
15246	4774	8778
15246	4774	252
15246	4774	5824
15246	4774	8206
15246	4774	3691
15246	4774	1371
15246	4774	4681
8911	4775	9220
8911	4775	6186
12660	4776	712
12660	4776	4004
12660	4776	895
12660	4776	7900
12660	4776	1657
12660	4776	4103
15586	4777	3918
15586	4777	8720
15586	4777	3943
15586	4777	7889
15586	4777	3327
15586	4777	6697
15586	4777	404
2232	4778	5041
2232	4778	8763
2232	4778	8712
2232	4778	6662
2232	4778	281
2232	4778	607
9050	4779	903
9050	4779	9883
9050	4779	1681
9050	4779	2865
9050	4779	8806
9050	4779	1634
9050	4779	4384
9050	4779	6764
9050	4779	5871
9164	4780	7396
9164	4780	1995
9164	4780	1314
9164	4780	2528
9164	4780	2012
9164	4780	4408
9164	4780	2220
9164	4780	5104
9164	4780	4465
12198	4781	4405
12198	4781	2160
12198	4781	6981
5849	4782	9150
5849	4782	255
5849	4782	8186
396	4783	2092
14392	4784	1105
14392	4784	7411
3630	4785	2090
3630	4785	1286
3630	4785	7156
3630	4785	9199
3630	4785	376
3630	4785	6768
3630	4785	2236
16894	4786	6879
788	4787	2262
788	4787	4948
788	4787	1263
788	4787	3628
788	4787	6430
788	4787	298
788	4787	9747
788	4787	9890
788	4787	8950
2371	4788	9633
2371	4788	8292
2371	4788	4379
2371	4788	6904
2371	4788	5489
2371	4788	5864
2371	4788	6031
19317	4789	4572
19317	4789	2648
19317	4789	272
19317	4789	4439
19317	4789	9194
19317	4789	407
19317	4789	562
19317	4789	2623
19317	4789	6549
6906	4790	2619
17297	4791	8307
17297	4791	2811
17297	4791	7657
17297	4791	7196
3270	4792	4756
3270	4792	6156
3270	4792	7595
3270	4792	4170
3270	4792	5779
3270	4792	7597
3270	4792	38
2303	4793	4899
2303	4793	1761
2303	4793	48
2303	4793	3167
2303	4793	7346
8991	4794	2052
8991	4794	8951
8991	4794	3281
8991	4794	3790
2773	4795	1601
2773	4795	3670
2773	4795	1607
6735	4796	2785
6735	4796	4924
6735	4796	604
6735	4796	4626
6735	4796	7436
6735	4796	3454
6735	4796	6324
227	4797	1500
227	4797	4507
16352	4798	6745
16352	4798	5750
16352	4798	8876
7599	4799	7602
7599	4799	2019
7599	4799	9967
12581	4800	6404
15806	4801	1003
15806	4801	5601
15806	4801	5208
15806	4801	5761
15806	4801	5366
15806	4801	9492
15806	4801	8436
12073	4802	1074
12073	4802	8389
12073	4802	7703
8213	4803	2009
8213	4803	3772
8213	4803	3471
8213	4803	7577
8213	4803	1717
8213	4803	9636
18254	4804	7283
18254	4804	2445
18254	4804	8726
18254	4804	142
18254	4804	6016
18254	4804	7710
12612	4805	6952
12612	4805	6972
12612	4805	8934
12612	4805	9099
17468	4806	7861
17468	4806	2267
17468	4806	8456
17468	4806	3873
17468	4806	8229
17468	4806	4296
4011	4807	8311
4011	4807	7770
4011	4807	9039
4011	4807	5684
9564	4808	3516
9564	4808	3032
9564	4808	9002
9564	4808	6520
9564	4808	9
9564	4808	4639
9564	4808	4407
12532	4809	76
12532	4809	5646
12532	4809	4512
12532	4809	2586
12532	4809	2655
12532	4809	4977
16985	4810	9869
16985	4810	7377
14772	4811	5624
14772	4811	7664
14772	4811	7454
14772	4811	4273
14772	4811	7853
14772	4811	5374
14772	4811	4601
14772	4811	2560
15073	4812	6029
15073	4812	959
15073	4812	2800
15073	4812	2286
15073	4812	5722
15073	4812	5621
15073	4812	255
15073	4812	9449
7443	4813	3639
7443	4813	2106
7443	4813	8568
7443	4813	5496
7443	4813	2202
7443	4813	7280
7443	4813	195
7443	4813	4128
7443	4813	6574
4590	4814	3639
4590	4814	8791
4590	4814	3442
4590	4814	6809
4590	4814	419
5047	4815	7189
5047	4815	6253
5047	4815	8211
5047	4815	7620
5047	4815	1770
5047	4815	1400
5047	4815	8160
5047	4815	639
8555	4816	7365
8555	4816	6260
8555	4816	1492
8555	4816	4620
8555	4816	9201
8555	4816	8630
9764	4817	8414
9764	4817	4105
9764	4817	5145
9764	4817	8528
9764	4817	6790
9764	4817	6945
12637	4818	9133
1249	4819	1402
1249	4819	2908
1249	4819	7690
1249	4819	4913
1249	4819	6096
1249	4819	6866
1249	4819	3511
1249	4819	5705
1249	4819	5315
4519	4820	8578
4519	4820	5455
4519	4820	660
4519	4820	8335
4519	4820	36
5886	4821	3339
5886	4821	5217
4166	4822	4093
4166	4822	3553
9514	4823	9404
9514	4823	9145
9514	4823	7955
9514	4823	5294
10658	4824	8272
10658	4824	8371
10658	4824	468
10658	4824	1044
10658	4824	5671
10658	4824	9989
7082	4825	8298
7082	4825	7755
7082	4825	1083
7082	4825	2560
15705	4826	3182
15705	4826	5887
15705	4826	7138
15705	4826	3063
15705	4826	7845
15705	4826	6079
15705	4826	4784
15705	4826	3279
15705	4826	9608
15811	4827	5607
15811	4827	9299
15811	4827	3407
17462	4828	80
17462	4828	652
17462	4828	5409
17462	4828	4823
17462	4828	7821
17462	4828	6770
17462	4828	6968
17462	4828	3404
17462	4828	2498
11572	4829	156
7125	4830	2294
7125	4830	3469
7125	4830	2166
7125	4830	9590
8823	4831	5313
8823	4831	8259
8823	4831	7645
8823	4831	8855
8823	4831	9711
8823	4831	5928
12167	4832	9646
12167	4832	5943
18822	4833	3531
18822	4833	6411
18822	4833	8312
18822	4833	7019
18822	4833	4835
18822	4833	5904
18822	4833	6938
18822	4833	2622
17098	4834	4633
17098	4834	3189
18263	4835	8542
18263	4835	7880
18263	4835	4428
18263	4835	3436
18263	4835	1528
18263	4835	6363
18263	4835	5731
18263	4835	8842
18263	4835	7026
10238	4836	6635
10238	4836	2840
10238	4836	8921
10238	4836	8955
10238	4836	4257
10238	4836	5665
183	4837	2831
183	4837	3458
183	4837	4316
6314	4838	4619
6314	4838	3604
6314	4838	7295
6314	4838	9273
6314	4838	61
6314	4838	5348
6314	4838	3331
6314	4838	6511
12157	4839	9082
12157	4839	6120
12157	4839	1109
12157	4839	1727
12157	4839	3592
12157	4839	1053
12157	4839	4752
12157	4839	2841
4227	4840	307
4227	4840	3970
4227	4840	7131
4227	4840	2631
4227	4840	6559
11280	4841	8179
11280	4841	3590
11280	4841	7310
16725	4842	3019
16725	4842	285
16725	4842	346
16725	4842	2868
16725	4842	9992
16725	4842	4289
16725	4842	7317
16725	4842	5994
6059	4843	6185
6059	4843	7010
6059	4843	7599
2169	4844	9323
2169	4844	580
2169	4844	3613
12961	4845	3317
12961	4845	9186
10358	4846	8209
10358	4846	3688
1394	4847	5017
1394	4847	399
1394	4847	3470
1394	4847	3398
1394	4847	9327
1394	4847	4974
1394	4847	3491
1394	4847	3460
1394	4847	2415
10396	4848	6617
10396	4848	5972
15376	4849	7002
15376	4849	5715
15376	4849	3715
15376	4849	7121
15376	4849	3234
16414	4850	4757
16414	4850	4421
16414	4850	3949
16414	4850	2370
16414	4850	3810
16414	4850	7805
16414	4850	9291
583	4851	6309
583	4851	1871
583	4851	7719
583	4851	7136
583	4851	5438
6562	4852	4585
6562	4852	1087
6562	4852	5152
6562	4852	305
16218	4853	6339
16218	4853	2024
16665	4854	8356
16665	4854	1544
16665	4854	6365
11047	4855	9439
11047	4855	8911
11047	4855	3378
11047	4855	3982
11047	4855	3023
11047	4855	1792
16259	4856	7289
9964	4857	395
9964	4857	2357
9964	4857	9735
9964	4857	2282
9964	4857	4725
9964	4857	4842
9964	4857	2246
12454	4858	2650
1610	4859	984
18989	4860	6361
17434	4861	7823
17434	4861	2813
17434	4861	5249
14989	4862	3721
14989	4862	4600
14989	4862	1469
14989	4862	7176
16318	4863	7653
16318	4863	6993
16318	4863	982
16318	4863	2731
16318	4863	2893
16318	4863	5756
2008	4864	8498
2008	4864	3162
2008	4864	7009
2008	4864	8590
2008	4864	4845
2008	4864	1768
2008	4864	3924
2008	4864	9054
2008	4864	664
3290	4865	3873
3290	4865	8873
3290	4865	4720
3290	4865	632
3290	4865	1255
3290	4865	7313
3290	4865	1348
3290	4865	2178
14044	4866	9412
14044	4866	8735
14044	4866	1203
14044	4866	4511
14044	4866	1043
9830	4867	4543
9830	4867	5957
9830	4867	2447
9830	4867	4303
11302	4868	5589
11302	4868	827
11302	4868	1443
11302	4868	917
4238	4869	8912
4238	4869	3846
4238	4869	5533
149	4870	5249
149	4870	1177
149	4870	65
149	4870	5202
1580	4871	2080
1580	4871	7673
1580	4871	2640
1580	4871	5115
1580	4871	9588
1580	4871	2832
1580	4871	8050
12115	4872	23
12115	4872	5091
12115	4872	3237
12115	4872	4003
12115	4872	9298
637	4873	2781
637	4873	4305
18839	4874	3446
18839	4874	5114
4078	4875	6824
4078	4875	953
4078	4875	8773
4078	4875	7069
4078	4875	2628
4078	4875	3386
4078	4875	6685
18930	4876	4885
18930	4876	6888
18930	4876	921
18930	4876	2984
18930	4876	1827
18930	4876	8073
18930	4876	9079
62	4877	4221
62	4877	8502
62	4877	244
62	4877	8705
62	4877	3318
62	4877	6393
2555	4878	3796
2555	4878	6556
2555	4878	6662
2555	4878	8591
2555	4878	7762
2555	4878	9630
12878	4879	317
12878	4879	8768
14943	4880	9340
14943	4880	4613
14943	4880	5159
14943	4880	4899
2910	4881	9838
2910	4881	6342
11941	4882	2409
11941	4882	1611
11941	4882	1698
11941	4882	3286
11941	4882	7849
11941	4882	6673
11941	4882	4656
11941	4882	5864
11941	4882	5605
1102	4883	2159
1102	4883	8826
1102	4883	9654
1102	4883	4470
1102	4883	509
4237	4884	2497
4237	4884	8946
4237	4884	3664
4237	4884	7534
4237	4884	6904
4237	4884	8135
13808	4885	1406
13808	4885	8432
13808	4885	3717
13808	4885	1049
13808	4885	52
13808	4885	5066
9338	4886	7559
9338	4886	6517
9338	4886	5757
9338	4886	9542
9338	4886	7447
9338	4886	5168
16452	4887	3443
16452	4887	6217
16452	4887	4500
16452	4887	5347
16452	4887	8822
16452	4887	9326
1037	4888	658
1037	4888	3861
1037	4888	9234
13360	4889	8287
13360	4889	2467
13360	4889	1646
13360	4889	2684
14366	4890	1734
14366	4890	8827
14366	4890	6447
14366	4890	1578
14366	4890	6545
14366	4890	298
14366	4890	8648
14366	4890	3809
9775	4891	547
9775	4891	767
9775	4891	339
9775	4891	54
9775	4891	633
4733	4892	3425
10004	4893	7236
11768	4894	3606
11768	4894	200
11768	4894	1227
11768	4894	9997
11768	4894	2938
5983	4895	8173
5983	4895	8442
5983	4895	6212
5983	4895	2879
5983	4895	6868
5983	4895	1864
6735	4896	8680
6735	4896	1806
6735	4896	9161
6735	4896	9625
6735	4896	5026
937	4897	6544
937	4897	8798
937	4897	1028
7812	4898	7475
7812	4898	7822
7812	4898	1005
7812	4898	7107
17824	4899	1945
13939	4900	7438
13939	4900	2447
13939	4900	27
13939	4900	8965
13939	4900	6253
13939	4900	4960
13939	4900	9533
13939	4900	9664
13939	4900	4465
3142	4901	483
3142	4901	7127
3142	4901	7101
3142	4901	9397
3142	4901	6058
3142	4901	4150
8351	4902	5229
8351	4902	5594
8351	4902	8028
8351	4902	2622
8351	4902	2482
8351	4902	8360
8351	4902	8658
8351	4902	4209
8351	4902	7627
9453	4903	2575
13448	4904	899
13448	4904	8390
13448	4904	8492
13448	4904	6316
13448	4904	9111
13448	4904	4211
13448	4904	6024
13448	4904	9236
6890	4905	4781
6890	4905	3636
6890	4905	6351
6890	4905	7201
6890	4905	2934
6890	4905	2758
6890	4905	2435
6890	4905	9960
6890	4905	5131
8482	4906	5833
8482	4906	4228
11021	4907	4420
11021	4907	5123
11021	4907	6255
11021	4907	4264
11021	4907	5620
11021	4907	3399
11021	4907	1030
11021	4907	9524
11021	4907	6760
8412	4908	5863
8412	4908	3709
8412	4908	9795
16616	4909	1601
15711	4910	1311
15711	4910	9535
15711	4910	9951
18950	4911	4129
18950	4911	1508
18950	4911	1289
18950	4911	7751
18950	4911	7460
18950	4911	4621
18950	4911	5853
14908	4912	5309
14908	4912	3490
6049	4913	3588
6049	4913	5415
6049	4913	9172
6049	4913	3955
6049	4913	2568
6049	4913	8049
11015	4914	8567
11015	4914	8840
11015	4914	1169
11015	4914	2798
11015	4914	1716
15409	4915	3645
15409	4915	6294
15409	4915	8039
15409	4915	8603
2341	4916	1488
2341	4916	9699
2341	4916	2336
2341	4916	3065
8467	4917	711
8467	4917	8995
8467	4917	7895
3079	4918	599
3079	4918	9988
3079	4918	1235
3079	4918	372
3079	4918	323
43	4919	8287
43	4919	9455
43	4919	8507
43	4919	906
43	4919	8121
43	4919	3024
43	4919	8205
43	4919	7555
16305	4920	7354
16305	4920	1896
16305	4920	8354
16305	4920	9584
16305	4920	2240
16305	4920	2579
4066	4921	9964
4066	4921	2787
4066	4921	9528
4066	4921	4099
3306	4922	9806
3306	4922	8605
3306	4922	5674
8055	4923	8326
8055	4923	5259
8055	4923	5483
8055	4923	2937
8055	4923	3894
13362	4924	2491
13362	4924	1095
13362	4924	6734
13362	4924	2394
1997	4925	1498
1997	4925	3726
1997	4925	3049
1997	4925	9173
1997	4925	2954
1997	4925	8631
1997	4925	8861
1997	4925	8789
1997	4925	9206
3392	4926	1250
3392	4926	5385
3392	4926	8125
3392	4926	4642
3392	4926	9107
3392	4926	405
3392	4926	356
19056	4927	4183
19056	4927	3724
19056	4927	2917
19056	4927	5737
19056	4927	2283
19056	4927	3818
19056	4927	8943
19056	4927	8721
13691	4928	8669
13691	4928	9493
13691	4928	5674
13691	4928	2527
8576	4929	4680
8576	4929	6601
8576	4929	4626
8576	4929	9718
7071	4930	8603
7071	4930	7400
7071	4930	9610
16556	4931	7351
19755	4932	4166
19755	4932	2939
19755	4932	710
19755	4932	6442
19755	4932	1876
19755	4932	2245
19755	4932	9695
19755	4932	9077
19755	4932	9052
17323	4933	6940
17323	4933	6434
17323	4933	1238
17323	4933	4168
17323	4933	5821
17323	4933	39
1497	4934	6084
1497	4934	9778
1497	4934	6177
1497	4934	4616
7335	4935	2329
7335	4935	9654
7335	4935	926
7335	4935	3558
15450	4936	6057
15450	4936	7106
15450	4936	4392
15450	4936	6852
15450	4936	5574
15450	4936	8804
15450	4936	6101
15450	4936	7004
17464	4937	8070
17464	4937	8682
17464	4937	2989
17464	4937	1158
17464	4937	9964
17464	4937	3863
17464	4937	8407
17464	4937	9254
17464	4937	6370
3887	4938	3694
3887	4938	5496
5162	4939	1995
5162	4939	6853
5162	4939	6494
5162	4939	2915
5162	4939	5356
5162	4939	2414
5162	4939	8899
5162	4939	186
5162	4939	3619
13784	4940	8969
13784	4940	5829
13784	4940	2889
13784	4940	7045
13784	4940	8484
13784	4940	9815
13784	4940	9716
5261	4941	5509
8814	4942	2560
8814	4942	6490
8814	4942	7703
8814	4942	3811
8814	4942	7179
8814	4942	1135
8814	4942	8173
8814	4942	2384
8814	4942	7218
13866	4943	9563
13866	4943	7701
13866	4943	8838
13866	4943	9479
13866	4943	7386
13866	4943	6842
13866	4943	8855
5331	4944	2305
5331	4944	6108
5331	4944	528
5331	4944	7133
5331	4944	688
5331	4944	4679
8483	4945	9313
8483	4945	1444
8483	4945	6526
8483	4945	828
19365	4946	2348
19365	4946	7606
7426	4947	2204
7426	4947	9749
8854	4948	8668
8854	4948	1671
8854	4948	4239
8854	4948	6771
8854	4948	1942
8854	4948	4132
8854	4948	7281
19256	4949	4280
19256	4949	7528
19256	4949	4648
19256	4949	1669
6107	4950	731
6107	4950	8450
6107	4950	5471
6107	4950	5514
6107	4950	3453
15170	4951	9628
15170	4951	6748
15170	4951	2124
15170	4951	3441
15170	4951	435
15170	4951	9382
15170	4951	2484
2612	4952	8796
2612	4952	8289
2612	4952	7846
2612	4952	6508
2612	4952	1258
2612	4952	8883
17021	4953	9307
5495	4954	835
5495	4954	3780
17872	4955	4824
17872	4955	6692
9074	4956	5836
9074	4956	540
9074	4956	1530
9074	4956	3229
5071	4957	5283
5071	4957	7137
5071	4957	3248
5071	4957	9435
5071	4957	9852
9350	4958	7787
9350	4958	834
9350	4958	9356
9350	4958	2873
9350	4958	1388
9350	4958	3901
16242	4959	3582
16242	4959	5009
16242	4959	8550
16242	4959	1634
16242	4959	6329
11869	4960	2232
11869	4960	4682
11869	4960	8647
11869	4960	9735
11869	4960	3932
11869	4960	5922
11869	4960	5738
11869	4960	5953
11869	4960	8103
6223	4961	1368
6223	4961	1856
6223	4961	3371
6223	4961	3631
11725	4962	8928
11725	4962	2135
11725	4962	3643
11725	4962	9784
11725	4962	3899
11725	4962	3085
11725	4962	8410
11725	4962	9386
19275	4963	1523
19275	4963	3362
19275	4963	3354
19275	4963	4423
19275	4963	2855
19275	4963	4868
14004	4964	3068
14004	4964	3228
14004	4964	5750
14004	4964	6817
12404	4965	5839
12404	4965	7462
1647	4966	7817
1647	4966	5068
1647	4966	4575
1647	4966	2454
1647	4966	6937
1647	4966	8259
1647	4966	3127
1647	4966	6971
7574	4967	9989
7574	4967	7091
7574	4967	6412
7574	4967	3190
7574	4967	5376
6384	4968	3864
6384	4968	4659
6384	4968	1291
6384	4968	9215
6384	4968	1600
17140	4969	2357
17140	4969	4127
17140	4969	5173
17140	4969	8173
17140	4969	5769
17140	4969	2941
17140	4969	6806
17140	4969	4337
16399	4970	4516
16399	4970	3572
10343	4971	3742
10343	4971	6327
10343	4971	1539
10343	4971	8443
10343	4971	1670
10343	4971	8295
10343	4971	7978
9565	4972	3709
9565	4972	1118
9565	4972	3125
13393	4973	1868
13393	4973	196
13393	4973	2725
8528	4974	976
18540	4975	505
18540	4975	9524
18540	4975	7583
18540	4975	5484
18540	4975	2561
17602	4976	1502
17602	4976	9134
17602	4976	2780
17602	4976	8220
10388	4977	3838
10388	4977	6368
10388	4977	6140
10388	4977	4583
10388	4977	1208
10388	4977	8895
10388	4977	865
10395	4978	8895
16058	4979	9888
12021	4980	3108
12021	4980	1073
12021	4980	624
12021	4980	6348
12021	4980	2875
12021	4980	7370
12021	4980	4246
12021	4980	3224
12021	4980	3432
4653	4981	356
4653	4981	8478
4653	4981	367
4653	4981	6253
4653	4981	3192
4653	4981	7940
4653	4981	8836
4653	4981	1476
8701	4982	6119
8701	4982	9373
5608	4983	5131
5608	4983	4599
5608	4983	6751
5608	4983	5729
5608	4983	6594
5608	4983	4351
5608	4983	1342
354	4984	5360
354	4984	9875
354	4984	5760
354	4984	5079
354	4984	5337
16316	4985	6217
16316	4985	8553
16316	4985	5956
5098	4986	2334
5098	4986	6724
5098	4986	7781
5098	4986	1908
3565	4987	7776
3565	4987	3090
3565	4987	7922
3565	4987	1270
3565	4987	4093
3565	4987	9083
3565	4987	453
3565	4987	6925
6374	4988	791
6374	4988	6304
6374	4988	9271
6374	4988	1712
6374	4988	9994
6374	4988	9426
6374	4988	9263
6374	4988	882
6374	4988	3542
15267	4989	278
15267	4989	7507
15267	4989	627
11194	4990	7291
11194	4990	9751
2924	4991	4410
2924	4991	7291
2924	4991	9971
2924	4991	856
2924	4991	323
2924	4991	1146
2924	4991	6710
2924	4991	50
2924	4991	8626
18031	4992	195
18031	4992	5642
18031	4992	125
18031	4992	1408
11634	4993	9489
11634	4993	155
955	4994	437
974	4995	1164
14873	4996	1000
14873	4996	9443
14873	4996	9959
14873	4996	9279
14873	4996	6668
14873	4996	6633
14873	4996	469
14873	4996	6499
14873	4996	7265
15403	4997	8189
15403	4997	1747
2097	4998	546
2097	4998	6645
13205	4999	1253
13205	4999	3077
13205	4999	3662
13205	4999	4673
13205	4999	3106
13205	4999	1244
13205	4999	9639
13205	4999	4364
12221	5000	7159
12221	5000	6078
12221	5000	1753
12221	5000	7692
15441	5001	5549
15441	5001	4398
15441	5001	7568
15441	5001	3244
8400	5002	2745
8400	5002	582
8959	5003	9056
11278	5004	2250
11278	5004	9382
9859	5005	8823
9859	5005	6815
9859	5005	9889
9859	5005	6267
9859	5005	3012
9859	5005	2330
9859	5005	4188
19285	5006	8686
19285	5006	2768
19285	5006	1816
19285	5006	5827
19285	5006	7477
19285	5006	6127
19285	5006	6541
6712	5007	4667
6712	5007	6754
6712	5007	2292
6712	5007	1272
6712	5007	1278
6712	5007	6122
9615	5008	869
9615	5008	4259
9615	5008	7702
9615	5008	5680
9615	5008	4856
9615	5008	8777
9615	5008	5577
9615	5008	7410
9615	5008	9074
2731	5009	7845
2731	5009	8538
2731	5009	9057
2731	5009	8774
2731	5009	4254
2731	5009	250
2731	5009	6337
2731	5009	247
2731	5009	1779
1110	5010	6347
1110	5010	56
1110	5010	7861
1110	5010	6785
1110	5010	7170
1110	5010	5628
1110	5010	8596
1110	5010	719
1110	5010	8430
17358	5011	6630
17358	5011	5362
17358	5011	8833
17358	5011	8964
10620	5012	730
10620	5012	7443
10620	5012	7787
10620	5012	2144
10620	5012	319
10620	5012	8098
10620	5012	8108
10620	5012	6010
10620	5012	5206
3672	5013	244
3672	5013	3423
3672	5013	7178
3672	5013	4517
10493	5014	2761
10493	5014	4355
10493	5014	3880
10493	5014	5643
10493	5014	5711
10493	5014	8505
10493	5014	8867
10493	5014	1215
10493	5014	5546
11579	5015	4997
11579	5015	7410
11579	5015	9670
11579	5015	4760
11579	5015	9453
7614	5016	8480
7614	5016	8670
7614	5016	1817
7614	5016	5912
7614	5016	884
7614	5016	8013
7614	5016	1564
16116	5017	1730
16116	5017	6728
16116	5017	862
16116	5017	3747
16116	5017	9007
16116	5017	4121
16116	5017	3253
3844	5018	9096
3844	5018	1997
19	5019	9176
19	5019	9449
2357	5020	2577
2357	5020	4056
2357	5020	5244
18727	5021	1964
18727	5021	8058
18727	5021	5303
18727	5021	1456
18727	5021	7132
18727	5021	7309
12969	5022	9402
12969	5022	3303
11759	5023	2203
11759	5023	7691
11759	5023	3006
11759	5023	1222
11759	5023	6173
2951	5024	8775
2951	5024	6463
2951	5024	7102
2951	5024	2569
2951	5024	1262
9128	5025	444
9128	5025	2474
9128	5025	7482
9128	5025	7732
9128	5025	2348
9128	5025	5456
9128	5025	8233
9128	5025	9995
17540	5026	4854
14844	5027	9392
14844	5027	5783
12451	5028	8872
12451	5028	2350
9393	5029	3217
9393	5029	1273
11259	5030	6449
11259	5030	2013
11259	5030	4257
11259	5030	7625
11259	5030	8475
11259	5030	8478
11259	5030	9632
17006	5031	5106
17006	5031	7417
17006	5031	2029
6601	5032	8930
6601	5032	9590
6601	5032	2660
13832	5033	564
13832	5033	2815
13832	5033	4872
13832	5033	6188
13832	5033	949
13832	5033	7963
13832	5033	9420
13832	5033	6718
13832	5033	6012
19712	5034	5681
19712	5034	9056
19712	5034	5270
19712	5034	5256
11638	5035	4860
11638	5035	5508
11638	5035	280
16485	5036	3622
16485	5036	1399
16485	5036	400
16485	5036	9489
16485	5036	9823
16485	5036	8145
16485	5036	3509
16485	5036	9717
16485	5036	6895
14119	5037	2096
14119	5037	491
14119	5037	4989
14119	5037	618
14119	5037	975
14119	5037	6728
14119	5037	3872
14119	5037	8519
14119	5037	1604
19497	5038	3163
19497	5038	803
10771	5039	4829
10771	5039	8458
10771	5039	1587
10771	5039	6342
10771	5039	945
10771	5039	6443
10771	5039	9689
10771	5039	4800
10771	5039	3675
4409	5040	4243
4409	5040	707
4409	5040	9371
4409	5040	430
10516	5041	577
10516	5041	9437
10516	5041	9488
10516	5041	4234
10516	5041	8054
10516	5041	6245
19838	5042	2123
19838	5042	2448
19838	5042	4724
19838	5042	1410
19838	5042	761
19838	5042	580
19838	5042	7098
19838	5042	4284
7439	5043	4101
7439	5043	8979
7439	5043	2747
9751	5044	3554
9751	5044	9675
9751	5044	3630
9751	5044	9155
19830	5045	8208
19830	5045	5347
19830	5045	1652
19830	5045	6211
19830	5045	1957
19830	5045	5068
19830	5045	2465
19830	5045	6158
19830	5045	2689
12485	5046	2244
12485	5046	5811
8604	5047	3373
8604	5047	8090
8604	5047	2011
8604	5047	7627
19166	5048	518
13351	5049	7975
13351	5049	7796
78	5050	1436
78	5050	1734
78	5050	78
78	5050	2268
78	5050	3825
78	5050	7908
78	5050	2501
2064	5051	2029
2064	5051	8228
12405	5052	2741
12405	5052	3193
12405	5052	9759
2985	5053	6598
2985	5053	5682
2985	5053	3924
2985	5053	1874
2985	5053	7479
2985	5053	7456
2985	5053	4461
5377	5054	8891
5377	5054	4738
15861	5055	2560
15861	5055	4266
15861	5055	8056
7475	5056	7326
7475	5056	9929
7475	5056	6068
7475	5056	7224
6897	5057	5032
6897	5057	7538
6897	5057	3738
6897	5057	7700
6897	5057	3326
6897	5057	7382
6897	5057	195
19552	5058	3281
19552	5058	2897
19552	5058	1304
19552	5058	594
19552	5058	9492
19552	5058	1976
19552	5058	4312
19552	5058	4813
19552	5058	6777
8951	5059	4735
8951	5059	3318
8951	5059	8210
8951	5059	4705
8951	5059	1509
8951	5059	3885
10377	5060	3716
10377	5060	9250
7124	5061	5412
15626	5062	3540
15626	5062	7093
15626	5062	3613
15626	5062	8628
272	5063	4542
272	5063	1759
272	5063	9287
272	5063	772
272	5063	1166
272	5063	2098
15018	5064	5322
15018	5064	9971
15018	5064	5972
15018	5064	5719
15018	5064	2367
15018	5064	7903
8411	5065	1704
8411	5065	6934
8411	5065	8857
8411	5065	9526
8411	5065	4045
8411	5065	3886
8411	5065	9133
8411	5065	6416
8411	5065	4512
968	5066	69
968	5066	3379
968	5066	870
968	5066	2177
968	5066	6884
968	5066	5876
968	5066	4870
968	5066	1523
968	5066	4755
17281	5067	5865
17281	5067	9604
17281	5067	9134
17281	5067	861
17281	5067	1952
10661	5068	3191
10661	5068	1762
10661	5068	4955
10661	5068	3891
10661	5068	2370
10661	5068	4219
10661	5068	981
10661	5068	5765
10661	5068	5387
9982	5069	7910
9982	5069	1778
9982	5069	3795
9982	5069	5191
9982	5069	9447
9982	5069	3770
9982	5069	8456
9982	5069	8846
9982	5069	8548
5534	5070	3004
5534	5070	6054
5534	5070	5733
5534	5070	3381
5534	5070	5309
5534	5070	604
5534	5070	1151
5534	5070	7264
13421	5071	7919
13529	5072	7980
13529	5072	900
13529	5072	2024
13529	5072	423
13529	5072	2293
13529	5072	4191
13529	5072	3894
13529	5072	6964
16229	5073	4456
16229	5073	561
16229	5073	6848
16229	5073	2356
15760	5074	1163
15760	5074	9543
15760	5074	9366
3317	5075	7332
3317	5075	4954
3317	5075	4513
3317	5075	2410
3317	5075	5390
11900	5076	4429
11900	5076	2674
11900	5076	6279
11900	5076	2896
11900	5076	2701
11900	5076	629
3782	5077	7345
3782	5077	8539
3782	5077	5353
3782	5077	3838
3782	5077	6459
3782	5077	4628
3782	5077	5177
3782	5077	2096
9538	5078	2007
9538	5078	2791
9538	5078	4612
9538	5078	6774
9538	5078	5310
5309	5079	4953
5309	5079	7130
5309	5079	4671
5309	5079	8018
6389	5080	2801
6389	5080	6306
16624	5081	3019
16624	5081	596
16624	5081	5879
16624	5081	292
16624	5081	8560
16624	5081	5496
16624	5081	8756
6854	5082	2725
5386	5083	1731
5386	5083	8393
5386	5083	1809
5386	5083	3295
5386	5083	1510
5386	5083	4620
9822	5084	6759
9822	5084	1867
9822	5084	6927
9822	5084	8942
9822	5084	4489
9822	5084	8794
9822	5084	4359
9822	5084	4318
5422	5085	5356
5422	5085	6116
1471	5086	5646
1471	5086	7541
1471	5086	7360
1471	5086	7919
1471	5086	3576
1471	5086	7425
1471	5086	8526
1471	5086	6067
1471	5086	2203
3367	5087	2973
3367	5087	6681
12145	5088	5259
12145	5088	2627
12145	5088	7873
12145	5088	2206
12145	5088	4272
12145	5088	2652
12145	5088	3845
12145	5088	7914
12145	5088	4061
6067	5089	4213
6067	5089	1842
6067	5089	3859
6067	5089	6967
4450	5090	5024
4450	5090	9338
4450	5090	2815
4450	5090	3011
4450	5090	5306
4450	5090	6643
4450	5090	6767
4450	5090	3336
4450	5090	3736
15897	5091	8843
15897	5091	9454
15897	5091	7446
13192	5092	3620
13192	5092	286
13192	5092	8478
7567	5093	7003
7567	5093	9246
7567	5093	3981
7567	5093	5473
7567	5093	930
7567	5093	6731
7567	5093	9143
7567	5093	5580
7225	5094	6669
7225	5094	2762
7225	5094	3237
7225	5094	250
7225	5094	5024
7225	5094	3680
7225	5094	7318
7225	5094	2364
15673	5095	3215
15673	5095	6606
15673	5095	8649
15673	5095	8945
15673	5095	5798
15673	5095	8905
15673	5095	8931
4335	5096	7304
4335	5096	69
4335	5096	9955
4335	5096	3908
4335	5096	8686
4335	5096	155
4335	5096	6647
4335	5096	6883
4335	5096	5726
9339	5097	6798
9339	5097	3702
6242	5098	2790
5717	5099	245
5717	5099	220
5717	5099	9902
5717	5099	3349
5717	5099	3744
5717	5099	9801
5717	5099	5763
5717	5099	4138
1870	5100	6663
9114	5101	9756
9114	5101	8944
9114	5101	731
9114	5101	6027
9114	5101	8119
9114	5101	1324
10135	5102	4536
10135	5102	7516
10135	5102	9766
15036	5103	2382
15036	5103	827
15036	5103	3547
15036	5103	94
15036	5103	6520
15036	5103	1680
19597	5104	1266
19597	5104	8165
19597	5104	3226
1482	5105	4731
17791	5106	6357
19807	5107	2395
19807	5107	8272
19807	5107	7724
19807	5107	3873
19807	5107	3142
19807	5107	7146
19807	5107	8102
17053	5108	8718
17053	5108	6358
17053	5108	4738
17053	5108	6516
17053	5108	1684
684	5109	5520
684	5109	7467
684	5109	9634
684	5109	9439
13169	5110	6956
13169	5110	3104
13169	5110	3464
13169	5110	3910
13169	5110	8247
9525	5111	8633
9525	5111	5454
9525	5111	4133
9525	5111	9541
9525	5111	4216
7309	5112	239
7309	5112	3991
7309	5112	4117
7309	5112	5262
7309	5112	8916
7309	5112	7402
7309	5112	7819
7309	5112	1925
7309	5112	5943
2792	5113	2369
2792	5113	4031
2792	5113	9223
2343	5114	7202
2636	5115	8898
2636	5115	2103
2636	5115	3543
10935	5116	6025
10935	5116	4468
10935	5116	8213
4487	5117	9211
4487	5117	6975
4487	5117	4135
4487	5117	5961
4487	5117	5494
4487	5117	4737
13678	5118	6759
13678	5118	8816
13678	5118	891
13678	5118	20
16466	5119	476
16466	5119	3757
16466	5119	9274
16466	5119	5277
16466	5119	4907
16466	5119	5214
16466	5119	4664
16466	5119	4791
10962	5120	3301
10962	5120	7788
10962	5120	1475
10962	5120	9550
3490	5121	7360
3490	5121	6202
3490	5121	5288
3490	5121	42
3490	5121	2716
3490	5121	595
10771	5122	867
10771	5122	5542
6658	5123	1136
6658	5123	623
6658	5123	9652
6658	5123	3691
6658	5123	5980
6658	5123	3646
6658	5123	1371
8174	5124	1467
8174	5124	7441
16614	5125	2473
16614	5125	5012
12295	5126	3323
12295	5126	9104
12295	5126	5402
12295	5126	6906
12295	5126	6350
12295	5126	2734
12295	5126	2364
7659	5127	7145
7659	5127	5614
7659	5127	3649
7659	5127	9410
7659	5127	8917
7659	5127	4809
7659	5127	4150
6506	5128	8337
6506	5128	492
6451	5129	4902
6451	5129	6518
6451	5129	9671
10567	5130	3370
10567	5130	5001
10567	5130	9666
10567	5130	9940
10567	5130	7940
10567	5130	7068
10808	5131	90
10808	5131	1144
10808	5131	8147
10808	5131	4950
10808	5131	6770
10808	5131	8326
10808	5131	9904
10808	5131	5802
1606	5132	612
1606	5132	8791
1606	5132	1481
1606	5132	1635
1606	5132	1262
2702	5133	3938
2702	5133	4013
2702	5133	5035
2702	5133	3508
2702	5133	244
2702	5133	5474
2702	5133	6684
2702	5133	6848
14920	5134	6011
14920	5134	407
14920	5134	8127
14920	5134	4412
14920	5134	3020
13913	5135	5844
13913	5135	7716
13913	5135	5403
13913	5135	2762
13913	5135	4005
13913	5135	1659
13913	5135	1686
18850	5136	8645
18850	5136	1969
18850	5136	4042
18850	5136	1723
9286	5137	1576
18583	5138	7251
18583	5138	8344
18583	5138	1417
18583	5138	2109
18583	5138	7420
18583	5138	2528
18583	5138	4744
13424	5139	3092
13424	5139	2862
13424	5139	4309
13424	5139	6132
13424	5139	6740
13424	5139	5176
4853	5140	3682
4853	5140	4011
4853	5140	2443
4853	5140	6210
1907	5141	7665
1907	5141	8375
1907	5141	3751
16119	5142	3944
16119	5142	1194
16119	5142	806
17457	5143	8069
17457	5143	1017
17457	5143	6307
17457	5143	5481
17457	5143	8180
11689	5144	6601
11689	5144	9307
11689	5144	7517
11689	5144	6461
11689	5144	2277
11689	5144	579
11689	5144	4513
11689	5144	1810
19757	5145	389
19757	5145	5593
19757	5145	3687
19757	5145	7493
19757	5145	9616
19757	5145	1453
19757	5145	2656
19757	5145	9682
12284	5146	3796
16617	5147	3689
16617	5147	5227
16617	5147	51
16617	5147	511
16617	5147	1486
17955	5148	2177
17955	5148	5248
17955	5148	9791
17955	5148	5005
17955	5148	1071
17955	5148	8429
17955	5148	8847
17955	5148	3175
17955	5148	7317
5087	5149	8159
5087	5149	559
5087	5149	5517
5087	5149	8622
5087	5149	9004
8501	5150	9179
8501	5150	9887
16632	5151	284
16632	5151	9297
16632	5151	5154
16632	5151	144
16632	5151	9077
16632	5151	7283
5597	5152	5893
5597	5152	7367
5597	5152	2862
5597	5152	9934
5597	5152	3632
5597	5152	2290
14811	5153	5696
14811	5153	6021
14811	5153	477
14811	5153	6812
14811	5153	4466
14811	5153	9188
14811	5153	6893
14811	5153	8982
12697	5154	9345
5953	5155	3879
5953	5155	2002
5953	5155	7113
5953	5155	7212
5953	5155	8547
10718	5156	9454
10718	5156	6176
10718	5156	5223
10718	5156	9131
19868	5157	671
2454	5158	9920
2454	5158	8601
2454	5158	9499
2454	5158	166
2454	5158	3499
2454	5158	3405
2454	5158	3225
18799	5159	4557
18799	5159	5018
18799	5159	8268
17876	5160	165
169	5161	7117
169	5161	2853
169	5161	2261
169	5161	6744
169	5161	7091
169	5161	8523
169	5161	9368
7848	5162	9985
7848	5162	9579
5389	5163	5609
5389	5163	3515
5389	5163	3113
5389	5163	4540
13600	5164	2465
13600	5164	4626
13600	5164	3665
13600	5164	8713
13600	5164	7917
15801	5165	4796
15801	5165	4249
19716	5166	183
19716	5166	9941
19716	5166	7578
19716	5166	1522
19716	5166	2511
19716	5166	9301
19716	5166	4973
19716	5166	1129
19716	5166	3278
10508	5167	6809
10508	5167	9921
10508	5167	4167
10508	5167	916
10508	5167	5024
10508	5167	4278
10508	5167	5820
14682	5168	1327
14682	5168	2464
14682	5168	4015
14682	5168	9984
14682	5168	2637
19163	5169	1322
19163	5169	412
19163	5169	1632
19163	5169	8154
19163	5169	2424
19163	5169	1619
19163	5169	4287
19163	5169	5585
19163	5169	9765
4456	5170	5820
16912	5171	8038
18717	5172	4847
6001	5173	5432
6001	5173	2695
6001	5173	7886
6001	5173	5753
6001	5173	5190
16798	5174	1592
16798	5174	4154
16798	5174	3260
16798	5174	853
16798	5174	1549
16798	5174	4250
12554	5175	729
12554	5175	4853
5477	5176	389
533	5177	5964
533	5177	9391
533	5177	105
533	5177	2308
533	5177	6199
533	5177	5355
533	5177	252
19296	5178	4476
19296	5178	877
19296	5178	3922
19296	5178	9318
19296	5178	9468
19296	5178	4577
19296	5178	9518
17817	5179	1559
17817	5179	2700
16108	5180	2981
16108	5180	6722
16108	5180	2386
16108	5180	495
16108	5180	217
16108	5180	5839
16108	5180	8727
6605	5181	3843
6605	5181	412
3941	5182	9728
3941	5182	4195
3941	5182	1360
3941	5182	2865
3941	5182	6487
3941	5182	9277
18988	5183	9029
18988	5183	9657
18988	5183	3427
18988	5183	2518
5858	5184	4900
5858	5184	1003
5858	5184	3518
5858	5184	2560
5858	5184	2373
17719	5185	5842
17719	5185	1728
17719	5185	3537
6388	5186	2914
8667	5187	9196
8667	5187	9059
8667	5187	6742
8667	5187	5396
8667	5187	7454
8667	5187	4727
8667	5187	6628
8667	5187	2646
8667	5187	4588
16249	5188	1318
16249	5188	7862
16249	5188	1185
16249	5188	8565
16249	5188	5747
16249	5188	516
16249	5188	7958
6707	5189	1122
6707	5189	5248
6707	5189	6686
6707	5189	218
6707	5189	2266
14788	5190	4293
10955	5191	3878
10955	5191	1271
10955	5191	1330
10955	5191	1650
16416	5192	9492
16416	5192	1452
16416	5192	6689
16416	5192	7450
13695	5193	7563
13695	5193	3447
13695	5193	6117
13695	5193	6021
13695	5193	748
13695	5193	4388
13695	5193	6521
13695	5193	790
8676	5194	3134
8676	5194	9915
8676	5194	5926
8676	5194	8776
10246	5195	5763
10246	5195	4284
609	5196	7596
609	5196	6604
609	5196	2300
609	5196	3218
609	5196	1731
9728	5197	4686
6922	5198	8584
6922	5198	3548
15664	5199	8136
15664	5199	7694
15664	5199	4363
13325	5200	3208
13325	5200	9089
13325	5200	8284
5938	5201	6430
5938	5201	3023
13142	5202	4403
13142	5202	1683
13142	5202	3686
13142	5202	8270
13142	5202	3673
13142	5202	4711
13142	5202	1183
13142	5202	8782
14131	5203	35
14131	5203	6347
14131	5203	4505
14131	5203	1477
14131	5203	5941
685	5204	2881
685	5204	3208
685	5204	8156
685	5204	9267
899	5205	720
715	5206	5567
715	5206	4588
715	5206	3006
715	5206	3704
715	5206	6901
715	5206	9289
715	5206	9684
715	5206	3429
3169	5207	4450
3169	5207	3034
3169	5207	3039
2258	5208	9253
2258	5208	8355
2258	5208	9749
2258	5208	9904
2258	5208	306
19189	5209	1763
19189	5209	1880
19189	5209	5139
19189	5209	7666
19189	5209	3666
19189	5209	4823
19189	5209	4453
19189	5209	7834
19189	5209	6968
10644	5210	6682
10644	5210	1441
10644	5210	7634
10644	5210	6582
10644	5210	9733
10644	5210	1314
10644	5210	3425
10644	5210	3264
13859	5211	3634
2934	5212	8553
18956	5213	308
18956	5213	9075
11313	5214	4001
11313	5214	4564
11313	5214	3466
19015	5215	372
6972	5216	3569
6972	5216	4399
10865	5217	7907
10865	5217	6136
10865	5217	5790
10865	5217	4077
10865	5217	8849
10865	5217	7215
10865	5217	6468
10865	5217	1822
4387	5218	5680
4387	5218	3935
4387	5218	7884
11543	5219	3967
11543	5219	9413
11543	5219	2797
11543	5219	1939
11543	5219	4992
11543	5219	5514
11543	5219	3103
11543	5219	7936
11543	5219	3206
5642	5220	2294
5642	5220	2044
5642	5220	8821
5173	5221	4259
5173	5221	19
5173	5221	4157
5173	5221	3929
5173	5221	2744
5173	5221	1354
5173	5221	1423
5173	5221	770
5173	5221	3260
19625	5222	300
19625	5222	9920
19625	5222	2991
19625	5222	1707
19625	5222	5784
19625	5222	1490
19625	5222	3021
19625	5222	7759
19625	5222	4794
12296	5223	5437
12296	5223	2443
12296	5223	5005
12296	5223	8509
12296	5223	9635
12296	5223	8414
12296	5223	7929
12296	5223	5423
2413	5224	7009
2413	5224	1074
2413	5224	5571
2413	5224	5270
2413	5224	2015
14904	5225	6149
14904	5225	2111
3489	5226	1299
3489	5226	9245
3489	5226	1028
3489	5226	7928
3489	5226	8610
3489	5226	5249
3489	5226	9703
3489	5226	5550
15130	5227	5017
15130	5227	4777
15130	5227	9063
16977	5228	6329
16977	5228	679
16977	5228	6650
16977	5228	8755
16977	5228	8335
16977	5228	9513
16977	5228	7047
16977	5228	4403
16977	5228	4187
1552	5229	6100
1552	5229	6342
1552	5229	1406
1552	5229	3650
1552	5229	1449
4255	5230	3834
4255	5230	1193
4255	5230	1669
4255	5230	5753
4255	5230	9920
4255	5230	1312
2947	5231	6651
2947	5231	1601
2947	5231	6143
2947	5231	5156
2947	5231	3043
2947	5231	9770
2947	5231	8732
5132	5232	4735
973	5233	642
973	5233	5547
858	5234	1411
858	5234	2436
858	5234	9669
858	5234	7345
858	5234	4196
858	5234	5718
858	5234	2434
858	5234	5494
858	5234	6156
15352	5235	9116
15352	5235	4674
15352	5235	9335
15352	5235	5091
13002	5236	4054
13002	5236	6936
13002	5236	3439
13002	5236	8513
13002	5236	4060
13002	5236	4497
13002	5236	3003
13002	5236	9780
13002	5236	8329
14889	5237	2107
14889	5237	1846
14889	5237	5580
14889	5237	3699
15504	5238	9151
15504	5238	6165
15504	5238	9961
15504	5238	8608
15504	5238	9777
19111	5239	49
19111	5239	884
19111	5239	2046
19111	5239	3078
17314	5240	5296
17314	5240	1638
17314	5240	5776
17314	5240	3467
6854	5241	7885
6854	5241	8668
6854	5241	1497
6854	5241	6434
6854	5241	4295
6854	5241	3440
6854	5241	307
988	5242	4379
988	5242	3618
988	5242	3132
13196	5243	25
13196	5243	2311
13196	5243	5439
13196	5243	903
13196	5243	7607
3803	5244	8242
3803	5244	8436
7221	5245	4080
7221	5245	5849
7221	5245	4359
7221	5245	3809
7221	5245	7905
7221	5245	9190
7221	5245	1742
7221	5245	1193
7221	5245	1563
83	5246	1960
83	5246	9594
83	5246	7415
83	5246	4007
83	5246	4879
1453	5247	3378
1453	5247	3779
1453	5247	2940
1453	5247	1496
1453	5247	7597
1453	5247	7326
1453	5247	1488
1453	5247	9201
2321	5248	1557
2321	5248	6579
2915	5249	2184
11122	5250	6843
11122	5250	5869
11122	5250	5673
5997	5251	305
5997	5251	4702
5997	5251	2984
9080	5252	103
7502	5253	2697
7502	5253	9557
7502	5253	4737
7502	5253	1740
14826	5254	412
14826	5254	8279
14826	5254	8516
14826	5254	2960
14826	5254	8810
14826	5254	6039
12282	5255	9892
12282	5255	2902
12282	5255	9418
12282	5255	3337
12282	5255	8858
12282	5255	4759
12282	5255	2489
12282	5255	9360
12282	5255	5520
8070	5256	5534
8070	5256	3312
8070	5256	2612
8070	5256	7714
8070	5256	9310
8070	5256	5057
8947	5257	8627
8947	5257	8605
8947	5257	7121
8947	5257	2213
15464	5258	1767
15464	5258	4185
15464	5258	4162
15464	5258	8872
15464	5258	7901
15464	5258	4249
15464	5258	4190
8764	5259	7911
8764	5259	7614
8764	5259	5790
8764	5259	7609
3204	5260	9212
3204	5260	67
3204	5260	4800
3204	5260	893
3204	5260	1001
10499	5261	4555
10499	5261	8827
10499	5261	9512
10499	5261	738
10499	5261	3252
1721	5262	2463
1721	5262	8406
1721	5262	7763
5125	5263	6234
5125	5263	4756
5125	5263	8951
5125	5263	934
5125	5263	6183
5125	5263	1837
5148	5264	9101
5148	5264	609
5148	5264	7753
5148	5264	3894
5148	5264	4745
5148	5264	4630
5148	5264	4218
5148	5264	5775
5148	5264	1031
19963	5265	3486
19963	5265	7634
19963	5265	3165
19963	5265	7897
19963	5265	3880
19963	5265	662
19963	5265	628
19963	5265	7559
4606	5266	2117
4606	5266	6531
4606	5266	846
4606	5266	8422
4606	5266	7543
4606	5266	5659
4606	5266	7181
4606	5266	6351
4606	5266	7423
2605	5267	5791
2605	5267	5404
2605	5267	6394
2605	5267	5652
2605	5267	9176
2605	5267	2965
2605	5267	5660
8161	5268	3791
1943	5269	1317
1943	5269	2437
1943	5269	9272
1943	5269	4635
1943	5269	5555
1943	5269	8411
1943	5269	13
1943	5269	4519
14966	5270	1294
14966	5270	1571
14966	5270	8972
14966	5270	145
14966	5270	6332
14966	5270	8999
14966	5270	8661
15865	5271	2995
15865	5271	9965
15865	5271	2619
15865	5271	5468
15865	5271	9165
15865	5271	4620
15865	5271	4789
15865	5271	2221
15865	5271	8803
17893	5272	9638
17893	5272	5700
17893	5272	2436
17893	5272	6230
17893	5272	919
17893	5272	8222
17893	5272	629
17893	5272	860
49	5273	4084
49	5273	8508
49	5273	4543
12525	5274	4315
12525	5274	501
12525	5274	4192
12525	5274	1007
12525	5274	488
12525	5274	9645
12525	5274	2808
12525	5274	9550
12525	5274	6371
19530	5275	7949
19530	5275	4080
19530	5275	5939
19530	5275	8753
19530	5275	1076
19530	5275	8089
19530	5275	3081
8174	5276	6012
8174	5276	3709
8174	5276	2620
8174	5276	2487
8174	5276	783
1807	5277	9532
1807	5277	9194
1807	5277	9609
1807	5277	7666
1807	5277	1014
1807	5277	2261
1807	5277	8034
1470	5278	3081
1470	5278	3013
1470	5278	8738
1470	5278	4690
6889	5279	147
6889	5279	3663
6889	5279	5427
6889	5279	7288
6889	5279	3956
6889	5279	8846
13758	5280	7614
1388	5281	6394
1388	5281	3280
1388	5281	8499
1388	5281	4528
1388	5281	587
1388	5281	8879
1388	5281	4016
1388	5281	7520
2950	5282	7691
2950	5282	3120
2950	5282	2573
2950	5282	5439
2950	5282	1428
2950	5282	5122
16802	5283	3357
16802	5283	2078
16802	5283	8107
4243	5284	3424
4243	5284	7186
4243	5284	8899
4243	5284	5023
4243	5284	5555
4243	5284	2752
8358	5285	2000
1808	5286	4336
1808	5286	5758
7899	5287	9661
7899	5287	5436
7899	5287	1013
12071	5288	3631
12071	5288	8270
12071	5288	3284
12071	5288	8626
12071	5288	6269
12071	5288	6188
12071	5288	8899
9314	5289	8607
9314	5289	7608
9314	5289	5515
9314	5289	5113
9314	5289	7378
7461	5290	2836
7461	5290	4761
7461	5290	7323
7461	5290	1403
7461	5290	471
7461	5290	4343
3310	5291	6484
8182	5292	7134
8182	5292	648
8182	5292	2847
8182	5292	8241
2153	5293	7196
2153	5293	7551
2153	5293	253
2153	5293	6189
8605	5294	5381
8605	5294	4048
9893	5295	958
9893	5295	8470
9893	5295	1966
9893	5295	762
201	5296	6762
201	5296	3581
201	5296	1106
201	5296	1611
201	5296	4072
18904	5297	3439
18904	5297	8904
18904	5297	1380
18904	5297	303
4536	5298	3638
4536	5298	4527
4536	5298	9328
4536	5298	2256
6722	5299	1856
6722	5299	7776
6722	5299	6200
6722	5299	5724
6722	5299	5793
6722	5299	1185
6722	5299	4489
6722	5299	7021
6722	5299	3755
14785	5300	6564
14785	5300	8397
14785	5300	159
14785	5300	2180
14785	5300	6615
14785	5300	9583
14785	5300	5801
3047	5301	6151
3047	5301	5726
3047	5301	8092
3047	5301	8793
3047	5301	6325
3047	5301	9239
3047	5301	8481
3047	5301	1500
3316	5302	4493
3316	5302	835
3316	5302	4581
3316	5302	9857
3316	5302	8159
3316	5302	5897
3316	5302	1883
19949	5303	1822
19949	5303	5114
19949	5303	4942
19949	5303	6862
2965	5304	8283
2965	5304	4236
2965	5304	6666
2965	5304	5753
7823	5305	8220
7823	5305	3677
16091	5306	8739
16091	5306	6538
16091	5306	5615
16091	5306	121
16091	5306	4882
6329	5307	2282
6329	5307	3181
6329	5307	3997
6329	5307	1946
331	5308	3333
331	5308	3116
331	5308	8612
331	5308	2262
331	5308	5534
11309	5309	3874
11309	5309	6594
11309	5309	8453
11309	5309	2157
12307	5310	1950
12307	5310	9021
12307	5310	7436
12307	5310	4563
12307	5310	2594
12307	5310	2406
12307	5310	8324
12307	5310	2730
13376	5311	776
13376	5311	2150
13376	5311	5771
13376	5311	862
13376	5311	460
13376	5311	1535
13376	5311	4199
3269	5312	2186
3269	5312	1573
3269	5312	356
3269	5312	2532
3269	5312	6768
3269	5312	9773
3269	5312	3592
3269	5312	3964
19467	5313	2414
7897	5314	4503
7897	5314	8304
7897	5314	5151
7897	5314	2912
7897	5314	5082
7897	5314	6619
7897	5314	6352
12248	5315	6672
12248	5315	3071
12248	5315	4151
12248	5315	7086
12248	5315	3625
12248	5315	512
12248	5315	6226
9058	5316	5019
9058	5316	5165
9058	5316	8604
9058	5316	7712
9058	5316	5168
9058	5316	1080
9058	5316	8778
9058	5316	39
8377	5317	752
8377	5317	842
14133	5318	1596
14133	5318	6864
14133	5318	4041
14133	5318	6713
14133	5318	3811
14133	5318	7600
14133	5318	5873
14133	5318	4600
9277	5319	8827
19157	5320	842
19157	5320	9821
19157	5320	3606
939	5321	2498
939	5321	2508
939	5321	9166
939	5321	5287
939	5321	8786
939	5321	9689
939	5321	4525
939	5321	5844
939	5321	7651
15411	5322	2890
15411	5322	891
15411	5322	1749
15411	5322	6965
18924	5323	5770
18924	5323	9191
18924	5323	8725
18924	5323	943
18924	5323	3191
18924	5323	4601
18924	5323	8818
18924	5323	6792
18924	5323	9957
5691	5324	9341
5691	5324	3121
5691	5324	9164
5691	5324	5767
5691	5324	8781
5691	5324	7370
12188	5325	4507
12188	5325	9003
12188	5325	8172
12188	5325	1359
2629	5326	4160
2629	5326	1492
2629	5326	9288
2629	5326	9806
2629	5326	4310
6181	5327	1062
6181	5327	5598
6181	5327	3237
6181	5327	6146
6181	5327	9212
6181	5327	58
6181	5327	9280
6181	5327	1884
6181	5327	4708
12398	5328	812
10242	5329	8211
10242	5329	823
12839	5330	6524
12839	5330	7204
12839	5330	6743
12839	5330	6304
12839	5330	6885
3185	5331	7791
3185	5331	9748
3185	5331	3123
3185	5331	3723
3185	5331	252
3185	5331	71
3185	5331	1207
3185	5331	7493
3185	5331	6765
7936	5332	1229
7936	5332	2677
7936	5332	4243
7936	5332	9706
7936	5332	9257
7936	5332	2247
10738	5333	3412
10738	5333	1755
10738	5333	9263
10738	5333	5282
10738	5333	448
10738	5333	772
10738	5333	6015
10738	5333	7016
10738	5333	6578
1640	5334	9293
1640	5334	2559
1640	5334	8198
1640	5334	6909
1640	5334	8479
468	5335	3195
468	5335	342
468	5335	1130
468	5335	4003
2037	5336	711
2037	5336	9034
2037	5336	4805
2037	5336	9840
2037	5336	9866
2037	5336	6021
2037	5336	4172
2037	5336	7095
1792	5337	9979
1792	5337	1570
1792	5337	3537
1792	5337	8251
1792	5337	6591
1792	5337	3387
1792	5337	2380
1792	5337	7949
15577	5338	5826
19996	5339	8494
19996	5339	5376
19996	5339	7729
19996	5339	2999
19996	5339	6462
9426	5340	7350
9426	5340	8765
13427	5341	4502
13427	5341	8871
13427	5341	2029
13427	5341	325
13427	5341	737
13427	5341	6898
13427	5341	9393
13427	5341	1466
15855	5342	2640
15855	5342	260
15855	5342	5728
15855	5342	9719
15855	5342	5737
15855	5342	1500
15855	5342	8091
15855	5342	566
1780	5343	9708
1780	5343	3475
1780	5343	8739
1780	5343	1492
1780	5343	2868
1780	5343	1461
1780	5343	1052
13557	5344	19
13557	5344	1846
13557	5344	6719
13557	5344	1888
13557	5344	56
14542	5345	1384
14542	5345	6982
14542	5345	4290
14542	5345	2786
14542	5345	8892
14542	5345	2665
14542	5345	5967
14542	5345	6722
13480	5346	8258
13480	5346	5158
13480	5346	7192
13480	5346	8658
13480	5346	2484
7733	5347	3989
13549	5348	1021
13549	5348	7536
13549	5348	6156
13549	5348	3697
13549	5348	996
13549	5348	4752
13549	5348	6794
7970	5349	9350
7970	5349	2590
7970	5349	1471
7970	5349	2823
7970	5349	4647
7970	5349	2234
7970	5349	9117
7970	5349	7971
8252	5350	3657
8252	5350	823
8252	5350	1157
8252	5350	8317
6877	5351	1043
5028	5352	7973
5028	5352	7892
5028	5352	2295
5028	5352	3460
5028	5352	3660
5028	5352	4392
16096	5353	6456
16096	5353	6075
16096	5353	8182
16096	5353	8212
16096	5353	8625
16096	5353	7992
16096	5353	1768
16096	5353	8537
12856	5354	3436
14190	5355	1662
14190	5355	2982
14190	5355	3203
14190	5355	5760
14190	5355	4211
4844	5356	1676
4844	5356	7747
4844	5356	4390
4844	5356	3185
4844	5356	2711
4844	5356	2649
6383	5357	8126
6383	5357	8387
6383	5357	3035
6383	5357	545
9510	5358	7177
9510	5358	3396
9510	5358	2195
9510	5358	2296
9510	5358	7425
9510	5358	8956
9510	5358	8612
9510	5358	6281
19043	5359	4424
19043	5359	4029
19043	5359	8768
19267	5360	7453
19267	5360	2457
19267	5360	5355
19267	5360	1990
19267	5360	1236
19267	5360	3131
19267	5360	9549
19267	5360	1797
19267	5360	6891
11365	5361	2861
11365	5361	7233
11365	5361	8115
11365	5361	1262
11365	5361	2472
11365	5361	3945
11365	5361	9561
11365	5361	9581
11365	5361	6950
161	5362	1823
17425	5363	4395
17425	5363	1470
17404	5364	2187
9316	5365	9587
9316	5365	1253
16404	5366	8283
209	5367	8817
209	5367	9483
209	5367	2108
209	5367	466
209	5367	9654
209	5367	5130
209	5367	9492
209	5367	6498
12169	5368	5252
12169	5368	4548
12169	5368	7666
12169	5368	6229
12169	5368	2934
12169	5368	6901
12766	5369	7335
12766	5369	9891
12766	5369	4776
12766	5369	8829
12766	5369	8160
6506	5370	9599
6506	5370	6115
6506	5370	1899
6506	5370	6976
6506	5370	2892
6506	5370	8154
6506	5370	1660
6506	5370	6175
6506	5370	6705
13189	5371	1615
13189	5371	1090
13189	5371	4653
13189	5371	3028
13189	5371	3086
13189	5371	2726
13189	5371	6772
7493	5372	3656
7493	5372	5664
7493	5372	2280
7493	5372	1937
7493	5372	5349
7493	5372	5578
14386	5373	6968
14386	5373	5604
17377	5374	7889
17377	5374	3238
17377	5374	3137
17377	5374	6740
17377	5374	6893
17377	5374	2108
17377	5374	4243
17377	5374	8156
7467	5375	927
7467	5375	737
7467	5375	437
7467	5375	7888
7467	5375	5029
7467	5375	4940
7467	5375	9898
7467	5375	3785
1049	5376	2929
14341	5377	6761
14341	5377	2120
14341	5377	2848
14341	5377	2809
14341	5377	939
14341	5377	9924
14341	5377	9570
14341	5377	9334
18462	5378	2265
18462	5378	2178
10211	5379	2276
10211	5379	6528
10211	5379	4016
10211	5379	1235
10211	5379	1694
10211	5379	447
10211	5379	7288
10211	5379	1459
1584	5380	23
1584	5380	4845
1584	5380	905
17630	5381	6957
17630	5381	8412
17630	5381	3439
17630	5381	2132
17630	5381	9290
17630	5381	8716
17630	5381	6458
17630	5381	107
10860	5382	8622
10860	5382	8279
10860	5382	1019
10860	5382	488
5229	5383	7017
5229	5383	8438
5229	5383	4644
5229	5383	5129
5229	5383	4395
1705	5384	8769
1705	5384	9206
1705	5384	6931
1705	5384	6209
14455	5385	2626
14455	5385	4396
2824	5386	1868
2824	5386	6349
2824	5386	7222
2824	5386	839
2824	5386	1596
2824	5386	4666
7744	5387	1699
5984	5388	4773
5984	5388	2308
5984	5388	332
5984	5388	580
5984	5388	5429
5984	5388	2266
5984	5388	9443
5984	5388	2521
5984	5388	377
10085	5389	8914
10085	5389	4675
10085	5389	6370
10085	5389	3605
16755	5390	7545
16755	5390	2077
16755	5390	858
6246	5391	2610
5972	5392	8029
5972	5392	5617
581	5393	493
581	5393	6734
581	5393	9537
581	5393	3041
581	5393	163
581	5393	5206
581	5393	2622
581	5393	4143
581	5393	5790
12170	5394	7347
12170	5394	21
12170	5394	4709
12170	5394	3253
12170	5394	1825
12170	5394	3423
12170	5394	4358
12170	5394	6841
12170	5394	41
10491	5395	1022
10491	5395	7040
10491	5395	8917
10491	5395	2896
10491	5395	370
782	5396	3129
782	5396	3391
13627	5397	9773
13627	5397	1957
13627	5397	7355
13627	5397	5059
13627	5397	9606
13291	5398	7392
13291	5398	5112
13291	5398	6029
13291	5398	8152
13291	5398	2659
13291	5398	5690
11782	5399	450
11782	5399	99
11782	5399	2448
11782	5399	6877
11782	5399	2830
11782	5399	3586
11782	5399	3128
11782	5399	6828
11782	5399	2264
16584	5400	7525
16584	5400	7712
16584	5400	2178
16584	5400	9105
16584	5400	3693
16584	5400	7675
245	5401	7629
245	5401	5319
245	5401	4444
245	5401	7691
245	5401	8965
245	5401	3211
245	5401	8246
245	5401	3676
2774	5402	5333
2774	5402	25
2774	5402	7643
2774	5402	2816
2774	5402	7822
10899	5403	6664
10899	5403	2205
10899	5403	3848
10899	5403	4308
5105	5404	8322
5105	5404	3477
17619	5405	7835
17619	5405	9257
14155	5406	2527
18380	5407	3544
18380	5407	8214
18380	5407	6323
18380	5407	403
18380	5407	8717
18380	5407	6609
18380	5407	6030
2848	5408	4461
2848	5408	9486
2848	5408	6032
2848	5408	8181
2848	5408	7035
2848	5408	7748
2848	5408	63
2848	5408	1716
16076	5409	8100
16076	5409	8268
16076	5409	5813
16076	5409	2849
16076	5409	5722
16076	5409	5650
16076	5409	1500
16076	5409	7284
16076	5409	9329
12725	5410	8814
12725	5410	5128
12725	5410	6823
12725	5410	8567
13332	5411	1374
13332	5411	6378
4199	5412	2282
4199	5412	8756
4199	5412	5798
4199	5412	5029
7024	5413	2058
7024	5413	3788
7024	5413	5118
17860	5414	1010
17860	5414	7109
17860	5414	4614
17860	5414	9487
17860	5414	8701
17860	5414	9647
10889	5415	7331
10889	5415	9874
10889	5415	3245
10889	5415	3904
10889	5415	811
10889	5415	9386
16810	5416	8798
16810	5416	6348
16810	5416	9556
16810	5416	4791
16810	5416	7603
16810	5416	5713
16810	5416	9883
16810	5416	5298
16810	5416	1238
8964	5417	1514
8964	5417	3191
8964	5417	9329
8964	5417	9305
16203	5418	1512
16203	5418	2283
16203	5418	8982
16203	5418	741
16203	5418	8821
16203	5418	5946
14366	5419	1665
14366	5419	2271
14366	5419	4305
14366	5419	4078
14366	5419	6602
14366	5419	329
14366	5419	1483
14366	5419	3151
10866	5420	5318
10866	5420	5899
3688	5421	9027
3688	5421	6596
3688	5421	3939
3688	5421	3870
3688	5421	4327
3688	5421	1878
3688	5421	1329
3688	5421	7631
1563	5422	6215
1563	5422	7134
1563	5422	5140
1563	5422	5671
1563	5422	4876
1563	5422	4293
1778	5423	9756
1778	5423	3656
1778	5423	6409
1778	5423	5011
1778	5423	7739
2886	5424	7372
2886	5424	1457
2886	5424	1169
2886	5424	7537
2886	5424	2394
2886	5424	767
4479	5425	7652
2614	5426	6840
2614	5426	3516
2614	5426	9065
2614	5426	6021
2614	5426	418
2614	5426	2125
6587	5427	133
6587	5427	7847
6587	5427	7550
6587	5427	3138
6587	5427	5068
8875	5428	216
8875	5428	292
8875	5428	3514
8875	5428	7795
16424	5429	86
16424	5429	7262
16424	5429	6258
16424	5429	9417
13933	5430	2091
13933	5430	2220
8631	5431	3252
8631	5431	1715
8631	5431	8063
8631	5431	6300
8631	5431	7721
8631	5431	3875
8631	5431	49
8631	5431	6361
11555	5432	2744
11555	5432	8252
11555	5432	2005
11555	5432	9381
11555	5432	4786
11555	5432	7758
11555	5432	6501
9128	5433	4471
16690	5434	9481
16020	5435	4832
16020	5435	5762
16020	5435	4222
16020	5435	3554
16020	5435	7540
16020	5435	1397
16020	5435	6376
2356	5436	2279
2356	5436	449
2356	5436	5277
2356	5436	2980
19319	5437	6749
19319	5437	1853
19319	5437	681
8468	5438	2573
8468	5438	3113
8468	5438	8970
8468	5438	127
8468	5438	1629
8468	5438	8362
8468	5438	5009
8468	5438	7032
5706	5439	5319
5706	5439	8759
18879	5440	3673
18879	5440	5001
18879	5440	3993
18879	5440	5194
18879	5440	5994
18879	5440	4393
18879	5440	7725
5467	5441	722
5467	5441	9584
5467	5441	5948
5467	5441	2765
5467	5441	2072
5467	5441	4146
5467	5441	6856
3712	5442	9969
3712	5442	5193
3712	5442	4578
4605	5443	5036
4605	5443	15
4605	5443	3521
18936	5444	4175
18936	5444	6562
18936	5444	1888
18936	5444	6138
18936	5444	5273
18936	5444	2356
18936	5444	9459
8072	5445	6338
8072	5445	8074
8072	5445	8208
8072	5445	7130
8072	5445	7687
4370	5446	8756
4370	5446	3690
4370	5446	8124
4370	5446	767
4370	5446	28
18973	5447	3522
18973	5447	4634
18973	5447	7278
18973	5447	1234
18973	5447	796
18973	5447	7214
18973	5447	9619
18973	5447	667
18973	5447	3780
14938	5448	7296
14648	5449	6810
14648	5449	2473
14648	5449	2426
19407	5450	5189
19407	5450	9788
18812	5451	7170
18812	5451	9177
18812	5451	2059
18812	5451	234
18812	5451	71
18812	5451	6678
18812	5451	6855
18812	5451	8645
18812	5451	3820
8023	5452	5436
8023	5452	6854
8023	5452	8365
8023	5452	4630
8023	5452	5699
8023	5452	3766
11649	5453	5179
11649	5453	5896
5500	5454	2077
5500	5454	7925
5500	5454	3176
5500	5454	4755
5500	5454	4662
5500	5454	3835
5500	5454	7552
6500	5455	8126
6500	5455	1792
6500	5455	3371
6500	5455	6427
6500	5455	8828
6500	5455	2017
8187	5456	2603
8187	5456	8113
8187	5456	5122
8187	5456	8966
8187	5456	5800
8187	5456	7419
8187	5456	9767
8187	5456	3969
8187	5456	9380
5500	5457	2017
5500	5457	1196
5500	5457	5730
5500	5457	8126
5500	5457	2100
5500	5457	5577
1396	5458	9654
1396	5458	3568
1396	5458	6787
1396	5458	4753
1396	5458	1227
1396	5458	6515
1396	5458	6882
17796	5459	2931
17796	5459	1800
17796	5459	5598
17796	5459	1784
17796	5459	4112
17796	5459	1872
17796	5459	6921
17796	5459	5885
17796	5459	8598
6701	5460	7483
6701	5460	6409
6701	5460	9187
6701	5460	3262
6701	5460	3443
10484	5461	9142
10484	5461	3293
10329	5462	6690
10329	5462	6309
10329	5462	8907
10329	5462	8638
10329	5462	5181
10329	5462	2274
2919	5463	1449
2919	5463	9937
2919	5463	4602
2919	5463	89
6762	5464	8545
6762	5464	937
6762	5464	3583
6762	5464	522
6762	5464	7377
5115	5465	4147
5115	5465	8554
5115	5465	9508
5115	5465	9424
5115	5465	7971
5115	5465	6629
5115	5465	7768
9527	5466	2110
9527	5466	5219
9527	5466	6142
9527	5466	8181
9527	5466	4900
9527	5466	6075
9527	5466	96
9527	5466	5941
9527	5466	286
19420	5467	3735
19420	5467	4680
19420	5467	4364
19420	5467	6266
19420	5467	6103
19420	5467	1219
14720	5468	878
14720	5468	5250
14720	5468	2139
16159	5469	3527
16159	5469	7170
16159	5469	9264
16159	5469	9939
16159	5469	2407
16159	5469	62
16159	5469	6624
15685	5470	5203
15685	5470	3364
17227	5471	3958
17227	5471	6726
17227	5471	7667
17227	5471	595
17227	5471	8671
17227	5471	5741
17227	5471	3801
17227	5471	2910
19067	5472	7376
19067	5472	4984
19067	5472	2060
19067	5472	8659
3381	5473	1897
19126	5474	4399
19126	5474	9322
19126	5474	1470
19126	5474	8286
19126	5474	6985
19126	5474	3913
19126	5474	8973
19126	5474	4526
19126	5474	3867
5050	5475	4216
5050	5475	181
5050	5475	6304
5050	5475	5675
5050	5475	8514
5050	5475	3355
5050	5475	211
5050	5475	957
5050	5475	9204
6233	5476	4405
6233	5476	6528
6233	5476	6065
2434	5477	3583
2434	5477	1124
2434	5477	7325
2434	5477	381
2434	5477	6870
14162	5478	5577
14162	5478	2571
14162	5478	879
14162	5478	1750
14162	5478	7005
6138	5479	4286
6138	5479	9364
6138	5479	3475
6138	5479	7755
16270	5480	1870
16270	5480	1235
16270	5480	4939
16270	5480	8192
18140	5481	4354
18140	5481	6016
18140	5481	5108
18140	5481	2261
18140	5481	8324
18140	5481	7263
18140	5481	2110
18789	5482	3549
18789	5482	9543
18789	5482	5449
18789	5482	1595
18789	5482	1990
18789	5482	2711
18789	5482	5321
18789	5482	9063
18789	5482	4972
14465	5483	8856
14465	5483	4581
14465	5483	5843
17988	5484	4015
17988	5484	8691
17988	5484	434
17988	5484	3104
11627	5485	2877
11627	5485	4525
11627	5485	2682
12492	5486	7072
12492	5486	4902
12492	5486	3524
12492	5486	1909
11845	5487	5386
11845	5487	8145
11845	5487	8744
11845	5487	4303
11845	5487	9202
11845	5487	6702
11845	5487	5029
11845	5487	2710
8950	5488	821
8950	5488	5616
8950	5488	4209
6755	5489	1237
18764	5490	5395
18764	5490	3420
18764	5490	8803
18764	5490	8322
18764	5490	9505
10267	5491	7834
10267	5491	6932
10267	5491	670
10267	5491	973
10267	5491	4517
10267	5491	5113
10267	5491	3250
10267	5491	5135
1059	5492	5125
6892	5493	4477
6892	5493	5003
6892	5493	6749
6892	5493	6308
6892	5493	6286
6892	5493	4820
6892	5493	1925
6892	5493	1676
6892	5493	5090
449	5494	754
449	5494	5702
449	5494	8681
449	5494	9324
449	5494	5937
1879	5495	3776
1879	5495	2697
1879	5495	7066
1879	5495	7320
1879	5495	6852
1879	5495	6028
1879	5495	3920
1879	5495	2165
1879	5495	120
11643	5496	1889
11643	5496	9286
11643	5496	1921
11643	5496	8764
11643	5496	572
11643	5496	5790
5711	5497	1846
5711	5497	8915
5711	5497	9577
5711	5497	2535
5711	5497	2247
5711	5497	4660
5711	5497	8475
5711	5497	5127
5711	5497	1576
6992	5498	9198
6992	5498	9491
6992	5498	9805
6992	5498	7843
6992	5498	2013
6992	5498	8224
6992	5498	7561
190	5499	2749
190	5499	5354
190	5499	7656
190	5499	1586
190	5499	4891
190	5499	2727
3847	5500	6911
3847	5500	8308
3847	5500	7785
3847	5500	4441
3847	5500	1247
3847	5500	3807
6695	5501	7547
6695	5501	6067
6695	5501	6848
6695	5501	4433
6695	5501	7426
8300	5502	365
8300	5502	7183
8300	5502	746
8300	5502	8992
8300	5502	975
8300	5502	7188
8300	5502	5245
8300	5502	8129
8300	5502	4128
389	5503	7847
389	5503	1212
389	5503	2470
389	5503	9422
389	5503	3793
389	5503	7546
389	5503	8459
389	5503	5943
389	5503	3478
1330	5504	9949
1330	5504	9191
1330	5504	5503
12760	5505	1691
12760	5505	7389
13622	5506	6597
10111	5507	2505
10111	5507	3933
10111	5507	5691
10111	5507	3124
10111	5507	5458
10111	5507	9715
10111	5507	4130
10839	5508	7921
10839	5508	3190
10839	5508	300
10839	5508	4326
10839	5508	2160
10839	5508	1953
10839	5508	2415
10839	5508	8734
10839	5508	4649
15545	5509	86
15545	5509	8395
15545	5509	3761
15545	5509	9635
15545	5509	4764
15545	5509	3351
15545	5509	1782
12214	5510	1506
12214	5510	2722
12214	5510	6957
12214	5510	268
12214	5510	5879
12214	5510	9379
12214	5510	9681
12214	5510	5719
12214	5510	3680
6630	5511	870
6630	5511	6527
6630	5511	6343
6630	5511	8759
6630	5511	2394
6630	5511	9390
6630	5511	4185
6630	5511	6570
4897	5512	8391
4897	5512	6795
4897	5512	4454
4897	5512	3588
4897	5512	3789
4897	5512	6837
4897	5512	5620
3924	5513	8852
3924	5513	6334
3924	5513	4252
3924	5513	4589
3924	5513	4970
3924	5513	3270
3320	5514	5769
3320	5514	7141
3320	5514	762
3320	5514	2284
3320	5514	5588
3320	5514	961
15408	5515	6841
15408	5515	6958
15408	5515	5818
15408	5515	1914
15408	5515	4087
15408	5515	2455
15408	5515	6843
15408	5515	624
15528	5516	8693
15528	5516	1359
15528	5516	2153
15528	5516	7179
12291	5517	1446
12291	5517	7955
12291	5517	9238
12291	5517	8050
12291	5517	5051
12291	5517	7283
12291	5517	1003
8002	5518	7761
8002	5518	721
8002	5518	8643
8002	5518	1438
8002	5518	4891
8002	5518	1967
6823	5519	674
6823	5519	6147
6823	5519	5879
6823	5519	9227
6823	5519	3091
6823	5519	1067
13473	5520	1099
13473	5520	1110
5094	5521	4008
5094	5521	8175
5094	5521	940
3227	5522	337
3227	5522	5953
3227	5522	3085
3227	5522	9793
3227	5522	6638
1405	5523	5488
1405	5523	1728
14581	5524	4819
14581	5524	6007
14581	5524	5362
14581	5524	7372
15418	5525	7272
15418	5525	4366
15418	5525	6566
15418	5525	1088
15418	5525	1705
14386	5526	340
14386	5526	8458
6553	5527	9035
6553	5527	8189
6553	5527	4675
6553	5527	4116
2775	5528	8452
2775	5528	8250
2775	5528	437
2775	5528	6640
2775	5528	7148
2775	5528	1044
2775	5528	4753
4639	5529	5893
4639	5529	8697
4639	5529	8220
4639	5529	1641
9045	5530	1770
9045	5530	6776
9045	5530	1713
9045	5530	9974
14243	5531	4608
14243	5531	7635
14243	5531	6286
14243	5531	1559
14243	5531	2226
14243	5531	6260
14243	5531	3626
14243	5531	2779
13001	5532	8674
13001	5532	4211
13001	5532	8781
13001	5532	8739
15904	5533	1919
15904	5533	4044
15904	5533	2051
15904	5533	382
15904	5533	5858
15904	5533	4720
14997	5534	3999
14997	5534	1154
14997	5534	6843
14997	5534	3059
14997	5534	9548
14997	5534	1493
14997	5534	9749
3334	5535	9871
505	5536	6894
505	5536	1751
505	5536	5678
19353	5537	2349
19353	5537	4915
19353	5537	9973
19353	5537	7204
19353	5537	5315
19353	5537	6961
19353	5537	8620
19353	5537	2889
19353	5537	3279
13477	5538	4919
13477	5538	7071
13477	5538	5551
13477	5538	273
13477	5538	5018
13477	5538	7408
14760	5539	8845
14760	5539	2185
14760	5539	1788
14760	5539	9900
14760	5539	9294
16073	5540	3672
16073	5540	8860
16073	5540	5431
16073	5540	6210
16073	5540	7469
9753	5541	2256
9753	5541	1584
9753	5541	5262
9753	5541	6906
9753	5541	4572
9753	5541	1726
11401	5542	1243
11401	5542	4736
11401	5542	6316
11401	5542	4513
11401	5542	5870
11401	5542	3752
11401	5542	6858
11401	5542	546
11401	5542	465
11451	5543	2775
11451	5543	3926
11451	5543	4335
11451	5543	200
11451	5543	3810
11451	5543	1809
11451	5543	1544
12114	5544	8039
12114	5544	8777
12114	5544	9312
12114	5544	4011
12114	5544	1452
14699	5545	7819
14699	5545	2774
14699	5545	9179
14699	5545	8388
14699	5545	4415
14699	5545	1534
14699	5545	8320
14699	5545	2016
108	5546	4951
108	5546	2927
108	5546	2455
108	5546	3185
9058	5547	9799
9058	5547	1698
9058	5547	1978
9058	5547	1966
9058	5547	280
9058	5547	2351
9058	5547	3746
9058	5547	7567
9058	5547	4420
18740	5548	8331
18740	5548	9482
18740	5548	4025
18740	5548	6044
18740	5548	754
4901	5549	2535
4901	5549	7629
19959	5550	4346
19959	5550	2601
19959	5550	9917
19959	5550	8136
12932	5551	7981
12932	5551	573
12932	5551	3880
12932	5551	9867
12932	5551	3777
12932	5551	4375
12932	5551	1469
12932	5551	9126
12932	5551	1983
12656	5552	5094
12656	5552	3159
12656	5552	2968
12656	5552	9694
12656	5552	2405
12656	5552	6192
12656	5552	1699
12656	5552	4303
16158	5553	4390
16158	5553	9588
16158	5553	9470
16158	5553	4056
16158	5553	7898
16158	5553	3630
16158	5553	3013
11960	5554	8547
11960	5554	3588
11960	5554	5211
11960	5554	4811
11960	5554	6851
11960	5554	7593
3965	5555	5498
3965	5555	6763
3965	5555	5537
3965	5555	3129
3965	5555	7652
7742	5556	9784
7742	5556	8016
7742	5556	5407
7742	5556	8657
7742	5556	2740
7742	5556	8238
7686	5557	9036
7686	5557	9713
7686	5557	7366
7686	5557	460
7686	5557	4415
7686	5557	6636
7686	5557	1982
7686	5557	6150
7686	5557	9424
9662	5558	5048
9662	5558	9301
9662	5558	465
9662	5558	7128
12327	5559	1962
12327	5559	2294
12327	5559	8450
12327	5559	532
12327	5559	7076
12327	5559	3842
12327	5559	4278
18828	5560	3207
18828	5560	4914
18828	5560	6429
18828	5560	415
18828	5560	8157
17495	5561	6704
17495	5561	4103
9267	5562	7146
2846	5563	837
2846	5563	6266
2359	5564	6558
2359	5564	8570
2359	5564	4712
2359	5564	3462
2359	5564	9971
8147	5565	8707
11704	5566	7275
11704	5566	6823
11704	5566	2421
11704	5566	2155
11704	5566	4267
1648	5567	5538
1648	5567	2876
1648	5567	9884
1648	5567	9164
1648	5567	6920
11252	5568	1478
11252	5568	3437
11252	5568	6655
11252	5568	6864
11252	5568	3346
11252	5568	79
11252	5568	7723
11252	5568	8436
7947	5569	2972
7947	5569	6404
7947	5569	129
7947	5569	6617
13310	5570	6329
5966	5571	2058
5966	5571	5061
5966	5571	9728
5966	5571	8232
5966	5571	6176
5966	5571	2137
10217	5572	7244
10217	5572	2198
10217	5572	715
10217	5572	516
10217	5572	1574
10217	5572	4303
10217	5572	9827
10217	5572	6796
3713	5573	4640
3713	5573	3080
3713	5573	1164
3713	5573	765
3713	5573	325
15138	5574	1430
15138	5574	5853
15138	5574	4614
15138	5574	8789
15138	5574	8179
9948	5575	6830
9948	5575	2095
9948	5575	6769
9948	5575	2285
9948	5575	391
9948	5575	1567
9948	5575	7421
11058	5576	4352
11058	5576	1658
11058	5576	2058
11058	5576	7881
11058	5576	9061
11058	5576	5210
11058	5576	7048
11058	5576	4077
11058	5576	3509
11585	5577	8842
11585	5577	5422
11585	5577	4419
11585	5577	1792
11585	5577	3420
10155	5578	5524
10155	5578	124
10155	5578	2858
10155	5578	4144
10155	5578	7373
10155	5578	9047
10155	5578	9066
10155	5578	6674
10155	5578	8069
6981	5579	7196
6981	5579	5803
6981	5579	9711
9636	5580	7806
9636	5580	5801
19887	5581	8164
19887	5581	7232
19887	5581	2978
19887	5581	5072
19887	5581	9419
19887	5581	4537
3464	5582	2348
3464	5582	5297
17636	5583	2463
17636	5583	7761
17636	5583	4999
17636	5583	7792
17636	5583	7944
17636	5583	391
17636	5583	8928
16693	5584	9542
16693	5584	8236
16693	5584	6246
16693	5584	8780
16693	5584	8623
16693	5584	361
5646	5585	4264
5646	5585	1257
5646	5585	1095
2971	5586	6948
2971	5586	4352
2971	5586	8592
2971	5586	248
2971	5586	8199
2971	5586	7410
12063	5587	3909
12063	5587	1219
12063	5587	3144
12063	5587	4774
12063	5587	7538
12063	5587	3600
12063	5587	7354
12063	5587	622
9948	5588	8868
9948	5588	1227
9948	5588	6709
9948	5588	4044
18185	5589	9308
18185	5589	5418
18185	5589	9842
18185	5589	6851
18185	5589	6060
18185	5589	1996
18185	5589	4170
18185	5589	7713
15360	5590	7895
15360	5590	3525
15360	5590	4240
15360	5590	9347
15360	5590	6661
15360	5590	7483
5801	5591	3092
5801	5591	4066
5801	5591	5720
5801	5591	2563
5801	5591	8679
5801	5591	9867
5801	5591	7956
11700	5592	453
11700	5592	3821
11700	5592	2995
11700	5592	2287
11700	5592	6449
11700	5592	3378
12938	5593	5620
12938	5593	5945
12938	5593	5747
12938	5593	8458
12938	5593	893
12938	5593	9858
12938	5593	2263
12938	5593	9873
12938	5593	3794
13578	5594	7266
13578	5594	3933
13578	5594	5491
13578	5594	7112
13578	5594	9635
11160	5595	203
11160	5595	2846
11160	5595	5784
11160	5595	4716
11160	5595	2409
11160	5595	762
11160	5595	8281
4908	5596	3076
17133	5597	4195
17133	5597	742
17133	5597	6977
17133	5597	2913
17133	5597	1026
17133	5597	8276
17133	5597	8462
17133	5597	4856
11235	5598	8895
11235	5598	8314
11235	5598	320
11235	5598	8984
11235	5598	9956
11235	5598	9231
19944	5599	1627
19944	5599	6300
19944	5599	8502
19944	5599	9461
19944	5599	7566
19944	5599	7833
19944	5599	9933
19944	5599	1004
19944	5599	4969
10577	5600	6508
10577	5600	5529
10577	5600	4811
10577	5600	5710
10577	5600	6791
6181	5601	7666
6181	5601	2849
6181	5601	3764
6181	5601	376
6181	5601	5587
6181	5601	2524
16646	5602	3106
16646	5602	2063
13746	5603	1514
13746	5603	1134
13746	5603	6186
13746	5603	4784
15264	5604	8313
15264	5604	8030
15264	5604	836
15264	5604	4454
593	5605	2647
593	5605	615
13840	5606	16
13840	5606	2280
13840	5606	6789
13840	5606	52
18267	5607	8590
18267	5607	6907
18267	5607	274
18299	5608	1131
18299	5608	8884
18299	5608	5039
18299	5608	8666
17362	5609	4882
17362	5609	3476
17362	5609	9384
17362	5609	4067
17362	5609	1178
17362	5609	796
2138	5610	218
2138	5610	6927
2138	5610	5405
886	5611	14
886	5611	440
10643	5612	255
8643	5613	6978
8643	5613	8015
8643	5613	9600
8643	5613	2097
8643	5613	8561
8643	5613	1166
8643	5613	4832
8643	5613	4408
8643	5613	6020
12918	5614	1781
12918	5614	9778
12918	5614	3612
12918	5614	6356
12918	5614	8461
12918	5614	9879
12918	5614	2393
12918	5614	3935
12918	5614	9296
923	5615	4721
923	5615	9736
923	5615	5290
923	5615	7199
923	5615	1018
923	5615	1913
923	5615	1014
923	5615	9325
15570	5616	4260
15570	5616	6227
15570	5616	7583
15570	5616	690
15570	5616	5984
15570	5616	9436
15570	5616	8019
6616	5617	8271
6616	5617	7622
6616	5617	2807
6616	5617	5707
6616	5617	6004
6616	5617	9917
6616	5617	9327
6616	5617	9801
14768	5618	8477
14768	5618	210
14768	5618	7763
18413	5619	7850
18413	5619	91
18413	5619	9989
18413	5619	4105
18413	5619	5030
18413	5619	8273
18413	5619	6816
18413	5619	9122
2985	5620	4553
2985	5620	1288
2985	5620	389
2985	5620	2990
9051	5621	4332
9051	5621	1577
9051	5621	8541
9051	5621	15
9051	5621	5791
9051	5621	8516
15275	5622	9130
15275	5622	3270
15275	5622	5698
15275	5622	8444
15275	5622	3609
15275	5622	3560
15275	5622	5959
15275	5622	7972
15275	5622	4754
6589	5623	6865
6589	5623	2912
6589	5623	3625
6589	5623	3017
6589	5623	7840
2219	5624	5667
2219	5624	7850
2819	5625	521
2819	5625	1952
13122	5626	1185
13122	5626	4907
13122	5626	813
13122	5626	2895
1469	5627	1844
1469	5627	9206
1469	5627	6073
1469	5627	6786
1469	5627	8465
1469	5627	3438
1469	5627	7037
11392	5628	9583
11392	5628	8259
11392	5628	7232
252	5629	861
252	5629	1838
252	5629	678
252	5629	214
13999	5630	4925
13999	5630	5548
13999	5630	7354
13999	5630	7658
13999	5630	2633
13999	5630	2439
19340	5631	9796
19340	5631	9144
19340	5631	1740
19340	5631	3360
19340	5631	2025
247	5632	6687
247	5632	9658
247	5632	7459
247	5632	2041
247	5632	6316
247	5632	2357
247	5632	5566
11057	5633	8392
11057	5633	8875
11057	5633	8960
11057	5633	2548
11057	5633	5808
11057	5633	1107
11057	5633	9409
11057	5633	1877
18671	5634	4452
18671	5634	6742
4614	5635	7836
4614	5635	7790
4614	5635	7705
4614	5635	6358
4614	5635	8899
4614	5635	7648
4614	5635	621
4614	5635	1085
4614	5635	6547
13148	5636	8642
13148	5636	7568
13148	5636	3556
13148	5636	7691
13148	5636	8287
12152	5637	2740
12152	5637	8544
12381	5638	4945
12381	5638	7665
12381	5638	389
12381	5638	8065
12381	5638	1935
12381	5638	9433
12381	5638	2090
19561	5639	5306
19561	5639	2580
19561	5639	3491
19561	5639	5167
19561	5639	6958
19561	5639	8224
6336	5640	4659
6336	5640	4241
6336	5640	3803
6336	5640	9430
6336	5640	5679
6336	5640	6224
6336	5640	1300
13210	5641	3662
13210	5641	8300
13210	5641	794
18034	5642	2185
13686	5643	9566
13686	5643	8724
13686	5643	7442
7330	5644	7324
7330	5644	8420
4163	5645	910
4163	5645	5234
4163	5645	1165
4163	5645	2746
4163	5645	3078
4163	5645	192
4163	5645	3601
4163	5645	7687
4163	5645	8754
18537	5646	1083
18537	5646	3723
18537	5646	8711
18537	5646	1584
18537	5646	5378
1222	5647	4403
1222	5647	6727
1222	5647	8212
1222	5647	961
17295	5648	3775
17295	5648	4698
17295	5648	5889
17295	5648	8684
17295	5648	5282
13731	5649	9359
7543	5650	931
7543	5650	2882
7543	5650	6693
7543	5650	955
7543	5650	2489
12528	5651	8831
12528	5651	9276
12528	5651	1456
12528	5651	4909
4735	5652	2039
10175	5653	4862
10175	5653	4625
10175	5653	9980
10175	5653	4924
10175	5653	673
13257	5654	8474
13257	5654	5078
13257	5654	1050
13257	5654	6397
13257	5654	2354
13257	5654	3253
13257	5654	1109
8731	5655	504
8731	5655	5897
8731	5655	3492
8731	5655	2952
3368	5656	9247
3368	5656	8253
18604	5657	1774
18604	5657	8845
18604	5657	1057
18604	5657	2831
18604	5657	4318
18604	5657	4878
1549	5658	1595
1549	5658	1686
1549	5658	9941
1549	5658	7898
1549	5658	1743
1549	5658	3512
1549	5658	5451
14449	5659	2251
14449	5659	5326
14449	5659	6079
14449	5659	1200
14449	5659	4465
19538	5660	8025
19538	5660	9464
19538	5660	6914
17312	5661	9594
12245	5662	1496
12245	5662	8515
12245	5662	3517
9432	5663	9946
5394	5664	7133
5394	5664	6688
5394	5664	7432
5394	5664	2703
5394	5664	4504
5394	5664	9903
5394	5664	8418
5394	5664	5961
8951	5665	9069
8951	5665	2755
8951	5665	4128
8951	5665	1901
8951	5665	5397
8951	5665	3548
8951	5665	2579
8951	5665	6577
18557	5666	1574
18557	5666	1567
18557	5666	6941
18557	5666	9905
18557	5666	2003
18557	5666	9502
18557	5666	9838
18557	5666	5690
15180	5667	98
5353	5668	2687
5353	5668	8737
5353	5668	5225
5353	5668	4493
5353	5668	303
5353	5668	4319
5353	5668	2897
5353	5668	6847
5353	5668	7393
6164	5669	672
6164	5669	9963
6164	5669	1778
6164	5669	3445
6164	5669	2305
6164	5669	998
6164	5669	9770
6164	5669	1352
6164	5669	3014
14665	5670	3654
14665	5670	990
14665	5670	5392
14665	5670	4128
14665	5670	5254
14665	5670	5482
14665	5670	5568
14665	5670	8062
732	5671	1407
732	5671	8830
732	5671	9176
9742	5672	3463
9742	5672	4981
9742	5672	3875
9742	5672	96
9742	5672	6415
9742	5672	2802
16738	5673	7382
16738	5673	8994
16738	5673	3374
16738	5673	7438
16738	5673	3159
16738	5673	4046
16738	5673	1485
16738	5673	3845
17651	5674	9198
17651	5674	7928
17651	5674	4844
17651	5674	7509
17651	5674	9098
17651	5674	4036
17651	5674	7432
17651	5674	9004
17651	5674	3429
13175	5675	4158
13175	5675	275
13175	5675	9486
13175	5675	6827
13175	5675	6250
13175	5675	8380
13175	5675	1638
18293	5676	5812
18293	5676	483
18293	5676	5697
18293	5676	4048
14112	5677	4110
14112	5677	3522
14112	5677	7872
14112	5677	710
14112	5677	1893
14112	5677	724
14112	5677	1137
14112	5677	3495
14112	5677	1507
14637	5678	561
9218	5679	1665
9218	5679	4926
9218	5679	5196
9218	5679	159
9218	5679	1455
9218	5679	7767
16980	5680	851
16980	5680	5007
16980	5680	9240
16980	5680	9676
16980	5680	5582
16980	5680	4522
16980	5680	4846
16980	5680	1540
16980	5680	9461
9314	5681	7725
9314	5681	3310
9314	5681	9715
6667	5682	448
6667	5682	7189
6667	5682	161
6667	5682	3719
6667	5682	7101
3892	5683	8456
3892	5683	9344
3892	5683	6493
8434	5684	9708
8434	5684	7628
8434	5684	3670
8434	5684	8519
8434	5684	2836
8434	5684	3803
15043	5685	5761
15043	5685	1616
15043	5685	2957
15043	5685	9971
15043	5685	810
15043	5685	6555
15043	5685	680
15043	5685	481
15043	5685	7512
2361	5686	5297
2361	5686	8299
2361	5686	1668
812	5687	484
812	5687	517
812	5687	2224
6067	5688	7024
6067	5688	9471
6067	5688	8016
4180	5689	4682
4180	5689	118
3570	5690	2191
3570	5690	1560
3570	5690	6539
3570	5690	6115
3570	5690	2563
3570	5690	1797
3570	5690	4150
3570	5690	7142
3570	5690	6324
3870	5691	3382
3870	5691	2222
3870	5691	4910
3870	5691	5284
3870	5691	3959
3870	5691	3144
3870	5691	149
3870	5691	7594
313	5692	9669
13622	5693	1969
13622	5693	7320
13622	5693	5251
13622	5693	1146
13622	5693	4200
18967	5694	6958
18967	5694	1729
18967	5694	7639
18967	5694	3369
18967	5694	9478
18967	5694	6324
10769	5695	769
10769	5695	6128
10769	5695	7142
10769	5695	8788
10769	5695	8851
10769	5695	4343
10769	5695	2471
10769	5695	7314
10769	5695	7113
9502	5696	834
9502	5696	1389
9502	5696	6987
9502	5696	2542
9502	5696	4783
9502	5696	868
9502	5696	1398
9502	5696	2290
9502	5696	6296
1276	5697	9794
1276	5697	5071
1276	5697	8599
1276	5697	1658
1276	5697	1507
1276	5697	4802
3576	5698	4731
3576	5698	5501
13798	5699	7085
13798	5699	7161
13798	5699	540
13798	5699	5901
13798	5699	8960
13798	5699	7240
17795	5700	1389
17795	5700	6977
17795	5700	1109
17795	5700	3228
17458	5701	5628
17458	5701	7587
9493	5702	4150
9493	5702	5816
9493	5702	9841
9493	5702	668
9493	5702	1953
6682	5703	4378
6682	5703	8489
6682	5703	1454
6682	5703	6335
3923	5704	4673
3923	5704	222
3923	5704	8357
3923	5704	6511
3923	5704	7481
16296	5705	3335
16296	5705	2522
16296	5705	8740
16296	5705	3457
16296	5705	4505
16296	5705	3552
16296	5705	7799
16296	5705	2801
16296	5705	6917
14277	5706	1510
14277	5706	1132
14277	5706	7976
14277	5706	7138
14277	5706	7540
14277	5706	2008
14277	5706	8314
3541	5707	6680
3541	5707	2304
10208	5708	2577
10208	5708	7023
10208	5708	5772
10208	5708	9317
10208	5708	7522
10208	5708	5264
10208	5708	4035
10208	5708	5131
10208	5708	2865
19649	5709	1289
19649	5709	6291
19649	5709	6373
19649	5709	8696
19649	5709	9143
12331	5710	4697
12331	5710	8069
6665	5711	6136
6665	5711	5648
6665	5711	5452
6665	5711	8824
6665	5711	7201
6665	5711	2559
6665	5711	3704
6665	5711	2750
6665	5711	5514
1814	5712	2073
1814	5712	914
1814	5712	4972
3696	5713	3855
3696	5713	8608
3696	5713	4175
3696	5713	9971
3696	5713	7543
3696	5713	4866
3696	5713	1462
3696	5713	3646
3696	5713	9507
15127	5714	317
15127	5714	95
15127	5714	7350
15127	5714	7136
15127	5714	3176
15127	5714	5178
15127	5714	297
15127	5714	9214
15127	5714	727
11184	5715	3207
11184	5715	1235
11184	5715	8964
11184	5715	276
1186	5716	5881
1186	5716	2733
1186	5716	567
1186	5716	4008
1186	5716	7692
1186	5716	5096
1186	5716	4572
1186	5716	3661
1186	5716	1414
9239	5717	7332
9239	5717	1978
9239	5717	1187
1930	5718	8092
1930	5718	7099
1930	5718	8854
1930	5718	4403
18996	5719	5320
18996	5719	7351
18996	5719	8774
18996	5719	1353
18996	5719	1840
18996	5719	4356
18996	5719	6292
18996	5719	4865
18996	5719	6507
9196	5720	3256
9196	5720	6779
9196	5720	3420
9196	5720	7156
9196	5720	2170
9196	5720	3980
5505	5721	4835
18380	5722	4732
18380	5722	29
18380	5722	4095
18380	5722	5836
18380	5722	4275
2107	5723	3242
2107	5723	9278
2107	5723	6381
11178	5724	6149
11178	5724	3765
11178	5724	35
11178	5724	929
1915	5725	9560
7670	5726	4888
7670	5726	4545
7646	5727	7081
7646	5727	3554
7646	5727	1899
7646	5727	3935
7646	5727	5096
7646	5727	3580
7646	5727	8735
7646	5727	6981
13082	5728	376
13082	5728	6827
13082	5728	5187
13082	5728	3393
13082	5728	5195
4550	5729	5365
4550	5729	7992
4550	5729	2964
4550	5729	3268
4550	5729	9111
4550	5729	7059
4550	5729	6741
4550	5729	2633
6016	5730	8271
3326	5731	8595
3326	5731	8963
3326	5731	5807
3326	5731	1299
3326	5731	3627
3326	5731	6886
3326	5731	805
15726	5732	6467
15726	5732	8956
15726	5732	7729
15726	5732	9883
15726	5732	5791
15726	5732	7662
12513	5733	254
12513	5733	1356
12513	5733	5695
12513	5733	5813
12513	5733	1877
12513	5733	8577
12513	5733	4480
1893	5734	708
1893	5734	5146
1893	5734	9115
1893	5734	1967
1893	5734	9509
11195	5735	7494
11195	5735	4838
11195	5735	3396
10543	5736	6045
10543	5736	5010
10543	5736	2694
10543	5736	7822
5936	5737	3905
5936	5737	9401
5936	5737	5990
6095	5738	1461
6095	5738	9692
6095	5738	1208
6095	5738	128
6095	5738	9804
6095	5738	223
5832	5739	6317
5832	5739	9417
5832	5739	1345
5832	5739	6266
5832	5739	6734
5832	5739	3178
17794	5740	9454
17794	5740	1620
17794	5740	7398
17794	5740	9136
17794	5740	7919
17794	5740	2014
17794	5740	2274
17180	5741	8898
17180	5741	5734
17180	5741	8033
2421	5742	107
2421	5742	9485
2421	5742	2396
19585	5743	6994
19585	5743	8714
19585	5743	7315
19585	5743	6230
19585	5743	9578
19585	5743	2722
19585	5743	9461
19585	5743	3639
19585	5743	921
18263	5744	9589
18263	5744	8370
18263	5744	4367
18263	5744	1777
18263	5744	7947
18263	5744	7986
18263	5744	7777
18263	5744	7648
14450	5745	5700
14450	5745	6784
14450	5745	3132
14450	5745	396
14450	5745	6836
14450	5745	644
14450	5745	7438
14450	5745	8409
370	5746	8954
370	5746	2211
370	5746	2307
370	5746	737
370	5746	7083
5565	5747	2121
5565	5747	733
5565	5747	7521
16329	5748	7178
16329	5748	5932
16329	5748	2587
16329	5748	333
5087	5749	2402
5087	5749	2181
5087	5749	5922
5087	5749	2267
8775	5750	6903
8775	5750	9755
7496	5751	6150
7496	5751	1807
7496	5751	8606
7496	5751	276
7496	5751	4682
7496	5751	4832
7496	5751	7552
6947	5752	1950
6947	5752	3222
6947	5752	9077
6947	5752	7794
6947	5752	3717
6947	5752	2580
6947	5752	4665
6947	5752	5089
7388	5753	4259
7388	5753	6286
7388	5753	374
7388	5753	6102
7388	5753	7311
7388	5753	5776
7388	5753	8431
15014	5754	6339
15014	5754	805
15014	5754	4274
18726	5755	3057
18726	5755	2853
18726	5755	3841
18726	5755	6406
18726	5755	2975
571	5756	9545
571	5756	5927
571	5756	9984
571	5756	8080
571	5756	7885
571	5756	5241
571	5756	4354
12589	5757	6845
12589	5757	1893
12589	5757	9990
12589	5757	4900
12589	5757	806
9704	5758	7329
9704	5758	7711
9704	5758	3960
3688	5759	4002
3688	5759	1763
3688	5759	5323
3688	5759	101
3688	5759	615
3688	5759	2852
3688	5759	292
3688	5759	3569
13637	5760	9613
13637	5760	5705
13637	5760	588
13637	5760	3114
13637	5760	1508
13637	5760	3096
13637	5760	6817
4279	5761	4307
4279	5761	3127
6835	5762	4514
6835	5762	6225
6835	5762	5508
6835	5762	3738
6835	5762	3161
6835	5762	877
6835	5762	8547
6835	5762	4062
6835	5762	7894
17854	5763	60
17854	5763	6353
4382	5764	1598
4382	5764	8106
4382	5764	1579
4382	5764	3659
4382	5764	4825
4382	5764	9641
4382	5764	3093
4382	5764	8085
4382	5764	9829
12656	5765	7447
7599	5766	5991
7599	5766	2241
7599	5766	5871
14897	5767	2765
14897	5767	5887
14897	5767	4485
14897	5767	592
14897	5767	6133
14897	5767	8548
14897	5767	6748
14897	5767	5211
14897	5767	8418
13137	5768	1322
13137	5768	1572
13137	5768	9017
13137	5768	4641
14809	5769	9810
14809	5769	914
14092	5770	1210
14092	5770	814
14092	5770	1764
14092	5770	1
14092	5770	5801
14092	5770	3741
14092	5770	5103
8239	5771	7095
8239	5771	6359
8239	5771	273
8239	5771	5098
8239	5771	6569
8239	5771	8232
8239	5771	1272
8239	5771	4958
8239	5771	5861
11722	5772	2293
11722	5772	4239
11722	5772	5530
11722	5772	1514
11722	5772	7507
11722	5772	6160
11722	5772	7462
5118	5773	6470
5118	5773	3990
5118	5773	5290
5118	5773	9826
5118	5773	5668
5118	5773	7011
18606	5774	6697
18606	5774	1049
18606	5774	5716
3751	5775	8308
3751	5775	6839
3751	5775	9054
3751	5775	1775
14128	5776	8214
10449	5777	4528
2448	5778	9435
2448	5778	2375
2448	5778	7652
2448	5778	532
14742	5779	679
14742	5779	9345
14742	5779	723
14742	5779	2600
14742	5779	8994
14742	5779	4161
17375	5780	9912
17375	5780	1475
17375	5780	6803
17375	5780	5598
17375	5780	8644
17375	5780	412
17375	5780	3501
8357	5781	5905
8357	5781	2870
3726	5782	661
3726	5782	8460
3726	5782	5660
3726	5782	2651
3726	5782	7716
3726	5782	984
3726	5782	3907
3726	5782	9443
3726	5782	5517
15416	5783	9243
15416	5783	9245
15416	5783	1529
9292	5784	2650
9292	5784	6261
9292	5784	1458
9292	5784	5444
9292	5784	8365
4541	5785	6589
4541	5785	4871
3983	5786	5017
3983	5786	634
3983	5786	9871
3983	5786	1191
3983	5786	9246
3983	5786	7587
3983	5786	2150
3983	5786	4418
5563	5787	5052
3280	5788	4842
3280	5788	9492
3280	5788	9444
3280	5788	5627
3280	5788	1053
3280	5788	4687
3280	5788	9996
15165	5789	6626
15165	5789	5826
15165	5789	6637
15165	5789	5544
15165	5789	9920
15165	5789	3328
15165	5789	5674
15165	5789	2486
3858	5790	2006
3858	5790	9905
3858	5790	2969
3858	5790	625
124	5791	3918
124	5791	8949
124	5791	2956
124	5791	2241
11137	5792	3737
11137	5792	3503
11137	5792	8853
11137	5792	6925
11137	5792	3900
11137	5792	7551
11137	5792	6729
11137	5792	5919
6407	5793	6314
6407	5793	2707
9896	5794	516
9896	5794	2763
9896	5794	3506
9896	5794	6771
7390	5795	524
7390	5795	206
7390	5795	8942
7390	5795	1464
19563	5796	7049
19563	5796	4910
19563	5796	6987
19563	5796	3232
19563	5796	3636
19563	5796	1755
17051	5797	2221
17051	5797	5037
10485	5798	1368
10485	5798	9603
10485	5798	1241
16578	5799	7097
16578	5799	8300
3872	5800	9078
3872	5800	5740
3872	5800	280
3872	5800	1294
3872	5800	704
3872	5800	558
3872	5800	7201
13606	5801	5737
13606	5801	1688
13606	5801	203
13606	5801	4667
253	5802	7341
253	5802	4016
253	5802	8092
253	5802	1041
253	5802	9611
337	5803	2094
337	5803	8165
7803	5804	610
7803	5804	8473
7803	5804	2375
7803	5804	5403
7803	5804	3019
7803	5804	2328
7803	5804	5824
7803	5804	1329
7803	5804	9805
7933	5805	5329
6986	5806	7394
6986	5806	3344
6986	5806	5455
6986	5806	3280
17364	5807	1425
17364	5807	9453
17364	5807	3391
6390	5808	7162
6390	5808	3772
6390	5808	6027
7881	5809	5523
7881	5809	1380
7881	5809	8241
7881	5809	8808
18900	5810	2420
18900	5810	2013
18900	5810	292
18900	5810	9005
18900	5810	8844
5229	5811	2040
10241	5812	1545
19571	5813	7426
14969	5814	6996
14969	5814	7793
13596	5815	2964
13596	5815	1752
13596	5815	5002
13596	5815	6257
13596	5815	8912
13596	5815	135
13596	5815	3662
13596	5815	242
13596	5815	1555
2235	5816	3101
2235	5816	1433
2235	5816	9433
2235	5816	7691
2235	5816	863
2235	5816	2867
2235	5816	2274
17060	5817	2799
17060	5817	5772
17060	5817	9250
17060	5817	4173
17060	5817	3680
17661	5818	977
17661	5818	5914
17661	5818	9698
17661	5818	9140
17661	5818	4260
13067	5819	5064
13067	5819	4895
13067	5819	5357
13067	5819	4323
13067	5819	6679
13067	5819	5409
13067	5819	7773
13067	5819	9189
13067	5819	2351
16529	5820	1870
16529	5820	2544
11436	5821	5297
11436	5821	9139
8991	5822	9101
8991	5822	8405
8991	5822	7893
8991	5822	1839
8991	5822	491
8991	5822	7246
8991	5822	2454
8991	5822	4760
8991	5822	7532
18499	5823	841
18499	5823	839
18499	5823	8508
18729	5824	6900
18729	5824	8085
18729	5824	917
18729	5824	1874
18239	5825	6938
18239	5825	890
18239	5825	6245
18239	5825	3719
18239	5825	4454
18239	5825	7584
12183	5826	5456
12183	5826	2590
12183	5826	2792
12183	5826	7148
12183	5826	598
12183	5826	5115
12183	5826	8140
12183	5826	1278
12183	5826	8240
8968	5827	3750
8968	5827	7825
8968	5827	3253
9942	5828	3024
9942	5828	5235
9942	5828	4641
10477	5829	9950
10477	5829	3936
10477	5829	4620
10477	5829	3394
10477	5829	6659
817	5830	1742
817	5830	7620
817	5830	3085
817	5830	2046
817	5830	2964
15208	5831	2843
15208	5831	6085
41	5832	2195
41	5832	9391
41	5832	4313
41	5832	9261
41	5832	2078
19394	5833	8694
3313	5834	9260
3313	5834	9850
3313	5834	217
3313	5834	4894
3313	5834	5955
3313	5834	6046
3313	5834	6325
3313	5834	7002
12525	5835	7265
12525	5835	4032
12525	5835	7469
12525	5835	9645
18274	5836	8291
18274	5836	5743
18274	5836	8135
18274	5836	9329
10749	5837	811
10749	5837	6511
10749	5837	5503
10749	5837	7403
10749	5837	3418
10749	5837	199
19687	5838	8981
19687	5838	2180
19687	5838	9386
19687	5838	5778
19687	5838	8560
19687	5838	1610
19687	5838	481
19687	5838	3982
983	5839	6812
983	5839	1357
983	5839	3196
983	5839	1115
983	5839	1399
983	5839	5893
983	5839	3135
983	5839	7650
6856	5840	8535
6856	5840	2662
6856	5840	5497
6856	5840	307
6856	5840	7135
7893	5841	4176
7893	5841	85
7893	5841	6977
7893	5841	1239
7893	5841	1862
7893	5841	943
7893	5841	6893
7893	5841	2939
2946	5842	488
2946	5842	797
2946	5842	2661
2946	5842	5460
3774	5843	1510
3774	5843	1342
3774	5843	9930
3774	5843	1357
3774	5843	6954
3774	5843	1303
8484	5844	5715
12404	5845	6996
12404	5845	3607
12404	5845	5930
12404	5845	4343
12404	5845	1536
12404	5845	2741
5341	5846	4462
5341	5846	7994
5341	5846	6258
5341	5846	7
5341	5846	7956
5341	5846	6394
19658	5847	5925
19658	5847	1374
19658	5847	7601
19658	5847	6148
19658	5847	1569
19658	5847	2014
19658	5847	1559
19658	5847	1602
19658	5847	9884
12283	5848	3177
12283	5848	7512
18868	5849	8353
18868	5849	8243
18868	5849	7178
18868	5849	5443
18868	5849	4980
18868	5849	2214
7543	5850	9792
7543	5850	4115
7543	5850	491
7543	5850	3368
7543	5850	5720
6671	5851	9461
6671	5851	7957
6671	5851	8392
7668	5852	845
7668	5852	5519
7668	5852	4444
7668	5852	8281
7668	5852	4334
7668	5852	5812
7668	5852	3335
7668	5852	8491
3454	5853	4361
4636	5854	7452
4636	5854	1261
4636	5854	1627
4636	5854	6583
4636	5854	5867
4636	5854	7130
4636	5854	5261
2145	5855	252
2145	5855	8933
2145	5855	6504
2145	5855	680
2145	5855	3173
2145	5855	3182
2145	5855	7143
2145	5855	5828
2145	5855	6544
6253	5856	4153
6253	5856	523
6253	5856	3192
6253	5856	486
6253	5856	6944
6253	5856	4254
1514	5857	1622
1514	5857	1440
17165	5858	6986
17165	5858	6381
17165	5858	5107
17165	5858	3869
17165	5858	2709
17165	5858	8672
17165	5858	1457
17165	5858	5378
17165	5858	9894
1879	5859	2665
1879	5859	1844
9883	5860	3867
9883	5860	4228
9883	5860	7165
2068	5861	5425
2068	5861	9836
2068	5861	6422
2068	5861	5282
19115	5862	1031
19115	5862	7241
19115	5862	4023
19115	5862	7815
19115	5862	6301
1056	5863	9862
1056	5863	4579
1056	5863	7090
1056	5863	5718
4278	5864	8454
4278	5864	1724
5508	5865	5628
5508	5865	3506
5508	5865	6358
5508	5865	5124
5508	5865	334
5508	5865	6283
5508	5865	206
5508	5865	8650
5508	5865	864
15498	5866	9916
15498	5866	3339
15498	5866	668
15498	5866	4393
15498	5866	5005
15498	5866	5945
4604	5867	5040
4604	5867	5637
4604	5867	8846
4604	5867	2183
4604	5867	3139
4604	5867	1863
4604	5867	795
4604	5867	3717
14111	5868	2607
14111	5868	291
14111	5868	6761
14111	5868	6122
8877	5869	3089
8877	5869	4898
8877	5869	288
8877	5869	9430
2585	5870	9661
5978	5871	6985
5978	5871	718
5978	5871	1775
5978	5871	3511
4096	5872	5624
4096	5872	953
4096	5872	7358
4096	5872	7602
4096	5872	4665
4096	5872	8081
15482	5873	730
15430	5874	4991
15430	5874	2449
15430	5874	5339
15430	5874	549
15430	5874	6657
15218	5875	8849
7027	5876	8963
7027	5876	3063
7027	5876	947
7027	5876	417
7027	5876	1507
12994	5877	4998
12994	5877	2768
12994	5877	6537
19265	5878	87
19265	5878	2710
19265	5878	9395
19265	5878	2649
19265	5878	5403
19265	5878	7269
19265	5878	9503
19265	5878	1550
3440	5879	4340
3440	5879	6158
3440	5879	8051
3440	5879	6532
3440	5879	2327
3440	5879	8183
3440	5879	9447
17682	5880	7198
17682	5880	8100
17682	5880	7376
17851	5881	646
17851	5881	3213
17851	5881	8623
17851	5881	2091
17851	5881	2065
17851	5881	6442
9248	5882	5516
9248	5882	474
15344	5883	2138
15344	5883	4634
15344	5883	8467
15344	5883	208
15344	5883	9364
15344	5883	4096
15344	5883	2791
9710	5884	9246
12098	5885	2592
12098	5885	2378
9087	5886	4085
9087	5886	3200
9087	5886	6434
9087	5886	1663
9087	5886	6827
9087	5886	3783
9087	5886	1945
9087	5886	4472
9087	5886	9541
10529	5887	6504
10529	5887	1478
10529	5887	3881
4870	5888	5623
4870	5888	60
4870	5888	3767
4870	5888	7853
4870	5888	7480
4870	5888	211
4870	5888	76
19231	5889	4880
19231	5889	2300
19231	5889	522
19231	5889	264
19231	5889	2027
19231	5889	6838
19231	5889	1197
19231	5889	9549
19231	5889	4517
4738	5890	4004
8157	5891	3694
8157	5891	5981
8157	5891	5364
8157	5891	9956
8157	5891	2057
8157	5891	288
14249	5892	9585
14249	5892	6361
14249	5892	6136
14249	5892	6470
14249	5892	9797
19356	5893	5735
19356	5893	162
19356	5893	6817
13545	5894	6992
13545	5894	6137
18818	5895	2229
18818	5895	2506
18818	5895	1704
18818	5895	8408
18818	5895	9448
18818	5895	1178
18818	5895	5532
18818	5895	2242
18118	5896	5832
18118	5896	678
18118	5896	4322
18118	5896	3722
18118	5896	6223
18118	5896	1548
18118	5896	2090
18118	5896	6816
10445	5897	7793
10445	5897	6473
10445	5897	3382
4021	5898	635
2623	5899	8126
2623	5899	324
2623	5899	9875
2623	5899	2800
2623	5899	5925
2623	5899	5756
2623	5899	4837
5258	5900	5953
5258	5900	6616
5258	5900	2910
5258	5900	5204
5258	5900	7994
5258	5900	4855
5258	5900	5245
5258	5900	4570
8887	5901	6407
4325	5902	3211
4325	5902	7208
4325	5902	1647
4325	5902	1627
4325	5902	8130
6666	5903	1396
13281	5904	2209
13281	5904	4076
13281	5904	3371
13281	5904	3014
13281	5904	2646
13281	5904	7691
13281	5904	9077
13281	5904	6583
13281	5904	8058
12375	5905	9520
12375	5905	2278
14683	5906	6974
14683	5906	2916
14683	5906	9413
14683	5906	1533
14683	5906	9399
14683	5906	7757
14683	5906	33
14683	5906	1987
14683	5906	7556
13079	5907	8174
13079	5907	8395
13079	5907	6667
13079	5907	7793
13079	5907	1826
13079	5907	3986
13079	5907	5816
14696	5908	1525
3116	5909	8173
3116	5909	9547
3116	5909	4510
3116	5909	568
3116	5909	1530
3116	5909	3134
3116	5909	1115
3116	5909	2418
3116	5909	5692
3015	5910	8855
3015	5910	9137
3015	5910	9208
3015	5910	1938
3015	5910	6155
3015	5910	7593
3015	5910	3108
3015	5910	1480
6018	5911	1205
6018	5911	8843
6018	5911	6692
6018	5911	25
6018	5911	6042
6018	5911	3084
6018	5911	5453
6018	5911	5276
14427	5912	7324
14427	5912	730
14427	5912	3976
14427	5912	4106
14427	5912	5219
12845	5913	44
12845	5913	55
12845	5913	1558
12845	5913	9895
12845	5913	993
12537	5914	3482
12537	5914	764
12537	5914	6164
12537	5914	1236
12537	5914	3702
12537	5914	8900
11153	5915	1097
11153	5915	9759
11153	5915	5455
10698	5916	696
10698	5916	4508
10698	5916	8554
10698	5916	4991
10698	5916	8794
10698	5916	810
10698	5916	1295
10698	5916	5370
14904	5917	27
14904	5917	4160
14904	5917	8018
14904	5917	1102
14904	5917	4962
14904	5917	3504
14904	5917	9878
14904	5917	6359
2700	5918	2505
2700	5918	4822
2700	5918	3069
2700	5918	3993
2700	5918	7644
15340	5919	7456
15340	5919	9046
15340	5919	9910
15340	5919	5617
15340	5919	9665
15340	5919	1424
15340	5919	3926
15340	5919	7373
15340	5919	2216
14076	5920	7229
14076	5920	9801
14076	5920	7432
8120	5921	8706
8120	5921	8555
8120	5921	7559
8120	5921	2029
8120	5921	9666
8120	5921	3246
8120	5921	875
8120	5921	5266
8120	5921	497
8345	5922	1841
8345	5922	2229
8345	5922	3673
8345	5922	3332
8345	5922	4768
8345	5922	1730
8345	5922	654
5364	5923	6134
5364	5923	752
5364	5923	377
5364	5923	98
5364	5923	1515
5364	5923	5045
5364	5923	7583
19621	5924	4581
19621	5924	763
19621	5924	1527
4360	5925	4862
1989	5926	8003
1989	5926	4092
1989	5926	9298
1989	5926	8326
1989	5926	5919
1989	5926	1227
1989	5926	5718
1989	5926	7415
16354	5927	669
16354	5927	580
16354	5927	2480
16354	5927	742
16354	5927	6436
16354	5927	7878
16354	5927	7216
16354	5927	2538
1726	5928	6771
1726	5928	8324
1726	5928	9466
1726	5928	2787
4865	5929	4748
4865	5929	7033
4865	5929	759
4865	5929	7031
4865	5929	6565
7561	5930	294
7561	5930	5032
7561	5930	7945
7561	5930	3230
5390	5931	9034
5390	5931	9509
5390	5931	502
5390	5931	9090
5390	5931	1484
5390	5931	5309
5390	5931	7042
17345	5932	2841
15744	5933	9674
15744	5933	8962
15744	5933	3018
4103	5934	5823
9825	5935	4760
9825	5935	4801
9825	5935	2102
9825	5935	474
9825	5935	8521
9825	5935	3701
1589	5936	1118
8271	5937	6187
8271	5937	6408
8271	5937	163
8271	5937	6922
8271	5937	7498
8271	5937	5313
14828	5938	5169
14828	5938	7271
14828	5938	2312
14828	5938	9664
1562	5939	4917
1562	5939	9999
1562	5939	1871
1562	5939	3112
67	5940	1715
67	5940	7413
67	5940	9843
67	5940	9154
67	5940	6975
18574	5941	7564
18574	5941	4324
18574	5941	8332
18574	5941	9860
3462	5942	3765
3462	5942	3488
3462	5942	7468
3462	5942	3311
6306	5943	8164
6306	5943	5977
6306	5943	9076
6306	5943	5587
6306	5943	5051
6306	5943	7405
6306	5943	9151
6306	5943	1713
6306	5943	8996
5519	5944	3641
5519	5944	1638
5519	5944	1150
5519	5944	104
5519	5944	1591
5519	5944	3753
5657	5945	9467
5657	5945	5809
5657	5945	6856
5657	5945	4136
5657	5945	4451
5657	5945	5018
7638	5946	89
7638	5946	6482
7638	5946	7507
7638	5946	5202
7638	5946	4853
7638	5946	6664
7638	5946	1783
7638	5946	1062
7638	5946	8560
10831	5947	3984
10831	5947	5388
10831	5947	3676
15017	5948	2978
15017	5948	4146
15017	5948	3875
17455	5949	3891
17455	5949	1330
17455	5949	1335
17455	5949	1822
17455	5949	5304
17455	5949	1712
14199	5950	8378
14199	5950	1113
14199	5950	4015
14199	5950	6475
700	5951	9077
700	5951	399
700	5951	5894
700	5951	7921
19485	5952	3392
19485	5952	6209
19485	5952	5494
19485	5952	6925
19485	5952	5604
19485	5952	3056
19485	5952	2127
13401	5953	856
13401	5953	1096
13401	5953	1926
13401	5953	2982
13401	5953	4217
1798	5954	9293
1798	5954	6299
1798	5954	2224
15655	5955	7446
15655	5955	1245
2250	5956	83
4015	5957	1853
4015	5957	9776
4015	5957	3709
4015	5957	4419
4015	5957	9023
2493	5958	9074
2493	5958	8159
2493	5958	8587
2493	5958	1744
2493	5958	528
2493	5958	9615
3620	5959	6987
3620	5959	5264
3620	5959	5908
652	5960	1044
652	5960	8327
652	5960	6206
652	5960	184
652	5960	3920
652	5960	3767
652	5960	7442
14113	5961	8866
14113	5961	4230
18986	5962	8465
18986	5962	8222
18986	5962	7752
18986	5962	198
18986	5962	4249
18986	5962	3479
18986	5962	768
18986	5962	3201
1285	5963	7699
13129	5964	2417
13129	5964	6478
13129	5964	1135
13129	5964	5703
13129	5964	5379
13129	5964	8621
13129	5964	9532
6021	5965	409
6021	5965	7282
6021	5965	1143
17682	5966	5405
17682	5966	4189
17682	5966	4330
17682	5966	2852
17682	5966	5608
17682	5966	4820
17682	5966	2008
3080	5967	4551
3080	5967	1290
3080	5967	4109
3080	5967	8429
3080	5967	4682
3080	5967	4092
3080	5967	81
3080	5967	5614
19886	5968	5407
452	5969	3666
19948	5970	3583
19948	5970	1780
19948	5970	6495
19948	5970	2942
19948	5970	3085
19948	5970	5698
19948	5970	6530
7695	5971	4017
7695	5971	2912
7695	5971	6885
1101	5972	525
1101	5972	2563
1101	5972	7085
1101	5972	1797
1101	5972	4550
1101	5972	4755
903	5973	1762
903	5973	2148
903	5973	604
903	5973	9675
903	5973	8905
903	5973	7954
903	5973	7110
903	5973	8118
1360	5974	5022
1360	5974	309
1360	5974	8275
1360	5974	7205
1360	5974	5515
1360	5974	8346
1360	5974	6239
13686	5975	358
13686	5975	6525
13686	5975	7939
13686	5975	8795
13686	5975	1268
13686	5975	6736
13686	5975	5170
13686	5975	6545
13686	5975	1328
17064	5976	6537
17064	5976	3332
17064	5976	3703
17064	5976	9618
17064	5976	3587
17064	5976	5923
7723	5977	9917
7723	5977	5522
7723	5977	8020
7723	5977	8409
7723	5977	6170
7723	5977	9382
7723	5977	8268
9608	5978	7579
9608	5978	9720
9608	5978	1519
9608	5978	7172
9608	5978	3418
9608	5978	1303
2440	5979	7872
2440	5979	8753
2440	5979	4756
2440	5979	6017
2440	5979	1634
2440	5979	8384
2440	5979	9088
2440	5979	498
435	5980	3524
435	5980	5958
435	5980	6493
435	5980	4103
435	5980	8480
435	5980	7093
435	5980	6469
435	5980	2632
17297	5981	2932
17297	5981	6801
17297	5981	9584
13160	5982	5096
13160	5982	3583
13160	5982	7981
4167	5983	8360
4167	5983	3144
4167	5983	2044
4167	5983	6053
4167	5983	4424
4167	5983	5211
4167	5983	5159
9483	5984	1322
9483	5984	609
9483	5984	7863
9483	5984	7470
9483	5984	4266
9483	5984	7927
9483	5984	2575
9483	5984	9571
3228	5985	4425
3228	5985	8581
3228	5985	3275
3228	5985	1646
3228	5985	8481
3228	5985	710
3228	5985	7778
11281	5986	1484
11281	5986	9470
11281	5986	3147
11281	5986	5697
13622	5987	3978
13622	5987	5177
13622	5987	8390
13622	5987	6297
13622	5987	1101
13622	5987	990
13622	5987	4578
13622	5987	3130
13622	5987	4408
11783	5988	5302
11783	5988	5999
11783	5988	4278
11783	5988	7809
3572	5989	4344
3572	5989	6648
3572	5989	5789
3572	5989	5418
3572	5989	9559
3572	5989	5545
3572	5989	792
3572	5989	1327
19481	5990	1301
19481	5990	2143
19902	5991	1737
19902	5991	204
13704	5992	4600
13704	5992	9870
13704	5992	2134
5849	5993	8199
5849	5993	7912
5849	5993	2355
5849	5993	2653
5849	5993	4791
5849	5993	4448
5849	5993	3648
5849	5993	526
15656	5994	919
15656	5994	1124
15656	5994	9461
15656	5994	6202
15656	5994	6182
15656	5994	4479
15656	5994	2778
15656	5994	1808
15656	5994	1603
12785	5995	5369
12785	5995	260
12785	5995	3599
12785	5995	3722
9280	5996	5428
9280	5996	5892
9280	5996	5371
19698	5997	2239
19698	5997	1107
19698	5997	2720
19698	5997	234
19698	5997	4810
19698	5997	8567
4330	5998	6466
4330	5998	9857
4330	5998	1739
4330	5998	5134
4330	5998	6914
223	5999	6086
223	5999	4416
223	5999	6432
223	5999	7927
223	5999	5955
223	5999	2267
7525	6000	8979
7525	6000	4504
7525	6000	9221
7525	6000	4120
7525	6000	3872
16984	6001	5853
16984	6001	4609
16984	6001	7550
16984	6001	2959
16984	6001	7669
16984	6001	6906
16984	6001	9046
16984	6001	3424
16984	6001	3864
5465	6002	100
5465	6002	3881
5465	6002	4715
5465	6002	9144
5465	6002	4544
5465	6002	7862
5465	6002	4151
5465	6002	5156
5650	6003	6040
5650	6003	2870
5650	6003	7214
3023	6004	9588
3023	6004	1518
3023	6004	217
3023	6004	8536
3023	6004	2646
3023	6004	4356
3023	6004	2231
3023	6004	5918
3023	6004	5616
9521	6005	2951
9521	6005	5714
9521	6005	4819
9521	6005	1676
9521	6005	7020
9521	6005	3849
8131	6006	3425
8131	6006	6345
8131	6006	7920
7675	6007	5951
7675	6007	6663
19226	6008	9777
19226	6008	6215
19226	6008	8353
19226	6008	2715
19226	6008	1771
19226	6008	6267
19226	6008	711
19226	6008	3952
3743	6009	5709
3743	6009	5660
3743	6009	7764
3743	6009	2825
4152	6010	6145
4152	6010	3163
11755	6011	3322
11755	6011	6079
11755	6011	2658
11755	6011	1088
11755	6011	1901
11755	6011	3887
11755	6011	8311
11755	6011	9268
11755	6011	1869
7606	6012	5514
7606	6012	9118
7606	6012	4811
7606	6012	4554
7606	6012	6428
5012	6013	2536
5012	6013	7261
5012	6013	9714
5012	6013	2046
5012	6013	694
5012	6013	4098
5012	6013	3407
15150	6014	7888
15150	6014	555
10217	6015	2984
10217	6015	9878
10217	6015	5813
10217	6015	7887
10217	6015	6850
10217	6015	4220
10217	6015	5625
19445	6016	80
19445	6016	1190
19445	6016	5716
19445	6016	9076
40	6017	7392
40	6017	4662
40	6017	9254
40	6017	9683
40	6017	3547
40	6017	4741
731	6018	88
731	6018	9250
731	6018	3989
731	6018	5187
731	6018	9516
731	6018	5974
14704	6019	1714
14704	6019	8942
17249	6020	5157
17249	6020	3717
17249	6020	3214
17249	6020	6219
17249	6020	6545
17249	6020	3468
17307	6021	2915
17307	6021	6713
17307	6021	3562
17307	6021	8870
17307	6021	5916
16642	6022	4273
16642	6022	7198
16642	6022	2176
16642	6022	4384
1856	6023	1461
1856	6023	5832
1856	6023	5195
1856	6023	7908
1856	6023	5943
1856	6023	5891
1856	6023	6745
5974	6024	7337
5974	6024	651
5974	6024	2388
5974	6024	4946
5974	6024	1221
5974	6024	7699
5974	6024	5835
5974	6024	4855
5974	6024	857
17528	6025	233
17528	6025	1166
17528	6025	9652
17528	6025	9964
17528	6025	2847
17528	6025	4177
13128	6026	3335
13128	6026	5437
13128	6026	2628
13128	6026	193
13128	6026	2936
13128	6026	7530
13128	6026	9813
91	6027	7022
13972	6028	4286
13972	6028	999
13972	6028	7500
13972	6028	2901
13972	6028	4866
13972	6028	1868
13972	6028	9608
5087	6029	5891
5087	6029	1989
5087	6029	2967
19978	6030	6975
2521	6031	7381
2521	6031	6932
2521	6031	2332
2521	6031	8620
2521	6031	9289
2521	6031	6260
2521	6031	770
2521	6031	6766
2521	6031	2290
10514	6032	5246
10514	6032	9818
10514	6032	7435
10514	6032	3480
10514	6032	8040
10514	6032	2929
10514	6032	1143
10514	6032	6768
12113	6033	319
12113	6033	5087
12113	6033	5418
12113	6033	5837
12113	6033	2634
12113	6033	6376
12387	6034	4623
12387	6034	7150
12387	6034	4438
12387	6034	7634
12387	6034	5339
12387	6034	5342
6658	6035	2087
15008	6036	5172
15008	6036	7603
15008	6036	3492
15008	6036	7741
4726	6037	5026
4726	6037	8831
4726	6037	7184
4726	6037	7060
4726	6037	8967
4726	6037	5854
4726	6037	8292
4726	6037	5086
16132	6038	3679
14340	6039	759
14340	6039	2266
14340	6039	3687
14340	6039	9529
14340	6039	9950
14340	6039	6686
14340	6039	9237
14340	6039	4526
14340	6039	5135
441	6040	8286
441	6040	9089
441	6040	6259
441	6040	9135
441	6040	1154
441	6040	4525
441	6040	7818
441	6040	710
1319	6041	7669
1319	6041	3065
1319	6041	8384
1319	6041	5012
1319	6041	8420
1319	6041	9885
1319	6041	2790
18096	6042	8638
18096	6042	7697
18096	6042	4797
18096	6042	1374
18096	6042	2860
18096	6042	6165
18096	6042	9515
18096	6042	212
17190	6043	7
19784	6044	8865
19784	6044	6854
19784	6044	2378
19784	6044	466
19784	6044	8655
19784	6044	5589
19784	6044	768
19784	6044	2130
3288	6045	4223
3288	6045	4172
3288	6045	7832
3288	6045	4199
3288	6045	4071
3288	6045	655
15016	6046	3000
15016	6046	7128
15016	6046	7752
15016	6046	1682
15016	6046	1165
15016	6046	5451
15016	6046	5455
19354	6047	4678
19354	6047	459
19354	6047	3688
19354	6047	8978
19354	6047	7465
19354	6047	1850
9699	6048	6503
9699	6048	549
9699	6048	8249
9699	6048	1995
9699	6048	8243
9699	6048	9916
9699	6048	7125
9699	6048	6630
14177	6049	1618
14177	6049	1795
14177	6049	3309
14177	6049	8571
14177	6049	8494
14177	6049	1848
14177	6049	279
17053	6050	2226
17053	6050	2622
17053	6050	2702
17053	6050	5066
17053	6050	1549
4452	6051	1881
4452	6051	7119
4452	6051	1722
4452	6051	9204
4452	6051	6237
4452	6051	5210
4452	6051	3446
4452	6051	5042
14533	6052	9408
14533	6052	5930
14533	6052	1939
14533	6052	3303
14533	6052	9704
14533	6052	6395
7026	6053	9202
7026	6053	9598
7026	6053	7027
7026	6053	1954
7026	6053	3197
7026	6053	8027
7026	6053	4261
7026	6053	2942
7026	6053	540
4956	6054	836
4956	6054	1029
17383	6055	8076
17383	6055	385
17383	6055	5383
17383	6055	2481
11354	6056	2435
11354	6056	3843
11354	6056	2258
11354	6056	4248
11354	6056	6860
11354	6056	1842
5741	6057	1562
5741	6057	8691
5741	6057	5612
5741	6057	7310
19581	6058	5467
19581	6058	281
19581	6058	1248
19581	6058	3279
15051	6059	8121
15051	6059	3059
15051	6059	8616
15051	6059	9051
15051	6059	3651
18524	6060	255
18524	6060	6914
18524	6060	7674
18524	6060	1242
18524	6060	283
18524	6060	2078
18524	6060	5994
19795	6061	5642
19795	6061	3976
19795	6061	6987
19795	6061	4434
19795	6061	766
19795	6061	9899
19795	6061	1372
19795	6061	885
19795	6061	8737
19956	6062	2467
16921	6063	8358
16921	6063	4803
16921	6063	4122
16921	6063	8257
16921	6063	1803
16921	6063	1745
3287	6064	1797
3287	6064	6594
3287	6064	9594
3287	6064	512
3287	6064	8208
3287	6064	4697
3287	6064	1439
3287	6064	8313
6230	6065	1893
6230	6065	4214
6230	6065	4742
3359	6066	9989
3359	6066	7450
3359	6066	9933
3359	6066	3842
3359	6066	3151
3359	6066	3422
9720	6067	4656
9720	6067	6195
9720	6067	3806
16039	6068	3978
16039	6068	6923
16039	6068	4460
16039	6068	979
16039	6068	3494
14671	6069	9386
14671	6069	9951
3329	6070	2364
3329	6070	2743
3329	6070	1512
3329	6070	4189
16333	6071	9747
16333	6071	2322
16333	6071	7709
16333	6071	1637
16333	6071	3151
5071	6072	6688
5071	6072	381
5071	6072	1699
5071	6072	7344
5071	6072	8913
5071	6072	7686
5071	6072	2149
5071	6072	1268
2027	6073	1739
2027	6073	9720
2027	6073	3657
2027	6073	6367
8271	6074	1541
8271	6074	6011
6707	6075	2209
6707	6075	6277
6707	6075	1540
6247	6076	7029
6247	6076	4125
6247	6076	3670
6247	6076	9618
6247	6076	204
6247	6076	4172
6247	6076	7115
6249	6077	6478
6249	6077	300
6249	6077	1998
6249	6077	3043
6249	6077	4120
6249	6077	6661
6249	6077	8016
4280	6078	9921
4280	6078	6677
4280	6078	5076
4280	6078	1467
4280	6078	6561
4280	6078	5314
3583	6079	477
3583	6079	8328
4894	6080	5123
4894	6080	8028
4894	6080	4561
4894	6080	4735
2823	6081	2260
2823	6081	5783
2823	6081	401
2823	6081	4331
12948	6082	616
12948	6082	6884
12948	6082	4379
12948	6082	2633
1321	6083	9124
1321	6083	2751
1321	6083	3741
1321	6083	1234
1321	6083	3429
1321	6083	4819
1321	6083	8112
1321	6083	5682
18571	6084	1217
18571	6084	4533
18571	6084	2537
18571	6084	5096
18571	6084	7825
18571	6084	4515
14530	6085	4621
14530	6085	4761
14530	6085	2838
14530	6085	1879
14530	6085	8730
14530	6085	1949
14530	6085	6845
14530	6085	591
10246	6086	2288
225	6087	7061
3299	6088	7471
3299	6088	793
3299	6088	9563
16584	6089	2645
16584	6089	9519
16584	6089	5137
17584	6090	7543
17969	6091	5446
17969	6091	9468
17969	6091	5242
17969	6091	651
17969	6091	7247
17969	6091	8706
17969	6091	8506
17969	6091	1710
2456	6092	8308
2456	6092	9940
14964	6093	6467
14964	6093	1967
14964	6093	5879
14964	6093	2581
6462	6094	3445
6462	6094	4124
6462	6094	4795
6462	6094	3101
6462	6094	7060
6462	6094	1953
3784	6095	9374
3784	6095	7769
3784	6095	3233
3784	6095	7753
665	6096	3563
665	6096	5163
665	6096	3246
665	6096	8958
665	6096	5118
665	6096	8846
665	6096	9545
665	6096	7545
665	6096	2690
4128	6097	7904
4128	6097	897
4134	6098	1610
13544	6099	6058
13544	6099	9496
16682	6100	9140
16682	6100	6893
16682	6100	9293
16682	6100	3893
16682	6100	1448
16682	6100	9023
16682	6100	7452
6879	6101	2990
6879	6101	2793
6879	6101	105
6879	6101	5064
6879	6101	25
6879	6101	7941
14160	6102	8909
14160	6102	6934
14160	6102	1109
14160	6102	4598
14160	6102	726
14160	6102	9747
372	6103	8835
372	6103	8026
372	6103	2799
372	6103	8540
372	6103	5727
372	6103	6202
372	6103	3560
372	6103	2130
18127	6104	7445
18127	6104	5284
18127	6104	1917
18127	6104	3307
18127	6104	5215
8100	6105	2989
8100	6105	6997
8100	6105	4035
8100	6105	8008
3135	6106	4036
18611	6107	9173
18611	6107	5012
18611	6107	221
18611	6107	8494
18611	6107	2781
18611	6107	9485
18611	6107	8283
10558	6108	8002
10558	6108	6674
10558	6108	3577
10558	6108	6541
10558	6108	2141
10558	6108	6918
12180	6109	7179
12180	6109	6110
12180	6109	2894
12180	6109	47
12180	6109	83
12180	6109	4852
12180	6109	3609
12180	6109	8923
11192	6110	2981
11192	6110	2051
11192	6110	296
11192	6110	7169
8816	6111	1867
8816	6111	7907
8816	6111	5867
11897	6112	8434
11897	6112	845
3413	6113	6145
3413	6113	3673
3413	6113	1053
3413	6113	7163
3413	6113	7044
3413	6113	2630
3413	6113	4455
3413	6113	4888
3413	6113	9258
12793	6114	8388
12793	6114	6489
12793	6114	2492
12793	6114	939
12793	6114	7305
12793	6114	1376
4857	6115	651
4857	6115	4661
4857	6115	9899
9573	6116	5540
9573	6116	3431
9573	6116	8389
9573	6116	7378
9573	6116	1050
9573	6116	2866
9573	6116	5313
13377	6117	9117
13377	6117	6790
13377	6117	8080
13377	6117	3047
1646	6118	7857
1646	6118	3833
4444	6119	7099
4444	6119	7793
4444	6119	6141
4444	6119	133
4444	6119	9794
4444	6119	9561
4444	6119	7371
4444	6119	8677
3446	6120	2546
3446	6120	407
3446	6120	4497
3446	6120	1689
3446	6120	6461
3446	6120	2966
3446	6120	8945
3446	6120	3523
7312	6121	4936
7312	6121	2568
7312	6121	6207
7312	6121	7756
2367	6122	7376
2367	6122	5914
2367	6122	7018
2367	6122	6915
2367	6122	2394
2678	6123	6425
13443	6124	6578
13443	6124	1458
13443	6124	1972
13443	6124	6791
13443	6124	396
13443	6124	450
13443	6124	1941
13443	6124	9645
13443	6124	3966
12719	6125	7699
12719	6125	34
12719	6125	1583
12719	6125	845
12719	6125	3402
12719	6125	472
12719	6125	207
12719	6125	4071
12719	6125	7380
15660	6126	4194
15660	6126	7058
15660	6126	8442
15660	6126	4519
15660	6126	8966
15660	6126	1961
15660	6126	6340
15660	6126	3250
13301	6127	1509
13301	6127	6200
13301	6127	1810
13301	6127	47
4570	6128	4168
4570	6128	3762
4570	6128	2620
4570	6128	7490
4570	6128	497
4570	6128	585
7668	6129	484
7668	6129	37
7668	6129	3437
7668	6129	7572
7668	6129	9817
7668	6129	3215
18567	6130	2410
18567	6130	6679
18567	6130	8870
18567	6130	6615
14398	6131	1033
14398	6131	2891
14398	6131	8845
14398	6131	3509
14398	6131	9165
14398	6131	7527
1483	6132	25
1483	6132	2672
1483	6132	7626
1483	6132	7463
1483	6132	3519
1483	6132	5860
1483	6132	1276
1483	6132	3748
13278	6133	9567
13278	6133	3408
1870	6134	1676
1870	6134	5713
1870	6134	4956
1870	6134	4134
1870	6134	7734
1870	6134	9075
1870	6134	5674
13897	6135	9256
13897	6135	8775
16684	6136	7073
16684	6136	4746
16684	6136	5934
16684	6136	2706
15321	6137	241
15321	6137	3852
15321	6137	9016
14808	6138	9540
14808	6138	524
1853	6139	4738
1853	6139	8043
1853	6139	8515
1853	6139	5904
1853	6139	5623
1853	6139	8880
1853	6139	6280
1853	6139	3416
1853	6139	8437
5374	6140	3933
5374	6140	1858
5374	6140	7690
5374	6140	5383
5374	6140	9884
5374	6140	8075
13179	6141	7809
13179	6141	9532
13179	6141	3177
13179	6141	5810
13179	6141	5943
11196	6142	1727
11196	6142	8233
11196	6142	5322
11196	6142	4249
11196	6142	269
11196	6142	824
11196	6142	2058
11196	6142	4933
5483	6143	9431
5483	6143	1275
5483	6143	1252
5483	6143	9486
5483	6143	2815
9081	6144	8124
9081	6144	3288
9081	6144	3308
9081	6144	6504
9081	6144	1900
9081	6144	4558
9081	6144	2522
8011	6145	8666
8011	6145	4243
8011	6145	4445
8011	6145	193
8011	6145	146
8011	6145	1800
8011	6145	6691
8011	6145	31
8011	6145	2295
17597	6146	7360
17597	6146	2266
17597	6146	2516
17597	6146	3887
17597	6146	842
10170	6147	8813
17916	6148	6386
17916	6148	9123
17916	6148	8657
17916	6148	9754
17916	6148	216
17916	6148	7625
17916	6148	9249
17916	6148	7457
17916	6148	1728
5140	6149	7655
5140	6149	6073
5140	6149	9027
5140	6149	5425
5140	6149	2674
5140	6149	9691
16694	6150	538
16694	6150	5202
16694	6150	1006
16694	6150	8052
16694	6150	6216
16694	6150	9806
16694	6150	2349
16694	6150	2381
16906	6151	1927
16906	6151	107
16906	6151	3703
16906	6151	6397
16906	6151	8144
16906	6151	9907
16906	6151	3041
16906	6151	6843
16906	6151	9560
11551	6152	2225
11551	6152	6015
11551	6152	7026
6991	6153	5390
6991	6153	9585
6991	6153	5077
6991	6153	1020
6991	6153	5592
17263	6154	2677
17263	6154	3639
17263	6154	1371
17263	6154	7498
17263	6154	5336
17263	6154	8200
17263	6154	9593
17263	6154	5857
2492	6155	338
2492	6155	1808
2492	6155	8343
2492	6155	2285
2492	6155	6030
2492	6155	8989
5255	6156	940
5255	6156	8881
5255	6156	4899
5255	6156	8637
5255	6156	8339
9161	6157	407
9161	6157	4425
9161	6157	7436
9161	6157	9613
9161	6157	3012
9161	6157	8040
9161	6157	4348
9161	6157	4627
9161	6157	7241
12243	6158	3202
12243	6158	9015
12243	6158	4972
12243	6158	6121
12243	6158	7574
3997	6159	4766
3997	6159	3944
3997	6159	3996
3997	6159	9777
8808	6160	9971
8808	6160	7300
1002	6161	2041
1002	6161	8015
1002	6161	7975
1002	6161	4688
1002	6161	7587
1002	6161	8986
1002	6161	1782
1002	6161	130
1002	6161	4912
17700	6162	29
14656	6163	7829
14656	6163	7381
14656	6163	5648
14656	6163	8030
14656	6163	984
14656	6163	8385
14656	6163	6147
15856	6164	3706
15651	6165	8528
15651	6165	9548
15651	6165	1417
15651	6165	3072
15651	6165	4026
19348	6166	3296
19348	6166	9863
19348	6166	5400
19348	6166	9051
19348	6166	3936
19348	6166	7372
19348	6166	4562
17245	6167	2712
17245	6167	9429
17245	6167	8785
17245	6167	3374
4977	6168	9633
4977	6168	5629
4977	6168	7460
4977	6168	5504
4977	6168	7349
4977	6168	5861
4977	6168	7080
4977	6168	3050
13292	6169	9790
13292	6169	5884
18514	6170	1746
18514	6170	218
11692	6171	6874
11692	6171	3620
11692	6171	5815
11692	6171	8944
11692	6171	9901
11692	6171	5442
11692	6171	8639
16857	6172	7003
16857	6172	5840
16857	6172	7837
16857	6172	2258
16857	6172	8963
16857	6172	3900
1546	6173	4996
1546	6173	2116
1546	6173	4921
724	6174	2344
724	6174	2999
724	6174	8243
724	6174	6710
724	6174	8389
1293	6175	2553
3138	6176	4205
3138	6176	8701
3138	6176	6206
3138	6176	8336
3138	6176	3983
3138	6176	6708
3138	6176	957
18399	6177	3282
18399	6177	7875
18399	6177	8741
2587	6178	2863
2587	6178	2716
2587	6178	6513
2587	6178	3387
2587	6178	5038
2587	6178	4855
3124	6179	1267
3124	6179	1175
8912	6180	9404
8912	6180	3643
8912	6180	9102
3928	6181	9031
3928	6181	5153
3928	6181	4090
3928	6181	4139
10315	6182	7132
10315	6182	6522
10315	6182	2746
10315	6182	2762
10315	6182	4984
17252	6183	9241
17252	6183	688
17252	6183	1904
17252	6183	5474
17252	6183	2135
17252	6183	7247
17252	6183	8509
17252	6183	1431
17125	6184	6869
17125	6184	9351
17125	6184	5347
17125	6184	1796
17125	6184	2961
17125	6184	3692
17125	6184	7108
18024	6185	6069
18024	6185	1340
19695	6186	8862
19695	6186	2497
19695	6186	8321
19695	6186	3183
17059	6187	3498
14379	6188	1568
14379	6188	5852
14379	6188	5245
14379	6188	1895
14379	6188	5235
14379	6188	6432
14379	6188	8333
1659	6189	195
1659	6189	1784
1659	6189	6654
1659	6189	9982
19427	6190	6554
19427	6190	9392
19427	6190	4573
19427	6190	4325
19427	6190	1220
19427	6190	866
18397	6191	28
445	6192	9413
445	6192	42
445	6192	2816
445	6192	9107
445	6192	4720
445	6192	9065
7275	6193	105
7275	6193	1948
7275	6193	7618
1124	6194	8448
8915	6195	7122
8915	6195	9225
8915	6195	6427
8915	6195	93
8915	6195	3992
8915	6195	5257
8915	6195	2795
8915	6195	4444
8915	6195	3971
3177	6196	2151
3177	6196	4234
3177	6196	1106
3177	6196	5055
4352	6197	2113
4352	6197	2040
4352	6197	3895
4352	6197	1362
8313	6198	7056
8313	6198	8921
8313	6198	8713
1726	6199	1461
1726	6199	3849
1726	6199	1393
1726	6199	8691
1726	6199	2040
1726	6199	465
1726	6199	3008
1726	6199	110
1726	6199	3510
13328	6200	3789
13328	6200	6506
13328	6200	1469
13328	6200	3365
13328	6200	665
13328	6200	5760
14305	6201	4868
10664	6202	9691
10664	6202	8210
10664	6202	7270
10664	6202	9865
7306	6203	6155
7306	6203	289
7306	6203	2169
7306	6203	4344
7306	6203	5466
7306	6203	5081
7306	6203	5714
7306	6203	3194
4316	6204	1232
4316	6204	8172
4316	6204	5332
4316	6204	6495
4316	6204	1689
15685	6205	7361
15685	6205	7709
15685	6205	3340
15685	6205	7388
15685	6205	1483
15685	6205	8370
15685	6205	9648
70	6206	8632
70	6206	6567
70	6206	4828
70	6206	1610
70	6206	7197
70	6206	4359
70	6206	4833
70	6206	5851
18380	6207	7611
11960	6208	9630
11960	6208	3594
11960	6208	6775
11960	6208	5043
19741	6209	6387
19741	6209	5875
19741	6209	4039
19741	6209	2465
19741	6209	3248
19741	6209	9079
19741	6209	6700
19741	6209	6159
16066	6210	6742
16066	6210	548
16066	6210	9990
12357	6211	3977
12357	6211	6860
12357	6211	2592
10114	6212	946
10114	6212	2768
10114	6212	6553
10114	6212	8257
4855	6213	192
4855	6213	7216
4855	6213	7657
4855	6213	6360
673	6214	187
673	6214	5090
673	6214	2612
673	6214	4551
14636	6215	6244
14636	6215	1513
14636	6215	1886
4155	6216	2259
4155	6216	8192
4155	6216	5872
4155	6216	8955
18284	6217	9887
18284	6217	680
18284	6217	4559
18284	6217	1755
18284	6217	8710
445	6218	3254
445	6218	9183
445	6218	2223
445	6218	1107
445	6218	60
445	6218	5938
445	6218	7814
12407	6219	7206
12407	6219	2479
12407	6219	7558
12407	6219	7525
12407	6219	2231
12407	6219	6490
12407	6219	9850
12407	6219	1535
7515	6220	4172
7515	6220	6181
7515	6220	9547
7515	6220	5763
7515	6220	198
7515	6220	5745
7515	6220	7361
7515	6220	9167
7515	6220	2457
9374	6221	8119
9374	6221	7417
9374	6221	8316
9374	6221	3411
9374	6221	4715
9374	6221	9320
9374	6221	7691
6908	6222	9676
6908	6222	2489
6908	6222	537
6908	6222	1953
6908	6222	8346
15563	6223	7066
15563	6223	5452
15563	6223	3740
15563	6223	4170
15563	6223	6444
15563	6223	9349
8474	6224	9323
8474	6224	1238
8474	6224	4299
8474	6224	3466
8474	6224	4767
8474	6224	9389
8474	6224	9593
8474	6224	8246
8474	6224	8426
4329	6225	618
4329	6225	9698
4329	6225	3137
4329	6225	4203
4329	6225	977
4329	6225	7988
4573	6226	8538
4573	6226	612
4573	6226	1202
4573	6226	8124
4573	6226	6863
4573	6226	3143
4573	6226	8714
4573	6226	5111
9616	6227	6861
9616	6227	8563
9616	6227	7025
9616	6227	52
9616	6227	8837
9616	6227	1161
9616	6227	2794
9616	6227	5300
6847	6228	9973
6847	6228	7740
6847	6228	2285
6847	6228	8017
6847	6228	7658
6847	6228	4826
6847	6228	813
6847	6228	2357
4816	6229	6447
4816	6229	6149
4816	6229	3131
4816	6229	3234
4816	6229	4871
4816	6229	3946
4816	6229	3258
4816	6229	3529
3090	6230	8859
3090	6230	6712
18137	6231	1476
15844	6232	7162
15844	6232	7049
15844	6232	7300
15844	6232	7069
15844	6232	6763
15844	6232	2930
14930	6233	9658
14930	6233	5749
14930	6233	365
14930	6233	5438
14930	6233	7168
14930	6233	5578
14930	6233	4836
14930	6233	2221
18539	6234	1189
18539	6234	5379
18539	6234	9786
18539	6234	8242
155	6235	771
155	6235	1802
155	6235	6286
155	6235	9009
155	6235	4152
17975	6236	984
17975	6236	1563
17975	6236	195
11148	6237	3883
11148	6237	8274
11148	6237	9021
19584	6238	928
19584	6238	4128
19584	6238	1856
19584	6238	4522
19584	6238	7267
19584	6238	4222
19584	6238	9809
7	6239	5577
7	6239	7079
7	6239	8182
7	6239	9115
7	6239	7674
19583	6240	8195
19583	6240	7858
19583	6240	3497
19583	6240	1979
19583	6240	6127
19583	6240	9013
19583	6240	1985
19583	6240	5939
3031	6241	975
3031	6241	7526
10398	6242	4990
10398	6242	60
15835	6243	296
15835	6243	4860
15835	6243	1413
15835	6243	2358
16592	6244	9812
16592	6244	1778
16592	6244	1618
16592	6244	875
16592	6244	4502
16592	6244	8899
16592	6244	548
16592	6244	2676
16592	6244	6876
14344	6245	3595
11904	6246	4248
11904	6246	8090
11904	6246	3530
11904	6246	4844
11904	6246	9170
11904	6246	1910
11904	6246	884
11904	6246	3163
11678	6247	1749
11678	6247	3814
11678	6247	7928
11678	6247	5408
11678	6247	3360
11678	6247	390
16960	6248	8347
16960	6248	9872
16960	6248	2227
16960	6248	1188
16960	6248	2589
4710	6249	8997
4710	6249	4945
4710	6249	4810
4710	6249	218
4710	6249	4777
4710	6249	1559
4710	6249	1184
5698	6250	9358
5698	6250	9509
1394	6251	5048
1394	6251	4073
6138	6252	5880
6138	6252	4173
17897	6253	4115
17897	6253	6514
17897	6253	3707
17897	6253	9753
18523	6254	9959
10012	6255	243
10012	6255	9326
10012	6255	6235
10012	6255	9403
10012	6255	1302
10012	6255	9355
6939	6256	1230
6939	6256	5869
14413	6257	7673
14413	6257	2596
14413	6257	5208
10899	6258	2867
10899	6258	643
10899	6258	2749
10899	6258	3873
10899	6258	2921
9509	6259	296
9509	6259	7785
9509	6259	4192
9509	6259	2155
9509	6259	8230
9509	6259	1722
9509	6259	5924
4064	6260	4375
4064	6260	4022
15789	6261	7133
15789	6261	3533
15789	6261	1603
15789	6261	5234
15789	6261	2730
15789	6261	7415
15789	6261	1290
15789	6261	9634
11114	6262	7589
11114	6262	9719
11114	6262	8031
11114	6262	9086
11114	6262	1634
11114	6262	2668
11114	6262	3113
11114	6262	7014
4496	6263	1673
4496	6263	7641
4496	6263	7162
12483	6264	4207
12483	6264	932
12483	6264	2382
12483	6264	7665
12483	6264	2851
12483	6264	9780
12483	6264	8063
10154	6265	7325
10154	6265	4505
4291	6266	9419
4499	6267	2669
10100	6268	6517
10100	6268	1722
10100	6268	3008
9451	6269	6472
9451	6269	8503
9451	6269	1184
9451	6269	3122
9451	6269	2116
9451	6269	1072
9451	6269	4790
14916	6270	2508
14916	6270	6763
14916	6270	3623
14916	6270	5321
9016	6271	1302
9016	6271	5317
9016	6271	8803
3848	6272	4464
3848	6272	2392
3848	6272	6530
3848	6272	6712
18438	6273	8244
18438	6273	1556
18438	6273	4408
11524	6274	3588
11524	6274	9177
11524	6274	4772
11524	6274	4314
11524	6274	4358
11524	6274	5125
11524	6274	8031
11524	6274	8720
11524	6274	9677
7665	6275	1611
7665	6275	5768
7677	6276	3211
7677	6276	705
7677	6276	7758
4142	6277	849
4142	6277	4203
4142	6277	6667
4142	6277	3621
4142	6277	7950
4142	6277	176
4142	6277	9785
11103	6278	9390
11103	6278	7614
11103	6278	4949
11103	6278	4989
11103	6278	3795
7365	6279	8695
7365	6279	4504
7365	6279	2664
7365	6279	1704
7365	6279	5705
7365	6279	6662
4728	6280	7545
4728	6280	1049
11995	6281	8703
11995	6281	6103
11995	6281	953
11995	6281	9104
11995	6281	1384
11995	6281	5009
11995	6281	1732
11995	6281	4661
2644	6282	3686
2644	6282	3724
2644	6282	4394
14848	6283	5442
14848	6283	7134
14848	6283	2952
14848	6283	3187
14848	6283	7734
14848	6283	5663
14848	6283	8618
14848	6283	9456
14848	6283	4829
15506	6284	1717
15506	6284	9515
15506	6284	8801
15506	6284	3534
15506	6284	5765
15506	6284	9043
15506	6284	521
15506	6284	985
17438	6285	1462
17438	6285	7104
17438	6285	172
17438	6285	8965
17438	6285	9686
17438	6285	3057
17438	6285	3296
17438	6285	7513
17438	6285	8473
8475	6286	7136
16242	6287	6840
16242	6287	6460
16242	6287	9421
16242	6287	9218
16242	6287	5496
16242	6287	4365
16242	6287	7451
1492	6288	2842
1492	6288	5143
1492	6288	2702
1492	6288	5215
15832	6289	4665
15832	6289	2484
15832	6289	3099
15832	6289	4687
15832	6289	1497
15832	6289	498
15832	6289	5363
15832	6289	3282
15832	6289	8694
3071	6290	6043
3071	6290	6348
4110	6291	2012
4110	6291	7032
4110	6291	4962
19298	6292	9831
19298	6292	3757
19298	6292	892
19298	6292	7140
19298	6292	313
19298	6292	1121
19298	6292	4366
19298	6292	6490
1533	6293	3001
1533	6293	1433
1533	6293	9275
1533	6293	163
1533	6293	6043
1533	6293	3570
1533	6293	5552
12887	6294	6029
12887	6294	1389
12887	6294	6728
12887	6294	4313
12887	6294	6467
12887	6294	3983
12887	6294	329
12887	6294	4015
6577	6295	8962
6577	6295	9787
6577	6295	71
6577	6295	9858
6577	6295	1781
6577	6295	9346
6577	6295	8900
11253	6296	8844
11253	6296	2006
11253	6296	2189
11253	6296	9810
11253	6296	4095
11253	6296	9491
11253	6296	4004
11253	6296	6446
11253	6296	984
1681	6297	5063
7923	6298	9588
7923	6298	2949
7923	6298	7174
7923	6298	1257
2133	6299	7892
2133	6299	3631
153	6300	6593
153	6300	5331
153	6300	5719
153	6300	1247
153	6300	4354
7884	6301	2373
7260	6302	4697
7260	6302	4684
7260	6302	352
7716	6303	8348
7356	6304	4070
16848	6305	2366
16848	6305	4306
16848	6305	3028
5524	6306	8059
5524	6306	5652
5524	6306	6620
10021	6307	9994
18448	6308	9701
18448	6308	6787
18448	6308	4351
18448	6308	1812
18448	6308	3891
18448	6308	8976
18448	6308	7601
18448	6308	5323
1949	6309	1109
1949	6309	2532
1949	6309	6954
1949	6309	6686
1949	6309	1750
1949	6309	9611
1949	6309	3766
16233	6310	6773
16233	6310	7257
16233	6310	1699
14043	6311	7996
14043	6311	6771
14043	6311	927
14043	6311	512
14043	6311	1828
14043	6311	9128
14043	6311	9858
14043	6311	5027
14043	6311	5135
1368	6312	124
1368	6312	4261
1368	6312	165
1368	6312	8845
1368	6312	1855
1368	6312	5271
1368	6312	5944
1368	6312	7928
19511	6313	3332
19511	6313	1941
19511	6313	7133
17744	6314	7384
17744	6314	7348
15025	6315	8195
15025	6315	5389
15025	6315	4730
15025	6315	9662
15025	6315	7788
15025	6315	2413
15025	6315	6942
15025	6315	4951
4168	6316	956
4168	6316	134
4168	6316	1600
4168	6316	9983
4168	6316	4994
4168	6316	9854
4168	6316	338
4168	6316	6654
12630	6317	53
12630	6317	5803
12630	6317	5882
12630	6317	5878
3670	6318	5552
3670	6318	2132
3670	6318	5691
3670	6318	8455
16616	6319	3550
16616	6319	1752
16616	6319	6841
16616	6319	4487
16616	6319	9614
16616	6319	3888
16616	6319	1043
7761	6320	7674
7761	6320	1767
7761	6320	4302
7761	6320	1919
16532	6321	4950
16532	6321	2539
18757	6322	6272
18757	6322	9513
18757	6322	1287
18757	6322	9924
18757	6322	4436
18757	6322	322
18757	6322	8675
18757	6322	1914
18757	6322	9545
15372	6323	9699
15372	6323	1411
15372	6323	3749
15372	6323	1616
15372	6323	5373
15372	6323	5717
15372	6323	8046
15939	6324	9493
15939	6324	1986
15939	6324	6178
15939	6324	1145
15939	6324	7732
15939	6324	3409
15939	6324	3675
15939	6324	6877
15939	6324	5344
13917	6325	4845
13917	6325	1492
13917	6325	3270
13917	6325	860
13917	6325	6810
13917	6325	1127
14608	6326	3027
14608	6326	6542
14608	6326	256
14608	6326	9541
14608	6326	5301
14608	6326	7758
14608	6326	1843
14608	6326	3141
14608	6326	4575
15688	6327	4881
12014	6328	3311
12014	6328	8975
12014	6328	292
12014	6328	2771
12014	6328	5732
12014	6328	7680
12014	6328	7197
12014	6328	7567
12014	6328	3745
16640	6329	6164
16640	6329	5742
16640	6329	5281
16640	6329	7052
16640	6329	5841
9629	6330	330
9629	6330	3156
9629	6330	1782
17955	6331	8017
17955	6331	5369
17955	6331	8336
17955	6331	9047
17955	6331	7615
5790	6332	5347
5790	6332	2957
5790	6332	1973
4605	6333	8364
4605	6333	4261
4605	6333	9884
4605	6333	120
10976	6334	6197
10976	6334	3383
10976	6334	5478
10976	6334	6706
10976	6334	1522
10976	6334	3954
10976	6334	9715
10976	6334	4134
6518	6335	4166
6518	6335	2051
6518	6335	8205
6518	6335	1950
6518	6335	7658
6518	6335	7636
2035	6336	9944
2035	6336	6555
2035	6336	6423
2035	6336	5943
2035	6336	6435
2035	6336	6124
2035	6336	3335
2035	6336	1257
2035	6336	7209
10827	6337	4166
10827	6337	7091
10827	6337	6989
10827	6337	2819
5523	6338	4226
5523	6338	8196
5523	6338	1584
5523	6338	245
5523	6338	9294
5523	6338	7242
5523	6338	1079
5256	6339	6126
5256	6339	2467
5256	6339	5830
5256	6339	4589
5256	6339	4109
5256	6339	1409
5256	6339	3408
5256	6339	8578
5256	6339	5803
12095	6340	9627
12095	6340	6077
12095	6340	9559
12095	6340	3333
12095	6340	9266
3466	6341	1188
3466	6341	7928
3466	6341	2985
3466	6341	8428
3466	6341	4971
3466	6341	7994
3466	6341	7166
3466	6341	6822
3466	6341	9753
11659	6342	5763
11659	6342	9121
11659	6342	9943
11659	6342	6762
11659	6342	1852
11659	6342	9881
11659	6342	3245
11659	6342	9115
11659	6342	9256
14499	6343	1476
14499	6343	877
14499	6343	8128
14499	6343	7058
14499	6343	717
14499	6343	5765
11413	6344	8324
11413	6344	2559
11413	6344	4039
11413	6344	1068
11413	6344	7477
12309	6345	1998
12309	6345	3780
3816	6346	7188
3816	6346	155
3816	6346	4444
3816	6346	8659
3816	6346	2613
3816	6346	1113
3816	6346	5185
12506	6347	6577
12506	6347	4606
12506	6347	7644
12506	6347	3197
12506	6347	9478
12506	6347	3331
12506	6347	808
12506	6347	7975
4837	6348	9271
4837	6348	9110
8590	6349	548
8590	6349	6178
8590	6349	9383
8590	6349	1273
8590	6349	7387
8590	6349	8449
8590	6349	7943
17501	6350	9713
17501	6350	624
17501	6350	7896
17501	6350	257
17501	6350	277
17501	6350	1301
17501	6350	4733
17501	6350	9649
18063	6351	6057
9010	6352	6285
9010	6352	1405
9010	6352	4382
10012	6353	4900
10012	6353	9251
10012	6353	7060
3584	6354	2702
8792	6355	3477
8792	6355	229
8792	6355	8980
8792	6355	5597
8792	6355	5095
8792	6355	1503
2597	6356	1351
2597	6356	5062
2597	6356	1491
2597	6356	202
2597	6356	6685
2597	6356	5259
2597	6356	7299
2597	6356	2076
2597	6356	3197
4353	6357	2562
4353	6357	5771
4353	6357	3354
4353	6357	5362
4353	6357	640
4353	6357	5983
14947	6358	1363
14947	6358	8226
14947	6358	4785
14947	6358	3492
14947	6358	6300
12990	6359	2287
12990	6359	1890
12990	6359	5490
12990	6359	8813
12990	6359	287
12990	6359	7563
12990	6359	5153
12990	6359	3742
10209	6360	1725
10209	6360	1757
10209	6360	6980
10209	6360	1905
10209	6360	4551
10209	6360	4124
12027	6361	1257
12027	6361	8535
12027	6361	3160
12027	6361	7813
12027	6361	8782
12027	6361	5214
12027	6361	6659
16766	6362	3600
16766	6362	2833
16766	6362	3792
16766	6362	6273
16766	6362	4222
18233	6363	2825
18233	6363	6728
18233	6363	781
18233	6363	4296
18233	6363	6094
5505	6364	1136
5505	6364	4147
5505	6364	8374
5505	6364	239
5505	6364	4364
5505	6364	80
5505	6364	4978
5505	6364	7702
5505	6364	9192
11839	6365	459
11839	6365	6154
11839	6365	314
11839	6365	9306
11839	6365	1874
11839	6365	1098
18943	6366	1637
18943	6366	1924
18943	6366	5949
18943	6366	5723
18943	6366	8028
7678	6367	431
13169	6368	9089
13169	6368	2175
6543	6369	2743
6543	6369	8179
6543	6369	7349
6595	6370	6947
6595	6370	6733
15132	6371	8859
15132	6371	5884
15132	6371	5097
15132	6371	3855
15132	6371	5934
15132	6371	543
15132	6371	4212
15132	6371	2901
15132	6371	7664
7516	6372	5576
7516	6372	4526
7516	6372	1615
7516	6372	9874
7516	6372	2693
7516	6372	6715
7516	6372	5436
7516	6372	3548
7516	6372	9082
19248	6373	2909
19248	6373	7340
19248	6373	5547
19248	6373	4330
19248	6373	9328
7706	6374	7247
7706	6374	4620
2667	6375	3145
2667	6375	5545
2667	6375	1545
2667	6375	1850
2667	6375	1230
2667	6375	9241
9576	6376	3880
9576	6376	9564
9576	6376	1582
9576	6376	4664
9576	6376	3862
9576	6376	8767
9576	6376	616
9576	6376	932
9576	6376	9346
1782	6377	4834
1782	6377	2594
1782	6377	2557
1782	6377	8862
1782	6377	7581
1782	6377	8687
1782	6377	6206
1782	6377	8921
5564	6378	7461
5564	6378	5144
5564	6378	4528
5564	6378	4869
5564	6378	5381
5564	6378	8350
5564	6378	1613
5564	6378	4288
6299	6379	5891
6299	6379	3591
6299	6379	4080
6299	6379	2966
6299	6379	5293
6299	6379	1036
12358	6380	669
12358	6380	8927
12358	6380	3640
12358	6380	6262
12358	6380	8220
12358	6380	9422
12358	6380	3699
12358	6380	3531
14241	6381	9631
14241	6381	5613
14241	6381	7769
3307	6382	66
3307	6382	4837
3307	6382	9544
3307	6382	6269
3307	6382	3729
3307	6382	6356
3307	6382	1573
3307	6382	7698
12115	6383	8497
12115	6383	5981
7498	6384	5402
7498	6384	3276
7498	6384	7080
7498	6384	4460
7498	6384	6588
634	6385	3467
634	6385	8839
634	6385	1891
634	6385	7222
634	6385	9811
634	6385	5967
634	6385	9828
634	6385	9540
9883	6386	409
9738	6387	5598
9738	6387	5489
9738	6387	9088
9738	6387	7604
9738	6387	121
14685	6388	3061
14685	6388	2011
14685	6388	2318
14685	6388	3474
14685	6388	6492
14685	6388	9987
17143	6389	3744
17143	6389	7067
17143	6389	8181
17143	6389	8188
17143	6389	4080
17143	6389	5278
17143	6389	5650
17421	6390	1599
17421	6390	267
17421	6390	291
17421	6390	2715
17421	6390	3658
17421	6390	8849
17421	6390	8371
17421	6390	2793
1946	6391	6757
4068	6392	919
4068	6392	2680
4068	6392	1581
4068	6392	154
889	6393	723
889	6393	3672
4083	6394	7479
18136	6395	4738
18136	6395	244
18136	6395	6289
18136	6395	3758
18136	6395	540
18136	6395	3247
18136	6395	7185
18136	6395	1137
3719	6396	1431
3719	6396	374
3719	6396	6221
3719	6396	7582
3719	6396	6920
3719	6396	5884
3719	6396	3900
3719	6396	2551
12617	6397	1646
12617	6397	8522
12617	6397	4999
12617	6397	4619
12617	6397	1518
12617	6397	7993
12617	6397	8410
12617	6397	6543
8248	6398	5705
8248	6398	4795
8248	6398	4315
3208	6399	9433
3208	6399	1350
3208	6399	4130
3208	6399	7612
3208	6399	6008
3208	6399	1418
3208	6399	2078
3208	6399	2367
3208	6399	4457
13519	6400	4947
13519	6400	8052
13519	6400	3863
13519	6400	865
13519	6400	6790
13519	6400	2816
13519	6400	8250
13519	6400	4487
990	6401	4495
990	6401	6939
990	6401	5688
990	6401	5446
990	6401	8154
990	6401	6878
990	6401	3685
15095	6402	5064
15095	6402	3521
15095	6402	7701
4375	6403	2682
14354	6404	4039
14354	6404	5963
14354	6404	3810
14354	6404	6653
14354	6404	7217
19155	6405	2802
19155	6405	7949
19155	6405	829
19155	6405	8094
19155	6405	7837
19155	6405	6172
19155	6405	8350
19155	6405	7696
3468	6406	1219
3468	6406	8451
3468	6406	7916
3468	6406	8208
12184	6407	9041
12184	6407	4370
12184	6407	5518
12184	6407	5522
12184	6407	8189
12184	6407	3873
12184	6407	5496
12184	6407	4579
15997	6408	5228
15997	6408	2391
15997	6408	2317
15997	6408	6675
15997	6408	6690
11461	6409	5599
11461	6409	2440
11461	6409	7335
11461	6409	2814
11461	6409	7167
11461	6409	2776
11461	6409	2176
11461	6409	9744
11461	6409	598
5976	6410	3586
5976	6410	6904
5976	6410	3383
5976	6410	6006
5976	6410	2488
5976	6410	5826
5976	6410	2725
5976	6410	5556
5976	6410	4367
14284	6411	3219
14284	6411	6399
14284	6411	9181
14284	6411	6804
14284	6411	2766
14284	6411	2084
10933	6412	7312
10933	6412	8274
10933	6412	9595
10933	6412	6297
10933	6412	6536
10933	6412	7872
10933	6412	7805
2046	6413	4839
2046	6413	6227
2046	6413	3024
10215	6414	574
10215	6414	9364
10215	6414	5508
10204	6415	252
10204	6415	7981
10204	6415	5553
10204	6415	461
10204	6415	6808
10204	6415	4762
10204	6415	2738
11523	6416	869
11523	6416	8013
11523	6416	9480
11523	6416	9327
11523	6416	5013
7294	6417	8817
8737	6418	6326
8737	6418	5932
8737	6418	9886
8737	6418	2076
8737	6418	4431
8737	6418	8493
8737	6418	696
8737	6418	6741
8737	6418	3881
17787	6419	2541
17787	6419	5591
17787	6419	9727
17787	6419	5726
17787	6419	2976
17815	6420	7577
17815	6420	2457
17815	6420	7269
17815	6420	7305
17815	6420	7453
17815	6420	8139
17815	6420	112
17815	6420	227
17815	6420	8551
8282	6421	8194
2338	6422	77
15305	6423	9659
15305	6423	3575
15305	6423	5483
7242	6424	6921
7242	6424	7646
16505	6425	8586
16505	6425	9329
16505	6425	8974
16505	6425	965
16505	6425	6267
16505	6425	6702
16505	6425	3762
16505	6425	4038
16505	6425	3324
8663	6426	5452
6195	6427	1350
6195	6427	8150
6195	6427	2949
6195	6427	12
6195	6427	8708
6195	6427	973
6195	6427	2111
6195	6427	1493
11060	6428	5050
11060	6428	1690
11060	6428	2300
11060	6428	8252
11060	6428	239
11060	6428	4284
11060	6428	8928
3754	6429	3800
3754	6429	2511
9243	6430	494
9243	6430	618
9243	6430	3841
9243	6430	5277
9243	6430	3857
4217	6431	5892
4217	6431	4498
4217	6431	9907
19639	6432	8440
4070	6433	7122
4070	6433	4197
4070	6433	8884
4070	6433	3406
4070	6433	3568
4070	6433	1735
4070	6433	9371
10526	6434	83
10526	6434	9666
10526	6434	2124
10526	6434	7274
5084	6435	257
5084	6435	7153
12072	6436	196
3861	6437	6855
3861	6437	2761
3861	6437	5091
3861	6437	1556
3861	6437	9622
3861	6437	1978
3861	6437	4243
13682	6438	6561
13682	6438	4147
13682	6438	4425
13682	6438	4884
13682	6438	2695
13682	6438	6550
13682	6438	508
13682	6438	6437
13682	6438	2656
8424	6439	7892
8424	6439	2627
8424	6439	7525
8424	6439	8975
8424	6439	1757
8424	6439	7149
3145	6440	6192
3145	6440	7449
3145	6440	226
3145	6440	6145
17601	6441	3012
17601	6441	3067
17601	6441	2735
17601	6441	3038
17601	6441	7757
17601	6441	9020
17601	6441	7548
14205	6442	1541
14205	6442	3189
14205	6442	6672
14205	6442	6945
14205	6442	77
14205	6442	1618
14205	6442	5504
14205	6442	2739
10948	6443	5734
10948	6443	582
10948	6443	1533
10948	6443	921
10948	6443	5232
10948	6443	4903
10948	6443	2592
10948	6443	5761
5410	6444	874
5410	6444	9848
5173	6445	8061
5173	6445	2427
5173	6445	1229
5173	6445	8546
18933	6446	8127
18933	6446	3140
18933	6446	2703
18933	6446	9981
18933	6446	1605
18933	6446	5792
11278	6447	8226
11278	6447	7942
11278	6447	3011
11278	6447	79
17250	6448	8091
17250	6448	881
17250	6448	1318
17250	6448	6935
17250	6448	2920
9048	6449	7002
9048	6449	9661
9048	6449	8818
9048	6449	9659
5338	6450	6908
5338	6450	2874
5338	6450	5016
5338	6450	613
3862	6451	5952
3862	6451	1032
3862	6451	7360
3862	6451	8203
15727	6452	5749
15727	6452	317
15727	6452	2545
15727	6452	4169
14085	6453	8007
14085	6453	8858
14085	6453	5902
3708	6454	6036
8477	6455	2102
8477	6455	8644
8477	6455	3424
8477	6455	7770
8477	6455	6404
8700	6456	7312
8700	6456	2750
8700	6456	2176
8700	6456	4943
8700	6456	505
8700	6456	1817
8700	6456	5520
8700	6456	779
5760	6457	730
5760	6457	4850
5760	6457	1787
5760	6457	437
5760	6457	5603
5760	6457	5985
17469	6458	7386
17469	6458	59
17469	6458	578
17469	6458	4431
17469	6458	4035
17469	6458	4945
17469	6458	8089
17469	6458	7169
4036	6459	3271
4036	6459	2151
4036	6459	7170
4036	6459	1788
4036	6459	6870
8510	6460	2146
8510	6460	4085
16239	6461	9399
16239	6461	3856
16239	6461	8691
16239	6461	8585
16239	6461	1959
16239	6461	3761
1861	6462	4504
1861	6462	3387
1861	6462	3370
11030	6463	2091
11030	6463	1069
11030	6463	1844
11399	6464	2714
11399	6464	8445
11399	6464	7475
16405	6465	719
8209	6466	2388
8209	6466	9025
8209	6466	6109
8209	6466	1473
6633	6467	9016
6633	6467	1174
6633	6467	299
6633	6467	6402
6633	6467	1824
6633	6467	5975
6633	6467	6208
6633	6467	2599
13786	6468	52
13786	6468	9330
13786	6468	9996
9969	6469	3720
9787	6470	4512
9787	6470	3733
9787	6470	6448
9787	6470	1294
9787	6470	6400
9787	6470	9004
17722	6471	7743
15476	6472	2723
12885	6473	1336
12885	6473	2940
12885	6473	3898
12885	6473	2181
12885	6473	6379
12885	6473	3000
12885	6473	7367
16302	6474	8988
11970	6475	6320
15275	6476	4617
15275	6476	5616
15275	6476	2690
9741	6477	8345
11422	6478	3862
11422	6478	3714
11422	6478	4332
11422	6478	8834
10306	6479	2791
10306	6479	2564
10306	6479	2095
10306	6479	4963
10306	6479	7692
10306	6479	9655
10306	6479	9795
10306	6479	407
10306	6479	3710
15142	6480	420
18506	6481	4406
18506	6481	7975
18506	6481	992
18506	6481	4603
18506	6481	8717
18506	6481	7870
18506	6481	8755
18506	6481	3957
8727	6482	9631
8727	6482	6802
8727	6482	8507
8727	6482	5946
8727	6482	6475
8727	6482	932
8727	6482	7686
8727	6482	8077
8727	6482	9444
16320	6483	4568
16320	6483	7155
16320	6483	9548
16320	6483	2888
16320	6483	1908
16320	6483	9532
16320	6483	3142
16320	6483	5931
16320	6483	576
3013	6484	413
3013	6484	7394
3013	6484	4041
3013	6484	8016
3013	6484	8787
3013	6484	7285
3013	6484	1108
3013	6484	8617
1049	6485	9234
1049	6485	5675
1049	6485	8743
1049	6485	7568
1049	6485	7756
1049	6485	8491
1049	6485	2215
12510	6486	2541
12510	6486	8622
12510	6486	9766
12510	6486	6657
12510	6486	3725
12510	6486	8907
16280	6487	3304
16280	6487	4322
16280	6487	8410
16280	6487	1724
16280	6487	245
16280	6487	2785
16280	6487	194
16280	6487	4307
5856	6488	2657
5856	6488	9797
17407	6489	6843
17407	6489	4447
17407	6489	5150
17407	6489	1018
17407	6489	845
17407	6489	460
6487	6490	1067
6487	6490	9606
6487	6490	6593
6487	6490	4129
6487	6490	1380
6487	6490	5631
6487	6490	2629
18943	6491	9618
18943	6491	4946
18943	6491	7473
18943	6491	3376
18943	6491	6881
18943	6491	1175
4481	6492	4955
4481	6492	8697
4481	6492	5745
4481	6492	3008
4481	6492	5434
4481	6492	3626
4779	6493	6303
4779	6493	5359
4779	6493	4079
4779	6493	1707
4779	6493	8788
11430	6494	2248
11430	6494	3595
11430	6494	9159
11430	6494	1021
11430	6494	714
11430	6494	7803
11430	6494	3618
13919	6495	5247
13919	6495	6807
13919	6495	1726
1027	6496	6228
1027	6496	4580
1027	6496	6590
1027	6496	9419
1027	6496	7513
1027	6496	7915
1027	6496	6893
1020	6497	7470
1020	6497	2325
1020	6497	9252
1020	6497	2042
1020	6497	7645
1020	6497	1490
1020	6497	9805
1020	6497	5552
1020	6497	6192
11221	6498	6050
5883	6499	3452
1842	6500	3637
1842	6500	1613
1842	6500	6635
16249	6501	5842
16249	6501	2192
16249	6501	5988
16249	6501	7644
16249	6501	4820
16249	6501	9683
16249	6501	6634
16249	6501	3979
8270	6502	6616
8270	6502	3419
8270	6502	321
8270	6502	7485
8270	6502	8178
8270	6502	6130
8270	6502	9625
11224	6503	9490
11224	6503	7388
11224	6503	1007
11224	6503	377
3458	6504	9489
3458	6504	9755
3458	6504	3964
3458	6504	2960
3458	6504	8398
9054	6505	2848
9054	6505	2462
9054	6505	4904
9054	6505	3807
9054	6505	1124
9054	6505	6313
9054	6505	9798
17835	6506	4653
17835	6506	5624
17835	6506	5361
7515	6507	8284
7515	6507	4140
7515	6507	6085
7515	6507	7048
7515	6507	8553
7515	6507	3280
7515	6507	5666
10927	6508	4381
10927	6508	7124
10927	6508	828
10927	6508	7650
15428	6509	5004
18286	6510	5745
18286	6510	3002
12563	6511	5874
12563	6511	8389
12563	6511	9557
13361	6512	9428
13361	6512	8442
13361	6512	7166
4338	6513	1312
4338	6513	9750
4338	6513	2382
4338	6513	1354
4338	6513	9033
4338	6513	2567
4338	6513	479
72	6514	6716
72	6514	4471
5826	6515	1300
5826	6515	4313
11250	6516	2681
11250	6516	8948
11250	6516	5912
11250	6516	9363
11250	6516	2885
11250	6516	9434
6315	6517	8684
6315	6517	2735
6315	6517	3275
6315	6517	5807
6315	6517	8346
6315	6517	2490
12758	6518	2650
12758	6518	2459
12758	6518	7915
12758	6518	7039
12758	6518	1662
12758	6518	4475
12758	6518	9630
12758	6518	8130
1730	6519	501
1730	6519	8577
1730	6519	7901
1730	6519	3638
9251	6520	4561
4951	6521	3276
4951	6521	2166
4951	6521	9549
4951	6521	8115
4951	6521	109
4951	6521	8543
18087	6522	7889
18087	6522	2488
19866	6523	28
19866	6523	8007
19866	6523	3188
19866	6523	4377
13084	6524	8338
13084	6524	9592
16268	6525	7178
16268	6525	5436
16268	6525	8160
16268	6525	6593
5489	6526	3457
5489	6526	6565
5489	6526	5409
5489	6526	3108
5489	6526	7483
5489	6526	9686
5489	6526	9647
5489	6526	4266
9588	6527	5188
9588	6527	9655
9588	6527	8188
9588	6527	2917
9588	6527	8992
4897	6528	9093
4401	6529	9520
4401	6529	4734
4401	6529	9162
4401	6529	9983
4401	6529	3792
4401	6529	1161
4401	6529	5077
4401	6529	2327
4401	6529	7062
12107	6530	8502
12107	6530	3723
12107	6530	650
1696	6531	733
1696	6531	8482
1696	6531	7798
1696	6531	6466
1696	6531	3276
1696	6531	570
1696	6531	8441
1696	6531	1617
1696	6531	8138
18689	6532	7568
16435	6533	9066
16435	6533	6762
16435	6533	5899
16435	6533	9692
16435	6533	3708
16435	6533	5286
16435	6533	3782
4445	6534	7724
4445	6534	7876
4445	6534	6233
4445	6534	9337
4445	6534	9910
4445	6534	2018
4445	6534	4436
2395	6535	6441
2395	6535	9635
2395	6535	6728
2395	6535	7131
2395	6535	776
2395	6535	2732
912	6536	9736
912	6536	9325
912	6536	6447
912	6536	6060
912	6536	2176
912	6536	9548
912	6536	1693
16266	6537	8281
16266	6537	2710
16266	6537	8238
16266	6537	7878
16266	6537	3011
16266	6537	1425
16266	6537	4589
16266	6537	2071
17036	6538	6983
17036	6538	6786
17036	6538	7539
17036	6538	6957
17036	6538	6612
17036	6538	3483
12385	6539	9678
12385	6539	4890
12385	6539	5478
12385	6539	2113
8367	6540	2701
8367	6540	3997
8367	6540	2449
8367	6540	6212
8367	6540	9261
8367	6540	5681
8367	6540	1126
13618	6541	730
11238	6542	1934
11238	6542	4793
11238	6542	4016
11238	6542	7113
11238	6542	5897
16691	6543	8333
16691	6543	5781
16691	6543	7024
15573	6544	8854
15573	6544	3565
15573	6544	62
15573	6544	2828
15573	6544	1118
15573	6544	1403
15573	6544	6392
15573	6544	1851
16499	6545	861
16499	6545	2668
19381	6546	7477
19381	6546	4686
19381	6546	1703
19381	6546	4432
19381	6546	9535
19381	6546	3760
10324	6547	3677
10324	6547	3559
8383	6548	3157
8383	6548	3386
8383	6548	7175
8383	6548	2288
8383	6548	4191
8383	6548	981
8383	6548	5223
9515	6549	5410
9515	6549	6579
510	6550	3556
510	6550	6573
510	6550	1464
9698	6551	1781
9698	6551	7682
9698	6551	5125
695	6552	5105
695	6552	938
695	6552	4300
695	6552	1711
695	6552	7771
695	6552	5503
695	6552	5261
695	6552	9699
695	6552	1805
15336	6553	5820
15336	6553	9324
15336	6553	4931
15336	6553	1291
12791	6554	6910
12791	6554	9162
13865	6555	8259
13865	6555	752
13865	6555	1147
13865	6555	3513
13865	6555	224
13865	6555	6071
13865	6555	8366
13865	6555	6987
16555	6556	4673
16555	6556	8937
16555	6556	8106
16555	6556	203
16555	6556	5031
16555	6556	9956
16555	6556	3789
9870	6557	7654
9870	6557	6857
9870	6557	9531
9870	6557	9119
9870	6557	8518
1638	6558	8873
1638	6558	1049
1638	6558	25
1638	6558	8257
1638	6558	617
1638	6558	8344
1638	6558	8920
1638	6558	9341
1638	6558	4349
2410	6559	6427
2410	6559	1717
2410	6559	5536
2410	6559	5764
2410	6559	5977
14051	6560	8277
17786	6561	3299
17786	6561	3463
17786	6561	9184
17786	6561	9632
699	6562	185
699	6562	388
699	6562	8281
699	6562	4246
699	6562	786
4797	6563	2268
4797	6563	8452
4797	6563	4575
4797	6563	7349
4797	6563	4388
4797	6563	5849
4797	6563	1386
4797	6563	4369
4797	6563	308
1389	6564	6845
1389	6564	5748
14060	6565	6589
14060	6565	5088
14060	6565	2644
14060	6565	6790
2356	6566	5198
2356	6566	8413
2356	6566	9349
2356	6566	4120
8786	6567	8912
8786	6567	3890
8786	6567	6825
8786	6567	2513
8786	6567	6213
8786	6567	8454
10487	6568	6422
10487	6568	8512
10487	6568	3285
10487	6568	1185
10487	6568	5645
10118	6569	1318
10118	6569	9034
10118	6569	6735
10118	6569	9125
10118	6569	9271
10118	6569	6849
10118	6569	4194
10118	6569	2968
10118	6569	9075
15173	6570	4511
15173	6570	4335
19051	6571	8764
19051	6571	5801
19051	6571	1738
19051	6571	3655
19051	6571	1783
19051	6571	6200
19051	6571	649
7233	6572	3005
7233	6572	9403
7826	6573	4068
7826	6573	7416
7826	6573	892
7826	6573	5813
7826	6573	3977
7826	6573	9229
7826	6573	8412
7826	6573	556
2409	6574	4821
2409	6574	4200
2409	6574	295
7701	6575	1741
7701	6575	1739
7701	6575	864
7701	6575	5337
7701	6575	9324
7701	6575	4226
7701	6575	6944
7701	6575	9563
18408	6576	1587
18408	6576	694
18408	6576	1349
6369	6577	1225
6369	6577	8484
6369	6577	5737
6369	6577	5594
6369	6577	6023
6369	6577	385
6369	6577	3470
6065	6578	2236
7646	6579	9609
7646	6579	4069
7646	6579	1585
5618	6580	5772
5618	6580	3729
5618	6580	2295
5618	6580	6284
19507	6581	2786
19507	6581	3018
19507	6581	8363
10830	6582	3816
10830	6582	7449
10830	6582	1459
10830	6582	8209
10830	6582	7727
10830	6582	8168
10830	6582	5347
10830	6582	1206
2409	6583	4089
2409	6583	7982
2409	6583	9191
16069	6584	6487
7870	6585	7281
7870	6585	1948
7870	6585	3164
7870	6585	6462
7870	6585	578
7439	6586	6868
7439	6586	5693
9765	6587	2917
9765	6587	3567
9765	6587	8526
19000	6588	8683
3693	6589	357
3693	6589	9754
17251	6590	1585
17251	6590	192
17251	6590	2594
17251	6590	4224
17251	6590	4337
5726	6591	2363
5726	6591	8872
5726	6591	1078
5726	6591	2892
5726	6591	6585
5726	6591	10
5726	6591	3745
5726	6591	4964
13096	6592	8198
13096	6592	5402
13096	6592	1580
13096	6592	212
10226	6593	2129
10226	6593	6009
10226	6593	8117
10226	6593	8460
10226	6593	2149
11786	6594	1657
11786	6594	2550
11786	6594	4796
11786	6594	1201
11786	6594	3168
11786	6594	9936
5074	6595	7501
5074	6595	7640
5074	6595	3826
5074	6595	2410
9117	6596	452
9117	6596	7497
92	6597	793
92	6597	3479
92	6597	1218
984	6598	4513
984	6598	6449
984	6598	6962
984	6598	7908
984	6598	2559
984	6598	3931
8763	6599	6489
8763	6599	7401
8763	6599	2787
8763	6599	2165
8763	6599	2153
8763	6599	9681
8763	6599	3875
16774	6600	539
16774	6600	2043
9203	6601	7915
9203	6601	3729
9203	6601	4025
9203	6601	8440
9203	6601	3944
9203	6601	9619
9203	6601	7493
9203	6601	9491
9203	6601	1262
13163	6602	8350
13163	6602	7935
6704	6603	2700
6704	6603	4216
6704	6603	1843
6704	6603	6645
6704	6603	9665
6704	6603	1509
6704	6603	6696
12371	6604	9550
12371	6604	8897
12371	6604	866
17600	6605	2152
17600	6605	1874
17600	6605	5540
17600	6605	1278
15845	6606	8510
15845	6606	3276
15845	6606	8173
15845	6606	1391
1881	6607	2242
1881	6607	2788
1881	6607	2987
1881	6607	159
1881	6607	3059
17197	6608	5981
17197	6608	9189
15396	6609	2903
15396	6609	4047
15396	6609	5333
15396	6609	5234
15396	6609	6234
15396	6609	2842
15396	6609	3306
15396	6609	9448
15396	6609	967
1909	6610	2220
1909	6610	6064
1909	6610	729
1909	6610	9106
4017	6611	6302
4017	6611	6960
4017	6611	8520
4017	6611	9009
4017	6611	2215
4017	6611	7190
16312	6612	9110
16312	6612	4890
1907	6613	3458
1907	6613	6630
1907	6613	3852
307	6614	1688
307	6614	2101
307	6614	909
307	6614	3011
307	6614	5977
307	6614	6254
307	6614	64
307	6614	5418
307	6614	6694
18863	6615	1275
18863	6615	5044
18863	6615	8651
18863	6615	5280
18863	6615	5898
18863	6615	9224
18863	6615	7664
18863	6615	2313
18863	6615	8230
8967	6616	9847
8967	6616	4481
8967	6616	1626
8967	6616	5972
8967	6616	9753
8967	6616	9974
8967	6616	2373
8967	6616	1787
8967	6616	8302
15051	6617	7658
15051	6617	2958
15051	6617	6286
9440	6618	8572
394	6619	2682
394	6619	9975
394	6619	1365
6304	6620	837
6304	6620	7105
6304	6620	6903
6304	6620	4516
6304	6620	650
6304	6620	2280
6304	6620	5521
6304	6620	1237
6304	6620	657
14946	6621	4042
14946	6621	9625
14946	6621	3045
14946	6621	8558
14946	6621	484
14946	6621	7663
14946	6621	5914
859	6622	1231
859	6622	4019
859	6622	932
3175	6623	9060
3175	6623	2103
3175	6623	4670
3175	6623	8508
3175	6623	2631
6228	6624	702
6228	6624	2986
6228	6624	2802
6228	6624	6052
6228	6624	4114
6228	6624	783
6228	6624	5326
6228	6624	6633
11385	6625	8794
11385	6625	589
11385	6625	4931
11385	6625	4366
11385	6625	6333
11385	6625	4109
11385	6625	3198
11385	6625	87
12275	6626	6208
12275	6626	3661
12275	6626	2441
12275	6626	107
12275	6626	5986
12275	6626	8060
12275	6626	9871
12275	6626	2080
12891	6627	7271
12891	6627	5234
12891	6627	1691
12891	6627	6468
12891	6627	1458
12891	6627	4810
12891	6627	7313
12891	6627	9197
18607	6628	1958
18607	6628	9527
18607	6628	5659
18607	6628	6630
18607	6628	8052
10643	6629	5790
4514	6630	8756
4514	6630	5400
4514	6630	2880
4514	6630	5821
4514	6630	3900
4514	6630	6391
4514	6630	1784
14885	6631	4968
14885	6631	1433
14885	6631	896
14885	6631	1651
15858	6632	5664
15858	6632	564
15858	6632	3765
15858	6632	5661
15858	6632	5085
15858	6632	4358
12282	6633	3583
12282	6633	7417
12282	6633	489
2769	6634	8070
14022	6635	4708
14022	6635	5550
14022	6635	8714
14022	6635	8058
14022	6635	770
12372	6636	9288
12372	6636	7581
12372	6636	690
19865	6637	825
19865	6637	6104
19865	6637	4533
19865	6637	4132
19865	6637	6082
19865	6637	7713
19865	6637	891
3320	6638	7846
3320	6638	6534
3320	6638	8880
3320	6638	3838
18781	6639	6941
18781	6639	9158
7381	6640	2931
7381	6640	3786
7381	6640	4732
7381	6640	6414
9197	6641	1340
9197	6641	1315
9197	6641	7840
9197	6641	9789
18581	6642	9617
18581	6642	4527
16763	6643	8318
16763	6643	8078
16763	6643	2157
16763	6643	6376
16763	6643	9089
16763	6643	2675
16763	6643	7297
10272	6644	5158
13629	6645	7628
13629	6645	8932
13629	6645	8074
13629	6645	9567
13629	6645	106
13629	6645	9441
13629	6645	2135
13629	6645	756
13629	6645	9386
13364	6646	1818
13364	6646	2735
13364	6646	244
10817	6647	5101
10817	6647	3550
6231	6648	759
6231	6648	5730
6231	6648	4822
6231	6648	4117
11536	6649	8067
11536	6649	3895
11536	6649	9682
11536	6649	3262
11536	6649	9546
11536	6649	4888
11536	6649	5801
18323	6650	2629
18323	6650	6389
18323	6650	5205
18323	6650	4844
18323	6650	5417
18323	6650	5089
18323	6650	2093
11973	6651	124
11973	6651	2164
11973	6651	2282
11973	6651	4315
11973	6651	5488
11973	6651	7244
11973	6651	9518
11973	6651	9351
9111	6652	3876
9111	6652	7832
9111	6652	8837
15696	6653	6541
15696	6653	3290
15696	6653	5701
15696	6653	5755
15696	6653	3654
15696	6653	2149
3332	6654	7572
3332	6654	2188
3332	6654	2071
3332	6654	7219
3332	6654	5028
3332	6654	9825
3332	6654	3904
888	6655	9148
888	6655	2081
888	6655	7482
888	6655	6144
888	6655	6630
888	6655	1296
17735	6656	3555
17735	6656	309
17735	6656	8367
17735	6656	6829
1466	6657	1177
1466	6657	2210
1466	6657	3157
1466	6657	5226
1466	6657	24
1466	6657	268
3127	6658	431
3127	6658	2097
3127	6658	8912
3127	6658	4759
3127	6658	7741
3127	6658	5469
3127	6658	2320
3127	6658	5923
16266	6659	2423
16266	6659	8879
16266	6659	415
16266	6659	9101
16266	6659	711
16266	6659	4059
16266	6659	3599
16266	6659	5126
19768	6660	1471
19768	6660	6523
19768	6660	4650
19768	6660	7288
19768	6660	578
19768	6660	7975
13707	6661	6000
13420	6662	7851
5953	6663	2860
5953	6663	1848
5953	6663	8851
5953	6663	8122
5953	6663	815
2785	6664	4393
2785	6664	8062
8123	6665	771
8123	6665	4843
8123	6665	3387
8123	6665	1598
8915	6666	8789
8915	6666	7594
8915	6666	3140
8915	6666	2319
8915	6666	9801
8915	6666	7583
8915	6666	5504
8915	6666	4034
8915	6666	9705
951	6667	9097
951	6667	3420
1594	6668	22
1594	6668	1519
9318	6669	1033
9318	6669	2003
9318	6669	17
8101	6670	2473
8101	6670	4439
8101	6670	8582
8101	6670	6881
15943	6671	9851
15943	6671	3320
15943	6671	434
15943	6671	6029
15943	6671	7338
15943	6671	2280
15943	6671	5676
15943	6671	6847
15943	6671	6347
17639	6672	1803
17639	6672	1870
17639	6672	4666
17639	6672	6654
17639	6672	5479
17639	6672	283
17639	6672	7874
17639	6672	2969
613	6673	9647
613	6673	1750
613	6673	6572
613	6673	3584
613	6673	6916
613	6673	8803
613	6673	330
613	6673	7401
613	6673	6771
4499	6674	1049
4499	6674	3458
4499	6674	2336
6596	6675	9936
6596	6675	463
6596	6675	9929
6596	6675	6975
11556	6676	6450
11556	6676	7037
18990	6677	2236
18990	6677	6011
18990	6677	535
18990	6677	6324
18990	6677	1643
18990	6677	8826
18990	6677	8240
16338	6678	5014
16338	6678	838
16338	6678	7089
16338	6678	3540
16338	6678	509
11957	6679	2497
11957	6679	1550
11957	6679	2490
11957	6679	7888
11957	6679	4280
11957	6679	5711
7592	6680	8856
7592	6680	4384
7592	6680	6277
7592	6680	6981
7592	6680	5598
7592	6680	373
7592	6680	3468
7592	6680	5075
7592	6680	2652
10283	6681	9274
10283	6681	3597
10283	6681	1294
10283	6681	8781
10283	6681	8936
10283	6681	7682
10283	6681	7330
8620	6682	1799
10533	6683	1231
10533	6683	1305
10533	6683	446
10533	6683	7109
10533	6683	4576
11738	6684	7851
11738	6684	1120
11738	6684	2558
11738	6684	9491
6528	6685	7410
6528	6685	9824
6528	6685	2025
6528	6685	5367
6528	6685	1280
16775	6686	9093
16775	6686	9574
16775	6686	3718
16775	6686	8635
2384	6687	8540
2384	6687	5710
2384	6687	601
849	6688	1478
849	6688	8974
849	6688	4361
849	6688	1145
849	6688	1807
849	6688	126
7687	6689	8681
7687	6689	9459
7687	6689	4205
7687	6689	8010
7687	6689	4275
7687	6689	3033
7687	6689	9034
7687	6689	3540
5027	6690	617
5027	6690	9014
5027	6690	4649
5027	6690	3804
5027	6690	2983
5027	6690	2548
5027	6690	4366
5027	6690	3628
5027	6690	4
8557	6691	2174
8557	6691	7730
4985	6692	1615
4985	6692	7473
4985	6692	1266
10138	6693	7676
10138	6693	4413
10138	6693	955
1918	6694	5237
1918	6694	609
1918	6694	9206
1918	6694	3124
1918	6694	830
1918	6694	2058
1918	6694	193
1918	6694	3073
1918	6694	1653
16109	6695	7004
16109	6695	6243
16109	6695	8044
16109	6695	8918
8309	6696	1565
8309	6696	4891
8309	6696	5848
8309	6696	6037
8309	6696	8165
8309	6696	7436
18176	6697	7143
18176	6697	8416
18176	6697	9672
18176	6697	2105
2043	6698	5176
2043	6698	4009
2043	6698	9931
2043	6698	1427
2043	6698	4620
2043	6698	3684
2043	6698	3693
2759	6699	5593
2759	6699	7769
2759	6699	1495
2759	6699	8668
2759	6699	5155
2759	6699	4621
2759	6699	7634
2759	6699	3672
7205	6700	9381
7205	6700	5426
7205	6700	7945
7205	6700	4183
7205	6700	497
7205	6700	66
7205	6700	1740
7205	6700	98
17530	6701	8943
13153	6702	8219
13153	6702	8294
13153	6702	5746
13153	6702	3921
13153	6702	737
9839	6703	9310
2097	6704	4283
2097	6704	5738
2097	6704	7435
2097	6704	2569
2097	6704	1257
2097	6704	3146
2097	6704	1600
14690	6705	8516
14690	6705	4021
15706	6706	1751
15706	6706	5126
15706	6706	3436
15706	6706	489
15847	6707	6378
15847	6707	6908
15847	6707	4584
5638	6708	4975
17990	6709	6848
17990	6709	8765
17990	6709	9224
17990	6709	2081
17990	6709	3298
7641	6710	6912
7641	6710	793
7641	6710	6392
7641	6710	2327
7641	6710	8195
7641	6710	7425
14688	6711	2032
14688	6711	8479
14688	6711	7610
14688	6711	4686
14688	6711	361
14688	6711	2260
5505	6712	9623
5505	6712	2534
5505	6712	4043
5505	6712	3367
5505	6712	3040
5505	6712	5406
5505	6712	8135
5505	6712	1306
19568	6713	7486
19568	6713	3881
19568	6713	3629
19568	6713	37
15822	6714	6578
15822	6714	4529
15822	6714	1541
15822	6714	2857
15822	6714	8686
15822	6714	167
15822	6714	5831
15822	6714	6986
15894	6715	3594
15894	6715	6587
15894	6715	6622
15894	6715	2654
15894	6715	4535
15894	6715	4029
15894	6715	3480
15894	6715	1731
9174	6716	2849
9174	6716	1959
9174	6716	1239
9174	6716	1091
9174	6716	6891
967	6717	7706
967	6717	4446
967	6717	308
967	6717	7159
967	6717	91
967	6717	2895
967	6717	5658
967	6717	6408
18513	6718	7936
18513	6718	5387
18513	6718	8759
18513	6718	6717
18513	6718	2761
18513	6718	7816
4522	6719	1240
4522	6719	4327
4522	6719	8620
4522	6719	3151
4522	6719	6568
4522	6719	9536
4522	6719	8815
4522	6719	7497
4522	6719	825
19167	6720	9577
19167	6720	7380
19167	6720	8386
18419	6721	7191
11621	6722	88
11621	6722	4933
11621	6722	6220
11621	6722	4184
11621	6722	497
12543	6723	8763
12543	6723	9678
16126	6724	7273
16126	6724	2107
8660	6725	9704
9272	6726	8383
9272	6726	5332
3859	6727	3688
3859	6727	7935
3859	6727	55
3859	6727	1428
17400	6728	3163
17400	6728	7146
17400	6728	5378
1550	6729	2392
1550	6729	7949
1550	6729	8747
1550	6729	9653
6679	6730	6704
6679	6730	8320
6679	6730	1122
6679	6730	6832
6679	6730	1844
6679	6730	9782
6679	6730	3431
6679	6730	5838
14646	6731	7191
14646	6731	6048
14646	6731	6083
14646	6731	9833
14646	6731	9039
14646	6731	5799
14646	6731	5505
14646	6731	3875
1411	6732	700
1411	6732	3980
1411	6732	6203
1411	6732	1358
1411	6732	7141
8661	6733	267
8661	6733	2209
8661	6733	4381
8661	6733	7740
8661	6733	6990
8661	6733	4297
14887	6734	2434
14887	6734	2176
16756	6735	514
16756	6735	124
16756	6735	7701
16756	6735	7483
16756	6735	8856
16756	6735	8066
16756	6735	939
15857	6736	8793
15857	6736	5155
15857	6736	52
15857	6736	2632
15857	6736	4002
15857	6736	605
15857	6736	6787
13821	6737	8359
13821	6737	9272
14675	6738	3143
4385	6739	1112
4385	6739	7289
4385	6739	4321
4385	6739	3391
4385	6739	8951
4385	6739	8556
4385	6739	5114
14413	6740	6782
12098	6741	6255
12098	6741	2538
12098	6741	5408
12098	6741	1315
12098	6741	848
12098	6741	7683
12098	6741	8523
12098	6741	3492
4094	6742	4206
15339	6743	405
15339	6743	218
15339	6743	3757
15339	6743	3693
18200	6744	5620
18200	6744	777
18599	6745	6773
18599	6745	1965
18599	6745	9624
18599	6745	5841
18599	6745	3840
18599	6745	1181
18599	6745	7789
18599	6745	4721
18599	6745	7870
17458	6746	903
17458	6746	9506
17458	6746	6435
17458	6746	979
17458	6746	5849
17458	6746	253
17458	6746	7734
17458	6746	3983
15644	6747	2066
15644	6747	9465
15644	6747	5612
15644	6747	5200
15644	6747	6064
15644	6747	1700
15644	6747	5846
15644	6747	8646
19248	6748	7376
19248	6748	797
19248	6748	3218
209	6749	8172
209	6749	9029
209	6749	1454
209	6749	4971
209	6749	8092
19583	6750	997
19583	6750	7492
19583	6750	6270
19583	6750	1117
19583	6750	3922
14277	6751	7243
14277	6751	2399
14277	6751	3961
14277	6751	3051
14277	6751	6069
14277	6751	2067
14277	6751	9057
14114	6752	3703
14114	6752	3081
14114	6752	4716
14114	6752	3617
14114	6752	6112
5609	6753	2098
5609	6753	8432
5609	6753	3634
19405	6754	3863
19405	6754	4973
19405	6754	5618
19405	6754	2763
11688	6755	42
12305	6756	8957
12305	6756	7895
12305	6756	7290
12305	6756	7113
12305	6756	7809
14626	6757	5874
14626	6757	2304
14626	6757	8713
14626	6757	811
14626	6757	910
1902	6758	7104
1902	6758	8910
1902	6758	3370
1902	6758	7115
8455	6759	2813
9875	6760	2035
9875	6760	5616
9875	6760	4066
9875	6760	5212
284	6761	4175
284	6761	7821
284	6761	9090
284	6761	9889
284	6761	1850
284	6761	432
284	6761	3957
284	6761	5641
284	6761	8182
431	6762	963
431	6762	8373
9798	6763	4435
9798	6763	9336
9798	6763	3575
9798	6763	3446
9798	6763	4630
9798	6763	6482
878	6764	2647
878	6764	6706
878	6764	6702
878	6764	926
18595	6765	4197
18595	6765	130
18595	6765	642
18595	6765	886
8662	6766	9626
8662	6766	7582
8662	6766	4601
14493	6767	6225
14493	6767	7471
14493	6767	6738
14493	6767	6448
14493	6767	4741
14493	6767	727
14493	6767	9274
14493	6767	4336
14493	6767	5585
6529	6768	7427
6529	6768	2470
6529	6768	8215
6529	6768	9273
10995	6769	2647
10995	6769	3005
15491	6770	2616
15491	6770	9067
15491	6770	9171
15491	6770	9178
15491	6770	7916
15491	6770	7777
15491	6770	6254
8937	6771	5056
8937	6771	2138
8937	6771	2145
8937	6771	1114
8937	6771	3879
8937	6771	2895
11020	6772	2461
11020	6772	9502
11020	6772	5458
11020	6772	5565
11020	6772	2759
252	6773	6767
252	6773	8971
252	6773	6058
252	6773	3688
252	6773	6264
252	6773	5257
252	6773	1182
252	6773	4668
252	6773	5891
10784	6774	2809
11133	6775	5693
11133	6775	6690
11133	6775	3778
11133	6775	1362
11133	6775	6775
11133	6775	7006
11133	6775	2616
7594	6776	7605
7594	6776	3993
7594	6776	4587
7594	6776	4271
7594	6776	7092
7594	6776	2962
7594	6776	6339
6057	6777	8689
6057	6777	9289
6057	6777	7523
6057	6777	8502
6057	6777	8558
6057	6777	3936
6057	6777	7562
6057	6777	1055
6057	6777	4748
18036	6778	7583
18036	6778	4647
647	6779	9777
647	6779	8235
647	6779	1101
647	6779	5360
647	6779	5897
647	6779	300
15723	6780	9416
15723	6780	2473
15723	6780	5137
15723	6780	5136
15723	6780	1506
15723	6780	6642
15723	6780	107
19767	6781	8949
8615	6782	8224
8615	6782	1638
6017	6783	9127
6017	6783	1239
6017	6783	8814
6017	6783	6983
6017	6783	6158
6017	6783	6475
6017	6783	7215
12888	6784	6774
12888	6784	9403
12888	6784	6260
12888	6784	6938
12888	6784	1627
4917	6785	5763
9153	6786	4895
9153	6786	4903
4235	6787	8562
4235	6787	3814
4235	6787	2758
4235	6787	2041
4235	6787	842
4235	6787	6915
4235	6787	4009
4235	6787	4926
1378	6788	5265
1378	6788	3427
16659	6789	447
16659	6789	8078
16659	6789	9594
16659	6789	4343
16659	6789	5107
16659	6789	1369
16659	6789	5361
16659	6789	8416
16659	6789	6103
7911	6790	6104
7911	6790	6719
7911	6790	9455
7911	6790	7860
7911	6790	2863
7911	6790	2274
3735	6791	4219
3735	6791	8038
6798	6792	2768
6798	6792	5644
6798	6792	3927
61	6793	9561
61	6793	5148
16021	6794	8950
16021	6794	3547
15531	6795	3352
15531	6795	6129
15531	6795	5906
3098	6796	1222
3098	6796	1150
1419	6797	8129
1419	6797	7307
1419	6797	9700
1419	6797	6891
1419	6797	8038
1419	6797	1012
1419	6797	4314
1419	6797	1359
1419	6797	1584
17552	6798	9895
17552	6798	9426
17552	6798	226
17552	6798	1754
17552	6798	2872
17552	6798	6858
17552	6798	3736
1253	6799	2210
1253	6799	2227
1253	6799	5177
1253	6799	6967
1253	6799	850
19326	6800	9698
19326	6800	6475
19326	6800	6225
19326	6800	8761
19326	6800	8110
3690	6801	2471
3690	6801	180
3690	6801	2792
3690	6801	1205
3690	6801	5992
3690	6801	4729
529	6802	5696
529	6802	352
529	6802	6125
529	6802	398
529	6802	5673
529	6802	504
529	6802	352
5644	6803	7503
17414	6804	6878
17414	6804	6071
17414	6804	410
17414	6804	9056
17414	6804	8777
17414	6804	8274
17414	6804	5984
17414	6804	9787
17414	6804	7178
15058	6805	351
15058	6805	8089
15058	6805	5074
15058	6805	6561
15058	6805	557
15058	6805	635
15058	6805	4792
7695	6806	3255
7695	6806	2880
7695	6806	4094
7695	6806	894
7695	6806	2957
7695	6806	8801
7695	6806	4751
7695	6806	3553
17252	6807	9116
17252	6807	7003
17252	6807	1352
17252	6807	795
15887	6808	3366
15887	6808	8134
15887	6808	4078
15887	6808	8731
15887	6808	6523
15887	6808	2961
15887	6808	6682
15887	6808	4113
15887	6808	5139
8509	6809	4005
8509	6809	6047
8509	6809	4908
8509	6809	2743
12216	6810	3568
12216	6810	7743
12216	6810	5964
12216	6810	9829
12216	6810	5538
12216	6810	5438
12216	6810	195
12216	6810	7930
1865	6811	5287
1865	6811	3635
1865	6811	9433
1865	6811	3634
1865	6811	2485
1865	6811	8732
1865	6811	7414
1865	6811	8349
16354	6812	4687
16354	6812	5928
16354	6812	8315
16354	6812	2327
16354	6812	4790
16354	6812	1979
11226	6813	1990
11226	6813	1216
19894	6814	6421
19894	6814	3180
19894	6814	7051
19894	6814	3437
19894	6814	3220
19894	6814	6619
19894	6814	3222
19894	6814	4678
19894	6814	2969
9474	6815	5937
9474	6815	2262
9474	6815	8732
9474	6815	7099
9474	6815	4454
9474	6815	8131
9474	6815	679
9474	6815	3115
12668	6816	7868
12668	6816	2482
12668	6816	4712
12668	6816	9202
2943	6817	5730
2943	6817	3276
2943	6817	8067
2943	6817	3719
2943	6817	3893
2943	6817	153
6535	6818	9601
6535	6818	7487
6535	6818	8867
6535	6818	14
18432	6819	688
18432	6819	1729
18432	6819	949
18432	6819	879
18432	6819	5378
18432	6819	1536
3377	6820	4956
3377	6820	7428
3377	6820	4693
3377	6820	2025
4078	6821	1255
3884	6822	8359
3884	6822	2640
3884	6822	1011
3884	6822	3834
3884	6822	7286
3884	6822	4235
3884	6822	3759
2371	6823	6100
2371	6823	1905
2371	6823	7810
2371	6823	1285
2371	6823	2558
2371	6823	1007
2371	6823	4827
2371	6823	5599
13218	6824	9155
13218	6824	2716
13218	6824	3894
15094	6825	5893
15094	6825	2097
15094	6825	4742
15094	6825	6840
15094	6825	8971
15094	6825	3217
16087	6826	5510
16087	6826	5208
16087	6826	378
16087	6826	3760
16087	6826	7752
16087	6826	9568
16087	6826	5200
16087	6826	6657
17506	6827	8660
17506	6827	1753
17506	6827	5126
17506	6827	7607
17506	6827	3013
17506	6827	6724
3863	6828	6294
3863	6828	8362
3863	6828	926
3863	6828	4376
3863	6828	5156
12281	6829	1867
12281	6829	1836
12281	6829	6074
12281	6829	8589
12281	6829	5087
12281	6829	629
11038	6830	788
11038	6830	2909
11038	6830	4080
11038	6830	7078
11038	6830	9960
11038	6830	9488
11038	6830	8373
11038	6830	3284
11038	6830	7716
7579	6831	7470
7579	6831	4048
7579	6831	8976
5434	6832	2752
5434	6832	3553
5434	6832	549
5434	6832	5288
9551	6833	4048
9551	6833	1476
10670	6834	7782
10670	6834	5333
10670	6834	1120
10670	6834	6001
10670	6834	7025
10670	6834	9140
10670	6834	6521
10670	6834	6609
3791	6835	6671
3791	6835	7422
3791	6835	6231
3791	6835	2481
3791	6835	4233
3791	6835	485
11635	6836	125
11635	6836	6912
12102	6837	8743
12102	6837	3241
12102	6837	5430
12102	6837	8251
12102	6837	6080
12102	6837	2818
10598	6838	3333
10598	6838	816
10598	6838	929
10598	6838	6564
10598	6838	4504
10598	6838	8204
10598	6838	9526
10598	6838	326
7132	6839	4384
7132	6839	6194
7132	6839	4258
7132	6839	2772
14798	6840	2511
14798	6840	2031
14798	6840	3105
14798	6840	4493
14798	6840	2068
14798	6840	1763
14798	6840	7826
12979	6841	583
13553	6842	5788
13553	6842	1864
13553	6842	669
6357	6843	6618
6357	6843	8365
6357	6843	8651
6357	6843	3807
6357	6843	2026
6357	6843	2500
6357	6843	8122
6357	6843	2082
6357	6843	8189
17374	6844	1957
17374	6844	1365
18211	6845	8877
18211	6845	4232
18211	6845	3531
14674	6846	8969
14674	6846	1586
14674	6846	3947
14674	6846	5793
14674	6846	4528
14674	6846	823
14674	6846	2540
14674	6846	4183
14674	6846	5404
2413	6847	3627
2413	6847	9128
13603	6848	6501
13603	6848	8826
13603	6848	552
12689	6849	7617
12689	6849	4705
12689	6849	8510
12689	6849	4062
12689	6849	8322
12689	6849	5120
17492	6850	5903
17492	6850	4887
17492	6850	567
17492	6850	3858
17492	6850	9474
17492	6850	2165
17492	6850	753
17492	6850	7508
4423	6851	1099
4423	6851	5226
691	6852	9092
691	6852	6702
691	6852	5699
691	6852	5390
691	6852	2975
691	6852	5658
691	6852	3657
691	6852	3675
2364	6853	3393
2364	6853	9011
2364	6853	3892
2364	6853	3910
2364	6853	4582
2364	6853	2167
2364	6853	2437
16270	6854	4401
16270	6854	3305
16270	6854	5880
16270	6854	7881
5550	6855	473
5550	6855	5453
5550	6855	8620
5550	6855	3719
16600	6856	1973
16600	6856	3931
16600	6856	7374
16600	6856	4696
16600	6856	7819
7395	6857	3251
7395	6857	2487
7395	6857	479
7395	6857	8115
7395	6857	2441
7395	6857	5276
7395	6857	9263
7395	6857	4459
7395	6857	3234
14328	6858	1551
14328	6858	4450
14328	6858	9764
9448	6859	1054
9448	6859	303
9448	6859	1437
9448	6859	7463
9448	6859	5150
9448	6859	37
8990	6860	926
8990	6860	1307
8990	6860	8455
8990	6860	9759
19046	6861	4247
19046	6861	1608
19046	6861	3655
19046	6861	6832
19046	6861	328
10955	6862	9890
10955	6862	3500
10955	6862	2086
10955	6862	6145
10955	6862	2419
10955	6862	6249
10955	6862	7504
10955	6862	1701
10955	6862	3766
10747	6863	7284
10747	6863	612
10747	6863	2374
10747	6863	3089
10747	6863	8585
4168	6864	6509
4168	6864	2826
4168	6864	4089
4168	6864	1106
4168	6864	7549
4168	6864	8281
4168	6864	8754
4168	6864	6687
4168	6864	5665
12551	6865	5856
8880	6866	6524
8880	6866	6645
8880	6866	481
8880	6866	1960
8880	6866	8545
8880	6866	6161
8880	6866	5871
9248	6867	4625
9248	6867	8064
9248	6867	6526
9248	6867	3160
6042	6868	231
6042	6868	2955
6869	6869	8003
6869	6869	1400
6869	6869	984
6869	6869	8604
6869	6869	1894
6869	6869	2485
6869	6869	3440
6869	6869	9224
4768	6870	5405
4768	6870	6471
4768	6870	2509
4768	6870	2511
4768	6870	2860
1724	6871	5026
1724	6871	5888
1724	6871	3122
1724	6871	6819
1724	6871	4300
1724	6871	6153
1724	6871	222
1724	6871	5907
2622	6872	6946
2622	6872	6749
2622	6872	3125
2622	6872	8313
2622	6872	470
2622	6872	8962
2622	6872	6790
19822	6873	5517
19822	6873	6201
19822	6873	453
19822	6873	8015
19822	6873	8989
19822	6873	7670
9230	6874	4072
9230	6874	2550
9230	6874	8430
14783	6875	2241
14783	6875	1144
13320	6876	8330
13320	6876	6204
13320	6876	8611
13320	6876	5213
13320	6876	5913
13320	6876	895
13320	6876	4347
13320	6876	8960
13320	6876	7350
3585	6877	3026
3585	6877	6069
3585	6877	1892
3585	6877	829
3585	6877	9431
3585	6877	5944
3585	6877	5502
3585	6877	826
13477	6878	7612
13477	6878	6694
8086	6879	5835
8086	6879	1707
8086	6879	5762
15307	6880	1345
15307	6880	3015
15307	6880	2488
15307	6880	1842
5351	6881	4403
5351	6881	7815
2352	6882	4453
2352	6882	6936
2352	6882	9834
2352	6882	3933
2352	6882	351
2352	6882	6720
2352	6882	8211
2352	6882	8984
1651	6883	3501
1651	6883	8831
1651	6883	1725
1651	6883	9000
1651	6883	7821
1651	6883	4155
1651	6883	5111
9889	6884	7807
9889	6884	3722
9889	6884	5834
9634	6885	5643
9634	6885	9992
9634	6885	703
4856	6886	8387
4856	6886	183
4856	6886	5560
4856	6886	3631
4856	6886	238
4856	6886	6356
154	6887	2009
154	6887	2207
154	6887	9339
154	6887	1280
154	6887	6992
154	6887	8152
154	6887	4410
5594	6888	5338
17938	6889	6388
17938	6889	3838
17938	6889	2889
17938	6889	5334
17938	6889	3235
17938	6889	9535
1629	6890	2797
1629	6890	6417
1629	6890	3671
1151	6891	3040
1151	6891	4310
1151	6891	8112
1151	6891	2308
1151	6891	8640
7947	6892	1514
7947	6892	4161
12126	6893	6116
12126	6893	445
12126	6893	2197
17915	6894	1275
17915	6894	2898
17915	6894	794
17915	6894	1335
19379	6895	1278
10877	6896	1501
15233	6897	7403
15233	6897	4692
15233	6897	7955
15233	6897	1165
8125	6898	9267
8125	6898	802
8416	6899	9127
1897	6900	2051
1897	6900	5473
1897	6900	8888
1897	6900	7850
1897	6900	639
1897	6900	4058
1897	6900	5034
1897	6900	5866
10266	6901	4800
10266	6901	1012
10266	6901	4157
10266	6901	5242
10266	6901	1087
10266	6901	8368
10266	6901	728
19231	6902	3195
19231	6902	5645
19231	6902	9159
19231	6902	1886
19231	6902	4328
19231	6902	157
19231	6902	4692
19231	6902	1167
19231	6902	9917
10316	6903	1243
10316	6903	66
10316	6903	8043
10316	6903	1585
10316	6903	1896
10316	6903	2112
10316	6903	2032
7833	6904	1804
7833	6904	473
7833	6904	1407
2646	6905	6481
2646	6905	4969
2646	6905	6998
2646	6905	9693
2646	6905	7090
2646	6905	9797
2646	6905	6057
2646	6905	6525
9485	6906	7288
9485	6906	5922
9485	6906	304
9485	6906	9399
9485	6906	8651
9485	6906	542
9485	6906	9156
9485	6906	2854
9485	6906	545
15270	6907	6620
6290	6908	7888
6290	6908	5548
6290	6908	3779
6290	6908	2935
6290	6908	8797
6290	6908	6584
14250	6909	2636
14250	6909	4003
14250	6909	7978
14250	6909	815
14250	6909	6184
14250	6909	1681
14250	6909	580
14250	6909	5157
1407	6910	2172
1407	6910	7479
1407	6910	8909
1407	6910	8416
1988	6911	6426
1988	6911	7002
1988	6911	4649
1988	6911	6206
15772	6912	7534
15772	6912	4297
15772	6912	5773
15772	6912	550
15772	6912	4514
15772	6912	8914
14658	6913	8323
14658	6913	7098
14658	6913	5931
1159	6914	1412
1159	6914	3244
1159	6914	2997
1159	6914	6394
1159	6914	7930
16958	6915	6507
16958	6915	3168
16958	6915	6354
16958	6915	1871
16958	6915	669
16958	6915	9426
16958	6915	3067
16958	6915	7178
16958	6915	3936
14360	6916	7957
14360	6916	2439
14360	6916	8474
14360	6916	4366
14360	6916	7416
1166	6917	4775
1166	6917	8641
1166	6917	306
1166	6917	2042
18439	6918	7808
15443	6919	4029
15443	6919	1603
15443	6919	5757
15443	6919	1088
15443	6919	6840
15443	6919	3756
17061	6920	3974
17061	6920	9367
12020	6921	6589
12020	6921	179
12020	6921	763
12020	6921	64
12020	6921	3912
12020	6921	7293
12020	6921	7634
12020	6921	2841
12020	6921	7077
19475	6922	1038
19475	6922	6377
19475	6922	5114
19475	6922	6415
19475	6922	7376
19475	6922	3389
19475	6922	7351
19475	6922	3379
14581	6923	6959
14581	6923	4614
14581	6923	1187
14581	6923	6395
14581	6923	1427
14581	6923	393
13539	6924	4468
13539	6924	6081
13539	6924	2286
13539	6924	9397
13539	6924	3620
13539	6924	7051
12260	6925	2843
12260	6925	6823
12260	6925	5098
12260	6925	5997
12260	6925	4739
12260	6925	8989
12260	6925	3159
15253	6926	9470
15253	6926	6641
15253	6926	3062
15253	6926	1641
15253	6926	2821
15253	6926	6242
15253	6926	8729
11103	6927	8769
7014	6928	8865
7014	6928	7489
7014	6928	6284
7014	6928	7128
7014	6928	2054
7014	6928	4619
12518	6929	7965
12518	6929	8464
12518	6929	554
12518	6929	2245
12518	6929	3607
12518	6929	2779
12518	6929	4520
6767	6930	3340
6767	6930	2000
6767	6930	8973
6767	6930	4234
16523	6931	5110
16523	6931	5866
16523	6931	4507
16523	6931	7061
1335	6932	919
1335	6932	1144
1335	6932	5666
18010	6933	9471
18010	6933	6224
10784	6934	9789
10784	6934	1525
10784	6934	650
10784	6934	2074
4323	6935	5028
12342	6936	4250
12342	6936	7497
12342	6936	8438
12342	6936	5820
12342	6936	673
12342	6936	53
12342	6936	3393
12342	6936	9715
729	6937	8075
729	6937	9730
729	6937	4274
729	6937	5748
729	6937	927
729	6937	5593
729	6937	8111
13097	6938	1210
13097	6938	6227
13097	6938	3367
13097	6938	1103
13097	6938	4537
13097	6938	3446
3039	6939	7972
3039	6939	8652
3039	6939	589
3039	6939	5562
7345	6940	221
7345	6940	2025
7345	6940	53
7345	6940	2692
7345	6940	7870
4812	6941	7891
4812	6941	1465
4812	6941	8451
4812	6941	593
4812	6941	3155
4812	6941	6681
4812	6941	7361
4812	6941	2389
4812	6941	6916
17880	6942	7191
17880	6942	9427
17880	6942	524
17880	6942	7467
17880	6942	5873
17880	6942	5471
7844	6943	1024
7844	6943	4235
7844	6943	8644
2065	6944	3642
2065	6944	4994
2065	6944	187
2065	6944	4411
2065	6944	7246
2065	6944	5541
2828	6945	8752
2828	6945	5242
12531	6946	3970
12531	6946	1413
12531	6946	5129
12531	6946	9163
12531	6946	3817
12531	6946	6451
12531	6946	6342
12531	6946	3618
12531	6946	5795
3287	6947	2964
3287	6947	896
3287	6947	4848
3287	6947	4471
3287	6947	6297
3287	6947	4397
3287	6947	1548
3287	6947	7346
2326	6948	5167
2326	6948	5605
2326	6948	4794
2326	6948	7942
2326	6948	3043
12013	6949	4211
12013	6949	8833
12013	6949	2986
14763	6950	6906
14763	6950	9379
14763	6950	1346
14763	6950	9945
14763	6950	5452
14763	6950	5296
14763	6950	6949
14763	6950	3338
9592	6951	7150
9592	6951	2275
9592	6951	8890
9592	6951	1112
9592	6951	2641
9592	6951	4678
9592	6951	4133
9592	6951	4747
9592	6951	8301
7505	6952	3998
7505	6952	525
7505	6952	7182
7505	6952	2131
7505	6952	1866
7505	6952	3388
7505	6952	5263
12749	6953	324
12749	6953	1586
12664	6954	1024
12664	6954	9073
12664	6954	9213
12664	6954	8454
12664	6954	406
5074	6955	1817
5074	6955	8018
5074	6955	4480
5074	6955	3455
7556	6956	8235
16339	6957	96
16339	6957	9660
16339	6957	215
16339	6957	9045
16339	6957	3748
16339	6957	3157
16339	6957	4937
16339	6957	4765
18487	6958	2010
18487	6958	9286
18487	6958	868
18487	6958	492
18487	6958	5689
11568	6959	5092
11568	6959	4409
11568	6959	6543
11568	6959	5194
11568	6959	718
11568	6959	4673
13452	6960	2234
13452	6960	3281
13452	6960	4476
13452	6960	9038
9453	6961	511
9453	6961	5319
9453	6961	5161
9453	6961	9737
9453	6961	7883
9453	6961	1402
9453	6961	5060
9453	6961	4083
9453	6961	2800
10066	6962	6552
10066	6962	9026
10066	6962	4986
10066	6962	316
10066	6962	437
11509	6963	5481
11509	6963	4617
11509	6963	1094
12306	6964	4296
12306	6964	4853
12306	6964	9925
12306	6964	772
12306	6964	414
12306	6964	2065
4762	6965	3207
4762	6965	7401
5763	6966	6245
5763	6966	5221
5763	6966	3044
5763	6966	4253
5763	6966	2204
5763	6966	3233
5763	6966	9501
5763	6966	8603
5763	6966	3802
10024	6967	6659
10024	6967	901
10024	6967	5888
10024	6967	6941
10024	6967	4689
10024	6967	8576
10024	6967	1393
10024	6967	7220
10024	6967	8958
4381	6968	6195
4381	6968	4164
4381	6968	821
4381	6968	5008
3333	6969	5726
3333	6969	5095
3333	6969	7697
3333	6969	5851
3333	6969	9691
3333	6969	7890
3333	6969	2888
3333	6969	6334
3333	6969	9038
10464	6970	5228
10464	6970	5528
10464	6970	2726
10464	6970	1902
10464	6970	3844
10464	6970	8861
13113	6971	2828
13113	6971	3387
13113	6971	5322
13113	6971	7565
13113	6971	3911
13113	6971	9538
15147	6972	6430
15147	6972	7297
15147	6972	1610
15147	6972	2004
15147	6972	6825
15147	6972	4393
15147	6972	7421
496	6973	965
496	6973	2922
496	6973	8499
496	6973	5131
496	6973	2628
496	6973	5610
4079	6974	1195
4079	6974	519
14686	6975	4461
14686	6975	6417
14686	6975	1730
5389	6976	1224
5389	6976	4122
5389	6976	1320
5389	6976	3317
5389	6976	1224
5389	6976	8968
5389	6976	8663
18361	6977	6524
18361	6977	8748
18361	6977	8906
18361	6977	8705
18361	6977	3106
15780	6978	1174
15780	6978	906
15780	6978	1235
15780	6978	9422
15780	6978	1564
452	6979	9407
452	6979	7506
12507	6980	1418
12507	6980	8875
12507	6980	8691
12507	6980	2413
12507	6980	6757
12507	6980	3540
12507	6980	6079
12507	6980	1884
6895	6981	3673
6895	6981	4827
6895	6981	4354
7377	6982	1929
7377	6982	1540
7377	6982	4527
7377	6982	3008
7377	6982	9285
7377	6982	526
13208	6983	2104
13208	6983	2756
13208	6983	7596
13208	6983	8435
13208	6983	9508
13208	6983	4755
13208	6983	6476
13208	6983	4438
13208	6983	3344
15739	6984	4809
15739	6984	1978
18805	6985	8711
18805	6985	746
18805	6985	35
18805	6985	7896
18805	6985	764
18805	6985	1256
15463	6986	6136
10685	6987	7557
10685	6987	8033
10685	6987	213
4300	6988	6191
4300	6988	9115
4300	6988	1348
4300	6988	4694
4300	6988	4413
4300	6988	7630
4300	6988	3681
19631	6989	5158
19631	6989	9565
19631	6989	3638
19631	6989	2249
19631	6989	3945
19631	6989	5999
19631	6989	8834
15896	6990	4958
18742	6991	9703
785	6992	7417
785	6992	4234
785	6992	424
785	6992	4578
785	6992	1721
15438	6993	9909
15438	6993	640
15438	6993	4501
14343	6994	7472
8518	6995	9735
8518	6995	3488
8518	6995	9461
8518	6995	1839
8518	6995	6584
8518	6995	2561
14577	6996	1229
14577	6996	9510
1882	6997	1429
1882	6997	9010
1882	6997	4631
1882	6997	432
7837	6998	7830
7837	6998	50
7837	6998	3731
7837	6998	4855
7837	6998	9898
7837	6998	6195
11408	6999	6645
11408	6999	5470
8958	7000	8551
8958	7000	9123
8958	7000	7077
8958	7000	1114
8958	7000	7628
8391	7001	6079
18655	7002	7571
18655	7002	730
18655	7002	2982
15040	7003	2602
15040	7003	7955
15040	7003	8826
15040	7003	2944
15040	7003	129
15040	7003	6776
15040	7003	8422
9001	7004	3828
2795	7005	6151
2795	7005	3287
2795	7005	7113
2795	7005	4071
4050	7006	8917
4050	7006	3504
4050	7006	985
4050	7006	4111
4050	7006	153
4050	7006	3906
4050	7006	9986
4050	7006	1501
4050	7006	9131
10562	7007	1641
10562	7007	4317
10562	7007	4533
10562	7007	7736
10562	7007	4122
10562	7007	5104
10562	7007	5698
10562	7007	7903
10562	7007	5494
18799	7008	7133
18799	7008	2423
18799	7008	2295
18799	7008	1544
18799	7008	9013
18799	7008	4818
18799	7008	8895
18799	7008	8136
18799	7008	7696
5598	7009	8887
5598	7009	8788
5598	7009	5840
5598	7009	3780
5598	7009	7741
5598	7009	2704
5598	7009	7175
5598	7009	9238
5598	7009	4997
19628	7010	9164
13717	7011	9658
17088	7012	2924
17088	7012	6749
17088	7012	4001
17088	7012	7616
17088	7012	4652
17088	7012	1702
17088	7012	3509
17088	7012	2140
7439	7013	3436
7439	7013	2534
7439	7013	4344
7439	7013	7264
7439	7013	735
7439	7013	2510
18515	7014	3746
18515	7014	3086
18515	7014	2767
18515	7014	2286
18515	7014	1485
18515	7014	1686
15787	7015	1528
15787	7015	6989
8503	7016	1154
8503	7016	2789
8503	7016	1671
8503	7016	9917
8503	7016	1128
8503	7016	3813
8503	7016	7789
8503	7016	170
8503	7016	524
17336	7017	248
14472	7018	1488
14472	7018	4677
14472	7018	9464
14472	7018	6177
14472	7018	616
3485	7019	5637
11611	7020	7660
11611	7020	5653
11611	7020	4371
11611	7020	8684
11611	7020	3137
11611	7020	7066
11611	7020	2881
4688	7021	3478
4688	7021	9534
4688	7021	1564
4688	7021	390
13701	7022	3836
13701	7022	5096
18933	7023	987
18933	7023	2587
18933	7023	3149
18933	7023	9794
18933	7023	7811
18933	7023	3854
18933	7023	8822
772	7024	7586
772	7024	8555
4779	7025	1878
4779	7025	3757
4779	7025	6085
4779	7025	5790
17876	7026	9351
17876	7026	1589
17876	7026	3236
9100	7027	6254
9100	7027	6133
9100	7027	8972
9100	7027	7197
9100	7027	9618
9100	7027	9556
9100	7027	6340
9100	7027	8117
1823	7028	3500
1823	7028	396
1823	7028	3621
1823	7028	5498
1823	7028	8181
1823	7028	8818
1823	7028	4674
1823	7028	9242
12877	7029	5513
12877	7029	3269
12877	7029	9068
12877	7029	3980
12877	7029	2296
12877	7029	1826
12877	7029	5464
12877	7029	884
12877	7029	5851
8062	7030	8465
8062	7030	3063
8062	7030	994
8062	7030	4145
8062	7030	3235
8062	7030	8294
8062	7030	1508
8062	7030	7887
366	7031	5979
366	7031	4785
366	7031	5081
8753	7032	2489
8753	7032	3265
8753	7032	837
8753	7032	8892
8753	7032	9124
8753	7032	4638
12292	7033	1634
12292	7033	6699
12292	7033	8082
12292	7033	8165
12292	7033	9539
12292	7033	3501
16335	7034	1298
4270	7035	7117
4270	7035	6680
4270	7035	2762
4270	7035	7900
4270	7035	1824
17045	7036	1199
17045	7036	4005
15012	7037	5673
13942	7038	9106
13942	7038	1058
13942	7038	5745
13942	7038	7976
13942	7038	3047
13942	7038	6046
18208	7039	243
18208	7039	6973
18208	7039	5329
18208	7039	1754
18208	7039	815
18208	7039	1064
18208	7039	4397
7004	7040	9724
7004	7040	6957
7004	7040	9893
7004	7040	3574
7004	7040	4874
7004	7040	5042
7004	7040	6089
7004	7040	2857
7004	7040	9532
2570	7041	8711
2570	7041	5616
2570	7041	3340
2570	7041	6609
12665	7042	4031
12665	7042	9956
12665	7042	6200
12665	7042	6585
12665	7042	3095
12665	7042	6527
12665	7042	5735
12665	7042	4138
12665	7042	7343
12108	7043	9161
12108	7043	2231
12108	7043	1590
12108	7043	2102
12108	7043	5179
12108	7043	2220
12108	7043	3737
12108	7043	9963
6116	7044	9010
6116	7044	2246
6116	7044	7607
6116	7044	4317
6116	7044	5643
6116	7044	8899
2258	7045	6355
2258	7045	9738
2258	7045	8807
2258	7045	6668
2258	7045	377
2258	7045	2864
2258	7045	9688
2258	7045	6226
16943	7046	8060
16943	7046	2637
3071	7047	2665
3071	7047	3715
3071	7047	1752
3071	7047	553
3071	7047	5410
3071	7047	3102
11930	7048	1822
11930	7048	2234
11930	7048	521
11930	7048	8599
2472	7049	2771
2472	7049	5919
2472	7049	9864
2472	7049	4454
2472	7049	3086
2472	7049	2174
2472	7049	2225
2472	7049	4281
2472	7049	1240
6124	7050	9469
6124	7050	5923
12323	7051	6145
12323	7051	4325
12323	7051	7509
12323	7051	1696
9561	7052	3275
9561	7052	3252
9561	7052	5267
9561	7052	7661
9561	7052	7554
9561	7052	6723
9561	7052	2492
9561	7052	5090
8786	7053	6467
8786	7053	7013
8786	7053	5798
8786	7053	5937
8786	7053	3489
13526	7054	4319
13526	7054	7321
13526	7054	2242
17928	7055	1609
17928	7055	8033
17928	7055	1379
17928	7055	5366
4758	7056	1087
4758	7056	4325
4758	7056	661
5515	7057	121
5515	7057	7635
5515	7057	8926
5515	7057	1326
5515	7057	3715
5515	7057	7809
18375	7058	7033
18375	7058	1095
18375	7058	6717
18375	7058	6609
18375	7058	6756
18375	7058	4943
18375	7058	26
18375	7058	3749
2766	7059	812
2766	7059	5473
2766	7059	6769
2766	7059	6274
2766	7059	2468
19001	7060	8353
19001	7060	2109
19001	7060	5090
19001	7060	2230
19001	7060	6957
19001	7060	1706
19001	7060	2402
19001	7060	2088
19001	7060	2080
15104	7061	833
15104	7061	5631
15104	7061	7040
15104	7061	2801
15104	7061	4392
13000	7062	5364
13000	7062	3540
13000	7062	599
13000	7062	3025
10224	7063	8011
10224	7063	2306
10224	7063	2166
10224	7063	9137
10224	7063	6439
18479	7064	393
18479	7064	3151
18479	7064	2473
18479	7064	4849
18479	7064	834
18479	7064	1257
7863	7065	8685
7863	7065	3011
7863	7065	2417
7863	7065	4129
7863	7065	2973
7863	7065	7730
16551	7066	7241
19426	7067	5725
19426	7067	6999
10891	7068	1802
10891	7068	4187
10891	7068	589
10891	7068	9988
10891	7068	8157
10891	7068	5284
10891	7068	8192
148	7069	5107
148	7069	1115
13678	7070	3821
9466	7071	4331
9466	7071	2602
9466	7071	9269
9466	7071	9636
9466	7071	5549
9466	7071	3312
9466	7071	9
9466	7071	3815
17842	7072	7575
17842	7072	6828
17842	7072	1375
17842	7072	1880
17842	7072	5381
17842	7072	5152
17842	7072	3024
17842	7072	4630
17842	7072	342
11781	7073	9631
11781	7073	502
11781	7073	4490
3555	7074	2609
3555	7074	548
3555	7074	6841
3555	7074	1346
3555	7074	2786
3555	7074	1933
3555	7074	4250
3555	7074	8101
3555	7074	828
22	7075	9204
7385	7076	5470
7385	7076	5861
7385	7076	6282
7385	7076	2062
7385	7076	8837
7385	7076	5344
14553	7077	3839
14553	7077	8745
14553	7077	3349
14553	7077	4677
7759	7078	7572
7759	7078	8814
7759	7078	6357
5278	7079	5762
5278	7079	6589
5278	7079	1542
17945	7080	4504
17945	7080	6885
3123	7081	5441
3123	7081	845
3123	7081	3859
3123	7081	6054
3123	7081	4333
3123	7081	2854
3123	7081	354
3123	7081	5336
13755	7082	5850
13755	7082	320
13755	7082	3470
13755	7082	8205
13755	7082	8766
13755	7082	36
13755	7082	7843
13755	7082	7219
6544	7083	445
6544	7083	287
6544	7083	3384
6544	7083	7740
6544	7083	2499
16697	7084	8701
16697	7084	8728
14988	7085	1701
17838	7086	2191
17838	7086	7131
17838	7086	3386
13539	7087	9873
13539	7087	2347
15201	7088	6323
15201	7088	9493
15201	7088	8821
1042	7089	9440
1042	7089	1954
1042	7089	6969
1042	7089	4266
1042	7089	6501
1042	7089	7125
1042	7089	8872
1042	7089	5078
1042	7089	8073
1342	7090	1998
1342	7090	2270
1342	7090	7694
1342	7090	1340
1342	7090	9933
3772	7091	970
3772	7091	5020
3772	7091	4374
3772	7091	7011
3772	7091	9141
14425	7092	7883
14425	7092	8424
14425	7092	3646
2678	7093	683
2678	7093	2817
10454	7094	1902
10454	7094	1193
10454	7094	208
10454	7094	9522
7971	7095	7268
7971	7095	3946
15183	7096	8930
15183	7096	7060
15183	7096	8183
15183	7096	7992
15183	7096	5104
14010	7097	3281
14010	7097	4052
14010	7097	8653
14010	7097	6787
14010	7097	5687
14010	7097	9655
7954	7098	8999
7954	7098	3446
7954	7098	5766
7954	7098	5935
7954	7098	2563
7954	7098	4792
7781	7099	3196
7781	7099	4124
1820	7100	4964
1820	7100	6781
1820	7100	691
1820	7100	838
1820	7100	158
1820	7100	5748
1820	7100	5912
16949	7101	5694
16949	7101	8363
16949	7101	2085
16949	7101	5881
16949	7101	3407
932	7102	7180
932	7102	6791
15256	7103	1911
15256	7103	1356
15256	7103	4990
15256	7103	6298
15256	7103	5508
7740	7104	5428
17668	7105	9300
17668	7105	5961
17668	7105	9736
17668	7105	4351
3823	7106	5219
3823	7106	113
3823	7106	2834
16682	7107	2211
16682	7107	6943
16682	7107	5784
16682	7107	6473
16682	7107	7585
16682	7107	8223
15916	7108	2969
15916	7108	8514
15916	7108	8965
15916	7108	5209
15916	7108	3941
15916	7108	5486
7771	7109	3037
7771	7109	6233
7771	7109	8893
7771	7109	8578
7771	7109	8477
7771	7109	22
7771	7109	4758
7771	7109	7332
11691	7110	9578
11691	7110	1033
13036	7111	404
6881	7112	2261
6881	7112	8300
6881	7112	4180
6881	7112	7638
6881	7112	7506
6881	7112	520
7023	7113	5468
7023	7113	7603
3980	7114	2760
3980	7114	2778
3980	7114	6862
3980	7114	7719
3980	7114	9291
3980	7114	9960
3980	7114	2796
3980	7114	7672
3980	7114	9994
230	7115	1373
230	7115	6082
230	7115	3671
230	7115	966
230	7115	9016
230	7115	111
13944	7116	6094
13944	7116	9586
13944	7116	6141
13944	7116	3652
7291	7117	3761
7291	7117	3641
7291	7117	876
7291	7117	4109
7291	7117	9582
7291	7117	1235
7291	7117	8799
7291	7117	389
7539	7118	6440
7539	7118	465
7539	7118	179
7539	7118	6394
16794	7119	2103
16794	7119	6655
1526	7120	5837
1526	7120	2218
1526	7120	105
1526	7120	9283
14992	7121	5295
14992	7121	5397
14992	7121	7414
10351	7122	6697
10351	7122	3333
10351	7122	5269
10351	7122	4114
10351	7122	995
10351	7122	1552
10351	7122	4586
10351	7122	5820
10351	7122	78
5820	7123	6208
5820	7123	2132
5820	7123	2199
5820	7123	8796
5820	7123	9479
5820	7123	4676
19887	7124	2736
19887	7124	2908
19887	7124	4391
420	7125	2405
420	7125	8931
420	7125	9383
420	7125	7824
420	7125	8759
420	7125	1980
2917	7126	4270
2917	7126	7026
2917	7126	4847
2917	7126	5632
2917	7126	4049
2917	7126	5246
2917	7126	232
5273	7127	53
5273	7127	82
5273	7127	228
5273	7127	7898
5273	7127	6394
18879	7128	1329
18879	7128	2388
18879	7128	4174
18879	7128	3929
18879	7128	8041
18879	7128	8214
18879	7128	5781
18879	7128	909
1922	7129	8837
1922	7129	8090
1922	7129	6259
1922	7129	7039
1922	7129	3922
1922	7129	7859
1922	7129	8838
1922	7129	1425
1922	7129	8265
12612	7130	4579
12612	7130	3671
12612	7130	5419
12612	7130	6449
12612	7130	2090
12612	7130	3293
12612	7130	2019
12612	7130	4662
12612	7130	9475
14666	7131	7579
14666	7131	5331
14666	7131	612
10277	7132	5446
10277	7132	2215
10277	7132	2519
10277	7132	106
10277	7132	3948
10277	7132	4787
10277	7132	2950
4849	7133	9758
4849	7133	825
4849	7133	7123
4849	7133	3180
4849	7133	2718
4849	7133	2873
4849	7133	2056
4849	7133	8405
1846	7134	5532
1846	7134	2687
1846	7134	2848
1846	7134	9767
1846	7134	8061
1846	7134	6376
1846	7134	9663
1846	7134	5154
1846	7134	3356
12146	7135	4799
12146	7135	5711
12146	7135	9988
12146	7135	4126
12146	7135	4180
12146	7135	9803
12146	7135	9975
19483	7136	7540
14404	7137	3987
14404	7137	1869
14404	7137	3525
14404	7137	5899
3218	7138	6501
3218	7138	4156
7916	7139	6608
7916	7139	5024
7916	7139	615
7916	7139	4025
7916	7139	9765
7503	7140	2258
7503	7140	9932
7503	7140	7421
7503	7140	9765
12532	7141	6947
12532	7141	527
12532	7141	5188
12532	7141	4545
12532	7141	4262
12532	7141	2774
5076	7142	6289
5076	7142	1091
5076	7142	1077
5076	7142	6703
5076	7142	2200
5076	7142	7444
5076	7142	2733
19359	7143	4174
19359	7143	8841
6204	7144	1388
15588	7145	9773
15588	7145	7490
15588	7145	6835
15588	7145	9347
15588	7145	660
15588	7145	3647
15588	7145	8830
15588	7145	3072
15588	7145	6535
10750	7146	8477
10750	7146	5367
10750	7146	7873
10750	7146	7658
10750	7146	6964
8905	7147	8645
8905	7147	4278
8905	7147	4415
8905	7147	2697
8905	7147	2752
18572	7148	4661
18572	7148	7176
5083	7149	562
5083	7149	9283
5083	7149	8089
5083	7149	1978
5083	7149	2933
5083	7149	3994
5083	7149	9926
5243	7150	8390
5243	7150	7172
5243	7150	7598
5243	7150	377
5243	7150	4969
5243	7150	7314
5243	7150	5880
5243	7150	8628
13432	7151	3084
13432	7151	7999
13432	7151	2995
13432	7151	5486
13432	7151	546
13432	7151	6015
13432	7151	2811
815	7152	5180
4987	7153	369
4987	7153	946
4987	7153	3298
4987	7153	3146
4987	7153	9582
4987	7153	3460
17890	7154	6084
17890	7154	8548
17890	7154	9906
17890	7154	9301
17890	7154	9597
17890	7154	4910
17890	7154	6974
17890	7154	5285
17890	7154	9446
5488	7155	9126
5488	7155	7401
5488	7155	2186
5488	7155	1530
5488	7155	6082
5488	7155	9611
19033	7156	4440
19033	7156	288
19033	7156	2609
19033	7156	2213
19033	7156	4605
19033	7156	4124
8300	7157	3759
8300	7157	6113
8300	7157	7842
8300	7157	8835
16890	7158	7961
16890	7158	7571
15716	7159	5120
15716	7159	5675
15716	7159	5620
15716	7159	7440
15716	7159	3948
15716	7159	3550
15716	7159	2784
15716	7159	3650
4967	7160	928
4967	7160	4323
4967	7160	5164
670	7161	8116
670	7161	7000
670	7161	4595
4067	7162	3445
4067	7162	5240
4067	7162	5851
4067	7162	6854
4067	7162	1373
4067	7162	5715
4067	7162	4502
19330	7163	10000
19330	7163	5517
19330	7163	6551
2290	7164	3179
2290	7164	3024
2290	7164	3963
2290	7164	2852
2290	7164	7153
17050	7165	826
17050	7165	8721
17050	7165	5274
17050	7165	4493
17050	7165	2331
17050	7165	3387
17050	7165	2524
17050	7165	26
6407	7166	9827
6407	7166	2068
6407	7166	9208
6407	7166	2383
6981	7167	9099
6981	7167	585
6981	7167	229
6981	7167	9645
6981	7167	5086
6981	7167	1440
6981	7167	8322
6981	7167	5266
1394	7168	91
1394	7168	7172
1394	7168	4195
1394	7168	1473
1394	7168	3045
4288	7169	6516
12321	7170	9192
12321	7170	8866
8263	7171	4828
8263	7171	6766
8263	7171	4496
17380	7172	630
17380	7172	8021
17380	7172	8680
17380	7172	2235
17380	7172	2070
17380	7172	1356
1095	7173	8061
1095	7173	2661
1095	7173	2780
1095	7173	4197
1095	7173	2407
1095	7173	3482
1095	7173	7381
1095	7173	2311
663	7174	262
663	7174	7386
17483	7175	9289
17483	7175	7985
17483	7175	2515
17483	7175	2025
17483	7175	8133
17483	7175	4839
17483	7175	4912
17483	7175	7162
17483	7175	5294
17608	7176	994
17608	7176	839
17608	7176	2398
17608	7176	7121
17608	7176	86
17608	7176	3503
17608	7176	3759
17608	7176	8715
17608	7176	1311
12297	7177	4469
12297	7177	9208
12297	7177	4022
12297	7177	8567
12297	7177	8964
12297	7177	3892
12297	7177	7939
10118	7178	1468
10452	7179	1009
10452	7179	4149
10452	7179	4764
10452	7179	9926
10452	7179	6085
10452	7179	8995
10452	7179	8643
15212	7180	7408
15212	7180	4112
15212	7180	117
15212	7180	8356
15212	7180	3186
15212	7180	6811
15212	7180	4244
15212	7180	9105
7735	7181	3100
4187	7182	9654
4187	7182	6137
4187	7182	7874
4187	7182	1832
4187	7182	1383
4187	7182	3883
4187	7182	3533
4187	7182	6681
1848	7183	9317
1848	7183	530
1848	7183	9747
1848	7183	5258
1848	7183	5722
1848	7183	8166
8604	7184	7846
8604	7184	1286
8604	7184	5927
8604	7184	8966
8604	7184	2237
8604	7184	9802
8604	7184	6571
8604	7184	6456
8604	7184	6955
13402	7185	6336
9002	7186	8803
9002	7186	2492
9002	7186	7836
7524	7187	3221
7524	7187	489
7524	7187	977
7524	7187	987
7524	7187	2945
16151	7188	8464
16151	7188	1365
16151	7188	5478
16151	7188	3420
16151	7188	6930
9531	7189	8527
9531	7189	1647
9531	7189	9817
9531	7189	4771
9531	7189	9193
9531	7189	8225
9531	7189	3698
16679	7190	9317
16679	7190	8904
16679	7190	2108
16679	7190	9074
16679	7190	8234
16679	7190	3803
16679	7190	6806
16679	7190	6556
12745	7191	7165
12745	7191	4606
12745	7191	1916
12745	7191	8031
12745	7191	6643
12745	7191	804
12745	7191	4736
12745	7191	753
19654	7192	9829
13270	7193	5087
13270	7193	1114
13270	7193	4939
13270	7193	5452
13270	7193	3668
3395	7194	7399
3395	7194	449
3395	7194	6
3395	7194	8978
3395	7194	1028
1713	7195	7491
5155	7196	8251
5155	7196	4617
5155	7196	7126
5155	7196	1069
5155	7196	9982
5155	7196	9462
19821	7197	1112
4279	7198	2996
4279	7198	5685
4279	7198	4444
4279	7198	3064
4279	7198	7249
3731	7199	150
3731	7199	6768
12459	7200	6140
12459	7200	8373
12459	7200	5516
12459	7200	9391
12459	7200	6474
12459	7200	6754
12459	7200	2873
11873	7201	7251
4533	7202	8350
4533	7202	2462
4533	7202	7747
7771	7203	1137
1053	7204	2912
1053	7204	780
1053	7204	9328
1053	7204	1721
1053	7204	4164
1053	7204	568
1053	7204	1237
1053	7204	8676
2275	7205	1110
2275	7205	8466
2275	7205	7961
2275	7205	619
2275	7205	129
6081	7206	8825
6081	7206	3357
6081	7206	7066
6081	7206	9516
6081	7206	3866
6081	7206	2951
6081	7206	339
6081	7206	3679
6081	7206	4366
5662	7207	2433
5662	7207	77
5662	7207	5509
5662	7207	5602
5662	7207	8317
5662	7207	5086
5662	7207	4971
5662	7207	9194
5662	7207	9784
5469	7208	2519
5469	7208	499
5469	7208	4067
5469	7208	9715
5469	7208	2474
5469	7208	475
11965	7209	1616
13402	7210	8852
13402	7210	4192
13402	7210	3601
13402	7210	1370
13402	7210	5006
13402	7210	8479
13402	7210	773
13402	7210	8010
13402	7210	9506
19959	7211	5962
19959	7211	7656
19959	7211	4064
19959	7211	4278
19959	7211	2098
19959	7211	5954
19959	7211	1766
6270	7212	7024
15593	7213	8284
15593	7213	4721
15593	7213	9262
15593	7213	8265
11839	7214	8311
11839	7214	1618
11839	7214	208
11839	7214	6698
11839	7214	7125
11839	7214	5108
4263	7215	9928
4263	7215	3608
4263	7215	2170
4263	7215	9131
4263	7215	6081
4263	7215	6654
4263	7215	3315
4263	7215	4430
4263	7215	6532
13479	7216	8712
13479	7216	1148
13479	7216	6622
13479	7216	5951
13479	7216	3660
13479	7216	2621
13479	7216	4090
13479	7216	5595
3352	7217	9899
3352	7217	2327
3352	7217	5555
15176	7218	6319
15176	7218	4738
15176	7218	8129
15176	7218	1757
10831	7219	2683
10831	7219	8502
10831	7219	7266
10831	7219	9954
19704	7220	4181
19704	7220	8780
19704	7220	4952
19704	7220	8551
19704	7220	8686
19704	7220	8737
19704	7220	4647
19704	7220	893
19704	7220	5908
17181	7221	6868
17181	7221	2673
17181	7221	40
17181	7221	6673
17181	7221	188
17181	7221	9213
17181	7221	5410
17181	7221	3344
4058	7222	8843
4058	7222	4662
4058	7222	7631
4058	7222	585
10958	7223	7638
10958	7223	2848
10958	7223	7972
10958	7223	9526
10958	7223	373
10958	7223	7126
938	7224	2498
938	7224	2504
938	7224	8880
938	7224	1077
938	7224	7735
938	7224	3592
938	7224	7140
938	7224	2921
11536	7225	5288
11536	7225	2461
11536	7225	719
11536	7225	1442
2365	7226	8170
2365	7226	3894
2365	7226	1622
18712	7227	6250
18712	7227	5776
18712	7227	8548
18712	7227	4938
18712	7227	6406
18712	7227	2983
18712	7227	5886
14653	7228	8509
14653	7228	1060
14653	7228	3731
14653	7228	3727
14653	7228	9924
14653	7228	4708
14653	7228	4439
14653	7228	325
17746	7229	9876
17746	7229	5291
17746	7229	7590
17746	7229	6559
17746	7229	8502
14021	7230	3688
14021	7230	561
14021	7230	2235
14021	7230	4702
14021	7230	7038
14021	7230	7899
16053	7231	3092
16053	7231	397
15972	7232	4028
15972	7232	9406
15972	7232	5070
15972	7232	4183
15972	7232	9441
3350	7233	8617
13031	7234	4542
13031	7234	1039
13031	7234	1972
13031	7234	6014
13031	7234	9420
13031	7234	6467
13031	7234	3630
13031	7234	2023
13031	7234	8431
15742	7235	9546
15742	7235	4501
15742	7235	8438
15742	7235	4677
18437	7236	6851
18437	7236	6352
18437	7236	6838
18437	7236	8436
18437	7236	9219
2482	7237	7446
2482	7237	5477
2482	7237	1848
2482	7237	4567
2482	7237	3185
2482	7237	863
2482	7237	1069
9990	7238	893
9990	7238	6795
9990	7238	1784
9990	7238	1034
419	7239	7816
419	7239	6281
419	7239	8081
419	7239	8315
419	7239	4478
419	7239	5653
419	7239	9360
419	7239	82
19484	7240	5754
19484	7240	338
19484	7240	2395
19380	7241	7750
8061	7242	2159
8061	7242	1197
8061	7242	2502
8061	7242	1975
8061	7242	3570
8061	7242	8301
8061	7242	1798
8061	7242	7894
16462	7243	9602
16462	7243	7919
16462	7243	4406
16462	7243	577
16462	7243	9699
16462	7243	3423
16462	7243	4267
16462	7243	8492
934	7244	2524
934	7244	323
934	7244	5600
934	7244	1873
934	7244	6446
12094	7245	7228
12094	7245	3248
12094	7245	9864
12094	7245	1068
12094	7245	4803
12094	7245	7906
12094	7245	2102
1461	7246	7661
1461	7246	606
1461	7246	2947
1461	7246	4693
1461	7246	9437
1461	7246	5440
5335	7247	471
5335	7247	8128
5335	7247	8163
5335	7247	6873
5335	7247	6224
19970	7248	6269
19970	7248	4582
19970	7248	624
19970	7248	9352
19970	7248	6921
19970	7248	9671
19970	7248	8810
19970	7248	5027
19970	7248	6786
9827	7249	7844
9827	7249	2927
9827	7249	2883
9827	7249	4052
9827	7249	8217
9827	7249	9951
9827	7249	7195
13091	7250	5334
13091	7250	9605
13091	7250	7167
13091	7250	7964
13091	7250	130
13091	7250	8866
13091	7250	3520
12892	7251	4813
12892	7251	6542
12892	7251	5149
12892	7251	5827
12304	7252	3397
12304	7252	8520
12304	7252	8364
12654	7253	2987
12654	7253	4928
12654	7253	5213
12654	7253	2952
12654	7253	9957
12654	7253	817
12654	7253	793
13238	7254	2771
12335	7255	9170
12335	7255	7222
13720	7256	5364
13720	7256	5598
13720	7256	5494
13720	7256	6565
13720	7256	6313
13720	7256	1949
13720	7256	3346
13720	7256	3724
13720	7256	4997
16025	7257	9548
13538	7258	3629
13538	7258	5239
13538	7258	2693
13538	7258	9569
13538	7258	9385
13538	7258	3637
11169	7259	524
11169	7259	8513
11169	7259	3021
11169	7259	3532
11169	7259	7622
11169	7259	7514
11169	7259	9848
6954	7260	2469
6954	7260	9884
6954	7260	226
6954	7260	8172
6954	7260	4965
6954	7260	9446
6954	7260	8547
6954	7260	4293
6954	7260	5489
18040	7261	2099
18040	7261	9704
7026	7262	2561
7026	7262	8042
7026	7262	9930
7026	7262	1712
7026	7262	2128
7026	7262	9789
16670	7263	5394
16670	7263	6049
16670	7263	6050
16670	7263	1853
16670	7263	9552
16670	7263	95
16670	7263	5069
16670	7263	2210
502	7264	8518
502	7264	1442
502	7264	8461
502	7264	2218
7519	7265	790
7519	7265	4771
7519	7265	6731
7519	7265	4987
7519	7265	8180
6496	7266	877
6496	7266	4949
6496	7266	7350
6496	7266	2733
6496	7266	4111
12658	7267	89
12658	7267	4545
12658	7267	3422
12658	7267	7717
12658	7267	5939
12658	7267	6434
12658	7267	7786
12658	7267	7366
12658	7267	3620
17138	7268	2035
17138	7268	8537
17138	7268	3116
17138	7268	2475
17138	7268	8144
17138	7268	2947
17138	7268	3441
17138	7268	2004
17138	7268	6521
5908	7269	1876
5908	7269	31
4850	7270	2170
4850	7270	8783
4850	7270	2245
4850	7270	9264
4850	7270	9110
4850	7270	7283
4850	7270	96
4198	7271	41
4198	7271	7899
4198	7271	7385
4198	7271	1529
4198	7271	5271
18670	7272	5434
18670	7272	2716
3958	7273	9386
3958	7273	7902
3958	7273	403
3958	7273	1580
3958	7273	1272
3958	7273	8021
10812	7274	2821
10812	7274	4448
10812	7274	3550
10812	7274	4670
10812	7274	5343
4158	7275	7925
4158	7275	8740
4158	7275	8231
4158	7275	2154
4158	7275	1424
4158	7275	1431
4158	7275	2595
4158	7275	4851
4158	7275	403
9700	7276	5354
9700	7276	8288
9700	7276	2386
9700	7276	2775
9700	7276	4010
9700	7276	498
9700	7276	6526
9700	7276	1892
9700	7276	8538
19935	7277	5120
19935	7277	6237
19935	7277	5282
19935	7277	372
19935	7277	1294
19163	7278	4532
19163	7278	4747
19163	7278	9895
12841	7279	5099
12841	7279	6499
12841	7279	2477
15192	7280	3118
15192	7280	126
15192	7280	7764
15192	7280	9215
15192	7280	1001
15192	7280	1374
15192	7280	4831
15192	7280	4074
10728	7281	8547
10728	7281	7846
10728	7281	3446
10728	7281	4304
10728	7281	7918
2072	7282	4526
2072	7282	5026
2072	7282	9463
2072	7282	9376
8413	7283	8931
8413	7283	996
8413	7283	3659
8413	7283	6320
8413	7283	4587
8413	7283	1826
19487	7284	779
19487	7284	2197
19487	7284	4473
19487	7284	9045
19487	7284	3249
19487	7284	4773
19487	7284	2626
19487	7284	439
2868	7285	976
2868	7285	5214
2868	7285	7717
2868	7285	4452
9028	7286	7900
9028	7286	2865
9028	7286	837
9028	7286	6309
9028	7286	329
9028	7286	8892
9028	7286	2811
5724	7287	6572
5724	7287	4096
5724	7287	7302
5724	7287	8824
5724	7287	4639
5724	7287	6267
8334	7288	6540
8334	7288	7941
8334	7288	4592
8334	7288	3930
8334	7288	1223
8334	7288	2815
7158	7289	5319
7158	7289	7958
7158	7289	7784
7158	7289	4374
7158	7289	2387
7158	7289	8480
16300	7290	8657
16300	7290	4196
16251	7291	4866
16251	7291	4750
16251	7291	3125
16251	7291	641
16251	7291	2599
16251	7291	1064
16251	7291	5381
16251	7291	2806
16251	7291	6077
1769	7292	2232
1769	7292	4429
1769	7292	1340
1769	7292	4553
1769	7292	1238
11975	7293	2614
10425	7294	5596
16802	7295	9686
16802	7295	2644
9749	7296	1302
9749	7296	1146
9749	7296	6622
9749	7296	5272
9749	7296	8371
9749	7296	4978
9749	7296	3683
9749	7296	6197
9749	7296	4406
176	7297	1847
176	7297	1174
11338	7298	4593
11338	7298	4759
11338	7298	6520
11338	7298	8121
11338	7298	5617
11338	7298	948
9260	7299	1437
9260	7299	5462
9260	7299	9248
9260	7299	8330
19006	7300	5172
19006	7300	737
19006	7300	5615
19006	7300	5502
19006	7300	6876
4985	7301	3087
4985	7301	9502
4985	7301	1259
4985	7301	7000
4985	7301	7685
12028	7302	5517
12028	7302	2433
12028	7302	7874
12028	7302	451
12028	7302	8665
12028	7302	5622
12028	7302	9575
12028	7302	8032
2235	7303	8958
2235	7303	4857
2235	7303	5254
2235	7303	2205
19091	7304	2471
19091	7304	4759
19091	7304	1134
19091	7304	3832
18907	7305	9000
6835	7306	7337
6835	7306	6231
6835	7306	9401
6835	7306	4734
6835	7306	9111
6835	7306	1151
6835	7306	7361
4238	7307	7329
4238	7307	3539
4238	7307	7251
4238	7307	9227
19300	7308	7348
19300	7308	174
19300	7308	9196
19300	7308	5063
19300	7308	1179
19300	7308	7219
19300	7308	8817
2846	7309	5164
2846	7309	7713
2846	7309	2517
2846	7309	7577
2846	7309	1213
2846	7309	1393
2846	7309	6550
2846	7309	7883
2846	7309	2320
14765	7310	1556
14765	7310	9805
14765	7310	2807
14765	7310	1795
14765	7310	5670
14765	7310	3530
14765	7310	5660
6472	7311	3057
6472	7311	436
6472	7311	7922
6472	7311	6329
6472	7311	5397
6472	7311	7623
6472	7311	101
6472	7311	4633
6472	7311	9551
2691	7312	8304
2691	7312	4711
6109	7313	2611
6109	7313	3488
6109	7313	9861
6109	7313	1365
13523	7314	3167
13523	7314	8451
13523	7314	8821
13523	7314	5237
13523	7314	9346
13523	7314	5810
13523	7314	2650
13523	7314	1611
13523	7314	3575
12371	7315	9232
12371	7315	8370
12371	7315	5114
12371	7315	7358
12371	7315	9290
12371	7315	2844
12371	7315	8323
7118	7316	5737
7118	7316	2734
7118	7316	2475
7118	7316	7555
7118	7316	3154
4436	7317	1143
4436	7317	2062
18839	7318	9944
18839	7318	3406
18839	7318	4692
18839	7318	1825
18839	7318	4232
18839	7318	2792
10533	7319	1315
10533	7319	4530
10533	7319	6682
10533	7319	5014
14152	7320	6495
14152	7320	919
14152	7320	7290
14152	7320	4704
14152	7320	3470
15403	7321	4667
15403	7321	877
15403	7321	3539
15403	7321	440
15403	7321	5740
15403	7321	588
18928	7322	4716
18928	7322	3288
18928	7322	763
18928	7322	9958
18928	7322	2559
18928	7322	1994
18928	7322	1130
18928	7322	988
18928	7322	6120
19317	7323	7727
19317	7323	9334
8558	7324	3304
8558	7324	2700
8558	7324	8128
8558	7324	7168
8558	7324	8928
8558	7324	1514
8558	7324	5104
8558	7324	7005
6249	7325	2783
1019	7326	8824
1019	7326	6035
18676	7327	5929
18676	7327	6885
18676	7327	5308
18676	7327	2823
15853	7328	4017
15853	7328	6863
15853	7328	8113
15853	7328	3979
11559	7329	8127
11559	7329	5579
11559	7329	7663
11559	7329	2274
11559	7329	1896
11559	7329	6688
11559	7329	4971
11559	7329	4025
11559	7329	7437
2907	7330	3424
2907	7330	1952
2907	7330	39
4658	7331	654
4658	7331	158
4862	7332	1589
4862	7332	436
4862	7332	8105
11082	7333	6994
11082	7333	6014
11082	7333	8843
11082	7333	7819
2000	7334	2308
2000	7334	7818
18308	7335	2386
18308	7335	682
17572	7336	4327
17572	7336	5015
2058	7337	8994
2058	7337	2294
2058	7337	556
2058	7337	221
16076	7338	7192
16076	7338	7635
16076	7338	6709
16076	7338	2399
16076	7338	7102
2856	7339	2749
2856	7339	7105
2856	7339	2891
2856	7339	4042
2856	7339	5164
2856	7339	8687
8108	7340	9601
8108	7340	3013
8108	7340	191
5180	7341	2270
5180	7341	4081
5180	7341	6612
7432	7342	9814
7432	7342	4731
7432	7342	9953
7432	7342	360
7432	7342	7472
7432	7342	202
7432	7342	4394
7432	7342	4308
7432	7342	2937
4822	7343	2947
4822	7343	6623
4822	7343	3418
4822	7343	3274
4822	7343	2827
4822	7343	87
4822	7343	8064
4822	7343	974
4822	7343	7452
15305	7344	867
15305	7344	1184
15305	7344	9682
15305	7344	6214
15305	7344	7801
15305	7344	8782
4398	7345	6931
4398	7345	5079
6286	7346	1567
6286	7346	7504
6286	7346	2158
6286	7346	370
6286	7346	2844
6286	7346	6828
6286	7346	9911
6286	7346	4717
6286	7346	2202
1840	7347	2912
1840	7347	365
1840	7347	9643
1840	7347	1134
1840	7347	7509
1840	7347	1203
1840	7347	6471
1840	7347	8032
1840	7347	6386
6426	7348	6254
6426	7348	6016
6426	7348	1616
6426	7348	9375
6426	7348	7987
6426	7348	9939
6426	7348	277
6426	7348	6802
8620	7349	9322
8620	7349	843
8620	7349	7421
8620	7349	8229
8620	7349	440
8620	7349	4118
8620	7349	9747
2725	7350	8675
2725	7350	6811
2725	7350	4621
2725	7350	8195
2725	7350	8497
5212	7351	3186
5212	7351	2406
5212	7351	24
5212	7351	6420
5212	7351	2263
4020	7352	3373
4020	7352	6831
4020	7352	5222
19686	7353	1265
19686	7353	3327
19686	7353	1831
19686	7353	2050
19686	7353	8078
19686	7353	5622
19686	7353	5089
19686	7353	8565
11445	7354	8029
11445	7354	2201
11445	7354	4780
10878	7355	4293
10878	7355	8454
10878	7355	5526
10878	7355	2900
10878	7355	5300
10878	7355	2031
10878	7355	9079
10878	7355	2963
10878	7355	4471
7665	7356	6566
7665	7356	6254
9508	7357	3983
9508	7357	4204
9508	7357	8695
9508	7357	2720
9508	7357	7305
9508	7357	2572
3300	7358	9293
3300	7358	7443
12462	7359	7219
12462	7359	2668
18903	7360	528
18903	7360	1477
18903	7360	5235
18903	7360	817
18903	7360	2215
18903	7360	1875
18903	7360	5038
18903	7360	3058
18903	7360	9253
8020	7361	5332
15999	7362	7451
15999	7362	5444
15999	7362	6386
15999	7362	7200
15999	7362	1117
15999	7362	4161
12070	7363	4363
12070	7363	772
12070	7363	8043
12070	7363	7626
12070	7363	8798
12070	7363	8723
16601	7364	9181
16601	7364	6385
16601	7364	8908
16601	7364	7188
16601	7364	1600
16601	7364	3355
16601	7364	7383
16601	7364	9445
431	7365	7975
431	7365	8201
431	7365	5944
431	7365	6914
6916	7366	5446
6916	7366	9970
6916	7366	5275
6916	7366	4377
15463	7367	5572
15463	7367	7632
15463	7367	9537
15463	7367	4382
15463	7367	5978
15463	7367	4283
2393	7368	4655
2393	7368	9132
2393	7368	5819
2393	7368	4453
2393	7368	6259
9526	7369	650
9526	7369	7164
9526	7369	3088
9526	7369	1274
9526	7369	4210
9526	7369	51
9526	7369	9173
9526	7369	9689
8686	7370	4443
8686	7370	2515
8686	7370	9033
8686	7370	7724
8569	7371	6417
8569	7371	2467
8569	7371	8705
8569	7371	6973
14048	7372	6580
1725	7373	4277
13583	7374	5565
13583	7374	4249
13583	7374	783
13583	7374	3286
13583	7374	1095
13583	7374	6703
13583	7374	9493
969	7375	648
969	7375	5212
969	7375	8141
969	7375	9083
14601	7376	4550
14601	7376	5800
14601	7376	3873
14601	7376	7888
14601	7376	3780
14601	7376	2912
14601	7376	8780
14601	7376	4158
14601	7376	2889
7072	7377	2341
2846	7378	8723
2846	7378	1299
14196	7379	3680
14919	7380	7942
4199	7381	6957
4199	7381	9445
4199	7381	5642
4199	7381	9369
4199	7381	3207
4199	7381	9109
814	7382	7505
2368	7383	8643
2368	7383	9509
2368	7383	3893
2368	7383	8684
2368	7383	8438
2368	7383	7926
2368	7383	4733
2368	7383	9666
2368	7383	679
19573	7384	193
15395	7385	8881
15395	7385	846
708	7386	2883
708	7386	7682
708	7386	8431
708	7386	9201
708	7386	9174
19705	7387	9639
19705	7387	3557
19705	7387	6547
19705	7387	7529
12820	7388	3934
12820	7388	7479
12820	7388	3598
12820	7388	832
12820	7388	1681
12820	7388	6886
12820	7388	2426
19379	7389	3117
19379	7389	8029
9150	7390	8400
9150	7390	9321
9150	7390	4401
3758	7391	2240
3758	7391	633
3758	7391	1389
3758	7391	4801
3758	7391	3578
3758	7391	3503
3758	7391	6036
3758	7391	5040
3758	7391	3293
8580	7392	1566
8580	7392	3775
8580	7392	5906
8580	7392	7845
8580	7392	8886
8580	7392	9326
8580	7392	4004
17609	7393	3353
18777	7394	3452
18777	7394	5562
18777	7394	2231
18777	7394	9129
18777	7394	1545
14900	7395	4649
14900	7395	7691
14900	7395	838
14900	7395	4688
14900	7395	499
14900	7395	8487
14900	7395	7245
3786	7396	9834
3786	7396	8782
3786	7396	8186
3786	7396	5862
3786	7396	813
3786	7396	7180
3786	7396	3231
1844	7397	2616
1844	7397	3277
1844	7397	9706
1844	7397	6967
1844	7397	353
8165	7398	3375
8165	7398	741
8165	7398	3591
8165	7398	1291
8165	7398	2225
8165	7398	7650
8165	7398	300
8165	7398	6378
17987	7399	2108
18148	7400	9280
18148	7400	7092
18148	7400	765
3010	7401	8107
3010	7401	9851
3010	7401	1787
3010	7401	5787
3010	7401	9715
14666	7402	8228
14666	7402	1079
14666	7402	2339
14666	7402	3894
14666	7402	6414
14356	7403	8683
14356	7403	5102
14356	7403	6796
14356	7403	7121
14356	7403	2452
14356	7403	668
14356	7403	5071
14356	7403	9499
14356	7403	3637
9429	7404	9040
9429	7404	3449
2490	7405	899
2490	7405	8420
2490	7405	8102
2490	7405	951
2490	7405	3797
8930	7406	3321
8930	7406	9428
8930	7406	2793
2805	7407	3907
14792	7408	2338
14792	7408	106
14792	7408	2342
14792	7408	5972
14792	7408	3430
14792	7408	6695
14792	7408	4234
14792	7408	4758
8370	7409	3105
7712	7410	8056
7712	7410	2827
7712	7410	1850
7712	7410	9843
7712	7410	5921
3786	7411	1662
3786	7411	5151
3786	7411	4435
3786	7411	3449
15920	7412	4143
15920	7412	1053
15920	7412	8842
15920	7412	4092
15920	7412	2609
15920	7412	6832
15920	7412	7897
16119	7413	1652
13603	7414	6709
13603	7414	8480
13603	7414	3610
13603	7414	7998
13603	7414	3776
13603	7414	8788
13603	7414	8159
1534	7415	3218
1534	7415	3870
17031	7416	4822
17031	7416	3228
17031	7416	6960
17031	7416	2673
17031	7416	737
17031	7416	5805
19162	7417	2199
19162	7417	5701
19162	7417	6711
19857	7418	7780
19857	7418	9987
9616	7419	1831
9616	7419	5599
9616	7419	8386
9616	7419	786
9616	7419	5070
9616	7419	3772
11940	7420	2454
11940	7420	7862
11940	7420	5438
11940	7420	1526
3023	7421	6320
3023	7421	3205
3023	7421	7892
3023	7421	2654
3023	7421	5138
3023	7421	468
3023	7421	8260
11804	7422	9244
11804	7422	7369
5613	7423	6024
5613	7423	5753
5613	7423	8851
5613	7423	9930
15642	7424	4099
15642	7424	6315
15642	7424	6203
18528	7425	1124
18528	7425	1675
18528	7425	6825
18528	7425	1299
18528	7425	8632
18528	7425	4336
18528	7425	2306
18528	7425	6456
18528	7425	5242
12199	7426	2095
12199	7426	8720
12199	7426	441
12199	7426	7561
17369	7427	7176
17369	7427	2602
17369	7427	488
17369	7427	5797
17369	7427	5617
17369	7427	8009
17369	7427	337
17369	7427	8749
16602	7428	4168
16602	7428	9743
14607	7429	5988
14607	7429	5539
14607	7429	3622
14607	7429	1638
14607	7429	9374
14607	7429	8932
14607	7429	5536
11744	7430	6264
11744	7430	4113
11744	7430	985
11744	7430	4076
11744	7430	2888
11744	7430	8031
8035	7431	7181
8035	7431	5873
8035	7431	2303
8035	7431	6251
8035	7431	238
8035	7431	8175
8035	7431	7658
7844	7432	4732
7844	7432	5505
7844	7432	9618
7844	7432	3674
7844	7432	6805
7844	7432	1665
7844	7432	3600
18944	7433	4719
18944	7433	3109
2567	7434	9649
2567	7434	7279
2567	7434	2594
2567	7434	6444
12123	7435	3709
12123	7435	360
12123	7435	4674
12123	7435	4218
12123	7435	3431
16299	7436	3106
16299	7436	511
16299	7436	4850
16299	7436	732
16299	7436	7713
16299	7436	4139
16299	7436	1424
16299	7436	218
16299	7436	9450
19618	7437	3768
19618	7437	128
19618	7437	5398
19618	7437	5347
19618	7437	5474
19618	7437	2684
15065	7438	9661
15065	7438	7870
15065	7438	8012
15065	7438	8756
15065	7438	7208
16836	7439	4301
16836	7439	4973
741	7440	1562
741	7440	2778
741	7440	2133
741	7440	1777
2875	7441	5236
2875	7441	8301
2875	7441	8373
2875	7441	2198
2875	7441	3926
2875	7441	1984
2875	7441	1993
2875	7441	2654
2875	7441	7327
17776	7442	3133
17776	7442	4667
17776	7442	9885
17776	7442	6347
17776	7442	4810
17776	7442	2160
17776	7442	5574
17776	7442	8618
5086	7443	770
5086	7443	10000
5086	7443	947
12487	7444	4319
12487	7444	7837
12487	7444	4256
12487	7444	4788
12487	7444	9738
12487	7444	2184
15515	7445	5529
15515	7445	3867
9272	7446	8059
9272	7446	3859
9272	7446	676
9272	7446	1038
9272	7446	9420
9272	7446	3978
17531	7447	8362
17531	7447	8231
17531	7447	4218
17531	7447	2393
17531	7447	4147
17531	7447	3257
13485	7448	1175
13485	7448	3765
13485	7448	1141
13485	7448	6843
13485	7448	3677
13485	7448	4235
13485	7448	9586
13485	7448	6607
13485	7448	4972
18378	7449	8935
18378	7449	7668
17125	7450	7517
17125	7450	8598
17125	7450	1958
17125	7450	6083
17125	7450	299
17125	7450	9621
17125	7450	33
13279	7451	1477
13279	7451	7205
13279	7451	7579
13279	7451	6614
13279	7451	8330
13279	7451	3808
13279	7451	4464
13279	7451	7372
18658	7452	8129
18658	7452	8447
18658	7452	7632
18658	7452	6956
18658	7452	5118
18658	7452	8691
18658	7452	280
18658	7452	3566
359	7453	7114
3154	7454	4639
3154	7454	4327
3154	7454	9526
3154	7454	537
3154	7454	205
14320	7455	1269
14320	7455	8162
3454	7456	1907
3454	7456	5825
3454	7456	9419
3454	7456	597
3454	7456	8449
5551	7457	5231
5551	7457	5989
5551	7457	1377
5551	7457	2595
5551	7457	4007
5551	7457	7753
5551	7457	5412
5551	7457	3895
11601	7458	4820
11601	7458	5917
11601	7458	4395
5773	7459	904
5773	7459	6533
5773	7459	7806
801	7460	4264
801	7460	5505
801	7460	7061
801	7460	4491
3629	7461	8557
5903	7462	5838
5903	7462	9409
5903	7462	5962
5903	7462	3633
5903	7462	3850
5903	7462	4168
16863	7463	8106
16863	7463	1203
12803	7464	6420
12803	7464	6873
12803	7464	5919
12803	7464	7940
12803	7464	6912
5748	7465	6642
5748	7465	5092
2783	7466	3196
2783	7466	1894
2783	7466	9942
2783	7466	800
2783	7466	5302
2783	7466	7320
2783	7466	9074
14027	7467	4361
14027	7467	5281
14027	7467	5619
1421	7468	2102
1421	7468	880
1421	7468	9317
1421	7468	9696
989	7469	7714
989	7469	761
989	7469	4168
989	7469	3801
989	7469	8663
989	7469	2651
989	7469	5812
989	7469	5865
17191	7470	567
19767	7471	9142
19767	7471	6568
19767	7471	29
19767	7471	3682
19767	7471	1070
19767	7471	7045
11414	7472	9650
11414	7472	7929
11414	7472	9442
11414	7472	4110
11414	7472	7990
11414	7472	9330
11414	7472	4560
11414	7472	442
11414	7472	8926
17908	7473	9743
13574	7474	2494
13574	7474	4653
13574	7474	9104
13574	7474	7657
13574	7474	9490
14959	7475	1848
14959	7475	9306
16463	7476	7186
16463	7476	1291
18547	7477	4267
17838	7478	1501
17838	7478	8090
17838	7478	7774
17838	7478	8469
17838	7478	2402
17838	7478	5217
17838	7478	2605
17838	7478	9939
17838	7478	1075
4729	7479	1638
4729	7479	5623
4729	7479	3976
4729	7479	4823
4729	7479	5609
7396	7480	4279
7396	7480	324
7396	7480	6098
7396	7480	8389
7396	7480	5460
7396	7480	606
6196	7481	8541
6196	7481	7272
6196	7481	6441
6196	7481	228
6196	7481	3573
6196	7481	7587
6196	7481	9534
6196	7481	8015
6196	7481	681
13555	7482	5480
13555	7482	7210
13555	7482	5870
13555	7482	9183
13555	7482	2165
13555	7482	5304
13555	7482	1887
13555	7482	683
8511	7483	6162
8352	7484	2513
8352	7484	2950
8352	7484	673
8352	7484	5727
8352	7484	4514
8352	7484	543
5414	7485	2143
5414	7485	3413
12839	7486	7013
12839	7486	854
12839	7486	7418
12839	7486	8678
3255	7487	57
3255	7487	2495
3255	7487	3644
3255	7487	8265
3255	7487	5744
15773	7488	711
15773	7488	1507
15773	7488	1777
15773	7488	1033
15773	7488	1025
19404	7489	1330
19404	7489	3335
19404	7489	6747
19404	7489	5955
19404	7489	8867
19404	7489	398
19404	7489	3902
19404	7489	2497
6415	7490	998
6415	7490	7185
6415	7490	9703
6415	7490	480
6415	7490	7911
6415	7490	3205
6415	7490	3560
6415	7490	626
13161	7491	800
13161	7491	5844
16680	7492	1548
5090	7493	4576
5090	7493	4384
5090	7493	8144
5090	7493	3914
5090	7493	1535
5090	7493	7887
509	7494	1489
509	7494	9570
509	7494	4241
509	7494	5672
509	7494	3060
509	7494	2718
509	7494	9764
509	7494	8225
5216	7495	4903
5216	7495	9829
5216	7495	781
5216	7495	8598
5216	7495	7970
5216	7495	7037
5216	7495	6878
5216	7495	6790
4922	7496	9680
4922	7496	4449
4922	7496	6343
13359	7497	5160
13359	7497	6482
13359	7497	6621
10436	7498	2556
18865	7499	551
18865	7499	9381
18865	7499	1205
18865	7499	7167
18865	7499	8503
18865	7499	8326
18865	7499	188
10695	7500	336
10695	7500	9203
10050	7501	7884
10050	7501	7616
10050	7501	763
10050	7501	6154
10050	7501	5666
10050	7501	9203
10050	7501	3012
10050	7501	6340
13055	7502	1875
13055	7502	7388
13055	7502	9144
13055	7502	5251
13055	7502	1615
18996	7503	6847
6000	7504	358
6000	7504	7232
6000	7504	621
6000	7504	4706
19299	7505	8383
19299	7505	4184
18869	7506	8398
18869	7506	1145
15983	7507	991
15983	7507	8953
15983	7507	1401
15983	7507	4718
15983	7507	9755
19706	7508	1827
19706	7508	2130
19706	7508	4982
19706	7508	5445
19706	7508	3809
19706	7508	2529
19706	7508	5045
19706	7508	2944
7870	7509	5284
7870	7509	8037
15582	7510	7644
15582	7510	3039
15582	7510	5954
15582	7510	5480
1848	7511	4766
1848	7511	6091
18069	7512	2970
18069	7512	3843
3758	7513	9670
3758	7513	3710
3758	7513	6177
3758	7513	6783
3758	7513	1917
3758	7513	3064
3758	7513	3187
3758	7513	384
3758	7513	2019
2217	7514	3098
2217	7514	5321
2217	7514	6731
2217	7514	8820
2217	7514	2312
2217	7514	2664
2217	7514	5802
5169	7515	4847
5169	7515	3932
5169	7515	5309
5169	7515	5985
5169	7515	789
12595	7516	4775
12595	7516	8475
14587	7517	5782
14587	7517	7746
1030	7518	5201
1030	7518	2993
1030	7518	7047
1030	7518	3448
1030	7518	5629
1030	7518	6779
1030	7518	534
1030	7518	5599
1030	7518	4373
7571	7519	5510
7571	7519	2458
7571	7519	8731
5795	7520	1911
5795	7520	8102
5795	7520	703
5795	7520	1989
5795	7520	5785
5795	7520	396
5795	7520	6682
5795	7520	1627
5795	7520	67
2863	7521	8579
14618	7522	206
14618	7522	6342
14618	7522	6463
14618	7522	1075
14618	7522	5992
14618	7522	3498
14618	7522	1830
17023	7523	9566
17023	7523	8163
17023	7523	1385
17023	7523	4756
17023	7523	4110
17023	7523	7272
17023	7523	5731
17023	7523	2821
17023	7523	9595
1337	7524	3732
1337	7524	4284
1337	7524	3839
7452	7525	3679
7452	7525	8044
7452	7525	171
7452	7525	5026
4594	7526	9775
4594	7526	8960
4594	7526	5144
4594	7526	37
4594	7526	7983
4594	7526	1540
4594	7526	9329
6802	7527	7039
6802	7527	7009
6802	7527	7845
6802	7527	7881
6802	7527	1459
6802	7527	5168
6802	7527	5926
9771	7528	361
9771	7528	7097
9771	7528	8115
9771	7528	608
9771	7528	4014
6234	7529	5900
6234	7529	2965
6234	7529	6186
6234	7529	6615
6234	7529	9884
6234	7529	2144
6234	7529	6724
6234	7529	695
2109	7530	9397
2109	7530	3738
2109	7530	939
2109	7530	5257
2109	7530	868
13533	7531	511
13533	7531	3476
13533	7531	92
4469	7532	4737
4469	7532	6664
4469	7532	917
4469	7532	7845
4469	7532	5539
4469	7532	318
11148	7533	2829
18180	7534	1537
18180	7534	4601
18180	7534	7391
18180	7534	3862
18180	7534	9138
18180	7534	6421
18180	7534	1341
18370	7535	767
18370	7535	9860
18370	7535	3541
18370	7535	297
14525	7536	4738
14525	7536	632
14525	7536	8622
14525	7536	2846
14525	7536	4582
14525	7536	1082
4844	7537	1607
4844	7537	9009
4844	7537	3956
4844	7537	2471
4844	7537	6987
4844	7537	3865
18648	7538	6319
18648	7538	4106
18648	7538	8286
18648	7538	7424
18648	7538	8934
13434	7539	2344
13434	7539	8196
4303	7540	9647
4303	7540	142
4303	7540	239
4303	7540	2836
4303	7540	4938
4303	7540	134
4303	7540	4094
3034	7541	22
3034	7541	1645
3034	7541	7363
3034	7541	3479
3034	7541	5341
11121	7542	2768
11121	7542	868
11121	7542	6071
11121	7542	2877
11121	7542	2857
11121	7542	51
11121	7542	1431
5434	7543	7872
5434	7543	9435
5434	7543	6604
5434	7543	793
5434	7543	1298
5434	7543	7505
5434	7543	5858
5434	7543	2955
18051	7544	33
18051	7544	9167
18051	7544	236
18051	7544	6128
18051	7544	3314
18051	7544	7191
13251	7545	9540
13251	7545	8263
13251	7545	5715
13251	7545	7892
13251	7545	6040
13251	7545	8299
17454	7546	2013
17454	7546	9988
17454	7546	5238
17454	7546	951
17454	7546	3215
17454	7546	9738
17454	7546	4767
17454	7546	9249
17454	7546	3371
18170	7547	658
18170	7547	3879
18170	7547	8637
8221	7548	8751
8221	7548	1943
8221	7548	9756
8221	7548	2540
8221	7548	1034
8221	7548	5899
8221	7548	8434
8221	7548	105
8221	7548	2659
11875	7549	5256
11875	7549	502
16369	7550	7880
16369	7550	3201
16369	7550	741
16369	7550	2714
16369	7550	5926
16369	7550	5557
16369	7550	9547
16369	7550	6972
16369	7550	5795
13367	7551	8230
13367	7551	5331
13367	7551	4715
5432	7552	9469
5432	7552	4617
5432	7552	6952
5432	7552	3489
5432	7552	1078
1248	7553	275
1248	7553	1305
13744	7554	7695
13744	7554	2475
13744	7554	4911
13744	7554	5125
9185	7555	4802
9185	7555	6132
9185	7555	9531
9185	7555	7336
9185	7555	7834
9185	7555	5907
9185	7555	9203
9185	7555	3278
3244	7556	5297
3244	7556	4185
18618	7557	3902
18618	7557	3311
18618	7557	2268
18618	7557	6994
18618	7557	6652
8970	7558	2592
8970	7558	9148
6459	7559	5006
6459	7559	8011
6459	7559	2994
6459	7559	8500
6459	7559	2843
6459	7559	4520
6459	7559	1103
16192	7560	2425
16192	7560	6732
16192	7560	6552
11397	7561	8928
11397	7561	6724
11397	7561	5472
11397	7561	3124
11397	7561	3068
11397	7561	7372
11397	7561	4024
11397	7561	2064
11397	7561	8679
14526	7562	1878
14526	7562	2773
14526	7562	5961
14526	7562	4127
14526	7562	3447
14526	7562	3838
18619	7563	7775
10293	7564	7038
10293	7564	885
10293	7564	3603
10293	7564	2979
10293	7564	9754
10293	7564	146
12213	7565	7261
12213	7565	464
12213	7565	9943
12213	7565	408
12213	7565	7564
12213	7565	2816
12213	7565	3328
731	7566	6081
731	7566	48
731	7566	9752
731	7566	3914
731	7566	2327
731	7566	6004
6528	7567	4362
6528	7567	2523
6528	7567	3214
6528	7567	2951
6528	7567	9384
8879	7568	380
8879	7568	1610
8879	7568	1784
8879	7568	228
8879	7568	1259
14525	7569	526
14525	7569	2573
14525	7569	8001
14525	7569	9657
14525	7569	5180
14525	7569	7245
14525	7569	8886
11059	7570	8254
11059	7570	9809
11059	7570	8308
11059	7570	5735
11059	7570	2591
11059	7570	6829
11059	7570	6132
11059	7570	3431
11059	7570	2242
3795	7571	4505
3795	7571	3542
3795	7571	9861
3795	7571	8919
3795	7571	1926
3795	7571	2144
3795	7571	7210
3795	7571	1771
3795	7571	18
13692	7572	4200
13692	7572	6409
13692	7572	3020
13692	7572	8339
13692	7572	9186
13692	7572	5556
13692	7572	6232
10301	7573	2323
10301	7573	8931
10301	7573	3208
10301	7573	2477
10301	7573	5063
10301	7573	71
10301	7573	1757
16332	7574	8373
16332	7574	3496
16332	7574	1892
16332	7574	285
16332	7574	4467
16332	7574	3273
16332	7574	2750
16332	7574	7835
2085	7575	4267
2085	7575	1656
2085	7575	666
2085	7575	8607
2085	7575	1579
2085	7575	3307
2085	7575	8367
516	7576	8381
516	7576	3347
516	7576	5399
516	7576	7249
516	7576	7777
516	7576	4276
516	7576	9982
516	7576	7603
16537	7577	3744
16537	7577	805
18341	7578	9429
18341	7578	1879
18341	7578	25
18341	7578	9462
13422	7579	9088
13422	7579	9256
13422	7579	1477
13422	7579	706
13422	7579	5127
13422	7579	5843
13422	7579	2383
13422	7579	5921
13422	7579	5818
10491	7580	3054
10491	7580	151
10491	7580	4927
10491	7580	9227
10491	7580	569
19650	7581	6683
19650	7581	2350
19650	7581	3844
19650	7581	680
19650	7581	4839
19650	7581	5187
19650	7581	6373
19650	7581	5902
17910	7582	1471
17910	7582	4782
17910	7582	3864
762	7583	8374
762	7583	4482
762	7583	3668
762	7583	8915
762	7583	4551
762	7583	947
14639	7584	3170
17046	7585	8803
5332	7586	3047
2841	7587	2144
2841	7587	9646
8394	7588	3935
3812	7589	3037
14956	7590	6701
14956	7590	1049
14956	7590	1412
14956	7590	1023
14956	7590	5516
14956	7590	9572
14956	7590	7905
14956	7590	8717
7057	7591	2750
7057	7591	9255
7057	7591	7040
7057	7591	1077
7057	7591	9769
7057	7591	5004
7057	7591	1576
5974	7592	1238
5974	7592	1397
5974	7592	3321
5974	7592	28
5974	7592	6827
5974	7592	5566
5974	7592	791
5974	7592	904
15887	7593	4564
15887	7593	2281
7713	7594	6844
7713	7594	5085
7713	7594	1428
7713	7594	8891
7713	7594	5783
7713	7594	6787
4705	7595	668
4705	7595	3194
4705	7595	6378
1882	7596	508
1882	7596	9072
1882	7596	2527
1882	7596	1891
1882	7596	3996
5772	7597	1804
5772	7597	2485
5772	7597	7206
5772	7597	7312
5772	7597	8450
5772	7597	9136
5772	7597	6036
5772	7597	5768
5772	7597	7285
12713	7598	2272
12713	7598	18
12713	7598	7610
11353	7599	530
15471	7600	5609
15471	7600	2936
15471	7600	9762
11059	7601	1804
11059	7601	455
11059	7601	4926
11059	7601	8495
12208	7602	1780
12208	7602	9102
12208	7602	9508
12208	7602	45
12208	7602	6651
12208	7602	929
12208	7602	396
12208	7602	8558
2398	7603	3719
2398	7603	2228
2398	7603	4489
2398	7603	3587
2398	7603	6827
2398	7603	1627
2398	7603	5676
2398	7603	916
1920	7604	6613
1920	7604	1185
19485	7605	941
19485	7605	7039
19485	7605	7288
19485	7605	3304
19485	7605	9988
19485	7605	5257
19485	7605	9528
19485	7605	5420
19485	7605	7611
5117	7606	4157
5117	7606	3670
12931	7607	5480
12931	7607	659
12931	7607	684
12931	7607	1785
12931	7607	9722
9957	7608	1862
18944	7609	2030
18944	7609	7558
18944	7609	1544
18944	7609	1528
18944	7609	7693
18944	7609	7593
16502	7610	6197
16502	7610	7303
16502	7610	9247
15666	7611	1839
15666	7611	2230
15666	7611	181
15477	7612	8966
15477	7612	3819
2823	7613	9663
2823	7613	4533
3671	7614	14
3671	7614	75
3671	7614	5433
15326	7615	1922
15326	7615	701
15326	7615	5268
18174	7616	499
18174	7616	4139
18174	7616	1675
9341	7617	6913
9341	7617	473
9341	7617	9115
9341	7617	8900
9341	7617	3569
9341	7617	4858
9341	7617	6901
9341	7617	7858
4396	7618	5121
4396	7618	7704
18757	7619	4049
18757	7619	5732
18757	7619	8957
18757	7619	7948
18757	7619	2110
18757	7619	9967
18757	7619	9840
18757	7619	1169
18052	7620	1224
18052	7620	7157
18052	7620	1918
18052	7620	5603
18052	7620	4238
18052	7620	1766
14994	7621	3701
11622	7622	1489
11622	7622	3788
11622	7622	622
11622	7622	1684
11622	7622	9779
11622	7622	9695
11622	7622	9251
11622	7622	1795
11622	7622	5444
14417	7623	4706
16812	7624	4217
11412	7625	8364
11412	7625	7199
11412	7625	8834
17056	7626	140
17056	7626	7058
10889	7627	5800
10889	7627	9624
10889	7627	5903
10889	7627	7359
10889	7627	5185
10889	7627	5825
8376	7628	4235
8376	7628	3801
8376	7628	531
8376	7628	9393
8376	7628	3419
8376	7628	6254
8376	7628	1895
15388	7629	4775
4266	7630	8732
4266	7630	273
4266	7630	2576
4266	7630	5181
4266	7630	5445
4266	7630	3998
6780	7631	9841
3469	7632	9429
3469	7632	7326
3469	7632	928
3469	7632	6336
3469	7632	4955
3469	7632	1879
8909	7633	1265
8909	7633	7587
8909	7633	89
8909	7633	8653
8909	7633	4392
8909	7633	9631
8909	7633	227
8909	7633	6148
6945	7634	2021
13950	7635	2203
13950	7635	807
13950	7635	7289
13950	7635	4986
13950	7635	7334
13950	7635	9155
7092	7636	3208
7092	7636	3008
6128	7637	4047
6128	7637	8411
6128	7637	1822
6128	7637	4873
6128	7637	2355
6128	7637	4896
6128	7637	7751
6128	7637	4519
7345	7638	7219
7345	7638	8195
7345	7638	252
7345	7638	9780
7345	7638	4267
7345	7638	2828
7345	7638	7453
18547	7639	3297
18547	7639	7386
10271	7640	219
10271	7640	5099
4633	7641	2742
4633	7641	9183
4633	7641	1696
4633	7641	5127
4633	7641	1763
4633	7641	5763
4633	7641	1853
4633	7641	303
15376	7642	2824
15376	7642	6271
15376	7642	4440
15376	7642	4330
15376	7642	3686
12855	7643	8949
12855	7643	4837
13198	7644	5196
10996	7645	3186
10996	7645	3684
10996	7645	8409
10996	7645	9051
10996	7645	1324
10996	7645	7072
10996	7645	4545
10996	7645	1436
768	7646	4459
768	7646	2099
768	7646	7438
768	7646	9618
768	7646	2791
11953	7647	1986
2073	7648	4417
2073	7648	7148
17168	7649	8968
17168	7649	4034
17168	7649	1700
17168	7649	4538
17168	7649	3426
17168	7649	7477
17168	7649	7427
17168	7649	2193
8356	7650	5215
8356	7650	8474
8356	7650	6489
8356	7650	8593
8356	7650	4205
8356	7650	2895
13858	7651	3061
13858	7651	5676
13858	7651	5291
13858	7651	2702
13858	7651	7808
13858	7651	411
13561	7652	4674
13561	7652	3917
13561	7652	3754
13561	7652	5523
16834	7653	5346
16834	7653	4233
16834	7653	8863
16834	7653	4892
16834	7653	3060
16834	7653	6871
16834	7653	2487
3117	7654	5844
3117	7654	1985
3117	7654	9898
3117	7654	2270
10250	7655	2819
10250	7655	2554
10250	7655	7588
10250	7655	6959
10250	7655	5570
4881	7656	9722
4881	7656	4117
4881	7656	8931
1831	7657	6654
1831	7657	7835
1831	7657	7116
19869	7658	6986
19869	7658	9146
19869	7658	920
19869	7658	3964
19869	7658	7156
19869	7658	3551
19869	7658	9928
17716	7659	9773
17716	7659	5593
17716	7659	9339
12908	7660	6389
12908	7660	9682
17655	7661	3543
17655	7661	6304
17655	7661	6131
17655	7661	7576
17655	7661	7521
10296	7662	2497
10296	7662	1115
10296	7662	434
10296	7662	8289
10296	7662	9843
19049	7663	8352
19049	7663	1187
19049	7663	6652
19049	7663	2594
19049	7663	7344
19049	7663	8839
7508	7664	8442
7508	7664	6823
7508	7664	4344
7508	7664	7447
7508	7664	2788
7508	7664	7309
7508	7664	6814
7508	7664	146
7508	7664	730
14761	7665	162
14761	7665	9822
14761	7665	1030
14761	7665	2755
14761	7665	8043
14761	7665	3551
14761	7665	753
14761	7665	2121
14761	7665	526
15669	7666	3195
15669	7666	7469
15669	7666	655
18952	7667	5641
18952	7667	467
6442	7668	4417
10338	7669	3368
10338	7669	2165
10338	7669	7516
10338	7669	1159
10338	7669	666
10338	7669	4634
10338	7669	3155
14673	7670	1340
14673	7670	3108
14673	7670	1091
14673	7670	3840
14673	7670	2084
14673	7670	676
8087	7671	2900
8087	7671	9739
8087	7671	9148
8087	7671	2685
8087	7671	1726
8087	7671	9719
8087	7671	3176
8087	7671	8960
4135	7672	2888
4135	7672	1590
4135	7672	898
4135	7672	6210
4135	7672	6310
4135	7672	5525
10528	7673	5669
10528	7673	8496
10528	7673	1790
10528	7673	9916
10528	7673	5336
656	7674	6411
656	7674	9484
656	7674	8799
656	7674	266
656	7674	7510
656	7674	2140
656	7674	5784
18100	7675	5001
18100	7675	1361
18100	7675	9131
18100	7675	1756
2469	7676	8797
16560	7677	8661
16560	7677	8727
16560	7677	6045
16560	7677	9206
15008	7678	1471
5662	7679	4107
8511	7680	5347
531	7681	3984
5419	7682	3575
5419	7682	8050
5419	7682	4275
5419	7682	3141
5419	7682	4807
5419	7682	8577
5365	7683	6938
5365	7683	1897
6800	7684	4107
6800	7684	6141
6800	7684	9242
6800	7684	505
6800	7684	477
9504	7685	498
9504	7685	3154
9504	7685	9764
9504	7685	1756
9504	7685	841
9504	7685	9221
9504	7685	978
9504	7685	6137
487	7686	4527
487	7686	5825
12603	7687	1053
12603	7687	5184
12603	7687	3357
12603	7687	624
12603	7687	7581
12603	7687	4784
12603	7687	1073
4101	7688	5578
4101	7688	7537
4101	7688	3334
4101	7688	4937
4101	7688	7096
4101	7688	5459
4101	7688	4134
18633	7689	7653
18633	7689	8228
18633	7689	1063
18633	7689	3655
18633	7689	7016
4505	7690	3467
4505	7690	5400
4505	7690	1706
4505	7690	5958
4505	7690	7390
4505	7690	9483
4505	7690	7928
4505	7690	840
4505	7690	6339
9132	7691	7578
9132	7691	7871
9132	7691	2192
9132	7691	6846
9132	7691	1820
9132	7691	3939
11290	7692	4446
11290	7692	4486
11290	7692	6468
14613	7693	5799
14613	7693	6065
7283	7694	8235
7283	7694	8734
7283	7694	3392
7283	7694	5392
7283	7694	7772
7283	7694	2976
7283	7694	5573
117	7695	2471
117	7695	4044
117	7695	8007
117	7695	3943
117	7695	9366
117	7695	7712
117	7695	9427
16321	7696	8713
16321	7696	6085
16321	7696	8920
16321	7696	1811
16321	7696	6481
16321	7696	4552
16321	7696	8818
16321	7696	4338
4689	7697	6416
4689	7697	4586
8025	7698	2173
8025	7698	2456
8025	7698	7515
8025	7698	7369
18359	7699	1260
18359	7699	1910
18359	7699	2501
18359	7699	2939
11285	7700	7711
11285	7700	9134
11285	7700	827
11285	7700	9750
11285	7700	305
15639	7701	4255
15639	7701	432
3383	7702	1769
3383	7702	580
3383	7702	3554
3383	7702	350
16121	7703	4109
16121	7703	2517
16121	7703	6422
611	7704	1558
611	7704	5150
611	7704	77
611	7704	3681
611	7704	1907
611	7704	3898
611	7704	157
1011	7705	8566
1011	7705	9146
1011	7705	9254
1011	7705	6532
1011	7705	4484
1011	7705	5981
15077	7706	9528
15077	7706	2123
15077	7706	834
15077	7706	8658
15077	7706	6516
16347	7707	4009
16347	7707	1249
16347	7707	558
16347	7707	4816
16347	7707	6178
4317	7708	9697
4317	7708	3630
4317	7708	4541
4317	7708	2434
4317	7708	9782
4317	7708	105
4317	7708	9904
4317	7708	4471
4317	7708	7705
17907	7709	9456
17907	7709	4753
17907	7709	5748
17907	7709	7792
17907	7709	3516
17907	7709	4616
17907	7709	6714
18294	7710	237
18294	7710	8975
18294	7710	6922
9253	7711	3580
9253	7711	4131
9253	7711	4
9253	7711	8669
9253	7711	3318
9253	7711	5924
1080	7712	9696
8450	7713	8859
11561	7714	407
11561	7714	6015
11561	7714	7451
11561	7714	7022
11561	7714	9028
11561	7714	3206
11561	7714	2151
11561	7714	9177
11561	7714	9670
18731	7715	3590
18731	7715	6618
18731	7715	8107
18731	7715	8229
18731	7715	6351
18731	7715	3973
2846	7716	8878
2846	7716	5335
2846	7716	3882
2846	7716	1214
2846	7716	3585
2846	7716	6213
2846	7716	248
2846	7716	6920
2846	7716	5821
7853	7717	4005
7853	7717	3151
7853	7717	9056
7853	7717	9400
7853	7717	5417
1502	7718	8236
1502	7718	43
1502	7718	2456
1502	7718	2169
1502	7718	2496
1502	7718	6541
1502	7718	2625
5931	7719	9657
5931	7719	4223
5931	7719	6265
5931	7719	278
5931	7719	1899
5931	7719	2433
1337	7720	2489
9315	7721	3745
9315	7721	7474
9315	7721	8357
9315	7721	9335
9315	7721	5963
9315	7721	6191
9315	7721	7703
9315	7721	3807
9315	7721	4137
13139	7722	7238
13139	7722	2133
17591	7723	7954
17591	7723	2604
17591	7723	4497
17591	7723	5144
17591	7723	6659
17591	7723	2822
17591	7723	1290
10193	7724	802
10193	7724	6011
10193	7724	1591
10193	7724	563
10193	7724	2974
10193	7724	2519
10193	7724	5719
10193	7724	5485
10193	7724	5899
2084	7725	2148
2084	7725	8792
2084	7725	7160
2084	7725	8534
2084	7725	3537
2084	7725	5530
14239	7726	843
14239	7726	7310
14239	7726	3126
14239	7726	3832
14239	7726	1351
14239	7726	8592
14239	7726	773
14239	7726	6576
10734	7727	9463
10734	7727	1863
10734	7727	4226
10734	7727	2546
10734	7727	4511
10734	7727	991
16599	7728	1328
16599	7728	2845
16599	7728	2276
16599	7728	3312
19775	7729	5255
19775	7729	9078
19775	7729	7215
2880	7730	3767
9515	7731	3057
9515	7731	946
9515	7731	9454
9515	7731	7062
9515	7731	5226
9515	7731	4777
9515	7731	261
11030	7732	232
15894	7733	8209
7621	7734	522
7621	7734	8240
15386	7735	9422
15386	7735	5125
15386	7735	9548
15386	7735	4944
15386	7735	900
2262	7736	9078
2262	7736	4773
2262	7736	5511
2262	7736	1096
2262	7736	9240
14959	7737	5172
14959	7737	1503
14959	7737	8822
14959	7737	8793
14959	7737	2012
14959	7737	9862
14959	7737	1749
90	7738	65
90	7738	406
90	7738	9535
17549	7739	6254
2851	7740	6020
2851	7740	5279
2851	7740	1733
2851	7740	8547
2851	7740	201
2851	7740	3972
2851	7740	340
2851	7740	7362
15534	7741	9269
15534	7741	762
14030	7742	8441
14030	7742	3512
14030	7742	6494
14030	7742	9271
14030	7742	6080
12559	7743	522
12559	7743	4618
12559	7743	8858
12559	7743	5650
9836	7744	7304
9836	7744	6833
9836	7744	4723
9836	7744	9022
9836	7744	9733
9836	7744	7024
9836	7744	3742
9836	7744	6821
9836	7744	9383
19808	7745	7787
19808	7745	9041
16194	7746	7915
16194	7746	9093
16194	7746	1551
16194	7746	20
16194	7746	2050
16194	7746	6087
16194	7746	8755
16194	7746	2177
16194	7746	3390
1486	7747	2714
1486	7747	6136
1486	7747	2686
1486	7747	9851
15530	7748	2512
15530	7748	5355
14809	7749	6478
14809	7749	4735
14809	7749	6613
14809	7749	214
14809	7749	8867
3161	7750	3335
3161	7750	366
3161	7750	4652
3161	7750	950
3161	7750	4351
3161	7750	9600
3161	7750	5992
16551	7751	9313
16551	7751	2242
16551	7751	6186
16551	7751	3047
8121	7752	1210
8121	7752	8668
8121	7752	3151
8121	7752	4387
8121	7752	4670
8538	7753	2689
8538	7753	1828
8538	7753	9141
8538	7753	4077
524	7754	5314
3893	7755	1913
3893	7755	6958
3893	7755	5010
3893	7755	9164
3893	7755	83
17052	7756	4079
17052	7756	2652
17052	7756	3246
17052	7756	4600
17052	7756	6990
17052	7756	425
9193	7757	9979
9193	7757	1116
9193	7757	1226
9193	7757	8280
9193	7757	5805
9193	7757	7115
9193	7757	6888
9193	7757	6389
9193	7757	9497
5485	7758	3055
5485	7758	7221
5485	7758	5062
5485	7758	8075
5485	7758	3048
5485	7758	5474
5485	7758	4989
5485	7758	288
12184	7759	5844
12184	7759	1595
12184	7759	9485
12184	7759	1274
14083	7760	9800
14083	7760	367
14083	7760	3296
14083	7760	4173
14083	7760	6495
14083	7760	506
14083	7760	6347
6872	7761	7640
6872	7761	4901
6872	7761	4962
6872	7761	326
6872	7761	8055
6872	7761	3277
6151	7762	7937
6151	7762	9857
12703	7763	7835
5172	7764	8969
5172	7764	733
5172	7764	8412
5172	7764	8255
5172	7764	1929
5172	7764	2897
5172	7764	6818
5172	7764	8281
12434	7765	8326
12434	7765	1568
12434	7765	622
12434	7765	8183
12434	7765	1988
1912	7766	4826
6161	7767	9390
6161	7767	3306
6161	7767	2886
6161	7767	3206
6161	7767	7803
6161	7767	3462
6161	7767	3977
6161	7767	6210
8784	7768	4112
8784	7768	7374
8784	7768	6562
8784	7768	317
8784	7768	5279
8784	7768	834
8280	7769	5726
8280	7769	6433
8280	7769	7763
8280	7769	9657
8280	7769	4923
8280	7769	6338
8280	7769	259
8280	7769	5770
6285	7770	5341
6285	7770	8056
6285	7770	4057
6285	7770	5288
6285	7770	3030
17511	7771	2284
17511	7771	3874
17511	7771	9746
17511	7771	7807
16130	7772	2436
16130	7772	7060
16130	7772	2845
16130	7772	7510
3134	7773	926
3134	7773	4471
3134	7773	1576
3134	7773	2453
3134	7773	2722
3134	7773	5800
3134	7773	5122
3134	7773	8552
14624	7774	4834
14624	7774	3921
14624	7774	6646
14624	7774	8580
16741	7775	1191
16741	7775	2396
16741	7775	7157
16741	7775	6625
4849	7776	6031
4849	7776	9566
4849	7776	8209
4849	7776	1809
4849	7776	998
4849	7776	722
18602	7777	7672
17723	7778	1628
17723	7778	1324
17723	7778	4756
17723	7778	677
17723	7778	8795
17723	7778	7999
12415	7779	9251
12415	7779	1947
12415	7779	3753
12415	7779	9273
12415	7779	9263
12415	7779	6338
8117	7780	8936
8117	7780	5684
8117	7780	3639
8117	7780	794
8117	7780	3067
8117	7780	793
8117	7780	5000
8500	7781	4222
8500	7781	4745
8500	7781	6826
8500	7781	437
8500	7781	7350
8500	7781	7222
12316	7782	9850
12316	7782	5718
12316	7782	4377
12316	7782	9436
12316	7782	6260
12316	7782	1074
12316	7782	8685
12316	7782	5592
12316	7782	8855
11360	7783	8844
11360	7783	3079
11360	7783	8859
11360	7783	2223
11360	7783	6110
11360	7783	9110
11360	7783	2716
4302	7784	6586
4302	7784	6823
4302	7784	2816
4302	7784	8177
4302	7784	2750
4302	7784	7350
4302	7784	1414
8984	7785	1245
8984	7785	4810
8984	7785	6553
8984	7785	9181
8984	7785	7405
8984	7785	1419
8984	7785	6662
6967	7786	5898
6967	7786	275
6967	7786	6029
6967	7786	5741
6967	7786	3817
6967	7786	1934
6967	7786	2171
6967	7786	556
14216	7787	6376
14216	7787	9503
14216	7787	4363
14216	7787	5798
14216	7787	9647
14216	7787	8756
14216	7787	525
14216	7787	4192
14216	7787	6654
941	7788	6545
941	7788	9108
941	7788	3608
941	7788	4208
941	7788	9351
941	7788	2809
14343	7789	7323
14343	7789	3248
14343	7789	207
14343	7789	5108
3522	7790	2231
3522	7790	250
3522	7790	5415
3522	7790	5876
167	7791	667
167	7791	7199
167	7791	3506
167	7791	3218
167	7791	6878
167	7791	6907
167	7791	237
167	7791	1483
11624	7792	4599
11624	7792	4781
11624	7792	4490
11624	7792	9034
11624	7792	740
11624	7792	1831
18059	7793	1244
18059	7793	3230
18059	7793	130
733	7794	929
733	7794	2499
733	7794	1928
733	7794	944
733	7794	7110
733	7794	7366
733	7794	8918
1497	7795	9778
1497	7795	10000
1497	7795	3626
1497	7795	9143
1497	7795	3364
1497	7795	4122
1497	7795	1035
7068	7796	631
7068	7796	73
7068	7796	7237
7068	7796	3884
5175	7797	186
5175	7797	5014
5175	7797	7702
5175	7797	3414
5175	7797	2394
13031	7798	1566
13031	7798	5760
13031	7798	7089
14323	7799	4599
14323	7799	7621
9047	7800	1204
17810	7801	5749
17810	7801	1164
17810	7801	7757
17810	7801	9166
9850	7802	1315
9850	7802	1430
9850	7802	7444
9850	7802	3461
8125	7803	4851
8125	7803	1573
839	7804	1661
839	7804	2383
839	7804	4827
839	7804	8738
839	7804	6473
15575	7805	3234
15575	7805	3734
15575	7805	8971
15575	7805	756
15575	7805	1267
15575	7805	9349
15575	7805	1429
3276	7806	3011
3276	7806	4335
3276	7806	8418
3276	7806	9845
3276	7806	3558
41	7807	3927
41	7807	2604
41	7807	7461
41	7807	1455
41	7807	8966
41	7807	1566
9648	7808	9743
9648	7808	1204
9648	7808	2880
9648	7808	7150
1416	7809	729
1416	7809	3098
1416	7809	226
1416	7809	7552
1416	7809	9061
1416	7809	6413
1416	7809	9811
19315	7810	3992
10390	7811	4816
10390	7811	1099
10390	7811	4479
10390	7811	6515
10390	7811	2611
10390	7811	9862
10390	7811	5313
10390	7811	523
13871	7812	4914
13871	7812	5888
13871	7812	1273
13871	7812	260
13871	7812	5074
13871	7812	5143
12483	7813	6184
12483	7813	339
12483	7813	5343
12483	7813	1631
12483	7813	7614
8067	7814	265
8067	7814	8250
8067	7814	1717
8067	7814	6032
8067	7814	6291
8067	7814	8859
8067	7814	995
422	7815	5942
422	7815	2652
422	7815	5180
422	7815	1939
13935	7816	4397
13935	7816	9524
13935	7816	3243
13935	7816	2168
13935	7816	3218
4152	7817	1587
4152	7817	1584
15051	7818	8809
15051	7818	8356
15051	7818	9182
15051	7818	7715
4222	7819	4757
4222	7819	1078
4222	7819	5614
4222	7819	5382
4222	7819	6371
4222	7819	7365
4222	7819	2837
4222	7819	4187
4222	7819	6474
10565	7820	6030
10565	7820	1478
10565	7820	6974
10565	7820	5855
10565	7820	1627
10565	7820	6413
10565	7820	7535
5832	7821	8188
5832	7821	1328
5832	7821	4332
5832	7821	5283
7229	7822	302
7229	7822	3659
7229	7822	5862
3432	7823	2327
3432	7823	7900
3432	7823	9142
3432	7823	2777
3432	7823	8269
19191	7824	5110
19191	7824	7680
19191	7824	886
19191	7824	8712
19191	7824	5886
19191	7824	2966
19191	7824	3002
7410	7825	821
7410	7825	5650
7410	7825	4528
7410	7825	7121
7410	7825	9392
7410	7825	2391
15001	7826	3519
15001	7826	7985
15001	7826	725
15001	7826	4600
15202	7827	1306
15202	7827	4868
15202	7827	1583
15202	7827	2088
15202	7827	8944
15202	7827	8906
15202	7827	8872
15202	7827	9716
15202	7827	8797
4630	7828	4545
4630	7828	1480
4630	7828	2321
4630	7828	6745
4630	7828	6174
4630	7828	4499
4630	7828	176
4525	7829	1471
684	7830	5751
684	7830	6920
684	7830	3505
684	7830	2987
684	7830	3456
684	7830	7193
684	7830	1562
684	7830	8320
5638	7831	8901
5638	7831	4425
11789	7832	6237
11789	7832	8227
11789	7832	5773
11789	7832	7364
11789	7832	9972
11789	7832	7327
11789	7832	4816
11789	7832	9202
11789	7832	8457
887	7833	2605
887	7833	3225
887	7833	333
5043	7834	7104
5043	7834	1147
5043	7834	7107
5043	7834	2154
5043	7834	8860
5043	7834	505
5043	7834	4001
5043	7834	52
5043	7834	7229
15139	7835	6810
15139	7835	2534
15139	7835	4339
15139	7835	9663
15139	7835	4618
11528	7836	4274
11528	7836	4219
11528	7836	1277
11528	7836	6808
11528	7836	4431
11528	7836	7734
11528	7836	1024
16155	7837	8355
16155	7837	3180
16155	7837	4130
16155	7837	766
16155	7837	9609
16155	7837	4511
17568	7838	1917
17568	7838	6882
2623	7839	2971
2623	7839	5966
2623	7839	4686
2623	7839	8236
2623	7839	777
9812	7840	3653
9812	7840	7298
9812	7840	3116
9812	7840	6947
9812	7840	7395
9812	7840	6485
8169	7841	9418
8169	7841	9782
8169	7841	756
17982	7842	406
17982	7842	3170
17982	7842	9740
17982	7842	8527
17982	7842	4985
17982	7842	2274
17982	7842	5804
17982	7842	795
16766	7843	1556
16766	7843	8091
16766	7843	1174
16766	7843	5804
16766	7843	7837
16766	7843	6924
16766	7843	6552
16766	7843	2904
16766	7843	6915
3798	7844	3830
3798	7844	5270
3798	7844	1166
3798	7844	3007
3798	7844	8748
3798	7844	3329
9005	7845	3163
9005	7845	5013
3128	7846	7854
3128	7846	6096
3128	7846	8993
3128	7846	6782
3128	7846	8045
18419	7847	6748
154	7848	4579
15483	7849	7828
15483	7849	9190
15483	7849	2480
15483	7849	5101
15483	7849	8224
15483	7849	7743
15483	7849	6915
8721	7850	4813
8721	7850	8333
8721	7850	1821
8721	7850	738
8721	7850	7716
8721	7850	4141
8721	7850	976
8721	7850	1582
8121	7851	2636
8121	7851	9169
8121	7851	436
8121	7851	6166
8121	7851	444
10512	7852	5082
10512	7852	9328
10512	7852	1125
10512	7852	9169
289	7853	309
289	7853	6452
289	7853	2285
2907	7854	7537
2907	7854	874
2907	7854	6792
2907	7854	3237
16636	7855	4137
6611	7856	3450
6611	7856	402
6611	7856	5255
6611	7856	1275
6611	7856	5941
6611	7856	8993
6611	7856	7604
6611	7856	1036
15654	7857	7524
15654	7857	6064
15654	7857	6153
15654	7857	7493
15654	7857	3505
15654	7857	1364
15654	7857	6352
3212	7858	9145
3212	7858	6207
7621	7859	2288
14903	7860	3446
14903	7860	8296
14903	7860	3183
14903	7860	2951
14903	7860	4094
14903	7860	3641
8705	7861	6338
8705	7861	9258
8705	7861	9332
8705	7861	6356
8705	7861	223
18098	7862	5399
7390	7863	9484
7390	7863	2943
7390	7863	6402
7390	7863	4021
7390	7863	936
7390	7863	7180
12875	7864	5660
12875	7864	596
12875	7864	4817
12875	7864	4931
12875	7864	3859
12875	7864	450
19173	7865	1674
19173	7865	7084
19173	7865	2715
19173	7865	556
15471	7866	4173
15471	7866	1040
15471	7866	6916
15471	7866	5714
1288	7867	973
1288	7867	6193
1288	7867	2679
1288	7867	8504
1288	7867	5513
1288	7867	2427
1288	7867	6692
1288	7867	1878
1288	7867	718
9781	7868	4722
9781	7868	985
9781	7868	2190
9781	7868	1079
9781	7868	5648
9781	7868	7925
9781	7868	7049
9781	7868	1222
9781	7868	4955
14764	7869	364
14764	7869	1699
14764	7869	9639
14764	7869	5972
14764	7869	9357
14764	7869	3640
14764	7869	1129
14764	7869	6728
4750	7870	4215
4750	7870	9188
4750	7870	6860
4750	7870	2170
4750	7870	1524
4750	7870	5830
4750	7870	3969
4750	7870	2970
17882	7871	9635
17882	7871	7234
17882	7871	6256
17882	7871	2971
17882	7871	6337
17882	7871	5501
17882	7871	8537
10793	7872	3395
10793	7872	5287
10793	7872	2241
10793	7872	6753
10793	7872	2862
10793	7872	4151
10793	7872	1182
10793	7872	77
12666	7873	3249
12666	7873	4749
12666	7873	9265
12666	7873	3437
12666	7873	8682
12666	7873	3408
12666	7873	2620
9721	7874	71
9721	7874	2343
9721	7874	460
9721	7874	8007
9721	7874	1940
9721	7874	6869
9721	7874	73
9721	7874	3031
4592	7875	7548
4592	7875	4570
4592	7875	8864
328	7876	8218
328	7876	8408
328	7876	6342
328	7876	4085
328	7876	9404
328	7876	6902
328	7876	342
6746	7877	5669
6746	7877	7559
6746	7877	6688
6746	7877	4172
6746	7877	9318
2735	7878	3488
2735	7878	4493
2735	7878	8695
2735	7878	4176
2156	7879	8052
2156	7879	8318
2156	7879	6015
2156	7879	9748
2156	7879	7202
2747	7880	5195
2747	7880	6387
2747	7880	1633
2747	7880	6441
2747	7880	9702
7756	7881	4956
7756	7881	4249
7756	7881	8362
7756	7881	2855
7756	7881	6552
7756	7881	7950
7756	7881	9038
7756	7881	5127
7756	7881	8671
10114	7882	4931
9265	7883	8510
9265	7883	487
9471	7884	7301
9471	7884	2084
9471	7884	1929
9471	7884	7606
9471	7884	3685
9471	7884	1989
9471	7884	3052
19971	7885	3361
19971	7885	6974
19971	7885	8728
18428	7886	3949
18428	7886	667
18428	7886	4749
13356	7887	7644
13356	7887	5439
13356	7887	8823
12467	7888	8575
12467	7888	8955
15365	7889	6897
15365	7889	280
15365	7889	5403
15365	7889	2096
15365	7889	3698
15365	7889	6829
15365	7889	9906
10689	7890	3835
10689	7890	8005
13159	7891	2128
13159	7891	2495
13159	7891	5174
13159	7891	3140
13159	7891	236
4662	7892	9529
18867	7893	4778
18867	7893	1296
18867	7893	8545
18867	7893	923
18867	7893	5880
18867	7893	9213
18867	7893	2923
18867	7893	1166
18867	7893	1098
2666	7894	3664
2666	7894	43
2666	7894	7062
2666	7894	2626
2666	7894	6145
2666	7894	1151
2666	7894	6015
2666	7894	6741
2666	7894	4096
6617	7895	5015
6617	7895	3024
6617	7895	6099
6617	7895	7445
6617	7895	6518
13121	7896	3180
13121	7896	4602
13121	7896	4329
13121	7896	6765
13121	7896	5447
13121	7896	7280
13121	7896	6125
13504	7897	8545
13504	7897	3978
13504	7897	3808
13504	7897	3589
13504	7897	2531
13504	7897	6886
13504	7897	1623
13504	7897	3757
16170	7898	8428
16170	7898	9659
16170	7898	6966
16170	7898	4993
16170	7898	2536
16170	7898	7681
3315	7899	3080
11221	7900	2442
11221	7900	7526
11221	7900	1234
11221	7900	4283
11221	7900	3069
11221	7900	634
11221	7900	8418
6821	7901	2617
18118	7902	9310
18118	7902	7159
18118	7902	5441
18118	7902	7346
18118	7902	5555
18118	7902	4081
18118	7902	1787
18118	7902	9999
1264	7903	8230
1264	7903	2902
1264	7903	7137
1264	7903	737
1264	7903	4577
1264	7903	7109
1264	7903	7318
1264	7903	3770
1264	7903	4813
734	7904	7155
734	7904	3086
734	7904	2628
734	7904	7785
734	7904	3651
13104	7905	2070
13104	7905	2698
13104	7905	9882
13104	7905	532
8603	7906	5417
8603	7906	9253
8603	7906	5321
8603	7906	9177
8603	7906	3561
8603	7906	2565
8603	7906	2012
8603	7906	7360
18034	7907	1411
18034	7907	1483
18034	7907	4253
18034	7907	8491
18034	7907	6316
3464	7908	3136
3464	7908	2872
3464	7908	2774
3464	7908	4115
3464	7908	7778
3464	7908	1553
8640	7909	9157
8640	7909	631
8640	7909	6855
8640	7909	2653
8640	7909	3209
8640	7909	3794
5682	7910	7209
5682	7910	6146
5682	7910	6190
5682	7910	5320
13746	7911	1193
698	7912	988
698	7912	2521
698	7912	1019
698	7912	2607
698	7912	6150
698	7912	7654
698	7912	7140
6569	7913	3545
6569	7913	2948
6569	7913	7037
6569	7913	753
6569	7913	5306
6569	7913	8578
6569	7913	5399
6569	7913	9798
6569	7913	3205
11621	7914	9116
11621	7914	2833
11621	7914	8144
11621	7914	9540
11621	7914	4607
11621	7914	3152
11621	7914	3014
11621	7914	9603
11621	7914	8417
13990	7915	6560
13990	7915	4844
13990	7915	9647
13990	7915	5574
13990	7915	8289
13990	7915	8558
13990	7915	945
968	7916	3568
968	7916	8907
17019	7917	3418
17019	7917	8440
9999	7918	4763
9999	7918	2132
9999	7918	6203
9999	7918	5026
11941	7919	6455
11941	7919	9642
11941	7919	3992
11941	7919	6603
11941	7919	7057
11941	7919	8466
11941	7919	8822
11941	7919	2924
8406	7920	5130
8406	7920	7004
8406	7920	3811
8406	7920	6092
8406	7920	8000
8406	7920	3641
8406	7920	8705
5392	7921	9716
16363	7922	5087
16363	7922	4466
16363	7922	6486
16363	7922	3658
16363	7922	9116
16363	7922	2947
16363	7922	2690
1378	7923	5142
1378	7923	5202
14063	7924	5918
14063	7924	5888
14063	7924	5566
14063	7924	7560
14063	7924	7965
14063	7924	5756
14063	7924	5660
17213	7925	7644
17213	7925	5661
17213	7925	7996
17213	7925	9529
17213	7925	419
2225	7926	9831
2225	7926	1424
2225	7926	2088
2225	7926	5427
2225	7926	3028
2225	7926	1674
7914	7927	8929
7914	7927	9927
7914	7927	9172
7914	7927	5393
11623	7928	6924
11623	7928	7495
17835	7929	7901
17835	7929	4698
17835	7929	8760
17835	7929	9616
17835	7929	328
18514	7930	3847
18514	7930	6514
18514	7930	9720
18514	7930	5050
18514	7930	8982
18514	7930	7385
18514	7930	8727
18514	7930	5393
6586	7931	4221
6586	7931	5657
6586	7931	2026
6586	7931	747
6586	7931	5241
6586	7931	9282
6586	7931	3613
6586	7931	8326
6586	7931	3428
4818	7932	8885
4818	7932	6600
4818	7932	4951
4818	7932	7571
4818	7932	474
4818	7932	617
5284	7933	3332
5284	7933	8969
5284	7933	6443
5284	7933	8408
5284	7933	5914
5284	7933	8143
6981	7934	7565
6981	7934	7406
6981	7934	9631
208	7935	6234
208	7935	9178
208	7935	8771
208	7935	5703
208	7935	5122
208	7935	320
12468	7936	1420
12468	7936	8545
12468	7936	2737
12468	7936	1705
12468	7936	8625
9089	7937	1080
9089	7937	4283
6105	7938	792
6105	7938	3868
1559	7939	5834
1559	7939	6390
1559	7939	2027
1559	7939	489
1559	7939	9268
1559	7939	5067
1559	7939	3658
9475	7940	4995
15522	7941	5649
15522	7941	5510
15522	7941	6568
15522	7941	3847
472	7942	9362
472	7942	7377
472	7942	6382
472	7942	3015
18575	7943	9842
18575	7943	3325
18575	7943	7531
6359	7944	246
6359	7944	6210
6359	7944	2
6359	7944	4328
7378	7945	2318
7378	7945	1293
7378	7945	470
7378	7945	4620
7378	7945	3367
7378	7945	5016
7378	7945	7911
7378	7945	1937
5939	7946	570
5939	7946	64
5939	7946	3152
5939	7946	7353
5939	7946	8081
5939	7946	3475
9534	7947	5008
9534	7947	7549
9534	7947	4812
5444	7948	8480
5444	7948	9971
5444	7948	6810
5444	7948	2916
5444	7948	1112
5444	7948	1264
5444	7948	692
8332	7949	8933
8332	7949	4003
3103	7950	4117
18456	7951	66
18456	7951	9427
4686	7952	8410
4686	7952	4468
4686	7952	4355
4686	7952	3268
4686	7952	6034
4686	7952	9568
10778	7953	6023
10778	7953	5835
10778	7953	4931
10778	7953	1212
10778	7953	4568
10778	7953	1871
10778	7953	2981
10778	7953	5465
19865	7954	4267
19865	7954	9080
19865	7954	5960
19865	7954	335
19865	7954	4036
115	7955	9435
115	7955	6604
115	7955	7552
115	7955	1285
115	7955	633
115	7955	5041
11341	7956	654
11341	7956	9909
11341	7956	595
11341	7956	8380
11341	7956	7968
11341	7956	2852
953	7957	3032
953	7957	2554
7676	7958	8104
7676	7958	9416
7676	7958	718
2743	7959	1104
2743	7959	5685
2743	7959	7263
2743	7959	1898
2743	7959	2175
2743	7959	591
2743	7959	6277
2743	7959	8600
2743	7959	4206
8425	7960	9260
19955	7961	1349
19955	7961	4257
19955	7961	1536
19955	7961	1936
7666	7962	8203
7666	7962	2854
7666	7962	3125
7666	7962	3310
7666	7962	2739
7666	7962	1544
1606	7963	781
1606	7963	5720
19953	7964	9918
19953	7964	6359
19953	7964	349
19953	7964	9282
19953	7964	4774
19953	7964	3032
19953	7964	3589
12653	7965	3668
12653	7965	7576
12653	7965	346
12653	7965	5850
12653	7965	485
12653	7965	6042
12653	7965	9435
11585	7966	1064
11585	7966	481
7023	7967	9852
7023	7967	803
7023	7967	5738
7023	7967	1236
7023	7967	9498
10696	7968	7223
10696	7968	7218
17595	7969	727
17595	7969	7873
17595	7969	9349
17595	7969	4719
17595	7969	3237
17595	7969	2049
17595	7969	6740
17595	7969	8510
17595	7969	1100
5536	7970	4921
5536	7970	891
5536	7970	7234
5536	7970	935
5536	7970	9658
5536	7970	3195
5536	7970	2868
15172	7971	2156
15172	7971	3567
15172	7971	5462
15172	7971	6871
15172	7971	84
15172	7971	9329
15172	7971	3629
15172	7971	4017
15172	7971	6388
14644	7972	8984
14644	7972	2246
14644	7972	6670
14644	7972	9437
14644	7972	8064
3260	7973	3707
3260	7973	1995
3260	7973	3784
3260	7973	7230
3260	7973	5573
3920	7974	9282
3920	7974	1707
3920	7974	7556
3920	7974	116
3920	7974	2490
3920	7974	6521
3920	7974	1146
3266	7975	8991
3266	7975	9679
3266	7975	5243
3266	7975	188
3266	7975	8154
3266	7975	2776
4115	7976	322
876	7977	9991
876	7977	7812
876	7977	8873
876	7977	2769
876	7977	5883
876	7977	4717
876	7977	4533
9441	7978	6840
11901	7979	6768
11901	7979	6985
11901	7979	6368
11901	7979	8797
11901	7979	5225
8193	7980	4894
19222	7981	9571
19222	7981	1274
19222	7981	1136
19222	7981	3897
19222	7981	4064
19222	7981	7758
9484	7982	7586
9484	7982	8160
11306	7983	5915
11306	7983	6860
11306	7983	1411
11306	7983	4488
11521	7984	3874
11521	7984	8960
11521	7984	4728
11521	7984	8768
11521	7984	1459
11521	7984	1963
245	7985	5775
3378	7986	9623
3378	7986	6213
3261	7987	8183
3261	7987	9501
3261	7987	1681
3261	7987	3859
10634	7988	4362
10634	7988	6475
10634	7988	3960
10634	7988	4977
10634	7988	3938
10634	7988	9717
11860	7989	7560
11485	7990	2885
11485	7990	8464
11485	7990	3413
11485	7990	2060
12841	7991	2636
12841	7991	7928
12841	7991	1250
12841	7991	3149
12841	7991	5426
12841	7991	6897
8912	7992	198
8912	7992	84
8912	7992	4887
8912	7992	9825
8912	7992	1399
8912	7992	3296
4356	7993	5019
12537	7994	7235
12537	7994	2355
6935	7995	9315
6935	7995	7152
6935	7995	1867
6935	7995	7945
6935	7995	337
7266	7996	5811
7266	7996	2817
2735	7997	3067
2735	7997	8006
2735	7997	8464
2735	7997	8889
2735	7997	7830
2735	7997	5835
15401	7998	9391
15401	7998	4890
15401	7998	990
15401	7998	4841
15401	7998	1062
2993	7999	8004
2993	7999	9058
2993	7999	7513
2993	7999	8609
2993	7999	4571
810	8000	8105
810	8000	7752
9922	8001	1376
9922	8001	9981
9922	8001	7410
9922	8001	2277
9922	8001	8945
9922	8001	4272
1039	8002	1626
1039	8002	6797
1039	8002	6441
1039	8002	1167
1039	8002	6650
1039	8002	4377
7980	8003	6876
7980	8003	4152
7980	8003	6419
7980	8003	8159
7980	8003	9010
1026	8004	7065
1026	8004	134
1026	8004	5371
1026	8004	9794
1026	8004	7818
4389	8005	6185
4389	8005	2537
4389	8005	822
4389	8005	7345
4389	8005	3118
4389	8005	2603
4389	8005	7933
4389	8005	2640
19408	8006	3566
19408	8006	6346
19408	8006	7362
19408	8006	9801
19408	8006	6358
19408	8006	99
19408	8006	484
19408	8006	5601
19408	8006	9324
4883	8007	4568
4883	8007	5267
9811	8008	4678
9811	8008	3542
9811	8008	3835
7271	8009	278
7271	8009	4086
19374	8010	2632
19374	8010	7534
19374	8010	1756
19374	8010	7460
19374	8010	9309
12438	8011	6695
12438	8011	7628
12438	8011	1881
12438	8011	4165
12438	8011	4359
12438	8011	8050
7636	8012	8910
7636	8012	7877
7636	8012	1842
7636	8012	8545
7636	8012	6654
7636	8012	4021
7636	8012	4072
1532	8013	1296
1532	8013	5627
1532	8013	9230
14559	8014	1097
14559	8014	2373
14559	8014	7322
14559	8014	6450
14559	8014	9881
13068	8015	5115
13068	8015	3941
13068	8015	7684
17958	8016	4439
17958	8016	8723
17958	8016	7198
17958	8016	9447
17958	8016	3710
17958	8016	8302
17958	8016	2069
17958	8016	193
17313	8017	1141
17313	8017	9509
17313	8017	3896
14013	8018	5744
14013	8018	2062
18519	8019	7554
18519	8019	6215
18519	8019	6357
18519	8019	607
703	8020	2943
703	8020	2310
703	8020	1427
703	8020	9643
703	8020	3212
703	8020	5026
703	8020	6422
703	8020	3422
10075	8021	364
10075	8021	9757
10075	8021	264
10075	8021	3269
16948	8022	4820
16948	8022	6107
16948	8022	7724
16948	8022	9129
8308	8023	1242
8308	8023	9354
8308	8023	8349
8308	8023	1490
8308	8023	7101
8308	8023	5431
8308	8023	1609
8308	8023	7860
14138	8024	8588
14138	8024	8238
14732	8025	1520
14732	8025	7379
14732	8025	445
14732	8025	350
14732	8025	1852
14732	8025	7505
14732	8025	3086
14732	8025	6317
14732	8025	1634
17612	8026	798
17612	8026	5081
17612	8026	6143
6775	8027	522
6775	8027	681
6775	8027	6422
6775	8027	9760
6775	8027	2871
6775	8027	7226
6775	8027	200
6775	8027	652
15337	8028	664
15337	8028	8796
15337	8028	472
15337	8028	8660
15337	8028	8326
15337	8028	4792
15337	8028	661
15337	8028	9815
15337	8028	6504
18748	8029	5331
18748	8029	6124
18748	8029	8871
19019	8030	946
19019	8030	58
19019	8030	6540
19019	8030	8289
6162	8031	8554
10114	8032	4431
10114	8032	5369
10114	8032	6980
11700	8033	5360
11700	8033	3705
11700	8033	9741
11700	8033	7722
11700	8033	2480
11700	8033	1146
11700	8033	9092
11700	8033	2519
11700	8033	8387
2979	8034	1431
2979	8034	6894
2979	8034	9600
2979	8034	4260
2979	8034	2028
2979	8034	3073
2979	8034	5924
7291	8035	9657
7291	8035	4144
13324	8036	6612
13324	8036	4974
13324	8036	6228
13324	8036	7458
14113	8037	1990
14113	8037	8692
14113	8037	3518
14113	8037	7875
14113	8037	8260
14113	8037	4988
14113	8037	7207
14113	8037	6665
14113	8037	5793
4809	8038	1755
18424	8039	6269
18424	8039	1052
19486	8040	4357
19486	8040	1574
19486	8040	8162
19486	8040	534
19486	8040	5692
19486	8040	7673
19486	8040	255
19486	8040	3889
11287	8041	4855
11287	8041	3367
8837	8042	4161
8837	8042	3150
8837	8042	3894
8837	8042	1135
8837	8042	1285
13952	8043	8461
13952	8043	8557
13952	8043	1527
13952	8043	7993
13952	8043	4168
15068	8044	1953
15068	8044	8737
15068	8044	6051
15068	8044	4631
11532	8045	7434
11532	8045	4870
11532	8045	4520
11532	8045	5418
11532	8045	5679
11532	8045	5856
11532	8045	9257
11532	8045	6518
976	8046	3839
976	8046	5622
976	8046	8627
976	8046	9833
976	8046	6019
976	8046	3130
976	8046	1256
976	8046	9750
976	8046	1328
14013	8047	677
14013	8047	4731
14013	8047	5226
14013	8047	7683
14013	8047	1796
14836	8048	7671
14836	8048	3833
14836	8048	3074
14836	8048	7141
14836	8048	4960
14836	8048	106
14836	8048	2058
14836	8048	3294
7942	8049	1166
7942	8049	683
7942	8049	3993
7942	8049	369
7942	8049	9896
7942	8049	2561
7942	8049	3020
7942	8049	1256
16792	8050	5286
16792	8050	4602
16792	8050	9486
16792	8050	1513
16792	8050	1867
16792	8050	1546
16792	8050	7813
16792	8050	1880
4496	8051	4026
4496	8051	2168
4496	8051	4722
4496	8051	3139
4496	8051	1819
14209	8052	4448
11921	8053	3010
1645	8054	2628
1645	8054	7913
1645	8054	9807
1645	8054	6725
1645	8054	8983
1645	8054	5397
14431	8055	4320
14431	8055	6905
14431	8055	3347
14431	8055	4728
14431	8055	6546
14431	8055	8344
17685	8056	4048
17685	8056	9583
12614	8057	7753
12614	8057	6950
12614	8057	8440
12614	8057	3187
12614	8057	2404
11502	8058	5823
11502	8058	3991
11502	8058	2759
11502	8058	3009
11502	8058	3736
11502	8058	2663
17018	8059	3338
17018	8059	7960
17018	8059	4652
17018	8059	2920
17018	8059	9158
17018	8059	7928
17018	8059	1075
13794	8060	1063
8142	8061	1127
8142	8061	530
8142	8061	8921
8142	8061	8771
8142	8061	7531
8142	8061	2546
8142	8061	3129
4572	8062	2969
4572	8062	1756
4572	8062	8761
4572	8062	830
4572	8062	6988
4572	8062	3895
4572	8062	1517
4572	8062	5150
8141	8063	6329
8141	8063	2556
8141	8063	1913
8141	8063	4341
8141	8063	7970
8141	8063	9878
3266	8064	9626
3266	8064	5579
3266	8064	5978
3266	8064	1351
3266	8064	4494
3266	8064	9540
3479	8065	1470
3479	8065	5774
3479	8065	5615
3479	8065	5313
3479	8065	5245
3479	8065	4523
3479	8065	6824
12898	8066	3062
12898	8066	3045
12898	8066	509
12898	8066	912
2964	8067	8381
2964	8067	6392
2964	8067	6640
2964	8067	4270
2964	8067	5591
2964	8067	7143
7932	8068	415
7932	8068	3317
7932	8068	5529
7932	8068	7888
7932	8068	3899
7932	8068	6086
7932	8068	281
7932	8068	9447
7932	8068	1131
15541	8069	9723
15541	8069	6600
15541	8069	3550
15541	8069	831
15541	8069	8097
15541	8069	1542
15541	8069	4721
5217	8070	1408
5217	8070	4657
8206	8071	9942
8206	8071	5968
8206	8071	252
8206	8071	1223
8206	8071	2556
8206	8071	5203
8206	8071	3799
8206	8071	4631
18702	8072	1959
18702	8072	4154
18702	8072	4713
3559	8073	9978
3559	8073	8570
3559	8073	640
3559	8073	1636
3559	8073	5673
1749	8074	4173
17766	8075	1366
17766	8075	3703
17766	8075	6883
17766	8075	4330
17766	8075	195
17766	8075	7340
17766	8075	96
17766	8075	6117
15505	8076	1944
19039	8077	1726
19039	8077	4333
19039	8077	3619
19039	8077	6800
19039	8077	1218
11095	8078	2789
11095	8078	6101
11095	8078	8868
11095	8078	3620
11095	8078	9971
11095	8078	4002
10559	8079	730
10559	8079	546
10559	8079	6442
10559	8079	761
10559	8079	1484
14438	8080	3149
14438	8080	5498
14438	8080	3198
13636	8081	3035
13636	8081	3350
9564	8082	7941
9564	8082	3034
9564	8082	8303
9564	8082	7622
9564	8082	5772
9564	8082	7006
9564	8082	7084
9564	8082	3611
13617	8083	3626
13322	8084	5144
13322	8084	437
13322	8084	2087
13322	8084	2876
13322	8084	2758
13322	8084	8914
9371	8085	7982
9371	8085	8124
9371	8085	4588
9371	8085	8401
9371	8085	8395
9371	8085	6441
9371	8085	8688
9371	8085	6354
13580	8086	5167
13580	8086	4632
13580	8086	6623
13580	8086	8304
13580	8086	8231
13580	8086	5558
13580	8086	5234
13580	8086	7805
13580	8086	1208
19204	8087	301
19204	8087	1105
19204	8087	751
19204	8087	3444
19204	8087	8043
19204	8087	8762
19204	8087	6534
19204	8087	6220
8900	8088	663
8900	8088	2211
8900	8088	3117
8900	8088	4673
8900	8088	3021
8900	8088	2264
8900	8088	9825
8900	8088	9976
6839	8089	2029
6839	8089	2615
6839	8089	8038
6839	8089	3400
6839	8089	3284
6839	8089	9538
6839	8089	4759
6839	8089	2414
6839	8089	5168
16376	8090	1509
16376	8090	7977
16376	8090	390
16376	8090	4904
16376	8090	9816
4860	8091	1264
4860	8091	5981
4860	8091	356
4860	8091	8493
4860	8091	7268
4870	8092	623
4870	8092	9943
4870	8092	7798
4870	8092	3616
4870	8092	7793
15217	8093	39
15217	8093	4376
15217	8093	9840
15217	8093	5849
15217	8093	5875
15217	8093	5311
15217	8093	5247
15217	8093	5577
15217	8093	3634
7152	8094	1494
7152	8094	7205
7152	8094	465
7152	8094	6895
7152	8094	9076
7152	8094	6862
7152	8094	8235
7152	8094	3806
7152	8094	6898
4416	8095	507
4416	8095	6910
4416	8095	4597
4416	8095	7717
18420	8096	8497
18420	8096	4025
18420	8096	1252
18420	8096	2325
1119	8097	4643
6133	8098	6738
6133	8098	1257
6133	8098	8568
12568	8099	5494
12568	8099	3277
12568	8099	8988
12568	8099	9382
12568	8099	401
12568	8099	8353
12568	8099	2266
12568	8099	7306
12568	8099	4881
17602	8100	3228
17602	8100	358
17602	8100	7309
17602	8100	8079
17602	8100	1059
17602	8100	9741
17602	8100	7563
13889	8101	8651
13889	8101	8987
12585	8102	3634
12585	8102	4170
12585	8102	4510
12585	8102	5289
12585	8102	9193
14542	8103	843
14542	8103	2395
14542	8103	7155
14542	8103	5350
14542	8103	6067
14542	8103	3443
14542	8103	4918
14542	8103	1346
9959	8104	8813
9959	8104	867
9959	8104	9916
9959	8104	6699
10770	8105	3812
10770	8105	6578
10770	8105	1402
10770	8105	7088
10770	8105	5928
10770	8105	2522
10770	8105	4462
10770	8105	3587
8253	8106	9175
8253	8106	1760
8253	8106	8156
8253	8106	6008
8253	8106	3843
8253	8106	3657
8253	8106	8355
19511	8107	7224
19511	8107	6238
19511	8107	8935
19511	8107	3613
19511	8107	4461
19511	8107	6648
11645	8108	4913
11645	8108	334
8354	8109	1832
8354	8109	7321
8354	8109	13
8354	8109	6159
8354	8109	7571
8354	8109	6982
8354	8109	3096
15113	8110	9248
15113	8110	1496
15113	8110	5045
15113	8110	6981
15113	8110	7328
15113	8110	9555
2772	8111	1837
2772	8111	4297
2772	8111	6736
2772	8111	392
2772	8111	8373
14798	8112	3072
14798	8112	532
14798	8112	9328
14798	8112	976
14798	8112	954
14798	8112	6718
14798	8112	7533
14040	8113	6520
14040	8113	1726
14040	8113	5193
14040	8113	6973
2567	8114	8646
2567	8114	6941
2567	8114	8603
2567	8114	4753
2567	8114	2577
2567	8114	7881
10826	8115	2433
10826	8115	1838
10826	8115	5861
10826	8115	2207
10826	8115	5681
10826	8115	4618
10826	8115	462
10826	8115	7936
9752	8116	1144
9752	8116	7798
9752	8116	8744
9752	8116	3014
9752	8116	1091
9752	8116	3065
9752	8116	9056
9752	8116	2476
9365	8117	3862
9365	8117	5433
9365	8117	6168
9365	8117	3431
3433	8118	4754
3433	8118	3108
3433	8118	7481
3433	8118	8455
3433	8118	2642
3433	8118	2095
3433	8118	6423
3433	8118	6613
3433	8118	9253
6227	8119	7437
6227	8119	7835
6227	8119	5120
6227	8119	2584
6227	8119	5466
17145	8120	4694
17145	8120	6981
17145	8120	809
17145	8120	9033
17145	8120	3646
17145	8120	2119
17145	8120	8225
17145	8120	6011
6895	8121	4315
6895	8121	9534
6895	8121	4971
6895	8121	4235
10139	8122	4359
10139	8122	5600
10139	8122	362
10139	8122	2398
10139	8122	277
10139	8122	6904
10139	8122	5671
10139	8122	9893
1236	8123	6464
2867	8124	7331
2867	8124	6879
2474	8125	6404
2474	8125	1347
2474	8125	7292
2474	8125	3319
2474	8125	125
2474	8125	7111
2474	8125	280
10051	8126	9306
10051	8126	8531
10051	8126	3532
10051	8126	1435
10051	8126	7499
10051	8126	1647
10051	8126	9265
1224	8127	2235
4719	8128	2376
4719	8128	5777
4719	8128	4463
7538	8129	2354
7538	8129	4499
7538	8129	5589
7538	8129	6338
7538	8129	2419
7538	8129	5286
7538	8129	6215
7538	8129	7124
4636	8130	4623
4636	8130	904
10734	8131	9136
10734	8131	4937
10734	8131	7150
10734	8131	5277
10734	8131	1432
10734	8131	9975
10520	8132	7398
10520	8132	1881
10520	8132	9417
10520	8132	1172
4151	8133	7443
4151	8133	8366
6606	8134	2738
6606	8134	6620
6606	8134	4956
6606	8134	8019
15987	8135	5092
15987	8135	8956
15987	8135	172
15987	8135	8547
15987	8135	2204
15987	8135	8109
15987	8135	7744
15987	8135	6223
15987	8135	9777
5029	8136	6684
5029	8136	1567
5029	8136	4759
5029	8136	2696
5029	8136	2671
3253	8137	1754
3253	8137	4059
3253	8137	3825
3253	8137	3603
3253	8137	8642
3253	8137	6043
3253	8137	4114
3253	8137	933
15233	8138	2319
10028	8139	2801
10028	8139	8654
10028	8139	5310
10028	8139	5938
10028	8139	4364
10028	8139	1536
10028	8139	1330
14745	8140	1769
14745	8140	3650
15962	8141	7071
15962	8141	4477
15962	8141	3461
15962	8141	3817
15962	8141	2374
15962	8141	2521
15962	8141	8495
15962	8141	8073
15962	8141	4851
5285	8142	4548
5285	8142	8331
5285	8142	9683
5285	8142	6178
5285	8142	4938
5285	8142	8193
5285	8142	9770
5285	8142	6693
18131	8143	7376
18131	8143	3174
18131	8143	1235
18131	8143	4851
18131	8143	667
18131	8143	243
17147	8144	4048
17147	8144	1611
17147	8144	2837
17147	8144	8401
17147	8144	1457
17147	8144	6192
17147	8144	4158
17147	8144	1513
17147	8144	108
2686	8145	2784
2686	8145	3457
7249	8146	3476
7249	8146	1588
8847	8147	7029
8847	8147	8127
8847	8147	1570
6164	8148	7768
6164	8148	3574
6164	8148	2632
12175	8149	9712
12175	8149	4442
12175	8149	6632
2531	8150	4299
2531	8150	9506
2531	8150	702
5648	8151	5055
5648	8151	9327
5648	8151	2401
5648	8151	4986
5648	8151	8045
5648	8151	8697
5648	8151	5354
5648	8151	943
18430	8152	2375
18430	8152	7101
18430	8152	9974
18430	8152	2955
18430	8152	626
18430	8152	3210
18430	8152	9034
18430	8152	4308
18430	8152	4494
5076	8153	294
5076	8153	9523
5076	8153	1001
5076	8153	452
5076	8153	8309
5076	8153	1800
3547	8154	6457
3547	8154	4771
3547	8154	9516
3547	8154	2203
3547	8154	5238
3547	8154	3116
3547	8154	9234
19054	8155	764
19054	8155	7523
19054	8155	1045
19054	8155	4042
19054	8155	1240
19054	8155	4617
19054	8155	6409
19054	8155	8286
15601	8156	1623
15601	8156	9638
15601	8156	3146
4913	8157	1289
4913	8157	4104
4913	8157	377
4913	8157	4642
4913	8157	7992
4913	8157	3167
4913	8157	332
17233	8158	6417
17233	8158	7364
17233	8158	5958
17233	8158	2778
8588	8159	1604
8588	8159	3431
8588	8159	1659
8588	8159	855
17694	8160	1456
17694	8160	967
3442	8161	7458
3442	8161	5585
3442	8161	3924
3442	8161	2518
3442	8161	2656
3442	8161	4064
3442	8161	6925
17167	8162	4884
14131	8163	9578
14131	8163	6261
11639	8164	2742
13330	8165	6460
13330	8165	1073
13330	8165	9113
13330	8165	8018
13330	8165	6581
13330	8165	9900
13330	8165	8845
19523	8166	1646
19523	8166	8814
19523	8166	2770
19523	8166	6313
19523	8166	901
19523	8166	2176
19523	8166	7787
19523	8166	7952
14128	8167	6143
14128	8167	6495
14128	8167	4901
14128	8167	5609
14128	8167	5101
14128	8167	1537
14128	8167	3249
12037	8168	1530
12037	8168	9100
12037	8168	1414
12037	8168	2341
12037	8168	5745
12037	8168	6429
12037	8168	8676
12037	8168	6037
1873	8169	4366
1873	8169	519
1873	8169	2355
1873	8169	6252
7332	8170	1981
7332	8170	5020
14721	8171	8859
14721	8171	6988
14721	8171	1759
14721	8171	2705
6426	8172	8822
6426	8172	4229
6426	8172	8877
6426	8172	5527
6426	8172	4146
6426	8172	9978
6426	8172	9945
6426	8172	9521
4560	8173	1468
4560	8173	8751
2910	8174	4668
2910	8174	5275
2910	8174	3296
2910	8174	4666
2910	8174	9983
2910	8174	836
2910	8174	8379
16646	8175	6912
16646	8175	2056
16646	8175	9385
16646	8175	9852
16646	8175	6749
16646	8175	9591
16646	8175	9788
16646	8175	8531
16646	8175	7748
4826	8176	2606
4826	8176	8678
4826	8176	5647
4826	8176	9307
4826	8176	8709
1529	8177	4288
1529	8177	7147
1529	8177	8796
1529	8177	1381
1529	8177	995
1529	8177	3647
1529	8177	1737
1529	8177	1155
1529	8177	2761
2875	8178	371
2875	8178	7674
2875	8178	268
2875	8178	9844
2875	8178	6310
2875	8178	2330
2252	8179	9710
2252	8179	6458
2252	8179	9928
2252	8179	1568
2252	8179	3930
2252	8179	4842
19169	8180	3635
19169	8180	5214
19169	8180	5686
19169	8180	276
19169	8180	9188
19169	8180	5450
11283	8181	6828
11283	8181	6795
11283	8181	5553
11283	8181	7836
5354	8182	2262
5354	8182	4589
5354	8182	3081
5354	8182	9798
5354	8182	4860
5354	8182	761
5354	8182	2678
5354	8182	8402
18604	8183	6661
18604	8183	5434
18604	8183	5004
18604	8183	1694
18604	8183	5946
18604	8183	6148
18604	8183	367
18604	8183	4103
7801	8184	3974
7801	8184	9446
7801	8184	9184
7801	8184	3059
7801	8184	7149
7617	8185	6021
7617	8185	8417
7617	8185	2245
7617	8185	3387
7617	8185	2570
13346	8186	573
13346	8186	5065
13346	8186	2385
13346	8186	1197
13346	8186	2356
13346	8186	2604
13346	8186	7161
13346	8186	3313
13346	8186	7466
11765	8187	246
11765	8187	1896
11765	8187	4186
11765	8187	9488
122	8188	4607
122	8188	264
122	8188	4748
122	8188	59
122	8188	2124
122	8188	9669
14268	8189	3017
14268	8189	8691
14268	8189	2250
14268	8189	6077
14268	8189	1611
4600	8190	8054
4600	8190	1797
4600	8190	6036
4600	8190	938
4600	8190	3895
4600	8190	3314
4600	8190	8498
4600	8190	697
7427	8191	6975
7427	8191	1706
6631	8192	5615
6631	8192	207
4006	8193	8547
4883	8194	6005
4883	8194	7155
4883	8194	7751
4883	8194	414
4883	8194	700
4883	8194	169
4883	8194	440
4883	8194	5721
4883	8194	5529
11471	8195	7739
11471	8195	8275
11471	8195	9914
11471	8195	8727
11471	8195	4789
11471	8195	382
11471	8195	1432
3691	8196	9234
3691	8196	4630
3691	8196	5074
1205	8197	6338
1205	8197	9791
16130	8198	2940
16130	8198	9491
16130	8198	3818
16130	8198	9672
2392	8199	3421
2392	8199	104
2392	8199	6002
2392	8199	8400
2392	8199	5779
2392	8199	6753
2392	8199	6773
2392	8199	6193
2392	8199	4609
15096	8200	5277
15096	8200	3405
15096	8200	4706
15096	8200	6144
19127	8201	7613
12024	8202	6096
12024	8202	3550
19484	8203	6295
19484	8203	4311
19484	8203	894
19484	8203	1392
19484	8203	4535
19484	8203	5704
19484	8203	7898
12050	8204	154
12050	8204	3865
12050	8204	3646
12050	8204	4623
12050	8204	2829
12050	8204	6937
12050	8204	3541
12050	8204	3507
8800	8205	8697
8800	8205	2655
8800	8205	2649
8800	8205	480
8800	8205	6577
8800	8205	743
9215	8206	4568
9215	8206	92
9215	8206	7142
1364	8207	8533
1364	8207	1449
1364	8207	1983
1364	8207	7942
1364	8207	4546
1364	8207	5189
1364	8207	3481
8446	8208	8830
8446	8208	4210
8601	8209	1329
8601	8209	2425
1915	8210	6928
1915	8210	2978
1915	8210	3634
17644	8211	588
17644	8211	3163
17644	8211	5925
17644	8211	3319
17644	8211	5390
17644	8211	4434
17644	8211	9664
17644	8211	519
17644	8211	7351
8730	8212	3361
8730	8212	4842
8730	8212	5235
8730	8212	5817
8730	8212	9242
8730	8212	2395
8730	8212	5486
8730	8212	4397
8730	8212	8453
5772	8213	8649
5772	8213	8476
5772	8213	8392
5772	8213	364
5772	8213	1494
5772	8213	838
12146	8214	3856
12146	8214	2939
12146	8214	8281
12146	8214	4569
12146	8214	7228
12146	8214	2464
16866	8215	4921
16866	8215	555
16866	8215	337
16866	8215	6438
16866	8215	4644
10724	8216	1898
10724	8216	678
10724	8216	3455
10724	8216	3259
10724	8216	1636
8197	8217	2531
8197	8217	1506
8197	8217	3596
8197	8217	764
8197	8217	2979
8197	8217	5762
8197	8217	4478
15652	8218	5030
15652	8218	9717
15652	8218	8363
15652	8218	6507
15652	8218	3462
15803	8219	2681
15803	8219	4079
15803	8219	8068
15803	8219	209
15803	8219	2044
15803	8219	8668
3304	8220	6533
3304	8220	8027
3304	8220	7862
3304	8220	9224
3304	8220	6387
3304	8220	1919
3304	8220	587
3304	8220	7110
2377	8221	6031
16149	8222	4596
17885	8223	8320
17885	8223	4641
17885	8223	8656
17885	8223	549
17885	8223	6550
17885	8223	5526
17885	8223	8887
17885	8223	404
19895	8224	9700
19895	8224	7928
19895	8224	3553
19895	8224	1039
19895	8224	1466
19895	8224	3804
19895	8224	7546
19895	8224	5966
19895	8224	2308
17714	8225	5993
17714	8225	9404
17714	8225	9180
17714	8225	6344
17714	8225	3081
17714	8225	4331
17714	8225	1464
5004	8226	7781
5004	8226	4782
5004	8226	5544
5004	8226	1527
5004	8226	7262
12486	8227	4110
12486	8227	9097
12486	8227	2169
10497	8228	6257
10497	8228	6490
10497	8228	5450
10497	8228	4785
10497	8228	6885
10497	8228	8556
10497	8228	314
10497	8228	279
13974	8229	9688
13974	8229	1333
13974	8229	1217
10983	8230	4097
10983	8230	8656
10983	8230	4793
10983	8230	371
10983	8230	7336
10983	8230	9143
18912	8231	7032
18912	8231	6949
18912	8231	1215
18912	8231	8777
18912	8231	5420
18912	8231	6048
18912	8231	5485
18912	8231	5353
18912	8231	9801
9187	8232	4170
6625	8233	2769
6625	8233	7437
6625	8233	6137
6625	8233	649
6625	8233	1021
6625	8233	9898
6625	8233	9418
9804	8234	4483
9804	8234	5447
7121	8235	9009
7121	8235	2617
7121	8235	451
7121	8235	7661
7121	8235	5185
7121	8235	2273
7121	8235	1148
7121	8235	5258
7121	8235	9734
11637	8236	7256
11637	8236	8273
11637	8236	8708
11637	8236	6262
11637	8236	2712
11637	8236	6869
11637	8236	5620
6560	8237	7077
6560	8237	1730
6560	8237	772
6560	8237	9270
6560	8237	1663
6560	8237	6324
7158	8238	6281
7158	8238	5669
7158	8238	7899
9534	8239	2086
9534	8239	6712
9534	8239	320
9534	8239	4771
11085	8240	6048
11085	8240	7541
3060	8241	3792
3060	8241	1243
3060	8241	4773
3060	8241	7841
3060	8241	3909
3060	8241	6018
3060	8241	5972
12582	8242	8340
12582	8242	3599
12582	8242	9811
12582	8242	8075
12582	8242	2018
12582	8242	8881
12582	8242	7250
12582	8242	198
9941	8243	7556
9941	8243	1523
9941	8243	7537
9941	8243	6304
9941	8243	3785
9941	8243	8879
9941	8243	1351
9941	8243	9501
9941	8243	2125
8283	8244	2109
8283	8244	65
8283	8244	3330
8283	8244	7276
8283	8244	2171
8283	8244	2505
8283	8244	8406
9418	8245	7531
9418	8245	7096
9418	8245	2220
9418	8245	43
9418	8245	4172
3521	8246	6598
19855	8247	891
6791	8248	3436
6791	8248	8121
6791	8248	228
6791	8248	4041
12521	8249	604
12521	8249	3128
12521	8249	9851
12521	8249	9683
12521	8249	5086
6587	8250	3672
6587	8250	661
6587	8250	1176
6587	8250	2999
6587	8250	8396
6587	8250	4948
6587	8250	549
8935	8251	2558
8935	8251	8390
8935	8251	6255
8935	8251	8857
8935	8251	654
8935	8251	4634
8935	8251	2498
8935	8251	1174
8935	8251	6047
18090	8252	2271
18090	8252	8087
18090	8252	6071
18090	8252	7287
18090	8252	6084
18090	8252	7304
7117	8253	4899
19063	8254	7837
19063	8254	1999
19063	8254	129
19063	8254	2928
19063	8254	4905
19063	8254	8365
19063	8254	8017
19063	8254	9774
11714	8255	330
11714	8255	5420
635	8256	9849
635	8256	3692
635	8256	460
635	8256	1568
635	8256	4944
19695	8257	2839
5224	8258	8469
5224	8258	1579
5224	8258	5561
5224	8258	1672
5224	8258	7316
5224	8258	8923
5224	8258	423
5224	8258	4849
5224	8258	8305
6495	8259	3095
6495	8259	4559
6495	8259	8311
6495	8259	8545
14028	8260	5812
14968	8261	5227
14968	8261	2494
14968	8261	652
14968	8261	6532
14968	8261	3759
9337	8262	5271
9337	8262	1232
9337	8262	6111
9337	8262	4904
9337	8262	6790
5204	8263	86
5204	8263	9906
5204	8263	6584
5204	8263	962
5204	8263	9742
6999	8264	8168
6999	8264	3694
6999	8264	3719
6999	8264	7019
6999	8264	4702
6999	8264	5377
6999	8264	6310
6999	8264	4093
8357	8265	9491
8357	8265	8821
8357	8265	8106
8357	8265	7944
8357	8265	2061
8357	8265	2692
12770	8266	1310
12770	8266	4314
12770	8266	2606
12770	8266	7503
12770	8266	1630
16291	8267	4567
16291	8267	9812
16291	8267	5715
16291	8267	1950
16291	8267	2213
16291	8267	7097
16291	8267	4239
16291	8267	1290
16291	8267	2346
13319	8268	6350
13319	8268	108
9526	8269	3705
9526	8269	8743
9526	8269	4078
9526	8269	1432
7289	8270	8549
7289	8270	3075
7289	8270	2179
7289	8270	2438
7289	8270	2080
16857	8271	6407
16857	8271	6829
1065	8272	4048
1065	8272	1547
1065	8272	3326
1065	8272	9124
1065	8272	4876
1065	8272	7638
1065	8272	7511
19896	8273	996
19896	8273	3878
19896	8273	4606
19896	8273	3023
19896	8273	2815
12071	8274	3334
12071	8274	1493
12071	8274	9668
12071	8274	23
12071	8274	8288
12071	8274	2492
11723	8275	1311
11723	8275	599
11723	8275	4897
11723	8275	5472
11723	8275	6637
11723	8275	9288
11723	8275	4321
11723	8275	4615
12215	8276	6723
12215	8276	1960
12215	8276	1997
12215	8276	809
12215	8276	313
12215	8276	7532
12215	8276	3296
16386	8277	6112
16386	8277	567
16386	8277	8571
6372	8278	9293
12031	8279	1026
3669	8280	8389
3669	8280	6655
3669	8280	8321
3669	8280	9878
3669	8280	5746
12624	8281	1199
7481	8282	596
7481	8282	8686
7481	8282	4003
17445	8283	3755
17445	8283	7825
17445	8283	1620
17445	8283	3875
17445	8283	7798
17445	8283	7486
17445	8283	5932
14261	8284	871
14261	8284	5660
14261	8284	2562
13128	8285	5287
13128	8285	5858
13128	8285	5536
13128	8285	9451
13128	8285	9828
13128	8285	8653
13128	8285	2945
13128	8285	7044
13311	8286	9644
13311	8286	7243
13311	8286	8342
13311	8286	9648
13311	8286	6368
13311	8286	9817
13311	8286	9306
13311	8286	695
291	8287	3470
291	8287	6809
291	8287	6787
291	8287	5290
291	8287	508
291	8287	212
291	8287	8171
291	8287	5455
291	8287	7259
7252	8288	5280
7252	8288	3597
7252	8288	2953
7252	8288	6120
7252	8288	2138
7252	8288	5597
7252	8288	6003
7252	8288	2800
6614	8289	3459
6614	8289	1847
6614	8289	7271
6614	8289	4017
5645	8290	934
5645	8290	3984
5645	8290	9846
5645	8290	8835
5645	8290	9692
5645	8290	929
5645	8290	6815
5645	8290	6987
19149	8291	333
15207	8292	2979
15207	8292	6246
15207	8292	7078
15207	8292	3167
6024	8293	4995
6024	8293	4332
6024	8293	6550
6024	8293	9651
6024	8293	2142
6024	8293	3111
6024	8293	7179
6024	8293	4763
6024	8293	1048
8051	8294	300
8051	8294	3432
8051	8294	8308
8051	8294	6478
8051	8294	4396
8051	8294	326
13751	8295	412
13751	8295	3731
13751	8295	9542
13751	8295	6966
13751	8295	7495
13751	8295	5405
13751	8295	2039
4676	8296	5805
4676	8296	1682
4676	8296	597
4676	8296	3755
4676	8296	4804
4676	8296	7798
4676	8296	8196
3852	8297	2836
3852	8297	536
3852	8297	6710
3852	8297	7831
3852	8297	1514
3852	8297	1086
13779	8298	9172
5853	8299	4076
5853	8299	6010
5399	8300	8932
5399	8300	3411
5399	8300	7361
5399	8300	5408
5399	8300	8868
19905	8301	6842
19905	8301	6001
19905	8301	2767
19905	8301	8940
19905	8301	3864
19747	8302	2573
19747	8302	2216
19747	8302	6515
19747	8302	972
19747	8302	5746
19747	8302	9067
19747	8302	3300
9105	8303	1264
9105	8303	7420
12720	8304	9375
12720	8304	3660
12720	8304	5792
12720	8304	4144
1315	8305	4533
1315	8305	5087
1315	8305	3992
1315	8305	9443
1315	8305	2939
1315	8305	9963
1315	8305	8228
1315	8305	8232
4010	8306	296
4010	8306	7778
4010	8306	1828
19128	8307	8272
19128	8307	7107
19128	8307	709
19128	8307	1744
19128	8307	9654
19128	8307	987
19128	8307	8884
14230	8308	9120
18830	8309	5502
18830	8309	3555
12265	8310	3242
12265	8310	7914
12265	8310	5528
12265	8310	4103
12265	8310	4338
6441	8311	336
6441	8311	2535
12782	8312	8025
12782	8312	2580
12782	8312	3968
12782	8312	7712
12782	8312	3421
12782	8312	5723
2500	8313	6431
2500	8313	4096
2500	8313	8548
2500	8313	3022
2500	8313	64
2500	8313	8338
2500	8313	1947
2500	8313	6888
2500	8313	1578
11090	8314	6837
11090	8314	216
11090	8314	3087
11090	8314	3809
11090	8314	4126
11090	8314	9404
11090	8314	1467
11090	8314	6619
11090	8314	6835
10343	8315	2378
10343	8315	1964
7029	8316	2777
7029	8316	4150
7029	8316	8895
5407	8317	2943
5407	8317	460
5407	8317	8667
11001	8318	672
11001	8318	935
11001	8318	6071
11001	8318	7005
11001	8318	6412
11001	8318	2533
11001	8318	2840
11001	8318	2182
11001	8318	3919
10460	8319	5945
10460	8319	1791
10460	8319	71
10460	8319	112
10460	8319	9633
10460	8319	5304
10460	8319	3833
1675	8320	7342
1675	8320	9064
1675	8320	725
1675	8320	1916
1675	8320	1539
1675	8320	9873
1675	8320	3736
1675	8320	7064
1675	8320	429
1080	8321	1324
1080	8321	6414
1080	8321	7643
1080	8321	5993
1080	8321	9752
1080	8321	3195
7838	8322	8562
7838	8322	1786
7838	8322	5670
7838	8322	4252
7838	8322	1047
14524	8323	3109
19045	8324	9400
19045	8324	3895
19045	8324	1026
19045	8324	7967
19045	8324	1008
19138	8325	8003
19138	8325	7278
16648	8326	5586
16648	8326	8726
16648	8326	8696
16648	8326	8217
16648	8326	569
16648	8326	8085
16648	8326	6767
16648	8326	1553
5120	8327	2129
5120	8327	5380
5120	8327	7679
5120	8327	2386
18639	8328	1473
18639	8328	5260
18639	8328	8151
18639	8328	561
18639	8328	1091
18639	8328	3183
9471	8329	7296
9471	8329	5029
816	8330	3065
816	8330	1117
816	8330	1261
816	8330	610
816	8330	7041
10383	8331	3911
10383	8331	2107
10383	8331	8291
10383	8331	1829
18248	8332	8549
18248	8332	6705
18248	8332	9370
18248	8332	46
18248	8332	3813
18248	8332	5202
4484	8333	7434
4484	8333	399
4484	8333	70
4484	8333	8437
4484	8333	2367
4484	8333	9239
4484	8333	9390
15876	8334	6042
15876	8334	6404
15876	8334	9280
15876	8334	7393
15876	8334	4639
15876	8334	6724
8313	8335	5500
8313	8335	1273
8313	8335	2994
8313	8335	4203
8313	8335	7275
8313	8335	7699
8313	8335	1530
8313	8335	3841
489	8336	461
489	8336	9679
489	8336	2482
489	8336	30
489	8336	559
12117	8337	9996
8396	8338	7790
8396	8338	9011
5704	8339	3097
5704	8339	393
5704	8339	1600
5704	8339	8657
5704	8339	6473
14062	8340	3089
14062	8340	5442
14062	8340	4734
14062	8340	7282
14062	8340	1778
1577	8341	3641
13473	8342	293
13473	8342	6278
13473	8342	7513
13473	8342	7637
13473	8342	9781
13473	8342	6994
4871	8343	2408
4871	8343	7351
4871	8343	8307
4871	8343	4973
4871	8343	9313
4871	8343	3979
4871	8343	5349
4871	8343	1333
15220	8344	360
15220	8344	9198
15220	8344	3146
15220	8344	3009
15220	8344	8627
15220	8344	4736
15220	8344	2197
1007	8345	3201
14359	8346	2990
14359	8346	9794
14359	8346	4161
14359	8346	8984
16361	8347	4372
16361	8347	6332
16361	8347	6631
16361	8347	4031
16361	8347	3154
16361	8347	9331
16361	8347	9439
16361	8347	4024
16361	8347	9710
5399	8348	4930
5399	8348	6573
6370	8349	2944
6370	8349	6801
6370	8349	9461
6370	8349	342
6370	8349	2259
6370	8349	2740
6370	8349	7428
6370	8349	4121
6370	8349	419
5624	8350	4999
5624	8350	6438
5624	8350	5371
5624	8350	4756
5624	8350	43
5624	8350	3927
6776	8351	6879
6776	8351	811
6776	8351	4122
6776	8351	1796
6776	8351	9690
6776	8351	2072
6776	8351	5027
51	8352	1596
51	8352	4215
51	8352	2892
13637	8353	207
14171	8354	6704
14171	8354	7389
14171	8354	6267
14171	8354	714
14171	8354	7461
14171	8354	6938
14171	8354	5765
14171	8354	7633
14171	8354	2425
10634	8355	2136
10634	8355	8788
10634	8355	8577
10634	8355	9427
10634	8355	6278
10634	8355	507
10634	8355	4629
10684	8356	1082
10684	8356	2532
10684	8356	9045
10684	8356	4207
10684	8356	2012
10684	8356	6787
10684	8356	5682
10684	8356	5319
7790	8357	6376
13765	8358	3656
13765	8358	6789
15740	8359	4716
15740	8359	3184
15740	8359	1329
16230	8360	7037
16230	8360	6991
16230	8360	2524
17799	8361	5782
17799	8361	7254
17799	8361	283
17799	8361	8203
17799	8361	1912
17799	8361	3791
13948	8362	2169
10957	8363	4108
10957	8363	3656
10957	8363	487
10957	8363	5531
10957	8363	8450
11405	8364	9744
11405	8364	5998
11405	8364	7970
11405	8364	8281
11405	8364	6762
17860	8365	4408
17860	8365	728
17860	8365	3026
17860	8365	5146
17860	8365	7026
10949	8366	1177
10949	8366	630
10949	8366	1688
10949	8366	2575
10949	8366	6415
6351	8367	2105
6351	8367	8925
6351	8367	2026
6351	8367	5028
346	8368	849
5672	8369	5572
5672	8369	8631
5672	8369	1678
5672	8369	6917
5672	8369	2061
5672	8369	1268
5672	8369	6972
11792	8370	5548
11792	8370	4723
11792	8370	5085
11792	8370	641
11792	8370	2305
11792	8370	8770
11792	8370	4885
11792	8370	1778
11792	8370	1601
17034	8371	1935
17034	8371	3526
17034	8371	6187
17034	8371	4803
17034	8371	843
17034	8371	983
17034	8371	9932
1144	8372	7746
1144	8372	7880
19316	8373	3114
19316	8373	5230
19316	8373	7646
19316	8373	7476
19316	8373	6071
19316	8373	2343
19316	8373	9733
1431	8374	6784
1431	8374	1726
18942	8375	2102
18942	8375	6289
18942	8375	1380
18942	8375	9111
18942	8375	4063
18942	8375	3773
19686	8376	716
3877	8377	3092
3877	8377	9801
17103	8378	5183
2942	8379	873
2942	8379	3424
2942	8379	503
2942	8379	6472
2942	8379	7040
2942	8379	8701
2942	8379	6602
4496	8380	4678
4496	8380	7602
4496	8380	2710
15783	8381	9362
15783	8381	8912
4671	8382	9532
4671	8382	5592
4671	8382	3310
4671	8382	4326
4671	8382	6447
4671	8382	2159
4671	8382	6803
8808	8383	6293
8808	8383	5563
8808	8383	1485
8808	8383	7483
8808	8383	5159
8808	8383	2732
8808	8383	1303
13789	8384	1187
13789	8384	5188
13789	8384	7177
13789	8384	8437
13789	8384	4183
13820	8385	6298
13820	8385	9245
13820	8385	1559
13820	8385	8179
13820	8385	869
4344	8386	9067
4344	8386	4288
4344	8386	5164
4344	8386	7886
4344	8386	6821
4344	8386	6319
4344	8386	9722
4344	8386	7913
4344	8386	9376
17240	8387	5348
17240	8387	5701
17240	8387	1081
17240	8387	8388
17240	8387	1755
17240	8387	6259
17240	8387	7707
17240	8387	5516
17240	8387	3763
162	8388	4782
162	8388	2428
19705	8389	8836
19705	8389	7624
19705	8389	4340
19705	8389	7280
19705	8389	2956
19705	8389	182
19705	8389	5076
1184	8390	2929
1184	8390	4479
1184	8390	7030
1184	8390	7519
5960	8391	433
5960	8391	4317
5960	8391	2681
5960	8391	6759
5960	8391	1383
5960	8391	8995
8141	8392	4663
8141	8392	3963
8141	8392	8325
8141	8392	3858
8141	8392	7702
8141	8392	4812
8141	8392	4356
8141	8392	7312
8141	8392	2266
9892	8393	4907
9892	8393	9317
9892	8393	3228
9892	8393	7972
9892	8393	7810
9892	8393	5610
9892	8393	224
9892	8393	215
9892	8393	9289
8200	8394	8220
8200	8394	4602
8200	8394	7973
8200	8394	5431
8200	8394	7049
8200	8394	9920
8200	8394	4239
8200	8394	4611
8200	8394	5827
2872	8395	5371
2872	8395	9149
2872	8395	2324
2872	8395	8759
2872	8395	4420
18042	8396	6467
18042	8396	3931
18042	8396	3232
18042	8396	9880
18042	8396	6999
18042	8396	9680
9047	8397	9591
17478	8398	3345
17478	8398	9192
17478	8398	28
17478	8398	6785
17478	8398	2571
17478	8398	386
17478	8398	6766
17478	8398	352
14700	8399	175
8870	8400	4066
8870	8400	3620
8870	8400	2493
8870	8400	1404
8870	8400	4729
3027	8401	4764
3027	8401	7650
16003	8402	5351
16003	8402	4779
16003	8402	7353
16003	8402	9961
8051	8403	2381
8051	8403	5534
8051	8403	5335
8051	8403	5216
8051	8403	1775
8051	8403	5061
8051	8403	3445
8051	8403	8068
12483	8404	5550
12483	8404	1587
12483	8404	5228
12483	8404	9403
12483	8404	5573
12483	8404	8746
8559	8405	4541
8559	8405	3458
8559	8405	1090
8559	8405	2855
8559	8405	1228
8559	8405	904
8559	8405	7164
8559	8405	8000
8559	8405	6443
3342	8406	1848
3342	8406	5578
3342	8406	4658
3342	8406	4873
3342	8406	9335
5585	8407	1311
5585	8407	8972
5585	8407	9506
5585	8407	4477
4952	8408	2062
4952	8408	9272
4952	8408	13
4952	8408	9900
4952	8408	1713
4952	8408	5379
4952	8408	953
8599	8409	8737
8599	8409	312
19635	8410	6487
19635	8410	8307
19635	8410	6341
19635	8410	865
19635	8410	3563
19635	8410	6733
16891	8411	5031
16891	8411	6559
8128	8412	2880
8128	8412	9714
14591	8413	6036
14591	8413	5242
14591	8413	8739
14591	8413	7990
14591	8413	6983
14591	8413	5764
14591	8413	3167
14591	8413	5295
14591	8413	2755
12050	8414	8032
12050	8414	5053
15877	8415	7311
15877	8415	1466
15877	8415	3453
2883	8416	6163
2883	8416	9090
2883	8416	2053
2883	8416	7527
2883	8416	6238
2883	8416	831
17725	8417	6608
17725	8417	1727
17725	8417	7077
17725	8417	2724
12352	8418	7618
7560	8419	3109
7560	8419	9363
7560	8419	6381
7560	8419	7387
7560	8419	7754
17409	8420	2686
17409	8420	4329
17409	8420	675
4528	8421	2511
4528	8421	8303
4528	8421	4626
4528	8421	3376
4528	8421	9399
4528	8421	8369
4528	8421	8338
12183	8422	4796
12183	8422	1745
12183	8422	3426
12183	8422	7242
12183	8422	3126
12183	8422	6364
12183	8422	2595
12183	8422	7201
12183	8422	7273
1298	8423	3387
1298	8423	3901
1298	8423	3683
1298	8423	7816
1298	8423	5955
1298	8423	7349
1298	8423	92
1298	8423	3773
13796	8424	3253
13796	8424	112
14768	8425	8033
14768	8425	3215
14768	8425	9764
14768	8425	3144
14768	8425	4006
19921	8426	7660
19921	8426	7129
19921	8426	995
19921	8426	8330
19921	8426	3240
19921	8426	9347
11435	8427	811
11435	8427	6149
11435	8427	187
11435	8427	1141
10292	8428	5107
10292	8428	4720
10292	8428	1521
10292	8428	4198
10292	8428	3850
10292	8428	6389
10292	8428	4109
10292	8428	440
2350	8429	9942
2350	8429	6289
2350	8429	2517
3750	8430	240
3750	8430	5605
3750	8430	446
3750	8430	6807
3750	8430	9641
3750	8430	7170
3750	8430	7746
16372	8431	9361
16372	8431	5481
16372	8431	4480
13993	8432	8872
13993	8432	633
13993	8432	9452
19796	8433	4541
3421	8434	2989
3421	8434	7464
3421	8434	4013
3421	8434	8286
3421	8434	6126
3421	8434	1262
3421	8434	9762
3421	8434	8442
3421	8434	2230
3364	8435	1580
3364	8435	2689
8442	8436	3499
1924	8437	7786
1924	8437	5013
1924	8437	2280
1924	8437	9465
1924	8437	6733
17926	8438	645
17926	8438	230
17926	8438	969
17926	8438	8345
17926	8438	7140
17926	8438	3358
17926	8438	6995
17926	8438	1600
18770	8439	3295
18770	8439	1672
18770	8439	2058
18770	8439	667
18770	8439	7367
16023	8440	236
16023	8440	4296
2870	8441	2073
2870	8441	1780
2870	8441	9973
2870	8441	3057
2870	8441	7561
2870	8441	7728
2870	8441	9111
19555	8442	7426
19555	8442	3015
19555	8442	5041
19555	8442	8278
19555	8442	1830
13169	8443	8334
13169	8443	6516
13169	8443	2695
512	8444	9488
512	8444	3529
512	8444	4812
512	8444	2127
10283	8445	8391
10283	8445	4085
10283	8445	9716
10283	8445	6804
10283	8445	7700
8430	8446	3787
8430	8446	1949
2873	8447	8561
2873	8447	2779
2873	8447	1791
2873	8447	5829
2873	8447	7235
2873	8447	9275
2873	8447	4439
2485	8448	6380
2485	8448	8089
2485	8448	8146
2485	8448	9285
4979	8449	9224
4979	8449	5883
4979	8449	778
4979	8449	4488
4979	8449	9068
4979	8449	824
10524	8450	6504
10524	8450	3090
10524	8450	1242
10524	8450	2708
10524	8450	3055
10524	8450	9482
10524	8450	4482
10524	8450	968
10524	8450	1102
3758	8451	8484
18616	8452	4570
18616	8452	4171
18616	8452	4053
18616	8452	3957
18616	8452	8439
2987	8453	6133
2987	8453	5175
2987	8453	6842
2987	8453	3951
16950	8454	2067
16950	8454	5947
16950	8454	9608
16950	8454	3264
16950	8454	1590
16950	8454	1038
18954	8455	970
18954	8455	1455
18954	8455	4004
18954	8455	4203
18954	8455	2906
18954	8455	3391
18954	8455	6628
17387	8456	2693
17387	8456	4162
17387	8456	4168
17387	8456	3273
11765	8457	3174
11765	8457	4374
11765	8457	2755
11765	8457	1258
8327	8458	5224
8327	8458	8742
8327	8458	430
6245	8459	9079
4701	8460	8233
4701	8460	1285
4701	8460	9621
4701	8460	6035
4701	8460	4034
4701	8460	9332
4701	8460	1455
13358	8461	9603
13358	8461	4132
13358	8461	9730
13358	8461	6902
13358	8461	8127
14828	8462	1383
14828	8462	797
14828	8462	8102
14828	8462	3378
14828	8462	4123
14828	8462	5391
14828	8462	7149
14828	8462	2256
14828	8462	5864
19991	8463	4041
19991	8463	8470
19991	8463	8313
19991	8463	9582
19991	8463	9019
19991	8463	1917
19991	8463	1967
19991	8463	6645
19991	8463	2155
15090	8464	8801
15090	8464	8528
15090	8464	458
15090	8464	4660
15090	8464	8123
13185	8465	6220
13185	8465	1202
6238	8466	3138
6238	8466	8724
6238	8466	2465
6238	8466	2837
3275	8467	6302
1922	8468	9662
1922	8468	3680
1922	8468	1500
1922	8468	978
1922	8468	5138
1922	8468	5821
1922	8468	5770
8985	8469	1269
8985	8469	3160
8985	8469	8723
8985	8469	3751
5432	8470	9804
5432	8470	4558
5432	8470	6175
5432	8470	3384
5432	8470	8759
9158	8471	3537
9158	8471	9804
9158	8471	4951
9158	8471	4872
9158	8471	4318
16137	8472	784
16137	8472	1901
16137	8472	250
16137	8472	4072
16137	8472	2516
16137	8472	3577
16137	8472	5977
9376	8473	5288
9376	8473	7176
9376	8473	9307
9376	8473	8350
9376	8473	5642
9376	8473	1692
9376	8473	4142
9376	8473	8864
9376	8473	3064
14269	8474	4590
14269	8474	6291
14269	8474	2235
14269	8474	5254
14269	8474	1534
17419	8475	757
17419	8475	1829
17419	8475	6156
17419	8475	658
17419	8475	5997
17419	8475	6341
17419	8475	8636
17419	8475	6195
1567	8476	1349
13204	8477	7142
13204	8477	2536
13204	8477	3292
13204	8477	7049
6408	8478	3502
19684	8479	8684
19684	8479	2678
19684	8479	675
19684	8479	2690
19684	8479	1489
19684	8479	8625
19684	8479	8809
19684	8479	2762
12105	8480	1173
19627	8481	4451
19627	8481	7283
19627	8481	3048
19627	8481	8039
19627	8481	8507
19627	8481	1692
19627	8481	737
18724	8482	5129
18724	8482	6331
18724	8482	9668
18724	8482	9552
18724	8482	5292
19929	8483	4508
19929	8483	3252
19929	8483	4181
19929	8483	3280
19929	8483	4
1482	8484	103
10463	8485	4048
10463	8485	2345
15272	8486	7601
15272	8486	8885
15272	8486	6236
15272	8486	9662
5883	8487	7912
5883	8487	4171
5883	8487	7048
5883	8487	5066
15371	8488	9973
15371	8488	7152
15371	8488	3455
15371	8488	6882
11533	8489	7903
11533	8489	8915
11533	8489	5766
11533	8489	4759
11533	8489	9003
11533	8489	9739
11533	8489	3204
11533	8489	8146
3240	8490	7439
3240	8490	5563
3240	8490	7655
19835	8491	8416
19835	8491	7935
19835	8491	7442
19835	8491	9348
19835	8491	7378
14232	8492	1920
14232	8492	7042
14232	8492	4165
14232	8492	6871
4865	8493	4877
4865	8493	4286
4865	8493	9556
4865	8493	9200
13283	8494	8842
13283	8494	7729
13283	8494	5684
13283	8494	4304
13283	8494	4674
13283	8494	2012
13283	8494	4647
13283	8494	442
13283	8494	1314
12381	8495	9278
16955	8496	5119
16955	8496	2126
16955	8496	4188
19744	8497	7475
19744	8497	9580
19744	8497	5494
19744	8497	8368
19744	8497	5589
19744	8497	8873
19744	8497	5872
19744	8497	1333
8098	8498	6797
8098	8498	3244
8098	8498	2706
8098	8498	8777
8098	8498	7303
8098	8498	4872
8098	8498	7415
5816	8499	8843
5816	8499	2314
5816	8499	5584
13834	8500	966
13834	8500	4790
13834	8500	5707
13834	8500	6685
13834	8500	5464
13834	8500	5048
13834	8500	6221
7270	8501	6543
7270	8501	4439
13504	8502	4938
13504	8502	9815
13504	8502	4239
18055	8503	7060
5046	8504	5289
5046	8504	4317
5046	8504	542
5046	8504	4640
18157	8505	5831
18157	8505	1947
18157	8505	2643
18157	8505	9039
18157	8505	2541
18157	8505	5909
18157	8505	5211
18157	8505	6309
18157	8505	5491
1558	8506	3611
1558	8506	1963
1558	8506	1528
7994	8507	9568
7994	8507	3926
7994	8507	6452
17985	8508	75
17985	8508	7967
17985	8508	7008
17985	8508	3378
17985	8508	4236
15692	8509	6096
15692	8509	4902
15293	8510	2338
15293	8510	9025
15293	8510	3472
15293	8510	7782
15293	8510	3114
15293	8510	3154
15293	8510	4238
15231	8511	4895
15231	8511	6618
15231	8511	6574
15231	8511	9868
15231	8511	6137
15231	8511	9122
15231	8511	3930
15231	8511	3227
13396	8512	7405
13396	8512	5885
13396	8512	5264
13396	8512	720
13396	8512	7738
13396	8512	8572
13396	8512	2218
13396	8512	9250
18234	8513	6232
18234	8513	6759
18234	8513	846
18234	8513	3116
8370	8514	8368
8370	8514	4646
8370	8514	5131
8370	8514	3432
4007	8515	7193
4007	8515	3222
4007	8515	3867
4007	8515	9135
11787	8516	5878
11787	8516	4813
11787	8516	7561
11787	8516	6648
2586	8517	6659
2586	8517	6942
2586	8517	4995
2586	8517	3302
13046	8518	10
5768	8519	6603
5768	8519	4792
4703	8520	8280
4703	8520	8689
4703	8520	8368
4703	8520	831
4703	8520	4219
4703	8520	7751
4703	8520	8012
10587	8521	1710
10587	8521	6937
10587	8521	8572
10587	8521	2209
5913	8522	352
18081	8523	4388
18081	8523	8277
18081	8523	8488
12997	8524	1792
7003	8525	7522
7003	8525	4700
19311	8526	9962
19311	8526	5765
15196	8527	261
15196	8527	5072
15196	8527	1835
15196	8527	5247
15196	8527	1368
15196	8527	9772
7790	8528	6590
7790	8528	7791
7790	8528	1106
7790	8528	4419
7790	8528	3514
7790	8528	5630
7790	8528	7782
7790	8528	2058
14257	8529	8327
19388	8530	5285
19388	8530	7271
19388	8530	7676
19388	8530	3486
9181	8531	5658
2574	8532	4447
2574	8532	6933
2574	8532	4234
2574	8532	4215
2574	8532	5760
2574	8532	2254
2574	8532	1196
2574	8532	4448
2574	8532	9573
6116	8533	7648
6116	8533	9761
6116	8533	2986
6116	8533	4592
6116	8533	9761
6116	8533	5138
6116	8533	2452
6116	8533	415
12348	8534	1008
12348	8534	1721
12348	8534	4147
12348	8534	7579
10334	8535	8697
10334	8535	5304
19792	8536	8934
19792	8536	2390
19792	8536	4223
19792	8536	8052
19792	8536	8979
19792	8536	335
4111	8537	3349
4111	8537	8839
4111	8537	8188
13768	8538	8566
13768	8538	4898
13768	8538	846
13768	8538	3133
13768	8538	5218
6539	8539	5807
6539	8539	5004
6539	8539	5897
6539	8539	6391
6539	8539	3466
3305	8540	8537
3305	8540	1645
3305	8540	3736
3305	8540	5383
3305	8540	374
3305	8540	7817
7712	8541	8874
7712	8541	3216
7712	8541	8693
7712	8541	4322
7712	8541	8357
7712	8541	312
7712	8541	9440
7712	8541	1943
7712	8541	8272
4015	8542	6589
8810	8543	8261
8810	8543	4219
8810	8543	9619
8810	8543	1011
8810	8543	6546
9804	8544	202
9804	8544	3391
9804	8544	536
9804	8544	5730
11716	8545	6360
4903	8546	7404
4903	8546	57
4903	8546	1544
16178	8547	2991
16178	8547	2432
16178	8547	2079
16178	8547	5336
16178	8547	7486
16178	8547	8228
16178	8547	6924
16178	8547	1415
12155	8548	9001
12155	8548	3351
12155	8548	160
12155	8548	125
12155	8548	2983
12155	8548	4220
12155	8548	6044
12155	8548	9166
12155	8548	2474
19920	8549	1116
19920	8549	3265
19920	8549	5774
19920	8549	8607
19920	8549	1855
19920	8549	4646
19920	8549	6665
19920	8549	100
19920	8549	298
9033	8550	1168
9033	8550	7480
9033	8550	2721
9033	8550	3601
9033	8550	7179
9033	8550	778
9033	8550	7246
9033	8550	3058
9033	8550	8059
5408	8551	7509
15612	8552	2323
6979	8553	7131
6979	8553	5279
6979	8553	1581
6979	8553	5447
6979	8553	2901
6979	8553	8911
6979	8553	8544
4007	8554	2128
18082	8555	9268
18082	8555	6852
18082	8555	799
18082	8555	5915
18082	8555	718
4596	8556	4657
4596	8556	6798
4596	8556	2509
4596	8556	536
417	8557	7390
417	8557	8513
417	8557	66
417	8557	9686
417	8557	6633
417	8557	4341
417	8557	8413
417	8557	3741
417	8557	7356
4025	8558	5580
4025	8558	3315
4025	8558	9830
4025	8558	6323
4025	8558	131
4025	8558	9760
4025	8558	6089
4025	8558	6425
6113	8559	5604
18687	8560	6735
18687	8560	5508
18687	8560	891
18687	8560	7128
13913	8561	1150
13913	8561	7236
13913	8561	3639
13913	8561	734
14950	8562	8557
14950	8562	26
14950	8562	8066
14950	8562	8193
14950	8562	4684
11148	8563	9780
11148	8563	9560
11148	8563	5513
5498	8564	6074
5498	8564	3340
5498	8564	9826
16764	8565	3079
2542	8566	4971
2542	8566	2575
2542	8566	6125
2542	8566	1747
2542	8566	6997
2542	8566	6393
2542	8566	9
12164	8567	1253
12164	8567	9710
12164	8567	8568
3292	8568	2917
3292	8568	1649
3292	8568	9706
3292	8568	7646
3292	8568	6576
7145	8569	208
7145	8569	5917
7145	8569	2742
7145	8569	3370
7145	8569	6462
7145	8569	5774
7145	8569	7970
7145	8569	6675
19183	8570	7479
19183	8570	8624
19183	8570	7825
19183	8570	4516
2336	8571	7828
2336	8571	9097
2336	8571	9437
2336	8571	4564
2336	8571	5546
2336	8571	928
2336	8571	8442
2336	8571	9622
2336	8571	7195
9346	8572	9797
9346	8572	9417
9346	8572	1068
9346	8572	5480
6616	8573	3878
6616	8573	8729
6616	8573	6809
6616	8573	8779
6616	8573	7790
6616	8573	5340
5067	8574	7206
5067	8574	8227
5067	8574	4956
5067	8574	1315
13590	8575	103
13590	8575	9260
13590	8575	6717
7051	8576	1262
7051	8576	8420
13668	8577	843
13668	8577	9
13668	8577	3343
13668	8577	6714
13668	8577	987
13668	8577	1452
13668	8577	5542
9603	8578	2790
9603	8578	1371
9603	8578	9152
9603	8578	5104
9603	8578	9233
9603	8578	4406
9603	8578	9350
9603	8578	4707
16097	8579	2705
8313	8580	5710
8313	8580	3920
8313	8580	9603
8313	8580	9196
8313	8580	1762
8313	8580	3605
8313	8580	5919
8313	8580	9432
8313	8580	1204
11820	8581	3959
11820	8581	922
11820	8581	7769
11820	8581	820
11820	8581	3616
11820	8581	155
11820	8581	7771
11820	8581	4245
11820	8581	731
8672	8582	7174
8672	8582	1556
14254	8583	7017
14254	8583	1682
14254	8583	4908
14254	8583	2436
14254	8583	7848
14254	8583	2256
14254	8583	3588
14254	8583	7760
14254	8583	6993
4612	8584	3538
4612	8584	9011
4612	8584	8376
4612	8584	2220
4612	8584	9316
4612	8584	908
4612	8584	7175
19221	8585	5662
19221	8585	6296
19221	8585	3825
19221	8585	7081
19221	8585	2545
19221	8585	3123
19221	8585	7626
19221	8585	5369
7489	8586	6407
7489	8586	3208
7489	8586	7043
7489	8586	3130
9344	8587	8470
9344	8587	4903
9344	8587	6133
9344	8587	3113
9344	8587	2901
9344	8587	4048
18833	8588	3161
18833	8588	8619
18833	8588	9940
18833	8588	6882
18833	8588	2207
4397	8589	7852
5509	8590	4737
5509	8590	7142
5509	8590	4795
5509	8590	8163
5509	8590	606
5509	8590	2336
5509	8590	9220
5509	8590	3335
432	8591	227
432	8591	7185
432	8591	867
432	8591	8063
432	8591	7792
5056	8592	165
5056	8592	9993
5056	8592	4552
5056	8592	3654
5056	8592	4366
5056	8592	7842
5056	8592	2032
5056	8592	7916
16285	8593	3052
16285	8593	7830
16285	8593	2849
9022	8594	3315
9022	8594	3556
9022	8594	6642
9022	8594	3907
9022	8594	4996
9022	8594	3168
9022	8594	5971
7773	8595	2029
7773	8595	1859
7773	8595	1805
7773	8595	6195
7773	8595	5310
7773	8595	9164
7773	8595	7511
7773	8595	1771
7773	8595	5787
19385	8596	7964
19385	8596	7006
19385	8596	7072
19385	8596	7821
19698	8597	4930
19698	8597	1078
12774	8598	9845
12774	8598	697
12774	8598	518
12774	8598	28
12774	8598	6175
12774	8598	3860
12774	8598	608
12774	8598	8073
11787	8599	5743
1343	8600	1795
1343	8600	9713
1343	8600	2390
6171	8601	9568
6171	8601	3396
6171	8601	9932
6171	8601	9881
15908	8602	3848
15908	8602	307
15908	8602	7055
15908	8602	261
15908	8602	5880
15908	8602	6344
15908	8602	5792
15908	8602	5149
15908	8602	1818
2772	8603	7129
2772	8603	3337
2772	8603	7989
2772	8603	4963
2772	8603	904
2772	8603	2545
19199	8604	1772
19199	8604	716
19199	8604	5236
19199	8604	6848
19199	8604	5488
19199	8604	6704
19199	8604	51
19199	8604	4254
15180	8605	9046
15180	8605	5866
15180	8605	7961
15180	8605	1160
15180	8605	8010
15180	8605	5021
15180	8605	4568
15180	8605	7896
15180	8605	2244
15463	8606	5904
15463	8606	1112
15463	8606	638
15463	8606	7748
15463	8606	2442
15463	8606	3977
15463	8606	6743
15804	8607	2825
15804	8607	4509
15804	8607	9054
15804	8607	7196
15804	8607	7148
1111	8608	4014
1111	8608	5091
1111	8608	8167
1111	8608	9478
1111	8608	9632
12748	8609	4276
12748	8609	363
12748	8609	7006
12748	8609	4493
12748	8609	7276
12748	8609	7357
12770	8610	1318
12770	8610	8729
12770	8610	3643
12770	8610	9247
17757	8611	5253
17757	8611	2056
17757	8611	5652
17757	8611	6629
17757	8611	7290
17757	8611	8716
12143	8612	2457
12143	8612	5225
7908	8613	850
7908	8613	9720
7908	8613	8308
7908	8613	4776
7908	8613	8257
7908	8613	3088
19432	8614	837
19432	8614	1104
19432	8614	1351
19432	8614	5527
19432	8614	4057
19432	8614	7582
15528	8615	7194
15528	8615	3910
15528	8615	9623
15528	8615	9061
15528	8615	5517
9532	8616	1306
9532	8616	3630
9532	8616	6347
9532	8616	2501
9532	8616	8788
9532	8616	2626
9532	8616	3569
9532	8616	4133
2652	8617	6827
2652	8617	5481
2652	8617	8012
2652	8617	8035
2652	8617	5763
2652	8617	8149
2652	8617	2600
17892	8618	820
17892	8618	8533
4203	8619	9282
4203	8619	7373
4203	8619	457
4203	8619	9925
4203	8619	86
4203	8619	6935
5393	8620	9764
5393	8620	7661
5393	8620	9564
5393	8620	1218
5393	8620	9965
5393	8620	3828
9205	8621	8264
9205	8621	924
1697	8622	8785
1697	8622	7702
1697	8622	4289
1697	8622	2402
1697	8622	6339
1697	8622	3294
1697	8622	4481
1697	8622	6285
1697	8622	4261
12223	8623	7244
12223	8623	9547
12223	8623	1699
12223	8623	9017
15601	8624	4320
15601	8624	2045
15601	8624	6291
15601	8624	6783
15601	8624	4285
15601	8624	4094
16709	8625	4466
16709	8625	6282
11657	8626	4871
6988	8627	9818
6988	8627	6617
6988	8627	7733
6988	8627	245
9059	8628	5098
9059	8628	4940
9059	8628	3520
9059	8628	1174
9059	8628	1114
9059	8628	5630
999	8629	3994
999	8629	427
999	8629	7591
999	8629	5674
999	8629	9952
999	8629	9839
11233	8630	7104
11233	8630	1324
11233	8630	3372
11233	8630	424
11233	8630	2044
3325	8631	7711
3325	8631	1938
3325	8631	4357
3325	8631	5181
3325	8631	4851
9378	8632	306
9378	8632	1941
9378	8632	569
9378	8632	8031
9378	8632	5762
9378	8632	8425
7803	8633	9262
2398	8634	727
2398	8634	5990
2398	8634	5628
2398	8634	267
2398	8634	8334
2398	8634	9804
746	8635	4313
746	8635	4465
746	8635	7104
746	8635	6639
746	8635	31
746	8635	3748
18125	8636	9558
18125	8636	3402
18125	8636	5523
18125	8636	8388
18125	8636	4240
18125	8636	4130
18125	8636	8564
18125	8636	8230
5390	8637	1667
5390	8637	640
5390	8637	8152
5390	8637	3332
1854	8638	4512
1854	8638	8194
1854	8638	145
8768	8639	6603
8768	8639	5687
8768	8639	6213
8768	8639	7527
8768	8639	6722
8768	8639	4079
8768	8639	891
8768	8639	1750
10399	8640	8208
12802	8641	2982
12802	8641	1559
12802	8641	1604
12802	8641	1091
12802	8641	2994
12802	8641	9942
12802	8641	9130
6417	8642	5439
5838	8643	3474
5838	8643	9637
5838	8643	5582
5838	8643	7680
5838	8643	2917
5838	8643	6317
5838	8643	7399
5838	8643	1810
5838	8643	4711
7680	8644	7049
4974	8645	5406
4974	8645	6033
4974	8645	8367
4974	8645	9383
4974	8645	5001
4974	8645	2511
17655	8646	6235
17655	8646	4091
17655	8646	5997
17655	8646	4785
3665	8647	4319
3665	8647	2916
3665	8647	4250
3665	8647	8603
3665	8647	4617
3665	8647	6564
3665	8647	5046
2689	8648	5043
2689	8648	4215
2689	8648	5080
2689	8648	4136
2689	8648	4623
2689	8648	1697
2689	8648	6624
2689	8648	6536
2689	8648	5740
8683	8649	2326
8683	8649	2723
8683	8649	9040
13881	8650	1076
13881	8650	2890
13881	8650	4652
13881	8650	6020
15433	8651	3732
15433	8651	2954
15433	8651	8067
15433	8651	3812
12275	8652	3508
12275	8652	7525
12275	8652	7412
12275	8652	5981
12275	8652	2190
12275	8652	4644
12275	8652	5895
5370	8653	6098
5370	8653	4143
5370	8653	1582
5370	8653	493
5370	8653	3677
5370	8653	1531
5370	8653	2307
19662	8654	7581
19662	8654	1481
19662	8654	2112
16013	8655	691
16013	8655	9587
16013	8655	7279
17721	8656	4254
17721	8656	1371
17721	8656	4725
17721	8656	823
17721	8656	3508
17721	8656	3299
9559	8657	904
9559	8657	1443
9559	8657	194
9559	8657	2859
274	8658	8998
274	8658	1094
274	8658	9063
274	8658	9036
274	8658	6141
19297	8659	737
19297	8659	2171
19297	8659	2704
19297	8659	9062
19297	8659	765
19297	8659	6280
19297	8659	9036
5089	8660	1992
5089	8660	6008
5089	8660	3520
19320	8661	9309
19320	8661	6326
19320	8661	2112
19320	8661	1639
19320	8661	1571
19320	8661	8962
19320	8661	9955
19320	8661	5959
19320	8661	443
810	8662	1461
810	8662	4580
810	8662	3526
810	8662	4640
7897	8663	3993
7897	8663	3176
7897	8663	8199
7897	8663	6331
7897	8663	7081
6078	8664	2757
6078	8664	3250
6078	8664	336
9830	8665	4336
9830	8665	5667
9830	8665	8279
9830	8665	7370
9830	8665	322
9830	8665	7902
9830	8665	5291
4744	8666	5411
4744	8666	927
4744	8666	2603
4744	8666	3399
4744	8666	8886
4744	8666	7853
4744	8666	4352
4744	8666	2906
2369	8667	3456
2369	8667	2793
2369	8667	5798
2956	8668	9561
2956	8668	1900
2956	8668	4033
2956	8668	4663
2956	8668	7440
2956	8668	4543
17788	8669	8912
17788	8669	6215
17788	8669	4604
17788	8669	3146
17788	8669	1027
13231	8670	2722
13231	8670	1798
13231	8670	469
13231	8670	9123
13231	8670	3261
13231	8670	8680
1609	8671	5835
1609	8671	1688
1609	8671	1476
1609	8671	1719
1609	8671	3687
1609	8671	3565
1609	8671	9361
1609	8671	5098
1609	8671	3968
8871	8672	9567
8871	8672	2387
8871	8672	3789
8871	8672	9050
8871	8672	3572
8871	8672	6093
15137	8673	2190
15137	8673	1398
15137	8673	4402
15137	8673	9741
15137	8673	2842
15137	8673	6394
15137	8673	8144
15137	8673	5371
15515	8674	1998
15515	8674	9377
15515	8674	9890
15515	8674	828
15515	8674	3038
15515	8674	5476
15515	8674	7615
15515	8674	982
15515	8674	7633
948	8675	19
948	8675	7027
948	8675	284
948	8675	3147
948	8675	1023
948	8675	1245
948	8675	712
948	8675	5869
17812	8676	4134
17812	8676	306
17812	8676	3546
17812	8676	5838
536	8677	2842
536	8677	3819
536	8677	2125
536	8677	9364
536	8677	2108
536	8677	3547
536	8677	1742
536	8677	4358
16547	8678	9804
16547	8678	7569
16547	8678	1375
19573	8679	8216
19573	8679	1371
6990	8680	6642
6990	8680	9612
6990	8680	3926
6990	8680	9603
6990	8680	1053
6990	8680	6557
6990	8680	377
6990	8680	7620
6990	8680	9710
16238	8681	9496
16238	8681	1540
16238	8681	9031
16238	8681	4361
16238	8681	184
19592	8682	1150
19592	8682	1344
19592	8682	8717
18186	8683	7038
18186	8683	2998
18186	8683	2089
18186	8683	3412
9902	8684	6131
9902	8684	5835
9902	8684	7813
9902	8684	6110
9902	8684	8032
9902	8684	9797
9902	8684	9460
9902	8684	7276
3072	8685	5506
3072	8685	3030
3072	8685	4624
3072	8685	9177
3072	8685	1392
15044	8686	3836
15044	8686	2007
15044	8686	5251
15044	8686	7204
15044	8686	9414
15044	8686	3560
15044	8686	2508
4710	8687	5201
4710	8687	1324
4710	8687	5278
4710	8687	3222
8848	8688	1461
6936	8689	3506
6936	8689	7108
1334	8690	1832
1334	8690	6700
1334	8690	1564
1334	8690	6475
3505	8691	8422
3505	8691	9369
3505	8691	6078
3505	8691	638
3505	8691	4297
15606	8692	723
15606	8692	2723
9108	8693	2193
9108	8693	8567
9108	8693	2617
9108	8693	420
9108	8693	5234
9108	8693	1520
15195	8694	485
15195	8694	699
8965	8695	104
8965	8695	8584
8965	8695	4764
8965	8695	6736
8965	8695	6476
8965	8695	5623
8965	8695	5592
8965	8695	5097
13233	8696	4214
13233	8696	8426
13233	8696	587
13233	8696	131
13233	8696	3607
13233	8696	6370
9905	8697	1700
9905	8697	9547
9905	8697	5817
2816	8698	2233
2816	8698	8981
2816	8698	2431
1713	8699	9981
1713	8699	7222
1713	8699	5640
1713	8699	7297
1713	8699	8544
1713	8699	6058
1713	8699	1591
1713	8699	8420
1713	8699	775
3973	8700	8082
1025	8701	1369
1025	8701	6332
1025	8701	6139
1025	8701	4936
1025	8701	7145
1025	8701	5245
1025	8701	3308
9796	8702	2305
9796	8702	38
9796	8702	9668
9796	8702	2166
1746	8703	8100
1746	8703	3463
1746	8703	978
1746	8703	7984
1746	8703	1379
13246	8704	7925
13246	8704	6351
17310	8705	9774
17310	8705	9225
8690	8706	9691
8690	8706	7817
8690	8706	5342
8690	8706	2754
8690	8706	4708
8690	8706	8454
8690	8706	755
8690	8706	4305
1312	8707	9311
1312	8707	8253
1312	8707	8202
1312	8707	1023
1312	8707	1823
1312	8707	6318
1312	8707	4746
174	8708	3413
174	8708	1553
174	8708	487
174	8708	1137
174	8708	987
174	8708	5448
174	8708	4272
5050	8709	3
5050	8709	6850
5050	8709	8700
5050	8709	3338
5050	8709	7301
5050	8709	3532
5050	8709	5425
5050	8709	7864
16701	8710	3142
16701	8710	7102
16701	8710	4766
16701	8710	3348
16701	8710	3898
16701	8710	4007
16701	8710	2054
16701	8710	5725
16701	8710	4024
2649	8711	1553
2649	8711	4673
2649	8711	9468
2649	8711	7767
2649	8711	3430
2649	8711	9020
2649	8711	9498
5689	8712	33
5689	8712	9703
5689	8712	3934
5689	8712	2839
5689	8712	4491
5689	8712	9281
1667	8713	250
1667	8713	2920
1667	8713	2266
1667	8713	8924
1667	8713	6880
1667	8713	5071
1667	8713	1265
1667	8713	4587
1667	8713	7219
2304	8714	9109
2304	8714	3258
2304	8714	5763
2304	8714	9223
2304	8714	7459
2304	8714	3327
11185	8715	6878
11185	8715	4831
11185	8715	2391
11185	8715	6090
11185	8715	7394
11185	8715	1266
1962	8716	5187
1962	8716	1958
1962	8716	8277
1962	8716	760
8172	8717	9678
8172	8717	4550
8172	8717	6447
8172	8717	8504
8172	8717	5477
8172	8717	5815
8172	8717	7901
8172	8717	3646
1289	8718	900
1289	8718	4197
1289	8718	9067
19437	8719	7858
4815	8720	1789
14529	8721	134
14529	8721	2044
14529	8721	8634
14529	8721	4424
14529	8721	3352
15095	8722	2504
15095	8722	1234
18183	8723	1499
18183	8723	4612
18183	8723	9318
18183	8723	552
1370	8724	4465
17777	8725	4212
17777	8725	1769
17777	8725	1120
17777	8725	8125
17121	8726	2862
17121	8726	1621
17121	8726	6230
17121	8726	1233
17121	8726	8627
17121	8726	7466
3860	8727	819
3860	8727	5812
15162	8728	1853
15162	8728	5415
15162	8728	427
6576	8729	761
6576	8729	6308
6576	8729	2812
6576	8729	1948
6576	8729	7522
5406	8730	5041
5406	8730	8056
5406	8730	7652
19008	8731	7174
19008	8731	2317
19008	8731	7379
19008	8731	6294
19008	8731	8149
1919	8732	1236
1919	8732	4748
18013	8733	9077
18013	8733	9781
18013	8733	6320
19967	8734	4074
19967	8734	4329
19967	8734	9717
19967	8734	9592
19447	8735	1803
13100	8736	5556
13100	8736	6370
13100	8736	4490
13100	8736	1361
15187	8737	999
15187	8737	8858
17148	8738	6439
17148	8738	5634
17148	8738	9927
17148	8738	5322
17148	8738	3986
17148	8738	9310
11359	8739	1830
11359	8739	4090
11359	8739	3128
8252	8740	9453
8252	8740	6495
8252	8740	1977
8252	8740	4570
8252	8740	8195
8252	8740	5045
8252	8740	235
8252	8740	2339
2258	8741	4410
2258	8741	8280
2258	8741	4859
7845	8742	1843
7845	8742	9194
7845	8742	386
9911	8743	9452
9911	8743	2979
9911	8743	2855
9911	8743	9230
9911	8743	6446
9911	8743	4170
9911	8743	1507
9911	8743	9354
9911	8743	3857
18778	8744	4375
18778	8744	467
3470	8745	1199
3470	8745	8828
3470	8745	8853
3470	8745	9494
3470	8745	3108
14555	8746	9727
14555	8746	407
14555	8746	8880
14555	8746	2972
14692	8747	2106
14692	8747	5025
14692	8747	1022
19698	8748	1531
19698	8748	7921
19698	8748	5832
19698	8748	1915
19698	8748	4499
19698	8748	8773
19698	8748	5224
19698	8748	5600
19698	8748	2393
4374	8749	8205
4374	8749	9466
4374	8749	2960
4374	8749	9075
4374	8749	292
4374	8749	3252
4374	8749	5243
14315	8750	8798
14315	8750	8072
14315	8750	8134
1052	8751	2713
1052	8751	5401
1052	8751	543
1052	8751	143
1052	8751	5320
1052	8751	6862
1052	8751	9823
10131	8752	2223
10131	8752	5659
10131	8752	1387
19040	8753	46
19040	8753	5012
19040	8753	3302
19040	8753	3675
19040	8753	5280
19040	8753	7347
19040	8753	3036
5716	8754	7923
291	8755	1166
291	8755	1914
291	8755	5329
291	8755	3463
291	8755	8811
291	8755	8132
291	8755	8888
291	8755	5956
6604	8756	7510
6604	8756	1518
6604	8756	1009
6604	8756	5346
6604	8756	9586
6604	8756	1716
6604	8756	5576
6604	8756	6957
839	8757	8894
839	8757	3866
19642	8758	3123
19642	8758	500
4034	8759	1458
4034	8759	2230
4034	8759	7575
4034	8759	1793
4034	8759	7575
4034	8759	4054
4034	8759	9169
4034	8759	2274
12278	8760	5960
18165	8761	9714
18165	8761	5312
18165	8761	892
6242	8762	7067
6242	8762	706
6242	8762	8353
6242	8762	5160
6242	8762	5090
6242	8762	5583
6242	8762	3572
19063	8763	8614
19063	8763	6873
19063	8763	5916
19063	8763	503
969	8764	8041
969	8764	6366
969	8764	1635
969	8764	3505
969	8764	2239
969	8764	4227
969	8764	8423
18412	8765	2785
18412	8765	2185
18412	8765	4271
18412	8765	1841
18412	8765	4907
18412	8765	5258
18412	8765	7554
18412	8765	1827
6923	8766	255
6923	8766	4143
6923	8766	8698
6923	8766	2280
6923	8766	1772
9111	8767	4212
9111	8767	6694
9111	8767	4595
9111	8767	6844
9111	8767	6434
9111	8767	3150
9111	8767	8317
9111	8767	1722
3953	8768	6458
3953	8768	7451
3953	8768	4474
3953	8768	8345
3953	8768	3777
15977	8769	4041
15977	8769	7769
15977	8769	8164
15977	8769	5282
15977	8769	2463
15977	8769	6508
14500	8770	2135
14500	8770	4912
14500	8770	1354
14500	8770	8807
14500	8770	267
14500	8770	3595
14500	8770	571
14500	8770	5912
7361	8771	7883
7361	8771	5101
7361	8771	4376
7361	8771	4528
1375	8772	3305
9315	8773	4356
9315	8773	1967
9315	8773	7617
9315	8773	5262
9315	8773	7149
9315	8773	7209
9315	8773	4672
9315	8773	3421
9315	8773	5436
19927	8774	651
7910	8775	8613
7910	8775	1193
6317	8776	5696
6317	8776	884
6317	8776	7064
6317	8776	5487
6317	8776	3183
6317	8776	1509
6317	8776	6704
18856	8777	5465
18856	8777	3187
18856	8777	6168
18856	8777	1590
18856	8777	4767
18856	8777	518
18856	8777	8686
18856	8777	1862
18856	8777	9056
9086	8778	3450
306	8779	9581
306	8779	7273
306	8779	2544
306	8779	4769
306	8779	2257
306	8779	6071
306	8779	7687
306	8779	2707
9136	8780	3494
9136	8780	6400
19698	8781	2
19698	8781	1945
19698	8781	9564
19698	8781	4628
18791	8782	5753
18791	8782	8955
3322	8783	6229
3322	8783	8133
3322	8783	9355
3322	8783	3876
3322	8783	4381
3322	8783	7702
19294	8784	8864
19294	8784	3248
8131	8785	954
8131	8785	7180
8131	8785	1086
8131	8785	706
17676	8786	3370
17676	8786	5897
7198	8787	3246
7198	8787	3824
7198	8787	4689
5351	8788	6416
5351	8788	543
3257	8789	8943
3257	8789	6062
3257	8789	5430
3257	8789	6889
3257	8789	7182
3257	8789	4925
3257	8789	680
9008	8790	1575
5422	8791	4801
5422	8791	2786
5422	8791	4215
5422	8791	8542
5422	8791	6703
5422	8791	9135
5422	8791	4034
5422	8791	3459
5422	8791	4019
9398	8792	9203
9398	8792	6041
9398	8792	7760
9398	8792	3488
9398	8792	8007
9398	8792	2391
13210	8793	9762
13210	8793	2750
13210	8793	3000
13210	8793	4920
13210	8793	7999
13210	8793	4842
13210	8793	3637
13210	8793	4469
1019	8794	9326
1019	8794	5791
1019	8794	5393
1019	8794	8125
1019	8794	4787
1019	8794	3146
11792	8795	2679
11792	8795	2615
11792	8795	7302
11792	8795	9205
11792	8795	8852
11792	8795	3778
14787	8796	4498
14787	8796	840
14787	8796	7040
14787	8796	4888
16067	8797	3930
16067	8797	567
16067	8797	8182
16067	8797	7285
12979	8798	163
12979	8798	6569
12979	8798	7592
12979	8798	7852
12979	8798	8495
12979	8798	1979
12979	8798	7656
12979	8798	7360
12979	8798	4899
17656	8799	5436
17656	8799	7068
17656	8799	7216
17656	8799	9210
18744	8800	3716
18744	8800	3399
18744	8800	3517
18744	8800	258
15827	8801	6823
15827	8801	8520
15827	8801	6087
15827	8801	4028
15827	8801	3803
2036	8802	4655
2036	8802	2826
2036	8802	9756
2036	8802	9918
6869	8803	8929
6869	8803	6279
6869	8803	7260
6869	8803	8548
6869	8803	3243
6869	8803	7849
6869	8803	6158
6869	8803	8366
14331	8804	3159
14331	8804	5815
14331	8804	3221
14331	8804	6068
14331	8804	9167
14331	8804	9694
14331	8804	3588
1694	8805	6626
1694	8805	2567
1694	8805	9587
1694	8805	6127
1694	8805	9126
1694	8805	5117
1694	8805	6120
1694	8805	9659
5757	8806	4207
5757	8806	8372
5757	8806	4928
5757	8806	9873
5757	8806	2806
5757	8806	2244
5757	8806	1263
1697	8807	8801
7834	8808	2193
7834	8808	6881
7834	8808	8176
7834	8808	639
7834	8808	1380
12615	8809	620
12615	8809	5101
12615	8809	3205
12615	8809	7674
12615	8809	7212
12615	8809	7142
11937	8810	915
11937	8810	4806
11937	8810	5502
11937	8810	2343
11937	8810	5364
11937	8810	5150
11937	8810	30
11937	8810	7800
11937	8810	9892
6192	8811	206
6192	8811	2394
12526	8812	5771
12526	8812	4534
12526	8812	2025
8733	8813	8088
8733	8813	567
8733	8813	7445
8733	8813	8766
8733	8813	1268
8733	8813	432
8733	8813	3462
8733	8813	7005
8733	8813	7983
2595	8814	5526
2595	8814	8465
2595	8814	6474
2595	8814	1917
2595	8814	944
2595	8814	3977
2595	8814	8122
2595	8814	9877
2288	8815	1675
2288	8815	9823
2288	8815	8481
2288	8815	8170
2288	8815	9103
2288	8815	8487
2288	8815	6512
2288	8815	2179
2288	8815	8975
19837	8816	1429
19837	8816	1032
19837	8816	9107
19837	8816	2449
19837	8816	8975
19837	8816	895
19837	8816	2802
19837	8816	6603
19837	8816	9974
16921	8817	5412
16921	8817	542
16921	8817	6609
16921	8817	4305
16921	8817	5790
16921	8817	2928
16921	8817	7038
18974	8818	3610
18974	8818	4380
18974	8818	574
18974	8818	7383
18974	8818	6688
18974	8818	9008
8838	8819	8806
8838	8819	2704
8838	8819	6851
8838	8819	8843
8838	8819	5314
8838	8819	1813
4235	8820	3317
4235	8820	5389
4235	8820	2867
4235	8820	4438
4235	8820	1200
4235	8820	6577
4235	8820	7864
4235	8820	3710
4235	8820	2254
18208	8821	8882
18208	8821	4502
18208	8821	2142
18208	8821	2812
18208	8821	8846
18208	8821	1532
18208	8821	18
18208	8821	7006
16409	8822	5388
18193	8823	5510
18193	8823	7997
18193	8823	829
18193	8823	635
18193	8823	7574
18193	8823	5199
18193	8823	2423
18193	8823	6513
18193	8823	8278
10567	8824	3488
10567	8824	2833
10567	8824	4646
14152	8825	9285
14152	8825	3896
14152	8825	3240
14152	8825	5444
1284	8826	4686
1284	8826	3683
1284	8826	4241
1284	8826	8247
1284	8826	4339
1284	8826	4109
1284	8826	609
1284	8826	6642
1284	8826	5830
10228	8827	5227
10228	8827	486
10228	8827	5420
10228	8827	1312
10228	8827	7520
10228	8827	4328
17136	8828	3793
17136	8828	8942
17136	8828	4746
17136	8828	6656
17136	8828	8131
17136	8828	6394
17136	8828	7600
5653	8829	3497
5653	8829	4423
5653	8829	4405
5653	8829	806
5653	8829	3145
5653	8829	7300
2185	8830	8994
2185	8830	5468
2185	8830	89
2185	8830	8134
2185	8830	3790
2185	8830	4243
13221	8831	4397
13221	8831	6864
15339	8832	7437
15339	8832	2457
15339	8832	5924
15339	8832	328
15339	8832	5114
15339	8832	566
17400	8833	4433
17400	8833	3118
17400	8833	2538
13869	8834	5736
13869	8834	9581
14034	8835	1428
14034	8835	8552
7331	8836	8868
7331	8836	8207
7331	8836	125
7331	8836	6481
7331	8836	5632
7331	8836	2928
7331	8836	5953
7331	8836	2591
7331	8836	7209
13784	8837	9031
13784	8837	7079
13784	8837	2370
19839	8838	6862
13973	8839	229
13973	8839	6165
13973	8839	2682
13973	8839	6758
13973	8839	3805
13973	8839	7443
13973	8839	858
19777	8840	7471
19777	8840	4913
19777	8840	9534
19777	8840	8834
19777	8840	4170
19777	8840	3382
19777	8840	6648
19777	8840	2543
19777	8840	6765
7043	8841	7488
7043	8841	7495
7043	8841	4568
7043	8841	8234
7043	8841	8204
7043	8841	1426
7043	8841	4423
7043	8841	3555
15448	8842	8264
1613	8843	6030
13051	8844	4463
13051	8844	463
17392	8845	4400
17644	8846	2078
17644	8846	5282
17644	8846	1317
17644	8846	4236
17644	8846	4353
17644	8846	6771
17644	8846	3596
18949	8847	2849
18949	8847	400
2483	8848	3509
2483	8848	5900
2483	8848	7983
2483	8848	7316
2483	8848	2809
2483	8848	6811
2483	8848	4294
2128	8849	2465
2128	8849	6565
2128	8849	9822
2128	8849	9966
2128	8849	4946
2128	8849	1463
2128	8849	9720
11238	8850	3596
11238	8850	3036
11238	8850	7654
11238	8850	3449
11238	8850	1009
11238	8850	3011
11238	8850	4033
11238	8850	1005
11238	8850	1459
2849	8851	4067
2849	8851	6319
2849	8851	7483
2849	8851	9406
2849	8851	7880
1831	8852	762
1831	8852	7811
1831	8852	9796
1831	8852	4322
1831	8852	6297
1831	8852	4424
8865	8853	9387
8865	8853	9714
8865	8853	7032
8865	8853	3814
8865	8853	6384
8865	8853	9438
8865	8853	2608
6738	8854	5139
6738	8854	9088
6738	8854	5318
6738	8854	4787
6738	8854	3139
6738	8854	4174
6738	8854	8142
6738	8854	5564
5191	8855	9032
5191	8855	4771
5191	8855	6027
12967	8856	4750
12967	8856	497
12967	8856	5346
12967	8856	9221
12967	8856	5556
12967	8856	1072
12967	8856	4677
12967	8856	3289
12967	8856	7069
4237	8857	3553
4237	8857	336
15296	8858	6654
15296	8858	4412
15296	8858	4649
15296	8858	2965
15296	8858	9889
15296	8858	6228
15296	8858	8250
15296	8858	174
14484	8859	9361
14484	8859	5845
14484	8859	121
14484	8859	2491
17106	8860	9365
8027	8861	7883
8220	8862	5014
8220	8862	8905
8220	8862	8856
8220	8862	136
8220	8862	2716
8220	8862	1128
8220	8862	2161
11978	8863	6472
11978	8863	7998
11978	8863	5549
11978	8863	4702
11978	8863	9071
11978	8863	7542
11978	8863	1187
183	8864	3087
11604	8865	8639
18749	8866	6536
18749	8866	7647
18749	8866	3553
18749	8866	3123
18749	8866	6627
18749	8866	2074
6521	8867	3352
6521	8867	5806
6521	8867	4284
6521	8867	2240
6521	8867	5323
18525	8868	5374
18525	8868	8527
18525	8868	1321
18525	8868	6217
18525	8868	333
18525	8868	6635
18525	8868	7012
18525	8868	5667
18525	8868	4164
19940	8869	4971
19940	8869	2565
19940	8869	8575
19940	8869	9556
9858	8870	7950
9858	8870	8347
9858	8870	1378
9858	8870	7009
9858	8870	1086
9858	8870	7350
3027	8871	1483
3027	8871	377
3027	8871	8923
3027	8871	6747
3027	8871	1605
3027	8871	6325
3027	8871	1231
18360	8872	3345
18360	8872	2639
18360	8872	8263
18360	8872	4374
4255	8873	9052
4255	8873	7474
4255	8873	5061
4255	8873	2369
4255	8873	3894
4255	8873	8109
18678	8874	8519
18678	8874	2893
18678	8874	1281
18678	8874	2217
18678	8874	9256
18678	8874	5155
18678	8874	8718
18678	8874	5979
18678	8874	887
11896	8875	7755
11896	8875	3539
11896	8875	3958
11896	8875	5202
11896	8875	5791
11896	8875	7144
11896	8875	5584
11896	8875	4214
11896	8875	7967
6242	8876	5400
6242	8876	876
6242	8876	2632
4959	8877	6220
4959	8877	5853
4959	8877	8033
4959	8877	6292
4959	8877	4775
4959	8877	2505
4959	8877	1859
4959	8877	8158
4959	8877	188
6777	8878	2568
6777	8878	4631
6777	8878	4604
6777	8878	7678
6777	8878	6854
6777	8878	3416
6777	8878	4076
6777	8878	3761
17069	8879	8892
17069	8879	4495
17069	8879	5485
17069	8879	9598
17069	8879	8070
17069	8879	6774
17069	8879	1784
12774	8880	8627
12774	8880	7412
12774	8880	7830
12774	8880	3491
17522	8881	6537
17522	8881	1318
17522	8881	6066
17522	8881	5713
17522	8881	5232
17522	8881	916
5399	8882	9086
15426	8883	9755
15426	8883	2670
9050	8884	182
9050	8884	5365
9050	8884	9573
9050	8884	8301
9050	8884	7094
9050	8884	9067
6973	8885	3743
6973	8885	629
6973	8885	7508
6973	8885	8695
6973	8885	2067
6973	8885	507
6973	8885	5889
6973	8885	4640
6973	8885	1054
1253	8886	5911
1253	8886	9404
1253	8886	6538
1253	8886	8464
1253	8886	3889
1253	8886	7041
9097	8887	1811
9097	8887	9777
9097	8887	2308
9097	8887	4830
9097	8887	1737
9097	8887	6951
9097	8887	6510
9097	8887	5177
9160	8888	9521
9160	8888	696
9160	8888	8067
9160	8888	7927
19754	8889	3894
19754	8889	6412
19754	8889	1641
19754	8889	3149
197	8890	8483
197	8890	6053
197	8890	2440
197	8890	8844
19077	8891	7275
19077	8891	5164
19077	8891	3174
19077	8891	3654
19077	8891	7335
19077	8891	3269
19077	8891	1306
16858	8892	2062
16858	8892	2894
16858	8892	392
16858	8892	1565
16858	8892	7292
5323	8893	5958
5323	8893	5607
5323	8893	4779
5323	8893	6198
5323	8893	9326
5323	8893	1089
6881	8894	8475
6881	8894	7395
6881	8894	9235
1600	8895	1676
1600	8895	6653
1600	8895	1844
1600	8895	3349
16256	8896	242
16256	8896	7404
16256	8896	6667
16256	8896	4771
16256	8896	5682
16256	8896	6846
16256	8896	4613
16256	8896	863
15768	8897	3679
15768	8897	8487
15768	8897	4567
15768	8897	2973
15768	8897	9964
15768	8897	4245
15768	8897	5719
15768	8897	1535
12612	8898	9551
8327	8899	5476
8327	8899	2438
8327	8899	6474
8327	8899	2737
8327	8899	1638
9221	8900	4293
9221	8900	6964
9221	8900	9503
9221	8900	2396
9221	8900	4804
9221	8900	5050
9221	8900	5462
12996	8901	4415
12996	8901	4773
12996	8901	1847
12996	8901	5848
5286	8902	9402
5286	8902	6277
5286	8902	2400
5286	8902	4864
5286	8902	213
5286	8902	5301
5286	8902	4022
5286	8902	4003
14593	8903	3027
14593	8903	2561
16817	8904	1052
16817	8904	2047
16817	8904	8842
16817	8904	6819
3363	8905	1349
3363	8905	9577
3363	8905	2098
3363	8905	7910
8885	8906	5747
8885	8906	8776
8885	8906	2000
8885	8906	8186
466	8907	8556
466	8907	3670
466	8907	2004
6704	8908	8723
6704	8908	126
6704	8908	2495
6704	8908	1075
6704	8908	4903
6704	8908	7116
18230	8909	2166
18230	8909	9801
18230	8909	6829
18230	8909	5992
18230	8909	1014
18230	8909	202
18230	8909	1347
18230	8909	4532
18230	8909	4380
13748	8910	398
13748	8910	4597
13748	8910	4239
13748	8910	6629
13748	8910	5546
13748	8910	9452
13748	8910	4464
909	8911	8449
909	8911	2701
909	8911	8221
909	8911	9864
909	8911	1889
15094	8912	8108
15094	8912	7385
15094	8912	4915
15094	8912	7398
15094	8912	2807
15094	8912	5807
15094	8912	3129
15094	8912	7725
15094	8912	4225
13850	8913	4157
13850	8913	7703
13850	8913	2397
13850	8913	3592
13850	8913	7047
8861	8914	8443
2499	8915	8519
2499	8915	6363
2499	8915	1326
2499	8915	2416
2499	8915	7512
2499	8915	3311
2499	8915	4216
13225	8916	3349
13225	8916	3005
14102	8917	8495
14102	8917	9357
14102	8917	7508
14102	8917	8208
14102	8917	4119
14102	8917	4457
14102	8917	7741
14102	8917	4919
18268	8918	5747
18268	8918	2656
11321	8919	2711
11321	8919	3260
11321	8919	8377
11321	8919	7992
11321	8919	491
9218	8920	1143
9218	8920	6178
9218	8920	4523
9218	8920	5195
1882	8921	36
1882	8921	9480
1882	8921	7480
1882	8921	5872
8496	8922	132
8496	8922	7586
6635	8923	6789
6635	8923	5658
6635	8923	85
6635	8923	7900
6635	8923	1793
6635	8923	5069
6635	8923	7067
6635	8923	9978
6635	8923	6739
267	8924	1521
267	8924	2484
267	8924	113
267	8924	2424
267	8924	534
267	8924	4477
267	8924	525
267	8924	7044
17672	8925	664
1284	8926	6492
1284	8926	2299
7639	8927	2926
7639	8927	2120
5308	8928	8845
5308	8928	176
5308	8928	3511
5308	8928	4724
5308	8928	6866
5308	8928	6903
3358	8929	1739
3358	8929	9110
3358	8929	576
7003	8930	8851
7003	8930	6395
7003	8930	9608
7003	8930	8499
4018	8931	8683
4018	8931	1239
4018	8931	4927
4018	8931	7264
4018	8931	9790
4018	8931	6141
13433	8932	218
18137	8933	2481
18137	8933	6436
15125	8934	3414
15125	8934	9474
15125	8934	7256
15125	8934	1921
15125	8934	3784
15125	8934	3523
15125	8934	610
10872	8935	3121
10872	8935	5927
10872	8935	23
10872	8935	6088
10872	8935	9388
10872	8935	4020
10872	8935	3998
6941	8936	7871
6941	8936	5823
18690	8937	2309
18690	8937	1760
18690	8937	5079
18690	8937	5160
18690	8937	9681
18690	8937	9413
17600	8938	1176
17600	8938	3092
17600	8938	394
17600	8938	6525
17600	8938	9182
17600	8938	9918
2994	8939	9717
2994	8939	333
2994	8939	7862
2994	8939	5800
10425	8940	4013
10425	8940	7973
10425	8940	3160
7105	8941	1817
7105	8941	9281
7105	8941	319
7105	8941	3231
7105	8941	4973
7105	8941	4521
7105	8941	7742
7083	8942	8754
7083	8942	3784
3511	8943	2820
3511	8943	6183
3511	8943	5297
9154	8944	5550
9154	8944	6341
9154	8944	5910
9154	8944	5826
9154	8944	3244
6337	8945	6404
6337	8945	8711
6337	8945	3631
6337	8945	8505
6337	8945	5026
6337	8945	5510
19982	8946	4792
19982	8946	5381
19982	8946	970
13590	8947	3418
13590	8947	8406
13590	8947	8080
13590	8947	3386
13590	8947	683
18375	8948	3875
18375	8948	8801
18375	8948	8967
18375	8948	8978
18375	8948	4148
18375	8948	4890
18375	8948	5650
18375	8948	1912
10657	8949	6838
447	8950	7240
447	8950	5204
447	8950	9527
447	8950	9681
447	8950	5638
447	8950	2027
12348	8951	1291
12348	8951	4178
12348	8951	5215
12348	8951	8531
12348	8951	6823
12348	8951	8744
12348	8951	5592
5662	8952	3536
5662	8952	2453
5662	8952	5238
5662	8952	1864
8536	8953	1562
8536	8953	6302
3032	8954	9456
3032	8954	1828
3032	8954	1014
3032	8954	4536
3032	8954	250
3032	8954	2560
10024	8955	3102
10024	8955	1333
10024	8955	3133
10024	8955	7485
7573	8956	5303
7573	8956	3888
7573	8956	1327
7573	8956	2956
7573	8956	3135
7573	8956	1525
7573	8956	9413
16488	8957	2313
16488	8957	3036
16488	8957	8004
16488	8957	8415
15826	8958	5341
15826	8958	3763
10179	8959	7430
10179	8959	9782
10179	8959	1461
17260	8960	2801
17260	8960	4333
4672	8961	7824
4672	8961	9722
10124	8962	4290
10124	8962	3011
10124	8962	3299
10124	8962	7310
10124	8962	9394
10124	8962	2275
10124	8962	7400
10124	8962	4567
17798	8963	1235
17798	8963	4666
17798	8963	902
10120	8964	2981
10120	8964	8840
10120	8964	2971
10120	8964	6432
10120	8964	5218
10120	8964	9051
10120	8964	8258
10120	8964	7204
13331	8965	9522
13331	8965	723
13331	8965	2015
16343	8966	6003
16343	8966	1760
16343	8966	5657
16343	8966	6979
16343	8966	5010
16343	8966	7913
16343	8966	9689
16343	8966	510
14319	8967	9845
1134	8968	2191
1134	8968	3860
1134	8968	3860
1134	8968	8540
1134	8968	4703
1134	8968	350
10718	8969	9419
10718	8969	366
10718	8969	458
10718	8969	7088
13864	8970	7499
13864	8970	9438
13864	8970	197
13864	8970	8564
14206	8971	1299
14206	8971	9543
14206	8971	5385
14206	8971	1777
14206	8971	6986
14206	8971	4731
14206	8971	1502
14206	8971	1458
17102	8972	2910
17102	8972	5939
17102	8972	8061
17102	8972	7163
17102	8972	1606
17102	8972	9079
17241	8973	2041
17241	8973	7051
17241	8973	4403
11807	8974	7481
11807	8974	6478
11807	8974	8600
11807	8974	7571
11807	8974	2493
11807	8974	9041
11807	8974	6849
11807	8974	6494
6715	8975	5605
6715	8975	6294
6715	8975	5614
6715	8975	4437
16073	8976	387
16073	8976	6887
16073	8976	5874
16073	8976	3525
5132	8977	3212
5132	8977	2863
5132	8977	7872
5132	8977	795
5132	8977	3998
5132	8977	6133
5132	8977	7784
8765	8978	8462
8765	8978	8191
8129	8979	2431
8129	8979	4070
14562	8980	4042
14562	8980	7099
14562	8980	6316
14562	8980	1924
14562	8980	707
14562	8980	3016
14562	8980	4090
14562	8980	4104
14562	8980	613
17183	8981	95
17183	8981	7596
17183	8981	9241
17183	8981	1445
17183	8981	4112
17183	8981	7046
17183	8981	322
4491	8982	1953
4491	8982	5414
4491	8982	445
2115	8983	9649
2115	8983	4198
2115	8983	6958
2115	8983	3908
2115	8983	6216
2115	8983	405
14901	8984	811
14901	8984	3406
10717	8985	1401
10717	8985	1788
10717	8985	6945
13186	8986	6337
489	8987	5597
489	8987	9019
489	8987	2776
489	8987	7595
489	8987	4401
489	8987	206
489	8987	6359
489	8987	3530
10634	8988	8916
10634	8988	5072
10634	8988	4922
10634	8988	9406
10634	8988	1652
10634	8988	6090
10634	8988	9653
10634	8988	3683
2555	8989	2278
17271	8990	6394
17271	8990	169
17271	8990	1880
17271	8990	8384
17271	8990	9765
18341	8991	3498
6300	8992	5578
3185	8993	7813
3185	8993	3131
3185	8993	3802
3185	8993	3081
3185	8993	3670
4106	8994	5359
4106	8994	1989
4106	8994	277
15069	8995	8475
15069	8995	2318
15069	8995	5806
15069	8995	5186
15069	8995	8897
5397	8996	6669
5397	8996	1337
5397	8996	3562
5397	8996	2540
5397	8996	3514
5397	8996	4981
15670	8997	2589
15670	8997	2863
15670	8997	490
15670	8997	4853
15670	8997	2286
15670	8997	3992
15670	8997	6448
15670	8997	1961
6594	8998	6544
6594	8998	5820
6594	8998	9906
6594	8998	3847
6594	8998	8636
6594	8998	8569
6594	8998	4970
10918	8999	1135
10251	9000	6956
10251	9000	4298
1490	9001	1697
1490	9001	5227
1490	9001	2409
1490	9001	7020
1490	9001	2166
1490	9001	5555
1490	9001	2850
10911	9002	5711
10911	9002	9041
10911	9002	4408
4550	9003	3020
4550	9003	3550
4550	9003	4226
4550	9003	9580
4550	9003	5002
4550	9003	4635
378	9004	3704
378	9004	5354
378	9004	4909
378	9004	6855
378	9004	1119
378	9004	2226
378	9004	3537
378	9004	5220
378	9004	2237
12926	9005	3097
15463	9006	7920
15463	9006	4397
15463	9006	6402
15463	9006	977
15463	9006	816
3868	9007	1317
3868	9007	1658
3868	9007	9186
3868	9007	5306
3868	9007	357
3868	9007	1308
3868	9007	5400
10228	9008	9719
10228	9008	728
10228	9008	7402
10228	9008	7431
10228	9008	9535
10228	9008	151
10228	9008	175
10228	9008	1258
10228	9008	8003
6617	9009	6160
6617	9009	9535
6617	9009	964
6617	9009	6673
6617	9009	9824
6617	9009	1869
18541	9010	7488
18541	9010	2633
18541	9010	417
18541	9010	9105
18541	9010	4638
18541	9010	2117
18541	9010	416
18541	9010	6444
18541	9010	5223
12372	9011	404
12372	9011	1199
12372	9011	7072
12372	9011	1543
12372	9011	3653
12570	9012	9091
12570	9012	3206
10644	9013	8338
10644	9013	9872
10644	9013	6513
6421	9014	9731
13605	9015	6128
13605	9015	2993
13605	9015	7658
13605	9015	8773
3957	9016	7301
3957	9016	1609
3957	9016	5103
3957	9016	9199
3957	9016	9485
3957	9016	4826
3957	9016	9095
3957	9016	6307
8055	9017	5401
8055	9017	4728
8055	9017	8133
8055	9017	9808
8055	9017	5479
8055	9017	1879
8055	9017	4853
19909	9018	1570
19909	9018	6561
19909	9018	6749
19909	9018	951
19909	9018	7172
19909	9018	7084
19909	9018	9794
9043	9019	8022
9043	9019	2822
9043	9019	5635
9043	9019	6279
9043	9019	8188
9043	9019	442
9043	9019	2311
9043	9019	7607
9043	9019	8405
18711	9020	1664
18711	9020	4349
10944	9021	4728
10944	9021	7870
10944	9021	7500
7557	9022	8474
1568	9023	9656
1568	9023	5552
5926	9024	7457
5926	9024	7323
5926	9024	5701
5926	9024	6955
5926	9024	7303
5926	9024	7977
451	9025	662
451	9025	6749
451	9025	7838
14985	9026	1674
15108	9027	7783
15108	9027	5855
5617	9028	7632
5617	9028	832
5617	9028	2112
5617	9028	8277
5617	9028	6466
5617	9028	7025
4945	9029	3473
4945	9029	8488
4945	9029	1023
4945	9029	8856
4945	9029	2016
4945	9029	2287
12394	9030	8083
12394	9030	1109
12394	9030	7016
12394	9030	2967
12394	9030	4410
5247	9031	8873
5247	9031	3046
5247	9031	3372
5247	9031	3950
5247	9031	2873
5247	9031	6937
5247	9031	6708
5247	9031	1356
5247	9031	9605
1427	9032	99
1427	9032	1580
1427	9032	2591
1427	9032	7131
1427	9032	8941
1427	9032	990
1427	9032	3364
1427	9032	6055
17854	9033	4086
17854	9033	7978
17854	9033	3465
17854	9033	4880
9026	9034	7112
9026	9034	2902
9026	9034	3590
9026	9034	4756
9026	9034	6036
9026	9034	4517
9026	9034	106
9026	9034	6713
19980	9035	9975
19980	9035	9026
19980	9035	5777
19980	9035	7988
1270	9036	4862
1270	9036	5233
1270	9036	5400
1270	9036	983
1270	9036	5733
11676	9037	2530
11676	9037	7537
11676	9037	9153
11676	9037	940
11676	9037	951
11676	9037	2085
11676	9037	788
6507	9038	8621
6507	9038	2887
6507	9038	1252
6507	9038	5457
12584	9039	3840
12584	9039	1007
12584	9039	8098
12584	9039	8888
12584	9039	8338
844	9040	925
844	9040	9794
844	9040	2785
844	9040	8221
844	9040	2435
844	9040	9540
17816	9041	4346
17816	9041	4629
17816	9041	9398
17816	9041	5512
17816	9041	1764
17816	9041	8124
17816	9041	4272
17816	9041	4057
17816	9041	5251
16070	9042	3706
6491	9043	2154
6491	9043	5578
6491	9043	4796
6491	9043	1851
6491	9043	2933
6491	9043	2479
1205	9044	7503
1205	9044	680
1205	9044	118
1205	9044	788
1205	9044	3204
6095	9045	9348
6095	9045	6443
6095	9045	6391
6095	9045	5132
6095	9045	5431
6095	9045	5605
6095	9045	2760
6095	9045	8512
6095	9045	2301
5961	9046	5812
5961	9046	3738
1634	9047	487
1634	9047	1679
16139	9048	6311
16139	9048	9530
4578	9049	7260
16997	9050	9854
16997	9050	4358
16997	9050	8840
16997	9050	4408
16997	9050	194
3744	9051	9942
3744	9051	113
3744	9051	3590
3744	9051	8167
3744	9051	1932
3744	9051	5117
3744	9051	7930
3744	9051	7689
15086	9052	1134
11084	9053	437
11084	9053	782
11084	9053	2466
11084	9053	2253
11084	9053	6975
11084	9053	2221
11084	9053	940
11084	9053	2039
11084	9053	3343
2064	9054	8575
2064	9054	3470
2064	9054	4279
11570	9055	9604
11570	9055	7948
11570	9055	2599
11570	9055	4647
11570	9055	6042
11570	9055	4713
13502	9056	6719
13502	9056	5395
13502	9056	3404
13502	9056	2301
13159	9057	2364
13159	9057	4613
13159	9057	2030
13159	9057	4036
13159	9057	2760
13159	9057	4201
13159	9057	5550
13159	9057	5781
13159	9057	5664
4765	9058	1009
4765	9058	295
4765	9058	9337
4765	9058	9889
4765	9058	2898
4765	9058	8549
1158	9059	5207
1158	9059	6937
1158	9059	1630
1158	9059	8320
1158	9059	9056
1158	9059	6228
1158	9059	6366
1158	9059	6315
13219	9060	581
13219	9060	5483
13219	9060	2826
13219	9060	989
13219	9060	4610
13219	9060	5299
13219	9060	3889
11036	9061	2928
11036	9061	1528
11036	9061	3765
11036	9061	4443
11036	9061	5268
11036	9061	6689
11036	9061	9281
9526	9062	8794
9526	9062	6396
9526	9062	2796
9526	9062	3221
9526	9062	3930
9526	9062	2202
9526	9062	9988
9526	9062	2427
9526	9062	4284
17453	9063	920
17453	9063	628
17453	9063	229
17453	9063	4963
17453	9063	6505
5800	9064	4595
5800	9064	2193
5800	9064	2825
5800	9064	7174
5800	9064	9523
7614	9065	2534
7614	9065	8409
7614	9065	5023
7614	9065	3653
17231	9066	2372
17231	9066	5593
17231	9066	4450
13283	9067	1036
13283	9067	5550
13283	9067	5485
2553	9068	3339
2553	9068	351
2553	9068	1055
2553	9068	3612
2553	9068	2618
2553	9068	9938
2553	9068	8780
6458	9069	9871
6458	9069	7172
6458	9069	313
6458	9069	1464
11656	9070	2726
11656	9070	8226
11656	9070	8773
11656	9070	7079
11656	9070	6525
11656	9070	2224
2008	9071	4233
2008	9071	3641
2008	9071	2139
2008	9071	5009
2008	9071	3534
2008	9071	8248
2008	9071	2300
2008	9071	2339
2008	9071	5732
9009	9072	6890
9009	9072	4875
9009	9072	2833
9009	9072	117
9009	9072	8766
4813	9073	3219
4813	9073	7125
4813	9073	9932
4813	9073	2884
4813	9073	692
12847	9074	928
12847	9074	536
12847	9074	2001
12847	9074	6930
12847	9074	4970
7471	9075	6142
7471	9075	6869
7986	9076	9365
7986	9076	5470
7986	9076	4217
6	9077	5634
6	9077	5225
6	9077	4029
6	9077	2469
6	9077	9200
6	9077	2733
6	9077	4322
2380	9078	5183
2380	9078	6985
2380	9078	3340
2380	9078	4604
2167	9079	8491
2167	9079	1881
2167	9079	829
6594	9080	5424
6594	9080	5663
6594	9080	6513
6594	9080	935
6594	9080	9851
13671	9081	9290
13671	9081	9988
13671	9081	6351
9684	9082	8557
9684	9082	5520
9684	9082	4867
9684	9082	9494
9684	9082	8064
9684	9082	36
9684	9082	1261
9684	9082	9322
9684	9082	7087
15502	9083	3019
15502	9083	1705
15502	9083	8376
15502	9083	4212
15502	9083	9046
15502	9083	686
15502	9083	7193
13373	9084	1843
13373	9084	7629
13373	9084	6846
7866	9085	1684
7866	9085	9396
2200	9086	535
2200	9086	4524
2200	9086	1051
2200	9086	4145
2200	9086	761
13204	9087	2479
13204	9087	9876
13204	9087	6766
13204	9087	3257
13204	9087	6250
13204	9087	8331
13204	9087	9643
7429	9088	1997
7429	9088	6859
7429	9088	504
7429	9088	1290
7429	9088	138
7429	9088	7866
7429	9088	2991
5732	9089	6955
5732	9089	1035
5732	9089	7866
5732	9089	8850
5732	9089	4728
5732	9089	1222
5732	9089	2873
5732	9089	793
5732	9089	6266
15111	9090	3774
13529	9091	9631
13529	9091	4247
13529	9091	3364
13529	9091	9790
13529	9091	4646
18747	9092	4872
18747	9092	3178
18747	9092	6837
18747	9092	6961
18747	9092	6999
18747	9092	8446
18747	9092	9947
18747	9092	7537
18747	9092	6984
2461	9093	6511
2461	9093	5748
2461	9093	2180
2461	9093	531
2461	9093	4443
15240	9094	7063
8122	9095	4833
8122	9095	8015
8122	9095	8212
8122	9095	9536
8122	9095	6229
8122	9095	3886
19266	9096	4117
19266	9096	5420
19266	9096	9828
19266	9096	6179
19266	9096	9291
19266	9096	8921
19266	9096	7302
19266	9096	3587
19266	9096	3964
4351	9097	1543
4351	9097	7327
4351	9097	5569
4351	9097	5061
18355	9098	7737
18355	9098	7520
18355	9098	4612
18355	9098	7156
18355	9098	4027
18355	9098	2
18355	9098	6592
18355	9098	9216
11631	9099	8645
11631	9099	3111
11631	9099	6617
11631	9099	3677
11631	9099	7348
11631	9099	8363
11631	9099	1285
11793	9100	9430
11793	9100	613
11793	9100	4332
11793	9100	3397
11793	9100	8300
11793	9100	9363
16014	9101	2220
11792	9102	3463
11792	9102	932
11792	9102	6536
11792	9102	644
11792	9102	6086
11792	9102	5947
558	9103	3826
558	9103	2437
558	9103	5635
3059	9104	4040
3059	9104	9310
3059	9104	4334
3059	9104	6983
7037	9105	2747
7037	9105	8235
7037	9105	7980
7037	9105	8973
7037	9105	638
7037	9105	4083
7037	9105	5987
7037	9105	2730
5431	9106	1201
5431	9106	1616
5431	9106	2677
5431	9106	800
5431	9106	2118
9728	9107	3558
9728	9107	4328
9728	9107	7138
9728	9107	5328
9728	9107	8040
9728	9107	937
4366	9108	7469
4366	9108	8995
4366	9108	219
4366	9108	7683
4366	9108	1866
4366	9108	7013
4366	9108	4664
4366	9108	6813
4366	9108	9547
13368	9109	7904
13368	9109	7393
13368	9109	4914
13368	9109	1024
13368	9109	4979
13368	9109	3082
6600	9110	4318
6600	9110	5059
6600	9110	7732
6600	9110	5620
6600	9110	7943
17386	9111	4771
17386	9111	5934
1693	9112	9243
1693	9112	8111
1693	9112	7004
1693	9112	5624
1693	9112	945
1693	9112	159
1693	9112	1271
1693	9112	5726
1693	9112	2434
16235	9113	9907
16235	9113	3661
16235	9113	9296
16235	9113	6686
11857	9114	8253
11857	9114	5670
11857	9114	29
11857	9114	3818
11857	9114	2618
11857	9114	8077
11857	9114	1979
11857	9114	2012
11857	9114	8628
17068	9115	4373
17068	9115	3858
11461	9116	5714
11461	9116	5902
11461	9116	9115
11461	9116	7997
11461	9116	6116
11461	9116	8021
11461	9116	8958
11461	9116	4702
6658	9117	1863
6658	9117	3579
14872	9118	3166
14872	9118	4309
14872	9118	9519
14872	9118	262
14872	9118	6140
14872	9118	1566
19172	9119	9585
19172	9119	8798
19172	9119	4478
19172	9119	5596
19172	9119	982
19172	9119	2575
19172	9119	6610
19172	9119	4411
17439	9120	8930
17439	9120	2300
17439	9120	7175
17439	9120	7324
7542	9121	4920
7542	9121	6655
7542	9121	6813
15588	9122	6418
15588	9122	8180
15588	9122	7810
15588	9122	9547
15588	9122	5994
15588	9122	5380
15588	9122	3545
15588	9122	2159
11220	9123	8645
11220	9123	5151
11220	9123	8956
9385	9124	3004
9385	9124	7006
9385	9124	7001
9385	9124	3511
9385	9124	1278
9385	9124	5024
9385	9124	7798
9385	9124	9212
9385	9124	9436
8151	9125	3634
8151	9125	9510
8151	9125	7401
8151	9125	7282
571	9126	1468
571	9126	7850
571	9126	6877
3800	9127	468
3800	9127	2238
3800	9127	2809
6193	9128	8535
6193	9128	202
6193	9128	8583
6193	9128	3091
6193	9128	7769
6193	9128	7648
6193	9128	6750
7252	9129	5526
7252	9129	978
7252	9129	5406
7252	9129	5897
7252	9129	1019
7252	9129	1311
7252	9129	7487
7252	9129	4557
6278	9130	7751
6278	9130	5290
6278	9130	2178
6278	9130	895
6278	9130	5665
6278	9130	5090
6278	9130	5928
6278	9130	7183
6158	9131	2954
880	9132	8129
880	9132	1029
880	9132	5351
880	9132	6241
880	9132	4178
880	9132	2678
880	9132	4810
880	9132	592
13038	9133	7852
13038	9133	9794
13038	9133	5550
13038	9133	8256
13038	9133	3187
13038	9133	6773
13038	9133	5438
1575	9134	1427
8210	9135	2447
8210	9135	3983
8210	9135	2941
8210	9135	8694
16976	9136	1236
8844	9137	5737
8844	9137	4202
8844	9137	1627
8844	9137	1208
8844	9137	1540
8844	9137	7159
19211	9138	1585
19211	9138	8495
19211	9138	7524
19211	9138	8767
19211	9138	4439
19211	9138	2160
19211	9138	4424
19211	9138	469
9341	9139	5453
13985	9140	4363
16310	9141	4887
16310	9141	1707
946	9142	475
946	9142	6005
12946	9143	1144
12946	9143	6273
12946	9143	7290
12946	9143	3588
12946	9143	9592
12946	9143	6255
3131	9144	5371
5737	9145	4805
5737	9145	1811
19311	9146	5901
19311	9146	9042
19311	9146	5022
19311	9146	1526
2235	9147	554
2235	9147	3641
18023	9148	1880
18023	9148	8585
18023	9148	552
18023	9148	7494
18023	9148	50
18023	9148	2440
18023	9148	3202
16445	9149	6831
16445	9149	767
16445	9149	5709
16445	9149	6054
16445	9149	2738
16445	9149	8361
16445	9149	6767
16445	9149	3760
16445	9149	6924
8835	9150	9193
8835	9150	1746
8835	9150	7197
8835	9150	617
8835	9150	9517
8835	9150	8643
8702	9151	3700
8702	9151	6600
8702	9151	1066
8702	9151	2299
8702	9151	8718
8702	9151	9136
8702	9151	3640
5666	9152	5227
5666	9152	1872
2778	9153	1672
2778	9153	3327
2778	9153	1018
2778	9153	7614
2778	9153	9086
2778	9153	984
2778	9153	3505
2778	9153	608
2778	9153	4165
8846	9154	6427
8846	9154	8506
8846	9154	8150
2880	9155	5567
2880	9155	4632
4491	9156	925
4491	9156	8641
4491	9156	4886
4491	9156	7068
4491	9156	3496
4491	9156	3474
4491	9156	5300
7611	9157	2646
924	9158	1606
924	9158	4623
924	9158	6120
924	9158	7031
924	9158	4009
924	9158	1472
924	9158	4919
924	9158	7945
2835	9159	1317
2835	9159	9764
2835	9159	2905
2835	9159	7400
2835	9159	2871
2835	9159	3416
16077	9160	6863
16077	9160	3680
16077	9160	6952
16077	9160	9765
16077	9160	3691
16077	9160	284
18545	9161	1145
8097	9162	9425
8097	9162	3999
8097	9162	9828
8097	9162	879
8097	9162	1151
8097	9162	5359
8097	9162	8612
16753	9163	6086
16753	9163	8021
16753	9163	3736
16753	9163	5655
11225	9164	2970
13936	9165	1483
13936	9165	136
13936	9165	9812
13936	9165	7465
13936	9165	7805
13936	9165	6800
5769	9166	8096
5769	9166	7467
5769	9166	5062
5769	9166	9363
5769	9166	6746
5769	9166	2341
5769	9166	9300
5769	9166	9035
5769	9166	5604
10831	9167	3839
1276	9168	3523
1276	9168	8581
1276	9168	1082
1276	9168	5368
1276	9168	1913
1276	9168	132
1276	9168	7062
1276	9168	1635
1276	9168	6006
3220	9169	7026
1728	9170	1502
1728	9170	9207
1728	9170	2327
1728	9170	6642
1728	9170	3835
1728	9170	9552
1728	9170	6740
1728	9170	4406
1728	9170	2156
16324	9171	9772
16324	9171	7864
16324	9171	1054
16324	9171	7661
16324	9171	9066
16324	9171	9454
16324	9171	4187
1656	9172	2838
1656	9172	5642
1656	9172	4423
1656	9172	3378
1656	9172	6087
1656	9172	4741
1656	9172	844
1656	9172	9344
1656	9172	1309
17938	9173	8132
17938	9173	5347
17938	9173	9658
17938	9173	3146
17938	9173	1302
17938	9173	9585
17938	9173	5560
17874	9174	2477
17874	9174	5871
17874	9174	9838
2293	9175	115
16493	9176	564
16493	9176	3863
16493	9176	6417
12003	9177	9
12003	9177	4187
12003	9177	2172
12003	9177	5920
12003	9177	9984
4020	9178	2045
4020	9178	2904
4020	9178	5265
4020	9178	1610
4020	9178	6387
4020	9178	9537
4020	9178	636
4020	9178	8804
17625	9179	9407
17625	9179	5328
17625	9179	2051
17625	9179	1084
17625	9179	7321
17625	9179	4176
17625	9179	5006
17625	9179	8520
260	9180	5602
260	9180	1085
260	9180	4863
260	9180	8980
260	9180	8701
260	9180	8005
260	9180	4827
260	9180	3433
9033	9181	2504
9033	9181	5330
9033	9181	3438
9033	9181	7780
9033	9181	3979
9033	9181	3614
9396	9182	4586
9396	9182	3716
9396	9182	5616
9396	9182	1393
9651	9183	9342
9651	9183	9660
9651	9183	5862
9651	9183	9355
14269	9184	1013
14269	9184	2397
14269	9184	2943
15058	9185	816
15058	9185	337
15058	9185	9069
15058	9185	7034
15058	9185	9085
15058	9185	5890
15058	9185	8221
15058	9185	3734
5142	9186	5387
5142	9186	3927
5142	9186	6247
5142	9186	5998
5142	9186	4399
5142	9186	9764
201	9187	5490
201	9187	3093
201	9187	829
201	9187	3319
201	9187	733
201	9187	6624
201	9187	9623
10019	9188	2793
10019	9188	8259
5314	9189	7870
5314	9189	4312
5314	9189	2143
5314	9189	9745
1147	9190	9623
1147	9190	4746
1147	9190	6733
1147	9190	7578
1147	9190	9378
1147	9190	5585
1147	9190	7932
4759	9191	6591
4759	9191	4197
4759	9191	9661
4759	9191	704
4759	9191	1574
4759	9191	9979
4759	9191	2773
4759	9191	741
14946	9192	1669
14946	9192	8057
14946	9192	3435
14946	9192	1097
15195	9193	1968
15195	9193	5861
15195	9193	3689
15195	9193	1034
15195	9193	1643
8832	9194	1934
8832	9194	9267
1870	9195	8189
1870	9195	3928
1870	9195	2916
1870	9195	6883
1870	9195	7253
1870	9195	3421
1870	9195	478
1870	9195	9678
2642	9196	5737
2642	9196	5219
2642	9196	9595
2642	9196	1491
13152	9197	5097
13152	9197	2893
13152	9197	3640
13152	9197	4082
15004	9198	4612
15004	9198	612
15004	9198	5005
15004	9198	409
15004	9198	6269
15004	9198	8411
15004	9198	112
15004	9198	5340
15004	9198	6478
3147	9199	9585
3147	9199	1808
864	9200	9534
864	9200	6324
864	9200	2763
6342	9201	8798
6342	9201	5409
6342	9201	380
6342	9201	4442
6342	9201	3506
6342	9201	8430
6342	9201	5614
6342	9201	5349
6342	9201	1681
5697	9202	8628
5697	9202	7532
5697	9202	4273
5697	9202	4561
5697	9202	356
5697	9202	6820
5697	9202	2267
13417	9203	290
11806	9204	3325
11806	9204	6957
11806	9204	5029
7313	9205	5046
7313	9205	6905
7313	9205	7138
7313	9205	2964
7313	9205	3025
7313	9205	1156
10423	9206	7697
10423	9206	8131
10423	9206	157
14228	9207	693
14228	9207	9063
14228	9207	7294
14228	9207	8013
14228	9207	3715
13356	9208	1908
13356	9208	4021
13356	9208	5474
13356	9208	6074
13356	9208	759
1831	9209	8029
1831	9209	7152
12428	9210	322
12428	9210	982
12428	9210	9099
12428	9210	714
12428	9210	6924
12428	9210	8467
12428	9210	6468
5083	9211	6746
5083	9211	6194
5083	9211	222
5083	9211	697
5083	9211	2944
17760	9212	2829
17760	9212	7945
17760	9212	391
17760	9212	133
17198	9213	2539
17198	9213	289
17198	9213	8057
17198	9213	8126
17198	9213	9440
17198	9213	8473
17198	9213	5720
18614	9214	3216
18614	9214	5243
18614	9214	5052
18614	9214	9819
18614	9214	2948
18614	9214	3783
18614	9214	8847
18270	9215	6170
18270	9215	6288
9520	9216	6175
9520	9216	7469
9520	9216	3360
9520	9216	9595
9520	9216	1845
9520	9216	4236
9520	9216	9830
9520	9216	2762
3215	9217	743
3215	9217	4407
3215	9217	9999
4880	9218	602
4880	9218	4333
4880	9218	8099
4880	9218	8754
4880	9218	6295
4880	9218	2339
4880	9218	2261
4880	9218	7713
12199	9219	8469
12199	9219	1619
12199	9219	4283
12199	9219	3569
12199	9219	4057
12199	9219	5069
18802	9220	7093
18802	9220	6443
18802	9220	2080
18802	9220	3917
18802	9220	950
18802	9220	9362
18802	9220	7729
18802	9220	2446
8129	9221	5682
8129	9221	4447
8129	9221	1663
8129	9221	4396
8129	9221	8916
8129	9221	1063
8129	9221	8606
1369	9222	5025
1369	9222	4941
1369	9222	3966
12824	9223	477
12824	9223	1381
12824	9223	576
12824	9223	5895
581	9224	7414
581	9224	267
581	9224	3118
581	9224	6704
3456	9225	6114
3456	9225	581
3456	9225	7016
3456	9225	227
3456	9225	7382
3456	9225	3650
3456	9225	7436
3456	9225	196
9494	9226	360
9494	9226	3268
9494	9226	6963
9494	9226	2880
9494	9226	1699
9494	9226	7848
9494	9226	122
14275	9227	4630
14275	9227	6137
14275	9227	3214
14275	9227	7823
14275	9227	6350
6771	9228	688
6771	9228	1993
6771	9228	8145
6771	9228	7586
6771	9228	4391
6771	9228	7656
6771	9228	3861
6771	9228	1650
12557	9229	4557
12557	9229	6193
12557	9229	3612
3534	9230	283
3534	9230	3116
3534	9230	4266
3534	9230	7148
3534	9230	1104
17517	9231	715
17517	9231	2878
19735	9232	70
19735	9232	914
19735	9232	8556
19735	9232	5448
19735	9232	5893
19735	9232	1098
19735	9232	8005
19735	9232	269
2743	9233	130
2743	9233	5641
2743	9233	437
2743	9233	8045
2743	9233	8386
16911	9234	2136
16911	9234	4810
16911	9234	6917
16911	9234	3314
2637	9235	6470
2637	9235	1349
2637	9235	5086
2637	9235	5897
2637	9235	2323
2637	9235	9246
2637	9235	747
2637	9235	8233
2637	9235	6086
16444	9236	5806
16444	9236	3064
16444	9236	9474
5699	9237	3439
5699	9237	66
5699	9237	5578
5699	9237	9251
5699	9237	2296
5699	9237	8268
5699	9237	6127
4425	9238	435
4425	9238	6649
4425	9238	4615
4425	9238	5359
11591	9239	2703
11591	9239	9335
11591	9239	8899
11591	9239	8731
11591	9239	2812
2159	9240	7579
2159	9240	4985
2159	9240	5090
3476	9241	1450
3476	9241	8044
3476	9241	2812
3476	9241	9170
17009	9242	3417
17009	9242	2404
17009	9242	8038
17009	9242	7308
9771	9243	1074
9771	9243	2223
9771	9243	9736
9771	9243	4371
9771	9243	897
9771	9243	5120
9771	9243	7394
5497	9244	7003
5497	9244	4515
5497	9244	2439
5497	9244	8454
5497	9244	4658
5497	9244	4631
5497	9244	7079
18603	9245	3183
18603	9245	6483
18603	9245	2903
18603	9245	7788
18603	9245	5892
17372	9246	4896
14669	9247	7080
14669	9247	8180
14669	9247	3802
14669	9247	7414
14669	9247	4560
14669	9247	4662
14669	9247	4021
14669	9247	1822
19217	9248	6618
19217	9248	7324
19217	9248	309
19217	9248	155
19217	9248	9554
19217	9248	7667
19217	9248	7969
19217	9248	8344
11514	9249	9289
11514	9249	3408
11514	9249	6939
11514	9249	233
11514	9249	4837
11514	9249	8322
11292	9250	7866
11292	9250	7783
11292	9250	4470
11292	9250	4052
11292	9250	1296
11292	9250	4209
11292	9250	8152
11292	9250	8066
2945	9251	6701
2945	9251	7760
2945	9251	8433
2945	9251	2991
2945	9251	1727
2945	9251	4167
2945	9251	8310
2945	9251	7011
2125	9252	3458
2125	9252	1094
2125	9252	4769
2125	9252	9051
2125	9252	632
2125	9252	3981
2125	9252	783
2125	9252	8869
3718	9253	7432
3718	9253	9139
3718	9253	1477
3718	9253	8520
3718	9253	7211
3718	9253	7568
3718	9253	3164
3718	9253	2278
3718	9253	7820
16901	9254	5783
16901	9254	9557
16901	9254	1126
16901	9254	6510
16901	9254	6924
16901	9254	6013
16901	9254	9681
16901	9254	2210
18842	9255	89
18842	9255	2592
18842	9255	3033
18842	9255	3693
9641	9256	6731
9641	9256	9294
9641	9256	1620
9641	9256	4342
9641	9256	9744
18848	9257	7624
18848	9257	6235
18848	9257	8138
18848	9257	4663
18848	9257	8689
18848	9257	1140
18848	9257	4566
18505	9258	3496
18505	9258	1788
18505	9258	9740
18505	9258	3658
16524	9259	5076
16524	9259	8534
16524	9259	6092
16524	9259	7633
12643	9260	8703
12643	9260	8539
12643	9260	2267
12643	9260	9837
12643	9260	7119
12643	9260	877
12643	9260	7754
12643	9260	6341
10495	9261	1778
10495	9261	9182
10495	9261	3767
10495	9261	8624
10495	9261	3136
10495	9261	9704
10495	9261	87
10495	9261	7743
15160	9262	9204
15160	9262	5401
15160	9262	3527
15160	9262	1194
15160	9262	6989
15160	9262	4194
15160	9262	6853
15160	9262	6636
10518	9263	2332
10518	9263	5162
10518	9263	9730
2307	9264	9696
2307	9264	1880
2307	9264	6646
15679	9265	7596
15679	9265	2594
15679	9265	9298
15679	9265	5068
13703	9266	8340
13703	9266	9237
13703	9266	876
13703	9266	9223
13703	9266	6896
13703	9266	1048
13703	9266	4015
1705	9267	4680
1705	9267	1832
1705	9267	7577
1705	9267	6501
1705	9267	615
1705	9267	9495
15668	9268	5903
15668	9268	1051
15668	9268	3630
15668	9268	4043
15668	9268	6722
15668	9268	2371
15668	9268	8910
7178	9269	861
7178	9269	9772
7178	9269	1252
7178	9269	8350
7178	9269	3810
7178	9269	8581
7178	9269	3199
7178	9269	7475
2208	9270	5782
2208	9270	1708
2208	9270	9819
2208	9270	6056
14173	9271	5694
14173	9271	2428
14173	9271	5430
14173	9271	7692
14173	9271	6934
263	9272	4381
263	9272	3022
17606	9273	6955
17606	9273	6337
17606	9273	1943
17606	9273	96
17606	9273	5609
17606	9273	2260
15379	9274	6929
2743	9275	3289
2743	9275	7815
2743	9275	6836
2743	9275	5113
2743	9275	7548
2743	9275	7642
2743	9275	5077
10345	9276	963
7395	9277	4124
7395	9277	2632
7395	9277	5046
7395	9277	8275
7395	9277	8769
7395	9277	4644
7395	9277	7917
10928	9278	9348
10928	9278	5159
10928	9278	2072
10928	9278	3809
10928	9278	1014
10928	9278	6731
1709	9279	1676
1709	9279	9906
17350	9280	4280
17350	9280	9216
17350	9280	9420
17350	9280	7789
17350	9280	7938
17350	9280	2541
17350	9280	4904
17350	9280	3043
17350	9280	8229
13986	9281	8389
13986	9281	1594
13986	9281	2255
13986	9281	6970
13986	9281	5868
10165	9282	6121
10165	9282	437
5955	9283	9327
5955	9283	5019
5955	9283	6883
5955	9283	4548
5955	9283	3810
5955	9283	9814
5955	9283	1231
5955	9283	1811
5955	9283	362
5222	9284	4280
5222	9284	4161
5222	9284	2938
14009	9285	4113
14009	9285	4574
14009	9285	1176
14009	9285	8506
14009	9285	2059
14009	9285	387
14009	9285	387
1497	9286	3359
15277	9287	2354
15277	9287	6368
15277	9287	1457
15277	9287	7065
15277	9287	6306
15277	9287	6565
15277	9287	761
15277	9287	2466
5704	9288	5049
5704	9288	4524
5704	9288	8536
5704	9288	7559
18147	9289	3527
18147	9289	7921
18147	9289	589
18147	9289	553
18147	9289	6624
18147	9289	4375
18147	9289	2188
18147	9289	204
12624	9290	3909
12624	9290	9665
12624	9290	1759
12624	9290	4829
12624	9290	6297
19645	9291	4806
19645	9291	8059
19645	9291	9466
7681	9292	681
7681	9292	241
7681	9292	8583
7681	9292	5113
7681	9292	3470
10457	9293	2508
10457	9293	4986
10457	9293	8119
10457	9293	736
10457	9293	9540
10457	9293	8283
10457	9293	3477
10457	9293	2846
10457	9293	5422
11325	9294	5255
11325	9294	8889
11325	9294	3789
11325	9294	3953
11325	9294	3589
11325	9294	4085
4407	9295	5128
4407	9295	3651
4407	9295	4088
4407	9295	4168
4407	9295	2672
973	9296	6884
973	9296	3369
973	9296	9231
973	9296	9597
6369	9297	1759
6369	9297	9234
6369	9297	8624
6369	9297	2384
6369	9297	7770
6369	9297	9402
6369	9297	3405
7729	9298	8222
7729	9298	7284
7729	9298	5216
7729	9298	8747
7729	9298	9697
7729	9298	7997
7729	9298	8722
15911	9299	2316
15911	9299	4004
6811	9300	5479
6811	9300	3181
6811	9300	325
6811	9300	7483
6811	9300	2992
6811	9300	4122
6811	9300	7510
6811	9300	3431
6811	9300	3160
12532	9301	7996
12532	9301	1757
12532	9301	2508
9060	9302	8078
16805	9303	6011
16805	9303	9103
16805	9303	6297
16805	9303	3951
16805	9303	2118
16805	9303	1880
3974	9304	4410
3974	9304	3370
17550	9305	9659
17550	9305	6269
17550	9305	7927
17550	9305	4986
17550	9305	2394
17550	9305	4070
16040	9306	5130
16040	9306	197
16040	9306	2284
13386	9307	3610
13386	9307	2021
13386	9307	6566
5668	9308	670
5668	9308	6446
5668	9308	9332
62	9309	2849
6089	9310	2936
6089	9310	9444
6089	9310	5290
14620	9311	8988
14620	9311	4140
9619	9312	7872
9619	9312	2159
1386	9313	4357
1386	9313	9746
1386	9313	3015
1386	9313	8570
1386	9313	6960
1386	9313	5512
1386	9313	1169
313	9314	9403
313	9314	1955
313	9314	3156
313	9314	7716
313	9314	9452
313	9314	6008
313	9314	8270
16032	9315	698
16032	9315	4985
16032	9315	9318
971	9316	642
971	9316	9510
971	9316	1943
10197	9317	413
10197	9317	3222
2984	9318	9508
2984	9318	2028
2984	9318	9133
2984	9318	7862
2984	9318	7508
2984	9318	8936
2984	9318	9583
2984	9318	2056
2984	9318	9622
7119	9319	5213
7119	9319	2589
5157	9320	2080
5157	9320	6387
5157	9320	9640
15002	9321	4721
15002	9321	252
15002	9321	2481
15002	9321	3394
15002	9321	6305
15002	9321	5662
15002	9321	5795
15002	9321	4908
1673	9322	3549
1673	9322	8670
1673	9322	7148
1673	9322	5455
1673	9322	5810
1673	9322	6894
1673	9322	2327
1673	9322	4832
1673	9322	9453
11513	9323	1157
11513	9323	3446
11513	9323	6352
14624	9324	353
15000	9325	5767
15000	9325	5261
15000	9325	5308
15000	9325	9806
15000	9325	2396
15000	9325	8366
1080	9326	8509
1080	9326	2235
1080	9326	8079
1080	9326	2171
1080	9326	9584
1080	9326	728
19393	9327	4475
19393	9327	8451
19393	9327	8655
19393	9327	9922
19393	9327	7514
19393	9327	357
4469	9328	7558
4469	9328	2194
4469	9328	69
4469	9328	5705
4469	9328	6888
4469	9328	9621
4469	9328	6129
1206	9329	385
1206	9329	9406
13840	9330	9448
13840	9330	8789
13840	9330	4755
13840	9330	9080
13840	9330	1982
13840	9330	1314
16402	9331	5112
16402	9331	3847
16402	9331	849
16402	9331	8962
16402	9331	5487
16402	9331	1541
16402	9331	5287
16402	9331	8240
14056	9332	3374
14056	9332	9257
14056	9332	1110
19821	9333	8332
19821	9333	7406
19821	9333	1694
19821	9333	2518
19821	9333	9488
19821	9333	9022
19821	9333	9689
15856	9334	4956
15856	9334	1023
15856	9334	3887
15856	9334	3685
15856	9334	850
15856	9334	4906
15856	9334	3885
15856	9334	3504
10393	9335	5852
10393	9335	5936
10393	9335	59
10393	9335	9183
10393	9335	3553
10393	9335	9935
10393	9335	151
10393	9335	6837
1043	9336	7247
1043	9336	1709
10423	9337	408
10423	9337	522
10423	9337	996
2108	9338	2274
4416	9339	3165
4416	9339	2728
4416	9339	1501
4416	9339	6490
4416	9339	5698
4416	9339	9879
4416	9339	3409
4416	9339	5462
11966	9340	2440
11966	9340	6313
11966	9340	1522
11966	9340	155
11966	9340	793
7916	9341	8361
7916	9341	3239
17872	9342	1809
17872	9342	7700
17872	9342	273
17872	9342	3253
17872	9342	7222
7068	9343	2120
7068	9343	3138
7068	9343	4664
19879	9344	6715
19879	9344	80
19879	9344	5543
19879	9344	7637
19879	9344	9582
19708	9345	202
19708	9345	3566
19708	9345	8055
19708	9345	4833
19708	9345	4146
19708	9345	3087
19708	9345	9860
19708	9345	8749
10926	9346	7699
10926	9346	8393
10926	9346	2730
10926	9346	673
10926	9346	7829
16059	9347	9786
16059	9347	2566
16059	9347	722
16059	9347	2589
16059	9347	5521
16059	9347	3765
16059	9347	5677
16059	9347	9732
14861	9348	2767
14861	9348	584
14861	9348	970
12385	9349	4981
12385	9349	4451
12385	9349	846
12385	9349	4258
19556	9350	4047
19556	9350	1697
19556	9350	7071
15922	9351	1580
15922	9351	7413
15922	9351	7518
15922	9351	8742
7443	9352	1268
7443	9352	2350
7443	9352	4465
7443	9352	5302
7443	9352	4075
7443	9352	1906
7443	9352	3126
8669	9353	8309
11443	9354	4544
11443	9354	790
11443	9354	3528
11443	9354	4447
11443	9354	2007
11443	9354	319
11443	9354	8125
4400	9355	7971
4400	9355	7700
4400	9355	2429
4400	9355	9861
4400	9355	3152
4400	9355	6459
4400	9355	6004
4400	9355	4024
15102	9356	2346
15102	9356	9513
15102	9356	6248
6132	9357	1790
6132	9357	1349
6132	9357	7463
14647	9358	6497
14647	9358	1492
14647	9358	1975
14647	9358	9293
14647	9358	3066
14647	9358	2964
14647	9358	6838
6170	9359	6151
6170	9359	9614
6170	9359	7760
6170	9359	7429
6170	9359	4739
6170	9359	2545
18083	9360	1542
1669	9361	7896
1669	9361	4309
1669	9361	7885
1669	9361	7818
1669	9361	8744
1669	9361	7950
1669	9361	1908
1669	9361	9318
1669	9361	931
6952	9362	2517
6952	9362	33
6952	9362	5732
6952	9362	4893
6952	9362	4764
6952	9362	3585
6952	9362	7521
6952	9362	1456
6952	9362	9467
14833	9363	3126
14833	9363	551
2878	9364	1154
2878	9364	8769
2878	9364	4107
2878	9364	7052
2878	9364	2676
12521	9365	7730
12521	9365	4646
12521	9365	2544
12521	9365	4613
12521	9365	5166
12521	9365	8971
12521	9365	1794
12521	9365	7155
12521	9365	6134
9805	9366	9402
9805	9366	2479
9805	9366	8362
9805	9366	8339
12135	9367	3264
12135	9367	2168
12135	9367	5236
12135	9367	5614
12135	9367	3050
12135	9367	5105
12135	9367	6733
12135	9367	8513
16013	9368	4553
16013	9368	7620
16013	9368	6329
16013	9368	2165
16013	9368	2026
10578	9369	3165
17558	9370	6187
5839	9371	9026
5839	9371	7389
5839	9371	5362
5839	9371	675
5839	9371	4856
5839	9371	8940
5839	9371	6902
5839	9371	778
5839	9371	6254
18836	9372	8197
18836	9372	3582
18836	9372	1583
10524	9373	5082
10524	9373	4939
10524	9373	3164
10524	9373	3425
10524	9373	2616
10524	9373	5039
11633	9374	4490
11633	9374	9000
11633	9374	2752
11633	9374	5436
11633	9374	1580
11633	9374	785
11633	9374	2280
11633	9374	5209
11633	9374	5842
18011	9375	7025
18011	9375	3592
13840	9376	6502
13840	9376	2263
13840	9376	8664
8197	9377	1116
8197	9377	3158
8197	9377	6750
8197	9377	756
17118	9378	9787
17118	9378	2646
17118	9378	685
17118	9378	298
13599	9379	2301
13599	9379	243
13599	9379	3695
13599	9379	9274
13599	9379	3720
940	9380	3062
940	9380	7520
940	9380	3579
940	9380	3279
940	9380	684
940	9380	6763
940	9380	2527
940	9380	7780
940	9380	4958
10399	9381	6789
10399	9381	1562
10399	9381	6783
10399	9381	979
10399	9381	8728
10399	9381	6888
10399	9381	8697
3950	9382	5938
3950	9382	5216
3950	9382	3183
3950	9382	1924
9959	9383	1730
9959	9383	2505
9959	9383	636
9959	9383	3058
9959	9383	6866
9959	9383	5653
9959	9383	8032
9959	9383	4220
1821	9384	4364
1821	9384	726
1821	9384	4030
14211	9385	5259
14211	9385	9152
14211	9385	2648
14211	9385	7050
14211	9385	1400
14211	9385	7491
14211	9385	7669
14211	9385	1401
14211	9385	7105
5847	9386	3958
5847	9386	4709
5847	9386	3360
5847	9386	5093
5847	9386	9418
5847	9386	344
5847	9386	8114
10326	9387	9078
10326	9387	6808
10326	9387	1709
10326	9387	8633
10326	9387	5933
10326	9387	1737
10326	9387	8593
10326	9387	6629
10326	9387	3681
17548	9388	9125
17548	9388	1682
17548	9388	4311
6016	9389	9195
6016	9389	8224
13714	9390	8288
13761	9391	182
13761	9391	3274
13761	9391	9602
17453	9392	5965
17453	9392	8708
17453	9392	2885
17453	9392	9844
17453	9392	5101
17453	9392	2984
17453	9392	4924
17453	9392	647
14608	9393	590
14608	9393	2129
3460	9394	456
3460	9394	9809
17033	9395	7017
17033	9395	8521
17033	9395	2697
17033	9395	2025
17033	9395	4205
17033	9395	833
1849	9396	1198
10695	9397	6486
10695	9397	6216
10695	9397	393
10357	9398	9808
10357	9398	3944
11937	9399	8640
17227	9400	9178
17227	9400	242
17227	9400	8426
17227	9400	6142
17227	9400	7731
17227	9400	1205
17227	9400	2128
17227	9400	3301
6217	9401	5613
6217	9401	7755
12787	9402	5007
12787	9402	6996
12787	9402	1655
12787	9402	7788
12787	9402	997
12787	9402	4992
12787	9402	6286
12787	9402	6849
299	9403	3258
17740	9404	4607
17740	9404	5986
17740	9404	7412
17740	9404	9877
17740	9404	5177
17740	9404	1645
17740	9404	1611
17740	9404	6893
17740	9404	1368
16432	9405	8366
16432	9405	5061
16432	9405	8167
16432	9405	493
16432	9405	6493
4957	9406	3472
4957	9406	7982
4957	9406	7807
4957	9406	1612
17008	9407	1683
17008	9407	1851
17008	9407	3826
17008	9407	1618
19568	9408	7077
19568	9408	7429
19568	9408	4757
16455	9409	6875
16455	9409	4422
16455	9409	7329
16455	9409	6991
16455	9409	324
4347	9410	2389
4347	9410	4877
4347	9410	3348
4347	9410	6557
4347	9410	2940
4347	9410	3664
956	9411	5274
956	9411	5830
956	9411	1285
956	9411	6385
956	9411	6507
956	9411	6948
956	9411	8881
956	9411	4662
19075	9412	200
19075	9412	6228
19075	9412	6038
19075	9412	836
19075	9412	369
19075	9412	1770
15200	9413	759
14530	9414	5937
14530	9414	4959
14530	9414	8579
14530	9414	136
14530	9414	3219
14530	9414	6127
4329	9415	6016
4329	9415	1069
4329	9415	5347
4329	9415	5386
12288	9416	3409
18691	9417	9943
18691	9417	9026
4488	9418	1689
4488	9418	9086
4488	9418	8196
4488	9418	730
4488	9418	2888
4488	9418	9890
4488	9418	6759
18325	9419	9995
18325	9419	7171
18325	9419	211
18325	9419	4856
18325	9419	7192
18325	9419	1480
18325	9419	2572
18325	9419	1491
19371	9420	8949
19371	9420	999
19371	9420	7920
19371	9420	199
19371	9420	6919
13826	9421	5049
13826	9421	4445
13826	9421	191
13826	9421	5554
13826	9421	9240
13826	9421	4838
13826	9421	9783
13084	9422	6189
13084	9422	8203
13084	9422	2709
13084	9422	6444
13084	9422	547
13084	9422	6540
13084	9422	3937
13084	9422	2246
13084	9422	1492
14092	9423	5171
14092	9423	9986
14092	9423	7975
14092	9423	1496
14092	9423	9766
14092	9423	6880
14092	9423	1793
14092	9423	6370
14092	9423	9215
11509	9424	7343
11509	9424	7158
11509	9424	2888
11509	9424	5881
11509	9424	6431
11509	9424	5937
11509	9424	6005
11509	9424	6817
13165	9425	4550
13165	9425	2305
13165	9425	5213
107	9426	8831
107	9426	6492
107	9426	3451
107	9426	3163
107	9426	6373
107	9426	382
12772	9427	3886
12772	9427	9408
12772	9427	4775
14160	9428	8599
14160	9428	1313
286	9429	6132
286	9429	4621
286	9429	3270
286	9429	8886
286	9429	3302
19043	9430	1580
19043	9430	2993
19043	9430	1084
19043	9430	3434
4066	9431	7906
4066	9431	1753
15768	9432	7178
15768	9432	8277
15768	9432	9254
15768	9432	958
15768	9432	1100
15768	9432	3214
15768	9432	5804
13774	9433	2847
13774	9433	4499
13774	9433	7153
17811	9434	6789
17811	9434	8883
14318	9435	8737
14318	9435	7277
14318	9435	9663
14318	9435	2516
14318	9435	6696
14318	9435	2353
14318	9435	4014
14318	9435	7484
9272	9436	3542
9272	9436	7254
9272	9436	4845
9272	9436	4297
9272	9436	3296
9272	9436	1564
17682	9437	9331
17682	9437	441
17682	9437	5932
17682	9437	7968
17682	9437	7993
9418	9438	363
9418	9438	1089
9418	9438	3958
9418	9438	3753
9418	9438	9510
9418	9438	2580
9418	9438	9080
9418	9438	9915
9418	9438	2866
6613	9439	6099
6613	9439	1208
19331	9440	9040
19331	9440	2405
19331	9440	6779
19331	9440	6061
19331	9440	4617
19331	9440	7579
19331	9440	6644
19331	9440	5088
15906	9441	1259
15906	9441	4202
15906	9441	4314
6006	9442	1780
8367	9443	546
8367	9443	6722
8367	9443	5873
8367	9443	2358
8367	9443	959
8367	9443	9075
9755	9444	5952
9755	9444	4015
9755	9444	1114
9755	9444	3269
9755	9444	5712
9755	9444	302
9087	9445	4846
9087	9445	4938
9087	9445	2335
9087	9445	3234
9087	9445	4740
9087	9445	1858
9087	9445	7185
9087	9445	6794
9087	9445	9066
357	9446	6366
357	9446	1718
357	9446	7107
357	9446	1211
357	9446	725
357	9446	6455
357	9446	6774
13	9447	2314
13	9447	7835
13	9447	7302
13	9447	2636
13	9447	5436
13	9447	6545
13	9447	2708
8852	9448	5374
12197	9449	1761
12197	9449	4460
12197	9449	3626
12197	9449	2416
12197	9449	484
12197	9449	5438
16147	9450	4111
13638	9451	1245
13638	9451	6507
13638	9451	3975
13638	9451	2717
13638	9451	1393
13638	9451	4439
16128	9452	4003
16128	9452	1862
13482	9453	7056
13482	9453	5510
13482	9453	8444
13482	9453	4788
13482	9453	2302
12552	9454	7096
12552	9454	3501
12552	9454	4260
12552	9454	9598
12552	9454	4309
12552	9454	9532
12552	9454	3041
12552	9454	2911
12552	9454	5008
1034	9455	9633
3869	9456	8211
3869	9456	5640
3869	9456	546
3869	9456	6841
3869	9456	1838
3869	9456	1460
1982	9457	1185
1982	9457	3635
1982	9457	5194
8472	9458	8066
8472	9458	8276
8472	9458	3363
8472	9458	5327
8472	9458	1793
8472	9458	8144
19962	9459	6128
19962	9459	3128
8624	9460	504
8624	9460	7637
8144	9461	818
8144	9461	4355
19362	9462	5554
12462	9463	8368
12462	9463	8919
12462	9463	5878
12462	9463	5807
12619	9464	3521
12619	9464	640
12619	9464	2680
12619	9464	8902
12619	9464	5638
12619	9464	6715
4535	9465	8498
4535	9465	9870
4535	9465	8888
4535	9465	8360
4535	9465	5896
4535	9465	4314
5454	9466	4241
5454	9466	1069
5454	9466	3491
5454	9466	3954
1336	9467	2935
1336	9467	566
1336	9467	9547
1336	9467	8298
1336	9467	9223
10238	9468	9946
10238	9468	240
10238	9468	5295
10238	9468	3374
10238	9468	1400
10238	9468	6333
10238	9468	5991
7877	9469	2032
7877	9469	388
7877	9469	9025
7877	9469	14
7877	9469	5343
7877	9469	3366
7877	9469	725
7877	9469	7465
7877	9469	4651
16048	9470	4888
16048	9470	2197
16048	9470	8972
16048	9470	4816
16048	9470	7174
16048	9470	5585
16048	9470	8427
16880	9471	1652
16880	9471	7756
10440	9472	7978
10440	9472	2208
10440	9472	5628
10440	9472	2553
3049	9473	8520
3049	9473	9637
3049	9473	777
14046	9474	8613
14046	9474	7791
14647	9475	1507
14647	9475	2656
14647	9475	6664
14647	9475	809
17562	9476	1569
17562	9476	5363
12278	9477	3162
12278	9477	3646
2873	9478	8760
2873	9478	8329
2873	9478	9293
2873	9478	3980
2873	9478	9266
10745	9479	7521
10745	9479	5176
10745	9479	6343
10745	9479	9023
10745	9479	618
10745	9479	1382
10614	9480	9764
10614	9480	1827
2239	9481	7077
2239	9481	3493
2239	9481	3713
2239	9481	8165
2239	9481	2200
2239	9481	4117
2239	9481	1881
2239	9481	4153
11067	9482	841
11067	9482	1379
11067	9482	6921
11067	9482	8696
11067	9482	4325
11067	9482	351
11067	9482	6112
11067	9482	3651
11067	9482	905
6208	9483	1646
6208	9483	8312
6208	9483	9535
6208	9483	1331
6208	9483	2915
8587	9484	7499
8587	9484	7324
8587	9484	9241
8587	9484	3225
8587	9484	1517
8587	9484	5177
12467	9485	1407
12467	9485	884
12467	9485	2968
12467	9485	3354
12536	9486	561
12536	9486	1151
12536	9486	715
12536	9486	9883
12536	9486	6148
15328	9487	85
11219	9488	2780
11219	9488	7843
11219	9488	3823
11219	9488	45
11219	9488	7463
11219	9488	6009
11219	9488	5758
11219	9488	6083
11932	9489	9074
11932	9489	9444
19057	9490	5138
19057	9490	7058
19057	9490	3655
19057	9490	3663
19057	9490	6095
19057	9490	8014
19057	9490	221
19057	9490	1581
19057	9490	1181
13625	9491	8593
13625	9491	610
13625	9491	1758
13625	9491	7565
13625	9491	1761
13625	9491	9738
13625	9491	619
13625	9491	3718
19623	9492	3369
19623	9492	2904
19623	9492	4186
19623	9492	2612
19623	9492	896
19623	9492	5511
19623	9492	8942
19623	9492	7524
10176	9493	7790
16816	9494	2689
16816	9494	3054
16816	9494	3066
11939	9495	53
11939	9495	9707
11939	9495	222
18326	9496	9862
18326	9496	3048
18326	9496	992
18326	9496	9971
18326	9496	9245
18326	9496	3759
18326	9496	7470
18326	9496	2611
2992	9497	4568
2992	9497	8587
2992	9497	7506
2992	9497	9491
2992	9497	7971
15664	9498	7879
15664	9498	9785
15664	9498	2619
15664	9498	1135
15664	9498	963
15664	9498	3190
15664	9498	9140
15664	9498	5069
15664	9498	1030
19233	9499	8425
19233	9499	7649
19233	9499	4227
19233	9499	4227
19233	9499	2498
19233	9499	7439
19233	9499	9954
19233	9499	1311
19233	9499	6435
19249	9500	6049
19249	9500	4475
19249	9500	549
19249	9500	6695
19249	9500	6384
19249	9500	7857
19249	9500	1514
19249	9500	7581
157	9501	2360
157	9501	4916
157	9501	8887
157	9501	5944
157	9501	975
14047	9502	4102
14047	9502	8560
9887	9503	8975
9887	9503	7650
9887	9503	3170
9887	9503	6634
9887	9503	9928
9887	9503	8814
15401	9504	6279
15401	9504	399
15401	9504	4191
15401	9504	5570
15401	9504	6354
15401	9504	9090
15401	9504	9073
15401	9504	9631
14559	9505	2349
14559	9505	6620
14559	9505	231
14559	9505	7119
14559	9505	3134
14559	9505	1504
3804	9506	5004
3804	9506	2963
3804	9506	2797
3804	9506	5421
3804	9506	7057
18981	9507	5095
18981	9507	5756
18981	9507	6955
18981	9507	7147
18981	9507	8881
770	9508	2287
770	9508	2534
770	9508	1457
770	9508	8647
770	9508	7548
770	9508	6122
770	9508	9118
770	9508	4094
18376	9509	902
18376	9509	2298
18376	9509	7153
18376	9509	8327
18376	9509	1564
18376	9509	2401
9868	9510	430
9868	9510	6516
9868	9510	3853
5941	9511	4418
5941	9511	5863
5941	9511	5543
5941	9511	3624
5941	9511	4811
5941	9511	9020
5941	9511	5313
15427	9512	2647
15427	9512	4225
1481	9513	3378
1481	9513	2180
1481	9513	308
1481	9513	1284
1481	9513	7141
1481	9513	2934
1481	9513	4668
1481	9513	1540
1481	9513	882
4073	9514	3999
4073	9514	4272
4073	9514	289
4073	9514	8964
4073	9514	8838
4073	9514	4976
4073	9514	4394
4073	9514	7614
9508	9515	5518
9508	9515	2131
9508	9515	858
9508	9515	3909
16948	9516	5686
16948	9516	7269
16948	9516	7725
16948	9516	7316
16948	9516	8573
16948	9516	7579
16948	9516	7575
16948	9516	8643
16948	9516	9947
10928	9517	2521
10928	9517	8559
10928	9517	4301
10928	9517	4903
10928	9517	2653
19844	9518	6154
19844	9518	511
19844	9518	6170
19844	9518	7693
12671	9519	7482
12671	9519	8691
12671	9519	1736
588	9520	3901
588	9520	7402
588	9520	3131
588	9520	6475
588	9520	7574
588	9520	3571
588	9520	7355
588	9520	6172
588	9520	3484
12513	9521	2446
12513	9521	4663
12513	9521	2582
12513	9521	4474
12513	9521	8912
12513	9521	2765
12513	9521	4928
12513	9521	9938
15021	9522	5594
15021	9522	8897
15021	9522	6430
15021	9522	1219
15021	9522	8637
15021	9522	6674
15021	9522	5270
15021	9522	5262
15021	9522	973
19768	9523	6197
12268	9524	3644
12268	9524	1476
12268	9524	9852
12564	9525	4093
12564	9525	6120
2779	9526	9241
2779	9526	7469
2779	9526	2960
2779	9526	8152
2779	9526	8616
2779	9526	5290
2779	9526	7203
17357	9527	9051
17357	9527	7656
3497	9528	2515
3497	9528	8905
3497	9528	3395
3497	9528	7694
3497	9528	5459
3497	9528	6442
3497	9528	9809
10196	9529	4032
10196	9529	4375
10196	9529	1008
10196	9529	1376
10196	9529	5229
10196	9529	413
5855	9530	7545
5855	9530	7335
5855	9530	8340
5855	9530	5891
5855	9530	6404
5855	9530	9838
5855	9530	797
5855	9530	595
5855	9530	7582
17180	9531	7254
17180	9531	1176
17180	9531	2044
17180	9531	594
17180	9531	651
17180	9531	3604
17180	9531	3376
17180	9531	779
14364	9532	2080
14364	9532	4510
14364	9532	589
14364	9532	7644
14364	9532	682
14364	9532	6023
14397	9533	8660
14397	9533	7833
2871	9534	3379
2871	9534	6974
2871	9534	5255
2871	9534	6664
2871	9534	7699
2871	9534	9
2871	9534	3265
7893	9535	1882
7893	9535	9126
15571	9536	7095
15571	9536	4327
15571	9536	5718
5382	9537	4630
5382	9537	5052
5382	9537	5644
5382	9537	616
5382	9537	2714
5382	9537	2855
5382	9537	8448
15147	9538	5359
15147	9538	7708
15147	9538	3907
15147	9538	6843
15147	9538	9739
15091	9539	2016
15091	9539	9272
15091	9539	7135
15091	9539	6568
15091	9539	6407
15091	9539	6253
15091	9539	4160
12758	9540	2276
12758	9540	238
12758	9540	568
12758	9540	5806
12758	9540	6386
12758	9540	7852
12758	9540	5064
12758	9540	5482
5233	9541	2465
5233	9541	3517
5233	9541	5483
5233	9541	4727
11107	9542	4088
11107	9542	2512
11107	9542	3013
11107	9542	4962
11107	9542	6438
11107	9542	2806
16575	9543	904
6736	9544	2085
6736	9544	5496
6736	9544	4079
6736	9544	2365
6736	9544	5880
6736	9544	5705
6736	9544	1108
6736	9544	6710
6293	9545	4648
969	9546	543
2459	9547	7399
2459	9547	2375
2459	9547	8938
2459	9547	1250
2459	9547	1191
2459	9547	3210
19837	9548	3065
19837	9548	4709
19837	9548	8813
19837	9548	8197
17478	9549	9968
17478	9549	3070
17478	9549	9937
17478	9549	8844
17478	9549	183
17478	9549	3692
17478	9549	7049
5440	9550	6508
5440	9550	9288
16200	9551	8684
16200	9551	4530
16200	9551	6667
16200	9551	5890
16200	9551	1865
16200	9551	5181
10727	9552	6737
10727	9552	5292
10727	9552	570
10727	9552	2447
10727	9552	1993
10727	9552	8293
10727	9552	9835
10727	9552	5378
19816	9553	4405
19816	9553	8988
19816	9553	5573
19816	9553	6978
19816	9553	9532
19816	9553	8663
19816	9553	5629
19816	9553	6677
19816	9553	6064
16111	9554	7643
16111	9554	4991
15151	9555	6827
15151	9555	2815
15151	9555	3602
1158	9556	8358
1158	9556	5782
1158	9556	1276
1158	9556	184
1158	9556	1583
1158	9556	5394
1158	9556	5024
1158	9556	3133
1158	9556	6057
17968	9557	6317
17968	9557	230
17968	9557	6610
17968	9557	498
17710	9558	2841
17710	9558	7965
17710	9558	1203
17710	9558	6481
17710	9558	1988
10239	9559	7462
10239	9559	4672
10239	9559	3525
10239	9559	1095
10239	9559	907
10239	9559	3965
7377	9560	9194
7377	9560	9427
7377	9560	6124
7377	9560	6706
7377	9560	7227
7377	9560	4109
11256	9561	4737
11256	9561	4144
10477	9562	2943
10477	9562	518
10477	9562	9668
10477	9562	1477
10477	9562	3877
10477	9562	6020
10477	9562	1534
10477	9562	2604
10477	9562	1417
10457	9563	6502
10457	9563	5383
10457	9563	5339
10457	9563	5884
10457	9563	2703
10457	9563	3332
10457	9563	4741
10457	9563	3997
15746	9564	7873
15746	9564	604
15746	9564	7414
15746	9564	7189
15746	9564	7250
15746	9564	1196
15746	9564	6606
15746	9564	4397
560	9565	9106
560	9565	6089
560	9565	5627
14974	9566	5367
14974	9566	5837
14974	9566	6307
14974	9566	7991
14974	9566	6282
14974	9566	3024
14974	9566	8991
6774	9567	3667
6774	9567	7091
6774	9567	3497
6774	9567	6617
13358	9568	3862
13358	9568	7055
6723	9569	6857
6723	9569	1178
6723	9569	6706
6723	9569	9510
6723	9569	3555
6723	9569	4982
4143	9570	5251
4143	9570	4572
4143	9570	3289
4143	9570	9739
4143	9570	3159
2210	9571	7043
2210	9571	9025
2210	9571	6891
2210	9571	8387
2210	9571	6491
2210	9571	7483
2210	9571	9163
2210	9571	3543
2210	9571	4883
18908	9572	636
18908	9572	6202
18908	9572	3839
18908	9572	4900
18908	9572	2845
18908	9572	1003
18908	9572	161
18908	9572	7600
18908	9572	4294
3553	9573	1211
3553	9573	8806
3553	9573	7898
3553	9573	5547
3553	9573	3622
3553	9573	2253
3553	9573	9977
3553	9573	2873
3553	9573	84
2174	9574	8981
2174	9574	5525
2174	9574	9276
2174	9574	5051
2174	9574	5664
2174	9574	3942
2174	9574	2353
15798	9575	4082
15798	9575	2483
15798	9575	5388
10942	9576	6558
10942	9576	2727
10942	9576	3844
10942	9576	8812
10942	9576	4264
10942	9576	7956
3794	9577	3736
3794	9577	374
3794	9577	6094
17151	9578	3931
17151	9578	934
17151	9578	3195
17151	9578	3660
17151	9578	3029
3679	9579	5701
3679	9579	8363
3679	9579	473
3679	9579	8297
3679	9579	6192
3679	9579	4988
3679	9579	3124
3679	9579	860
9580	9580	9792
9580	9580	8951
3959	9581	3819
3959	9581	801
3959	9581	150
1246	9582	4832
1246	9582	2307
1246	9582	397
1246	9582	4883
10817	9583	6869
10817	9583	8416
10817	9583	9288
10817	9583	7799
10817	9583	8975
10817	9583	1815
3929	9584	2588
3929	9584	114
3929	9584	8971
3929	9584	7237
3929	9584	7850
3929	9584	624
13338	9585	2507
13338	9585	215
13338	9585	6081
13338	9585	2035
7698	9586	5813
16800	9587	5818
16800	9587	9777
16800	9587	2967
16800	9587	5174
16800	9587	2539
16800	9587	259
16800	9587	7096
14620	9588	5323
14620	9588	4201
14620	9588	443
14620	9588	5717
14620	9588	2802
14620	9588	4656
14620	9588	316
14620	9588	1030
14620	9588	3528
17403	9589	1402
16994	9590	5807
16994	9590	6059
16994	9590	1764
16994	9590	6081
16994	9590	9291
16994	9590	8461
16994	9590	4757
10144	9591	5163
5760	9592	3135
5760	9592	9980
1182	9593	5761
1182	9593	2652
17464	9594	529
17464	9594	1595
17464	9594	1306
17464	9594	357
17464	9594	1668
17464	9594	2012
17464	9594	8400
17464	9594	8350
17464	9594	5049
1529	9595	2287
1529	9595	2367
1529	9595	2204
3866	9596	123
3866	9596	9485
3866	9596	4795
3866	9596	6323
16668	9597	6163
16668	9597	5294
16668	9597	9357
16668	9597	1976
8525	9598	9201
8525	9598	1170
8525	9598	7094
8525	9598	7070
8525	9598	6931
8525	9598	8645
8525	9598	6395
8525	9598	8187
1729	9599	1892
1729	9599	675
1729	9599	4619
1729	9599	9525
1729	9599	6913
1729	9599	9432
1729	9599	7643
1729	9599	8984
1729	9599	3855
1570	9600	2510
1393	9601	1561
1393	9601	8329
1393	9601	7078
1393	9601	4700
1393	9601	1653
1393	9601	2538
1393	9601	6707
1393	9601	4678
7323	9602	9714
7323	9602	7210
7323	9602	1637
7323	9602	1320
7323	9602	416
7323	9602	6065
8787	9603	3396
8787	9603	7117
8787	9603	4352
8787	9603	3615
8787	9603	1624
8389	9604	620
8389	9604	5532
8389	9604	3987
8389	9604	7549
8389	9604	4369
866	9605	4827
866	9605	1146
866	9605	5496
866	9605	3271
866	9605	7917
866	9605	907
12627	9606	807
12627	9606	8797
12627	9606	2183
12627	9606	3507
12627	9606	8089
12627	9606	7695
12627	9606	8308
6267	9607	1356
6267	9607	602
6267	9607	8347
18506	9608	5567
18506	9608	3818
18506	9608	6146
18506	9608	2712
18506	9608	5398
18506	9608	8059
18506	9608	4093
4800	9609	5534
13778	9610	1515
13778	9610	1607
13778	9610	2490
16111	9611	4428
16111	9611	6147
16111	9611	5930
16111	9611	3357
14898	9612	9849
14898	9612	4133
14898	9612	9520
14898	9612	2271
7571	9613	6812
7571	9613	980
4871	9614	38
4871	9614	9757
4871	9614	7747
5552	9615	6761
5552	9615	2826
5552	9615	5793
5552	9615	7514
5552	9615	6755
5552	9615	1849
5552	9615	8538
5552	9615	4535
5552	9615	5186
10486	9616	1447
10486	9616	7957
15823	9617	7608
15823	9617	9187
15823	9617	9623
15823	9617	2779
15823	9617	3043
15823	9617	4359
15823	9617	3933
15823	9617	3551
17473	9618	3979
17473	9618	6355
17473	9618	1631
17473	9618	4619
13175	9619	5317
13175	9619	264
13175	9619	2783
13175	9619	2076
13175	9619	2575
13175	9619	716
13175	9619	9331
13175	9619	4973
13175	9619	3003
13964	9620	2407
13964	9620	6775
13964	9620	4170
5575	9621	592
5575	9621	3869
5575	9621	2133
5575	9621	9200
5575	9621	2378
5575	9621	1214
5575	9621	4182
5575	9621	3452
5575	9621	2350
10091	9622	9372
10091	9622	3599
10091	9622	7796
10091	9622	6329
10091	9622	6140
10091	9622	5714
15692	9623	2553
15692	9623	9408
15692	9623	39
15692	9623	9953
15692	9623	775
15692	9623	3052
15692	9623	7348
15692	9623	1515
15692	9623	3875
3341	9624	8294
3341	9624	3508
3341	9624	8472
3341	9624	1853
3341	9624	3294
3341	9624	2755
5586	9625	6284
5586	9625	427
5586	9625	2007
5586	9625	4411
5586	9625	4494
5586	9625	8634
5586	9625	9957
5586	9625	1343
9701	9626	8652
9701	9626	2317
9701	9626	8513
9701	9626	4648
9701	9626	7864
9701	9626	4809
9701	9626	8005
9701	9626	3483
15787	9627	6180
15787	9627	2258
15787	9627	3124
15787	9627	4385
15787	9627	8451
15787	9627	438
15787	9627	749
18523	9628	5946
18523	9628	4634
18523	9628	9836
18523	9628	5990
17999	9629	6504
17999	9629	8349
17999	9629	3527
17999	9629	2361
17999	9629	4017
17999	9629	4552
10599	9630	4561
10599	9630	656
10599	9630	721
10599	9630	1261
10599	9630	7926
10599	9630	3875
10599	9630	6249
5505	9631	1513
5505	9631	6577
5505	9631	3914
5505	9631	4686
5505	9631	5048
4510	9632	7287
4510	9632	8831
4510	9632	5503
4510	9632	8563
4510	9632	7341
4510	9632	4003
4510	9632	7523
4510	9632	6342
15709	9633	1729
15709	9633	3035
15709	9633	8382
4291	9634	471
4291	9634	8785
4291	9634	5630
4291	9634	9393
4291	9634	7715
4291	9634	6629
4291	9634	323
4291	9634	2477
16681	9635	782
7631	9636	1897
7631	9636	597
7631	9636	242
7631	9636	9855
7631	9636	368
7631	9636	3314
7631	9636	9677
7631	9636	6493
13630	9637	3479
13630	9637	3562
13630	9637	4762
13630	9637	4243
13630	9637	8159
110	9638	2288
110	9638	4945
110	9638	7842
110	9638	7627
14605	9639	3608
14605	9639	8380
3715	9640	9854
3715	9640	8054
3715	9640	8266
3715	9640	997
19140	9641	8385
19140	9641	696
19140	9641	5684
19140	9641	7380
19140	9641	5624
19140	9641	2320
19140	9641	4489
19140	9641	3296
3936	9642	5402
3936	9642	6505
3936	9642	2613
17758	9643	7432
16255	9644	6449
16255	9644	7451
16255	9644	8623
16255	9644	1304
16255	9644	470
16255	9644	7748
16255	9644	6567
3937	9645	5637
3937	9645	9442
13026	9646	1968
13026	9646	9547
11991	9647	8068
11991	9647	6421
11991	9647	4442
11991	9647	3971
11991	9647	9917
11991	9647	8285
1562	9648	5890
1562	9648	8993
1562	9648	3246
1562	9648	1297
1562	9648	2990
1562	9648	8863
1562	9648	6838
1562	9648	8841
10523	9649	2152
10523	9649	9534
10523	9649	8785
10523	9649	7420
10523	9649	8600
10523	9649	9431
10523	9649	1445
9381	9650	9904
9381	9650	6505
9381	9650	4089
9381	9650	338
9381	9650	8249
9381	9650	8190
683	9651	2410
19658	9652	4541
19658	9652	1024
19658	9652	8701
19658	9652	676
19658	9652	1052
19658	9652	9508
7192	9653	6525
7192	9653	2924
7192	9653	1672
7192	9653	5056
7192	9653	3626
7192	9653	2001
7192	9653	7293
7192	9653	8097
7192	9653	3124
3648	9654	9433
3648	9654	9073
3648	9654	3117
3648	9654	2536
3648	9654	8102
3648	9654	3161
3648	9654	3774
3648	9654	4533
16316	9655	9719
16316	9655	2124
16316	9655	5420
16316	9655	6936
16316	9655	7070
16316	9655	1731
16316	9655	7007
16316	9655	5443
16316	9655	9222
14647	9656	8348
14647	9656	2131
14647	9656	9641
14647	9656	1038
14647	9656	8684
14647	9656	9520
14647	9656	8573
11016	9657	6954
11016	9657	9625
11016	9657	711
19865	9658	7256
19865	9658	5519
19865	9658	895
19865	9658	8484
19865	9658	7056
19865	9658	6469
19865	9658	278
19865	9658	6546
5196	9659	5721
5196	9659	9012
5196	9659	5271
5196	9659	413
5196	9659	9655
5196	9659	7575
5196	9659	3540
5196	9659	2514
5196	9659	743
15598	9660	3538
15598	9660	7426
16706	9661	7457
16706	9661	5314
16706	9661	3746
16706	9661	6191
11690	9662	2755
11690	9662	607
11690	9662	5588
11690	9662	6266
11690	9662	9149
11690	9662	1993
11690	9662	7578
14446	9663	1226
14446	9663	3851
14446	9663	1696
14446	9663	7123
14446	9663	1755
18739	9664	524
18739	9664	1754
18739	9664	6531
18739	9664	6667
18739	9664	4802
18739	9664	8365
2269	9665	6584
2269	9665	1073
2269	9665	7366
2269	9665	8032
2269	9665	653
2269	9665	1550
12248	9666	1305
12248	9666	5790
12248	9666	642
12248	9666	3513
12248	9666	1115
12248	9666	7823
12248	9666	3013
12248	9666	5037
12248	9666	8253
11238	9667	108
11238	9667	7848
11238	9667	3913
11238	9667	7781
11238	9667	6681
11238	9667	7405
11238	9667	6920
11238	9667	4927
12084	9668	5233
12084	9668	8738
13980	9669	2609
13980	9669	3011
13980	9669	4784
13980	9669	4374
13980	9669	7860
9082	9670	7012
3877	9671	7980
3877	9671	3729
3877	9671	6222
2280	9672	6089
2280	9672	5112
2280	9672	4781
2280	9672	9956
2280	9672	8591
2280	9672	1308
2280	9672	2357
2280	9672	2951
2280	9672	704
18587	9673	194
18587	9673	2498
18587	9673	490
18587	9673	7555
18587	9673	5837
18587	9673	2010
18587	9673	2742
18587	9673	844
18587	9673	5944
14502	9674	9797
14502	9674	2238
14502	9674	6331
1250	9675	8649
1250	9675	6402
1250	9675	1305
1250	9675	9083
1250	9675	7599
1250	9675	8089
1250	9675	7883
1250	9675	3038
1250	9675	8367
19737	9676	4321
1302	9677	1276
1302	9677	1155
15112	9678	1513
15112	9678	8801
13780	9679	5822
13780	9679	944
13780	9679	6038
13780	9679	4057
13780	9679	2895
13780	9679	1114
13780	9679	9028
606	9680	227
606	9680	4147
606	9680	358
606	9680	7430
606	9680	4769
606	9680	6048
3738	9681	6057
3738	9681	6747
3738	9681	5203
3738	9681	8490
3738	9681	3909
18689	9682	5935
18689	9682	6669
18689	9682	7333
18689	9682	5739
18689	9682	6184
18689	9682	1428
18689	9682	4727
18689	9682	4100
313	9683	269
313	9683	6323
313	9683	5697
313	9683	6276
313	9683	9576
313	9683	3297
313	9683	2141
18948	9684	4237
18948	9684	1836
13125	9685	7997
13125	9685	9660
13125	9685	7494
13125	9685	1558
13125	9685	8687
13125	9685	4048
13125	9685	2581
13125	9685	9058
13125	9685	9133
9446	9686	6052
9446	9686	6005
9446	9686	573
2893	9687	2257
2893	9687	4623
2893	9687	500
18374	9688	4149
18374	9688	1236
18374	9688	1893
18374	9688	4405
18374	9688	5092
18374	9688	566
18374	9688	9985
1114	9689	2003
1114	9689	5925
1114	9689	9462
1114	9689	4009
15150	9690	5188
12848	9691	6793
12848	9691	5805
12848	9691	5985
12848	9691	3027
12848	9691	2941
12848	9691	6526
12848	9691	5534
12848	9691	9810
18544	9692	9234
18544	9692	4371
18544	9692	8893
18544	9692	1679
18544	9692	5983
18544	9692	3141
18544	9692	9091
10149	9693	1044
10149	9693	9740
10149	9693	9175
10149	9693	6097
10149	9693	6732
10149	9693	8257
10149	9693	5681
103	9694	9610
103	9694	1431
103	9694	5733
103	9694	8367
103	9694	3516
103	9694	9898
1881	9695	8509
9210	9696	3489
9210	9696	1191
9210	9696	990
13723	9697	4412
13723	9697	4421
13723	9697	1020
13723	9697	4968
13723	9697	5812
13723	9697	3366
13723	9697	5805
13723	9697	6970
5384	9698	5147
5384	9698	5454
12887	9699	3305
15432	9700	7861
15432	9700	6831
15432	9700	2017
15432	9700	7692
6992	9701	7809
6992	9701	8825
6992	9701	4497
6992	9701	9132
6992	9701	308
6992	9701	6394
19395	9702	7414
19395	9702	5167
3995	9703	4640
3995	9703	6659
4982	9704	5034
4982	9704	3824
4982	9704	2731
4982	9704	9480
4982	9704	3662
4982	9704	8341
4982	9704	5571
5968	9705	8258
5968	9705	3448
16176	9706	1891
16176	9706	5117
16176	9706	8538
4722	9707	5317
4722	9707	6356
4722	9707	5033
1206	9708	3587
3688	9709	8202
3688	9709	3410
3688	9709	7070
3688	9709	1793
3688	9709	7127
15428	9710	1032
15428	9710	1177
12419	9711	6812
12419	9711	1548
6842	9712	8743
6842	9712	7137
6842	9712	797
5178	9713	2919
5178	9713	2293
5178	9713	745
5178	9713	3615
5178	9713	712
5589	9714	3229
5589	9714	5341
5589	9714	6691
5589	9714	141
5589	9714	8026
17644	9715	1411
17644	9715	9615
17644	9715	6603
17644	9715	9938
17644	9715	5231
11884	9716	8737
11884	9716	2341
11884	9716	9143
11884	9716	9412
11884	9716	5263
11884	9716	1267
11884	9716	6829
16623	9717	6186
16623	9717	7850
16623	9717	5409
16623	9717	136
18808	9718	6803
18808	9718	1364
18808	9718	7283
18808	9718	6823
18808	9718	6340
15212	9719	6457
15212	9719	1386
15212	9719	1006
17710	9720	6642
17710	9720	9894
17710	9720	9899
17710	9720	3471
17710	9720	1793
17710	9720	5844
17710	9720	5340
17710	9720	5769
17710	9720	4752
252	9721	7611
252	9721	6086
252	9721	4047
252	9721	7470
252	9721	9185
252	9721	4902
9601	9722	1501
9601	9722	397
9601	9722	6419
9601	9722	11
9601	9722	7416
9601	9722	4202
18581	9723	5766
18581	9723	1114
18581	9723	8458
15284	9724	6719
15284	9724	3920
15284	9724	350
15284	9724	9615
15284	9724	2764
15284	9724	6482
15284	9724	8220
15284	9724	7536
15284	9724	597
6077	9725	1566
6077	9725	7289
6077	9725	4618
6077	9725	7665
6077	9725	626
6077	9725	2099
6077	9725	6654
12537	9726	2301
12537	9726	5503
12537	9726	3571
8335	9727	7206
8335	9727	2129
8335	9727	6419
8335	9727	8795
8335	9727	924
3099	9728	6095
12118	9729	8788
12118	9729	5763
12118	9729	6585
12118	9729	7330
12118	9729	3500
12118	9729	4178
12612	9730	5723
12612	9730	630
12612	9730	4729
12612	9730	8196
12612	9730	9425
12612	9730	3067
12612	9730	349
12612	9730	8407
12612	9730	2895
18959	9731	9005
6363	9732	9488
6363	9732	6317
6363	9732	5454
6363	9732	1857
6363	9732	5924
6363	9732	5754
6363	9732	4343
9383	9733	3828
9383	9733	243
9383	9733	8025
9383	9733	8011
9383	9733	747
9383	9733	210
19394	9734	4907
19394	9734	1543
19394	9734	1274
19394	9734	6816
19394	9734	2813
959	9735	6553
959	9735	43
16134	9736	5096
16134	9736	6500
16134	9736	9741
16134	9736	5003
16134	9736	9377
1837	9737	8384
1837	9737	4769
1837	9737	4647
1837	9737	1676
1837	9737	2113
1837	9737	173
1837	9737	5024
11127	9738	6850
11127	9738	623
11127	9738	3326
11127	9738	1968
11127	9738	5534
4413	9739	5695
4413	9739	3201
9753	9740	3105
9753	9740	5829
9753	9740	8114
9753	9740	3692
1083	9741	7132
1083	9741	7617
6301	9742	5357
6301	9742	359
6301	9742	4658
6301	9742	1392
6301	9742	8436
6301	9742	9893
6301	9742	3237
6301	9742	9668
6719	9743	3901
6719	9743	5132
6719	9743	2247
13959	9744	5333
13959	9744	1377
13959	9744	2305
13959	9744	9250
13959	9744	2254
13959	9744	5924
13959	9744	9225
17786	9745	2253
17786	9745	2779
17786	9745	2235
17786	9745	7186
17786	9745	659
17786	9745	1460
17786	9745	4982
17786	9745	7811
17786	9745	2484
3468	9746	9419
3468	9746	6791
3468	9746	8894
3468	9746	7537
3468	9746	4296
14149	9747	4985
14149	9747	8140
14149	9747	444
14149	9747	2200
19	9748	124
19	9748	610
19	9748	8820
19	9748	3668
19	9748	8673
19	9748	268
19	9748	1966
19	9748	5998
3880	9749	5067
3880	9749	2266
3880	9749	4786
3880	9749	935
3880	9749	4474
3880	9749	54
1326	9750	692
1326	9750	1322
1326	9750	4762
1326	9750	5573
1326	9750	6153
1326	9750	116
14327	9751	2350
14327	9751	4087
14327	9751	1143
14327	9751	8313
14327	9751	7738
14327	9751	214
14327	9751	9029
14327	9751	339
3320	9752	3249
3320	9752	2433
3320	9752	6226
3320	9752	7191
3320	9752	9711
3320	9752	8311
4795	9753	7419
4795	9753	5039
4795	9753	5874
4795	9753	9784
4795	9753	3998
4795	9753	4622
4795	9753	1782
4795	9753	648
4795	9753	8361
9172	9754	4321
9172	9754	3224
3009	9755	928
3009	9755	4102
3009	9755	7602
3009	9755	1219
3009	9755	4877
3009	9755	7507
18578	9756	4319
17499	9757	371
17499	9757	4851
17499	9757	3102
17499	9757	5099
17499	9757	8843
17499	9757	578
17499	9757	1992
17499	9757	2918
17499	9757	5565
6142	9758	2360
6142	9758	9389
6142	9758	2060
6142	9758	5428
6142	9758	2786
6142	9758	8680
6142	9758	9393
6142	9758	9886
17455	9759	1672
9178	9760	2383
9178	9760	7303
9178	9760	2728
9178	9760	171
4459	9761	439
4459	9761	7567
13919	9762	1451
13919	9762	4425
13919	9762	1299
13919	9762	4476
13919	9762	685
13919	9762	4198
3001	9763	1163
3001	9763	9183
3001	9763	5143
3001	9763	9271
3001	9763	2750
3001	9763	4698
3001	9763	3797
10493	9764	7214
10493	9764	4780
10493	9764	7671
10493	9764	1884
10493	9764	8532
10493	9764	3368
10493	9764	3289
10493	9764	4187
18658	9765	4910
18658	9765	8141
3874	9766	7183
3874	9766	1297
3874	9766	9315
13970	9767	8853
13970	9767	4191
13970	9767	1347
13970	9767	6751
13970	9767	9951
13970	9767	4862
13970	9767	87
13970	9767	6788
10285	9768	7756
10285	9768	6193
10285	9768	1744
10285	9768	5130
10285	9768	2492
2688	9769	3564
2688	9769	7468
2688	9769	3621
2688	9769	9098
2688	9769	4413
2688	9769	8254
2688	9769	7413
2688	9769	6343
2688	9769	2214
16812	9770	3913
16812	9770	4496
16812	9770	4950
16812	9770	7747
16812	9770	282
16812	9770	9779
6798	9771	1881
268	9772	7766
268	9772	4897
268	9772	1219
268	9772	8385
268	9772	6486
268	9772	2650
268	9772	8700
12893	9773	7758
12893	9773	9305
8943	9774	4051
8943	9774	4482
8943	9774	7334
8943	9774	1950
6338	9775	7539
377	9776	7788
377	9776	8052
11618	9777	5192
11618	9777	6119
339	9778	4999
339	9778	9689
339	9778	4873
339	9778	117
339	9778	2523
339	9778	5456
339	9778	7844
11262	9779	2709
11262	9779	895
11262	9779	9750
11262	9779	7468
11262	9779	1383
13385	9780	9336
8416	9781	1130
8416	9781	5756
8416	9781	7425
8416	9781	1555
8416	9781	9230
8416	9781	9544
8416	9781	5416
8416	9781	793
16520	9782	8689
16520	9782	4599
16520	9782	8108
16520	9782	4118
16520	9782	8142
16520	9782	4193
16520	9782	5587
16520	9782	5855
14819	9783	4723
14819	9783	4714
14819	9783	7450
7946	9784	1879
7946	9784	3408
7946	9784	9013
7946	9784	411
7946	9784	7608
7946	9784	6722
4615	9785	5318
4615	9785	1087
4615	9785	8072
4615	9785	9798
14494	9786	1220
14494	9786	7585
1985	9787	2508
1985	9787	6654
1985	9787	8537
1985	9787	1917
7331	9788	8961
14065	9789	9818
14065	9789	830
14065	9789	4124
14065	9789	165
9349	9790	8198
9349	9790	4708
9349	9790	5324
9349	9790	8226
9349	9790	9602
19274	9791	759
19274	9791	6898
19274	9791	2275
19274	9791	563
19274	9791	4823
19274	9791	5154
19274	9791	6394
19274	9791	9662
19274	9791	5023
19460	9792	2974
19460	9792	6863
19460	9792	4843
19460	9792	2212
19460	9792	7633
19460	9792	8442
19460	9792	658
19460	9792	1246
19460	9792	3821
17948	9793	9275
17948	9793	1393
17948	9793	8577
2573	9794	2222
2573	9794	9575
2573	9794	9946
2573	9794	6813
2573	9794	4757
2573	9794	2109
2573	9794	5971
19582	9795	8765
19582	9795	4842
19582	9795	1196
19544	9796	1058
19544	9796	3363
19544	9796	9419
19544	9796	343
19544	9796	4723
19544	9796	6943
18102	9797	2405
18102	9797	8172
18102	9797	4069
18102	9797	2306
18102	9797	4975
18102	9797	5144
18102	9797	3273
18102	9797	3674
14071	9798	9973
14071	9798	3094
14071	9798	5108
14071	9798	4175
18135	9799	596
18135	9799	3319
11249	9800	9126
11249	9800	3291
11249	9800	5789
11249	9800	6729
11249	9800	4000
11249	9800	3829
13846	9801	6959
13846	9801	4917
13846	9801	1908
13846	9801	7537
13846	9801	4884
13846	9801	7167
13846	9801	6481
11211	9802	8004
11211	9802	2123
11211	9802	5347
11211	9802	9071
11211	9802	94
17520	9803	1601
17520	9803	9102
17520	9803	4491
18749	9804	5263
18749	9804	3919
18749	9804	9580
15166	9805	2315
15166	9805	536
15166	9805	3148
15166	9805	2746
3012	9806	5183
19347	9807	9048
8622	9808	1442
8622	9808	982
8622	9808	6674
8622	9808	8146
8622	9808	3580
8622	9808	372
8622	9808	9310
17396	9809	9687
17396	9809	9678
17396	9809	9479
17396	9809	4690
17396	9809	3257
17396	9809	2838
17396	9809	5979
17396	9809	1858
17062	9810	7518
17062	9810	4838
17062	9810	6874
17062	9810	1008
17062	9810	2845
17062	9810	1119
1593	9811	8516
1593	9811	3443
1593	9811	9779
1593	9811	4540
1593	9811	559
17141	9812	4727
17141	9812	9433
17141	9812	335
17141	9812	3712
17141	9812	9152
17141	9812	6974
17141	9812	9089
17141	9812	1067
17141	9812	7325
1535	9813	7047
1535	9813	2743
1535	9813	2290
1535	9813	6176
1535	9813	4746
1535	9813	9662
1535	9813	467
8357	9814	735
8357	9814	9906
8357	9814	722
8357	9814	5626
8357	9814	554
8357	9814	8814
8357	9814	9817
8357	9814	7801
8357	9814	3465
19280	9815	542
19280	9815	6942
19280	9815	6965
16606	9816	6615
16606	9816	5745
16606	9816	7937
16606	9816	5382
16606	9816	4201
16606	9816	397
16395	9817	8287
16395	9817	3159
16395	9817	7358
16395	9817	2562
19051	9818	7828
19051	9818	5817
19051	9818	5748
19051	9818	1778
19051	9818	2931
19051	9818	2174
19051	9818	1354
19051	9818	1148
19051	9818	767
18108	9819	4647
18108	9819	1784
18108	9819	3973
18108	9819	6734
18108	9819	6387
18108	9819	4480
18108	9819	9004
18108	9819	3763
13387	9820	3825
13387	9820	8654
13387	9820	701
13387	9820	2696
13387	9820	8475
13387	9820	3710
10986	9821	1984
10986	9821	4356
10986	9821	1625
10986	9821	573
10986	9821	9062
10986	9821	1409
10986	9821	1029
10986	9821	9057
15421	9822	7131
15421	9822	4968
15421	9822	7533
15421	9822	8727
15421	9822	4170
15421	9822	879
15421	9822	6119
15421	9822	4524
15421	9822	4070
6262	9823	6104
6262	9823	9128
6262	9823	5312
6262	9823	2870
6262	9823	7111
6262	9823	7657
6262	9823	5606
6262	9823	756
6262	9823	7408
16573	9824	3521
16573	9824	7250
16573	9824	698
16573	9824	721
16573	9824	5399
16573	9824	588
16573	9824	1984
16573	9824	2296
16573	9824	1036
17383	9825	3880
2575	9826	9574
2575	9826	7684
2575	9826	3846
2575	9826	684
2575	9826	553
2575	9826	4671
2575	9826	8228
2575	9826	478
5547	9827	2180
5547	9827	885
9529	9828	6052
9529	9828	3344
9529	9828	1314
9529	9828	8719
9529	9828	5961
13028	9829	2465
13028	9829	9632
13028	9829	9245
13028	9829	5716
15792	9830	1561
15792	9830	8631
15792	9830	9769
15792	9830	536
3699	9831	7009
3699	9831	8426
3699	9831	6616
3699	9831	1083
3699	9831	8266
3699	9831	2023
3699	9831	1504
3699	9831	1820
3699	9831	5635
14390	9832	4660
14390	9832	1663
14390	9832	3530
14390	9832	7045
14390	9832	993
14390	9832	7772
14390	9832	764
3693	9833	2561
3693	9833	4426
3693	9833	3229
3693	9833	8549
3693	9833	2291
3693	9833	6058
3693	9833	3881
11086	9834	7511
11086	9834	4555
11086	9834	7012
11086	9834	7922
11086	9834	6714
11086	9834	9622
11086	9834	3487
15823	9835	4156
15823	9835	7764
15823	9835	1694
15823	9835	9384
15823	9835	4540
15823	9835	1117
15823	9835	9624
15823	9835	3411
15823	9835	7131
10105	9836	1624
10105	9836	3400
10105	9836	9999
12489	9837	1038
12489	9837	3623
12489	9837	9557
12489	9837	8306
12489	9837	5746
12489	9837	4549
12489	9837	8050
10361	9838	233
10361	9838	9271
10361	9838	4394
10361	9838	6966
10361	9838	1742
10361	9838	636
3348	9839	4406
5421	9840	2133
5421	9840	4907
5421	9840	1607
5421	9840	5363
5421	9840	507
5421	9840	6563
5421	9840	7451
5421	9840	2448
5421	9840	5348
11967	9841	7657
11967	9841	2350
12284	9842	5680
12284	9842	7102
12284	9842	7087
12284	9842	5041
11095	9843	5325
11095	9843	6213
11095	9843	9909
11095	9843	1962
11095	9843	7543
10399	9844	7262
10399	9844	4365
10399	9844	3020
10399	9844	8938
10399	9844	631
10399	9844	8829
10399	9844	8473
10399	9844	1218
13085	9845	4315
13085	9845	552
13085	9845	6226
13085	9845	2140
13085	9845	3294
13085	9845	321
13085	9845	6919
13085	9845	2588
13085	9845	4729
10718	9846	1030
10718	9846	6410
10718	9846	2537
10718	9846	8790
10718	9846	8181
10718	9846	6461
10718	9846	9381
10718	9846	6827
240	9847	675
240	9847	9791
240	9847	5729
240	9847	4788
240	9847	9878
1815	9848	3155
3890	9849	5050
3890	9849	7186
3890	9849	4587
3890	9849	5952
3890	9849	4132
3890	9849	4476
3890	9849	615
3890	9849	8069
5712	9850	5194
5712	9850	9571
5712	9850	7890
5712	9850	4448
5712	9850	4671
5712	9850	6617
5712	9850	1788
5712	9850	4151
205	9851	4926
205	9851	6752
9640	9852	7676
9640	9852	1936
9640	9852	822
17423	9853	6874
6980	9854	7292
6980	9854	8918
6980	9854	2876
15603	9855	3342
15603	9855	8623
15603	9855	2641
15603	9855	9242
127	9856	8775
127	9856	6456
127	9856	9215
127	9856	9138
127	9856	9754
127	9856	611
6972	9857	1287
6972	9857	2391
6972	9857	7585
6972	9857	9855
6972	9857	7312
6972	9857	4801
6972	9857	9160
6972	9857	2067
17046	9858	5734
10976	9859	4159
10976	9859	2343
10976	9859	9272
10976	9859	5707
10976	9859	8258
10976	9859	2676
10976	9859	3517
10976	9859	7208
12735	9860	4301
12735	9860	7057
12735	9860	804
12735	9860	602
12735	9860	8278
12735	9860	7907
12735	9860	436
12735	9860	9928
11269	9861	8926
11269	9861	249
14913	9862	3824
16248	9863	6007
16248	9863	8879
16248	9863	205
16248	9863	6359
16248	9863	9593
16248	9863	8361
4480	9864	4377
4480	9864	1917
4480	9864	6522
4480	9864	2081
4480	9864	6450
4480	9864	7238
4480	9864	4028
4480	9864	1572
902	9865	7607
902	9865	7058
902	9865	9795
902	9865	6719
902	9865	7658
902	9865	4168
902	9865	5953
902	9865	6659
902	9865	2035
16969	9866	3967
16969	9866	4580
16969	9866	8705
16969	9866	5989
16969	9866	2269
16969	9866	8348
16969	9866	796
15028	9867	9387
15028	9867	4436
15028	9867	4691
13451	9868	5210
13451	9868	4560
13451	9868	3148
13451	9868	4714
13451	9868	2461
13451	9868	7200
13451	9868	4299
10188	9869	2608
10188	9869	1201
10188	9869	6733
10188	9869	7335
10188	9869	6731
10188	9869	8149
10188	9869	2717
10188	9869	1041
8376	9870	6040
8376	9870	7950
8376	9870	3605
8376	9870	8786
8376	9870	7343
8376	9870	6458
8376	9870	600
14664	9871	8755
14664	9871	4428
14664	9871	6590
14664	9871	260
14664	9871	4420
14664	9871	1817
14664	9871	40
14664	9871	9710
14664	9871	1096
19762	9872	2355
19762	9872	7531
19762	9872	5089
19762	9872	286
19762	9872	8756
19762	9872	8409
19762	9872	5943
12405	9873	8996
12405	9873	5580
12405	9873	2301
12405	9873	7025
12405	9873	8604
19153	9874	7007
19153	9874	8586
19153	9874	1850
19153	9874	480
19153	9874	7912
19153	9874	3788
8228	9875	8860
8228	9875	956
8228	9875	8087
8228	9875	9729
8228	9875	6653
8228	9875	2373
14432	9876	9590
14432	9876	7011
14432	9876	3018
14432	9876	2045
14432	9876	6377
524	9877	6774
524	9877	3890
524	9877	3245
524	9877	986
524	9877	7086
18918	9878	6675
18918	9878	4127
18918	9878	7276
18918	9878	7705
18918	9878	8626
18918	9878	1221
18918	9878	5582
18918	9878	5265
18918	9878	841
9460	9879	6706
9460	9879	552
9460	9879	8393
9460	9879	3250
9460	9879	1068
9460	9879	9090
9460	9879	6189
7787	9880	3643
7787	9880	9959
7787	9880	3881
7787	9880	4753
7787	9880	7262
14059	9881	7784
14059	9881	9947
14059	9881	9072
14059	9881	2136
14059	9881	3121
14059	9881	5333
3325	9882	6618
3325	9882	2124
3325	9882	6071
3325	9882	1799
18119	9883	6089
7744	9884	48
7744	9884	9474
7744	9884	3003
7744	9884	3408
7744	9884	1904
7744	9884	9998
13230	9885	3191
13230	9885	3371
13230	9885	8846
13230	9885	4049
13230	9885	4270
13230	9885	5330
13230	9885	4009
8112	9886	6239
8112	9886	8945
8112	9886	3322
8112	9886	645
8112	9886	5955
8112	9886	9933
6247	9887	8113
6247	9887	721
6247	9887	3530
6247	9887	2298
6247	9887	5591
6247	9887	7981
19930	9888	4951
19930	9888	6247
19930	9888	8612
19930	9888	1590
19930	9888	2779
19930	9888	2474
16807	9889	3178
16807	9889	4919
16807	9889	8371
7923	9890	6430
7923	9890	3513
7923	9890	484
7923	9890	3012
3247	9891	6190
3247	9891	9848
3247	9891	2433
3247	9891	7067
3247	9891	7252
3247	9891	8472
3247	9891	6953
3247	9891	9387
5816	9892	6791
5816	9892	2482
5816	9892	8042
5816	9892	4004
5816	9892	7117
5816	9892	3102
5816	9892	4025
12915	9893	1549
12915	9893	9282
12915	9893	6865
12915	9893	6863
12915	9893	8753
12915	9893	9159
12915	9893	4899
12915	9893	4399
12915	9893	3223
14454	9894	4852
14454	9894	3296
14454	9894	3268
14454	9894	5334
14454	9894	4302
14454	9894	5404
14454	9894	6904
14454	9894	9817
14454	9894	8519
15354	9895	3626
15354	9895	3710
15354	9895	228
15354	9895	4076
15354	9895	6573
15354	9895	7764
2063	9896	1742
2063	9896	21
2063	9896	3019
5669	9897	1404
5669	9897	5608
5669	9897	8450
5669	9897	2580
5669	9897	6083
5669	9897	8742
5669	9897	253
5669	9897	9085
13778	9898	27
93	9899	6970
93	9899	5604
93	9899	5278
1772	9900	120
1772	9900	386
1772	9900	7185
1772	9900	6359
1772	9900	4441
1772	9900	5453
1772	9900	2333
1772	9900	9939
19379	9901	2459
19379	9901	570
19379	9901	7033
13620	9902	5037
13620	9902	1246
13620	9902	3053
13620	9902	4549
13620	9902	5867
13620	9902	4856
13620	9902	8613
17101	9903	8240
1395	9904	8760
1395	9904	748
1395	9904	5167
1395	9904	696
1395	9904	4333
14771	9905	6797
3304	9906	8840
3304	9906	6324
3304	9906	4487
3304	9906	335
3304	9906	5261
3304	9906	3720
3304	9906	17
10365	9907	5385
10365	9907	484
10365	9907	3666
10365	9907	1181
10365	9907	7092
10365	9907	2115
10365	9907	8117
10365	9907	8028
5028	9908	1333
5028	9908	1333
5028	9908	8284
5028	9908	9520
5028	9908	6531
5028	9908	4675
5028	9908	7749
5028	9908	2925
5028	9908	6013
6209	9909	7754
6209	9909	4946
6209	9909	7004
6209	9909	8295
19254	9910	4680
19254	9910	6639
19254	9910	4686
19254	9910	5668
19254	9910	5085
16019	9911	2115
13124	9912	9126
13124	9912	7168
10924	9913	5089
10924	9913	9175
10924	9913	961
10924	9913	3967
19268	9914	3050
19268	9914	2076
19268	9914	52
19268	9914	4588
10574	9915	931
10574	9915	6007
10574	9915	7702
10574	9915	4744
10574	9915	549
10574	9915	2558
10574	9915	9730
10574	9915	7156
10574	9915	6158
18416	9916	7088
18416	9916	9042
18416	9916	5422
18416	9916	6962
18416	9916	9669
11350	9917	3818
8732	9918	5876
8732	9918	2305
8732	9918	5852
8732	9918	5193
8732	9918	7671
8732	9918	3481
5044	9919	2314
5044	9919	4529
5044	9919	1288
5044	9919	7658
2949	9920	5841
3432	9921	4748
3432	9921	7468
3432	9921	2567
3432	9921	6818
3432	9921	9896
3432	9921	8569
3432	9921	9466
3432	9921	9723
3432	9921	2865
1045	9922	1997
1045	9922	9870
1045	9922	5526
1045	9922	9553
1045	9922	5574
1045	9922	7549
1045	9922	4241
1045	9922	8179
1045	9922	6162
9461	9923	5613
9461	9923	9950
9461	9923	5135
9461	9923	9000
9461	9923	156
9461	9923	764
12579	9924	9901
12579	9924	2686
12579	9924	5207
12579	9924	7565
12579	9924	7986
12579	9924	1459
12579	9924	8457
12579	9924	431
760	9925	1585
760	9925	1303
760	9925	2542
760	9925	1764
760	9925	8356
16514	9926	5706
16514	9926	9372
16514	9926	9116
1148	9927	6435
1148	9927	9521
1148	9927	2641
1148	9927	1540
1148	9927	3613
12307	9928	7527
12307	9928	6086
12307	9928	1521
12307	9928	9731
12307	9928	2339
12307	9928	497
12307	9928	6459
16579	9929	551
16579	9929	4882
16579	9929	4532
16579	9929	7417
16579	9929	9263
16579	9929	4298
16579	9929	1109
16579	9929	7436
17912	9930	6183
17912	9930	7943
17912	9930	7595
17912	9930	4171
17912	9930	2690
17912	9930	8085
17912	9930	9581
17912	9930	6432
7695	9931	7229
7695	9931	2821
7695	9931	8378
7695	9931	5531
7695	9931	9212
7695	9931	6328
7695	9931	5474
7695	9931	2074
12489	9932	3360
12489	9932	4602
2066	9933	4881
2066	9933	1779
2066	9933	5861
8477	9934	1726
8477	9934	5309
8477	9934	9462
8477	9934	2324
8477	9934	3850
8477	9934	7779
2275	9935	4077
2275	9935	7991
2275	9935	4185
2275	9935	437
2275	9935	4980
2275	9935	563
2275	9935	535
4521	9936	314
4521	9936	7490
4521	9936	480
4521	9936	3633
4521	9936	7880
4521	9936	9395
4521	9936	2947
1874	9937	3808
17573	9938	4211
17573	9938	2377
17573	9938	4129
17573	9938	2319
17573	9938	806
17573	9938	7081
17573	9938	1149
18056	9939	4222
18056	9939	2410
18056	9939	585
18056	9939	906
18056	9939	2046
18056	9939	3179
18056	9939	4263
18056	9939	5248
18056	9939	3000
10637	9940	5127
10637	9940	591
10637	9940	1611
10637	9940	5303
10637	9940	9071
10637	9940	7961
10637	9940	9996
10637	9940	8490
10637	9940	2937
12229	9941	3503
12229	9941	9107
12229	9941	8538
4711	9942	3254
4711	9942	3223
4711	9942	7637
4711	9942	3177
4711	9942	8049
4711	9942	8188
4711	9942	9682
5236	9943	8732
5236	9943	9618
5236	9943	288
5236	9943	8737
5236	9943	6331
5236	9943	1181
5236	9943	7505
1453	9944	9252
1453	9944	5091
1453	9944	3613
1453	9944	5345
1453	9944	9955
1453	9944	5912
1453	9944	1441
1453	9944	8294
17163	9945	7407
17163	9945	6173
17163	9945	9355
17163	9945	3022
17163	9945	4404
17163	9945	8484
7149	9946	6853
7149	9946	1704
7149	9946	590
7149	9946	3975
7149	9946	2259
7149	9946	3088
7149	9946	849
7149	9946	4753
1850	9947	4602
1850	9947	8435
1850	9947	2185
1850	9947	2660
1850	9947	494
1850	9947	5390
1850	9947	9914
1850	9947	4153
16254	9948	395
16254	9948	6104
16254	9948	8490
16254	9948	9499
16254	9948	1781
16254	9948	5804
16254	9948	6205
16777	9949	5369
16777	9949	1661
16777	9949	8996
16777	9949	7851
16777	9949	2079
16777	9949	1276
16777	9949	9525
16777	9949	234
17447	9950	6194
17447	9950	8752
17447	9950	4647
69	9951	8081
69	9951	9044
69	9951	9472
69	9951	1317
69	9951	1188
69	9951	9880
69	9951	8008
16482	9952	6965
16482	9952	9457
16482	9952	9779
16482	9952	5154
16482	9952	3164
16482	9952	4460
16482	9952	8783
15652	9953	5865
15652	9953	2014
15652	9953	6994
15652	9953	9516
15652	9953	1297
12655	9954	7842
15242	9955	2047
15242	9955	9906
15242	9955	8029
15242	9955	9047
15242	9955	6514
15242	9955	7943
15242	9955	4928
15242	9955	9432
17894	9956	2595
17894	9956	9473
17894	9956	369
7462	9957	2247
7462	9957	3315
2687	9958	4593
2687	9958	3864
2687	9958	9734
18330	9959	8112
18330	9959	7484
18330	9959	7798
18330	9959	3995
14863	9960	9226
14863	9960	6186
14863	9960	6297
14863	9960	3884
14863	9960	2209
14863	9960	4492
14863	9960	1012
14863	9960	4864
14863	9960	3390
3002	9961	2208
3002	9961	2281
3002	9961	9175
3002	9961	3633
3002	9961	5755
3882	9962	1615
3882	9962	8649
6280	9963	7365
6280	9963	2270
6280	9963	334
6280	9963	2255
6280	9963	5435
6280	9963	4554
6280	9963	664
6280	9963	4266
41	9964	1962
7152	9965	7399
14585	9966	2050
4767	9967	5928
4767	9967	8151
4767	9967	3891
4767	9967	4210
18019	9968	9025
1105	9969	729
1105	9969	4244
1105	9969	8403
1105	9969	4725
1105	9969	3233
7945	9970	147
7945	9970	9245
7945	9970	6814
7945	9970	2193
7945	9970	2463
7945	9970	190
7945	9970	506
7945	9970	2040
5535	9971	6812
5535	9971	4509
15483	9972	1714
15483	9972	5784
15483	9972	5541
15483	9972	5898
15483	9972	8482
15483	9972	2278
15483	9972	8459
17928	9973	3182
17928	9973	7238
17928	9973	5044
17928	9973	2244
17928	9973	5584
6557	9974	820
6557	9974	867
6557	9974	4261
6557	9974	8715
6557	9974	4853
6557	9974	3686
6557	9974	3460
6557	9974	2275
6557	9974	587
15648	9975	1872
15648	9975	6669
15648	9975	2639
15648	9975	734
15648	9975	2968
15648	9975	5320
15648	9975	7915
13257	9976	7621
13257	9976	8762
13257	9976	2125
13257	9976	17
13257	9976	6493
920	9977	6671
920	9977	9863
920	9977	9839
5613	9978	6640
14475	9979	2688
14475	9979	8624
14475	9979	5393
10818	9980	7500
10818	9980	9436
10818	9980	6401
10818	9980	2585
10818	9980	5415
10818	9980	6859
10818	9980	5230
10818	9980	1524
10818	9980	9071
11526	9981	75
11526	9981	3243
11453	9982	4703
11453	9982	1257
11453	9982	5083
11453	9982	245
11453	9982	3920
11453	9982	91
11453	9982	6469
15986	9983	9811
15986	9983	4619
15986	9983	8089
15986	9983	7300
15986	9983	161
15986	9983	7057
15986	9983	8368
15986	9983	9412
8989	9984	2162
8989	9984	1803
8989	9984	1979
8989	9984	7572
8989	9984	6264
8989	9984	620
10478	9985	9933
10478	9985	473
10478	9985	8721
10478	9985	1130
10478	9985	9290
10478	9985	6712
10478	9985	5036
10478	9985	1331
10478	9985	5193
14342	9986	8935
14342	9986	1780
14342	9986	3743
14342	9986	4793
14342	9986	1977
14342	9986	1677
14342	9986	4818
11895	9987	6488
11895	9987	4456
11895	9987	8189
11895	9987	8720
11895	9987	8920
11895	9987	553
11895	9987	5189
11895	9987	7993
11895	9987	9042
7668	9988	8559
7668	9988	4227
8412	9989	3474
8412	9989	9548
8412	9989	7335
8412	9989	3716
8412	9989	1119
3343	9990	1159
3343	9990	6380
3343	9990	2685
3343	9990	4034
3343	9990	7960
3343	9990	5948
3343	9990	5969
3343	9990	6392
3343	9990	9165
17424	9991	6449
17424	9991	4495
17424	9991	4144
17424	9991	9238
17424	9991	8130
17424	9991	8053
17424	9991	595
17424	9991	691
17301	9992	837
17301	9992	8976
17301	9992	8482
17301	9992	7094
17301	9992	6852
6600	9993	866
6600	9993	1239
6600	9993	7644
11393	9994	6434
11298	9995	811
11298	9995	6132
11298	9995	1284
16753	9996	3264
16753	9996	8078
16753	9996	4747
16753	9996	202
16753	9996	9047
19092	9997	640
19092	9997	3801
19092	9997	5624
19092	9997	9305
19092	9997	1075
19092	9997	6222
19092	9997	49
19092	9997	734
19092	9997	8926
14007	9998	5948
14007	9998	7206
5119	9999	1791
5119	9999	5223
5119	9999	1542
5119	9999	2611
5119	9999	7281
7004	10000	7650
7004	10000	580
7004	10000	774
7004	10000	3579
7004	10000	8275
7004	10000	8293
12934	10001	6941
12934	10001	5365
12934	10001	7332
12934	10001	6645
12934	10001	240
12934	10001	6731
12934	10001	4020
12934	10001	4615
2761	10002	6378
2761	10002	2423
2761	10002	4496
2761	10002	9165
2761	10002	2507
2761	10002	9548
2761	10002	6104
2761	10002	4499
2761	10002	7799
16077	10003	7161
16077	10003	8585
16213	10004	7127
16213	10004	706
10403	10005	6016
10403	10005	5432
10403	10005	7541
10403	10005	475
16547	10006	6312
6944	10007	5247
6944	10007	9336
12923	10008	6011
12923	10008	1082
12923	10008	6171
12923	10008	9694
12923	10008	2660
12923	10008	3137
16213	10009	8549
16213	10009	4959
16213	10009	1191
12874	10010	4838
12874	10010	8218
8457	10011	5827
8457	10011	3362
8457	10011	3014
8457	10011	2754
8457	10011	9155
8457	10011	4256
5608	10012	3997
5608	10012	243
5608	10012	5907
5608	10012	8174
5608	10012	3675
5608	10012	3516
5608	10012	620
5608	10012	5124
5608	10012	169
6365	10013	9332
6365	10013	6748
6365	10013	4221
6365	10013	6392
6365	10013	671
1826	10014	5285
1826	10014	8620
1826	10014	1371
1826	10014	7817
1826	10014	893
1826	10014	8437
1826	10014	1425
1826	10014	4244
7152	10015	7164
7152	10015	3101
7543	10016	4684
7543	10016	6156
7543	10016	5727
7543	10016	8927
7543	10016	6911
7543	10016	9088
7543	10016	9684
7543	10016	8866
6220	10017	6686
6220	10017	4922
6220	10017	435
13489	10018	5024
13489	10018	2094
15640	10019	4917
15640	10019	2116
15640	10019	669
15640	10019	1529
15640	10019	2907
19887	10020	6569
19887	10020	3178
19887	10020	5451
19887	10020	3749
19887	10020	1927
19887	10020	3721
19887	10020	9951
19887	10020	1839
19887	10020	5538
15305	10021	9451
15305	10021	8973
15305	10021	1745
15305	10021	2301
15305	10021	946
15305	10021	1680
15305	10021	5873
15305	10021	4704
15305	10021	4374
16189	10022	8261
16189	10022	4249
16189	10022	9245
16189	10022	1450
16189	10022	2456
16189	10022	2293
16189	10022	3258
16189	10022	3045
7979	10023	8113
7979	10023	7099
7979	10023	9922
7979	10023	9447
7979	10023	9567
7979	10023	6658
7979	10023	2585
7979	10023	1624
7979	10023	3924
12759	10024	7808
12759	10024	8164
12759	10024	2790
12759	10024	4841
5906	10025	5770
5906	10025	4991
5906	10025	5752
5906	10025	5312
15792	10026	9725
15792	10026	7080
15792	10026	3618
15792	10026	5684
7694	10027	300
13440	10028	239
13440	10028	3246
13440	10028	1054
13440	10028	9787
13440	10028	1407
13440	10028	4261
7971	10029	5543
7971	10029	4309
7971	10029	7003
18556	10030	6395
18556	10030	2092
18556	10030	7768
18556	10030	2302
18556	10030	7560
14692	10031	9516
14692	10031	6138
16195	10032	3675
16195	10032	4735
16195	10032	5848
16195	10032	9955
12698	10033	2813
12698	10033	9602
12698	10033	255
12698	10033	8469
12698	10033	4508
12698	10033	1681
12698	10033	2169
270	10034	3644
270	10034	1913
270	10034	267
270	10034	8187
270	10034	7277
270	10034	6571
270	10034	637
270	10034	7995
16498	10035	8514
16498	10035	1152
16498	10035	5930
11285	10036	4301
11285	10036	3517
11285	10036	5477
11285	10036	3974
2502	10037	3
15994	10038	6246
15994	10038	7418
15994	10038	7211
15994	10038	4953
15994	10038	1890
10690	10039	2443
10690	10039	9296
10690	10039	4192
16393	10040	8772
16393	10040	6276
16393	10040	2520
16393	10040	3183
16393	10040	9484
16393	10040	3524
16393	10040	9170
16393	10040	9835
17233	10041	1699
17233	10041	8740
17233	10041	6766
17233	10041	4265
17233	10041	1128
17233	10041	6959
17233	10041	3308
17233	10041	8629
3622	10042	2411
3622	10042	3593
3622	10042	6591
3622	10042	2639
3622	10042	2043
3622	10042	6363
3622	10042	7888
9308	10043	3002
9308	10043	7784
9308	10043	9059
9308	10043	3196
9308	10043	6918
9308	10043	9498
9308	10043	7509
9308	10043	9625
9308	10043	3488
12251	10044	5167
12251	10044	310
12251	10044	5709
12251	10044	7709
12251	10044	4045
12251	10044	2901
3919	10045	9647
3919	10045	4477
3919	10045	1346
3919	10045	1052
9077	10046	664
9077	10046	4181
9077	10046	2037
9077	10046	8886
9077	10046	9536
9077	10046	1487
9077	10046	7305
15951	10047	1843
15951	10047	8163
15951	10047	5137
15951	10047	8304
15951	10047	478
15951	10047	726
15951	10047	9001
15951	10047	9091
2255	10048	8873
2255	10048	2699
2255	10048	789
2255	10048	4747
2255	10048	7979
2255	10048	4523
5370	10049	2193
5370	10049	8410
18270	10050	525
18270	10050	8015
18270	10050	548
18270	10050	3849
18270	10050	2896
7368	10051	9880
7368	10051	5619
7368	10051	4350
7368	10051	7088
7368	10051	4927
6672	10052	2471
5989	10053	739
5989	10053	9298
5989	10053	1669
5989	10053	1135
15371	10054	2215
15371	10054	159
15371	10054	4298
15371	10054	7055
15371	10054	6525
15371	10054	2560
10061	10055	8025
10061	10055	1959
10061	10055	4703
10061	10055	3350
10061	10055	3449
10061	10055	7820
10061	10055	2170
10061	10055	5082
10479	10056	2485
10479	10056	8909
10479	10056	9990
10479	10056	7484
10479	10056	6499
10479	10056	1089
10479	10056	691
10479	10056	3287
10479	10056	4304
15505	10057	7078
15505	10057	3379
15505	10057	7676
15505	10057	7399
15505	10057	8451
15505	10057	6628
15505	10057	8892
15505	10057	8828
15505	10057	9358
893	10058	3494
893	10058	696
893	10058	9772
893	10058	5550
893	10058	2045
10848	10059	4190
10848	10059	483
14220	10060	3727
6170	10061	3532
6170	10061	7247
15885	10062	403
15885	10062	7798
15885	10062	2998
15885	10062	7871
15885	10062	3839
15885	10062	9966
15885	10062	4701
9398	10063	3525
9398	10063	8242
9398	10063	2267
9398	10063	1676
9398	10063	8797
7237	10064	3989
7237	10064	305
7237	10064	5495
7237	10064	4768
7237	10064	236
7237	10064	3653
7237	10064	6766
7237	10064	9635
6318	10065	834
6318	10065	254
6318	10065	1856
6318	10065	1320
6318	10065	2669
6318	10065	7168
6318	10065	550
6318	10065	3643
16822	10066	3145
16822	10066	820
16822	10066	4113
16822	10066	9664
16822	10066	3613
16822	10066	2834
6174	10067	2138
6174	10067	3250
6174	10067	5311
6174	10067	1464
10212	10068	3517
10212	10068	9422
10212	10068	6311
10212	10068	6570
12467	10069	5974
12467	10069	8755
12467	10069	695
12467	10069	1997
10492	10070	5664
10492	10070	5157
10492	10070	4207
10492	10070	7092
10492	10070	4342
10492	10070	4383
10492	10070	6755
10492	10070	1075
10492	10070	7186
6320	10071	1217
6427	10072	8460
8246	10073	7677
8246	10073	1723
8246	10073	5650
8246	10073	1281
8246	10073	6716
15579	10074	3639
15579	10074	1331
15579	10074	7757
15579	10074	1246
15579	10074	5761
15579	10074	4191
15579	10074	2848
15579	10074	8343
12038	10075	787
4135	10076	103
4135	10076	650
4135	10076	9332
1324	10077	3210
17941	10078	3191
17941	10078	2455
17941	10078	270
17941	10078	7552
17941	10078	893
17941	10078	4908
17941	10078	405
17941	10078	9898
1093	10079	4834
1093	10079	6238
1093	10079	9515
1093	10079	8843
1093	10079	8418
1093	10079	2842
10592	10080	6109
10592	10080	8432
10592	10080	9029
10592	10080	4039
7871	10081	4482
7871	10081	244
7871	10081	4962
7871	10081	5531
7871	10081	5929
8693	10082	5955
8693	10082	6696
5608	10083	9805
5608	10083	2906
5608	10083	8249
5608	10083	7778
5608	10083	5996
5608	10083	4225
5608	10083	1575
5608	10083	2720
5608	10083	3662
4440	10084	3620
4440	10084	3015
4440	10084	8044
4440	10084	3120
4440	10084	3716
13243	10085	7950
13243	10085	3082
13243	10085	6804
13243	10085	184
13243	10085	6492
306	10086	2373
306	10086	2509
306	10086	3496
306	10086	6308
306	10086	9674
306	10086	9368
306	10086	2351
18236	10087	3663
18236	10087	1905
18236	10087	1291
18236	10087	8845
18236	10087	4992
18236	10087	7935
18236	10087	1290
18236	10087	1091
9173	10088	6126
9173	10088	2035
9173	10088	2385
4791	10089	356
4791	10089	6394
4791	10089	7632
12952	10090	805
12952	10090	5883
12952	10090	3707
12952	10090	5893
12952	10090	1561
12952	10090	2613
12952	10090	4211
12952	10090	3179
12952	10090	9033
5071	10091	9701
5071	10091	1605
5071	10091	1171
5071	10091	3808
5071	10091	5292
5071	10091	36
5071	10091	6706
5071	10091	8149
5071	10091	3748
12721	10092	1008
12721	10092	8618
15216	10093	6954
15216	10093	5836
15216	10093	9607
6828	10094	8026
6828	10094	978
6828	10094	7418
6828	10094	7328
6828	10094	8835
6828	10094	7526
6828	10094	7163
6828	10094	6802
6828	10094	8573
2296	10095	3423
6060	10096	6444
6060	10096	3213
6060	10096	4565
6060	10096	9199
13053	10097	1666
13053	10097	8380
10361	10098	7239
10361	10098	8925
10361	10098	8337
10361	10098	1888
10361	10098	5377
10361	10098	646
10361	10098	24
9176	10099	6570
9176	10099	2014
9176	10099	3517
9176	10099	388
9176	10099	2508
14231	10100	5111
14231	10100	5960
14231	10100	8642
14231	10100	683
2657	10101	5187
2657	10101	1593
2657	10101	7615
2657	10101	4601
2657	10101	7879
2657	10101	3308
2657	10101	13
14176	10102	1402
14176	10102	1521
14176	10102	1488
14176	10102	5209
14176	10102	4180
36	10103	2145
36	10103	1920
36	10103	8951
36	10103	9387
36	10103	4638
36	10103	5095
36	10103	8508
36	10103	1737
6278	10104	500
6278	10104	9862
6278	10104	3136
6278	10104	7898
6278	10104	4059
6278	10104	5318
6278	10104	7882
6278	10104	5963
6278	10104	3758
16790	10105	3045
16790	10105	1707
16790	10105	7988
16790	10105	7920
16790	10105	9586
16790	10105	8431
16790	10105	4128
16790	10105	3489
15094	10106	3751
15094	10106	753
15094	10106	3833
15094	10106	5061
6205	10107	9652
6205	10107	731
6205	10107	7840
6205	10107	5105
6205	10107	7071
6205	10107	6873
722	10108	7908
722	10108	6815
722	10108	9344
6352	10109	669
6352	10109	9533
6352	10109	933
6352	10109	4871
6352	10109	6824
6352	10109	314
14768	10110	8583
14768	10110	7369
14768	10110	3862
14768	10110	4149
14768	10110	6935
14768	10110	8243
14768	10110	6668
14673	10111	4252
14673	10111	3452
14673	10111	7899
14673	10111	1832
3935	10112	8976
3935	10112	8231
3935	10112	5985
3935	10112	1621
3935	10112	2769
3935	10112	3626
3935	10112	6859
3187	10113	5861
3187	10113	2871
3187	10113	1003
3187	10113	9589
3187	10113	8982
3187	10113	4803
7556	10114	122
7556	10114	9783
7556	10114	4874
7556	10114	298
7556	10114	3562
7556	10114	8792
7556	10114	8749
9218	10115	3922
9218	10115	5167
9218	10115	2139
9218	10115	5302
9523	10116	2452
9523	10116	2221
9523	10116	2583
9523	10116	4785
9523	10116	5593
9523	10116	36
9523	10116	3240
9533	10117	9164
9533	10117	8409
9533	10117	824
9533	10117	8478
9533	10117	7488
9533	10117	887
9533	10117	4683
9533	10117	9045
9533	10117	5572
713	10118	8703
713	10118	3975
713	10118	3326
713	10118	6708
713	10118	3884
713	10118	4032
713	10118	202
713	10118	2840
713	10118	980
3732	10119	5204
1550	10120	1131
1550	10120	1055
10058	10121	9808
10058	10121	8296
4655	10122	7183
4655	10122	3233
4655	10122	9150
4655	10122	29
4655	10122	9676
14282	10123	8605
14282	10123	8171
14282	10123	6971
14282	10123	4688
14282	10123	8000
12590	10124	8622
12590	10124	6135
18735	10125	8480
18735	10125	9822
10157	10126	9539
10157	10126	2370
10157	10126	3559
10157	10126	4133
10157	10126	8086
10625	10127	6893
6055	10128	2395
6055	10128	228
6055	10128	813
6055	10128	9029
6055	10128	5127
6055	10128	5271
6055	10128	8224
6055	10128	2375
13015	10129	8639
13015	10129	378
13015	10129	3695
13015	10129	4114
13015	10129	298
5385	10130	3566
5385	10130	7153
5385	10130	4636
5385	10130	6918
5385	10130	6945
5385	10130	7546
5385	10130	6924
13904	10131	9721
13904	10131	1531
13904	10131	7240
13904	10131	2206
13904	10131	2610
12788	10132	991
12788	10132	6390
12788	10132	5617
12788	10132	5533
6156	10133	7604
6156	10133	2325
6156	10133	2171
6156	10133	7165
6156	10133	5461
15332	10134	6748
15332	10134	8349
18680	10135	4966
18680	10135	5665
18680	10135	4447
12653	10136	4033
12653	10136	8376
11080	10137	9945
11080	10137	6982
11080	10137	1204
11080	10137	4059
11080	10137	6662
11080	10137	8892
11080	10137	2383
11080	10137	4818
11080	10137	4356
15864	10138	9112
15864	10138	3459
14629	10139	6631
14629	10139	4981
14629	10139	4857
14629	10139	7342
14629	10139	5737
14629	10139	8941
2647	10140	9371
2647	10140	1018
13217	10141	6232
13217	10141	7372
13217	10141	3953
13217	10141	7790
13217	10141	3369
13217	10141	4196
13217	10141	8955
13217	10141	7140
13217	10141	5541
4952	10142	4229
4952	10142	649
4952	10142	8306
4952	10142	1855
4952	10142	1308
4952	10142	8125
4952	10142	145
4952	10142	9078
4891	10143	670
4891	10143	8394
4891	10143	4350
4891	10143	3889
4891	10143	6410
4891	10143	1476
4891	10143	8064
12739	10144	7856
12739	10144	5826
12739	10144	3534
12739	10144	8057
12739	10144	3904
12739	10144	5056
12739	10144	7574
11934	10145	9902
11934	10145	2284
11934	10145	8714
11934	10145	6950
11934	10145	5884
11934	10145	3147
11934	10145	574
11934	10145	4285
15637	10146	429
15637	10146	5754
15637	10146	881
15637	10146	1210
15637	10146	9295
18391	10147	5507
18391	10147	9805
18391	10147	7657
18391	10147	5291
18391	10147	5118
18391	10147	1804
17569	10148	3822
17569	10148	904
17569	10148	3134
17569	10148	2903
17569	10148	6931
1383	10149	6737
1383	10149	2135
19583	10150	594
19583	10150	510
19583	10150	6749
19583	10150	1182
19583	10150	7404
16614	10151	92
16614	10151	9097
16614	10151	9677
16614	10151	7713
16614	10151	9440
3149	10152	1366
3149	10152	1966
3149	10152	564
3149	10152	4357
3149	10152	5247
3149	10152	1282
3149	10152	542
10238	10153	2599
4550	10154	3343
4550	10154	231
4550	10154	5947
4550	10154	8629
4550	10154	4439
4550	10154	9271
7255	10155	9166
7255	10155	965
7255	10155	6496
7255	10155	4826
7255	10155	2969
7255	10155	898
7255	10155	9700
7255	10155	6820
14101	10156	8271
14101	10156	3462
14101	10156	3573
14101	10156	7711
14101	10156	6361
14101	10156	4957
11843	10157	7843
1623	10158	1849
1623	10158	993
1623	10158	223
1623	10158	5719
1623	10158	7346
1616	10159	3541
1616	10159	7766
5445	10160	8644
5445	10160	8170
5445	10160	717
5445	10160	7297
5445	10160	7598
5445	10160	5380
5445	10160	7814
5445	10160	9786
14263	10161	7939
14263	10161	8851
14263	10161	8625
14263	10161	1380
14263	10161	9339
14263	10161	1110
14263	10161	7465
16363	10162	6380
16363	10162	911
17450	10163	2257
17450	10163	4819
17450	10163	5264
17450	10163	3995
17450	10163	4237
17450	10163	731
17450	10163	5677
13573	10164	6066
13573	10164	8069
13573	10164	4285
13573	10164	7094
13573	10164	6208
13573	10164	3921
13573	10164	2683
13573	10164	1106
13573	10164	5954
19897	10165	2568
19897	10165	112
19897	10165	1284
19897	10165	5030
19897	10165	2422
981	10166	4939
981	10166	1336
981	10166	965
981	10166	4715
981	10166	1432
981	10166	1149
2814	10167	5902
2814	10167	3888
2814	10167	8146
6352	10168	4272
6298	10169	9119
6298	10169	7544
6298	10169	9091
6298	10169	3731
6298	10169	8079
6298	10169	7909
10486	10170	5145
10486	10170	8201
13496	10171	7717
13496	10171	2870
13496	10171	3888
13496	10171	5574
13496	10171	9206
13496	10171	3089
13639	10172	1698
13639	10172	3723
13639	10172	1971
13639	10172	171
16741	10173	5119
16741	10173	2008
16741	10173	7611
16741	10173	2011
16741	10173	248
18907	10174	7750
18907	10174	4412
18907	10174	9529
18907	10174	3297
18907	10174	4093
18907	10174	9918
18907	10174	2382
5575	10175	9660
5575	10175	587
5575	10175	5798
5575	10175	8769
5575	10175	182
5575	10175	5498
5575	10175	864
10551	10176	1385
10551	10176	9738
10551	10176	8379
10551	10176	9740
10551	10176	3069
10551	10176	3548
6415	10177	478
18493	10178	2518
18493	10178	4372
18493	10178	3490
18493	10178	8657
82	10179	5518
82	10179	7209
82	10179	5558
82	10179	7631
82	10179	2260
82	10179	2313
82	10179	8465
3546	10180	5263
3546	10180	8847
3546	10180	7936
3546	10180	964
3546	10180	5643
3546	10180	6633
3546	10180	6334
3546	10180	6858
4831	10181	1521
4831	10181	2793
4831	10181	1242
4831	10181	6623
4831	10181	3031
16585	10182	7927
16585	10182	4890
16585	10182	7741
8747	10183	6524
8747	10183	7546
8747	10183	1866
8747	10183	8970
3525	10184	3020
3525	10184	3788
3525	10184	2500
3525	10184	4342
3525	10184	48
3525	10184	6862
3525	10184	1159
3525	10184	5471
16126	10185	7514
16126	10185	9431
16126	10185	1742
16126	10185	2764
16126	10185	163
6365	10186	9232
6365	10186	9155
18406	10187	4141
18406	10187	3498
18406	10187	5829
18406	10187	7674
18406	10187	7971
18406	10187	9037
18406	10187	4566
18406	10187	5803
18406	10187	9964
15673	10188	9497
15673	10188	7456
18980	10189	8386
18980	10189	4797
18980	10189	1607
18980	10189	4355
18980	10189	9286
18980	10189	4467
18980	10189	9727
18980	10189	9099
18126	10190	6900
18126	10190	4805
18126	10190	9021
18126	10190	5048
5804	10191	4898
13007	10192	5783
13007	10192	8697
13007	10192	1798
13007	10192	9281
13007	10192	3953
13007	10192	9960
13717	10193	3254
13717	10193	6377
13717	10193	6084
13717	10193	1204
12201	10194	2604
16772	10195	8636
16772	10195	3769
16772	10195	8780
16772	10195	3558
16772	10195	3168
18511	10196	4365
18511	10196	7152
18511	10196	1491
18511	10196	5301
18511	10196	4456
18511	10196	28
18511	10196	6329
18511	10196	5445
8159	10197	1996
8159	10197	3510
8159	10197	7814
8159	10197	8423
8159	10197	5932
8159	10197	2261
18826	10198	7768
4446	10199	9282
9452	10200	8805
9452	10200	4526
9452	10200	7877
9452	10200	6353
9452	10200	4711
9452	10200	9101
9452	10200	184
9452	10200	939
3364	10201	7726
3364	10201	765
3364	10201	9276
3364	10201	3580
3364	10201	4772
3364	10201	4730
3364	10201	885
3364	10201	4377
1458	10202	5504
1458	10202	2642
7160	10203	5262
7160	10203	4230
7160	10203	3101
7160	10203	477
7160	10203	5040
7160	10203	8370
6198	10204	2354
6198	10204	5785
6198	10204	8493
6198	10204	1641
6198	10204	3788
6198	10204	9684
6198	10204	7862
6247	10205	6111
6247	10205	3611
6247	10205	3673
6247	10205	643
6247	10205	8462
6247	10205	5141
6247	10205	3806
6247	10205	9612
16210	10206	2101
16210	10206	3059
16210	10206	2315
16210	10206	6114
16210	10206	4044
16210	10206	5320
16210	10206	5603
16210	10206	6742
14769	10207	4166
14769	10207	7890
14769	10207	3951
14769	10207	7562
14769	10207	5607
14769	10207	9862
5839	10208	3840
5839	10208	17
5839	10208	9912
11030	10209	4791
11030	10209	2163
11030	10209	7889
11030	10209	2564
11030	10209	4301
3724	10210	9250
3724	10210	6593
3724	10210	380
3724	10210	3565
3724	10210	1689
3724	10210	2102
3724	10210	8919
3724	10210	7116
3811	10211	8013
3811	10211	3409
3811	10211	8698
3811	10211	7090
3811	10211	9571
3811	10211	864
3811	10211	2149
5057	10212	6748
5057	10212	6216
5057	10212	6830
7889	10213	5850
7889	10213	984
7889	10213	6270
7889	10213	4438
3055	10214	6216
3055	10214	490
19119	10215	2194
19119	10215	4035
19119	10215	6489
19119	10215	3543
19119	10215	4808
19119	10215	9381
19119	10215	5212
19119	10215	4520
17916	10216	485
17916	10216	8527
17916	10216	1204
17916	10216	5066
17916	10216	8576
17916	10216	5275
17916	10216	3599
176	10217	5564
176	10217	4582
176	10217	5639
316	10218	9116
19201	10219	6302
19201	10219	4463
19201	10219	8789
19201	10219	7326
19201	10219	3807
5968	10220	5704
5968	10220	8525
5968	10220	1520
5968	10220	79
2704	10221	9074
2704	10221	3037
2704	10221	9256
2704	10221	2511
2598	10222	5362
2598	10222	8954
2598	10222	3545
2598	10222	2278
2598	10222	6542
2598	10222	9534
2598	10222	4966
2598	10222	4888
3556	10223	5587
9684	10224	8560
9684	10224	4037
9684	10224	3830
5567	10225	2749
5567	10225	8667
5567	10225	1213
5567	10225	7351
5567	10225	7813
5567	10225	5465
5567	10225	4016
5567	10225	8813
5567	10225	3946
18083	10226	4842
18083	10226	8318
18083	10226	5214
6691	10227	3755
6691	10227	3494
6691	10227	478
6691	10227	1145
13218	10228	4796
13218	10228	6699
13218	10228	4919
13218	10228	7783
13218	10228	4147
13218	10228	2512
13218	10228	1296
5500	10229	6954
893	10230	1290
893	10230	1311
893	10230	7545
4681	10231	1081
4681	10231	9310
4681	10231	5869
4681	10231	1487
4681	10231	5919
4681	10231	6104
4681	10231	5532
4681	10231	2839
10764	10232	8403
10764	10232	2725
539	10233	2610
7380	10234	2553
7380	10234	992
7380	10234	5763
7380	10234	6821
7380	10234	9484
7380	10234	9040
7380	10234	4838
15538	10235	1991
15538	10235	5821
15538	10235	5820
15538	10235	644
15538	10235	6253
15538	10235	2119
9343	10236	8711
9343	10236	4309
9343	10236	2781
9343	10236	7884
9343	10236	6115
9343	10236	2858
9343	10236	491
4961	10237	3064
4961	10237	9655
4961	10237	5481
4961	10237	2577
4961	10237	3675
4961	10237	2271
1962	10238	6513
8792	10239	7118
15215	10240	88
15215	10240	84
15215	10240	1168
15215	10240	6857
18867	10241	8417
18867	10241	8146
18867	10241	7499
18867	10241	5488
18867	10241	407
18867	10241	8407
18867	10241	564
18867	10241	1946
18867	10241	3131
6437	10242	6369
6437	10242	9138
6437	10242	6757
6437	10242	2659
6437	10242	4102
6437	10242	7522
6437	10242	5874
6437	10242	133
6437	10242	9032
14877	10243	2962
14877	10243	6871
12373	10244	5586
9446	10245	9505
9446	10245	8868
9446	10245	2640
9446	10245	5853
9446	10245	1410
9446	10245	9873
9446	10245	6525
9446	10245	7880
1683	10246	6934
1683	10246	6151
1683	10246	2100
1683	10246	1925
1683	10246	6459
1683	10246	1071
1683	10246	2394
1683	10246	9569
1683	10246	6328
15474	10247	8178
15474	10247	4620
15474	10247	9743
15474	10247	6898
7664	10248	77
7664	10248	5565
7664	10248	5192
7664	10248	2832
10450	10249	258
10450	10249	2977
10450	10249	265
10450	10249	7221
10450	10249	2316
10450	10249	4500
10450	10249	9554
14463	10250	1060
13250	10251	8649
13250	10251	4170
13250	10251	5365
13250	10251	4190
13250	10251	2898
13250	10251	9425
13250	10251	1550
13250	10251	1606
12210	10252	7503
12210	10252	5270
12210	10252	7499
12210	10252	8038
12210	10252	2954
12210	10252	8120
12210	10252	5485
12210	10252	8237
4852	10253	9592
4852	10253	8719
4852	10253	2540
4852	10253	5008
4852	10253	6429
4852	10253	9063
8665	10254	662
8665	10254	5412
8665	10254	45
8665	10254	5217
8665	10254	5819
16953	10255	4033
16953	10255	8742
16953	10255	6613
3241	10256	2553
3241	10256	3435
3241	10256	5701
3241	10256	5452
3241	10256	4797
3241	10256	9977
3241	10256	4393
3241	10256	369
3241	10256	8647
9052	10257	9997
9052	10257	5471
9052	10257	9615
3840	10258	3288
17977	10259	5351
17977	10259	7348
17977	10259	1218
17977	10259	521
17977	10259	1951
17977	10259	8332
15848	10260	6258
15848	10260	300
15848	10260	7375
15848	10260	7791
2158	10261	68
10835	10262	745
10835	10262	5918
10835	10262	7671
10835	10262	433
8251	10263	7816
8251	10263	693
16134	10264	3491
16134	10264	4925
16134	10264	6300
16134	10264	8889
7512	10265	9841
7512	10265	2418
5701	10266	6976
5701	10266	1462
5701	10266	7625
5701	10266	2906
5701	10266	221
5701	10266	7525
5701	10266	5504
5701	10266	4111
5701	10266	7442
15701	10267	9004
15701	10267	5464
15701	10267	4107
15242	10268	5062
15242	10268	6039
17889	10269	8494
17889	10269	3702
17889	10269	6340
17889	10269	5801
17889	10269	812
17889	10269	1631
17889	10269	2973
17889	10269	4163
17889	10269	2056
12655	10270	7575
12655	10270	8758
17054	10271	8516
4435	10272	29
1681	10273	8408
1681	10273	6277
1681	10273	2992
1681	10273	839
1681	10273	4660
1681	10273	9126
15766	10274	6410
15766	10274	1319
10421	10275	5442
10421	10275	5353
10421	10275	8012
10421	10275	5095
10421	10275	1492
8965	10276	2465
8965	10276	6556
8965	10276	6596
8965	10276	9472
8965	10276	5553
8965	10276	846
8965	10276	807
8965	10276	2081
8965	10276	4802
309	10277	7090
309	10277	9551
309	10277	3441
6288	10278	7506
6288	10278	7117
6288	10278	9157
6288	10278	6544
6288	10278	2470
6552	10279	1225
6552	10279	1183
6552	10279	2644
6552	10279	9478
18056	10280	7567
18056	10280	6811
18056	10280	6904
18056	10280	854
21	10281	4720
21	10281	2350
21	10281	6354
21	10281	9960
21	10281	2528
10343	10282	4905
10343	10282	2429
10343	10282	3192
10343	10282	4596
2999	10283	5520
2999	10283	6791
2999	10283	7698
2999	10283	9204
2999	10283	7810
2999	10283	85
2999	10283	3135
14117	10284	459
14117	10284	7737
14117	10284	5907
14117	10284	2882
14117	10284	931
14117	10284	2002
14117	10284	5589
14117	10284	7986
11366	10285	5731
11366	10285	8409
11366	10285	9469
16761	10286	6592
16761	10286	8899
16761	10286	1948
16761	10286	5257
16761	10286	5308
16761	10286	3637
18449	10287	1604
18449	10287	5104
18449	10287	1329
18449	10287	7192
18449	10287	6650
18449	10287	1281
18449	10287	5041
18449	10287	1288
18449	10287	8943
1781	10288	5719
1781	10288	7404
17679	10289	8261
17679	10289	915
17679	10289	5676
5734	10290	9527
9135	10291	6200
9135	10291	7398
9135	10291	2977
9135	10291	3376
9135	10291	2689
9135	10291	8050
9135	10291	9619
15757	10292	1243
15757	10292	5892
15757	10292	5353
15757	10292	6289
4426	10293	9425
4426	10293	6362
4426	10293	7805
4426	10293	9212
3799	10294	2196
3799	10294	2710
3799	10294	9456
3799	10294	8577
3799	10294	2007
3799	10294	6140
4856	10295	4641
4856	10295	7747
4856	10295	7331
4856	10295	887
196	10296	1998
196	10296	7559
537	10297	9790
537	10297	7
537	10297	2166
537	10297	9156
537	10297	8574
537	10297	7977
537	10297	3080
537	10297	7279
537	10297	9831
6553	10298	4754
6553	10298	137
19977	10299	9297
19977	10299	1272
19977	10299	4166
19977	10299	5448
8041	10300	7235
8041	10300	1643
8041	10300	8205
8041	10300	2679
8041	10300	4750
8041	10300	5611
11493	10301	5735
11493	10301	9230
11493	10301	6764
11493	10301	4333
11493	10301	3939
11493	10301	4250
17928	10302	6758
9924	10303	8712
9924	10303	9167
9924	10303	5168
9924	10303	69
9924	10303	6025
9924	10303	1377
9924	10303	834
9924	10303	5755
19386	10304	1575
19386	10304	2283
19386	10304	9782
10657	10305	3554
10657	10305	5401
10657	10305	7036
10657	10305	3090
10657	10305	7552
10657	10305	2907
10657	10305	4367
10657	10305	7069
10657	10305	8907
7706	10306	2600
7706	10306	765
19167	10307	9319
19167	10307	7494
19167	10307	3984
19167	10307	5289
19167	10307	1632
9077	10308	8279
14369	10309	1038
7275	10310	6019
7275	10310	2224
7275	10310	1722
18430	10311	3744
18430	10311	6048
18430	10311	4390
18430	10311	9913
18430	10311	2789
18430	10311	4992
18430	10311	5376
18430	10311	3952
18430	10311	4392
1112	10312	7499
1112	10312	9796
1112	10312	2235
1112	10312	8435
1112	10312	3761
1112	10312	47
8872	10313	593
8872	10313	5657
8872	10313	8295
8872	10313	5548
8872	10313	7445
8872	10313	8074
8872	10313	495
15985	10314	7213
15985	10314	8143
15985	10314	7966
15985	10314	7825
10755	10315	2843
10755	10315	8585
10755	10315	8623
10755	10315	9531
13950	10316	4469
13950	10316	3740
13950	10316	2595
13950	10316	1388
13950	10316	443
13950	10316	5454
13950	10316	1433
6286	10317	6897
6286	10317	1906
6286	10317	9997
6286	10317	2359
6286	10317	4699
6286	10317	6502
6286	10317	8681
6286	10317	3410
12010	10318	5812
2531	10319	4544
2531	10319	4493
2777	10320	6869
2777	10320	9964
2777	10320	4220
2777	10320	711
2777	10320	3469
2777	10320	1691
2777	10320	1811
2777	10320	2883
2777	10320	1078
1990	10321	2344
1990	10321	9946
14950	10322	6910
14950	10322	7091
14950	10322	4321
10062	10323	4422
10062	10323	1881
10062	10323	4413
10062	10323	1436
10062	10323	3457
6832	10324	7919
6832	10324	5666
6832	10324	9178
6832	10324	8019
6832	10324	8983
6832	10324	2961
6832	10324	6420
6832	10324	8334
5510	10325	8987
5510	10325	6141
19194	10326	3013
19194	10326	7389
19194	10326	4356
19194	10326	6552
19194	10326	6943
19194	10326	9622
19194	10326	9679
19194	10326	9228
15122	10327	316
15122	10327	7951
15122	10327	3305
15122	10327	9723
15122	10327	3688
15122	10327	3939
2654	10328	4381
2654	10328	1161
2654	10328	8752
2654	10328	7249
2654	10328	3364
2654	10328	4528
2654	10328	4038
8706	10329	3655
8706	10329	9054
8706	10329	4479
8706	10329	3996
8706	10329	9442
14145	10330	1255
14145	10330	5448
14145	10330	6834
14145	10330	8437
5930	10331	2041
5930	10331	7563
5930	10331	2612
3331	10332	4407
3331	10332	9833
19154	10333	3702
18300	10334	1846
18300	10334	3830
18300	10334	3583
18300	10334	4229
3581	10335	3007
3581	10335	6392
3581	10335	1813
3581	10335	6189
3581	10335	4646
11131	10336	7740
11131	10336	4074
11131	10336	3222
11131	10336	539
11131	10336	6938
2332	10337	2956
2332	10337	8358
2332	10337	3602
2332	10337	3563
19501	10338	1793
9164	10339	4171
9164	10339	3418
9164	10339	3197
9164	10339	4443
11918	10340	9590
11918	10340	1028
11918	10340	218
11918	10340	2696
11918	10340	42
11918	10340	3531
11918	10340	8434
11918	10340	5381
17171	10341	5863
17171	10341	1467
17171	10341	5062
17171	10341	9193
985	10342	4748
985	10342	9405
4201	10343	343
4201	10343	3760
4201	10343	7599
4201	10343	2968
4201	10343	7725
4201	10343	1579
6091	10344	8954
6091	10344	9961
6091	10344	2332
6091	10344	2278
6091	10344	2912
6091	10344	2045
6091	10344	3783
8250	10345	2901
8250	10345	9087
8250	10345	8168
8250	10345	6523
8250	10345	399
8250	10345	2792
8250	10345	5105
8250	10345	4885
8250	10345	2567
9688	10346	6526
9688	10346	8428
9688	10346	7129
9688	10346	4433
9688	10346	4562
9688	10346	857
9688	10346	3202
9688	10346	460
9688	10346	8771
3125	10347	3308
3125	10347	8177
3125	10347	6003
595	10348	6636
595	10348	7552
595	10348	6107
595	10348	3957
595	10348	9319
595	10348	4317
595	10348	3838
5218	10349	4172
14958	10350	3353
14958	10350	5704
17534	10351	259
17534	10351	5024
17961	10352	3795
15264	10353	241
15264	10353	5184
15264	10353	1295
15264	10353	1891
15264	10353	86
11578	10354	4556
11578	10354	9831
11578	10354	9493
11578	10354	1179
11578	10354	3834
11578	10354	511
11578	10354	9560
11578	10354	5260
11001	10355	9913
11001	10355	1861
11001	10355	8357
4605	10356	873
4605	10356	6987
4605	10356	7105
4605	10356	5557
4605	10356	6822
4605	10356	6494
12107	10357	1738
12107	10357	7779
12107	10357	1978
7676	10358	5784
7676	10358	8574
7676	10358	2899
7676	10358	5809
7676	10358	150
7676	10358	6365
6374	10359	520
6374	10359	3743
6374	10359	4391
6374	10359	9714
6374	10359	4659
6374	10359	9860
6374	10359	5529
2626	10360	4832
2626	10360	6867
2626	10360	8677
2626	10360	3554
2626	10360	2721
2626	10360	8228
2626	10360	2440
12365	10361	1663
12365	10361	6489
12365	10361	1204
12365	10361	8896
15483	10362	5162
15483	10362	383
18118	10363	4100
18118	10363	1821
18118	10363	9580
18118	10363	1075
18118	10363	442
18118	10363	3828
18118	10363	386
3178	10364	8322
3178	10364	5063
3178	10364	3955
3178	10364	9243
3178	10364	2252
3178	10364	3396
3178	10364	9830
3300	10365	5910
3300	10365	2146
3300	10365	1772
4314	10366	3746
4314	10366	4202
4314	10366	5314
4314	10366	8434
4314	10366	9488
4314	10366	3606
4314	10366	436
530	10367	1915
530	10367	8728
530	10367	5220
530	10367	4176
530	10367	6846
530	10367	9148
5787	10368	4961
5787	10368	2977
5787	10368	668
5787	10368	1069
3009	10369	1769
3009	10369	3326
3009	10369	94
3009	10369	1509
3009	10369	2927
3009	10369	2304
3009	10369	8315
15654	10370	1541
15654	10370	390
15654	10370	2699
15654	10370	6982
15654	10370	5330
15654	10370	5272
15654	10370	8419
15654	10370	2376
15654	10370	724
4465	10371	7916
4465	10371	6496
4465	10371	1537
4465	10371	4058
4465	10371	8393
4465	10371	5186
4465	10371	116
14193	10372	8280
14193	10372	1772
14193	10372	3963
14193	10372	8442
14193	10372	6617
8797	10373	4484
8797	10373	1066
8797	10373	4860
8797	10373	1900
8797	10373	721
1673	10374	7933
1673	10374	7041
17625	10375	2960
17625	10375	2190
17625	10375	3590
17625	10375	3975
17625	10375	3943
17625	10375	8010
17625	10375	4477
12753	10376	3462
16862	10377	5051
16862	10377	5832
16862	10377	5884
16862	10377	6097
16862	10377	94
16862	10377	8420
16862	10377	7395
16862	10377	6235
16862	10377	852
10656	10378	1705
10656	10378	7326
10656	10378	1394
10656	10378	3597
10656	10378	8633
10656	10378	8495
8757	10379	3222
8757	10379	1623
8757	10379	6983
8757	10379	4035
9772	10380	214
9772	10380	3172
9772	10380	7812
9772	10380	7084
9772	10380	9510
9772	10380	629
9772	10380	9328
13136	10381	9905
13136	10381	9114
13136	10381	8364
13136	10381	544
13136	10381	9314
13136	10381	7284
14995	10382	9415
12997	10383	7179
13013	10384	3075
13013	10384	7336
12899	10385	2546
12899	10385	9104
12899	10385	5947
12899	10385	8635
12899	10385	3885
12899	10385	4307
12899	10385	9149
15034	10386	6513
15034	10386	3482
15034	10386	6782
15034	10386	6252
15034	10386	9535
15034	10386	567
15034	10386	1300
806	10387	6791
806	10387	8576
806	10387	3590
806	10387	3974
806	10387	8453
9593	10388	55
9593	10388	1401
9593	10388	785
9593	10388	953
9593	10388	2246
9593	10388	4359
9593	10388	4630
19200	10389	3205
13588	10390	9533
13588	10390	9159
13588	10390	3191
13588	10390	6557
13588	10390	4134
9837	10391	5238
19193	10392	3045
19193	10392	6783
19193	10392	6085
19193	10392	8587
19193	10392	6781
19193	10392	2884
19193	10392	6923
227	10393	3359
227	10393	614
227	10393	999
12471	10394	5832
12471	10394	4210
12471	10394	820
12471	10394	403
12471	10394	979
12471	10394	4402
12471	10394	7517
8879	10395	4553
15824	10396	1352
15824	10396	9664
15824	10396	4588
15824	10396	2854
14126	10397	8055
18065	10398	6791
18065	10398	8623
15899	10399	9223
15899	10399	3107
15899	10399	7306
15899	10399	4928
15899	10399	285
6275	10400	200
6275	10400	9953
6275	10400	8926
6275	10400	7287
6275	10400	8227
6275	10400	3815
6275	10400	4940
6275	10400	4799
6275	10400	9652
5517	10401	7217
5517	10401	4111
5517	10401	5038
5517	10401	639
5517	10401	4739
5517	10401	4199
5517	10401	9093
12759	10402	457
12759	10402	6656
12759	10402	9007
12759	10402	1370
12759	10402	5474
12759	10402	1417
12759	10402	8348
12759	10402	1593
12759	10402	6134
13545	10403	7611
13545	10403	6704
16568	10404	8091
16568	10404	4207
16568	10404	8937
16568	10404	6200
16568	10404	1871
16568	10404	1513
16568	10404	7743
16568	10404	1921
16568	10404	2318
19185	10405	1606
19185	10405	3366
19185	10405	9141
19185	10405	6594
19185	10405	1946
19185	10405	5764
19185	10405	9430
11257	10406	7302
11257	10406	4523
12886	10407	4498
12886	10407	8289
12886	10407	7913
12886	10407	1761
12886	10407	8204
12886	10407	3566
12886	10407	3126
12886	10407	9481
17819	10408	4538
3678	10409	6883
3678	10409	3228
3678	10409	188
3678	10409	1609
3678	10409	7049
3678	10409	8370
3678	10409	799
8729	10410	9875
8729	10410	1725
8729	10410	9760
8594	10411	6136
8594	10411	1611
8594	10411	515
8594	10411	4281
8594	10411	2563
19222	10412	8420
19222	10412	4122
19222	10412	572
19222	10412	966
19222	10412	6342
19222	10412	1984
19222	10412	8005
3826	10413	936
3826	10413	9552
3826	10413	5823
3826	10413	2153
3826	10413	9721
3826	10413	7996
12830	10414	4545
12830	10414	8493
12830	10414	2355
8678	10415	8887
8678	10415	8119
8678	10415	7865
8678	10415	9245
8678	10415	505
8678	10415	1248
1938	10416	6099
1938	10416	7863
4814	10417	7918
4814	10417	9194
4814	10417	6039
4814	10417	2326
888	10418	9498
888	10418	6741
888	10418	7496
888	10418	2659
888	10418	8957
888	10418	2396
888	10418	9514
888	10418	2492
888	10418	2665
1164	10419	6702
1164	10419	9063
1164	10419	4499
1164	10419	9470
1164	10419	9847
1164	10419	112
1164	10419	8970
1164	10419	4575
1164	10419	8556
1901	10420	1208
1901	10420	3169
1901	10420	2915
1901	10420	4454
1901	10420	1844
1901	10420	6024
1901	10420	182
1901	10420	1428
2548	10421	7861
2548	10421	5924
2548	10421	9217
2548	10421	5967
2548	10421	5430
2548	10421	5278
2548	10421	5633
2548	10421	510
9926	10422	6118
9926	10422	4104
9926	10422	1543
19495	10423	8064
19495	10423	2157
19495	10423	7101
19495	10423	8467
19495	10423	8863
8281	10424	2587
8281	10424	1800
8281	10424	6005
4245	10425	8421
4245	10425	6774
7158	10426	8244
7158	10426	1159
7158	10426	2468
7158	10426	8411
7158	10426	3522
7158	10426	5471
7158	10426	9284
2166	10427	7880
11395	10428	5059
11395	10428	6016
9908	10429	6049
9908	10429	4320
9908	10429	2123
9908	10429	9847
9908	10429	8761
9908	10429	9698
9908	10429	3374
9908	10429	9127
9908	10429	5896
18238	10430	764
18238	10430	2041
18238	10430	1929
18238	10430	1732
18238	10430	1748
12135	10431	8798
12135	10431	3530
12135	10431	1461
12135	10431	5602
12135	10431	8022
12135	10431	206
12135	10431	1734
12135	10431	3035
7596	10432	577
7596	10432	4414
12324	10433	2229
12324	10433	1043
12324	10433	2529
7979	10434	8824
7979	10434	8913
7979	10434	9738
7979	10434	3744
6689	10435	4986
6689	10435	1407
6689	10435	9454
6689	10435	5562
6689	10435	1956
6689	10435	5928
6689	10435	8817
14800	10436	1585
14800	10436	1192
14800	10436	299
14800	10436	1142
14800	10436	3701
541	10437	7417
541	10437	1772
541	10437	3710
11331	10438	8665
11331	10438	798
11331	10438	1340
5848	10439	3421
5848	10439	3726
5848	10439	8854
12480	10440	8613
12480	10440	9201
12480	10440	1982
12480	10440	7718
5682	10441	6780
5682	10441	3474
5682	10441	4775
5682	10441	1043
5682	10441	7877
5682	10441	4099
5682	10441	9025
19622	10442	4101
19622	10442	1835
19622	10442	8188
19622	10442	6210
19622	10442	2210
19622	10442	8746
19622	10442	2024
10996	10443	578
10996	10443	8537
10996	10443	9150
10996	10443	55
10996	10443	5587
10996	10443	7985
10996	10443	5805
10996	10443	2582
10996	10443	5386
3191	10444	6380
3191	10444	6608
3191	10444	945
3191	10444	3902
8957	10445	2932
8957	10445	1504
8957	10445	6600
8957	10445	2069
8957	10445	1868
8957	10445	6670
8957	10445	5513
8957	10445	5218
3782	10446	7310
16509	10447	2843
16509	10447	6813
16509	10447	7521
18049	10448	6114
18049	10448	1727
18049	10448	2673
18049	10448	2430
18049	10448	450
18049	10448	5151
18049	10448	9538
13694	10449	5102
13694	10449	4898
13694	10449	9993
15027	10450	6538
5302	10451	632
5302	10451	7869
5302	10451	9842
5302	10451	707
5302	10451	2419
5302	10451	774
5302	10451	7091
5302	10451	9111
5302	10451	5133
10249	10452	2638
18350	10453	1826
18350	10453	8023
18350	10453	1998
18350	10453	5518
18350	10453	4211
18350	10453	6831
18350	10453	6468
18350	10453	3177
4574	10454	6295
4574	10454	1653
4574	10454	6082
4574	10454	9184
4574	10454	3466
4574	10454	5433
6910	10455	9347
6910	10455	4717
6910	10455	9489
11912	10456	9514
11912	10456	5649
11912	10456	7076
11912	10456	1149
14461	10457	4114
14461	10457	3680
14461	10457	1776
19047	10458	2789
19047	10458	5904
19047	10458	3701
5703	10459	3398
5703	10459	3010
5703	10459	7041
5703	10459	9202
5703	10459	1389
5703	10459	4135
5703	10459	8704
959	10460	3
959	10460	398
959	10460	1967
959	10460	5068
959	10460	2389
959	10460	8520
959	10460	1047
959	10460	6936
7951	10461	4971
7951	10461	3812
5031	10462	2995
5994	10463	5788
5994	10463	4901
5994	10463	6741
5994	10463	4155
5994	10463	9127
5994	10463	7177
5994	10463	9257
5994	10463	37
10015	10464	4113
10015	10464	7484
10015	10464	2329
10015	10464	325
10015	10464	3475
18526	10465	118
18526	10465	1319
18526	10465	2502
18526	10465	9474
17460	10466	6200
17460	10466	1552
17460	10466	5371
17460	10466	5447
17460	10466	6695
17460	10466	3333
13615	10467	6070
13615	10467	1466
13615	10467	4193
13615	10467	460
13615	10467	3230
13615	10467	6373
13615	10467	8663
9724	10468	8133
9724	10468	3495
9724	10468	4243
9724	10468	1355
9724	10468	7209
9724	10468	4382
9724	10468	7096
9724	10468	608
9602	10469	1496
9602	10469	7030
9602	10469	4310
9602	10469	3484
9602	10469	554
9602	10469	8421
9602	10469	889
10262	10470	2706
10262	10470	3281
10262	10470	2971
10262	10470	7538
8351	10471	1273
16606	10472	3995
16606	10472	9751
16606	10472	725
16606	10472	3235
16606	10472	87
16606	10472	6745
16606	10472	9121
16606	10472	1505
16606	10472	6536
8147	10473	8249
8147	10473	1993
13691	10474	6007
13691	10474	5269
13691	10474	6368
13691	10474	3929
8031	10475	6207
8031	10475	3801
8031	10475	6625
8031	10475	2187
478	10476	6670
478	10476	2180
478	10476	9953
11919	10477	1717
11919	10477	8280
11919	10477	7793
5791	10478	7119
5791	10478	3580
5791	10478	4374
5791	10478	3145
5791	10478	6005
5791	10478	1442
7244	10479	3626
7244	10479	3278
7244	10479	4952
7244	10479	3641
7244	10479	641
7244	10479	9118
7244	10479	4329
2893	10480	5190
2893	10480	5515
2893	10480	6549
2893	10480	2593
2893	10480	4192
2893	10480	1613
2893	10480	7278
2893	10480	2504
2893	10480	688
8657	10481	5762
8657	10481	6492
8657	10481	9158
8657	10481	1536
8657	10481	2410
8657	10481	316
13729	10482	4855
13729	10482	7612
13729	10482	3474
13729	10482	1705
13729	10482	5444
13729	10482	3433
13729	10482	6721
4964	10483	2572
4964	10483	6336
4964	10483	5631
4964	10483	833
11784	10484	3544
11784	10484	9747
11784	10484	4131
11784	10484	6044
11784	10484	9197
11784	10484	8229
9898	10485	7431
9898	10485	3337
9898	10485	3751
9898	10485	4109
9898	10485	8417
9898	10485	5326
9898	10485	833
9898	10485	1198
9898	10485	5799
19858	10486	5765
19858	10486	3061
11082	10487	5203
11082	10487	3406
11082	10487	6374
966	10488	5425
966	10488	1714
966	10488	9997
966	10488	634
966	10488	3855
966	10488	5724
2977	10489	5481
8844	10490	794
8844	10490	83
16588	10491	4922
16588	10491	9061
16588	10491	9332
16588	10491	9546
16588	10491	4851
16588	10491	6129
16588	10491	1417
5588	10492	159
5588	10492	1965
5588	10492	2551
5588	10492	3767
5588	10492	9927
5588	10492	928
5588	10492	1628
1376	10493	9744
1376	10493	9946
1376	10493	5430
1376	10493	5170
1376	10493	9943
1376	10493	9640
1376	10493	4775
1376	10493	5618
1376	10493	59
7651	10494	8255
7651	10494	7001
7651	10494	7579
7651	10494	570
7651	10494	7632
7651	10494	2092
7651	10494	4908
7651	10494	3653
7651	10494	4368
8014	10495	3806
8014	10495	8823
16641	10496	7745
16641	10496	4522
16641	10496	5826
12789	10497	6708
3231	10498	1693
3231	10498	4852
6113	10499	6879
6113	10499	7819
6113	10499	8227
6113	10499	1662
12366	10500	8283
12366	10500	3671
12366	10500	3138
12366	10500	4697
12366	10500	1994
12366	10500	1999
12366	10500	2612
5520	10501	6714
5520	10501	3676
5520	10501	5654
5520	10501	40
2982	10502	8768
2982	10502	1698
2982	10502	2224
2982	10502	2816
2982	10502	5577
2982	10502	3392
2982	10502	8494
2982	10502	4425
8661	10503	1116
8661	10503	9
8661	10503	526
8661	10503	4085
8661	10503	1539
612	10504	2744
612	10504	3517
612	10504	8506
612	10504	369
612	10504	6668
612	10504	7900
612	10504	42
612	10504	5423
13076	10505	3307
13076	10505	2196
7470	10506	4041
7470	10506	8204
7470	10506	5921
7470	10506	2344
7470	10506	814
7470	10506	6324
7470	10506	1574
7470	10506	8574
7470	10506	887
6052	10507	5174
14739	10508	1104
14739	10508	6420
14739	10508	539
14739	10508	1929
14739	10508	6344
14739	10508	886
14739	10508	6984
17115	10509	174
17115	10509	7207
17115	10509	5345
1037	10510	7888
1037	10510	8260
9359	10511	9302
9359	10511	6013
9359	10511	336
9359	10511	2802
9359	10511	4108
9359	10511	5877
9359	10511	651
9359	10511	7860
9359	10511	2829
19659	10512	1191
19659	10512	9988
19659	10512	601
19659	10512	4130
19659	10512	8555
19659	10512	799
19659	10512	9077
3757	10513	9318
3757	10513	1114
3757	10513	378
3757	10513	7825
3757	10513	2177
3757	10513	3036
8453	10514	3677
15613	10515	1239
15613	10515	2709
15613	10515	4775
15613	10515	2194
15613	10515	9747
15613	10515	7556
15613	10515	1479
15613	10515	9832
4016	10516	7906
4016	10516	8401
4016	10516	3909
4016	10516	3520
12724	10517	3
12724	10517	1437
7260	10518	5141
7260	10518	9124
7260	10518	3495
7260	10518	5924
7260	10518	963
7260	10518	8809
7260	10518	1973
7260	10518	4281
15602	10519	4163
15602	10519	293
15602	10519	5356
15602	10519	8943
15602	10519	5360
15602	10519	2137
15602	10519	2509
15602	10519	7120
15602	10519	216
2356	10520	47
2356	10520	6655
2356	10520	9546
2356	10520	2128
2356	10520	5113
2356	10520	9933
2356	10520	456
2356	10520	7135
2356	10520	9161
2595	10521	2558
2595	10521	4857
2595	10521	3157
2595	10521	3951
2595	10521	4939
2595	10521	8514
2595	10521	8324
2595	10521	7535
5295	10522	8053
5295	10522	2199
5295	10522	6595
5295	10522	7682
5295	10522	2657
5295	10522	1794
5295	10522	789
7891	10523	8795
7891	10523	5933
8512	10524	4708
8512	10524	8857
8512	10524	9258
8512	10524	8646
8512	10524	2097
8512	10524	2816
10944	10525	686
10944	10525	6625
10944	10525	5186
10944	10525	608
10944	10525	5849
10944	10525	1289
10944	10525	796
10944	10525	732
10944	10525	9002
16518	10526	9715
16518	10526	838
16518	10526	8370
16518	10526	8003
16518	10526	8993
16518	10526	63
10498	10527	9230
10498	10527	4506
10498	10527	4757
10498	10527	7173
10498	10527	804
10498	10527	5076
10498	10527	4433
10498	10527	3353
8380	10528	3208
8380	10528	7358
8380	10528	3368
8380	10528	7818
8380	10528	2669
8380	10528	8693
8380	10528	2437
8380	10528	2416
19177	10529	5763
19177	10529	7060
19177	10529	9330
19177	10529	4342
19177	10529	4601
19177	10529	8030
19177	10529	5699
19177	10529	9
19177	10529	2807
10952	10530	7374
10952	10530	1684
10952	10530	9658
10952	10530	9377
10952	10530	9488
10952	10530	96
10952	10530	5334
10952	10530	6958
3117	10531	9368
3117	10531	2337
3117	10531	5460
3117	10531	7202
3117	10531	619
3117	10531	3737
3117	10531	9696
18706	10532	1692
18706	10532	2297
18706	10532	1638
18706	10532	1212
18706	10532	7306
18706	10532	154
18706	10532	7081
18833	10533	4560
18833	10533	5105
18833	10533	3329
18833	10533	3170
18833	10533	4262
18833	10533	2377
18833	10533	8108
18833	10533	4958
18833	10533	5855
14132	10534	7197
14132	10534	3339
14132	10534	4864
14132	10534	3693
14132	10534	7585
5379	10535	1532
5379	10535	6212
5379	10535	7550
11313	10536	6060
8187	10537	9432
8187	10537	7744
8187	10537	7049
1484	10538	8994
1484	10538	777
1484	10538	9414
1484	10538	9023
1484	10538	8101
1484	10538	4214
1484	10538	2229
1484	10538	4376
3173	10539	3987
3461	10540	4338
1411	10541	6932
12691	10542	1971
12691	10542	8530
1515	10543	9046
1515	10543	4076
1515	10543	9386
6225	10544	3888
6225	10544	2908
6225	10544	4835
6225	10544	5915
6225	10544	27
6225	10544	8112
6225	10544	807
6225	10544	637
17501	10545	1240
17501	10545	7750
17501	10545	566
17501	10545	3378
17501	10545	248
17501	10545	1628
17501	10545	7300
17501	10545	9540
17501	10545	614
1280	10546	6921
1280	10546	2094
16718	10547	7678
16718	10547	3677
16718	10547	2862
16718	10547	2563
16718	10547	8047
19348	10548	4209
19348	10548	8842
19348	10548	1940
19348	10548	5462
19348	10548	4754
19348	10548	1353
19348	10548	9939
12492	10549	3793
12492	10549	8310
12492	10549	8253
12597	10550	5973
12597	10550	9010
12597	10550	7113
18103	10551	5294
13293	10552	2444
13293	10552	9031
13293	10552	284
17188	10553	9467
17188	10553	1341
17188	10553	4673
17188	10553	3777
17188	10553	7494
4991	10554	2960
4991	10554	7474
19337	10555	7070
19337	10555	7103
19337	10555	445
19337	10555	5947
10827	10556	8562
4676	10557	3226
4676	10557	7575
4676	10557	4308
4676	10557	8399
4676	10557	6340
9860	10558	2551
9860	10558	5872
9860	10558	5596
9860	10558	2918
9860	10558	7232
9860	10558	4804
9860	10558	2176
9860	10558	8131
2714	10559	4523
2714	10559	5579
2714	10559	1092
2714	10559	3200
2714	10559	6848
18797	10560	2394
18797	10560	8751
18797	10560	9632
18797	10560	522
18797	10560	1776
18797	10560	6825
18797	10560	5521
1049	10561	9835
1049	10561	8707
1049	10561	6835
1049	10561	3468
1049	10561	9709
1049	10561	3080
10947	10562	785
2613	10563	4004
2613	10563	7874
2613	10563	9500
2613	10563	49
2613	10563	4923
2613	10563	3755
2613	10563	810
2613	10563	5535
10486	10564	4457
10486	10564	2825
10486	10564	475
10486	10564	2720
10486	10564	4916
10486	10564	4635
10486	10564	6307
11613	10565	4645
11613	10565	8375
11613	10565	197
11613	10565	8990
11613	10565	3461
11613	10565	974
11613	10565	612
11613	10565	2531
6010	10566	9672
6010	10566	8024
6010	10566	881
6010	10566	6815
6010	10566	137
6010	10566	7816
6010	10566	5028
10448	10567	955
10448	10567	5431
12086	10568	9480
12086	10568	6635
12086	10568	8486
12086	10568	8488
18737	10569	8693
18737	10569	5886
18737	10569	5759
18737	10569	2698
18737	10569	6137
18737	10569	1110
18737	10569	6905
16009	10570	1634
16009	10570	7943
16009	10570	8589
16009	10570	4574
16009	10570	2938
16009	10570	6445
10274	10571	1645
10274	10571	9409
10274	10571	9453
10274	10571	2414
10274	10571	2638
10274	10571	7103
10274	10571	7323
10274	10571	8038
11960	10572	2408
10690	10573	9123
10690	10573	8995
10690	10573	8089
10690	10573	4389
7683	10574	4404
7683	10574	6713
7683	10574	7339
7683	10574	1193
7683	10574	2992
7683	10574	1356
7683	10574	3279
1383	10575	4549
1383	10575	8588
1383	10575	2107
1383	10575	4182
1383	10575	4174
1383	10575	336
1383	10575	6557
1383	10575	2898
1383	10575	6246
14875	10576	379
7313	10577	4348
7313	10577	1520
7313	10577	8068
348	10578	6669
348	10578	5784
348	10578	8173
348	10578	1745
348	10578	5610
348	10578	1306
13836	10579	3885
13836	10579	9462
13836	10579	6244
13836	10579	4454
13836	10579	2706
13836	10579	7870
9305	10580	5609
9305	10580	6369
9305	10580	9891
9305	10580	4852
9305	10580	6103
9305	10580	8415
9305	10580	3076
9305	10580	7334
9305	10580	5343
3173	10581	9349
3173	10581	8550
3173	10581	8454
3173	10581	1871
3173	10581	610
3173	10581	7771
15323	10582	3162
15323	10582	2271
15323	10582	2722
15323	10582	3201
15323	10582	2307
15323	10582	6849
14904	10583	761
14904	10583	6696
14904	10583	9705
14904	10583	9435
14904	10583	6045
14904	10583	7293
14904	10583	4866
14904	10583	3419
14904	10583	3577
12596	10584	6353
12596	10584	1348
12596	10584	7223
14266	10585	5593
14266	10585	629
126	10586	7268
126	10586	9567
126	10586	5288
17727	10587	5162
17727	10587	2571
17727	10587	3052
17727	10587	4715
17727	10587	5396
17727	10587	7408
17727	10587	6783
17727	10587	4001
17727	10587	8299
7820	10588	6814
7820	10588	6875
7820	10588	5028
7820	10588	965
7820	10588	6802
18745	10589	3291
18745	10589	6740
18745	10589	7723
18745	10589	5036
18745	10589	7147
18745	10589	1916
18779	10590	4131
18779	10590	3771
17598	10591	2502
17598	10591	5361
17598	10591	4216
17598	10591	2379
17598	10591	5355
17598	10591	6192
17598	10591	3265
17598	10591	7583
17598	10591	264
19031	10592	1244
19031	10592	1380
19031	10592	4023
19031	10592	3813
19031	10592	8885
8490	10593	7245
8490	10593	8629
9641	10594	6048
9641	10594	7401
9641	10594	2758
9641	10594	5827
9641	10594	8467
9641	10594	4663
9641	10594	2084
11792	10595	2211
11792	10595	2624
11792	10595	8778
11792	10595	9046
11792	10595	2469
11792	10595	2226
11792	10595	9760
11792	10595	1405
8323	10596	5807
937	10597	9154
937	10597	5459
937	10597	6603
937	10597	7558
937	10597	2108
937	10597	9095
937	10597	3741
937	10597	3923
937	10597	9708
2224	10598	5274
2224	10598	9234
2224	10598	138
2224	10598	1548
2224	10598	6276
2224	10598	7088
2224	10598	604
2224	10598	9404
3021	10599	2663
3021	10599	3574
6563	10600	4394
6563	10600	7264
6563	10600	2364
6563	10600	746
6563	10600	3211
6563	10600	1366
6563	10600	2996
6563	10600	1221
1248	10601	2134
1248	10601	7070
1248	10601	4491
1248	10601	1382
1248	10601	3924
16634	10602	7984
16634	10602	893
16634	10602	7622
16634	10602	1024
8038	10603	7618
8038	10603	5434
8038	10603	4644
8038	10603	5632
8038	10603	2365
7493	10604	5395
7493	10604	4596
7493	10604	343
7493	10604	3273
7493	10604	1309
7493	10604	5339
17857	10605	3739
17857	10605	6907
17857	10605	3345
17857	10605	6740
17857	10605	3262
17857	10605	9098
17857	10605	2850
16490	10606	6397
16490	10606	9070
16490	10606	5437
16490	10606	563
16490	10606	2710
16490	10606	9704
6884	10607	2614
6884	10607	6221
6884	10607	5348
6884	10607	8458
6884	10607	5099
13987	10608	3484
13987	10608	419
13987	10608	5617
13987	10608	2932
13987	10608	6632
13987	10608	6623
8775	10609	9059
8775	10609	4102
8775	10609	1745
8775	10609	4761
8775	10609	3895
8775	10609	1509
8775	10609	6853
673	10610	2890
673	10610	8744
673	10610	8805
10853	10611	9814
10853	10611	3893
10853	10611	3877
10853	10611	4151
10853	10611	7444
10853	10611	5823
14661	10612	8391
14661	10612	5959
14661	10612	2949
14661	10612	8025
14661	10612	4670
14661	10612	7067
17551	10613	262
17551	10613	940
10182	10614	4003
10182	10614	2965
1111	10615	617
1111	10615	6701
9450	10616	1553
9450	10616	4005
9450	10616	1099
9450	10616	5876
9450	10616	2488
9450	10616	5499
9450	10616	1907
9450	10616	8296
2521	10617	1816
2521	10617	5052
2521	10617	1433
2521	10617	5997
2506	10618	3576
2506	10618	1837
2506	10618	2813
2506	10618	6034
2506	10618	4528
2506	10618	1970
2506	10618	6790
2506	10618	2342
2047	10619	8102
2047	10619	5773
2047	10619	8182
2047	10619	4170
13358	10620	3192
13358	10620	1271
13358	10620	2237
13358	10620	1305
13358	10620	8838
13358	10620	3198
11079	10621	6563
11079	10621	8407
11079	10621	1061
11079	10621	4198
11079	10621	5948
17939	10622	5566
17939	10622	1112
17939	10622	4242
17939	10622	4142
17939	10622	112
17939	10622	8821
4721	10623	7426
4721	10623	6491
15103	10624	6794
15103	10624	2639
15103	10624	4930
15103	10624	7280
16782	10625	1739
3700	10626	5159
3700	10626	6891
3700	10626	4917
3700	10626	9417
3700	10626	150
324	10627	6123
324	10627	6444
324	10627	4087
324	10627	1547
324	10627	2115
324	10627	174
11768	10628	414
11768	10628	7861
11768	10628	4868
11768	10628	1622
11768	10628	4184
6285	10629	8894
6285	10629	3940
6285	10629	9106
6285	10629	9061
6285	10629	8035
6285	10629	9532
6285	10629	5029
1462	10630	1592
1462	10630	1810
1462	10630	5326
1462	10630	743
1462	10630	5202
14269	10631	5189
14269	10631	6882
11886	10632	7119
11886	10632	263
8709	10633	8860
8709	10633	1597
8709	10633	928
8709	10633	4101
8709	10633	6431
8709	10633	6188
8709	10633	6437
8709	10633	627
8709	10633	4237
16514	10634	312
1149	10635	4929
1149	10635	8756
1149	10635	61
1149	10635	4458
1149	10635	7274
1149	10635	2658
1149	10635	7861
1149	10635	2786
1149	10635	7087
2647	10636	9580
2647	10636	2709
16109	10637	7761
16109	10637	3246
16109	10637	9182
16109	10637	6868
16109	10637	4293
16109	10637	2198
16109	10637	7844
1259	10638	4041
1259	10638	4204
1259	10638	2120
9658	10639	2884
9658	10639	1921
9658	10639	9534
9658	10639	7160
8054	10640	8168
8054	10640	9714
8054	10640	4611
17933	10641	9245
2729	10642	6194
2729	10642	9236
2729	10642	4192
2729	10642	9720
2729	10642	6322
9585	10643	7556
9585	10643	9348
9585	10643	5085
9585	10643	2778
9585	10643	2926
4339	10644	3534
4339	10644	3013
4339	10644	187
4339	10644	8803
4339	10644	3404
4339	10644	8103
4339	10644	5402
4339	10644	4517
4145	10645	9342
4145	10645	8646
4145	10645	2191
4145	10645	3286
4145	10645	3740
14546	10646	7000
14546	10646	7900
14546	10646	1744
14546	10646	4325
14546	10646	1027
14546	10646	389
11455	10647	414
11455	10647	1882
8144	10648	8667
8144	10648	9406
8144	10648	1642
17282	10649	4444
17282	10649	6160
17282	10649	5541
17282	10649	8495
17282	10649	2730
690	10650	7302
690	10650	1129
3516	10651	6127
15535	10652	6409
15535	10652	3687
15535	10652	4377
15535	10652	9620
15535	10652	7032
15535	10652	5846
15535	10652	2643
15535	10652	107
14816	10653	3786
5051	10654	671
5051	10654	6352
5051	10654	9579
5051	10654	4083
5051	10654	3612
5051	10654	3111
5051	10654	8376
5051	10654	1344
7973	10655	2574
17977	10656	7301
17977	10656	3729
8798	10657	9800
8798	10657	2148
8798	10657	9772
8798	10657	2342
8798	10657	8990
8798	10657	3025
8798	10657	4938
8798	10657	4319
8798	10657	2938
712	10658	1560
712	10658	4399
712	10658	9361
712	10658	9687
712	10658	6824
712	10658	2797
712	10658	3369
712	10658	4731
712	10658	5451
16950	10659	1403
16950	10659	8023
11951	10660	5923
11951	10660	4326
7372	10661	9975
7372	10661	716
8167	10662	9793
8167	10662	2000
8167	10662	9265
8167	10662	7582
8167	10662	4423
8167	10662	5008
8167	10662	1580
8167	10662	829
10309	10663	8840
10309	10663	8732
10309	10663	160
10309	10663	1586
10309	10663	3531
10309	10663	1992
10309	10663	7714
13956	10664	7645
13956	10664	2727
13956	10664	4151
13956	10664	2357
13956	10664	1808
13956	10664	134
13956	10664	5819
9101	10665	3998
9101	10665	9082
9101	10665	6298
9101	10665	851
9101	10665	5065
10215	10666	9573
10215	10666	1288
10215	10666	4546
10215	10666	8704
10215	10666	1961
10215	10666	5986
10215	10666	7811
10215	10666	2330
12653	10667	3854
12653	10667	6722
12653	10667	5281
12653	10667	5095
12653	10667	6894
12653	10667	4905
12384	10668	9836
12384	10668	3749
12384	10668	7730
12384	10668	9575
12384	10668	930
12384	10668	1138
12384	10668	8231
4169	10669	6788
4169	10669	1653
4169	10669	8930
4169	10669	4492
4169	10669	5013
4169	10669	27
4169	10669	4735
4169	10669	4095
4169	10669	1658
2465	10670	3136
2465	10670	6643
2465	10670	4611
2465	10670	3451
2465	10670	9656
2465	10670	4648
2465	10670	2121
2465	10670	9855
2465	10670	7412
14875	10671	7300
14875	10671	7169
14875	10671	5988
14875	10671	189
14875	10671	4531
14875	10671	1852
14875	10671	4691
14875	10671	961
1233	10672	1925
1233	10672	6676
1233	10672	7112
2128	10673	9750
2128	10673	878
2128	10673	7781
2128	10673	2303
2128	10673	216
2128	10673	1295
2128	10673	8006
17933	10674	9583
17933	10674	80
17933	10674	3005
17933	10674	3287
17933	10674	843
17933	10674	1180
17933	10674	6647
15050	10675	4390
15050	10675	6941
15050	10675	6983
15050	10675	6673
15050	10675	4220
15050	10675	3954
15050	10675	2183
15050	10675	850
15050	10675	5044
16659	10676	8262
16659	10676	2227
16659	10676	6080
16659	10676	2433
16659	10676	2388
16659	10676	4077
16659	10676	1427
16659	10676	7563
16659	10676	6048
2	10677	3538
2	10677	7747
2	10677	4831
2	10677	6910
2	10677	6624
17701	10678	2268
9311	10679	3984
9311	10679	9092
9311	10679	8860
9311	10679	3328
9311	10679	5140
9311	10679	7645
9311	10679	4431
9311	10679	7258
8334	10680	9338
8334	10680	7630
8334	10680	2039
8334	10680	1928
8334	10680	4553
8334	10680	4026
8334	10680	2021
8334	10680	81
6817	10681	6863
6817	10681	2073
6817	10681	6076
6817	10681	554
17228	10682	624
17228	10682	2251
17228	10682	4537
18177	10683	7624
18177	10683	5800
18177	10683	8337
2754	10684	2062
2754	10684	9268
2754	10684	8853
2754	10684	6368
2754	10684	8434
2754	10684	5184
2754	10684	8017
2754	10684	1721
753	10685	3059
753	10685	4507
753	10685	6969
753	10685	2914
753	10685	4221
753	10685	6056
753	10685	9889
17484	10686	1091
12548	10687	3708
12548	10687	4733
12746	10688	5638
12746	10688	6647
12746	10688	9718
12746	10688	687
12746	10688	9926
12746	10688	219
12746	10688	2064
12746	10688	8556
19294	10689	5921
19294	10689	1765
19294	10689	7770
19294	10689	4947
19294	10689	2870
19294	10689	289
19294	10689	4187
19294	10689	1112
19294	10689	6496
12844	10690	6237
12844	10690	2697
12844	10690	7808
12844	10690	4439
12844	10690	7703
12844	10690	2005
12844	10690	9988
12844	10690	5963
17664	10691	7339
17664	10691	9497
17664	10691	337
16355	10692	6237
16355	10692	9390
16355	10692	3442
16355	10692	7051
16355	10692	5786
16355	10692	8241
16355	10692	4220
16355	10692	7564
19674	10693	2398
19674	10693	1841
19674	10693	4803
19674	10693	7886
19674	10693	354
13181	10694	5523
13181	10694	424
13181	10694	272
17024	10695	6740
17024	10695	1730
1489	10696	7098
1489	10696	5692
1489	10696	9326
1489	10696	6951
1577	10697	4015
1577	10697	5218
1577	10697	4367
3386	10698	3240
3386	10698	6209
3386	10698	642
3386	10698	5714
3386	10698	1406
14193	10699	674
14193	10699	2105
14193	10699	2450
12929	10700	903
12929	10700	8083
12929	10700	6226
18931	10701	4435
18931	10701	11
18931	10701	9417
5032	10702	4941
5032	10702	9331
5032	10702	3736
5032	10702	5419
5032	10702	8245
5032	10702	3706
5032	10702	119
12688	10703	5810
12688	10703	9292
12688	10703	163
12688	10703	392
12688	10703	718
12688	10703	2095
12688	10703	1020
701	10704	2131
701	10704	3261
13932	10705	8754
13932	10705	1545
13932	10705	7106
13932	10705	9322
13932	10705	7598
15978	10706	1340
15978	10706	5646
15978	10706	8191
15978	10706	2709
15978	10706	6209
15978	10706	1768
13702	10707	2052
13702	10707	4951
13702	10707	7815
13702	10707	951
13702	10707	8453
8305	10708	569
8305	10708	6837
8305	10708	235
8305	10708	275
8305	10708	7297
8305	10708	7782
5991	10709	7730
5991	10709	7578
5991	10709	1564
5027	10710	1062
5027	10710	7341
5027	10710	4826
3325	10711	6690
3325	10711	8652
3325	10711	882
3325	10711	3051
3325	10711	9429
3325	10711	9223
13601	10712	2192
13601	10712	1009
13601	10712	7762
13601	10712	3865
13601	10712	9668
13601	10712	3011
13601	10712	353
13601	10712	850
19002	10713	5934
19002	10713	9250
19002	10713	3045
19954	10714	8473
19954	10714	6931
19954	10714	2183
12094	10715	4737
12094	10715	6361
14422	10716	6712
14422	10716	3887
6273	10717	1609
13762	10718	4346
13762	10718	8212
13762	10718	4507
13762	10718	2575
13762	10718	982
13762	10718	7105
13762	10718	2401
13762	10718	4554
2530	10719	3911
2530	10719	5539
2530	10719	5211
10939	10720	4200
10939	10720	5144
10939	10720	4901
10939	10720	2175
10939	10720	3950
2108	10721	8098
2108	10721	1721
2108	10721	6317
2108	10721	9015
2108	10721	4340
2108	10721	2145
2108	10721	1700
11455	10722	4101
11455	10722	1630
11455	10722	4712
11455	10722	6477
11455	10722	6960
11455	10722	9715
11455	10722	8453
11455	10722	2510
11455	10722	4425
6879	10723	7993
6879	10723	3473
6879	10723	5785
6879	10723	5420
19040	10724	8521
19040	10724	3145
19040	10724	4137
19040	10724	6261
19040	10724	7562
19040	10724	1663
19040	10724	4885
19040	10724	8897
19040	10724	9527
15039	10725	7212
15039	10725	356
16132	10726	7406
16132	10726	6873
2017	10727	4860
2017	10727	6643
3055	10728	5996
3055	10728	5132
3055	10728	9656
3055	10728	6251
3055	10728	9207
3055	10728	9499
3055	10728	4672
4154	10729	2627
4154	10729	9117
4154	10729	9921
4154	10729	1496
4154	10729	499
4154	10729	8091
4154	10729	6966
4154	10729	5246
9802	10730	1769
9802	10730	1330
9802	10730	5421
9802	10730	2918
9802	10730	8078
1408	10731	3985
1408	10731	7857
1408	10731	9716
1408	10731	5263
4457	10732	4326
4457	10732	1610
4457	10732	5090
4457	10732	6281
4457	10732	4645
4457	10732	2419
4457	10732	8357
6242	10733	7001
6242	10733	9186
6242	10733	665
6242	10733	3213
6242	10733	6708
6242	10733	8156
4962	10734	3181
4962	10734	6372
4962	10734	474
5786	10735	3389
5786	10735	2640
5786	10735	7414
5786	10735	9773
5786	10735	4498
5786	10735	5500
5786	10735	6364
5786	10735	2386
5786	10735	808
19547	10736	3829
8606	10737	7196
1167	10738	5172
1167	10738	2603
1167	10738	8123
7245	10739	5830
7245	10739	6264
6526	10740	3444
6526	10740	863
6526	10740	4542
6526	10740	3890
6526	10740	7743
6526	10740	2320
6526	10740	7176
19556	10741	6878
19556	10741	5120
1898	10742	7586
1898	10742	9086
1898	10742	7577
1898	10742	4234
1898	10742	5615
1898	10742	3453
2390	10743	3047
2390	10743	323
2390	10743	671
15097	10744	9236
15097	10744	3987
15097	10744	5956
10082	10745	7570
10082	10745	3982
10082	10745	8576
10082	10745	2689
10082	10745	8629
3349	10746	8096
3349	10746	4999
3349	10746	5518
9507	10747	2872
9507	10747	4612
9507	10747	6700
8539	10748	7454
285	10749	6549
285	10749	8099
285	10749	1802
285	10749	1816
285	10749	2209
285	10749	2372
16150	10750	9735
16150	10750	5797
16150	10750	9092
16150	10750	704
16150	10750	2539
669	10751	6758
669	10751	4831
669	10751	8695
669	10751	1050
669	10751	3432
11606	10752	3878
11606	10752	4889
11606	10752	7734
11606	10752	46
11606	10752	2862
11606	10752	5897
11606	10752	8907
11606	10752	5735
11606	10752	8793
7247	10753	256
7375	10754	9490
7375	10754	9033
7375	10754	4997
7375	10754	6980
7375	10754	4605
7375	10754	9555
7375	10754	7774
7375	10754	2866
7375	10754	8975
15535	10755	1391
15535	10755	6687
15535	10755	6837
15535	10755	5333
15535	10755	7047
15535	10755	4669
19331	10756	2395
19331	10756	2195
19331	10756	2071
19331	10756	7400
19331	10756	6648
1067	10757	6472
1067	10757	3066
1067	10757	7178
1067	10757	1103
1067	10757	8396
6128	10758	2729
6128	10758	692
6128	10758	8834
6128	10758	7073
6128	10758	2854
19004	10759	35
19004	10759	4000
19004	10759	519
19004	10759	9665
19004	10759	6968
19004	10759	207
19004	10759	8916
19004	10759	8427
19004	10759	3062
7508	10760	6640
7508	10760	7110
7508	10760	7825
7508	10760	8996
7508	10760	2322
7508	10760	3659
8355	10761	1874
8355	10761	5967
8355	10761	5718
8355	10761	9619
8355	10761	8028
10802	10762	1608
10802	10762	4931
5511	10763	1427
5511	10763	592
12256	10764	1328
12256	10764	4051
12256	10764	3215
12256	10764	2178
410	10765	5606
410	10765	791
410	10765	5022
410	10765	5931
410	10765	8477
410	10765	9151
410	10765	1583
410	10765	4988
410	10765	5870
14395	10766	4492
14395	10766	9406
14395	10766	1433
14395	10766	6874
14395	10766	2530
14395	10766	8895
14395	10766	9693
14395	10766	9042
14395	10766	1504
1308	10767	396
1308	10767	6692
1308	10767	6658
1308	10767	3463
1308	10767	1918
2647	10768	4642
2647	10768	9021
15829	10769	1830
15829	10769	9291
15829	10769	7053
15829	10769	3988
8766	10770	648
8766	10770	6281
8766	10770	5582
8766	10770	2064
13374	10771	8184
13374	10771	1333
13374	10771	5232
13374	10771	5829
10239	10772	7628
10239	10772	2885
10239	10772	8765
10239	10772	8938
10239	10772	3306
10239	10772	3522
10239	10772	3415
10239	10772	5110
6813	10773	723
11908	10774	3015
11908	10774	3564
11908	10774	24
11908	10774	7792
11908	10774	6129
11908	10774	2675
11908	10774	5968
11908	10774	284
7397	10775	6634
7397	10775	3384
7397	10775	7803
7397	10775	2160
7397	10775	60
7397	10775	8864
7397	10775	4027
7397	10775	6484
7397	10775	3619
19495	10776	4814
19495	10776	5613
19495	10776	6287
19495	10776	8796
19495	10776	458
19495	10776	8708
19495	10776	9159
19495	10776	7947
19495	10776	6929
11585	10777	8220
11585	10777	1810
11585	10777	1840
11585	10777	1586
11585	10777	8402
11585	10777	9468
11585	10777	1496
583	10778	5720
583	10778	8792
583	10778	2334
583	10778	6198
583	10778	4744
11649	10779	3389
11649	10779	5113
11649	10779	8267
13335	10780	682
13335	10780	3121
13335	10780	4885
13335	10780	127
13335	10780	6060
13335	10780	5483
13335	10780	5657
801	10781	6225
801	10781	5983
801	10781	8796
14124	10782	3730
14124	10782	105
14124	10782	5482
732	10783	970
732	10783	8632
732	10783	7912
732	10783	8132
732	10783	4688
732	10783	8275
732	10783	9038
732	10783	526
732	10783	5352
6287	10784	4033
6287	10784	3035
6287	10784	1433
6287	10784	9881
6287	10784	2333
6287	10784	4413
6287	10784	7303
6287	10784	5252
19879	10785	852
19879	10785	423
19879	10785	2046
19879	10785	6743
19879	10785	8918
19879	10785	5565
17198	10786	1219
17198	10786	9380
17198	10786	3195
17198	10786	4516
17198	10786	6118
8016	10787	174
1192	10788	6370
1192	10788	4304
1192	10788	3524
1192	10788	8237
1192	10788	8468
1192	10788	1066
1192	10788	3045
12479	10789	6736
12479	10789	7521
12479	10789	4363
12479	10789	3771
12479	10789	7785
12479	10789	5132
12479	10789	6452
1510	10790	623
1510	10790	8499
19127	10791	9
19127	10791	5010
19127	10791	9768
19127	10791	4600
19127	10791	4412
19127	10791	4514
19127	10791	3498
19127	10791	7271
7444	10792	4477
10199	10793	4190
5932	10794	4980
9494	10795	2035
9494	10795	8211
9494	10795	5791
9494	10795	8846
9494	10795	338
9494	10795	6783
9494	10795	1276
9494	10795	7388
9494	10795	6359
1096	10796	3514
1096	10796	5240
1096	10796	4891
1096	10796	3241
1096	10796	9138
14697	10797	9058
14697	10797	4545
2656	10798	2587
2656	10798	6416
2656	10798	6582
7164	10799	7023
7164	10799	1500
7164	10799	822
19919	10800	7308
19919	10800	7179
19919	10800	2504
19919	10800	5760
19919	10800	3051
19919	10800	6840
6510	10801	4112
6510	10801	3036
6510	10801	7082
6510	10801	738
6510	10801	1972
6510	10801	3322
6510	10801	1519
6510	10801	7666
6510	10801	5173
15351	10802	1709
17097	10803	1803
17097	10803	8899
17097	10803	3913
17097	10803	5719
17097	10803	1993
17097	10803	9577
17097	10803	8015
17097	10803	5935
17097	10803	6235
2814	10804	9083
2814	10804	4499
2814	10804	4629
2814	10804	9339
2284	10805	7057
2284	10805	1349
2284	10805	4630
2284	10805	9231
2284	10805	7305
2284	10805	7105
2284	10805	6779
2284	10805	6840
2284	10805	4746
7656	10806	4619
7656	10806	4256
7656	10806	4808
9058	10807	8163
9058	10807	4931
8322	10808	1407
8322	10808	9420
8322	10808	7442
8322	10808	3322
8322	10808	1543
8322	10808	6015
1267	10809	4591
1267	10809	4218
1267	10809	6096
1267	10809	1846
1267	10809	3938
1267	10809	7051
1267	10809	937
1267	10809	8994
1267	10809	8151
11185	10810	7780
11185	10810	5856
11185	10810	8051
11185	10810	4428
18038	10811	8709
18038	10811	3114
18038	10811	6730
18038	10811	7330
18038	10811	9865
17716	10812	7271
17716	10812	1572
17716	10812	4984
17716	10812	8156
17716	10812	3145
17716	10812	1886
4758	10813	7089
4758	10813	9865
4758	10813	5854
4758	10813	7254
4758	10813	375
4758	10813	1450
4758	10813	5976
6492	10814	5188
6492	10814	5103
6492	10814	9018
6492	10814	9550
6492	10814	5820
6492	10814	3282
741	10815	573
741	10815	4418
741	10815	6747
741	10815	4943
741	10815	2994
741	10815	255
741	10815	4164
741	10815	2928
16061	10816	6278
4194	10817	4508
4194	10817	5198
4194	10817	8593
4194	10817	5781
4194	10817	3596
17076	10818	9456
7239	10819	2971
11332	10820	7911
11332	10820	7302
11332	10820	3072
11332	10820	1492
11332	10820	4026
19613	10821	2334
19613	10821	6173
19613	10821	1690
19613	10821	4037
19613	10821	9248
19613	10821	558
19613	10821	4519
2435	10822	9462
2435	10822	6516
2435	10822	3801
2435	10822	803
2435	10822	8091
2435	10822	7633
19932	10823	3024
19932	10823	4277
19932	10823	3428
19932	10823	5525
19932	10823	5743
19932	10823	3469
19932	10823	1261
19932	10823	9421
11872	10824	3944
11872	10824	1776
11872	10824	8901
11872	10824	3218
10592	10825	9064
10592	10825	9458
10592	10825	7828
7139	10826	7196
7139	10826	8102
7139	10826	7010
7139	10826	2552
7139	10826	2202
7139	10826	4324
7139	10826	8528
7139	10826	3385
7139	10826	4603
9258	10827	8932
9258	10827	8595
9258	10827	9595
9258	10827	329
9258	10827	5013
9258	10827	909
15835	10828	8183
15835	10828	3185
15835	10828	7544
15835	10828	5732
15835	10828	3459
15835	10828	3686
15835	10828	4963
7789	10829	654
7789	10829	268
7789	10829	7668
7789	10829	8506
7789	10829	8395
19522	10830	3328
19522	10830	7183
19522	10830	4234
19522	10830	1799
19522	10830	3247
16419	10831	2104
16419	10831	9993
16419	10831	823
16419	10831	3739
16419	10831	5540
7869	10832	3695
7869	10832	8235
7869	10832	6745
7869	10832	7894
19384	10833	5176
19384	10833	9786
3778	10834	4646
3778	10834	1905
14889	10835	1379
14889	10835	7213
14889	10835	9741
14889	10835	2095
19977	10836	9681
19977	10836	770
19977	10836	2992
19977	10836	4356
19977	10836	2445
19977	10836	6291
19977	10836	9731
19977	10836	5474
19977	10836	5639
14035	10837	2091
14035	10837	2634
14035	10837	7845
14035	10837	4174
14035	10837	2691
14035	10837	1440
14035	10837	8710
6130	10838	4697
6130	10838	3551
6130	10838	3561
6130	10838	746
6130	10838	5126
6130	10838	6218
16615	10839	2493
13331	10840	519
13331	10840	185
13331	10840	7125
13331	10840	2293
13331	10840	661
13331	10840	1567
13331	10840	1416
4322	10841	2880
4322	10841	5103
4322	10841	8852
4322	10841	1322
4322	10841	9151
4322	10841	8009
4322	10841	2081
4322	10841	3097
443	10842	6422
15978	10843	3117
15978	10843	612
15978	10843	2931
15978	10843	7988
15978	10843	4275
15978	10843	1238
15978	10843	8183
15978	10843	952
6065	10844	5298
6065	10844	4110
6065	10844	2518
6065	10844	8890
453	10845	4798
453	10845	9079
14133	10846	3906
14133	10846	1975
14133	10846	7386
14133	10846	8278
14133	10846	5959
14133	10846	2065
12347	10847	6705
12347	10847	7537
12347	10847	2137
12347	10847	6860
12347	10847	4154
12347	10847	4662
12347	10847	3005
12347	10847	2638
9225	10848	7539
9225	10848	2983
9225	10848	270
9225	10848	4755
9225	10848	1220
15848	10849	3148
15848	10849	6795
1897	10850	7207
1897	10850	3838
1897	10850	5860
1897	10850	4457
3990	10851	5493
3990	10851	4095
3990	10851	8137
3990	10851	8022
3990	10851	3238
3990	10851	3112
3990	10851	9526
3990	10851	6393
3990	10851	855
16123	10852	7906
16123	10852	6791
16123	10852	2005
16123	10852	4357
16123	10852	1903
11994	10853	1311
11994	10853	6531
11994	10853	5822
11994	10853	934
11994	10853	9550
808	10854	8466
808	10854	854
808	10854	8099
808	10854	8732
808	10854	500
4805	10855	8400
19420	10856	4258
19420	10856	1626
2350	10857	1579
2350	10857	1263
2350	10857	3131
2350	10857	6415
2350	10857	9761
2350	10857	1333
11145	10858	6350
11145	10858	4201
10694	10859	2315
10694	10859	220
10694	10859	6585
10694	10859	570
10694	10859	4917
16095	10860	9277
16095	10860	9768
16095	10860	3968
16095	10860	6182
16095	10860	9171
6742	10861	8718
6742	10861	3490
6742	10861	3527
6742	10861	5661
6742	10861	6446
6742	10861	8274
6742	10861	8061
6742	10861	9410
17373	10862	9296
10954	10863	8008
10954	10863	1411
10954	10863	2465
10954	10863	456
10954	10863	1161
10954	10863	9664
10954	10863	4093
10954	10863	3050
2221	10864	3119
2221	10864	5568
2221	10864	818
2221	10864	8518
2221	10864	340
2221	10864	7727
2221	10864	8834
2597	10865	7253
2597	10865	5125
18435	10866	1584
861	10867	380
861	10867	3360
861	10867	7812
861	10867	884
861	10867	6709
11084	10868	6840
11084	10868	8328
11084	10868	7440
11084	10868	1009
11084	10868	2670
11084	10868	4983
11084	10868	4533
3826	10869	4861
3826	10869	6259
3826	10869	6152
3826	10869	823
3826	10869	5753
7000	10870	514
7000	10870	9334
7000	10870	6286
7000	10870	2640
7000	10870	4377
17820	10871	823
17820	10871	2954
17820	10871	9198
17820	10871	8356
17820	10871	6355
17820	10871	8208
17820	10871	6500
17820	10871	5607
12240	10872	4074
12240	10872	1525
11804	10873	4812
11804	10873	178
11804	10873	3269
4931	10874	7814
4931	10874	8851
4931	10874	806
4931	10874	2630
4931	10874	6356
4931	10874	2532
4931	10874	5662
4931	10874	317
4931	10874	3318
15305	10875	5997
15305	10875	3533
15305	10875	4989
15305	10875	1731
15305	10875	4523
15305	10875	6031
15305	10875	5565
15305	10875	8724
10158	10876	5273
10158	10876	2384
10158	10876	5520
10158	10876	4984
10158	10876	3354
10158	10876	6506
77	10877	4889
77	10877	844
77	10877	9889
77	10877	2785
3018	10878	6588
3018	10878	2738
3018	10878	4653
3018	10878	7449
3018	10878	823
3018	10878	8778
3018	10878	9098
15241	10879	1132
15241	10879	2488
4753	10880	7830
4753	10880	3915
4753	10880	9520
4514	10881	7378
4514	10881	2619
4514	10881	2245
2683	10882	8962
2683	10882	8047
2683	10882	2212
2683	10882	2069
2683	10882	2910
2683	10882	4239
16308	10883	8657
16308	10883	5256
16308	10883	2460
10156	10884	6475
10156	10884	4416
10156	10884	9116
14324	10885	7695
14324	10885	9198
14324	10885	6458
14324	10885	1344
14324	10885	1590
14324	10885	2936
14324	10885	3571
12060	10886	1108
12060	10886	5170
19170	10887	2962
19170	10887	1147
19170	10887	3256
19170	10887	1971
16856	10888	8365
2599	10889	9490
2599	10889	3950
2599	10889	1087
2599	10889	1972
2599	10889	2639
2599	10889	5841
2599	10889	826
2599	10889	9264
5038	10890	4973
5038	10890	5633
5038	10890	1049
5038	10890	8343
5038	10890	5296
5038	10890	3317
5038	10890	5060
12293	10891	2402
12293	10891	3912
12293	10891	8334
12293	10891	7044
12293	10891	6710
12293	10891	117
12293	10891	9482
10228	10892	9110
10228	10892	4230
10228	10892	363
10228	10892	9192
10228	10892	4813
10228	10892	1569
10228	10892	1362
10228	10892	2096
860	10893	8027
860	10893	1533
860	10893	4245
860	10893	3232
860	10893	6128
860	10893	860
860	10893	3478
860	10893	9644
860	10893	2637
14898	10894	4584
13360	10895	7110
13360	10895	6269
13360	10895	6492
13360	10895	3279
13360	10895	8815
13360	10895	2764
13360	10895	5694
18342	10896	3011
18342	10896	8659
18342	10896	8798
18342	10896	3106
18342	10896	6271
18342	10896	62
18342	10896	4921
18342	10896	5802
18342	10896	2307
11171	10897	2097
11171	10897	2748
11171	10897	9418
11171	10897	6961
11171	10897	2751
11171	10897	9480
11171	10897	2246
11171	10897	3193
18927	10898	5494
18927	10898	8892
2395	10899	6783
2395	10899	6163
2395	10899	2414
2395	10899	6669
2395	10899	1838
2395	10899	9961
2395	10899	3602
2395	10899	5997
18380	10900	8653
18380	10900	1097
18380	10900	2635
18380	10900	5443
18380	10900	1186
18380	10900	361
18380	10900	5652
18380	10900	6848
18380	10900	5434
14542	10901	1859
14542	10901	9296
14542	10901	6595
14542	10901	7046
14542	10901	6389
14542	10901	2248
14542	10901	9845
14542	10901	7473
14542	10901	6885
14492	10902	3770
14492	10902	8037
14492	10902	6990
14492	10902	6475
14492	10902	7788
14492	10902	4883
14492	10902	6189
14492	10902	4095
14492	10902	9269
3031	10903	6398
3031	10903	4066
3031	10903	4099
3031	10903	528
3031	10903	8357
3031	10903	4198
3031	10903	3500
3031	10903	4324
4222	10904	9194
6577	10905	3772
3480	10906	7181
3480	10906	2143
3480	10906	7891
3480	10906	2004
3480	10906	6967
3480	10906	2640
3480	10906	7388
3480	10906	441
17495	10907	3244
17495	10907	1556
17495	10907	5541
17495	10907	7637
17495	10907	7068
17495	10907	6866
17495	10907	2584
17495	10907	5527
15061	10908	3732
15061	10908	9110
15061	10908	6324
15061	10908	3828
15061	10908	8298
15061	10908	3665
15061	10908	1333
15061	10908	2514
301	10909	3228
301	10909	1863
301	10909	751
301	10909	6285
301	10909	4920
301	10909	1072
301	10909	2366
17378	10910	4086
17378	10910	338
17378	10910	9569
17378	10910	2971
7036	10911	1133
7036	10911	5164
7036	10911	1271
7036	10911	384
10606	10912	3954
10606	10912	9593
10606	10912	1616
10606	10912	7321
10606	10912	7353
10606	10912	3451
10606	10912	9328
10606	10912	9003
10606	10912	9939
2143	10913	4066
2143	10913	2369
2143	10913	5521
2143	10913	9752
2143	10913	121
2143	10913	9008
1246	10914	6324
1246	10914	2407
1246	10914	3310
1246	10914	6196
1246	10914	9606
1795	10915	7353
19441	10916	430
19441	10916	9810
19441	10916	9175
19441	10916	264
18602	10917	5691
18602	10917	5539
18602	10917	5491
18602	10917	1313
18602	10917	7869
18602	10917	5993
6690	10918	3066
6690	10918	7039
6690	10918	7534
13417	10919	3311
13417	10919	3608
13417	10919	872
13417	10919	8418
7817	10920	9004
7817	10920	4472
7817	10920	1086
7817	10920	8342
7817	10920	2885
7817	10920	9494
7817	10920	4901
7817	10920	6772
7817	10920	3735
14092	10921	1707
14092	10921	6158
14092	10921	4828
14092	10921	4033
14092	10921	4067
14092	10921	8984
14092	10921	8033
12749	10922	7781
5363	10923	1626
5363	10923	130
5363	10923	4800
5363	10923	1738
5363	10923	6094
5363	10923	6631
5363	10923	2352
12836	10924	4957
12836	10924	2947
12836	10924	8106
11773	10925	8568
11773	10925	2676
11773	10925	9212
11773	10925	5072
11773	10925	481
13149	10926	7495
13149	10926	7810
13149	10926	3473
13149	10926	4264
13149	10926	3240
13149	10926	1498
13149	10926	7656
10187	10927	6551
10187	10927	5994
10187	10927	6026
10187	10927	9773
10187	10927	7874
10187	10927	3081
1151	10928	1963
1151	10928	6754
1151	10928	1535
1151	10928	3437
1151	10928	1338
17139	10929	4369
17139	10929	2359
17139	10929	8498
17139	10929	1427
17139	10929	4891
17139	10929	8559
17139	10929	1878
17139	10929	8547
17139	10929	1241
15987	10930	7986
15987	10930	9181
15987	10930	1265
15987	10930	7894
15987	10930	6912
15987	10930	186
17366	10931	6953
17366	10931	3351
17366	10931	516
17366	10931	1507
5493	10932	740
5493	10932	7503
13367	10933	4458
13367	10933	5194
13367	10933	8204
13367	10933	639
13367	10933	4061
13367	10933	4878
13367	10933	838
2708	10934	417
2708	10934	777
2708	10934	1547
2708	10934	6296
2708	10934	242
2708	10934	5734
2708	10934	520
2708	10934	4232
4871	10935	3263
4871	10935	492
2658	10936	2683
2658	10936	721
2658	10936	19
3132	10937	616
3132	10937	2159
3132	10937	1545
3132	10937	6539
3132	10937	8392
3132	10937	8212
3132	10937	296
3132	10937	4636
3132	10937	9615
11968	10938	5809
11968	10938	7898
11968	10938	5710
11968	10938	7393
11968	10938	368
5052	10939	5205
5052	10939	9297
5052	10939	8994
5052	10939	3080
15429	10940	8516
15429	10940	4581
15429	10940	6990
15429	10940	6218
15429	10940	6217
15429	10940	5871
15429	10940	650
15429	10940	1618
11949	10941	6870
11949	10941	7564
11949	10941	2952
11949	10941	5152
10454	10942	7418
10454	10942	8879
10454	10942	5501
10454	10942	9294
10454	10942	7024
10454	10942	5326
10454	10942	1402
329	10943	4132
329	10943	1889
329	10943	5650
329	10943	2339
329	10943	6773
329	10943	6028
6890	10944	7852
6890	10944	1543
6890	10944	9633
6890	10944	2309
6890	10944	6240
6890	10944	1902
9638	10945	4606
9638	10945	9702
9638	10945	9710
9638	10945	1056
9638	10945	2735
9638	10945	3786
9638	10945	528
9638	10945	6749
16583	10946	6858
16583	10946	8707
16583	10946	1543
16583	10946	9635
5234	10947	7488
14395	10948	3680
14395	10948	8425
17905	10949	7332
17905	10949	3241
17905	10949	1530
17905	10949	690
17905	10949	3195
5658	10950	5446
5658	10950	6302
5658	10950	4193
5658	10950	131
5658	10950	7931
5658	10950	7254
10909	10951	404
10909	10951	2724
10909	10951	5496
10909	10951	3743
10909	10951	4490
10667	10952	1603
10667	10952	7133
10667	10952	8145
10667	10952	4494
10667	10952	682
10667	10952	2086
6722	10953	8303
6722	10953	6725
6722	10953	7438
6722	10953	5280
19538	10954	5102
19538	10954	2883
19538	10954	3096
19538	10954	4610
19538	10954	1341
19538	10954	9515
19538	10954	1526
608	10955	4390
608	10955	7141
608	10955	4289
608	10955	3333
3473	10956	8556
3473	10956	1759
3473	10956	1143
3473	10956	1454
5588	10957	4816
5588	10957	7209
5588	10957	6684
5588	10957	8120
5588	10957	5433
5588	10957	2186
11038	10958	7255
11038	10958	9472
11038	10958	3063
11038	10958	7249
11038	10958	6085
11038	10958	9957
9623	10959	1191
9623	10959	1084
9623	10959	7166
9623	10959	8948
9623	10959	4463
9623	10959	2319
3214	10960	232
3214	10960	9717
3214	10960	598
3214	10960	7499
14911	10961	2267
14911	10961	3472
14911	10961	1643
14911	10961	1332
14911	10961	3758
14911	10961	1406
14911	10961	1413
16129	10962	1971
16129	10962	1784
16129	10962	8855
12706	10963	3808
12706	10963	1480
12706	10963	4571
12706	10963	9532
1727	10964	1143
1727	10964	1482
1727	10964	150
10959	10965	1040
10959	10965	4277
10959	10965	584
19295	10966	7571
4283	10967	8355
4283	10967	6524
4283	10967	6446
4283	10967	9802
4283	10967	221
4283	10967	1930
16697	10968	6551
16697	10968	6364
16697	10968	636
16697	10968	6781
16697	10968	2666
16697	10968	6612
580	10969	3474
580	10969	8223
580	10969	8645
580	10969	7848
580	10969	7974
6807	10970	9873
6807	10970	840
6807	10970	1809
17180	10971	2942
17180	10971	307
9523	10972	5741
9523	10972	9652
9523	10972	528
9523	10972	3251
9523	10972	7276
9523	10972	1905
9523	10972	6089
9523	10972	77
9523	10972	8014
13720	10973	8372
13720	10973	3732
13720	10973	2851
13720	10973	3440
13720	10973	9724
13720	10973	9636
13720	10973	3565
13630	10974	9770
13630	10974	9552
13630	10974	2346
13630	10974	2788
2382	10975	8954
2382	10975	5405
16509	10976	5386
16509	10976	6889
16509	10976	1776
16509	10976	5184
16509	10976	7268
16509	10976	2800
16509	10976	4415
13521	10977	7119
13521	10977	6875
13521	10977	5480
13521	10977	9928
13521	10977	8513
13521	10977	9138
9047	10978	9544
9047	10978	9246
9047	10978	4013
9047	10978	8574
9047	10978	3552
9047	10978	9163
9047	10978	9749
9047	10978	2131
18011	10979	4833
6689	10980	4533
16241	10981	3484
16241	10981	8928
16241	10981	1786
16241	10981	4308
6940	10982	4611
18488	10983	9357
18488	10983	9444
18488	10983	1097
18488	10983	486
18488	10983	2005
18488	10983	3750
18488	10983	9344
18488	10983	3302
10173	10984	424
10173	10984	2505
10173	10984	6504
10173	10984	6123
10173	10984	6360
10173	10984	1922
10173	10984	6795
10173	10984	6068
10173	10984	6138
16284	10985	6172
16284	10985	4503
16284	10985	9312
16284	10985	4560
16284	10985	8266
16284	10985	1349
16284	10985	7190
6625	10986	2355
6625	10986	9962
6625	10986	4750
6625	10986	7042
1123	10987	7832
1123	10987	5319
1123	10987	4674
1123	10987	1564
19657	10988	599
16970	10989	2731
5383	10990	8721
5383	10990	9398
5383	10990	3826
5383	10990	5581
5383	10990	3627
5383	10990	3990
5383	10990	5530
5383	10990	7535
3502	10991	3157
3502	10991	4464
3502	10991	5604
3502	10991	4949
3502	10991	9886
3502	10991	7877
14549	10992	5701
14549	10992	9918
14549	10992	6389
14549	10992	7629
14549	10992	9461
14549	10992	7162
14549	10992	6913
14549	10992	821
10569	10993	2479
10569	10993	3664
10569	10993	4067
10569	10993	970
1756	10994	6367
1756	10994	3842
1756	10994	590
1756	10994	4673
1756	10994	6632
7090	10995	3615
7090	10995	996
7090	10995	8299
7090	10995	4455
7090	10995	5838
7090	10995	3501
4630	10996	6829
4630	10996	470
4630	10996	6807
4630	10996	2141
17545	10997	2317
17545	10997	1711
17545	10997	2618
17545	10997	7493
17545	10997	6181
17545	10997	2878
12756	10998	8693
12756	10998	1280
12756	10998	563
12756	10998	6192
12756	10998	2808
12756	10998	8848
12756	10998	7104
18842	10999	5353
18842	10999	4333
1027	11000	2532
1027	11000	3569
1027	11000	2752
1027	11000	7869
1027	11000	7783
1027	11000	5780
1027	11000	5800
4497	11001	7259
4497	11001	618
4497	11001	7328
4497	11001	1387
4497	11001	3472
4497	11001	8008
4497	11001	5368
4497	11001	7533
4497	11001	8538
11426	11002	5650
11426	11002	6126
11426	11002	6751
11638	11003	8467
11638	11003	9904
11638	11003	6427
11638	11003	1953
11638	11003	2340
11638	11003	601
11638	11003	4331
11638	11003	5758
11638	11003	8024
14033	11004	9068
14033	11004	4294
14033	11004	4433
14033	11004	1637
206	11005	5897
206	11005	7369
206	11005	3626
206	11005	7810
206	11005	7415
206	11005	2359
765	11006	7399
765	11006	7817
765	11006	7408
765	11006	2284
7841	11007	4024
7841	11007	970
7841	11007	8430
7841	11007	7769
7841	11007	8046
10922	11008	8634
10922	11008	9022
10922	11008	6313
10922	11008	96
10922	11008	2887
10922	11008	6240
10922	11008	9345
10922	11008	9092
6230	11009	3035
1607	11010	6382
1607	11010	2660
1607	11010	6850
1607	11010	6825
1607	11010	7141
1607	11010	2293
1607	11010	7267
7012	11011	8461
7012	11011	829
7012	11011	2557
7012	11011	9122
16550	11012	5475
16550	11012	2288
16550	11012	6876
16550	11012	9428
13136	11013	3805
13136	11013	2481
13136	11013	7610
13136	11013	2631
13136	11013	2273
13136	11013	4376
13136	11013	5733
15762	11014	1959
15762	11014	9588
15762	11014	5380
15762	11014	3383
15762	11014	163
15762	11014	1375
15762	11014	5693
16347	11015	1004
16347	11015	4783
16347	11015	9814
16347	11015	8104
16347	11015	2655
16347	11015	3427
16347	11015	5335
16347	11015	1672
14103	11016	1859
14103	11016	1405
14103	11016	8549
19304	11017	8365
19304	11017	8492
16609	11018	3851
16609	11018	6177
16609	11018	9385
16609	11018	2662
16609	11018	6435
16609	11018	8108
16609	11018	5306
13421	11019	3808
13421	11019	7568
13421	11019	3748
13421	11019	5353
13421	11019	9079
13421	11019	544
13421	11019	2558
13421	11019	6341
11449	11020	6781
11449	11020	6625
11449	11020	4501
11449	11020	4853
16103	11021	9663
16103	11021	1526
16103	11021	5283
8722	11022	5743
8722	11022	586
8722	11022	3075
8722	11022	7808
8722	11022	6589
8722	11022	2
9004	11023	8370
9004	11023	2380
9004	11023	6231
9004	11023	9504
9574	11024	9148
9780	11025	6973
9780	11025	133
9780	11025	7153
9780	11025	9368
9780	11025	9935
9780	11025	1657
9780	11025	3171
9780	11025	8860
10180	11026	2846
10180	11026	4470
10180	11026	4142
10180	11026	3897
10180	11026	8507
10180	11026	9310
10180	11026	8485
10180	11026	259
10180	11026	6164
12197	11027	1176
12197	11027	4475
12197	11027	7189
12197	11027	5126
12197	11027	4336
17611	11028	2422
17611	11028	3396
5410	11029	2147
5410	11029	8124
5410	11029	6293
9523	11030	6401
9523	11030	5620
9523	11030	4491
9523	11030	8369
9523	11030	8716
9523	11030	7633
108	11031	983
108	11031	4252
12797	11032	4709
12797	11032	9041
12797	11032	5111
12797	11032	4702
12797	11032	4242
12797	11032	5100
12797	11032	1065
12797	11032	7560
10383	11033	5246
10383	11033	9356
10383	11033	4978
10383	11033	3618
10383	11033	6
10383	11033	3105
10383	11033	8024
10383	11033	3832
17065	11034	8853
19836	11035	9698
19836	11035	2274
19836	11035	677
19836	11035	1107
19836	11035	3747
19836	11035	3640
19836	11035	1064
8337	11036	6314
8337	11036	6196
8337	11036	723
19152	11037	9494
19152	11037	259
19152	11037	6663
14679	11038	7373
14679	11038	26
14679	11038	1163
14679	11038	4657
6032	11039	5207
6032	11039	4433
16171	11040	1262
16171	11040	675
16171	11040	4189
16171	11040	4053
16171	11040	4677
16171	11040	967
16171	11040	7902
18129	11041	5266
18129	11041	733
18129	11041	8908
18129	11041	9986
18129	11041	1869
18129	11041	1426
18129	11041	3163
7674	11042	1174
7674	11042	3585
7674	11042	2363
7674	11042	7899
7674	11042	5544
7674	11042	9329
9187	11043	9122
9187	11043	5347
9187	11043	7211
9187	11043	5390
9187	11043	4589
9187	11043	1324
9187	11043	2389
9187	11043	3520
9187	11043	3790
12304	11044	6417
12304	11044	8268
12304	11044	4824
12304	11044	338
12304	11044	6350
12304	11044	3657
12304	11044	8566
7910	11045	2507
7910	11045	460
7910	11045	6357
7910	11045	8457
15736	11046	5178
15736	11046	9940
15736	11046	8459
17594	11047	8256
17594	11047	8433
17594	11047	9074
17594	11047	777
17594	11047	844
17594	11047	9404
17594	11047	8178
13268	11048	4502
13268	11048	9106
13268	11048	4920
13268	11048	3124
13268	11048	3809
13268	11048	2175
862	11049	7253
862	11049	6024
862	11049	4215
862	11049	1312
862	11049	8171
862	11049	9379
862	11049	6123
862	11049	9819
17849	11050	7970
17849	11050	5788
17849	11050	6936
14365	11051	5862
14365	11051	2337
14365	11051	3674
14365	11051	8754
14365	11051	169
14365	11051	4475
14365	11051	378
392	11052	9120
392	11052	4730
392	11052	4950
3772	11053	9068
3772	11053	5701
3772	11053	2517
3772	11053	6816
3772	11053	4588
3772	11053	1176
3772	11053	2494
3772	11053	4302
3772	11053	6248
14937	11054	8993
14937	11054	9275
16282	11055	7143
16282	11055	2052
16282	11055	9826
16282	11055	879
16282	11055	759
3868	11056	7584
3868	11056	7575
3868	11056	3656
3868	11056	1300
3868	11056	2828
4205	11057	244
4205	11057	3174
4205	11057	4958
4205	11057	228
4205	11057	9793
4205	11057	1425
4205	11057	6573
4205	11057	2485
136	11058	3899
136	11058	6555
136	11058	82
136	11058	5491
136	11058	1485
136	11058	9368
5081	11059	7765
5081	11059	9527
5081	11059	447
5081	11059	8108
5081	11059	4586
5849	11060	8838
5849	11060	101
5849	11060	9757
5849	11060	4775
5849	11060	1556
1846	11061	3464
1846	11061	9501
1846	11061	6441
1846	11061	8785
1846	11061	9978
9126	11062	7488
9126	11062	2848
9126	11062	2701
9126	11062	1718
9126	11062	3131
9126	11062	7703
9126	11062	2752
1477	11063	7839
1477	11063	300
1477	11063	5959
1477	11063	1165
1477	11063	5977
1477	11063	499
1477	11063	2789
1477	11063	1602
1477	11063	4311
12057	11064	2521
12057	11064	6401
4019	11065	1082
4019	11065	1497
4019	11065	8127
4019	11065	466
4019	11065	3391
7778	11066	1875
7778	11066	2787
7778	11066	5806
7778	11066	2214
7778	11066	3086
7778	11066	7025
7778	11066	6
12032	11067	9865
12032	11067	3959
12032	11067	7676
2131	11068	4955
2131	11068	8795
3162	11069	2952
3162	11069	642
3162	11069	9961
3162	11069	5524
3162	11069	1826
3162	11069	5982
3162	11069	9597
3162	11069	772
16893	11070	9512
16893	11070	2762
3113	11071	3137
3113	11071	9964
1209	11072	8271
1209	11072	9462
1209	11072	4671
1209	11072	647
1209	11072	1290
1209	11072	7822
1209	11072	9864
1209	11072	6245
1209	11072	4647
8522	11073	6147
8522	11073	9444
8522	11073	9788
8522	11073	6714
8522	11073	8475
15874	11074	3381
15874	11074	8502
15874	11074	7144
15874	11074	9796
12080	11075	5047
12080	11075	1032
12080	11075	5360
12080	11075	9308
12080	11075	3288
12080	11075	3782
12080	11075	1010
1149	11076	4809
6621	11077	9634
6621	11077	9944
6621	11077	4079
18249	11078	4733
18249	11078	6740
18249	11078	6713
18249	11078	3135
18249	11078	29
18249	11078	2750
18249	11078	4718
18249	11078	5081
18249	11078	6516
9516	11079	2796
9516	11079	4230
9516	11079	81
13262	11080	8541
10505	11081	5747
10505	11081	2049
10505	11081	4132
10505	11081	1439
10505	11081	6294
10505	11081	86
10505	11081	2711
10505	11081	1602
11661	11082	8590
11661	11082	4359
11661	11082	9110
11661	11082	9971
11661	11082	8151
11661	11082	1785
11661	11082	8176
4614	11083	1519
4614	11083	1784
4614	11083	6024
4614	11083	5499
6293	11084	875
6293	11084	761
6293	11084	2955
5850	11085	1984
5850	11085	180
5850	11085	9367
5850	11085	2466
5850	11085	6403
5850	11085	6861
5768	11086	509
7929	11087	6009
7929	11087	341
7929	11087	5694
7929	11087	1889
7929	11087	4755
9868	11088	7506
9868	11088	4310
9868	11088	481
9868	11088	2096
9555	11089	7460
9555	11089	8527
9555	11089	6498
9555	11089	8349
9555	11089	3499
10775	11090	9259
6579	11091	9785
6579	11091	6413
6579	11091	8284
4676	11092	6901
4676	11092	4881
4676	11092	3269
4676	11092	9963
6924	11093	8849
6924	11093	3593
6924	11093	7605
6924	11093	1397
2364	11094	1447
2364	11094	6017
2364	11094	8144
2364	11094	1271
2364	11094	48
2364	11094	471
2364	11094	7529
11491	11095	9273
5731	11096	1457
5731	11096	7748
5731	11096	3430
5731	11096	60
5731	11096	1076
5731	11096	2658
5731	11096	5379
10853	11097	8743
10853	11097	5167
10853	11097	3354
10853	11097	4269
10853	11097	1806
5314	11098	4906
5314	11098	9500
5314	11098	4362
5314	11098	3212
5314	11098	5637
5314	11098	4656
5314	11098	9798
19754	11099	7486
19754	11099	8859
19754	11099	7879
19754	11099	3466
19754	11099	7131
16949	11100	7566
16949	11100	5581
16949	11100	4964
16949	11100	7364
16949	11100	4662
16949	11100	1615
16949	11100	938
9176	11101	3405
9176	11101	2661
12251	11102	5083
12251	11102	830
12251	11102	553
12268	11103	4927
12268	11103	1956
7140	11104	1625
9727	11105	6961
9727	11105	9919
9727	11105	8990
9727	11105	4541
9727	11105	4193
9727	11105	5059
9727	11105	3765
9727	11105	880
11611	11106	5394
11611	11106	8331
11611	11106	2121
11611	11106	7823
11611	11106	4819
3560	11107	3966
3560	11107	6789
3560	11107	3952
3560	11107	3876
3560	11107	5727
3560	11107	461
6533	11108	8027
6533	11108	4978
6533	11108	7245
6533	11108	6313
2264	11109	2912
13754	11110	5383
13754	11110	4107
13754	11110	6825
14571	11111	552
14571	11111	2128
14571	11111	6655
14571	11111	4936
14571	11111	4203
14571	11111	8966
14571	11111	2381
14571	11111	9085
10843	11112	8548
10843	11112	7722
10843	11112	6811
10843	11112	2488
10843	11112	1833
10843	11112	2338
10843	11112	7778
10843	11112	963
10843	11112	1570
11545	11113	4424
11545	11113	9357
11545	11113	4820
11545	11113	8930
11545	11113	5307
11545	11113	4541
11545	11113	131
5237	11114	1546
5237	11114	1791
5237	11114	1863
5237	11114	3756
5237	11114	8652
5237	11114	9204
5237	11114	9385
5237	11114	5326
5237	11114	7135
12128	11115	3541
12128	11115	2477
12128	11115	3026
12128	11115	6289
12128	11115	9458
12128	11115	5485
12128	11115	7158
12128	11115	4002
12128	11115	778
19963	11116	3609
19963	11116	1126
19963	11116	3921
2110	11117	2729
11509	11118	3841
18650	11119	6671
18650	11119	6210
18650	11119	4602
18650	11119	7431
18650	11119	1594
5439	11120	7986
5402	11121	9892
5402	11121	287
5402	11121	3258
5402	11121	3835
5402	11121	3452
245	11122	7571
245	11122	2114
245	11122	1386
16427	11123	8963
16427	11123	6409
16427	11123	7114
16427	11123	5298
16427	11123	8294
16427	11123	4140
16427	11123	9711
16427	11123	2949
19287	11124	2548
19287	11124	1823
19287	11124	5856
19287	11124	8370
9592	11125	9209
12644	11126	3328
12644	11126	2031
12644	11126	1311
12644	11126	5442
12644	11126	4903
12644	11126	3902
12899	11127	1111
18960	11128	4276
18960	11128	5523
18960	11128	2630
18960	11128	9807
18960	11128	3119
10300	11129	6892
10300	11129	9424
10300	11129	1240
10300	11129	9981
10300	11129	9775
1772	11130	366
1772	11130	9290
1772	11130	7214
1772	11130	8126
15864	11131	1066
15864	11131	9752
15864	11131	2959
15864	11131	7708
15864	11131	8438
16836	11132	7440
16836	11132	6368
16836	11132	3458
16836	11132	2064
16836	11132	1375
19001	11133	7432
19001	11133	3644
19001	11133	854
19001	11133	164
19001	11133	39
19001	11133	6195
19001	11133	6819
19001	11133	6894
19001	11133	7385
7504	11134	486
7504	11134	1201
7504	11134	7031
7504	11134	1361
7504	11134	7800
7504	11134	9213
7504	11134	7289
7504	11134	4838
9752	11135	3352
492	11136	4579
492	11136	3111
492	11136	1284
492	11136	8021
492	11136	5456
492	11136	1243
492	11136	1204
492	11136	5608
492	11136	484
10643	11137	198
10643	11137	4433
10643	11137	7813
10643	11137	3795
16746	11138	8640
16746	11138	2472
16746	11138	2242
16746	11138	1712
16746	11138	4743
16746	11138	2526
16746	11138	3331
16746	11138	3247
7191	11139	9267
7191	11139	2076
7191	11139	9011
7191	11139	2725
7191	11139	4243
7191	11139	3653
7191	11139	958
7191	11139	9544
2509	11140	4170
2509	11140	9146
2509	11140	2217
2509	11140	1311
2509	11140	5988
2509	11140	9074
2509	11140	2087
2509	11140	2334
10118	11141	6258
10118	11141	4146
7378	11142	4943
7378	11142	8497
7378	11142	6305
7378	11142	6612
7378	11142	34
7378	11142	9068
7378	11142	7405
7378	11142	1275
7378	11142	9291
12620	11143	7573
12620	11143	5986
12620	11143	2140
12620	11143	5407
12620	11143	1338
12620	11143	9651
11909	11144	4476
11909	11144	3995
11909	11144	3528
11909	11144	1684
11909	11144	889
11909	11144	8411
14155	11145	2003
14155	11145	6574
14155	11145	5558
14155	11145	6696
14155	11145	2329
3580	11146	7862
3580	11146	1711
3580	11146	319
3580	11146	3255
8287	11147	5619
8287	11147	5529
8287	11147	5115
8287	11147	7477
8287	11147	1674
8287	11147	3667
8287	11147	9931
8287	11147	4716
14031	11148	3791
14031	11148	7503
14031	11148	7812
14031	11148	6111
14031	11148	4900
14031	11148	6305
3667	11149	9365
3667	11149	6146
3667	11149	4586
3667	11149	9407
3667	11149	5808
7184	11150	9238
7184	11150	4610
4842	11151	274
4842	11151	4235
4842	11151	2916
4842	11151	8412
4842	11151	8038
8366	11152	3996
8366	11152	7640
8366	11152	2342
6958	11153	8408
6958	11153	9372
6958	11153	7880
16307	11154	4732
16307	11154	405
16307	11154	9169
16307	11154	918
16307	11154	2625
16307	11154	832
16307	11154	7952
586	11155	3772
586	11155	2449
586	11155	3593
586	11155	9623
586	11155	8689
586	11155	9625
586	11155	9042
586	11155	135
586	11155	7499
16833	11156	8148
12198	11157	6392
12198	11157	3373
12198	11157	1734
12198	11157	2342
3929	11158	4180
3929	11158	4284
3929	11158	779
3929	11158	2669
3929	11158	3721
3929	11158	6693
9681	11159	939
9681	11159	1759
9681	11159	8489
9681	11159	7494
9681	11159	952
9681	11159	5548
9681	11159	1799
9681	11159	4921
18409	11160	3622
18409	11160	7822
18409	11160	2425
18409	11160	8075
18409	11160	9355
18409	11160	1698
18409	11160	1539
18409	11160	7624
18409	11160	8587
19076	11161	8130
19076	11161	8141
19076	11161	2729
19076	11161	2255
19076	11161	6453
19076	11161	3797
12442	11162	9716
12442	11162	7943
18962	11163	9509
18962	11163	1178
18962	11163	2994
18962	11163	5553
18962	11163	2880
18962	11163	4174
12856	11164	2304
12856	11164	1328
12856	11164	7554
12856	11164	6816
12856	11164	8261
12856	11164	8682
12856	11164	4239
7493	11165	3504
7493	11165	65
7493	11165	1124
7493	11165	2749
6700	11166	404
6700	11166	7422
6700	11166	9552
6700	11166	1848
6700	11166	2245
6700	11166	1124
10725	11167	9109
10725	11167	3499
10725	11167	1485
10725	11167	1668
10725	11167	6508
10725	11167	7906
10725	11167	7767
10725	11167	1149
10725	11167	3660
6421	11168	9577
6421	11168	1856
17322	11169	8224
17322	11169	2676
8321	11170	6768
8321	11170	3867
8321	11170	6854
8321	11170	4304
8321	11170	9802
8321	11170	6572
8321	11170	1173
8321	11170	1451
8321	11170	5905
5240	11171	3812
5240	11171	2683
5240	11171	1913
5240	11171	648
5240	11171	9916
5240	11171	8993
5240	11171	2089
12785	11172	4355
12785	11172	4918
12785	11172	535
12785	11172	6277
12785	11172	9675
3282	11173	1831
3282	11173	9359
3282	11173	8386
16602	11174	2083
16602	11174	5782
16602	11174	5903
16602	11174	2712
16602	11174	49
16602	11174	5784
16602	11174	3998
16602	11174	7022
16602	11174	9786
10047	11175	2944
10047	11175	887
10047	11175	8315
10047	11175	9630
10047	11175	1765
10047	11175	5246
10047	11175	9209
3841	11176	9550
3841	11176	7806
3841	11176	9249
3841	11176	7220
3841	11176	908
3841	11176	4058
3841	11176	9676
1125	11177	2392
1125	11177	2216
1125	11177	9674
1125	11177	1702
1125	11177	8610
1125	11177	802
704	11178	3900
704	11178	8733
704	11178	5487
704	11178	3651
6652	11179	3888
6652	11179	4143
6652	11179	2838
6652	11179	436
6652	11179	3820
6652	11179	1392
6652	11179	1014
14226	11180	1019
14226	11180	6099
14226	11180	7564
14226	11180	9391
14226	11180	1129
14226	11180	4540
14226	11180	6550
14226	11180	2551
14226	11180	4708
10285	11181	7279
16584	11182	5405
16584	11182	5392
16584	11182	473
16584	11182	6174
16584	11182	3076
16584	11182	9250
7580	11183	2218
13850	11184	2067
13850	11184	9616
13850	11184	7006
13850	11184	7638
13850	11184	8661
13850	11184	2517
13850	11184	9466
13850	11184	5543
17236	11185	2822
9402	11186	9130
9402	11186	3207
9402	11186	7093
9402	11186	6663
9402	11186	4619
9402	11186	9624
16568	11187	2336
16568	11187	7661
16568	11187	403
16568	11187	6497
16568	11187	8960
6048	11188	9306
6048	11188	2260
6048	11188	2097
6048	11188	7786
4810	11189	4661
4810	11189	3967
4810	11189	9255
4810	11189	4724
4810	11189	4181
4810	11189	5601
9120	11190	7584
9120	11190	7900
9120	11190	7163
9120	11190	9402
14376	11191	9593
14376	11191	1254
14376	11191	5027
14376	11191	4213
14376	11191	1522
14376	11191	1196
13592	11192	1356
17880	11193	5830
17880	11193	2839
17880	11193	6812
9659	11194	5274
9659	11194	6265
955	11195	9414
955	11195	1618
955	11195	2573
955	11195	4267
955	11195	4373
955	11195	2868
17395	11196	3929
17395	11196	6912
17395	11196	3956
17395	11196	8358
17395	11196	4006
16797	11197	4314
16797	11197	9887
16797	11197	7989
16797	11197	3929
16603	11198	3064
16603	11198	7953
16603	11198	7586
16603	11198	4505
16603	11198	8228
16603	11198	9331
16603	11198	7690
16603	11198	1209
16603	11198	1734
12094	11199	1978
12094	11199	3676
127	11200	9320
127	11200	5388
127	11200	2650
14309	11201	5615
14309	11201	3967
14309	11201	137
14309	11201	524
14309	11201	1484
14309	11201	7918
14309	11201	3069
13489	11202	6808
13489	11202	4544
19861	11203	2904
19861	11203	7083
19861	11203	9933
19861	11203	7177
19861	11203	6002
19861	11203	9075
19861	11203	9184
19861	11203	8379
19861	11203	2864
7958	11204	6158
7958	11204	2806
7958	11204	1126
9050	11205	7077
9050	11205	3911
9050	11205	9791
9050	11205	910
19969	11206	543
19969	11206	4686
19969	11206	2145
19969	11206	7386
19969	11206	4480
19969	11206	5336
19969	11206	4245
9751	11207	8411
9751	11207	4475
9751	11207	5072
9751	11207	3409
9751	11207	58
9751	11207	5965
9751	11207	9394
8159	11208	5762
8159	11208	5554
8159	11208	842
8159	11208	7525
8159	11208	7350
16669	11209	6397
16669	11209	694
16669	11209	1014
16669	11209	7449
16669	11209	5911
16669	11209	3448
16669	11209	9921
16669	11209	9384
10291	11210	5386
10291	11210	8180
10291	11210	3061
10291	11210	7804
10291	11210	3863
10291	11210	1395
10291	11210	6826
15678	11211	8910
15678	11211	2589
15678	11211	7405
15678	11211	8878
15678	11211	2343
15678	11211	1934
15678	11211	7907
15678	11211	7451
15678	11211	230
16068	11212	8112
16068	11212	5737
16068	11212	7015
16068	11212	2776
16068	11212	6640
18456	11213	1737
18456	11213	9498
18456	11213	3535
2883	11214	7527
18283	11215	4619
18283	11215	9978
18283	11215	62
18283	11215	7819
18283	11215	196
11000	11216	8210
11000	11216	1484
11000	11216	9502
11000	11216	9139
11000	11216	6460
11000	11216	4063
11000	11216	6870
11000	11216	3128
15491	11217	8101
11838	11218	377
11838	11218	3294
11838	11218	4995
11838	11218	9484
11838	11218	9210
11838	11218	1496
11838	11218	2042
11838	11218	6238
6214	11219	6991
6214	11219	2814
6214	11219	2919
6214	11219	5071
6214	11219	6832
14417	11220	1271
14417	11220	3108
4634	11221	666
4634	11221	4332
4634	11221	7884
4634	11221	10
4634	11221	1341
4634	11221	1878
9591	11222	5312
9591	11222	5050
9591	11222	9107
9591	11222	5227
9591	11222	6863
9591	11222	1132
9591	11222	650
9591	11222	8121
4905	11223	8725
130	11224	4219
130	11224	6772
4166	11225	5705
4166	11225	9804
13332	11226	8410
13332	11226	2668
10635	11227	5851
10635	11227	7673
10635	11227	7772
10635	11227	7925
10635	11227	1125
10635	11227	1275
10635	11227	6779
10635	11227	8766
10635	11227	2747
6826	11228	5211
6826	11228	2592
6826	11228	174
18311	11229	6863
18311	11229	4996
18311	11229	3839
18311	11229	6624
18311	11229	7617
18311	11229	2384
18311	11229	355
18311	11229	6879
18311	11229	9718
9904	11230	8596
9904	11230	9604
5598	11231	1846
5598	11231	3590
5598	11231	9420
12088	11232	3942
12088	11232	1772
12088	11232	5922
12088	11232	7398
12088	11232	8944
12088	11232	591
12088	11232	5636
10478	11233	8038
10478	11233	9513
10478	11233	665
10478	11233	6724
10478	11233	531
10478	11233	6129
10478	11233	3861
11265	11234	4284
11265	11234	9256
11265	11234	5674
11265	11234	5142
5241	11235	9483
5241	11235	2866
5241	11235	4469
5241	11235	2098
5241	11235	3616
5241	11235	7676
5241	11235	5549
6486	11236	6859
6486	11236	5942
6486	11236	4679
6486	11236	5960
9984	11237	1979
9984	11237	4060
9984	11237	919
9984	11237	8376
9984	11237	9721
9984	11237	5645
9984	11237	1735
9984	11237	8933
9984	11237	4436
2589	11238	7409
2589	11238	3285
12419	11239	5683
12419	11239	6418
12419	11239	5183
12419	11239	8270
12419	11239	353
11993	11240	7190
11993	11240	8832
11993	11240	421
11993	11240	2920
11993	11240	6228
11993	11240	207
11993	11240	3696
4110	11241	2394
4110	11241	1145
18828	11242	7404
5580	11243	7109
5580	11243	5669
5580	11243	7355
5580	11243	5504
11419	11244	7969
11419	11244	4665
11419	11244	217
2723	11245	775
2723	11245	9258
2723	11245	2450
2723	11245	969
2723	11245	157
2723	11245	9212
2723	11245	5607
2723	11245	4413
6654	11246	5937
6654	11246	2055
6654	11246	9510
14804	11247	5802
14804	11247	8062
14804	11247	2587
7110	11248	1633
7110	11248	7152
3128	11249	4891
3128	11249	6091
3128	11249	9955
18929	11250	6867
18929	11250	1382
18929	11250	8457
18929	11250	7726
18929	11250	9955
18929	11250	4598
18929	11250	224
18929	11250	3017
18929	11250	3469
3633	11251	6984
3633	11251	4657
3633	11251	2806
3633	11251	6403
6537	11252	5936
6537	11252	6000
6537	11252	6771
6537	11252	2558
6537	11252	2834
6537	11252	7598
2132	11253	2883
2132	11253	2927
2132	11253	4799
2132	11253	6804
2132	11253	3670
2132	11253	827
2132	11253	6474
2132	11253	5400
2132	11253	3827
1195	11254	1966
1195	11254	1411
1195	11254	6035
1195	11254	630
1195	11254	665
1195	11254	7742
1195	11254	3377
1195	11254	1175
9687	11255	3687
18172	11256	485
18172	11256	3492
18172	11256	6968
16755	11257	9946
16755	11257	1658
16755	11257	9161
16755	11257	4201
10750	11258	219
10750	11258	3055
4247	11259	5018
4247	11259	6569
4247	11259	1310
4247	11259	3967
4247	11259	1913
4247	11259	3384
4247	11259	4637
4247	11259	2468
13336	11260	2043
13336	11260	8464
13336	11260	5154
13336	11260	6166
13336	11260	3642
13336	11260	9345
11825	11261	9448
11825	11261	3270
11825	11261	124
11825	11261	3218
11370	11262	2353
11370	11262	2515
11370	11262	3945
11370	11262	6656
11370	11262	2498
11370	11262	213
19114	11263	5470
19114	11263	8547
19114	11263	3106
19114	11263	6277
19114	11263	8470
330	11264	6300
330	11264	1442
330	11264	1927
330	11264	9794
330	11264	4484
330	11264	1402
6756	11265	7984
6756	11265	5198
6756	11265	4640
1832	11266	411
1832	11266	6982
1832	11266	6070
1832	11266	3122
1832	11266	2096
1832	11266	2897
1832	11266	3631
10065	11267	8410
10065	11267	5837
10065	11267	6052
1381	11268	1607
1381	11268	8087
10137	11269	8349
10137	11269	3971
10137	11269	5778
10137	11269	2333
10137	11269	4247
10137	11269	4441
5701	11270	9244
5701	11270	5990
5701	11270	9394
5701	11270	3439
5701	11270	6195
13168	11271	3044
14028	11272	3881
14028	11272	6539
14028	11272	4230
14028	11272	4450
14028	11272	3829
14028	11272	8305
14028	11272	5804
10393	11273	6196
10393	11273	205
10393	11273	2399
10393	11273	9837
10393	11273	1741
10393	11273	2456
10393	11273	8320
10393	11273	4846
18150	11274	2424
18150	11274	6012
18150	11274	2739
18150	11274	5022
18150	11274	7012
18150	11274	6658
18150	11274	456
18150	11274	2420
18150	11274	3661
10801	11275	2527
14743	11276	6447
14743	11276	461
12945	11277	8288
12945	11277	2842
12945	11277	9260
12945	11277	8506
12945	11277	6362
44	11278	5422
15897	11279	5320
15897	11279	254
15897	11279	7474
15897	11279	636
15897	11279	7187
15897	11279	4461
15897	11279	4851
15897	11279	773
18557	11280	204
18557	11280	3186
18557	11280	7261
17756	11281	7582
17756	11281	3418
17756	11281	3641
17756	11281	8549
17756	11281	489
17756	11281	4508
17756	11281	1210
17756	11281	2252
18106	11282	2217
18106	11282	3689
18106	11282	4850
18106	11282	4009
18106	11282	9828
18106	11282	3265
18106	11282	2439
12158	11283	355
12158	11283	9529
12158	11283	3011
12158	11283	4221
15378	11284	4983
15378	11284	5443
15378	11284	1933
15378	11284	9622
18899	11285	6859
18899	11285	5100
18899	11285	5021
18899	11285	5898
18899	11285	734
18899	11285	238
18899	11285	6164
18899	11285	9006
6641	11286	9852
6641	11286	5802
6641	11286	8598
6641	11286	7724
6641	11286	4872
6641	11286	2169
6641	11286	3169
16379	11287	3565
16379	11287	5158
16379	11287	4419
16379	11287	8260
16379	11287	205
16379	11287	6745
16379	11287	7537
16379	11287	1373
16379	11287	8379
12204	11288	330
12204	11288	5364
12204	11288	3157
12204	11288	1687
10502	11289	9053
10502	11289	5409
10502	11289	1614
10502	11289	7720
10514	11290	8595
14711	11291	988
14711	11291	9634
14711	11291	3261
14711	11291	5549
8956	11292	8565
8956	11292	7849
8956	11292	6564
8956	11292	9586
8956	11292	7821
8956	11292	9541
8956	11292	8319
8956	11292	6107
8956	11292	5490
12954	11293	2828
12954	11293	4510
794	11294	56
794	11294	2960
794	11294	5391
794	11294	7368
10377	11295	7963
10377	11295	1482
10377	11295	9903
10377	11295	9609
9822	11296	3474
9822	11296	4652
9822	11296	8616
9822	11296	693
9822	11296	8924
9822	11296	6576
7886	11297	9131
7886	11297	329
7886	11297	4092
7886	11297	1162
7886	11297	8781
7886	11297	5984
7886	11297	5681
18310	11298	6139
18310	11298	661
18310	11298	5197
3543	11299	5714
3543	11299	642
3543	11299	5720
3543	11299	1938
6199	11300	3870
6199	11300	3790
4586	11301	5448
4586	11301	3916
4586	11301	1675
4586	11301	5692
4586	11301	884
4586	11301	5818
4586	11301	2778
16994	11302	8308
16994	11302	6479
16994	11302	1771
16994	11302	1901
2763	11303	8772
2763	11303	3445
2763	11303	9408
2763	11303	1800
2763	11303	7278
2763	11303	4689
2763	11303	9280
2763	11303	9555
13968	11304	7193
13968	11304	6384
13968	11304	926
13968	11304	4523
4748	11305	5674
4748	11305	1124
4748	11305	7989
4748	11305	180
4748	11305	5606
4748	11305	8363
4748	11305	2336
4748	11305	5605
19409	11306	283
19409	11306	1056
11157	11307	7953
11157	11307	5339
11157	11307	4325
11157	11307	8706
11157	11307	9386
11157	11307	7580
11157	11307	3755
12180	11308	4389
12180	11308	5184
12180	11308	851
12180	11308	5911
12180	11308	6674
17407	11309	159
17407	11309	9063
17407	11309	1850
17407	11309	6796
17407	11309	6655
818	11310	6499
818	11310	1579
818	11310	2933
818	11310	7846
818	11310	2228
818	11310	5690
6350	11311	8612
6350	11311	2340
6350	11311	2244
6350	11311	5443
6350	11311	5425
6350	11311	3414
6350	11311	2505
18007	11312	9891
18007	11312	6090
18007	11312	4619
18007	11312	1492
18007	11312	7217
18007	11312	3483
18007	11312	5347
18007	11312	2582
18007	11312	9769
10421	11313	7307
10421	11313	8951
10421	11313	1008
10421	11313	8815
10421	11313	6028
10421	11313	9748
10421	11313	6441
15863	11314	6326
15863	11314	2470
15863	11314	252
15863	11314	9358
15863	11314	9877
15863	11314	5230
15863	11314	8535
14969	11315	4184
14969	11315	937
1367	11316	5049
1367	11316	4237
1367	11316	411
1367	11316	7880
1367	11316	2234
1367	11316	7931
15614	11317	1547
15614	11317	5917
15614	11317	8844
15614	11317	4590
11052	11318	6209
11052	11318	5596
11052	11318	8328
11052	11318	981
11052	11318	395
11052	11318	1618
11052	11318	6993
11052	11318	4221
11052	11318	7356
17805	11319	1467
17805	11319	2703
17805	11319	278
17805	11319	1582
15582	11320	9049
15582	11320	6846
15582	11320	6149
15582	11320	8890
15582	11320	9870
15582	11320	7315
15582	11320	1025
19096	11321	3988
19096	11321	6792
19096	11321	1095
19096	11321	8817
19096	11321	585
19096	11321	467
19096	11321	7247
19096	11321	7078
19096	11321	9545
16869	11322	4316
16869	11322	5291
12853	11323	5969
12853	11323	1586
12853	11323	5566
12853	11323	9828
12853	11323	5356
12853	11323	4617
3726	11324	5955
3726	11324	382
3726	11324	3316
3726	11324	8487
3726	11324	9680
3726	11324	2973
3726	11324	204
12343	11325	8931
17516	11326	9170
17516	11326	4646
17516	11326	3165
17516	11326	6406
17516	11326	4865
17516	11326	6404
17516	11326	8161
17516	11326	5813
17570	11327	6646
17570	11327	5041
17570	11327	483
17570	11327	5685
17570	11327	2730
17570	11327	2773
17570	11327	3671
17570	11327	1148
15106	11328	4340
15106	11328	446
15106	11328	7247
11827	11329	4783
19648	11330	3795
13049	11331	8424
13049	11331	5151
13049	11331	3629
13049	11331	7124
13049	11331	4816
13049	11331	1939
13049	11331	3964
8606	11332	5136
8606	11332	8249
8606	11332	9705
8606	11332	6677
8606	11332	4073
8606	11332	24
16893	11333	8018
16893	11333	7075
16893	11333	7202
16893	11333	6605
16893	11333	7150
17336	11334	5229
17336	11334	3304
17336	11334	5672
17336	11334	6795
1736	11335	8064
1736	11335	4978
1736	11335	7883
1736	11335	9674
1736	11335	8136
1736	11335	6847
7992	11336	2664
7992	11336	7762
7992	11336	188
7992	11336	1369
16327	11337	9031
14189	11338	9149
14189	11338	5084
6440	11339	7961
6440	11339	9236
6440	11339	6051
6440	11339	3450
6440	11339	9791
2318	11340	9322
2318	11340	9533
2318	11340	9899
2318	11340	5447
2318	11340	8735
2318	11340	8891
2318	11340	3418
2318	11340	7038
2318	11340	2524
3518	11341	3658
3518	11341	690
3518	11341	5355
3518	11341	4608
3518	11341	4520
3518	11341	2555
3518	11341	2283
15458	11342	2325
15458	11342	3249
15458	11342	4081
15458	11342	4857
15458	11342	5285
15458	11342	8363
15458	11342	2561
15458	11342	5270
15458	11342	5470
155	11343	4007
155	11343	7389
155	11343	483
155	11343	4018
12684	11344	2084
13881	11345	2624
13881	11345	9887
13881	11345	6254
13881	11345	8434
13881	11345	5780
13881	11345	1800
11613	11346	2096
11613	11346	6061
11613	11346	8156
11613	11346	2455
11613	11346	4341
11613	11346	2608
11613	11346	1479
11613	11346	1726
3225	11347	6768
3225	11347	687
3225	11347	4970
3225	11347	3802
3225	11347	8293
3225	11347	3532
3225	11347	2853
3225	11347	6501
3225	11347	3168
15017	11348	2900
15017	11348	5435
15017	11348	9073
15017	11348	6237
15017	11348	7109
15017	11348	6076
15017	11348	5553
18709	11349	2440
18709	11349	8962
18709	11349	9724
18709	11349	6301
18709	11349	4417
18709	11349	400
18709	11349	7608
18709	11349	2880
3903	11350	309
3903	11350	7166
3903	11350	6090
3903	11350	7429
8060	11351	4162
8060	11351	9804
8060	11351	9367
8060	11351	6778
8060	11351	6755
8723	11352	7404
8723	11352	6524
8723	11352	2561
8723	11352	6885
8723	11352	3216
1290	11353	4675
1290	11353	9027
1290	11353	8193
1290	11353	2723
1290	11353	4935
3378	11354	6050
3378	11354	7607
3378	11354	5552
16224	11355	7838
16224	11355	1901
16224	11355	4822
16224	11355	4796
16224	11355	5531
16224	11355	8334
16224	11355	2652
16224	11355	1283
16224	11355	555
14461	11356	4382
14461	11356	8778
14461	11356	7397
14461	11356	8045
14461	11356	9748
3295	11357	2891
3295	11357	6853
3295	11357	4782
3295	11357	2145
3295	11357	6241
3295	11357	5020
3295	11357	6052
3424	11358	4979
3424	11358	8340
3424	11358	9217
3424	11358	732
3424	11358	2268
3424	11358	612
3424	11358	623
3424	11358	9391
8343	11359	1605
8343	11359	7495
8343	11359	5697
8343	11359	918
1072	11360	8932
16298	11361	7113
16298	11361	6609
16298	11361	3552
16298	11361	1226
6299	11362	7218
6299	11362	6268
6299	11362	5341
6299	11362	8259
6299	11362	1686
6299	11362	6794
6299	11362	3754
12730	11363	9708
12730	11363	4256
12730	11363	8710
12730	11363	3547
12730	11363	750
12730	11363	3085
12730	11363	5618
12730	11363	6580
12730	11363	5015
6546	11364	6791
6546	11364	5348
6546	11364	696
6546	11364	6909
6546	11364	765
10041	11365	2828
10041	11365	4201
10041	11365	4729
10041	11365	1439
16035	11366	9937
16035	11366	5875
16035	11366	1613
13921	11367	8590
13921	11367	8348
13921	11367	6733
13921	11367	4375
14403	11368	778
14403	11368	9653
14403	11368	1218
6896	11369	9528
2280	11370	8101
2280	11370	5147
6989	11371	7397
6989	11371	8104
6989	11371	7620
6989	11371	7932
6989	11371	5117
6989	11371	615
6989	11371	4825
6989	11371	9782
18617	11372	449
18617	11372	670
18617	11372	352
18617	11372	5239
18617	11372	9311
18617	11372	496
18617	11372	1702
18617	11372	2271
18617	11372	2845
15922	11373	4294
15922	11373	9181
15922	11373	7276
15922	11373	3384
15922	11373	9501
15922	11373	6420
15922	11373	2381
15922	11373	5988
10597	11374	2006
10597	11374	7924
10597	11374	9926
10597	11374	4478
10597	11374	8729
10597	11374	5978
10597	11374	4873
10597	11374	7098
10597	11374	5357
9716	11375	5029
9716	11375	2997
9716	11375	4315
9716	11375	6314
9716	11375	1150
9716	11375	3822
7494	11376	1391
7494	11376	9335
7494	11376	1592
7494	11376	2527
7494	11376	6356
7494	11376	9172
7494	11376	2741
15538	11377	8785
15538	11377	7208
15538	11377	7711
15538	11377	3418
15538	11377	7431
14544	11378	5842
14544	11378	4038
14544	11378	6627
14544	11378	6123
14544	11378	4447
14544	11378	9143
14544	11378	8779
17916	11379	3452
17916	11379	8839
17916	11379	2477
17916	11379	2694
15945	11380	4642
15945	11380	3772
797	11381	3381
797	11381	1869
797	11381	6877
797	11381	4053
797	11381	9605
797	11381	5573
8824	11382	6669
8824	11382	7466
8824	11382	4885
8824	11382	6290
8824	11382	7664
8824	11382	8206
8824	11382	460
7681	11383	6364
7681	11383	7206
7681	11383	1848
7681	11383	1380
7681	11383	9867
7681	11383	1833
17002	11384	3438
17002	11384	6131
7588	11385	1910
7588	11385	7060
7588	11385	4089
7588	11385	3158
727	11386	7174
727	11386	9482
2628	11387	9815
2628	11387	4218
2628	11387	8002
6816	11388	7019
6816	11388	3016
6816	11388	2651
11618	11389	6172
11618	11389	6550
11618	11389	669
11618	11389	387
11618	11389	7345
14318	11390	411
14318	11390	6675
14318	11390	5042
14318	11390	6157
14318	11390	6869
14318	11390	6140
831	11391	4905
831	11391	2252
831	11391	4846
831	11391	7485
9658	11392	1988
9658	11392	733
9658	11392	2010
9658	11392	5788
3888	11393	1116
3888	11393	4613
3888	11393	5667
3888	11393	1221
3888	11393	1441
12574	11394	1519
12574	11394	4338
12574	11394	3097
12574	11394	8637
12574	11394	8724
12574	11394	1237
12574	11394	7697
12574	11394	6455
12574	11394	4553
18331	11395	9106
18331	11395	8297
18331	11395	9654
18331	11395	6834
18331	11395	9831
18331	11395	4736
18331	11395	6614
10501	11396	5897
10501	11396	3727
10501	11396	2359
10501	11396	402
10501	11396	7751
10501	11396	6078
10501	11396	188
10501	11396	8893
10501	11396	5730
5125	11397	915
5125	11397	2804
5125	11397	7161
5125	11397	2779
5125	11397	2513
5125	11397	1722
5125	11397	2268
5125	11397	6420
8341	11398	6882
8341	11398	2252
8341	11398	3802
8341	11398	4321
8341	11398	544
8341	11398	1243
8341	11398	8239
10799	11399	4222
10799	11399	438
5411	11400	5375
5411	11400	6683
5411	11400	8083
669	11401	8316
669	11401	2230
669	11401	2570
669	11401	316
669	11401	7518
669	11401	6208
669	11401	1065
669	11401	4714
669	11401	6373
12790	11402	7409
12790	11402	86
12790	11402	3566
12790	11402	5827
12790	11402	5531
12790	11402	6562
12790	11402	3000
12790	11402	1233
12790	11402	9940
12295	11403	6577
12295	11403	5183
12295	11403	9130
12295	11403	9344
13505	11404	2245
13505	11404	4965
13505	11404	8919
13505	11404	2212
13505	11404	8257
13505	11404	4612
13505	11404	8527
13505	11404	8240
13505	11404	699
14550	11405	224
19135	11406	6320
19135	11406	7424
19135	11406	216
19135	11406	6635
19135	11406	2884
19135	11406	4615
19135	11406	4057
19135	11406	629
17736	11407	717
17736	11407	1750
17736	11407	8553
17736	11407	191
17736	11407	1541
15720	11408	6424
15720	11408	6126
15720	11408	5492
15720	11408	1905
11923	11409	8545
4539	11410	817
18739	11411	7317
18739	11411	3384
19051	11412	5883
19051	11412	185
19051	11412	2502
19051	11412	1479
19051	11412	8050
19051	11412	3428
19051	11412	3916
2993	11413	826
2993	11413	9049
2993	11413	6129
2993	11413	4971
2993	11413	9996
2993	11413	9038
2993	11413	2799
2993	11413	857
2993	11413	6294
15545	11414	8582
15545	11414	9716
15545	11414	2510
11891	11415	632
11891	11415	6947
11891	11415	3673
11891	11415	6272
11891	11415	7590
777	11416	3372
777	11416	5247
2512	11417	693
2512	11417	5374
2512	11417	9860
16235	11418	5425
16235	11418	6539
16235	11418	3051
16235	11418	2767
16235	11418	8120
16235	11418	1028
16235	11418	5688
16235	11418	4871
16235	11418	2843
8816	11419	5689
8816	11419	6085
8816	11419	6781
1935	11420	2101
1935	11420	8188
1935	11420	4361
1935	11420	5790
1935	11420	4753
1935	11420	830
1935	11420	1218
1935	11420	1374
1935	11420	4865
13810	11421	4319
13810	11421	9705
13810	11421	7763
13810	11421	2067
8334	11422	9317
10214	11423	1925
10214	11423	6792
10214	11423	7694
10214	11423	7203
10214	11423	1729
10214	11423	9463
7562	11424	4881
7562	11424	2902
7562	11424	1241
7562	11424	1114
7562	11424	6007
7562	11424	4249
7562	11424	5537
7562	11424	3959
7562	11424	7408
10202	11425	7659
10202	11425	3478
10202	11425	8820
10202	11425	902
10202	11425	2838
10202	11425	7992
10202	11425	2728
10202	11425	1099
14211	11426	4712
14211	11426	4457
14211	11426	7270
14211	11426	9422
14211	11426	6966
14211	11426	5680
14211	11426	8982
14211	11426	1745
14211	11426	2463
10599	11427	1038
10599	11427	4548
10599	11427	4996
10599	11427	9242
10599	11427	8387
5687	11428	4708
5687	11428	4219
5687	11428	382
5687	11428	6298
5687	11428	9056
5687	11428	7165
8979	11429	9806
8979	11429	270
8979	11429	9991
8979	11429	3696
8979	11429	4532
8979	11429	3186
8979	11429	4926
8979	11429	9952
8979	11429	7855
16473	11430	7600
16473	11430	5646
16473	11430	4640
16473	11430	9254
16473	11430	5448
16473	11430	9312
16473	11430	3412
14214	11431	9189
14214	11431	9122
14214	11431	7530
14214	11431	3747
14214	11431	3242
14618	11432	432
14618	11432	5984
10475	11433	4297
15416	11434	4815
15416	11434	2298
15416	11434	5396
15416	11434	8117
15416	11434	492
15416	11434	8309
15416	11434	6917
19146	11435	7876
19146	11435	6544
6144	11436	8911
6144	11436	6373
6144	11436	5178
6144	11436	7727
6144	11436	5191
6144	11436	8894
6144	11436	6047
6144	11436	5170
4173	11437	1660
4173	11437	5633
4173	11437	8562
4173	11437	2045
9278	11438	3034
9278	11438	8211
9278	11438	9157
9278	11438	5687
9161	11439	3966
9161	11439	9462
9161	11439	4910
9161	11439	1243
9161	11439	5174
7471	11440	6666
7471	11440	2787
7471	11440	8460
7471	11440	6231
7471	11440	4031
7471	11440	2609
7471	11440	9733
7471	11440	4297
16525	11441	5346
16525	11441	1980
16525	11441	1687
16525	11441	3464
16525	11441	889
16525	11441	5937
17447	11442	4543
17447	11442	1947
17447	11442	7433
17447	11442	8291
17447	11442	6223
5996	11443	9234
5996	11443	9878
5996	11443	2784
5996	11443	8368
5996	11443	9353
10580	11444	4013
10580	11444	855
10580	11444	4673
10580	11444	7130
10580	11444	7356
10580	11444	9271
7644	11445	8582
7644	11445	5053
7644	11445	7024
7644	11445	24
7644	11445	4084
7644	11445	4647
7644	11445	4667
7644	11445	8426
18562	11446	2082
18562	11446	861
18562	11446	9784
18562	11446	3015
18562	11446	3954
18562	11446	6649
18562	11446	5401
18562	11446	995
2038	11447	396
2038	11447	6468
2038	11447	3918
2038	11447	3742
1953	11448	5341
1953	11448	5692
1953	11448	7748
1953	11448	2916
1953	11448	8297
1953	11448	4236
10461	11449	6250
13291	11450	1708
10899	11451	6426
10899	11451	6212
10899	11451	2685
10899	11451	6890
10899	11451	609
10899	11451	2133
10899	11451	9369
10899	11451	2603
10899	11451	1599
15695	11452	4493
15695	11452	6749
15695	11452	9368
15695	11452	1650
15695	11452	2488
15695	11452	2751
10871	11453	5868
10871	11453	6533
10871	11453	115
10871	11453	4368
10871	11453	6535
10871	11453	1440
10871	11453	3813
16610	11454	4506
12309	11455	4229
12309	11455	4294
12309	11455	8387
12309	11455	797
12309	11455	6104
12309	11455	2254
13241	11456	2586
13241	11456	7736
13241	11456	4474
13241	11456	4704
13241	11456	2140
13241	11456	147
13241	11456	5363
13241	11456	842
13241	11456	3299
3372	11457	5940
3372	11457	1785
3372	11457	2351
3372	11457	4813
3372	11457	4781
5032	11458	4079
5032	11458	3762
5032	11458	7708
5032	11458	1466
5032	11458	4255
5032	11458	2661
12640	11459	776
12640	11459	3602
12640	11459	3371
12640	11459	7576
12640	11459	7240
12640	11459	5583
12640	11459	4873
17903	11460	5170
17903	11460	2705
17903	11460	8657
17903	11460	8941
17903	11460	4514
17903	11460	7637
17903	11460	3852
17903	11460	8931
4604	11461	486
4604	11461	904
4604	11461	9547
4604	11461	5447
4604	11461	4727
4604	11461	3380
4604	11461	8912
4604	11461	6531
10943	11462	1854
10943	11462	1309
10943	11462	4932
10943	11462	3158
10943	11462	2542
10943	11462	4451
10943	11462	7210
13513	11463	1339
13513	11463	7867
13513	11463	5752
13513	11463	803
13513	11463	4345
6457	11464	9749
6457	11464	5312
6457	11464	2952
6457	11464	585
6457	11464	5034
6457	11464	8520
6457	11464	389
6457	11464	9000
6457	11464	2155
42	11465	6799
42	11465	5408
42	11465	9707
2218	11466	3821
2218	11466	8801
2218	11466	6549
2218	11466	2265
1568	11467	8398
1568	11467	6325
1568	11467	3165
1568	11467	574
1568	11467	6823
4460	11468	5391
4460	11468	4897
4460	11468	7005
4460	11468	6239
5575	11469	4370
5575	11469	8538
5575	11469	4414
5575	11469	1023
5575	11469	7488
5575	11469	4435
5575	11469	2410
12982	11470	279
12982	11470	6832
12982	11470	7037
12982	11470	3893
18765	11471	7136
18765	11471	4436
18765	11471	8629
18765	11471	2609
18765	11471	9587
8044	11472	5279
8044	11472	2738
8044	11472	7538
8044	11472	7644
8044	11472	8192
8044	11472	8206
15691	11473	2674
15691	11473	4450
15691	11473	4277
15691	11473	5959
11091	11474	9567
11091	11474	2813
11091	11474	8730
11091	11474	3612
11091	11474	8567
11091	11474	637
17685	11475	6688
17685	11475	7907
17685	11475	8913
17685	11475	6471
4858	11476	7975
4858	11476	4728
4858	11476	2194
4858	11476	2387
4858	11476	3091
4858	11476	7192
4858	11476	7254
4858	11476	8416
14517	11477	7568
14517	11477	2719
14517	11477	7342
14517	11477	9669
19483	11478	6797
19483	11478	7134
19483	11478	3204
19483	11478	9914
19483	11478	5519
19483	11478	7951
19483	11478	4934
19483	11478	5960
19483	11478	3625
2385	11479	7672
2385	11479	6869
2385	11479	8139
2385	11479	7082
2385	11479	8079
2385	11479	4738
2385	11479	2868
5563	11480	9887
9639	11481	6423
9639	11481	2019
9639	11481	3369
9639	11481	9063
9639	11481	5406
9639	11481	8380
9639	11481	4418
9639	11481	2620
9639	11481	9339
4413	11482	4988
4413	11482	2688
4413	11482	1718
539	11483	2446
539	11483	7498
539	11483	6748
539	11483	6854
539	11483	2492
539	11483	5698
16633	11484	5674
1942	11485	504
1942	11485	2100
1942	11485	7944
1942	11485	2490
1942	11485	7907
1942	11485	9338
1942	11485	749
15203	11486	2835
15203	11486	1366
15203	11486	2251
15203	11486	3561
15203	11486	7881
14859	11487	9666
14859	11487	1619
14859	11487	6919
14859	11487	241
14859	11487	9044
14859	11487	230
14859	11487	5662
14859	11487	7393
14859	11487	6653
16036	11488	8788
13336	11489	4098
13336	11489	6301
13336	11489	1268
13336	11489	1372
13336	11489	2028
13336	11489	3011
13336	11489	1190
13701	11490	749
13701	11490	8482
13701	11490	106
13701	11490	8666
13701	11490	9553
13701	11490	5561
13701	11490	3577
13701	11490	8810
155	11491	8263
155	11491	6404
155	11491	895
155	11491	4514
155	11491	4444
10385	11492	3775
10385	11492	731
10385	11492	1037
10385	11492	9114
10385	11492	2951
10385	11492	6255
10385	11492	2568
10385	11492	1837
200	11493	1374
11775	11494	5838
11775	11494	8101
11775	11494	1345
4151	11495	2358
10617	11496	7069
10617	11496	3582
10617	11496	9050
10617	11496	9005
757	11497	6266
757	11497	292
757	11497	6008
757	11497	9978
757	11497	267
757	11497	9429
757	11497	1051
17406	11498	2610
17406	11498	2814
17406	11498	3068
17406	11498	4240
6320	11499	544
6320	11499	4575
1166	11500	7936
14728	11501	9150
14728	11501	545
6307	11502	9344
6307	11502	889
6307	11502	5548
6307	11502	6744
6307	11502	3406
6307	11502	6715
6307	11502	8123
6307	11502	8564
6307	11502	8328
18238	11503	961
3010	11504	4658
3010	11504	8236
3010	11504	3138
3010	11504	7586
3010	11504	1113
3010	11504	6684
3010	11504	1616
3010	11504	2499
3010	11504	931
18517	11505	8377
18517	11505	4846
18517	11505	4437
18517	11505	842
11000	11506	9502
11000	11506	4416
11000	11506	5180
11000	11506	1416
11000	11506	46
5090	11507	3608
5090	11507	5450
5090	11507	3783
5090	11507	2594
5090	11507	3164
5090	11507	6473
7056	11508	8820
7056	11508	575
7056	11508	6094
7056	11508	8762
17615	11509	1352
17615	11509	9070
17615	11509	3160
13884	11510	5570
13884	11510	5753
13884	11510	5516
13884	11510	5570
13884	11510	557
13884	11510	4028
13884	11510	7623
13884	11510	6885
9003	11511	7380
9003	11511	1476
9003	11511	1504
9003	11511	968
9003	11511	1578
9003	11511	6354
9003	11511	823
9003	11511	9189
9516	11512	9146
9516	11512	268
9516	11512	5509
9516	11512	3154
9516	11512	1654
9516	11512	1310
9516	11512	4890
9516	11512	5482
9516	11512	7421
17996	11513	6145
10665	11514	90
18472	11515	6005
18316	11516	7503
18316	11516	8308
18316	11516	2414
18316	11516	8785
18316	11516	239
18316	11516	8832
18316	11516	3185
18316	11516	2589
18316	11516	308
796	11517	9634
796	11517	7399
796	11517	4648
796	11517	4796
796	11517	4294
796	11517	2595
796	11517	4691
6949	11518	6283
6949	11518	2631
6949	11518	8649
6949	11518	5135
6949	11518	733
6949	11518	9354
17975	11519	4626
17975	11519	1214
17975	11519	7611
17975	11519	1720
17975	11519	8108
17975	11519	5214
112	11520	3730
112	11520	5634
112	11520	8976
112	11520	1335
112	11520	2632
112	11520	237
467	11521	4878
467	11521	3722
467	11521	4340
467	11521	2694
15815	11522	7964
15815	11522	7901
7070	11523	4303
13868	11524	8361
11962	11525	4814
11962	11525	8343
11962	11525	9233
11962	11525	1602
11962	11525	8943
11962	11525	2818
1438	11526	4254
1438	11526	9239
1438	11526	8073
1438	11526	5490
1438	11526	491
1438	11526	9934
1438	11526	9831
1438	11526	7323
11330	11527	6701
11330	11527	4111
11330	11527	3944
1116	11528	8997
1116	11528	3815
3774	11529	6052
3774	11529	9796
3774	11529	9940
3774	11529	5989
3774	11529	4270
3774	11529	2927
19253	11530	5270
19253	11530	3851
19253	11530	7969
19253	11530	8964
19253	11530	3399
19253	11530	5201
19253	11530	4664
1432	11531	6702
1432	11531	9223
1432	11531	8856
1432	11531	2475
1432	11531	1561
1432	11531	1409
1432	11531	2207
1432	11531	2438
1432	11531	4495
6916	11532	6235
1798	11533	1615
1798	11533	4207
1798	11533	9000
1798	11533	1008
1798	11533	6923
16966	11534	3510
11895	11535	6354
11895	11535	5674
3816	11536	2807
8844	11537	2739
8844	11537	2594
8844	11537	6307
8844	11537	7227
8844	11537	7998
8844	11537	6987
8844	11537	6967
8844	11537	7455
8844	11537	6924
5193	11538	4505
5193	11538	4466
5193	11538	5873
5193	11538	1734
8943	11539	8217
8943	11539	694
17383	11540	199
17383	11540	7723
17383	11540	2400
1962	11541	5100
1962	11541	2820
1962	11541	9058
1962	11541	8987
1962	11541	4019
1962	11541	5263
1962	11541	8749
1962	11541	7882
1962	11541	8924
721	11542	8764
721	11542	5986
721	11542	9292
721	11542	2145
721	11542	6442
721	11542	8281
721	11542	6809
721	11542	7954
3943	11543	9768
3943	11543	6871
3943	11543	1556
3943	11543	1559
16965	11544	3129
16965	11544	6081
16965	11544	1454
16965	11544	8955
16965	11544	5469
4553	11545	8071
4553	11545	7080
4553	11545	6094
4553	11545	3549
4553	11545	4498
12112	11546	4539
12112	11546	9828
12112	11546	6819
12112	11546	88
12112	11546	4133
19202	11547	1877
19202	11547	8431
19202	11547	3554
19294	11548	2611
19294	11548	36
19294	11548	2911
19294	11548	6279
19294	11548	7642
8921	11549	2733
8921	11549	4246
8921	11549	5748
8921	11549	2222
8921	11549	1374
9854	11550	4574
9854	11550	3886
9854	11550	5375
9854	11550	8553
9854	11550	8750
9854	11550	5734
9854	11550	938
9854	11550	852
9854	11550	6052
594	11551	820
594	11551	2472
594	11551	5358
594	11551	7120
594	11551	8998
5767	11552	6805
5767	11552	3699
5767	11552	2262
5767	11552	1945
5767	11552	282
12667	11553	6630
12667	11553	96
12667	11553	3569
12667	11553	9642
12667	11553	2611
3217	11554	4492
2592	11555	6850
2592	11555	9031
2592	11555	223
2592	11555	1590
2592	11555	5646
2592	11555	1623
2592	11555	6833
2592	11555	9724
2592	11555	4286
13794	11556	8506
13794	11556	260
13794	11556	1915
13794	11556	4293
13794	11556	5758
13794	11556	3702
13794	11556	9937
13794	11556	4101
13794	11556	298
3840	11557	3639
3840	11557	6731
3840	11557	1111
3840	11557	4821
3840	11557	5834
3840	11557	1820
7468	11558	412
8226	11559	8038
8226	11559	3221
5432	11560	9045
5432	11560	410
5432	11560	1818
5432	11560	1835
5432	11560	8758
5432	11560	9964
5432	11560	3761
5432	11560	4311
9444	11561	8835
9444	11561	353
9444	11561	3720
9444	11561	5207
9444	11561	6289
9444	11561	9030
9444	11561	9355
9444	11561	1108
5885	11562	610
5885	11562	294
5885	11562	4060
5885	11562	384
5885	11562	9326
5885	11562	9619
5885	11562	1228
5885	11562	5033
5885	11562	3544
19663	11563	5165
19663	11563	3781
19663	11563	6228
19663	11563	9215
19648	11564	4194
19648	11564	9354
19648	11564	6832
19648	11564	8984
19648	11564	6840
3744	11565	2112
3744	11565	9797
3744	11565	4812
3744	11565	2868
3744	11565	1233
3744	11565	3333
3744	11565	3134
3744	11565	271
3744	11565	2539
3784	11566	571
3784	11566	4099
3784	11566	8237
3784	11566	9283
3784	11566	486
3784	11566	3866
3784	11566	9206
4146	11567	1169
4146	11567	6923
4146	11567	8391
4146	11567	9248
4146	11567	1658
4146	11567	2820
6782	11568	802
6782	11568	2331
5634	11569	3099
5634	11569	2900
5634	11569	2756
5634	11569	4818
3481	11570	8934
3481	11570	89
3481	11570	7537
3481	11570	1291
3481	11570	6300
3481	11570	7060
3481	11570	6978
3481	11570	7184
3481	11570	2207
10611	11571	3648
10611	11571	4625
10611	11571	6023
10611	11571	206
10611	11571	4556
9288	11572	7552
9288	11572	4507
9288	11572	1037
9288	11572	952
9288	11572	956
9288	11572	5349
9288	11572	6797
9288	11572	8468
9288	11572	1361
11969	11573	1380
11969	11573	8508
11969	11573	9924
11969	11573	578
16260	11574	1981
16260	11574	5560
16260	11574	9726
16260	11574	1068
15728	11575	4003
15728	11575	260
15728	11575	9323
15728	11575	6500
15728	11575	1624
15728	11575	6636
15728	11575	5237
15728	11575	1201
3750	11576	3587
3750	11576	257
3750	11576	793
3750	11576	8385
3750	11576	9188
3750	11576	8615
3750	11576	3701
6045	11577	3724
6045	11577	6938
4347	11578	6897
4347	11578	5960
4347	11578	240
4347	11578	9890
1364	11579	1152
1364	11579	1604
10609	11580	8327
10609	11580	1559
10609	11580	9693
10609	11580	2410
10609	11580	669
10609	11580	6662
10609	11580	2898
10609	11580	3179
10609	11580	2167
10047	11581	6265
10047	11581	6462
10047	11581	4669
10047	11581	3173
10047	11581	288
3692	11582	342
3692	11582	3933
1187	11583	3215
1187	11583	1976
1187	11583	4821
1187	11583	404
1187	11583	1064
1187	11583	3473
1187	11583	4537
1187	11583	8185
16945	11584	318
16945	11584	4470
16945	11584	8715
9309	11585	3493
10936	11586	1077
10936	11586	5389
10936	11586	4662
10936	11586	9666
10936	11586	7001
10936	11586	6906
10936	11586	6323
13281	11587	7300
13281	11587	4436
13281	11587	2238
13281	11587	9212
13281	11587	5642
13281	11587	1198
4549	11588	4415
4549	11588	2274
4549	11588	5084
4549	11588	1931
16506	11589	4893
16506	11589	5323
16506	11589	4556
16506	11589	1160
16506	11589	3190
16506	11589	2523
16506	11589	1579
16506	11589	2062
16506	11589	5995
820	11590	4490
820	11590	4565
820	11590	6245
820	11590	4673
820	11590	1579
13802	11591	6659
13802	11591	2667
13802	11591	3290
13802	11591	8679
13802	11591	8911
13802	11591	4472
14978	11592	2779
14978	11592	7455
14978	11592	6225
1795	11593	464
1795	11593	8112
9541	11594	4619
9541	11594	3095
9541	11594	3296
9541	11594	4038
9541	11594	6910
9541	11594	5257
9541	11594	1264
9541	11594	2029
16507	11595	9151
16507	11595	6224
16507	11595	9826
16507	11595	1835
16507	11595	9106
7448	11596	7022
7448	11596	8067
7448	11596	6466
7448	11596	9124
7448	11596	7201
7448	11596	9757
10272	11597	148
10272	11597	1983
3617	11598	6872
3617	11598	5057
3617	11598	3534
3617	11598	5901
3617	11598	9156
3617	11598	1614
3617	11598	8943
3617	11598	7343
14200	11599	2236
4765	11600	8753
4765	11600	5543
4765	11600	3818
4765	11600	9269
5605	11601	3358
5605	11601	2119
5605	11601	4108
5605	11601	5709
5605	11601	7205
5605	11601	8551
5605	11601	7065
5605	11601	5431
9838	11602	654
9838	11602	1379
1294	11603	3450
1294	11603	913
1294	11603	1163
10541	11604	6721
10541	11604	4321
10541	11604	3874
10541	11604	6057
10541	11604	202
10541	11604	4223
10541	11604	1145
5047	11605	3171
5047	11605	4115
10056	11606	8059
10056	11606	1800
10056	11606	2691
10056	11606	3449
10056	11606	3792
10056	11606	8397
17198	11607	1352
4397	11608	3553
4397	11608	7765
4397	11608	2530
4397	11608	2696
4397	11608	9663
2924	11609	9983
2924	11609	861
2924	11609	3676
2924	11609	3622
5386	11610	2910
5386	11610	1406
5386	11610	1947
5386	11610	1559
5386	11610	2627
5386	11610	2844
5386	11610	44
5386	11610	6077
5386	11610	3968
7901	11611	7724
7901	11611	5171
7901	11611	9314
7901	11611	4039
7901	11611	2235
7901	11611	7337
18567	11612	8995
18567	11612	8243
18567	11612	6547
18567	11612	4344
16623	11613	2262
16623	11613	455
16623	11613	5954
16623	11613	1331
16623	11613	8652
1772	11614	4526
1772	11614	2350
1772	11614	9068
14621	11615	5597
10172	11616	9628
10172	11616	2066
10172	11616	8085
10172	11616	5707
10172	11616	3287
18033	11617	2083
18033	11617	2015
18033	11617	2893
18033	11617	5777
18033	11617	8393
18033	11617	8137
18033	11617	6485
4644	11618	421
4644	11618	8784
4644	11618	6863
4644	11618	7921
4644	11618	8848
4644	11618	9166
4644	11618	9808
4644	11618	3861
13506	11619	3994
13506	11619	416
13800	11620	9222
13800	11620	3061
13800	11620	9407
13800	11620	8148
12138	11621	8775
12138	11621	9273
12138	11621	6833
12138	11621	403
12138	11621	9886
7759	11622	6010
7759	11622	1285
7759	11622	4244
7759	11622	358
19528	11623	6033
19528	11623	4365
19528	11623	663
19528	11623	8035
19528	11623	1721
19528	11623	3069
19528	11623	7380
19528	11623	5430
62	11624	9916
62	11624	2638
62	11624	7525
15347	11625	5970
668	11626	3473
668	11626	6692
668	11626	4143
668	11626	7317
668	11626	2714
668	11626	2871
668	11626	2777
5384	11627	6852
5384	11627	8022
5384	11627	821
5384	11627	8926
5384	11627	9572
1628	11628	91
8467	11629	5756
8467	11629	5851
8467	11629	484
5747	11630	7901
5747	11630	6001
5747	11630	6485
10821	11631	429
10821	11631	7089
10821	11631	1331
10821	11631	667
10821	11631	1413
10821	11631	225
12150	11632	4703
12043	11633	4192
1354	11634	6087
1354	11634	9986
1354	11634	3046
1354	11634	8718
18769	11635	8275
18769	11635	2832
18769	11635	7794
18769	11635	8416
18769	11635	1649
18769	11635	8518
5419	11636	3386
5419	11636	3404
5419	11636	411
5419	11636	5988
5419	11636	463
5419	11636	7832
5419	11636	4089
5419	11636	381
5419	11636	1046
17679	11637	1336
17679	11637	483
17679	11637	1010
17679	11637	2563
17679	11637	2862
17679	11637	8512
17679	11637	5421
17679	11637	9655
234	11638	4833
10425	11639	8425
522	11640	3746
9511	11641	5167
9511	11641	9119
9511	11641	4692
8691	11642	4463
8691	11642	5188
8691	11642	2262
8691	11642	4507
8691	11642	5304
9447	11643	5479
9447	11643	2171
9447	11643	1693
9447	11643	9257
9447	11643	6162
9447	11643	537
9447	11643	2914
9447	11643	5199
9447	11643	8115
6605	11644	8026
6605	11644	8010
6605	11644	6393
19168	11645	6522
19168	11645	9618
19168	11645	5550
19168	11645	5074
11220	11646	8747
13724	11647	165
13724	11647	3125
13724	11647	9839
13724	11647	1519
13724	11647	7004
13724	11647	5815
13724	11647	3102
13724	11647	460
13724	11647	550
11246	11648	1233
11246	11648	9002
11246	11648	8046
11246	11648	6842
11246	11648	7967
11246	11648	1845
11246	11648	5195
11246	11648	2225
18457	11649	1875
18457	11649	6065
18457	11649	2104
18457	11649	8343
12126	11650	6347
12126	11650	3450
12126	11650	9562
12126	11650	9860
3409	11651	3388
3409	11651	9203
3409	11651	72
3892	11652	4280
5246	11653	8686
5246	11653	3418
5246	11653	4744
5246	11653	9424
5246	11653	7158
5246	11653	1833
5246	11653	987
5246	11653	6944
5246	11653	1295
2733	11654	3312
15183	11655	215
15183	11655	9462
15183	11655	7354
15183	11655	3931
15183	11655	9746
15183	11655	6402
15183	11655	2637
15183	11655	1357
15183	11655	8685
19960	11656	1346
19960	11656	4384
19960	11656	2582
19960	11656	2250
4927	11657	1363
4927	11657	8042
4927	11657	9657
4927	11657	8648
4927	11657	4692
12096	11658	4348
12096	11658	2956
12096	11658	6582
1930	11659	7152
1930	11659	3512
1930	11659	3672
1930	11659	8016
1930	11659	1279
1930	11659	328
1930	11659	3846
17074	11660	4585
17074	11660	4260
14431	11661	1518
14431	11661	5619
14431	11661	47
14431	11661	1685
14431	11661	5624
7278	11662	9697
7278	11662	9489
7278	11662	9693
7278	11662	2078
7278	11662	7764
7278	11662	5119
7278	11662	5594
7278	11662	9240
1513	11663	1233
1513	11663	6235
1513	11663	9516
1513	11663	8273
17326	11664	9380
17326	11664	8735
17326	11664	1314
17326	11664	9024
17326	11664	7475
6135	11665	6384
4591	11666	8253
4591	11666	5246
4591	11666	6735
4463	11667	7425
4463	11667	4739
4463	11667	633
4463	11667	6971
4463	11667	5131
4463	11667	3797
4463	11667	7512
4463	11667	6573
4463	11667	6307
9897	11668	9826
9897	11668	2213
9897	11668	8761
9897	11668	8792
12431	11669	2374
12431	11669	7469
5198	11670	8831
5198	11670	7713
5198	11670	5196
5198	11670	3072
5198	11670	8968
5198	11670	5830
16085	11671	4814
16085	11671	8012
16085	11671	359
16085	11671	2907
16085	11671	3647
16085	11671	2077
16085	11671	2974
3608	11672	7207
555	11673	3346
555	11673	2511
555	11673	7619
555	11673	8728
13479	11674	7253
13479	11674	5098
13479	11674	7205
357	11675	1983
18377	11676	9466
18377	11676	9553
18377	11676	5886
18377	11676	4468
18377	11676	9926
18377	11676	5936
19719	11677	6689
19719	11677	8085
19719	11677	6567
19719	11677	4072
19719	11677	5770
19719	11677	9807
19719	11677	5243
9417	11678	7520
9417	11678	4303
9417	11678	8067
8005	11679	3862
8005	11679	2303
8005	11679	9851
8005	11679	4444
8005	11679	5805
3149	11680	8428
3149	11680	8197
3149	11680	4521
3149	11680	3355
3149	11680	1438
3149	11680	4027
18418	11681	4325
18418	11681	8501
18418	11681	7917
18418	11681	7014
18418	11681	4768
18418	11681	877
18418	11681	4394
18418	11681	6618
9628	11682	1689
9628	11682	1818
9628	11682	4946
9628	11682	2629
9628	11682	5054
9628	11682	4874
9628	11682	3501
9628	11682	6005
9628	11682	1726
12986	11683	7282
12986	11683	101
12986	11683	3052
12986	11683	8713
12986	11683	5137
13909	11684	2799
13909	11684	6053
13909	11684	2290
13909	11684	7230
13909	11684	4301
13909	11684	7207
13909	11684	6254
13909	11684	2519
13909	11684	5640
11479	11685	1098
11479	11685	2361
11479	11685	2814
11479	11685	3189
11479	11685	5860
3825	11686	2839
3825	11686	574
3825	11686	4305
3825	11686	3166
3825	11686	8766
8809	11687	144
8809	11687	345
8809	11687	1596
8809	11687	7477
8809	11687	9343
10405	11688	7115
10405	11688	8030
10405	11688	1564
11737	11689	6427
18151	11690	4046
18151	11690	611
4414	11691	6616
4414	11691	9082
4414	11691	1640
4414	11691	611
4414	11691	6229
4414	11691	8708
4414	11691	7243
4414	11691	3660
172	11692	9161
172	11692	3428
8077	11693	6245
8077	11693	7384
8077	11693	1130
8077	11693	227
8077	11693	2200
8077	11693	1523
8077	11693	9476
8077	11693	6220
8077	11693	6030
4176	11694	4089
4176	11694	7452
4176	11694	2333
4176	11694	1555
4176	11694	4448
4176	11694	4621
4176	11694	660
4176	11694	8297
4176	11694	8519
82	11695	271
82	11695	7917
16523	11696	7383
16523	11696	4113
16523	11696	9994
16523	11696	315
16523	11696	6375
1990	11697	6745
10527	11698	5305
10527	11698	3811
10527	11698	9455
8954	11699	9464
7154	11700	22
7154	11700	4280
7154	11700	7283
7753	11701	8767
7753	11701	9399
7753	11701	7136
7753	11701	8464
15837	11702	2396
15837	11702	2414
10307	11703	7886
10307	11703	4759
10307	11703	1853
18487	11704	3379
18487	11704	3946
18487	11704	8837
18487	11704	7480
18487	11704	2028
18487	11704	5219
18487	11704	9909
18487	11704	7362
18487	11704	9473
9818	11705	367
9818	11705	7526
9818	11705	6433
9818	11705	1463
9818	11705	2740
13369	11706	7766
13369	11706	3170
13369	11706	2856
13369	11706	4494
13369	11706	6002
13369	11706	5086
5122	11707	7922
5122	11707	3274
5122	11707	2969
5122	11707	8764
5122	11707	2056
5122	11707	9273
5122	11707	8188
5122	11707	4958
16254	11708	6515
16254	11708	7608
16254	11708	2094
16254	11708	7991
16254	11708	5254
6351	11709	8623
6351	11709	3204
6351	11709	6522
6351	11709	8889
14153	11710	3029
14153	11710	7432
14153	11710	9518
14153	11710	9013
14153	11710	6463
14153	11710	9819
14153	11710	2450
14153	11710	2827
14153	11710	8248
13740	11711	4256
13740	11711	4636
13740	11711	6355
13740	11711	221
13740	11711	8288
13740	11711	3713
13740	11711	2024
13740	11711	9665
13740	11711	356
348	11712	5246
348	11712	7269
348	11712	5355
348	11712	363
348	11712	2819
14910	11713	6438
14910	11713	5351
14910	11713	1234
14910	11713	444
14910	11713	2293
14910	11713	4295
12877	11714	1032
12877	11714	222
12877	11714	1561
12877	11714	1742
12877	11714	4971
12877	11714	6542
12877	11714	2016
16906	11715	3179
16906	11715	5651
16906	11715	6780
16906	11715	3731
16906	11715	591
16906	11715	7513
17088	11716	6844
17088	11716	2579
17088	11716	4963
17088	11716	3147
17088	11716	2476
17088	11716	5808
17088	11716	3615
13586	11717	415
13586	11717	3895
13586	11717	9471
13586	11717	4112
13586	11717	7898
13586	11717	5527
4741	11718	956
8205	11719	9264
5758	11720	9672
5758	11720	464
5758	11720	2802
5758	11720	4232
5758	11720	8843
13481	11721	6118
13481	11721	7151
13481	11721	7606
13481	11721	5915
13481	11721	2210
2947	11722	4352
8046	11723	4109
8046	11723	9672
8046	11723	1753
8046	11723	6683
8046	11723	5255
2744	11724	9907
2744	11724	1045
2744	11724	6286
4826	11725	2752
15206	11726	2918
15206	11726	8542
15206	11726	5550
15206	11726	1104
15206	11726	1301
15206	11726	8152
15206	11726	7730
15206	11726	26
15206	11726	1859
16288	11727	557
16288	11727	4180
16288	11727	8128
16288	11727	912
7657	11728	6417
7657	11728	4458
7657	11728	6221
7657	11728	3878
3213	11729	9242
3213	11729	3941
3213	11729	5575
12264	11730	9440
702	11731	4179
702	11731	7297
702	11731	9098
10635	11732	9689
10635	11732	3600
5682	11733	5538
5682	11733	5435
5682	11733	4400
5682	11733	3258
5682	11733	8190
5682	11733	4190
5682	11733	3902
2397	11734	2953
2397	11734	4385
2397	11734	9074
2397	11734	824
2397	11734	9335
2397	11734	5513
2397	11734	1224
2397	11734	295
2397	11734	3359
13233	11735	7385
13233	11735	2457
13233	11735	1091
13233	11735	2485
13233	11735	1494
13233	11735	7136
13233	11735	5903
13454	11736	781
13454	11736	1313
13454	11736	5444
13454	11736	8663
13454	11736	6300
13454	11736	5419
13454	11736	5666
13454	11736	7555
13454	11736	4090
13149	11737	2012
13149	11737	7921
15745	11738	7158
16941	11739	77
12753	11740	1209
12753	11740	7788
12753	11740	7944
12753	11740	7408
12753	11740	8452
927	11741	8378
927	11741	6329
927	11741	4917
927	11741	8440
927	11741	1956
927	11741	1000
927	11741	1953
927	11741	8409
19235	11742	8381
19235	11742	5214
19235	11742	2368
19235	11742	1897
7684	11743	7833
7684	11743	5525
7684	11743	1172
6256	11744	5161
6256	11744	4550
6256	11744	7892
6256	11744	3187
3133	11745	7355
3133	11745	2313
3133	11745	2967
3133	11745	3093
3133	11745	8947
3133	11745	2011
3133	11745	3674
3133	11745	8436
16531	11746	48
16531	11746	5040
16452	11747	9792
16452	11747	7372
16452	11747	9525
16452	11747	6398
16452	11747	6125
16452	11747	6816
16452	11747	416
16452	11747	9543
15957	11748	6244
15957	11748	9791
15957	11748	6581
15957	11748	4231
15957	11748	3056
15957	11748	593
15957	11748	5454
15957	11748	9994
12782	11749	5881
12782	11749	8845
12782	11749	3112
12782	11749	385
2264	11750	2521
2264	11750	8900
2264	11750	8060
2231	11751	3963
2231	11751	9528
14351	11752	949
14351	11752	1308
14351	11752	2524
14351	11752	8180
14351	11752	9540
14351	11752	4040
14351	11752	7154
12108	11753	9185
12108	11753	5385
12108	11753	8194
12108	11753	2885
4878	11754	9462
4878	11754	9877
4878	11754	5638
4878	11754	5189
9457	11755	7709
9457	11755	5908
9457	11755	1571
9457	11755	8189
9457	11755	8199
9457	11755	9063
9457	11755	2921
9457	11755	4113
9457	11755	4386
7696	11756	4618
7696	11756	2149
7696	11756	4310
7696	11756	4535
7696	11756	6804
7696	11756	8190
7696	11756	6161
7696	11756	4278
7696	11756	515
19154	11757	1524
11820	11758	9758
11820	11758	6686
11820	11758	7337
11820	11758	4181
11820	11758	6291
11820	11758	4319
11820	11758	957
14235	11759	1466
18775	11760	229
18775	11760	4409
12798	11761	3244
12798	11761	3923
12798	11761	9752
12798	11761	2225
12798	11761	6818
12798	11761	9137
12798	11761	9051
12798	11761	4893
12798	11761	5023
15164	11762	9009
15164	11762	338
15164	11762	3268
15164	11762	9816
15164	11762	9678
15164	11762	8415
16332	11763	4208
16332	11763	2407
16332	11763	6297
16332	11763	8285
16332	11763	2774
16332	11763	7547
6584	11764	9266
6584	11764	3316
6584	11764	3795
6584	11764	32
6584	11764	6190
6584	11764	7073
6584	11764	6612
6584	11764	5692
6584	11764	7299
7191	11765	4784
7191	11765	5755
7191	11765	9199
5053	11766	6192
5053	11766	7421
5053	11766	2988
5053	11766	3459
5053	11766	5898
5019	11767	3329
5019	11767	2796
5019	11767	203
5019	11767	9939
5019	11767	4677
7751	11768	6402
7751	11768	7826
7751	11768	8737
3449	11769	903
3449	11769	6571
3449	11769	1105
3449	11769	4606
3449	11769	2487
3449	11769	1925
3727	11770	7558
3727	11770	8302
3727	11770	7929
3727	11770	8775
15023	11771	9236
15023	11771	5916
15023	11771	2295
15023	11771	46
15023	11771	8366
15023	11771	7833
15023	11771	2052
15023	11771	3541
15023	11771	1621
18355	11772	9073
18355	11772	9234
18355	11772	9887
18355	11772	5359
18355	11772	6407
4646	11773	4809
4646	11773	279
4646	11773	9429
4646	11773	4026
4646	11773	7868
4646	11773	3282
4646	11773	8781
9970	11774	9118
9970	11774	5585
9970	11774	9803
9970	11774	9891
9970	11774	5537
9970	11774	8533
9970	11774	1355
3267	11775	9744
3267	11775	5954
3267	11775	8108
3267	11775	7100
3267	11775	8745
5569	11776	6058
11721	11777	2071
11721	11777	4358
11721	11777	5835
11721	11777	3945
11721	11777	7346
11721	11777	5354
11721	11777	1002
11721	11777	4701
11721	11777	542
18574	11778	2072
18574	11778	8858
18574	11778	155
18574	11778	3989
18574	11778	8734
18574	11778	5751
18574	11778	6662
18574	11778	8805
12300	11779	3239
12300	11779	9126
12300	11779	1175
12300	11779	9741
12300	11779	8955
12300	11779	5041
12300	11779	8373
12300	11779	9154
6285	11780	9201
6285	11780	4574
6756	11781	9528
6756	11781	6331
6756	11781	9599
6756	11781	706
6756	11781	5125
6756	11781	7945
6756	11781	7751
6756	11781	5104
8516	11782	7401
8516	11782	1114
8516	11782	7821
8516	11782	2463
8516	11782	9065
8516	11782	2379
8516	11782	6463
8516	11782	1359
8516	11782	4166
18581	11783	3369
18581	11783	7763
18581	11783	6385
18581	11783	2731
18581	11783	4277
10779	11784	1077
10779	11784	6080
16915	11785	7167
16915	11785	648
16915	11785	2157
16915	11785	623
16915	11785	2259
44	11786	4667
44	11786	2347
13478	11787	8952
13478	11787	1252
18753	11788	3964
18753	11788	4376
18753	11788	1988
18753	11788	2092
8701	11789	4372
8701	11789	7441
8701	11789	4262
8701	11789	7981
8701	11789	6526
8701	11789	1644
5791	11790	2272
5791	11790	7555
5791	11790	4651
13277	11791	9249
13277	11791	7287
13277	11791	5791
6464	11792	3019
6464	11792	8766
6464	11792	990
6464	11792	5022
6464	11792	3306
6464	11792	1983
6464	11792	9526
6464	11792	1812
6464	11792	1468
19862	11793	9594
10769	11794	8616
3270	11795	1180
3270	11795	9186
3270	11795	3610
3270	11795	1731
3270	11795	8068
3270	11795	5129
3270	11795	5433
3270	11795	2535
16253	11796	1005
16253	11796	1506
16253	11796	3056
16253	11796	774
16253	11796	1756
16253	11796	1842
2054	11797	3518
2054	11797	8784
2054	11797	2123
15110	11798	3802
15110	11798	2124
15110	11798	3158
15110	11798	2336
10782	11799	8457
10782	11799	4126
10782	11799	9474
10782	11799	1325
10782	11799	6899
10782	11799	9476
10782	11799	6427
10782	11799	9595
10782	11799	9153
5909	11800	3066
5909	11800	7139
5909	11800	4961
5909	11800	792
18497	11801	9546
18497	11801	3084
18497	11801	4367
18497	11801	5713
18497	11801	5665
18497	11801	5441
18497	11801	28
18497	11801	5364
18497	11801	7548
1226	11802	6015
1226	11802	8871
1226	11802	7506
7579	11803	9547
7579	11803	6471
7579	11803	6565
7579	11803	7757
7579	11803	4322
7579	11803	7489
5704	11804	5356
5704	11804	5950
5704	11804	5251
5704	11804	5918
5704	11804	8770
9649	11805	425
9649	11805	8324
9776	11806	7118
9776	11806	1626
9776	11806	7748
9776	11806	7458
9776	11806	4752
9776	11806	6200
9776	11806	969
9776	11806	2666
2871	11807	6260
2871	11807	5557
2871	11807	4281
2871	11807	3578
5311	11808	6054
5311	11808	491
5311	11808	4423
5311	11808	7813
5311	11808	762
5311	11808	9877
5084	11809	3977
472	11810	6920
994	11811	3153
994	11811	8935
994	11811	4072
16988	11812	7669
15090	11813	87
8126	11814	4299
8126	11814	6577
8126	11814	4581
8126	11814	1715
8126	11814	3911
8126	11814	9325
6792	11815	1890
6792	11815	7897
6792	11815	7776
6792	11815	7104
6792	11815	3019
6792	11815	6120
6792	11815	1253
11102	11816	6769
11102	11816	7952
11102	11816	2220
11102	11816	3350
11102	11816	4708
11102	11816	4941
11102	11816	4501
4794	11817	5124
4794	11817	2034
4794	11817	682
4794	11817	2485
5999	11818	92
5999	11818	1014
5999	11818	2737
5999	11818	9906
5999	11818	4779
5999	11818	3508
5999	11818	1589
5999	11818	6551
5999	11818	405
11057	11819	3670
11057	11819	2787
11057	11819	9048
11057	11819	9154
11057	11819	3520
9068	11820	7768
9068	11820	9608
9068	11820	1805
9068	11820	2266
17633	11821	1756
17633	11821	7056
1451	11822	6880
1451	11822	6086
19210	11823	4139
19210	11823	5187
9587	11824	7909
9587	11824	4956
13113	11825	757
13113	11825	5477
13113	11825	8338
13113	11825	1213
13113	11825	5125
13113	11825	1250
13113	11825	6903
2082	11826	2947
2082	11826	7648
2082	11826	413
10737	11827	1925
10737	11827	6940
10737	11827	2756
10737	11827	2273
10737	11827	3194
10737	11827	6310
10737	11827	782
10737	11827	4322
10737	11827	4087
6357	11828	2028
6357	11828	9071
6374	11829	2838
6374	11829	7778
6374	11829	2414
9372	11830	8171
9372	11830	3705
9372	11830	5496
9372	11830	6637
9372	11830	16
9721	11831	7352
9721	11831	7228
9721	11831	9290
9721	11831	8034
9721	11831	4769
14365	11832	1868
14365	11832	9487
14365	11832	5905
14365	11832	8991
11254	11833	989
11254	11833	6094
6891	11834	8845
6891	11834	793
6891	11834	5542
6891	11834	2688
6891	11834	2743
6891	11834	1546
2064	11835	4223
2064	11835	4305
2064	11835	9267
509	11836	8276
509	11836	6212
509	11836	3312
8208	11837	9665
8208	11837	8801
692	11838	1378
11200	11839	1040
11200	11839	3147
11200	11839	4828
11200	11839	480
11200	11839	9728
11200	11839	5502
11200	11839	1748
11200	11839	7143
13615	11840	9215
13615	11840	1815
6385	11841	8793
6385	11841	4028
6385	11841	7778
6385	11841	7546
6385	11841	9348
6385	11841	5708
2419	11842	2524
2419	11842	147
2419	11842	6065
2419	11842	6662
2419	11842	408
2419	11842	1511
18819	11843	2615
785	11844	2998
785	11844	5863
785	11844	8809
785	11844	9914
785	11844	7044
785	11844	181
785	11844	7630
785	11844	5640
12095	11845	9065
12095	11845	2444
12095	11845	4896
10376	11846	3026
10376	11846	1579
773	11847	1310
773	11847	9503
773	11847	3700
773	11847	7735
773	11847	1422
773	11847	5388
773	11847	2292
9470	11848	9793
9470	11848	8706
9470	11848	6005
9470	11848	3689
1681	11849	7906
14816	11850	4539
11920	11851	148
11920	11851	9476
11920	11851	4786
11920	11851	2288
11920	11851	6335
4678	11852	9922
4678	11852	4350
4678	11852	3429
4678	11852	7168
15871	11853	6437
15871	11853	162
15871	11853	4982
15871	11853	4247
18065	11854	3611
18065	11854	2359
10163	11855	8424
10163	11855	3116
10163	11855	3545
10163	11855	1877
10163	11855	8219
9311	11856	8852
9311	11856	7878
9311	11856	1593
9311	11856	2131
9311	11856	8323
9311	11856	1190
9311	11856	9172
12222	11857	7401
12222	11857	6037
12222	11857	5120
12222	11857	4152
3119	11858	9129
3119	11858	9400
3119	11858	9942
4145	11859	7813
4145	11859	2966
4145	11859	6900
17240	11860	3456
17151	11861	1913
17151	11861	7151
17151	11861	9234
17151	11861	6751
17151	11861	3285
17151	11861	9624
17679	11862	9244
17679	11862	3562
17679	11862	1225
17679	11862	4764
17679	11862	7152
17679	11862	3084
19887	11863	6913
19887	11863	8613
19887	11863	7612
19887	11863	4779
19887	11863	2056
19887	11863	8145
19887	11863	3242
19887	11863	7397
1917	11864	7615
1917	11864	5534
17236	11865	8562
17236	11865	7112
17236	11865	8874
17236	11865	1620
17236	11865	1088
17236	11865	7382
17236	11865	800
17236	11865	3962
2718	11866	2317
2718	11866	4775
2718	11866	8547
2718	11866	4698
16111	11867	5596
16111	11867	2961
16111	11867	1397
16111	11867	955
16111	11867	979
16111	11867	5627
16111	11867	3863
14130	11868	442
14130	11868	7502
14130	11868	3196
15785	11869	5948
15785	11869	1937
15785	11869	439
15785	11869	6012
15785	11869	9479
913	11870	2235
913	11870	9535
913	11870	6230
913	11870	401
913	11870	3746
913	11870	1886
913	11870	3949
913	11870	4834
913	11870	1860
7594	11871	8695
7594	11871	7195
7594	11871	5302
7594	11871	8630
7594	11871	1461
1990	11872	1477
1990	11872	2669
1990	11872	7220
1990	11872	2164
1990	11872	1965
1990	11872	1322
12484	11873	1601
17590	11874	309
17590	11874	4344
17590	11874	3982
17590	11874	2764
8482	11875	9464
8482	11875	7335
8482	11875	606
3855	11876	8169
3855	11876	6505
3855	11876	7061
3855	11876	8564
3855	11876	8681
3855	11876	4667
17297	11877	1548
17297	11877	7647
17297	11877	26
17297	11877	3203
7617	11878	5736
7617	11878	3766
7617	11878	527
7617	11878	3674
7617	11878	5212
7617	11878	9137
7617	11878	1111
3504	11879	5157
3504	11879	1299
3504	11879	7765
3504	11879	9913
17300	11880	6013
17300	11880	5124
17300	11880	4415
17300	11880	47
17300	11880	3238
4748	11881	6177
4748	11881	3188
16690	11882	1148
16690	11882	2741
2847	11883	6765
2847	11883	6645
2847	11883	5500
2847	11883	7539
2847	11883	9148
2847	11883	805
19912	11884	6024
19912	11884	7954
19912	11884	2443
19912	11884	7560
19912	11884	971
19912	11884	4651
19912	11884	1724
19912	11884	8462
19912	11884	83
11164	11885	1128
11164	11885	8692
11164	11885	4787
11164	11885	1889
11164	11885	1167
11164	11885	9794
11164	11885	4054
11164	11885	9699
1339	11886	2998
2919	11887	6565
2919	11887	501
2919	11887	419
2919	11887	8043
2919	11887	3562
10899	11888	3361
10899	11888	1237
1871	11889	1605
1871	11889	6855
1871	11889	4579
1871	11889	6061
1871	11889	6610
1871	11889	9208
19252	11890	8735
19252	11890	6227
19252	11890	7750
19252	11890	1802
6076	11891	3973
6076	11891	2
6076	11891	8494
6076	11891	179
12479	11892	8866
12479	11892	2268
12479	11892	8610
12479	11892	7619
12479	11892	3306
2111	11893	2165
2111	11893	1869
2111	11893	5288
2111	11893	8242
2111	11893	1418
2111	11893	2146
2111	11893	9807
2111	11893	7836
13402	11894	922
13402	11894	9125
13402	11894	4521
13402	11894	2386
13402	11894	3486
13402	11894	381
13402	11894	2647
13402	11894	6340
9163	11895	1316
9163	11895	1104
9163	11895	6064
9163	11895	706
9163	11895	5641
9163	11895	33
9163	11895	6449
9163	11895	5103
9163	11895	1588
10146	11896	723
10146	11896	5148
10146	11896	9051
4549	11897	7645
4549	11897	4083
4549	11897	2788
16858	11898	4991
16858	11898	4810
16858	11898	1479
16858	11898	7581
16858	11898	1470
16858	11898	6896
4087	11899	5280
4087	11899	8491
4087	11899	3859
4087	11899	1873
4087	11899	9843
4087	11899	2730
13581	11900	7301
13581	11900	8173
13581	11900	2324
13581	11900	2777
13581	11900	1803
13581	11900	5986
13581	11900	1716
13581	11900	5185
7352	11901	9811
7352	11901	7940
7352	11901	1553
7352	11901	5116
7352	11901	7460
7352	11901	2722
7352	11901	2159
7352	11901	3539
7352	11901	6647
16899	11902	7418
16899	11902	9502
16899	11902	4699
16899	11902	6278
12177	11903	5741
12177	11903	4248
12177	11903	2805
12177	11903	7090
18497	11904	3731
4012	11905	6267
4012	11905	10
4012	11905	1536
15627	11906	3902
15627	11906	626
15627	11906	9200
15627	11906	500
15627	11906	6580
15627	11906	7532
15627	11906	6837
1134	11907	2573
1134	11907	1678
1134	11907	7469
1134	11907	4606
1134	11907	6396
1134	11907	6817
1134	11907	3062
1134	11907	1860
1134	11907	361
1719	11908	8448
1719	11908	8186
1719	11908	4548
1719	11908	5851
1719	11908	607
4568	11909	3972
4568	11909	6573
4568	11909	7882
4568	11909	1190
4568	11909	4108
4568	11909	4630
4568	11909	4109
14345	11910	7768
14345	11910	9059
14345	11910	7750
14345	11910	3881
7964	11911	1551
16246	11912	1513
11240	11913	88
11240	11913	9105
11240	11913	497
11240	11913	9190
11240	11913	3947
11240	11913	580
8921	11914	8442
8921	11914	7086
8921	11914	5302
8921	11914	8115
8921	11914	9891
8921	11914	6448
11329	11915	8989
11329	11915	749
11329	11915	3630
11329	11915	7750
11329	11915	8186
2687	11916	7835
2687	11916	15
2687	11916	1223
2687	11916	4468
2687	11916	5596
2687	11916	8965
2687	11916	5535
2687	11916	7708
2687	11916	9546
589	11917	232
589	11917	29
589	11917	2261
10100	11918	6281
10100	11918	2515
10100	11918	3953
10100	11918	6841
10100	11918	1340
10100	11918	1593
10100	11918	18
19126	11919	9857
19126	11919	778
19126	11919	6111
19126	11919	8506
19126	11919	106
19126	11919	3422
19126	11919	5861
19126	11919	7366
2638	11920	868
2638	11920	9852
2638	11920	3570
2638	11920	1760
15513	11921	9935
15513	11921	9377
15513	11921	2980
15513	11921	4417
15513	11921	6148
15513	11921	1815
15513	11921	7540
15513	11921	382
15513	11921	499
2733	11922	3827
2733	11922	8510
2733	11922	9074
2733	11922	3343
2733	11922	7229
2733	11922	2645
2733	11922	9323
2733	11922	4487
1269	11923	2642
6047	11924	8761
2386	11925	7196
2386	11925	983
2386	11925	7742
2386	11925	6739
2386	11925	7602
13848	11926	663
13848	11926	6697
13848	11926	4241
13848	11926	1354
13848	11926	2362
13848	11926	4149
11438	11927	1115
11438	11927	8956
11438	11927	5779
11438	11927	6422
11438	11927	1667
11438	11927	1900
11438	11927	948
11438	11927	9305
11438	11927	624
9728	11928	8810
9728	11928	416
9728	11928	8822
9728	11928	8677
9728	11928	7434
12777	11929	3085
12777	11929	8942
12777	11929	2335
12777	11929	7994
12777	11929	7748
12777	11929	4891
17479	11930	3942
17479	11930	6336
17479	11930	5003
17479	11930	2636
17479	11930	6294
17479	11930	3472
17479	11930	6458
17479	11930	3364
4610	11931	3146
4610	11931	9287
4610	11931	9584
4610	11931	9265
4610	11931	2917
4610	11931	1518
15707	11932	3011
15707	11932	3226
15707	11932	3920
15707	11932	6243
15707	11932	2057
15707	11932	9919
15707	11932	1911
15707	11932	1733
15707	11932	6500
12166	11933	8965
12166	11933	7716
12166	11933	4969
12166	11933	8336
12166	11933	1807
10065	11934	1730
10065	11934	4329
10065	11934	6500
10065	11934	9514
2493	11935	2265
2493	11935	1042
2493	11935	4633
2493	11935	5572
2493	11935	488
17647	11936	170
17647	11936	1448
17647	11936	707
17647	11936	7712
17647	11936	6963
17647	11936	9282
15483	11937	2700
15483	11937	5505
15483	11937	7447
15483	11937	3747
15483	11937	2487
15483	11937	3558
560	11938	7035
560	11938	4046
560	11938	8135
10195	11939	1575
10195	11939	9799
4996	11940	6239
19972	11941	4221
19972	11941	9903
19972	11941	3587
1243	11942	8363
1243	11942	6309
1243	11942	1602
1243	11942	3196
1243	11942	868
11091	11943	5728
11091	11943	8489
16475	11944	1545
16475	11944	3216
16475	11944	2170
16475	11944	5753
16475	11944	8272
16475	11944	7044
17292	11945	1822
17292	11945	1443
17292	11945	3272
17292	11945	6052
17292	11945	8665
17292	11945	5047
17292	11945	2778
17292	11945	6319
19068	11946	3255
19068	11946	5369
19068	11946	9319
19068	11946	6107
19068	11946	1058
5760	11947	7174
5760	11947	1396
5760	11947	2962
5760	11947	7766
5760	11947	441
13518	11948	6293
13518	11948	9399
13518	11948	9520
13518	11948	1073
13518	11948	7180
16475	11949	1117
16475	11949	891
16475	11949	4798
16475	11949	1516
16475	11949	2346
16475	11949	5768
15356	11950	2248
15356	11950	9002
15356	11950	5385
15356	11950	6413
15356	11950	7359
1535	11951	7197
1535	11951	4616
1535	11951	1236
1535	11951	373
5436	11952	5505
5436	11952	618
5436	11952	6543
11088	11953	4065
11088	11953	2730
11088	11953	4516
11088	11953	2191
11088	11953	147
11088	11953	9289
1049	11954	3276
1049	11954	563
1049	11954	4288
1049	11954	7165
1049	11954	1117
1049	11954	7771
1049	11954	9250
1049	11954	8277
2012	11955	7372
2012	11955	4064
2012	11955	6314
2012	11955	2280
2012	11955	3878
2012	11955	1632
2012	11955	7803
4182	11956	6997
4182	11956	3332
4182	11956	1381
4182	11956	7049
4182	11956	5896
4182	11956	663
4182	11956	7974
4182	11956	7561
4182	11956	5552
15663	11957	4287
15663	11957	6420
15663	11957	1486
15663	11957	4180
15663	11957	8507
15663	11957	9122
15663	11957	5943
15663	11957	4420
15663	11957	158
1640	11958	8854
1640	11958	3255
17290	11959	7912
8663	11960	3213
3439	11961	3558
3439	11961	191
3439	11961	2900
3439	11961	8294
3439	11961	1168
3439	11961	7361
3439	11961	7752
3439	11961	4427
3439	11961	9261
14344	11962	1503
14344	11962	340
14344	11962	4588
14344	11962	6435
14344	11962	596
14344	11962	8462
14344	11962	7970
14344	11962	1133
14344	11962	7504
9729	11963	5480
9729	11963	3393
9729	11963	3412
13194	11964	8394
13194	11964	8130
13194	11964	4336
13194	11964	1534
19991	11965	1356
19991	11965	8790
19991	11965	9150
2943	11966	8220
2943	11966	3945
2943	11966	4518
2943	11966	8229
2943	11966	9271
2943	11966	1037
2943	11966	9603
2943	11966	1965
2943	11966	303
12037	11967	2868
12037	11967	1348
12037	11967	2134
19372	11968	631
19372	11968	3340
3135	11969	8190
3135	11969	745
3135	11969	9163
3135	11969	8929
121	11970	2548
121	11970	6120
121	11970	367
121	11970	8966
121	11970	7940
121	11970	5563
121	11970	1460
121	11970	3717
12943	11971	262
12943	11971	6451
12943	11971	2334
12943	11971	8889
12943	11971	5440
12943	11971	9846
12943	11971	2722
12943	11971	1882
1695	11972	4088
1695	11972	727
8887	11973	915
8887	11973	536
13972	11974	2365
13972	11974	3482
6655	11975	9292
6655	11975	9669
6655	11975	8520
6655	11975	5667
6655	11975	9117
6655	11975	8155
18473	11976	9197
18473	11976	2926
7050	11977	3013
7050	11977	91
7050	11977	7506
13595	11978	307
13595	11978	9731
13595	11978	4683
5675	11979	2074
5675	11979	4952
5675	11979	4709
9262	11980	6918
14017	11981	2891
14017	11981	9228
14017	11981	7856
15172	11982	6433
15172	11982	6040
15172	11982	1077
12057	11983	3906
12057	11983	6917
12057	11983	178
10205	11984	7533
13522	11985	6296
13522	11985	1186
13522	11985	1900
13522	11985	9678
1509	11986	6783
1377	11987	5997
11438	11988	6727
11438	11988	8609
11438	11988	4438
11438	11988	6071
11438	11988	7484
18765	11989	7321
18765	11989	2969
19502	11990	439
19502	11990	2782
19502	11990	8709
17705	11991	6529
17705	11991	1353
17705	11991	9087
17705	11991	1699
17705	11991	4679
17705	11991	5953
17705	11991	6449
17705	11991	7849
14287	11992	9724
14287	11992	9115
14287	11992	6043
14287	11992	9321
14287	11992	6675
6407	11993	4169
6407	11993	5854
6407	11993	6971
6407	11993	102
6407	11993	84
6407	11993	6196
6407	11993	5968
6407	11993	5076
9598	11994	7304
9598	11994	5223
9598	11994	8983
9598	11994	7637
9598	11994	5101
9598	11994	4491
9598	11994	9351
12643	11995	9245
12643	11995	1788
12643	11995	8892
12643	11995	8279
12643	11995	2892
15270	11996	8421
15270	11996	2693
15270	11996	1085
15270	11996	3464
15270	11996	9280
15270	11996	5454
1180	11997	5828
1180	11997	133
1180	11997	9635
1180	11997	5370
1180	11997	2991
1180	11997	4478
1180	11997	5896
1180	11997	7824
1180	11997	7629
17427	11998	4898
17427	11998	3138
17427	11998	8755
17427	11998	942
17427	11998	610
1485	11999	9767
1485	11999	5449
1485	11999	8014
1485	11999	4512
1485	11999	8368
1485	11999	8225
1485	11999	2851
7393	12000	3821
7393	12000	9960
7393	12000	9702
7393	12000	6281
7393	12000	7670
7393	12000	1054
7393	12000	1717
7393	12000	1807
7393	12000	3576
\.


--
-- Data for Name: customers; Type: TABLE DATA; Schema: public; Owner: chriskl
--

COPY customers (customerid, firstname, lastname, address1, address2, city, state, zip, country, region, email, phone, creditcardtype, creditcard, creditcardexpiration, username, "password", age, income, gender) FROM stdin;
1	VKUUXF	ITHOMQJNYX	4608499546 Dell Way	\N	QSDPAGD	SD	24101	US	1	ITHOMQJNYX@dell.com	4608499546	1	1979279217775911	2012/03	user1	password	55	100000	M
2	HQNMZH	UNUKXHJVXB	5119315633 Dell Way	\N	YNCERXJ	AZ	11802	US	1	UNUKXHJVXB@dell.com	5119315633	1	3144519586581737	2012/11	user2	password	80	40000	M
3	JTNRNB	LYYSHTQJRE	6297761196 Dell Way	\N	LWVIFXJ	OH	96082	US	1	LYYSHTQJRE@dell.com	6297761196	4	8728086929768325	2010/12	user3	password	47	100000	M
4	XMFYXD	WQLQHUHLFE	9862764981 Dell Way	\N	HOKEXCD	MS	78442	US	1	WQLQHUHLFE@dell.com	9862764981	5	7160005148965866	2009/09	user4	password	44	40000	F
5	PGDTDU	ETBYBNEGUT	2841895775 Dell Way	\N	RZQTCDN	AZ	16291	US	1	ETBYBNEGUT@dell.com	2841895775	3	8377095518168063	2010/10	user5	password	21	20000	M
6	FXDZBW	BAXPEEKXVJ	6192740010 Dell Way	\N	OPLRCNT	IN	99300	US	1	BAXPEEKXVJ@dell.com	6192740010	5	7730283664073796	2011/01	user6	password	72	100000	M
7	WVZTXZ	RMEVXCQGQF	9743191382 Dell Way	\N	SIIGBQF	NV	55961	US	1	RMEVXCQGQF@dell.com	9743191382	2	5914961899630726	2011/02	user7	password	52	60000	M
8	LIWLAI	PVGRMMHSEQ	7576564107 Dell Way	\N	BKSRQJE	NJ	66444	US	1	PVGRMMHSEQ@dell.com	7576564107	2	7663945967331529	2009/12	user8	password	67	80000	F
9	NCGWRC	CJOPRHUHIE	7291678624 Dell Way	\N	ZAVIELY	VT	78838	US	1	CJOPRHUHIE@dell.com	7291678624	1	7172072122339160	2009/10	user9	password	86	100000	M
10	FUOHXX	WMOEHWMMWM	2603867587 Dell Way	\N	HERSDPM	TN	75182	US	1	WMOEHWMMWM@dell.com	2603867587	2	5486729339230806	2008/02	user10	password	44	40000	M
11	XQVVMI	KRPGDBCQJH	2415449050 Dell Way	\N	ICLYPGR	PA	53868	US	1	KRPGDBCQJH@dell.com	2415449050	5	6630987872369588	2010/03	user11	password	58	60000	M
12	KGISQZ	IXDKAUUHCW	1896033667 Dell Way	\N	SBLZSFM	UT	18452	US	1	IXDKAUUHCW@dell.com	1896033667	2	3715867913328111	2011/10	user12	password	27	20000	F
13	LURLDP	PNPJHXMEPN	3029418206 Dell Way	\N	QPGVBCY	DE	53356	US	1	PNPJHXMEPN@dell.com	3029418206	5	3617457962129265	2009/11	user13	password	43	100000	M
14	AGUQVI	FFPCRUSFKI	3748672054 Dell Way	\N	LGKNEOA	MA	44395	US	1	FFPCRUSFKI@dell.com	3748672054	4	3344003576319665	2011/07	user14	password	85	80000	M
15	SIQANV	QQNKJSURDA	3354132892 Dell Way	\N	BREQSOA	AK	37471	US	1	QQNKJSURDA@dell.com	3354132892	4	8717996907886119	2008/05	user15	password	66	100000	M
16	IXEENV	RXEKSWOTYG	6914808178 Dell Way	\N	YOYMOYU	SD	63504	US	1	RXEKSWOTYG@dell.com	6914808178	5	9422665674239398	2009/11	user16	password	61	80000	M
17	UUGPME	UWWRKPPQOD	1436497137 Dell Way	\N	PASNVNC	MO	55931	US	1	UWWRKPPQOD@dell.com	1436497137	5	4461925670970231	2011/06	user17	password	28	60000	F
18	KASOVP	LMZBBQPFFQ	4002123087 Dell Way	\N	YTMLWYY	VA	79031	US	1	LMZBBQPFFQ@dell.com	4002123087	3	2972224516794085	2010/12	user18	password	52	100000	M
19	ELUTXG	TZIKOOQEMJ	6334227072 Dell Way	\N	RXFPWCJ	GA	68186	US	1	TZIKOOQEMJ@dell.com	6334227072	4	6367064577993006	2008/07	user19	password	59	40000	F
20	IAYPUX	YELMUQZEHW	7467996902 Dell Way	\N	JXTMHYD	UT	66087	US	1	YELMUQZEHW@dell.com	7467996902	5	2656596019398421	2009/03	user20	password	32	80000	F
21	DFYAED	MQXCPBKMLH	9981729052 Dell Way	\N	GXOEALV	PA	42074	US	1	MQXCPBKMLH@dell.com	9981729052	1	5711935373954475	2009/08	user21	password	69	40000	M
22	QIBTUS	RXITHVEPBC	5221450049 Dell Way	\N	EGDPBXY	AR	93269	US	1	RXITHVEPBC@dell.com	5221450049	2	6283100841101260	2008/08	user22	password	52	100000	M
23	NPSFGQ	NAYJFNKHRQ	8606105897 Dell Way	\N	LGSIFTG	NY	11455	US	1	NAYJFNKHRQ@dell.com	8606105897	5	6406863798853011	2009/09	user23	password	56	100000	F
24	GBNXPN	VYTIJBAAMH	1759698957 Dell Way	\N	SVNMCEM	WA	13905	US	1	VYTIJBAAMH@dell.com	1759698957	2	7402193841524423	2011/02	user24	password	88	100000	F
25	MTUAPT	TXCUYCHGVC	7232171147 Dell Way	\N	THEYTCZ	TX	40738	US	1	TXCUYCHGVC@dell.com	7232171147	3	4909582856111229	2011/04	user25	password	61	20000	F
26	JDRCWP	FRNIYTDANK	1757661798 Dell Way	\N	FLEILAQ	CT	51575	US	1	FRNIYTDANK@dell.com	1757661798	4	8073390801902861	2011/11	user26	password	81	20000	F
27	NEYCKP	QSOKVPXFUJ	6716835282 Dell Way	\N	JCVKTYW	TN	74298	US	1	QSOKVPXFUJ@dell.com	6716835282	3	6621923426631839	2010/07	user27	password	67	20000	M
28	PDDFUV	TERICXCMHF	6049066172 Dell Way	\N	HRYFNUY	DC	36514	US	1	TERICXCMHF@dell.com	6049066172	4	8860724361613394	2009/09	user28	password	63	100000	M
29	UAPQTU	HBWEEJLJQC	3449703700 Dell Way	\N	IWPCUTK	LA	45481	US	1	HBWEEJLJQC@dell.com	3449703700	3	1614113333169371	2012/06	user29	password	82	80000	F
30	MHFGOH	DTMMFWDHEA	2016678561 Dell Way	\N	XHVQREB	WI	79755	US	1	DTMMFWDHEA@dell.com	2016678561	5	2865310022607446	2012/07	user30	password	66	60000	M
31	XSKFVE	RIJNLQSLOA	4837704029 Dell Way	\N	GESLGQF	KY	56291	US	1	RIJNLQSLOA@dell.com	4837704029	2	1454196398146450	2008/10	user31	password	82	100000	M
32	HEJLWR	UKDLCPZCWE	1184575169 Dell Way	\N	UIKLNTZ	WI	17967	US	1	UKDLCPZCWE@dell.com	1184575169	1	9080948004499080	2012/01	user32	password	48	20000	F
33	UQBLKL	PVOFURBZMJ	1806894893 Dell Way	\N	JYXCXWE	VT	93580	US	1	PVOFURBZMJ@dell.com	1806894893	5	9715552329085768	2010/01	user33	password	31	40000	M
34	GTASJW	HORYQQLAZJ	7282866423 Dell Way	\N	YCGUHES	MA	10625	US	1	HORYQQLAZJ@dell.com	7282866423	5	1105126248672604	2012/03	user34	password	64	20000	M
35	RWHOEV	FCLWOLWXKY	4409192440 Dell Way	\N	EEGJXQJ	NJ	56565	US	1	FCLWOLWXKY@dell.com	4409192440	3	7246819562744350	2008/08	user35	password	63	80000	M
36	XGRSMU	EIIQEGADKF	3021789304 Dell Way	\N	KUDADTN	MT	32229	US	1	EIIQEGADKF@dell.com	3021789304	3	9073497921694072	2012/03	user36	password	48	80000	F
37	CMYWQG	FHLLHPWNZQ	5803405046 Dell Way	\N	QZUKNIQ	OR	87777	US	1	FHLLHPWNZQ@dell.com	5803405046	3	1896664091385901	2012/04	user37	password	60	20000	M
38	NYLUDS	GPAVMNUDEU	2906073166 Dell Way	\N	YOHGFAC	OR	65430	US	1	GPAVMNUDEU@dell.com	2906073166	4	9456843751948328	2011/09	user38	password	71	40000	M
39	ECUWIJ	WDWKYZOSXC	6284773018 Dell Way	\N	AEIAGAQ	MO	74187	US	1	WDWKYZOSXC@dell.com	6284773018	2	4912659454625100	2009/07	user39	password	23	60000	M
40	WIZGFD	CPBCDTZGTD	7725075074 Dell Way	\N	OUKPLXI	AL	24179	US	1	CPBCDTZGTD@dell.com	7725075074	2	7576088857371361	2012/10	user40	password	46	80000	F
41	JYINBY	ODBICICGXX	5021884093 Dell Way	\N	RMJOUKS	NC	76640	US	1	ODBICICGXX@dell.com	5021884093	2	6023778205737472	2012/01	user41	password	69	40000	F
42	BSBZHE	AQHJTNGQFT	7225708050 Dell Way	\N	ATNKMCD	WA	51342	US	1	AQHJTNGQFT@dell.com	7225708050	4	5741442908532918	2009/12	user42	password	56	60000	M
43	PKATLQ	AUKOBAUUAO	4599311991 Dell Way	\N	ILAKOYW	ID	74576	US	1	AUKOBAUUAO@dell.com	4599311991	4	7362957327160985	2012/02	user43	password	49	60000	F
44	LGYCHT	MWUNQPOEYZ	6118785825 Dell Way	\N	FINDFUW	NJ	49850	US	1	MWUNQPOEYZ@dell.com	6118785825	3	5789964983239770	2012/01	user44	password	20	60000	F
45	ZNPSZM	NNCDBHBAMK	3934871591 Dell Way	\N	OQPJMFU	AR	78641	US	1	NNCDBHBAMK@dell.com	3934871591	1	8396578761748970	2009/06	user45	password	28	40000	M
46	TBZFPM	ISOQTOCDDS	5928516639 Dell Way	\N	TMFZGGS	NH	38220	US	1	ISOQTOCDDS@dell.com	5928516639	5	8143781044054777	2011/04	user46	password	75	60000	F
47	URXHAP	VQJJTNNMGZ	1468092885 Dell Way	\N	RFGYYVG	MO	79543	US	1	VQJJTNNMGZ@dell.com	1468092885	1	1439432312734425	2012/08	user47	password	45	80000	F
48	HXIXSY	GCSTPEAPVF	5164479008 Dell Way	\N	VUEQBRK	CO	85154	US	1	GCSTPEAPVF@dell.com	5164479008	5	5145818285178393	2012/07	user48	password	73	20000	F
49	CAFAHI	TAYXBNTGIN	4483097562 Dell Way	\N	LZPCJRY	TX	65999	US	1	TAYXBNTGIN@dell.com	4483097562	4	2767849665600806	2008/10	user49	password	67	40000	M
50	XGCFAD	DXERQLZEWY	3309250755 Dell Way	\N	TYILWEB	ID	87593	US	1	DXERQLZEWY@dell.com	3309250755	3	7016217195894570	2012/08	user50	password	53	100000	M
51	PBXSEV	WWMHVQDUKC	8443500542 Dell Way	\N	DWZHXGE	DE	70302	US	1	WWMHVQDUKC@dell.com	8443500542	1	3863717397209257	2009/12	user51	password	35	100000	M
52	EPEZLA	LTVCXQNZTJ	3004564116 Dell Way	\N	ZBGGFLX	AL	57677	US	1	LTVCXQNZTJ@dell.com	3004564116	2	5146914470475167	2010/03	user52	password	49	80000	M
53	PPHQAA	MDYCQYVZXX	7102610410 Dell Way	\N	GDCRBDF	ID	52077	US	1	MDYCQYVZXX@dell.com	7102610410	4	7402909262105823	2008/05	user53	password	58	80000	M
54	WIZWUC	VXTTSTQPZU	1023603196 Dell Way	\N	SRVVXDH	NE	86106	US	1	VXTTSTQPZU@dell.com	1023603196	4	2668283766135573	2010/05	user54	password	26	60000	M
55	BHNECK	XVDQMTQHMH	3574669247 Dell Way	\N	DHFGOUC	NE	51427	US	1	XVDQMTQHMH@dell.com	3574669247	1	8774650241713972	2009/07	user55	password	61	60000	M
56	DQXOOT	REGLVOXDRF	4761523925 Dell Way	\N	IYUCBJO	KS	53642	US	1	REGLVOXDRF@dell.com	4761523925	4	1167002467904239	2008/03	user56	password	79	20000	M
57	TSKNJP	UVKITNAYWY	6110351941 Dell Way	\N	SYABMIO	VT	15705	US	1	UVKITNAYWY@dell.com	6110351941	5	3408206243067980	2010/01	user57	password	26	20000	M
58	NRECLZ	NUTBURXTJV	4833048217 Dell Way	\N	TLICZGE	ND	25277	US	1	NUTBURXTJV@dell.com	4833048217	5	3229167290963232	2010/02	user58	password	19	20000	M
59	EEGERB	XSWOPPYLJK	4842132323 Dell Way	\N	UMKAQZE	AR	94176	US	1	XSWOPPYLJK@dell.com	4842132323	3	1609264146536588	2010/08	user59	password	82	80000	M
60	DUNFRG	BGWRFHAPBM	9649127091 Dell Way	\N	ZBCYGEX	NY	77389	US	1	BGWRFHAPBM@dell.com	9649127091	1	4611537483520806	2012/09	user60	password	34	100000	M
61	TEFZGL	VXQCXGEKGG	8449346521 Dell Way	\N	NFNRCEL	AR	37621	US	1	VXQCXGEKGG@dell.com	8449346521	5	1476791314315050	2008/11	user61	password	60	80000	F
62	UTHGOF	WRDDWNJCBO	2219900888 Dell Way	\N	PSQUDRC	WV	61548	US	1	WRDDWNJCBO@dell.com	2219900888	1	5048757464159280	2011/10	user62	password	55	60000	M
63	VTDAQU	DTQRCTSRIL	1055097560 Dell Way	\N	HCPZFOO	KS	64664	US	1	DTQRCTSRIL@dell.com	1055097560	1	4810401593800634	2010/07	user63	password	90	40000	F
64	DJYXMR	OEUIWLRITU	5734550591 Dell Way	\N	XSZMHHC	IL	41518	US	1	OEUIWLRITU@dell.com	5734550591	5	9145867860410364	2010/02	user64	password	32	80000	M
65	DOAUDE	PLBACKUWHM	4563891355 Dell Way	\N	VUUDXBM	MI	89266	US	1	PLBACKUWHM@dell.com	4563891355	5	1298333559185266	2010/07	user65	password	57	80000	F
66	ONGTCS	UDVEXRMKNH	2559052903 Dell Way	\N	ERFGEQD	ND	62223	US	1	UDVEXRMKNH@dell.com	2559052903	1	2450195379555225	2011/11	user66	password	39	40000	F
67	OANHVR	CAOUMZIUEZ	4337782111 Dell Way	\N	ZLDQOSF	OR	87650	US	1	CAOUMZIUEZ@dell.com	4337782111	3	7699506011325867	2011/09	user67	password	29	40000	M
68	RNOIPO	XKBWSWASWL	2521982461 Dell Way	\N	WMAORTL	AZ	29353	US	1	XKBWSWASWL@dell.com	2521982461	4	9546184672508390	2009/12	user68	password	69	100000	F
69	GICVFN	XCFTCYPOUC	5621417868 Dell Way	\N	PIUJUVO	WA	61844	US	1	XCFTCYPOUC@dell.com	5621417868	2	5908201500773430	2009/04	user69	password	20	60000	M
70	DIUQFW	WYZUOOOQDX	4579724741 Dell Way	\N	LMRHBQW	ND	90023	US	1	WYZUOOOQDX@dell.com	4579724741	4	2270859372802078	2010/03	user70	password	69	60000	M
71	MFTJBS	IWHWKYZIJM	7151078438 Dell Way	\N	AQNQNCO	VA	86660	US	1	IWHWKYZIJM@dell.com	7151078438	2	1909482368268072	2009/11	user71	password	66	100000	F
72	LGDDOA	LLKJKTTXUK	5076143849 Dell Way	\N	KLXNZVJ	NV	22494	US	1	LLKJKTTXUK@dell.com	5076143849	1	1294616055209189	2008/12	user72	password	27	60000	F
73	HRTHDE	SNPLGMGRXR	5940442139 Dell Way	\N	OKQJTHN	GA	42285	US	1	SNPLGMGRXR@dell.com	5940442139	2	3680636959616095	2011/11	user73	password	52	100000	M
74	FGRJYE	YKLKQCIHRS	9144738893 Dell Way	\N	YAMGORP	CO	97924	US	1	YKLKQCIHRS@dell.com	9144738893	4	8466012486256660	2009/09	user74	password	45	60000	M
75	AYXFXH	QIYSQFJJEK	3559184079 Dell Way	\N	VKZMABL	WA	86608	US	1	QIYSQFJJEK@dell.com	3559184079	2	6260699358303100	2011/11	user75	password	58	80000	M
76	LXTTNB	RGSXQBBBWM	5843842130 Dell Way	\N	AJNCULY	CA	77025	US	1	RGSXQBBBWM@dell.com	5843842130	4	6731045445892960	2008/06	user76	password	53	60000	F
77	FIWHZC	ZXTBZUYMVH	8203956428 Dell Way	\N	ZYCKXEE	ME	91924	US	1	ZXTBZUYMVH@dell.com	8203956428	3	4091474133078009	2009/01	user77	password	67	60000	F
78	NUJQUH	KWGFUTABSZ	5901074984 Dell Way	\N	DDWHHHF	CA	83709	US	1	KWGFUTABSZ@dell.com	5901074984	2	9049576921388508	2009/11	user78	password	38	80000	M
79	RKMYUI	FZCYADRAHU	8947035148 Dell Way	\N	WOCETEZ	IN	60391	US	1	FZCYADRAHU@dell.com	8947035148	3	5019842551089823	2008/04	user79	password	27	100000	M
80	QULYZL	BYMFPMMKJA	7038885902 Dell Way	\N	MNURNCF	MD	66172	US	1	BYMFPMMKJA@dell.com	7038885902	3	9086241888813676	2012/05	user80	password	59	60000	F
81	AJEMKC	ZPSLCCVCPI	5684336516 Dell Way	\N	XGWZMGQ	DC	85073	US	1	ZPSLCCVCPI@dell.com	5684336516	5	3071253094356507	2008/05	user81	password	47	20000	M
82	OPEROU	KAWNVYDEWJ	4250067926 Dell Way	\N	AWWHMAD	WY	98473	US	1	KAWNVYDEWJ@dell.com	4250067926	1	4282251605298370	2011/03	user82	password	26	40000	M
83	HAJBLJ	XZEWCJSMJP	7328085613 Dell Way	\N	IRBJVBI	DE	23592	US	1	XZEWCJSMJP@dell.com	7328085613	5	4187984682153911	2012/04	user83	password	29	20000	F
84	NDTWBS	BYVKQHUGPM	8804140647 Dell Way	\N	HZHJHLN	AK	45455	US	1	BYVKQHUGPM@dell.com	8804140647	5	7080934641417117	2008/12	user84	password	90	60000	F
85	TKDMLB	HWSORYEDGE	9566648908 Dell Way	\N	LPMWCMH	WV	36979	US	1	HWSORYEDGE@dell.com	9566648908	5	2994280820246786	2012/07	user85	password	39	80000	M
86	KEKMMG	EAYCFBIJMY	8481905861 Dell Way	\N	VJAIQAP	NH	10347	US	1	EAYCFBIJMY@dell.com	8481905861	3	5738052499946207	2008/03	user86	password	50	60000	F
87	VAWCEX	AGDCPNPNJZ	1912388650 Dell Way	\N	ORQOHFO	CO	79369	US	1	AGDCPNPNJZ@dell.com	1912388650	2	1135459203738719	2010/10	user87	password	49	40000	M
88	IMYGNF	JPVWEIGDXX	7842002899 Dell Way	\N	TMEZBHT	DC	54656	US	1	JPVWEIGDXX@dell.com	7842002899	4	3349915018305182	2008/02	user88	password	20	60000	M
89	ZTBECR	ZZVIFZFDSR	3881306276 Dell Way	\N	HSTOLWB	GA	61593	US	1	ZZVIFZFDSR@dell.com	3881306276	2	6911563112400473	2009/11	user89	password	34	40000	M
90	HMTYMT	UVZTACMSJE	6012148553 Dell Way	\N	LYPIAUX	KS	27127	US	1	UVZTACMSJE@dell.com	6012148553	4	1807652772404253	2011/12	user90	password	71	20000	F
91	MAZFUU	ENVGZNQDZP	8338619980 Dell Way	\N	TIPNFXS	RI	61453	US	1	ENVGZNQDZP@dell.com	8338619980	3	6087300324812532	2010/08	user91	password	22	20000	M
92	BFKVKY	QQXEHBEWUM	5313838823 Dell Way	\N	LISIBMX	UT	12099	US	1	QQXEHBEWUM@dell.com	5313838823	3	6740367790218443	2010/06	user92	password	36	60000	M
93	RKAPBR	MGZOKVIXHR	7656402342 Dell Way	\N	PQSCNPC	AK	98954	US	1	MGZOKVIXHR@dell.com	7656402342	3	4691996377892792	2012/02	user93	password	21	80000	M
94	CGPUTV	THGPQDWHTM	1007417866 Dell Way	\N	AVAPYAP	NY	61905	US	1	THGPQDWHTM@dell.com	1007417866	4	7348126735538245	2008/05	user94	password	35	20000	M
95	VXIRRQ	XGHBCPUPPQ	9091236773 Dell Way	\N	PFOQUGF	SD	91490	US	1	XGHBCPUPPQ@dell.com	9091236773	5	3153780541848391	2008/01	user95	password	78	100000	M
96	EQPUNV	CPYRKNHACN	9652656132 Dell Way	\N	PSIVXDS	SD	97822	US	1	CPYRKNHACN@dell.com	9652656132	5	9816991902422160	2011/12	user96	password	83	100000	M
97	MTCIVR	GNBTVBWIQP	7278548154 Dell Way	\N	QMMTEHS	DC	32789	US	1	GNBTVBWIQP@dell.com	7278548154	5	2557797038927674	2010/11	user97	password	70	20000	M
98	UKMMQA	NKVPGDGVTS	1547526094 Dell Way	\N	INXQFBX	WA	99947	US	1	NKVPGDGVTS@dell.com	1547526094	3	9011170953046532	2011/08	user98	password	57	60000	F
99	ABRAPB	WEIZKETDNH	9885368844 Dell Way	\N	ADNCALC	CA	95338	US	1	WEIZKETDNH@dell.com	9885368844	5	6015513976104558	2010/06	user99	password	59	60000	M
100	FPCHLG	QLRUFUHMVL	9250484007 Dell Way	\N	ZYLKBNJ	AL	45808	US	1	QLRUFUHMVL@dell.com	9250484007	3	8659899443387986	2010/02	user100	password	44	80000	M
101	LADSQO	JKUESHADGZ	4081060163 Dell Way	\N	ORACABM	WI	63156	US	1	JKUESHADGZ@dell.com	4081060163	3	7210860711988062	2011/02	user101	password	45	20000	F
102	NWTCGE	WLWDLZKLNB	7874303452 Dell Way	\N	LQCMDBB	MN	52679	US	1	WLWDLZKLNB@dell.com	7874303452	1	6542575670871884	2008/04	user102	password	73	80000	F
103	NSKRPV	OTHNDSBFER	4941352913 Dell Way	\N	HQVJSHV	MO	49863	US	1	OTHNDSBFER@dell.com	4941352913	4	7841232322156430	2008/04	user103	password	86	80000	M
104	IKPEYI	MMMENRIFZZ	5599346700 Dell Way	\N	AISIDET	NE	82321	US	1	MMMENRIFZZ@dell.com	5599346700	4	1622023951262235	2010/06	user104	password	22	80000	M
105	QZWZLI	LPWCYBCYCK	7270570272 Dell Way	\N	QKOVEDQ	NY	92320	US	1	LPWCYBCYCK@dell.com	7270570272	1	4695855054073036	2011/11	user105	password	40	60000	M
106	EKHMVX	IYWKAUNLLY	5127891259 Dell Way	\N	ZGCDXUB	NH	90730	US	1	IYWKAUNLLY@dell.com	5127891259	2	8246030778624118	2011/10	user106	password	67	100000	F
107	ZKZXTY	TEZORKZQKG	2817086674 Dell Way	\N	SNDMPTK	AR	17360	US	1	TEZORKZQKG@dell.com	2817086674	5	8563901439309121	2012/09	user107	password	90	100000	F
108	ZTXXMC	WAUGAKRHDF	1721490290 Dell Way	\N	LQUEAVG	HI	68232	US	1	WAUGAKRHDF@dell.com	1721490290	1	4522647375240922	2008/12	user108	password	58	20000	M
109	MYEOUF	IBGSTNWYYM	6452446201 Dell Way	\N	TCMOJSF	ME	83040	US	1	IBGSTNWYYM@dell.com	6452446201	3	7893348607234658	2008/07	user109	password	51	80000	F
110	QEHWNI	DGCQCAPOTS	4109508464 Dell Way	\N	BIBTNMP	DC	98040	US	1	DGCQCAPOTS@dell.com	4109508464	2	5642515898682178	2012/12	user110	password	90	60000	F
111	GIQPLW	RCYSRNLJOU	4645878337 Dell Way	\N	LIIXXLX	ID	77448	US	1	RCYSRNLJOU@dell.com	4645878337	1	7074275085236878	2009/07	user111	password	75	80000	M
112	KHHGYJ	FRBSDKHXWQ	1754146260 Dell Way	\N	FTORQVK	AR	90684	US	1	FRBSDKHXWQ@dell.com	1754146260	3	4792518061585725	2012/02	user112	password	37	40000	F
113	ONJXTA	ZMDJUAGKGZ	2079674498 Dell Way	\N	ZXQUHSS	MA	24662	US	1	ZMDJUAGKGZ@dell.com	2079674498	2	3534821788780391	2009/07	user113	password	67	100000	F
114	AWUAVH	EFBFLMLLLI	3189182691 Dell Way	\N	CGQUYAZ	AZ	36056	US	1	EFBFLMLLLI@dell.com	3189182691	3	8334010239224882	2012/05	user114	password	81	100000	F
115	RZCYDH	ZISMUEXDGE	9050788475 Dell Way	\N	TBCUAEC	ID	66758	US	1	ZISMUEXDGE@dell.com	9050788475	1	1235684926621615	2011/02	user115	password	38	60000	F
116	JKGQKO	JWJNTMUYFV	8858951903 Dell Way	\N	BAWFCCW	WY	35427	US	1	JWJNTMUYFV@dell.com	8858951903	4	4559770044870675	2008/03	user116	password	53	60000	M
117	SEZHNV	QBPCVNIROJ	3862314451 Dell Way	\N	NULQQLX	MS	28694	US	1	QBPCVNIROJ@dell.com	3862314451	4	4628714819438756	2012/03	user117	password	89	60000	F
118	YUWULX	JOTWXLLHZF	8102950769 Dell Way	\N	SPVENIK	TN	99033	US	1	JOTWXLLHZF@dell.com	8102950769	4	2408726370427757	2011/02	user118	password	53	80000	M
119	IMKGWZ	ZTXLEEKKXZ	7448935926 Dell Way	\N	GBNOLJO	IA	10295	US	1	ZTXLEEKKXZ@dell.com	7448935926	1	2482879911083728	2008/09	user119	password	27	60000	F
120	OUCOUV	LFAPPKNPQO	6595474595 Dell Way	\N	CFALUHL	MO	37519	US	1	LFAPPKNPQO@dell.com	6595474595	4	1476338486187160	2011/03	user120	password	39	40000	M
121	KWTFHZ	GXOQKDHZFM	6798147794 Dell Way	\N	ARGHDTP	PA	49164	US	1	GXOQKDHZFM@dell.com	6798147794	3	6879583658184857	2012/10	user121	password	65	40000	M
122	KOZJVW	YLGBTFHGFZ	4065978990 Dell Way	\N	NNDGCWR	OR	45437	US	1	YLGBTFHGFZ@dell.com	4065978990	4	2960724868346006	2012/01	user122	password	83	60000	M
123	WUKSSW	YUPECVKBIX	7123033009 Dell Way	\N	EPZBGTM	NJ	47412	US	1	YUPECVKBIX@dell.com	7123033009	3	4887257677968592	2010/01	user123	password	19	60000	M
124	KDNGCI	VGKRRMZORP	2220276636 Dell Way	\N	OTWHFLS	UT	14819	US	1	VGKRRMZORP@dell.com	2220276636	3	1511949831619858	2008/11	user124	password	79	60000	F
125	JVCRQJ	CIAOIPFXDY	3776657381 Dell Way	\N	TLDFDAG	ID	53111	US	1	CIAOIPFXDY@dell.com	3776657381	3	4190435957163572	2008/12	user125	password	44	60000	M
126	MFLVHT	WVBLBZPASA	1160092385 Dell Way	\N	EXDEEKR	MN	84486	US	1	WVBLBZPASA@dell.com	1160092385	4	8194721666630358	2009/02	user126	password	60	100000	F
127	ARPTOL	VZMUPMMPQK	8003738523 Dell Way	\N	TVODMAZ	MT	68240	US	1	VZMUPMMPQK@dell.com	8003738523	5	8104929108172656	2009/09	user127	password	27	40000	F
128	TDZEYZ	RTOEGDVRWQ	7115704372 Dell Way	\N	FADGAQX	SC	58787	US	1	RTOEGDVRWQ@dell.com	7115704372	1	3566918413620442	2012/07	user128	password	69	60000	M
129	RSPQKJ	EOPIJGFAMG	6569254887 Dell Way	\N	DSGUPAI	IL	25921	US	1	EOPIJGFAMG@dell.com	6569254887	1	7207910898141564	2009/08	user129	password	42	20000	F
130	YRUHWI	XESDJSQQWJ	7879493371 Dell Way	\N	WQZXZGB	NH	42082	US	1	XESDJSQQWJ@dell.com	7879493371	5	1020454077515751	2008/12	user130	password	45	20000	M
131	DILMFQ	EJAXZQTJMJ	9370650948 Dell Way	\N	IJJOLYY	HI	89715	US	1	EJAXZQTJMJ@dell.com	9370650948	2	8417101474478842	2009/05	user131	password	48	60000	M
132	WYWMCG	MZFCTOPDXZ	2364824409 Dell Way	\N	MLLLKQI	KS	97547	US	1	MZFCTOPDXZ@dell.com	2364824409	4	3896020112093538	2010/01	user132	password	90	60000	F
133	WXDCKC	IMWXCZUBLG	4938118819 Dell Way	\N	MXQDFYD	MA	61179	US	1	IMWXCZUBLG@dell.com	4938118819	5	6804848136845977	2010/05	user133	password	65	40000	F
134	UJRXSE	TPHSJIEQVB	4649670859 Dell Way	\N	GZHECRT	MT	64118	US	1	TPHSJIEQVB@dell.com	4649670859	5	9834340581204744	2008/03	user134	password	38	100000	M
135	ZSHELX	LEHTIXPJDO	9021567530 Dell Way	\N	QIQICEX	MS	19756	US	1	LEHTIXPJDO@dell.com	9021567530	3	4042470287531614	2008/05	user135	password	87	20000	F
136	GHODSS	LMAICKLQBU	9031787945 Dell Way	\N	HJWLGJO	DE	93829	US	1	LMAICKLQBU@dell.com	9031787945	2	3841774760745466	2012/06	user136	password	48	20000	M
137	ZGMRRZ	RZBCLRDFZM	7600041415 Dell Way	\N	CKTMZXK	TX	31046	US	1	RZBCLRDFZM@dell.com	7600041415	4	7242152146063746	2008/10	user137	password	50	20000	F
138	XUSWLR	YODPRJPEMA	7706483551 Dell Way	\N	XYZVJVB	CO	57975	US	1	YODPRJPEMA@dell.com	7706483551	2	3907713198103011	2008/05	user138	password	43	20000	F
139	BZPTXD	WNVFDZRDWQ	8008482630 Dell Way	\N	CSZXTCL	MO	41216	US	1	WNVFDZRDWQ@dell.com	8008482630	4	7346554525196553	2008/10	user139	password	79	20000	M
140	LXSOUG	JZJIRMFHOX	4891437624 Dell Way	\N	HMRJYDS	OK	84489	US	1	JZJIRMFHOX@dell.com	4891437624	5	6533029990736396	2009/01	user140	password	46	80000	M
141	CHSIQS	RZJDFQSDYE	4451610678 Dell Way	\N	UIDYBVT	MO	71554	US	1	RZJDFQSDYE@dell.com	4451610678	4	7439413087442518	2011/06	user141	password	66	100000	M
142	JEJCWJ	LZPCSSAWNI	3047343803 Dell Way	\N	ZLJVFWN	NJ	63033	US	1	LZPCSSAWNI@dell.com	3047343803	2	1315480657387524	2012/04	user142	password	73	40000	F
143	DJHMUH	CXZVXWIGVU	1903096573 Dell Way	\N	QRAMEQB	ME	12305	US	1	CXZVXWIGVU@dell.com	1903096573	2	3506011716555804	2012/07	user143	password	70	100000	M
144	AMSHOQ	HKNDSUZNKQ	5440590231 Dell Way	\N	OXVEYGF	AR	59430	US	1	HKNDSUZNKQ@dell.com	5440590231	5	2107666220050305	2009/11	user144	password	21	40000	F
145	UNYKUI	YXBSWPDNDA	3522341788 Dell Way	\N	JIZPOAE	AR	95317	US	1	YXBSWPDNDA@dell.com	3522341788	2	8590224726591260	2009/06	user145	password	34	20000	M
146	EMUNLR	PDOFHCJHLR	1861340140 Dell Way	\N	GBGHFHG	MS	60245	US	1	PDOFHCJHLR@dell.com	1861340140	5	1319741338025778	2009/12	user146	password	19	60000	F
147	UAWMPA	BUHDDOPVVR	9813855180 Dell Way	\N	CDXKKKY	MS	31000	US	1	BUHDDOPVVR@dell.com	9813855180	5	2573778084479272	2008/04	user147	password	62	100000	F
148	MHXMIS	UMWICSETUI	5060410082 Dell Way	\N	QESBDFH	CO	11100	US	1	UMWICSETUI@dell.com	5060410082	1	3798310699407011	2008/11	user148	password	63	60000	F
149	NBNGVZ	CEBVIVPQMU	9064342289 Dell Way	\N	JNXOUAP	IA	19326	US	1	CEBVIVPQMU@dell.com	9064342289	2	1060866510029882	2010/11	user149	password	32	20000	M
150	SHSSKW	UGFPVWBQFO	6713663457 Dell Way	\N	NUJNJPQ	IL	89840	US	1	UGFPVWBQFO@dell.com	6713663457	4	7678243461530656	2012/11	user150	password	64	60000	F
151	JGOFAU	LPQHQGNFUI	7969281022 Dell Way	\N	OHSDYZA	ND	79849	US	1	LPQHQGNFUI@dell.com	7969281022	2	6614301770459861	2010/12	user151	password	74	80000	F
152	IAEDLT	TSKAGQUOEC	6712504583 Dell Way	\N	GIAGJPA	CT	97902	US	1	TSKAGQUOEC@dell.com	6712504583	3	9115279169287532	2010/04	user152	password	22	80000	F
153	FWTZQM	JQSZLHENNM	1207147861 Dell Way	\N	OTWDUZD	MD	57064	US	1	JQSZLHENNM@dell.com	1207147861	5	8568743811454625	2008/07	user153	password	29	40000	F
154	XHBKRS	CQEJVSXIGR	5570075807 Dell Way	\N	EKLDNVR	NC	69460	US	1	CQEJVSXIGR@dell.com	5570075807	4	2965509313158691	2011/12	user154	password	65	60000	F
155	SZWLBN	PLIHJROAVY	2624904403 Dell Way	\N	LZMHQAZ	DC	67409	US	1	PLIHJROAVY@dell.com	2624904403	5	6121233948506415	2012/05	user155	password	74	60000	F
156	QZLEOW	NWGEKGZJSZ	1288064537 Dell Way	\N	VAPVZTM	DC	60252	US	1	NWGEKGZJSZ@dell.com	1288064537	5	9553356157615782	2012/07	user156	password	40	60000	M
157	TQBQDY	WHICHRVGMV	2061304593 Dell Way	\N	WIUPUYE	SD	92565	US	1	WHICHRVGMV@dell.com	2061304593	4	4973234752193093	2010/02	user157	password	86	20000	M
158	AUVYQD	HTLYOSLKOU	5235986700 Dell Way	\N	EEOCIJA	MN	99500	US	1	HTLYOSLKOU@dell.com	5235986700	5	1709392597433179	2010/01	user158	password	75	60000	M
159	QJNUQG	FPVXBFMVJQ	8270375752 Dell Way	\N	JMZTNLS	WY	40268	US	1	FPVXBFMVJQ@dell.com	8270375752	3	4545490718446672	2010/11	user159	password	35	40000	F
160	TZVAFL	VDMAPHKGRX	4736229063 Dell Way	\N	GKLRDLA	WA	85709	US	1	VDMAPHKGRX@dell.com	4736229063	3	7071166023612023	2011/09	user160	password	81	60000	M
161	SKYDGB	QHRXRXPPDZ	9937922485 Dell Way	\N	BVCMWAI	ID	60078	US	1	QHRXRXPPDZ@dell.com	9937922485	5	3754587507341057	2012/05	user161	password	21	60000	M
162	ATZBJG	THYQWOUVPQ	8539709012 Dell Way	\N	YBMZKTN	MA	70518	US	1	THYQWOUVPQ@dell.com	8539709012	2	1063123161438852	2012/11	user162	password	72	100000	M
163	TZYZSF	YJCMDYBUWD	7051157108 Dell Way	\N	GWNZJXR	HI	25077	US	1	YJCMDYBUWD@dell.com	7051157108	1	1011314923875033	2010/01	user163	password	59	20000	M
164	MDRSBA	UOETQYPTEL	4485849114 Dell Way	\N	HEVFVBK	MT	25714	US	1	UOETQYPTEL@dell.com	4485849114	5	2577017887029797	2012/02	user164	password	28	60000	F
165	UEHVZW	ZSMXIGCUOH	1355972789 Dell Way	\N	QTCRDQW	NC	60279	US	1	ZSMXIGCUOH@dell.com	1355972789	3	6849177487194539	2008/12	user165	password	82	100000	F
166	EVCAUU	NSDTVXHCNB	1234921125 Dell Way	\N	FFFVCTJ	CT	32046	US	1	NSDTVXHCNB@dell.com	1234921125	2	2738955661188811	2012/04	user166	password	40	20000	F
167	KDXFQP	IKKGSMTURZ	2577301920 Dell Way	\N	ZNBTWEZ	VT	53841	US	1	IKKGSMTURZ@dell.com	2577301920	5	7954928710591049	2010/11	user167	password	81	100000	F
168	TCRJLC	TRUGLOYLOL	9521375513 Dell Way	\N	NHIRGFE	MI	12756	US	1	TRUGLOYLOL@dell.com	9521375513	5	9429098135326060	2012/10	user168	password	89	60000	M
169	RXJTRB	NYNCWYQHLX	8166259560 Dell Way	\N	PDEVIPW	ID	58146	US	1	NYNCWYQHLX@dell.com	8166259560	1	4229035379830748	2011/08	user169	password	39	60000	M
170	REGTSE	GUAFKIRIYU	9938818816 Dell Way	\N	MTCCQJQ	ME	49451	US	1	GUAFKIRIYU@dell.com	9938818816	1	1698986183851957	2009/08	user170	password	64	100000	M
171	WSMAYG	BERJVZIPMB	6383758055 Dell Way	\N	SOSCFCN	GA	36927	US	1	BERJVZIPMB@dell.com	6383758055	3	9211614733561874	2009/06	user171	password	68	20000	F
172	EDCKFG	CPBBXROZKC	9827637124 Dell Way	\N	RMIUZNB	NH	10719	US	1	CPBBXROZKC@dell.com	9827637124	5	5090842019300908	2011/12	user172	password	61	100000	F
173	SGHYIW	AKTSYSCBJO	4240752714 Dell Way	\N	JDOXFEX	DE	99123	US	1	AKTSYSCBJO@dell.com	4240752714	5	9316775482147932	2012/09	user173	password	90	80000	M
174	GPHCQR	WIQOKRXZBA	6616090950 Dell Way	\N	OYFSWKS	HI	32573	US	1	WIQOKRXZBA@dell.com	6616090950	1	9422093743458392	2011/11	user174	password	82	100000	F
175	EABVWK	MKUDIUFIIE	2453803311 Dell Way	\N	OBAZTGF	LA	49960	US	1	MKUDIUFIIE@dell.com	2453803311	5	3537283960264176	2008/11	user175	password	70	20000	M
176	UATEND	ZRLUWUCBJD	1612266074 Dell Way	\N	CIXIOGU	OK	32358	US	1	ZRLUWUCBJD@dell.com	1612266074	4	2124531744979322	2011/12	user176	password	18	60000	M
177	TTMWTE	INACQBMUEU	3690125030 Dell Way	\N	RMJYHCE	KY	87228	US	1	INACQBMUEU@dell.com	3690125030	1	8344086087308825	2009/09	user177	password	77	20000	F
178	IXGMFT	MIKOUESPVF	7778050487 Dell Way	\N	ZTMCYWY	HI	99138	US	1	MIKOUESPVF@dell.com	7778050487	3	7467364052310587	2010/07	user178	password	33	100000	F
179	LISFVB	QKWUCLPILJ	4419226889 Dell Way	\N	VNHRLNR	GA	15976	US	1	QKWUCLPILJ@dell.com	4419226889	4	6736056394875050	2010/08	user179	password	26	20000	M
180	VHVWXF	SRIEHQQRMD	2864315572 Dell Way	\N	ZDPNUVO	FL	63957	US	1	SRIEHQQRMD@dell.com	2864315572	4	3229760578833520	2009/10	user180	password	34	20000	F
181	BAZGTR	OXZFNQRRPU	9615864405 Dell Way	\N	HCPCRUS	UT	59176	US	1	OXZFNQRRPU@dell.com	9615864405	2	4315120882354677	2008/05	user181	password	52	40000	F
182	MMCDAA	CGOTXGISNL	9977305070 Dell Way	\N	HQCCIZQ	IN	28214	US	1	CGOTXGISNL@dell.com	9977305070	3	6033942591864616	2010/09	user182	password	86	100000	F
183	BBFBEM	PXJWFCJRKZ	5815056834 Dell Way	\N	UMIUCQZ	CA	20953	US	1	PXJWFCJRKZ@dell.com	5815056834	3	8543319231830538	2010/06	user183	password	20	60000	M
184	GOSSEP	CAVEKMOKGA	4027881849 Dell Way	\N	TBDJAFM	ND	80573	US	1	CAVEKMOKGA@dell.com	4027881849	1	3435135567095131	2009/07	user184	password	77	80000	F
185	NJHDLI	YQTLFDSFWT	6721374519 Dell Way	\N	JGTPTIJ	CA	40114	US	1	YQTLFDSFWT@dell.com	6721374519	3	8799941331148148	2010/01	user185	password	88	100000	F
186	GCXPBN	IMSMFYIYHP	2990152133 Dell Way	\N	SWJAGLJ	UT	90374	US	1	IMSMFYIYHP@dell.com	2990152133	2	9778463285882028	2008/04	user186	password	48	60000	F
187	HBMVKY	NWDMFCUUUR	5063134523 Dell Way	\N	DVXPEUM	MD	21340	US	1	NWDMFCUUUR@dell.com	5063134523	3	4950456544756890	2012/01	user187	password	80	20000	F
188	IZMHNJ	LAONUIILMD	7440923984 Dell Way	\N	JBIDOSH	WY	37322	US	1	LAONUIILMD@dell.com	7440923984	5	4178096932359040	2010/01	user188	password	51	100000	F
189	YENHPO	WDIELURPDT	3449626268 Dell Way	\N	XHHQOHX	IL	24443	US	1	WDIELURPDT@dell.com	3449626268	5	2682829477824271	2011/09	user189	password	32	80000	M
190	TZNHVQ	PABKSQOLOV	4651647065 Dell Way	\N	TEKBCRF	KY	58823	US	1	PABKSQOLOV@dell.com	4651647065	1	3582177852746099	2011/10	user190	password	32	40000	M
191	SQPIGQ	JQIAEUOAOS	9312927970 Dell Way	\N	KPUCVDQ	HI	30690	US	1	JQIAEUOAOS@dell.com	9312927970	5	9968570222612472	2008/03	user191	password	72	100000	M
192	IDBYNR	HNWBCWQVGF	9945151528 Dell Way	\N	QJBTZHZ	VT	20452	US	1	HNWBCWQVGF@dell.com	9945151528	1	3657055824529380	2011/11	user192	password	25	20000	M
193	DBNVIB	RKDNAZUGPD	9899340102 Dell Way	\N	HJDPJBS	KY	17662	US	1	RKDNAZUGPD@dell.com	9899340102	1	9476211321074516	2008/03	user193	password	86	40000	F
194	LBOMSY	QGZQAFFENO	4313723413 Dell Way	\N	HCXIUGL	RI	41702	US	1	QGZQAFFENO@dell.com	4313723413	5	5750362674240023	2009/02	user194	password	72	80000	F
195	HGWGXC	FNCLSHYHOA	4104551268 Dell Way	\N	FXVMIPV	OH	50286	US	1	FNCLSHYHOA@dell.com	4104551268	1	5839422373566777	2008/10	user195	password	67	40000	F
196	NQXPVL	SGEZFLOFRL	6541135995 Dell Way	\N	BDUQYMC	IL	54277	US	1	SGEZFLOFRL@dell.com	6541135995	2	3270581658463925	2009/10	user196	password	37	100000	F
197	ELFQEM	UDRGSXYEZB	2696203470 Dell Way	\N	YPALRHY	IL	71710	US	1	UDRGSXYEZB@dell.com	2696203470	3	5081255959346891	2010/05	user197	password	79	80000	M
198	BHZOCD	GJVEHADJZT	8223866562 Dell Way	\N	JKKRIRJ	NC	34094	US	1	GJVEHADJZT@dell.com	8223866562	5	6962987584527583	2011/08	user198	password	53	80000	M
199	MHAPOJ	LSQLWAKPJV	6475307981 Dell Way	\N	ZAERJSY	FL	71865	US	1	LSQLWAKPJV@dell.com	6475307981	5	3916127920616418	2008/07	user199	password	35	60000	M
200	GEJPQC	GCYGMOQINQ	2739437763 Dell Way	\N	MFAEDFW	PA	12572	US	1	GCYGMOQINQ@dell.com	2739437763	5	6217044524848462	2010/06	user200	password	48	80000	M
201	UHFXOI	WVUKLDYCPD	9292288565 Dell Way	\N	CUHIQBI	TX	91453	US	1	WVUKLDYCPD@dell.com	9292288565	2	4009823579341173	2009/12	user201	password	86	20000	F
202	EBVMXQ	HHBKFEAJGU	9389964211 Dell Way	\N	QPLSXHP	TN	60828	US	1	HHBKFEAJGU@dell.com	9389964211	1	5774560738354922	2012/04	user202	password	75	20000	F
203	PNHGUP	HFULFESZVH	8229181451 Dell Way	\N	LNFSCBH	AL	32047	US	1	HFULFESZVH@dell.com	8229181451	5	6141538870055229	2010/12	user203	password	86	20000	F
204	FLHUTM	PERTXRPFCC	3734459121 Dell Way	\N	LVEMCFT	VA	22085	US	1	PERTXRPFCC@dell.com	3734459121	3	1788752209395170	2009/09	user204	password	59	60000	F
205	WGVIWA	AQYSFDUHOP	9479539791 Dell Way	\N	MBSSUPW	CA	15183	US	1	AQYSFDUHOP@dell.com	9479539791	2	7613272601738573	2010/10	user205	password	79	40000	F
206	RRYSSO	QKUUFCIVPJ	8896107254 Dell Way	\N	NHECEGD	CO	62598	US	1	QKUUFCIVPJ@dell.com	8896107254	4	4463152668438852	2011/12	user206	password	50	60000	M
207	JCJYTT	TNZVWUKGHS	6620438987 Dell Way	\N	KJWRNZG	MA	62527	US	1	TNZVWUKGHS@dell.com	6620438987	1	5915406333282590	2008/07	user207	password	32	60000	M
208	OKJIDX	HZTBJZICJS	1608915044 Dell Way	\N	ZAFYHQN	VT	75419	US	1	HZTBJZICJS@dell.com	1608915044	5	3160989703610539	2009/06	user208	password	80	100000	M
209	FDZDKY	WLIVUKFNJG	3792013392 Dell Way	\N	SINIVLB	VA	47264	US	1	WLIVUKFNJG@dell.com	3792013392	1	8617610038723797	2008/12	user209	password	67	60000	F
210	RNMPJY	YFTILGSRZA	9294354440 Dell Way	\N	FHVRJTB	OH	91125	US	1	YFTILGSRZA@dell.com	9294354440	5	8862436947878451	2011/04	user210	password	88	40000	M
211	LWEKUJ	DDUJVMIWSQ	2891817942 Dell Way	\N	SJALLSI	LA	60840	US	1	DDUJVMIWSQ@dell.com	2891817942	5	8434869633987547	2008/03	user211	password	62	80000	F
212	TAXDEB	YOXKWTDNLM	6715788093 Dell Way	\N	OWYGFIV	ME	35406	US	1	YOXKWTDNLM@dell.com	6715788093	3	5721002531237901	2009/03	user212	password	64	20000	F
213	ODLPBZ	MMWGPKRCYN	2254211018 Dell Way	\N	AETIZEP	NJ	77374	US	1	MMWGPKRCYN@dell.com	2254211018	5	9806594968773426	2011/11	user213	password	36	40000	M
214	RYARLN	NRCXJEWXFA	5600068507 Dell Way	\N	QNZUDPN	IL	50786	US	1	NRCXJEWXFA@dell.com	5600068507	1	3759584844112396	2011/05	user214	password	39	60000	F
215	IDUVRM	YPVCLSILJV	8129480423 Dell Way	\N	LDZARHM	FL	41801	US	1	YPVCLSILJV@dell.com	8129480423	5	7870392904616893	2008/05	user215	password	26	60000	M
216	YGEKET	GHEZPPILBM	8348967875 Dell Way	\N	KCDSOIB	LA	32561	US	1	GHEZPPILBM@dell.com	8348967875	3	6714487021323294	2012/11	user216	password	28	100000	F
217	HHGBNN	FNCVVNWHYY	6630870131 Dell Way	\N	LQNTSWZ	MT	38083	US	1	FNCVVNWHYY@dell.com	6630870131	3	2411882798187434	2011/04	user217	password	35	20000	M
218	MCDAIQ	DELQBTPAEG	8816522961 Dell Way	\N	NYYKXLS	NC	90322	US	1	DELQBTPAEG@dell.com	8816522961	2	2886030686553567	2008/05	user218	password	76	80000	F
219	YQVOTZ	AJAUZBYFOW	7071810956 Dell Way	\N	DZUORIM	NC	67869	US	1	AJAUZBYFOW@dell.com	7071810956	4	1136976864654570	2010/04	user219	password	54	60000	M
220	IZPIZZ	JUZKTEYQHX	4715606254 Dell Way	\N	KWPTIDK	AK	82093	US	1	JUZKTEYQHX@dell.com	4715606254	3	1535790319554507	2012/11	user220	password	86	40000	M
221	OOWOXQ	NHJSGZZEKW	8024583176 Dell Way	\N	UEFXOGS	WV	76164	US	1	NHJSGZZEKW@dell.com	8024583176	5	6799417681992055	2011/02	user221	password	56	40000	M
222	KVPBIW	LADLAHVXCA	7707627258 Dell Way	\N	DAPJSOC	MS	51144	US	1	LADLAHVXCA@dell.com	7707627258	2	6317456409800798	2009/06	user222	password	38	80000	F
223	WSQTDR	WPSELQGLTG	6681761544 Dell Way	\N	ADZPFMB	WV	74144	US	1	WPSELQGLTG@dell.com	6681761544	2	2820148667786270	2012/11	user223	password	55	80000	M
224	ENUVKJ	OOUEVFYCGB	5551250048 Dell Way	\N	CVGPWFH	MS	50947	US	1	OOUEVFYCGB@dell.com	5551250048	3	4249738764483482	2008/03	user224	password	90	20000	M
225	UACDOR	XTNDRQKSSF	1099968377 Dell Way	\N	ZHCFPPQ	CO	11112	US	1	XTNDRQKSSF@dell.com	1099968377	1	2746653990820050	2008/04	user225	password	83	80000	F
226	ZXXQVQ	DZITJAMPAU	5399641553 Dell Way	\N	RFKHVNH	TX	67610	US	1	DZITJAMPAU@dell.com	5399641553	5	9522778161801400	2009/08	user226	password	37	40000	M
227	EAIUEI	DYRDKGDFYI	7172292935 Dell Way	\N	PFECNBT	WY	90665	US	1	DYRDKGDFYI@dell.com	7172292935	2	5701220414135606	2012/09	user227	password	21	20000	M
228	KYXSBV	JEGQILORAT	3775013622 Dell Way	\N	WCHXWHU	NC	68429	US	1	JEGQILORAT@dell.com	3775013622	3	4475123568437994	2009/08	user228	password	27	80000	M
229	ALPWVT	CLCNZTNTPQ	4128732778 Dell Way	\N	BNMIHAY	NH	56647	US	1	CLCNZTNTPQ@dell.com	4128732778	5	2197880040388554	2010/09	user229	password	67	60000	F
230	GJZALL	CYLWMFMCGZ	3326815737 Dell Way	\N	POHPNWD	TX	83829	US	1	CYLWMFMCGZ@dell.com	3326815737	2	5715942581649870	2012/11	user230	password	67	20000	F
231	RFQCIO	NFASRDZRSN	2425690554 Dell Way	\N	YIAVLXQ	OH	29790	US	1	NFASRDZRSN@dell.com	2425690554	4	1508830762002617	2012/10	user231	password	35	60000	F
232	WPILDO	MWFPVXHJVP	5860990967 Dell Way	\N	JRBGHTM	MN	43816	US	1	MWFPVXHJVP@dell.com	5860990967	2	2722737114410847	2011/10	user232	password	33	80000	F
233	OCOCOL	IDGFLPBBZT	4646948505 Dell Way	\N	CGAVTMF	IL	79997	US	1	IDGFLPBBZT@dell.com	4646948505	1	6232737744227052	2011/09	user233	password	90	20000	M
234	OHJZPN	GVYVXZVQCC	5718193571 Dell Way	\N	RXVEDCY	NC	24319	US	1	GVYVXZVQCC@dell.com	5718193571	1	8901934914756567	2010/04	user234	password	68	20000	M
235	BBFOHB	NCZMYQOAIM	9853886479 Dell Way	\N	WMQYKEC	WI	37824	US	1	NCZMYQOAIM@dell.com	9853886479	3	6780904320999981	2011/07	user235	password	36	80000	M
236	MHVNUY	NHXDWYLIUY	1565292418 Dell Way	\N	YSICVHK	SD	76908	US	1	NHXDWYLIUY@dell.com	1565292418	3	3436183401383460	2009/03	user236	password	79	80000	M
237	RIHQWO	NZLLLTGJSY	1059322345 Dell Way	\N	SVUZGPT	KS	17902	US	1	NZLLLTGJSY@dell.com	1059322345	4	3707163629587740	2012/06	user237	password	76	60000	M
238	CDPRRP	CDBWJKPIDK	1863348993 Dell Way	\N	CCRSWZU	TX	67106	US	1	CDBWJKPIDK@dell.com	1863348993	4	1597759217489510	2012/03	user238	password	78	100000	F
239	LRBBTE	CQNNFWQQYT	1035903769 Dell Way	\N	HRPHMLY	ND	22996	US	1	CQNNFWQQYT@dell.com	1035903769	3	4281205979641527	2012/06	user239	password	71	40000	F
240	UIWYLM	MYRIOIHHPZ	8532190868 Dell Way	\N	WXLIWZM	TX	50462	US	1	MYRIOIHHPZ@dell.com	8532190868	4	9071420274209232	2010/12	user240	password	18	40000	F
241	WHSIUR	ADFILNYKKW	2585578940 Dell Way	\N	VSSVEPH	AL	34847	US	1	ADFILNYKKW@dell.com	2585578940	3	3266492069233209	2008/12	user241	password	58	20000	F
242	HKAYKE	ETPRSZBOVU	4533164555 Dell Way	\N	HRZWYZD	CT	63213	US	1	ETPRSZBOVU@dell.com	4533164555	2	5839909839909524	2012/05	user242	password	75	40000	M
243	VEDZIW	OZPOBDKVLB	9216089902 Dell Way	\N	UHAULDJ	SD	47729	US	1	OZPOBDKVLB@dell.com	9216089902	4	7840317948721350	2011/01	user243	password	53	60000	F
244	QMNNBN	CQOFAKRCEY	4593760254 Dell Way	\N	CZJFJFQ	ID	97140	US	1	CQOFAKRCEY@dell.com	4593760254	5	9782808824907988	2012/06	user244	password	29	60000	M
245	RAAFCR	UIREZUJYWI	5091884392 Dell Way	\N	ICRNTYM	DC	92098	US	1	UIREZUJYWI@dell.com	5091884392	1	4461169376038015	2011/07	user245	password	43	40000	M
246	JNRAHA	SLANVYKEGM	1953241795 Dell Way	\N	WUGVGJS	OK	45758	US	1	SLANVYKEGM@dell.com	1953241795	2	9423395997844636	2010/08	user246	password	54	100000	F
247	EWKEPW	FCSDMWKZSE	9178639777 Dell Way	\N	FNLOGEZ	LA	53760	US	1	FCSDMWKZSE@dell.com	9178639777	5	2033070211298763	2010/08	user247	password	36	60000	M
248	RTCNYE	FCRCNQVSWI	9242159193 Dell Way	\N	ELPIKYU	IN	77168	US	1	FCRCNQVSWI@dell.com	9242159193	4	4464414094574750	2008/04	user248	password	82	100000	F
249	ZJZEPC	VRQMMIIVMT	5333657757 Dell Way	\N	KUDJPLC	MT	25089	US	1	VRQMMIIVMT@dell.com	5333657757	4	5085826066322625	2009/07	user249	password	54	40000	M
250	MNLPJD	FVQOELAXWV	2265148245 Dell Way	\N	BFLNIYR	SC	65884	US	1	FVQOELAXWV@dell.com	2265148245	1	2131060719490051	2011/07	user250	password	90	20000	F
251	LTJPYF	FNJRNHOJIT	5319693184 Dell Way	\N	UWCTOXJ	OH	14869	US	1	FNJRNHOJIT@dell.com	5319693184	2	6145804445724935	2010/06	user251	password	62	100000	F
252	ZNEFSR	OKFWYOFSJB	3726352094 Dell Way	\N	UCPRLHT	WA	67533	US	1	OKFWYOFSJB@dell.com	3726352094	3	1990017764270305	2012/04	user252	password	41	100000	M
253	MCOERY	JNWYSPIUJK	4994618101 Dell Way	\N	KBWSUUI	CA	28395	US	1	JNWYSPIUJK@dell.com	4994618101	5	5730263859499246	2011/11	user253	password	43	40000	M
254	XKQVUD	STWHBQRMAS	8840514968 Dell Way	\N	ISMDAOI	MO	60334	US	1	STWHBQRMAS@dell.com	8840514968	2	4976068728137762	2009/07	user254	password	48	20000	M
255	BYSEQL	AXNROZRHIJ	3996292216 Dell Way	\N	TMKIVXX	OH	22516	US	1	AXNROZRHIJ@dell.com	3996292216	5	6752039397601039	2011/01	user255	password	58	80000	M
256	HZPSAN	GRCFIJOSDA	8146984087 Dell Way	\N	DMVAJNE	OH	49564	US	1	GRCFIJOSDA@dell.com	8146984087	3	5128881895449013	2009/03	user256	password	48	80000	F
257	AJFNPX	QVFZJYDKBP	7152320561 Dell Way	\N	GCYUGQF	AL	15207	US	1	QVFZJYDKBP@dell.com	7152320561	2	3552331936545670	2008/01	user257	password	53	20000	F
258	SQYPGT	VGDTJOVYUX	8619782804 Dell Way	\N	WPDNVEO	MS	58628	US	1	VGDTJOVYUX@dell.com	8619782804	3	5877144973725081	2009/09	user258	password	83	20000	F
259	VQPPLW	SFFHAEBXAR	3671714553 Dell Way	\N	BOMFCYT	WI	59568	US	1	SFFHAEBXAR@dell.com	3671714553	2	3291495500132442	2008/04	user259	password	61	20000	M
260	FPKBIP	GPQKRNLIPZ	6159762535 Dell Way	\N	VUCTOBI	TX	40758	US	1	GPQKRNLIPZ@dell.com	6159762535	1	6974036936182529	2008/01	user260	password	62	40000	M
261	AKAPRQ	FCITORIOMD	7365676672 Dell Way	\N	QGSSOOB	CT	65180	US	1	FCITORIOMD@dell.com	7365676672	2	7112545191310347	2009/09	user261	password	43	40000	F
262	JXTZDW	IXKZGYLJPR	9540433463 Dell Way	\N	CHFRIJH	AR	68569	US	1	IXKZGYLJPR@dell.com	9540433463	2	3890195515006781	2009/09	user262	password	48	80000	M
263	ERTBZQ	LYWKKGABIH	6566542046 Dell Way	\N	HAQQHSH	HI	16226	US	1	LYWKKGABIH@dell.com	6566542046	3	7873327853158117	2008/03	user263	password	45	40000	M
264	DGWUSV	QCFXCHGKPG	6326537996 Dell Way	\N	BFNTNTV	DC	33931	US	1	QCFXCHGKPG@dell.com	6326537996	1	5189834399614483	2012/05	user264	password	42	20000	M
265	FWIANL	GLONRZCYAI	9446080135 Dell Way	\N	MUWFPZM	GA	24944	US	1	GLONRZCYAI@dell.com	9446080135	1	5925173651892692	2009/04	user265	password	31	60000	F
266	NNSYTD	NGVMJUNSGH	3319631964 Dell Way	\N	OLXOYCS	UT	36223	US	1	NGVMJUNSGH@dell.com	3319631964	1	6190924708265812	2010/08	user266	password	72	100000	F
267	LXWPLD	LXMFKFMSTX	6351986862 Dell Way	\N	PHWSASA	ID	87142	US	1	LXMFKFMSTX@dell.com	6351986862	4	5325801098253578	2009/08	user267	password	62	80000	M
268	MKZPVX	CBIHNABLQI	3979425513 Dell Way	\N	HJIZJPW	WV	36049	US	1	CBIHNABLQI@dell.com	3979425513	2	9462667724583300	2012/02	user268	password	54	60000	F
269	MAIKCJ	SKWSLIJUPS	9490352484 Dell Way	\N	DPCSLBA	RI	44691	US	1	SKWSLIJUPS@dell.com	9490352484	4	5419349465984851	2010/02	user269	password	90	100000	F
270	IIGRBQ	OUCWDXMWAB	9235048020 Dell Way	\N	ZSMBSGL	NY	96633	US	1	OUCWDXMWAB@dell.com	9235048020	1	1688433615025133	2012/01	user270	password	32	40000	F
271	LXLCLG	EIJCUGCVFU	6672575523 Dell Way	\N	IGNPRFO	NH	38590	US	1	EIJCUGCVFU@dell.com	6672575523	3	4426763960160315	2012/09	user271	password	75	40000	M
272	GJBMOJ	WQEDSAINIP	9556971297 Dell Way	\N	BYHGMWO	CT	42373	US	1	WQEDSAINIP@dell.com	9556971297	5	1611147962510585	2011/03	user272	password	66	100000	M
273	SMDCIT	GLMGUZPJBO	9460061874 Dell Way	\N	QHANWDW	SD	19353	US	1	GLMGUZPJBO@dell.com	9460061874	3	3943755624815822	2011/07	user273	password	84	40000	F
274	BKIURU	HYPHOYICPP	7503574506 Dell Way	\N	DDMHZHK	WA	86553	US	1	HYPHOYICPP@dell.com	7503574506	3	4485530681908131	2011/11	user274	password	46	80000	F
275	SMYNTX	CAMBJORYSU	9755488057 Dell Way	\N	LZUTKSP	CO	32947	US	1	CAMBJORYSU@dell.com	9755488057	4	2083347867242992	2009/06	user275	password	47	20000	M
276	JPRHSS	TUBHLAAFLA	1906662633 Dell Way	\N	AEKSUNZ	PA	33723	US	1	TUBHLAAFLA@dell.com	1906662633	1	7219346944708378	2010/03	user276	password	61	100000	M
277	HDNZWH	AETBEZNEZS	1513486435 Dell Way	\N	PSMCRFJ	RI	40104	US	1	AETBEZNEZS@dell.com	1513486435	2	5840217979624868	2011/02	user277	password	43	100000	F
278	WXEEYJ	XANWNSWFIO	8074536088 Dell Way	\N	RKGXUAG	TN	38533	US	1	XANWNSWFIO@dell.com	8074536088	3	5271383880171925	2008/06	user278	password	74	20000	F
279	YFHHCI	VZVOWBWKTG	5305716901 Dell Way	\N	RQBRXWA	NY	43325	US	1	VZVOWBWKTG@dell.com	5305716901	5	8190472083631904	2009/11	user279	password	28	20000	F
280	LMDTHD	PWZQSKJZBA	1505129548 Dell Way	\N	ATXXTPG	HI	46923	US	1	PWZQSKJZBA@dell.com	1505129548	3	3246493724174797	2009/09	user280	password	38	80000	F
281	LKMOZI	OPAYZZAZAT	2223535093 Dell Way	\N	XXNMDTX	GA	30341	US	1	OPAYZZAZAT@dell.com	2223535093	3	9097498407587410	2010/01	user281	password	22	100000	F
282	NKLVZB	WYAWYZWSXT	1924203953 Dell Way	\N	FJXZGCF	MA	54346	US	1	WYAWYZWSXT@dell.com	1924203953	5	5873693423345686	2008/08	user282	password	90	80000	F
283	LNBMKZ	MGXMCQJWWT	8764344763 Dell Way	\N	TVZVBJI	DC	25809	US	1	MGXMCQJWWT@dell.com	8764344763	2	8467443868052215	2012/12	user283	password	83	40000	M
284	YTXXGE	VTGMCDIWWE	2921405410 Dell Way	\N	VRFFAJJ	UT	71047	US	1	VTGMCDIWWE@dell.com	2921405410	4	7058159681968392	2008/01	user284	password	32	20000	M
285	CZAHUT	OHWRPSNUOF	7536785773 Dell Way	\N	ATFJDBB	KY	81900	US	1	OHWRPSNUOF@dell.com	7536785773	3	8235087835229934	2012/07	user285	password	59	20000	F
286	OIHIWO	ENEWBYKGZE	2193997890 Dell Way	\N	LIINKRI	CO	20694	US	1	ENEWBYKGZE@dell.com	2193997890	1	6729655596427620	2011/01	user286	password	27	40000	F
287	KPGZTT	DQVCBBBFNK	9512775433 Dell Way	\N	NBUEJXI	MS	95962	US	1	DQVCBBBFNK@dell.com	9512775433	1	1267902967520058	2008/06	user287	password	48	60000	F
288	RMULQL	GTMHUSVFGW	9218394410 Dell Way	\N	ALFYTSW	OH	92838	US	1	GTMHUSVFGW@dell.com	9218394410	4	4492166974116117	2009/04	user288	password	50	100000	M
289	GLIRRB	EZWXUCDQCP	8941537579 Dell Way	\N	WAJOXBM	TN	83213	US	1	EZWXUCDQCP@dell.com	8941537579	1	1610873518045991	2009/02	user289	password	75	60000	M
290	DGGFLF	CIZEMQHBMH	4139329435 Dell Way	\N	KBFMOBH	MI	27849	US	1	CIZEMQHBMH@dell.com	4139329435	4	4138480763882399	2008/04	user290	password	85	40000	M
291	EMAKOI	KSVAZXNHIO	1933757302 Dell Way	\N	NUCOBOT	ME	37155	US	1	KSVAZXNHIO@dell.com	1933757302	3	6636056853458286	2008/10	user291	password	32	40000	F
292	FPWOZP	JZPHNWPBKK	6812486108 Dell Way	\N	EYMSSXA	SD	49956	US	1	JZPHNWPBKK@dell.com	6812486108	5	3440863080788404	2012/01	user292	password	59	20000	M
293	LQPAAP	PHCMXEWHIV	4270815277 Dell Way	\N	TBNQCIC	OR	25764	US	1	PHCMXEWHIV@dell.com	4270815277	3	2944905824027955	2012/08	user293	password	79	40000	F
294	LJHBZO	ELMJHURDNT	4386977421 Dell Way	\N	QEVZHOE	NM	22039	US	1	ELMJHURDNT@dell.com	4386977421	3	8001161888707430	2009/12	user294	password	21	80000	F
295	ITHXYS	JHADZDRSUW	1149060316 Dell Way	\N	OUDCYTG	KS	40469	US	1	JHADZDRSUW@dell.com	1149060316	3	3476236413698643	2008/03	user295	password	60	40000	M
296	WHXPRE	QVDUNWOJKJ	8891680955 Dell Way	\N	MNHGTQP	RI	25612	US	1	QVDUNWOJKJ@dell.com	8891680955	5	4629932022653520	2010/03	user296	password	45	40000	M
297	HYFMOA	QIOMWXXGKK	7717197769 Dell Way	\N	OREEGYI	DC	81292	US	1	QIOMWXXGKK@dell.com	7717197769	4	1234501875471323	2008/12	user297	password	58	60000	M
298	UXKUNS	JAPGXVQIKI	3569018616 Dell Way	\N	NOPMXSG	NV	40267	US	1	JAPGXVQIKI@dell.com	3569018616	4	3514434749726206	2012/03	user298	password	28	80000	F
299	OKPHTQ	XANTRWDZKR	9254136228 Dell Way	\N	OWPHCFQ	MD	10505	US	1	XANTRWDZKR@dell.com	9254136228	2	2839149499312043	2008/11	user299	password	39	80000	F
300	XXBNUB	BNSYQSIIHE	4098719533 Dell Way	\N	XPHDGSD	DC	94562	US	1	BNSYQSIIHE@dell.com	4098719533	2	8165997060481460	2011/11	user300	password	23	60000	M
301	CCNEEB	XDSQLAXQYN	4294433532 Dell Way	\N	YBTQFXO	ND	19201	US	1	XDSQLAXQYN@dell.com	4294433532	1	9450068387202920	2010/10	user301	password	67	60000	M
302	FSAHQD	ZGPAEFYRDA	4081031166 Dell Way	\N	KUFHJUK	OK	97571	US	1	ZGPAEFYRDA@dell.com	4081031166	1	7549268234055490	2008/09	user302	password	60	40000	F
303	PNBSMI	IMMNLDRLOM	2243459966 Dell Way	\N	RWVLGNK	NH	71916	US	1	IMMNLDRLOM@dell.com	2243459966	4	4559870145749301	2011/11	user303	password	78	40000	F
304	XBWFJI	RXUVOFJAWG	5180039471 Dell Way	\N	WINJSCB	UT	76700	US	1	RXUVOFJAWG@dell.com	5180039471	3	6458090835250915	2009/11	user304	password	89	20000	M
305	VJHEBE	YWTEGUBMQJ	5159175581 Dell Way	\N	AACCBZW	NC	58805	US	1	YWTEGUBMQJ@dell.com	5159175581	5	4901917542796582	2010/01	user305	password	44	40000	F
306	RLLVKI	OPPJQCZACZ	1472697085 Dell Way	\N	CFBBBPQ	MT	48652	US	1	OPPJQCZACZ@dell.com	1472697085	5	4990246432367712	2010/03	user306	password	79	20000	M
307	HXCPMS	EVJGUJJUMO	3766494931 Dell Way	\N	VOPLECW	HI	15233	US	1	EVJGUJJUMO@dell.com	3766494931	4	3613013172987849	2008/09	user307	password	89	60000	M
308	CBCUGY	DNSNWNAKIO	4932828367 Dell Way	\N	ZUTCQZD	WI	66930	US	1	DNSNWNAKIO@dell.com	4932828367	1	4214093363378197	2010/07	user308	password	89	60000	M
309	CIUAMH	SZDGZOOONJ	3531801684 Dell Way	\N	IQZHTYY	GA	12546	US	1	SZDGZOOONJ@dell.com	3531801684	4	5970230807084591	2009/02	user309	password	26	40000	F
310	XJXFCX	JIXXXLLGUB	7757414799 Dell Way	\N	GBVEZAF	ID	68624	US	1	JIXXXLLGUB@dell.com	7757414799	3	8083655754104257	2012/11	user310	password	35	80000	F
311	DAIBKQ	YHOKTUEVAG	2058246426 Dell Way	\N	QEGRKNI	CT	13945	US	1	YHOKTUEVAG@dell.com	2058246426	1	9332935007754714	2009/10	user311	password	29	60000	M
312	MOFDNN	RYGLDBMJSR	1912545777 Dell Way	\N	QKBDTEE	TX	27155	US	1	RYGLDBMJSR@dell.com	1912545777	2	9884611359797420	2009/09	user312	password	76	80000	F
313	ZXUMOT	TAWVMGODWY	5962735780 Dell Way	\N	EZRJENO	ID	75744	US	1	TAWVMGODWY@dell.com	5962735780	3	4982919144444168	2009/04	user313	password	70	40000	F
314	NVTGOT	DKFJYJFWOF	3284500294 Dell Way	\N	OYKCNRV	AR	29065	US	1	DKFJYJFWOF@dell.com	3284500294	3	5543105227872730	2012/09	user314	password	67	60000	M
315	KTDEWN	KFMULIIRXH	5130357361 Dell Way	\N	BZUTUVY	AR	30496	US	1	KFMULIIRXH@dell.com	5130357361	1	9687519971746952	2008/07	user315	password	56	60000	F
316	RSCFDI	RXUAFLXMNX	3632549888 Dell Way	\N	HGRCFTI	NY	77759	US	1	RXUAFLXMNX@dell.com	3632549888	5	3363321579061449	2012/05	user316	password	55	60000	F
317	QSGZJD	TJJFHWSEDZ	6617857897 Dell Way	\N	WFFPOXJ	TN	74673	US	1	TJJFHWSEDZ@dell.com	6617857897	4	1920309088192880	2008/02	user317	password	33	80000	M
318	LTFOMP	XRXTKBXKYC	3978165483 Dell Way	\N	PORNXMF	NC	24160	US	1	XRXTKBXKYC@dell.com	3978165483	4	3824727247934789	2010/06	user318	password	30	100000	F
319	JORZMI	WGTYDDXGTL	8701239216 Dell Way	\N	XHJJNXO	TN	63293	US	1	WGTYDDXGTL@dell.com	8701239216	2	1406037268228828	2008/05	user319	password	34	60000	M
320	XJKGGQ	ZETDBZXNXE	4765436836 Dell Way	\N	WHRUVMJ	NY	88654	US	1	ZETDBZXNXE@dell.com	4765436836	4	3121728072874248	2011/02	user320	password	29	60000	F
321	OUSETX	YXYYUMVZIC	3162309773 Dell Way	\N	QDXDMOA	VT	33656	US	1	YXYYUMVZIC@dell.com	3162309773	3	4204171595629305	2009/02	user321	password	78	100000	M
322	OCQLBO	KZJWUIEXYI	9936746621 Dell Way	\N	UBUJBSQ	KS	34603	US	1	KZJWUIEXYI@dell.com	9936746621	4	4385146947577596	2012/08	user322	password	36	40000	M
323	XUVLEU	UBPDGNBOHD	7395355168 Dell Way	\N	JRFBINI	IN	30863	US	1	UBPDGNBOHD@dell.com	7395355168	1	8913109336979688	2012/06	user323	password	64	100000	F
324	LIMGDN	WGTJIHRLQI	3628955565 Dell Way	\N	RSREAZK	OR	18202	US	1	WGTJIHRLQI@dell.com	3628955565	4	6241616962477565	2012/08	user324	password	81	40000	M
325	IQCWNJ	PWRXNDNWUG	2426902854 Dell Way	\N	NZGMJAO	NY	75145	US	1	PWRXNDNWUG@dell.com	2426902854	4	3864944910164923	2008/12	user325	password	36	40000	M
326	IFDRVZ	JSNMGKGMXG	8308951018 Dell Way	\N	TKPUZHM	CT	89643	US	1	JSNMGKGMXG@dell.com	8308951018	1	8887495858594776	2008/07	user326	password	55	60000	M
327	QCPQLI	EYPOFCLLVW	1771878486 Dell Way	\N	BPVICYF	VT	20089	US	1	EYPOFCLLVW@dell.com	1771878486	5	6783226095605642	2010/05	user327	password	47	40000	F
328	ZWYIBW	XPBZBMVXNL	4884960135 Dell Way	\N	SWORBMU	DC	51208	US	1	XPBZBMVXNL@dell.com	4884960135	4	8608122009318323	2012/12	user328	password	41	100000	M
329	GEXCBM	EBNQXLEIEA	7064518587 Dell Way	\N	XVCJQFV	AR	97634	US	1	EBNQXLEIEA@dell.com	7064518587	5	9608518044929952	2012/09	user329	password	77	40000	M
330	SIYFMA	TDXEHGIIDE	6102770832 Dell Way	\N	KNUQIVP	AK	75728	US	1	TDXEHGIIDE@dell.com	6102770832	1	5066645417828113	2009/03	user330	password	42	20000	M
331	HICHBF	EFNKOWOSGB	5839084352 Dell Way	\N	NXJJNKC	AZ	45472	US	1	EFNKOWOSGB@dell.com	5839084352	3	6756219666451216	2012/07	user331	password	34	20000	M
332	IKYNPD	BZSXNLEPYB	4452663315 Dell Way	\N	YIOJKPT	WA	16107	US	1	BZSXNLEPYB@dell.com	4452663315	5	6627232364844531	2011/12	user332	password	54	100000	F
333	KLYONX	HKLSOARPZZ	5191289053 Dell Way	\N	EIKUCIV	MN	21469	US	1	HKLSOARPZZ@dell.com	5191289053	1	1602543503046035	2012/12	user333	password	48	40000	F
334	JYYHGJ	SZYTQOTQSB	6028678077 Dell Way	\N	AMDJIPM	RI	71763	US	1	SZYTQOTQSB@dell.com	6028678077	4	7147648865822703	2012/02	user334	password	27	40000	F
335	CPILIH	KBYYUOQWPC	9893963170 Dell Way	\N	AZKQMFH	AL	94745	US	1	KBYYUOQWPC@dell.com	9893963170	1	1547435238957405	2008/04	user335	password	27	40000	M
336	LRGSBH	QZCFQYVTYU	4260390964 Dell Way	\N	EPGJXHH	UT	36740	US	1	QZCFQYVTYU@dell.com	4260390964	5	6641835723072291	2010/03	user336	password	58	100000	M
337	UQYCHY	ENODIHCDLR	6602347009 Dell Way	\N	KVOSDLZ	MO	49398	US	1	ENODIHCDLR@dell.com	6602347009	5	6800323426257820	2008/11	user337	password	56	100000	M
338	LBWKGJ	YKRGNVSFFN	3605916651 Dell Way	\N	TYQFXDQ	NC	17981	US	1	YKRGNVSFFN@dell.com	3605916651	4	9953626471105964	2012/09	user338	password	58	40000	M
339	KRATPK	LWYGODMCXK	9329606369 Dell Way	\N	SCIVTXY	AL	64826	US	1	LWYGODMCXK@dell.com	9329606369	5	3703636562451720	2010/02	user339	password	22	100000	M
340	BQKMBG	LIVOVXLGQN	4523716839 Dell Way	\N	PMGMKHC	KS	22391	US	1	LIVOVXLGQN@dell.com	4523716839	5	3233503010589629	2010/09	user340	password	19	60000	F
341	KAJRLS	MZOKLUAZJM	9247578219 Dell Way	\N	GWXNYGR	KY	13669	US	1	MZOKLUAZJM@dell.com	9247578219	4	7501876194961370	2012/04	user341	password	20	40000	F
342	KAUDMU	RWGLWFVJLS	3477728459 Dell Way	\N	HYQNQZO	NC	81760	US	1	RWGLWFVJLS@dell.com	3477728459	3	2103398712351918	2009/10	user342	password	52	80000	M
343	HVHBME	HYBMULXMSW	1321186344 Dell Way	\N	DFNDUBX	AR	57819	US	1	HYBMULXMSW@dell.com	1321186344	2	4206207036040723	2010/01	user343	password	31	80000	M
344	MWKRDI	SQCDOOWLRC	9018709599 Dell Way	\N	YUWASYN	PA	35511	US	1	SQCDOOWLRC@dell.com	9018709599	2	4209969127550721	2008/01	user344	password	37	60000	M
345	RFAZYR	CCGRZRJBQD	5464307220 Dell Way	\N	YQWWEPD	AR	88481	US	1	CCGRZRJBQD@dell.com	5464307220	1	9166661614552140	2011/09	user345	password	75	60000	M
346	VKWMNZ	SEYKNAARYQ	9370768462 Dell Way	\N	NUVDYWA	MI	10477	US	1	SEYKNAARYQ@dell.com	9370768462	1	7329671544954181	2011/08	user346	password	64	60000	F
347	NANMTR	LDFLDWKUKE	2758153718 Dell Way	\N	PODMPOM	MT	77996	US	1	LDFLDWKUKE@dell.com	2758153718	2	4278092387598008	2012/10	user347	password	45	40000	M
348	XVNPGR	VSURCPCHFR	1900375179 Dell Way	\N	KSHZFUT	MA	12930	US	1	VSURCPCHFR@dell.com	1900375179	2	8283417826052756	2010/07	user348	password	62	40000	F
349	DZQUUI	PMLFPSLGDD	2527048894 Dell Way	\N	NDIIWSJ	WI	93712	US	1	PMLFPSLGDD@dell.com	2527048894	3	5332548341713846	2011/10	user349	password	80	100000	M
350	MSPVIC	GNRZYYDCMG	5743836143 Dell Way	\N	KUDDECB	KS	57319	US	1	GNRZYYDCMG@dell.com	5743836143	1	4183805213775486	2009/01	user350	password	29	100000	M
351	TSBVZP	NYNLCPXJAS	4966356843 Dell Way	\N	MDWOEFC	OH	37320	US	1	NYNLCPXJAS@dell.com	4966356843	1	3903849002439529	2011/12	user351	password	22	40000	M
352	CFPRSO	FERVBAVUMZ	5342618657 Dell Way	\N	RBDWDVE	NE	93321	US	1	FERVBAVUMZ@dell.com	5342618657	1	8900803357828409	2010/07	user352	password	56	80000	M
353	DIMSOQ	JJSJFMWEDX	9758801231 Dell Way	\N	IABEEQC	NV	84274	US	1	JJSJFMWEDX@dell.com	9758801231	1	4386899176053703	2010/11	user353	password	27	80000	F
354	PISGSC	YCILYMPWVQ	7942490020 Dell Way	\N	YZUOCLK	AR	66755	US	1	YCILYMPWVQ@dell.com	7942490020	3	5195883271284402	2012/03	user354	password	64	60000	M
355	JTGLSI	TEGGUDBKBB	7577906167 Dell Way	\N	FQDQAFG	SC	77644	US	1	TEGGUDBKBB@dell.com	7577906167	4	9515341184102000	2009/03	user355	password	53	80000	M
356	SESBXX	HDRLFCNGHD	3632031204 Dell Way	\N	KXEPEZJ	VT	70854	US	1	HDRLFCNGHD@dell.com	3632031204	2	9114507246296854	2011/12	user356	password	83	60000	F
357	PNBNVF	EHKHUROYBM	6760008357 Dell Way	\N	CRQBAOT	IN	85330	US	1	EHKHUROYBM@dell.com	6760008357	1	8435384907294066	2010/07	user357	password	88	20000	F
358	AQYFVF	QCAHRYJDAB	1039379857 Dell Way	\N	UCBIVJE	MO	51456	US	1	QCAHRYJDAB@dell.com	1039379857	1	1342018307652324	2012/02	user358	password	28	100000	M
359	CFQIWS	IEKHNNIPHK	5797678580 Dell Way	\N	RQGAVSM	SD	76251	US	1	IEKHNNIPHK@dell.com	5797678580	4	8974270416423679	2011/10	user359	password	67	80000	F
360	HCWALA	LTOYBDGMUW	1777718754 Dell Way	\N	TVSMINF	TX	38262	US	1	LTOYBDGMUW@dell.com	1777718754	3	1958312905393541	2011/04	user360	password	26	20000	F
361	ZCXZNQ	NMSRSELPXH	3124822499 Dell Way	\N	HJPVPLD	NV	99151	US	1	NMSRSELPXH@dell.com	3124822499	3	3768307211808860	2009/07	user361	password	71	40000	M
362	QHEGVQ	YMJDYYAGGK	6261663562 Dell Way	\N	VBZHFQH	MI	17419	US	1	YMJDYYAGGK@dell.com	6261663562	4	6298322129994631	2009/02	user362	password	33	100000	F
363	JEGZDT	JGSIHYORTQ	9999927052 Dell Way	\N	RBWIIHK	VT	16931	US	1	JGSIHYORTQ@dell.com	9999927052	2	2709896927233785	2009/03	user363	password	62	60000	F
364	WOMPXT	HGAGVSZLKB	8735286854 Dell Way	\N	HSJPDHR	CT	56177	US	1	HGAGVSZLKB@dell.com	8735286854	2	7151354987174273	2010/11	user364	password	21	40000	F
365	NYKHGQ	HMLAMXKNFD	4410586962 Dell Way	\N	XUGEMKS	KS	75146	US	1	HMLAMXKNFD@dell.com	4410586962	4	6676866185851396	2010/02	user365	password	25	100000	F
366	NFHDNU	PNGMYURBRM	1455873704 Dell Way	\N	IWYSOHK	WI	17898	US	1	PNGMYURBRM@dell.com	1455873704	2	2907655410002917	2008/04	user366	password	37	80000	M
367	OUBJJP	QWOKOPCAXY	6290136627 Dell Way	\N	ZPNHAMJ	AZ	84771	US	1	QWOKOPCAXY@dell.com	6290136627	2	2355790163390338	2012/11	user367	password	69	60000	M
368	UUBJKX	XULNXMLWMA	8402587396 Dell Way	\N	JTBVDDR	OR	42716	US	1	XULNXMLWMA@dell.com	8402587396	3	3245471953414380	2010/01	user368	password	85	40000	M
369	ZRFWPA	ICXUNTHODB	4322463798 Dell Way	\N	QZETQXD	MO	55153	US	1	ICXUNTHODB@dell.com	4322463798	5	5706963019445539	2009/04	user369	password	42	40000	M
370	ODOOLR	MGEGNTJOJJ	7236657544 Dell Way	\N	TDARGME	NJ	53848	US	1	MGEGNTJOJJ@dell.com	7236657544	5	7993865395896138	2008/03	user370	password	71	60000	F
371	HDUYPA	DVOXFDHPXK	4140722931 Dell Way	\N	PORCTHO	ME	28877	US	1	DVOXFDHPXK@dell.com	4140722931	3	4572375999763608	2008/01	user371	password	70	40000	F
372	NITOLP	CIVGPKDAZS	6257334598 Dell Way	\N	RBLZQWE	WY	39633	US	1	CIVGPKDAZS@dell.com	6257334598	1	4145796103402972	2009/06	user372	password	54	100000	M
373	GJFVMO	RTEBWFBPXD	6442399032 Dell Way	\N	BWTYBTG	NM	85344	US	1	RTEBWFBPXD@dell.com	6442399032	5	3620588372461498	2008/10	user373	password	22	40000	F
374	HFPWWI	AXFGYVDBWZ	7443495141 Dell Way	\N	VUBPBRL	NV	67561	US	1	AXFGYVDBWZ@dell.com	7443495141	4	4629723208490759	2011/02	user374	password	56	20000	F
375	DXEMYC	REAMHCJHYD	1735684435 Dell Way	\N	JNEBYVR	NV	62724	US	1	REAMHCJHYD@dell.com	1735684435	3	7239370234310628	2011/07	user375	password	18	80000	F
376	EFJGWN	HJVJSDIWMV	2464967654 Dell Way	\N	BNUWFLM	IL	89059	US	1	HJVJSDIWMV@dell.com	2464967654	5	4421099658589810	2008/08	user376	password	75	40000	M
377	DOSRWC	NGUQORDJSQ	8670228408 Dell Way	\N	EPVPBDM	HI	11011	US	1	NGUQORDJSQ@dell.com	8670228408	2	6753233018331230	2011/09	user377	password	52	80000	F
378	EMEGZK	BQYSUILLMA	1386296926 Dell Way	\N	HBCKNIK	MA	75057	US	1	BQYSUILLMA@dell.com	1386296926	1	5031183911487460	2010/10	user378	password	72	80000	F
379	XYHHZY	FSSNDDZELB	7959889125 Dell Way	\N	HVPPFYI	ID	98829	US	1	FSSNDDZELB@dell.com	7959889125	4	8297181698959322	2010/06	user379	password	26	60000	F
380	KSKJYC	CMGGMLRNSM	8674097456 Dell Way	\N	CHSBQZB	MD	76853	US	1	CMGGMLRNSM@dell.com	8674097456	5	2840031786821782	2012/05	user380	password	62	40000	F
381	ATADVM	JCYUTMNGOV	8893245345 Dell Way	\N	YQLYRWR	MT	80262	US	1	JCYUTMNGOV@dell.com	8893245345	3	2222663085907697	2010/11	user381	password	33	60000	M
382	FPLSZO	RUIDHORCNH	3807279390 Dell Way	\N	OMZKDME	AK	96166	US	1	RUIDHORCNH@dell.com	3807279390	3	8383920805528761	2010/12	user382	password	49	80000	M
383	XLOLCJ	UGQIYSWGHI	5126499498 Dell Way	\N	FRMRVMQ	DC	99661	US	1	UGQIYSWGHI@dell.com	5126499498	4	9864839225541800	2012/06	user383	password	60	80000	M
384	DGZMAF	DJDWFKDOPU	5801655211 Dell Way	\N	BHQOXUO	LA	51257	US	1	DJDWFKDOPU@dell.com	5801655211	2	8890351350884885	2008/01	user384	password	72	40000	F
385	STHYWQ	CTWMWLCQMJ	4522183122 Dell Way	\N	HBGBPQN	CT	89283	US	1	CTWMWLCQMJ@dell.com	4522183122	2	9343711226712912	2008/06	user385	password	33	100000	F
386	MVDDXW	ZKSLMJYVQZ	5680364181 Dell Way	\N	CROSFRP	NH	93327	US	1	ZKSLMJYVQZ@dell.com	5680364181	4	4822750995401293	2011/08	user386	password	67	40000	F
387	VJIRJT	KUGTSBKREC	3441283382 Dell Way	\N	GWHXMXW	WY	65995	US	1	KUGTSBKREC@dell.com	3441283382	4	3029052692931145	2012/12	user387	password	65	80000	F
388	ZLQTVL	ZPDBZUFBBC	1900316417 Dell Way	\N	JYOGUOW	AZ	35701	US	1	ZPDBZUFBBC@dell.com	1900316417	1	3063468502368778	2011/10	user388	password	56	80000	F
389	EMBPMR	TNROTSPWCO	5657291052 Dell Way	\N	LJJAFLH	KS	51380	US	1	TNROTSPWCO@dell.com	5657291052	1	3250254617072642	2008/10	user389	password	53	40000	F
390	OVTFOH	WCBPSXRGJA	7648048803 Dell Way	\N	PJGAQPM	DE	68696	US	1	WCBPSXRGJA@dell.com	7648048803	2	5156824692152441	2009/06	user390	password	73	80000	F
391	NZVVVY	WLQUDWDEMM	2087995519 Dell Way	\N	LMDAZHR	OK	53058	US	1	WLQUDWDEMM@dell.com	2087995519	5	9124726902693512	2012/09	user391	password	29	40000	M
392	ZFNXBZ	NWCKZGWLRJ	3069822747 Dell Way	\N	ORJWJBI	MN	11376	US	1	NWCKZGWLRJ@dell.com	3069822747	2	7516995991580189	2009/09	user392	password	47	40000	M
393	YGAXUW	ZEWGBIYKWQ	6122061129 Dell Way	\N	TSZVBLV	IL	80785	US	1	ZEWGBIYKWQ@dell.com	6122061129	4	5754062341526151	2012/01	user393	password	52	100000	F
394	NVBJVG	GBHOASLQLE	4183120554 Dell Way	\N	PHFBDMV	OH	25392	US	1	GBHOASLQLE@dell.com	4183120554	4	2777767871040851	2012/08	user394	password	52	40000	F
395	OSGUYH	CMHUXYGBNN	2370918144 Dell Way	\N	HORUKJY	OR	13392	US	1	CMHUXYGBNN@dell.com	2370918144	3	6711411399301142	2011/11	user395	password	21	20000	M
396	HZPPBC	WVZVBBIPJX	3428771862 Dell Way	\N	GDHPCAQ	IA	64755	US	1	WVZVBBIPJX@dell.com	3428771862	5	5702685076277704	2009/01	user396	password	29	80000	F
397	TEBVBW	VWYWFNGCTJ	6046930359 Dell Way	\N	KJMLZSA	ID	62800	US	1	VWYWFNGCTJ@dell.com	6046930359	3	6741783560719342	2011/03	user397	password	65	60000	F
398	SHLPCI	NZNBFQVPAE	9872167209 Dell Way	\N	BMETNLJ	AZ	13421	US	1	NZNBFQVPAE@dell.com	9872167209	4	3066665519494563	2011/03	user398	password	62	40000	M
399	BYPJMO	XNUNJJOOKA	4962798750 Dell Way	\N	SEOENPF	MS	44723	US	1	XNUNJJOOKA@dell.com	4962798750	1	6593742118682713	2008/06	user399	password	27	20000	F
400	SLXHJL	BXULLIWMBA	6830864688 Dell Way	\N	AGOQLBA	VA	27719	US	1	BXULLIWMBA@dell.com	6830864688	5	7238008170854301	2011/01	user400	password	27	60000	F
401	BUWMWT	HIFQESSESY	6995234320 Dell Way	\N	SJKUKHZ	AR	30644	US	1	HIFQESSESY@dell.com	6995234320	5	3345355732366443	2011/04	user401	password	72	100000	F
402	PIAIQI	NHMFZRYYJI	2104070194 Dell Way	\N	IESQDTW	SC	62359	US	1	NHMFZRYYJI@dell.com	2104070194	3	9170686969067902	2012/06	user402	password	20	60000	M
403	AVKJJR	VORMNQWWYA	8412834151 Dell Way	\N	OPDILYX	NE	57972	US	1	VORMNQWWYA@dell.com	8412834151	3	9736720310058446	2012/12	user403	password	72	100000	M
404	EGCWBR	NOFDKBCKQS	1090605100 Dell Way	\N	OYENWTB	OH	27341	US	1	NOFDKBCKQS@dell.com	1090605100	3	2091208441182971	2011/06	user404	password	81	100000	M
405	YTUQHI	VLSWODMHSL	5380234430 Dell Way	\N	LFIEGAJ	ID	62295	US	1	VLSWODMHSL@dell.com	5380234430	1	1305581101682037	2009/12	user405	password	71	40000	M
406	NXAVTM	OPASCHKOTQ	5647370127 Dell Way	\N	WXXXHEM	PA	27853	US	1	OPASCHKOTQ@dell.com	5647370127	1	2292535816784948	2009/05	user406	password	80	80000	F
407	WOBIDR	JVURGIKWFI	3569905887 Dell Way	\N	UCPYPJD	CO	51789	US	1	JVURGIKWFI@dell.com	3569905887	2	8908742939587683	2008/02	user407	password	33	20000	M
408	HJVZSQ	TKWCUTHCNK	4613596908 Dell Way	\N	SMABPDN	VA	53225	US	1	TKWCUTHCNK@dell.com	4613596908	1	6353552803397179	2011/01	user408	password	38	100000	F
409	CWDTQN	QTHJAKXLDJ	6840234973 Dell Way	\N	LEZOSXB	CO	94492	US	1	QTHJAKXLDJ@dell.com	6840234973	4	9949641735292972	2012/08	user409	password	47	20000	M
410	NUEAKX	IUXTRJXBVB	9070701781 Dell Way	\N	BKUZLXX	CO	65480	US	1	IUXTRJXBVB@dell.com	9070701781	1	3266028830781579	2009/01	user410	password	74	100000	M
411	YWGVEA	TYSCVUYXWI	5072135530 Dell Way	\N	SVUPTWF	NM	92321	US	1	TYSCVUYXWI@dell.com	5072135530	5	9875021984800696	2009/09	user411	password	79	20000	M
412	CZUDST	WVPRTMNCEJ	6829156070 Dell Way	\N	WUCTZSR	ME	68976	US	1	WVPRTMNCEJ@dell.com	6829156070	4	4601656510494650	2010/10	user412	password	90	60000	M
413	USMNOH	CGBPTDUDAO	1087313727 Dell Way	\N	FTNYLYP	AZ	63387	US	1	CGBPTDUDAO@dell.com	1087313727	3	4533396830782294	2008/02	user413	password	29	80000	M
414	QHKYKR	AZLEUOEIUY	8037583475 Dell Way	\N	WTJUILK	KY	10277	US	1	AZLEUOEIUY@dell.com	8037583475	2	2266294944565743	2012/02	user414	password	90	60000	F
415	KOWBOW	MTQBXZVWVO	8462120693 Dell Way	\N	GPXRAGR	RI	65155	US	1	MTQBXZVWVO@dell.com	8462120693	4	7819508424028755	2012/04	user415	password	33	40000	M
416	BHLYUE	OVCNRYIFFY	7813864146 Dell Way	\N	DXYKOTZ	MD	52054	US	1	OVCNRYIFFY@dell.com	7813864146	2	8096668172627688	2012/06	user416	password	66	20000	M
417	CZOGNK	JBBIKHNJLK	3810626171 Dell Way	\N	IVZBVJN	ND	64273	US	1	JBBIKHNJLK@d