#include <stdlib.h>

#include "connection.h"

Environment* AllocEnvironment()
{
	Environment* pEnvironment = (Environment*)malloc(sizeof(Environment));
	if (NULL != pEnvironment)
	{
		memset(pEnvironment, 0, sizeof(Environment));
		
		/* default attributes' values */
		pEnvironment->attributes.cp_match           = SQL_CP_RELAXED_MATCH;
		pEnvironment->attributes.odbc_version       = SQL_OV_ODBC3;
		pEnvironment->attributes.connection_pooling = SQL_CP_OFF;

		/* connections list */
		pEnvironment->connections.handles = NULL;
		InitDiag(&pEnvironment->diag);
		_INIT_CRITICAL_SECTION(pEnvironment);
	}

	return pEnvironment;
}

SQLRETURN FreeEnvironment(Environment* pEnvironment)
{
	FreeList(&pEnvironment->connections, SQL_HANDLE_DBC);

	ENTER_CRITICAL_SECTION(pEnvironment);
	
	FreeDiag(&pEnvironment->diag);
	_DELETE_CRITICAL_SECTION(pEnvironment);
	FREE(pEnvironment);
	return SQL_SUCCESS;
}
