#ifndef __DESCRIPTOR__
#define __DESCRIPTOR__

#include "connection.h"

typedef struct _descriptor Descriptor;

#ifdef _MULTITHREAD_SUPPORT
	#define GET_DESCRIPTOR(desc)   desc; ENTER_CRITICAL_SECTION(desc)
	#define RET_DESCRIPTOR(desc)   LEAVE_CRITICAL_SECTION(desc)
	#define GET_ADDED_IRD(stmt)    ENTER_CRITICAL_SECTION(
#else
	#define GET_DESCRIPTOR(desc)   desc
	#define RET_DESCRIPTOR(desc)
	#define GET_ADDED_IRD(stmt)
#endif /* _MULTITHREAD_SUPPORT */

typedef enum
{
	DT_EMPTY = 0x00,
	DT_APD   = 0x01,
	DT_ARD   = 0x02,
	DT_IPD   = 0x04,
	DT_IRD   = 0x08,

	DT_AD = DT_ARD | DT_APD, /* application class */
	DT_ID = DT_IRD | DT_IPD, /* implementation class */
	
	DT_D = DT_AD | DT_ID /* typed descriptor (not empty) */
} Descriptor_type;

typedef enum
{
	C_TYPE   = 0,
	SQL_TYPE = 1
} TypeClass;

/*---------------------------------------------------------
	struct _common_desc_record
---------------------------------------------------------*/
struct _common_desc_record
{
	SQLSMALLINT datetime_interval_code;
	SQLSMALLINT concise_type;
	SQLUINTEGER length;
	SQLSMALLINT precision;
	SQLSMALLINT scale;
	SQLSMALLINT type;
	SQLPOINTER* data_ptr;
	SQLINTEGER  datetime_interval_precision;
	SQLINTEGER  num_prec_radix;
	SQLINTEGER  octet_length;
};

/*---------------------------------------------------------
	struct AD_REC
---------------------------------------------------------*/
struct _application_desc_record
{
	struct _common_desc_record common;

	SQLINTEGER* indicator_ptr;
	SQLINTEGER* octet_length_ptr;
	SQLSMALLINT bound;
};

/*---------------------------------------------------------
	struct ID_REC
---------------------------------------------------------*/
struct _implementation_desc_record
{
	struct _common_desc_record common;

	SQLSMALLINT fixed_prec_scale;
	SQLSMALLINT nullable;
	SQLSMALLINT parameter_type;
	SQLSMALLINT unnamed;
	SQLSMALLINT is_unsigned;
	SQLSMALLINT updatable;
	SQLINTEGER  display_size;
	SQLTCHAR*   literal_prefix;
	SQLTCHAR*   literal_suffix;
	SQLTCHAR*   local_type_name;
	SQLTCHAR*   type_name;
	SQLTCHAR*   name;

	SQLUINTEGER  max_column_length;
/* -- This are the same for every descriptor or unsupported now --
	SQLCHAR*    label;
	SQLCHAR*    table_name;
	SQLCHAR*    catalog_name;
	SQLCHAR*    base_column_name;
	SQLCHAR*    base_table_name;
	SQLCHAR*    shema_name;
	SQLINTEGER  auto_unique_value;
	SQLINTEGER  case_sensitive;
	SQLSMALLINT searchable;
	SQLSMALLINT rowver;
*/

	/* */
	int    bytes_left;
	uint32 type_oid;
	uint32 table_oid;
	int    type_modifier;
	uint16 column_attribute;
	short  type_size;
	uint16 format_code;
};

typedef struct _application_desc_record     AD_REC;
typedef struct _implementation_desc_record  ID_REC;
typedef struct _common_desc_record          CD_REC;

/*---------------------------------------------------------
	struct _descriptor_header
---------------------------------------------------------*/
struct _descriptor_header
{
	/* alloc_type moved out to allow using 'memcpy' in SQLCopyDesc*/
	SQLUINTEGER*  rows_processed_ptr;
	SQLUSMALLINT* array_status_ptr;
	SQLINTEGER*   bind_offset_ptr;
	SQLSMALLINT   alloc_type;          /* SQL_DESC_ALLOC_AUTO or SQL_DESC_ALLOC_USER */
	SQLUINTEGER   array_size;          /* ARD - number of rows in rowset 
	                                      APD - number of values for each parameter  */
	SQLINTEGER    bind_type;
	SQLSMALLINT   count;               /* ARD - highest number of bound column 
									                	    APD -           -//-          parameter */
	/*---- used only in ird ----------------------------------------*/
	QueryType   query_type;
	int         rows_affected; /* rows affected by non-SELECT query */
	/*--------------------------------------------------------------*/
};
/*---------------------------------------------------------
	struct Bookmark
---------------------------------------------------------*/
struct _bookmark
{
	SQLINTEGER* indicator_ptr;
	SQLINTEGER  octet_length;
	SQLPOINTER  data_ptr;
	SQLSMALLINT type;
};

typedef struct _bookmark Bookmark;
/*---------------------------------------------------------
	struct Descriptor
---------------------------------------------------------*/
struct _descriptor
{
	/* header */
	struct _descriptor_header header;
	struct _diag              diag;
	struct _bookmark          bookmark;
	
	SQLSMALLINT allocated;  /* number of allocated records */	
	Connection* connection; /* parent conneciton */
	Descriptor* next;

	/* type specific info */
	Descriptor_type type;   /* APD, ARD, IPD, or IRD */

	union {
		ID_REC* id_records;   /* array of records */
		AD_REC* ad_records;
		void*   records;
	};

	__CRITICAL_SECTION(cs);
};

Descriptor* NewResultset(Statement* pStatement);
Descriptor* AllocDescriptor(Connection* pConnection);
SQLRETURN FreeDescriptor(Descriptor* pDescriptor);
SQLRETURN EmptyDescriptorRecord(Descriptor* pDescriptor, SQLSMALLINT number);
SQLRETURN ReallocDescriptorRecords(Descriptor* pDescriptor, SQLSMALLINT number);
SQLRETURN CopyDescriptor(Descriptor* SourceDescHandle, Descriptor* TargetDescHandle);
SQLRETURN CheckDescriptorConsistency(Descriptor* pDescriptor, SQLSMALLINT RecNumber);

SQLRETURN GetDescField(Descriptor* pDescriptor, SQLSMALLINT RecNumber, SQLSMALLINT FieldIdentifier,
                       SQLPOINTER Value, SQLINTEGER BufferLength, SQLSMALLINT* StringLength, Statement* pStatement);
SQLRETURN SetDescField(Descriptor* pDescriptor, SQLSMALLINT RecNumber, SQLSMALLINT FieldIdentifier,
                       SQLPOINTER Value, SQLINTEGER BufferLength);
void InitDescriptor(Descriptor* pDescriptor, SQLSMALLINT alloc_type);
void TranslateType(CD_REC* common, SQLSMALLINT code, SQLSMALLINT decimalDigits, SQLUINTEGER size, TypeClass typeClass);
SQLRETURN SetDescData(Descriptor* pDescriptor, SQLSMALLINT RecNumber, SQLPOINTER Value, SQLINTEGER Length,
                      SQLSMALLINT Type, SQLSMALLINT SubType, SQLSMALLINT Precision, SQLSMALLINT Scale,
                      SQLINTEGER* StringLength, SQLINTEGER* Indicator, BOOL record);
int PrepareResultset(Statement* pStatement, int nRows);

#endif /* __DESCRIPTOR__ */

