/**********************************************************************
 * functions.sql native chemistry handling functions SQL stubs
 *
 * Copyright (c) 2004,2008 by Ernst-G. Schmid
 *
 * This file is part of the pgchem::tigress project.
 * For more information, see
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 ************************************************************************/

CREATE OR REPLACE FUNCTION add_hydrogens(molecule, boolean, boolean)
  RETURNS molecule AS
'libpgchem', 'pgchem_add_hydrogens'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION exactmass(molecule)
  RETURNS double precision AS
'libpgchem', 'pgchem_exactmass'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fgroup_codes(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_fgroup_codes_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_2d(molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_2D'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_3d(molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_3D'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_chiral(molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_chiral'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION is_nostruct(molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_is_nostruct'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION inchi(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_inchi'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION canonical_smiles(molecule, boolean)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_canonical_smiles'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION smiles(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_smiles'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION v3000(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_V3000'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molfile(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_molecule_to_molfile'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molformula(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_hillformula'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molweight(molecule)
  RETURNS double precision AS
'libpgchem', 'pgchem_molweight'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_long(molecule, boolean, boolean, boolean)
  RETURNS text AS
'libpgchem', 'pgchem_ms_fingerprint_long_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_long(molecule)
  RETURNS text AS
$BODY$
BEGIN
RETURN molkeys_long($1,false,false,false);
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molkeys_short(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_ms_fingerprint_short_a'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_atoms(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_atoms'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_bonds(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_bonds'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_heavy_atoms(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_heavy_atoms'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_rotatable_bonds(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_rotatable_bonds'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION pgchem_barsoi_version()
  RETURNS cstring AS
'libpgchem', 'pgchem_barsoi_version'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION pgchem_version()
  RETURNS cstring AS
'libpgchem', 'pgchem_version'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION remove_hydrogens(molecule, boolean)
  RETURNS molecule AS
'libpgchem', 'pgchem_remove_hydrogens'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION strip_salts(molecule, boolean)
  RETURNS molecule AS
'libpgchem', 'pgchem_strip_salts'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION total_charge(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_total_charge'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION validate_cas_no(character varying)
  RETURNS boolean AS
$BODY$
DECLARE checksum_from_cas_no varchar;
DECLARE cas_no_left varchar;
DECLARE cas_no_right varchar;
DECLARE cas_no_full varchar;
DECLARE tmpsum int;
DECLARE position_multiplier int;
DECLARE caslen int;
BEGIN
caslen:=length($1);

IF caslen<5 OR caslen>12 THEN RETURN FALSE;
END IF;

checksum_from_cas_no:=split_part($1,'-',3)::int;
cas_no_left:=split_part($1,'-',1);
cas_no_right:=split_part($1,'-',2);
cas_no_full:=cas_no_left || cas_no_right;

if(length(cas_no_left)>7 OR length(cas_no_right)>2 OR length(checksum_from_cas_no)!=1) THEN 
return false; 
END IF;

caslen:=length(cas_no_full);
tmpsum:=0;
position_multiplier:=1;

 FOR i IN REVERSE caslen..1 LOOP
  tmpsum:=tmpsum+substr(cas_no_full,i,1)::int*position_multiplier;
  position_multiplier:=position_multiplier+1;
 END LOOP;
 RETURN tmpsum % 10 = checksum_from_cas_no::int;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION logP(molecule)
  RETURNS double precision AS
'libpgchem', 'pgchem_logP'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION MR(molecule)
  RETURNS double precision AS
'libpgchem', 'pgchem_MR'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION PSA(molecule)
  RETURNS double precision AS
'libpgchem', 'pgchem_PSA'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION migrate_molecule(bytea)
  RETURNS molecule AS
'libpgchem','pgchem_molecule_to_new_molecule'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION SMARTSmatch(text, molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_smartsfilter'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION SMARTSmatch_count(text, molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_smartsfilter_count'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION molhash(molecule)
  RETURNS text AS
'libpgchem', 'pgchem_molhash'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fpstring(molecule)
  RETURNS bit varying AS
'libpgchem', 'pgchem_fp_out'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_h_acceptors(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_H_acceptors'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION number_of_h_donors(molecule)
  RETURNS integer AS
'libpgchem', 'pgchem_num_H_donors'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION lipinsky(molecule)
  RETURNS text AS
$BODY$
DECLARE parameters text;
BEGIN
parameters := '';

IF number_of_H_donors(mol) > 5 THEN
parameters := parameters || 'A';
END IF;
IF molweight(mol) > 500 THEN
parameters := parameters || 'B';
END IF;
IF logP(mol) > 5.0 THEN
parameters := parameters || 'C';
END IF;
IF number_of_H_acceptors(mol) > 10 THEN
parameters := parameters || 'D';
END IF;

RETURN parameters;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION mutabor(molecule)
  RETURNS molecule AS
'libpgchem', 'pgchem_mutate_fp'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION delebor(molecule)
  RETURNS molecule AS
'libpgchem', 'pgchem_blank_fp'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fp2string(molecule)
  RETURNS bit varying AS
$BODY$
DECLARE fp bit varying;
BEGIN
fp := substring(fpstring(struct) for 1024);
RETURN fp;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION fp3string(molecule)
  RETURNS bit varying AS
$BODY$
DECLARE fp bit varying;
BEGIN
fp := substring(fpstring(struct) from 1025);
RETURN fp;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION nse(tablename text, columnname text)
  RETURNS SETOF int AS
$BODY$
DECLARE fpAllOn bit varying;
DECLARE fpAllOff bit varying;
DECLARE row record;
DECLARE i int;
BEGIN
fpAllOn := B'11111111111111111111111111111111';
fpAllOff := B'00000000000000000000000000000000';

FOR row IN EXECUTE 'SELECT fp3string(' || columnname || ') as fp from ' || tablename LOOP
fpAllOn = fpAllOn & row.fp;
fpAllOff = fpAllOff | row.fp;
END LOOP;

FOR i IN 1..32 LOOP

IF (substring(fpAllOn from i for 1)='1') THEN RETURN NEXT i; END IF;
IF (substring(fpAllOff from i for 1)='0') THEN RETURN NEXT i; END IF;

END LOOP;

RETURN;
END;
$BODY$
  LANGUAGE 'plpgsql' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION nbits_set(bit varying)
  RETURNS integer AS
'libpgchem', 'pgchem_nbits_set'
  LANGUAGE 'c' IMMUTABLE STRICT;

CREATE OR REPLACE FUNCTION disconnected(molecule)
  RETURNS boolean AS
'libpgchem', 'pgchem_disconnected'
  LANGUAGE 'c' IMMUTABLE STRICT;
