/**********************************************************************
 * obwrapper.h OpenBabel wrapper functions
 *
 * Copyright (c) 2004,2005 by Ernst-G. Schmid
 * Copyright (c) 2004,2005 by Bayer Business Services GmbH
 * for explicitly marked functions
 *
 * This file is part of the xchem::tigress project.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * lesser GNU General Public License for more details.
 ************************************************************************/

#ifdef __cplusplus
extern "C"
{
#endif
  char *ob_mol_to_smiles (char *molfile);
  char *ob_mol_to_canonical_smiles (char *molfile, int iso_and_chiral_markings);
  char *ob_smiles_to_mol (char *smiles);
  char *ob_mol_to_inchi (char *molfile);
  //double ob_tanimoto_otf (char *molfile1, char *molfile2);
  double ob_tanimoto (unsigned int *fp1, unsigned int *fp2);
  void ob_fp2 (char *molfile1, unsigned int *fp);
  int ob_total_charge (char *molfile);
  unsigned int ob_num_rotatable_bonds (char *molfile);
  unsigned int ob_num_bonds (char *molfile);
  unsigned int ob_num_atoms (char *molfile);
  unsigned int ob_num_heavy_atoms (char *molfile);
  unsigned int ob_is_chiral (char *molfile);
  unsigned int ob_is_nostruct (char *molfile);
  char *ob_add_hydrogens (char *molfile, int polaronly, int correct4PH);
  char *ob_delete_hydrogens (char *molfile, int nonpolaronly);
  char *ob_strip_salts (char *molfile);
  int ob_2D (char *molfile);
  int ob_3D (char *molfile);
  char *ob_mol_to_V3000 (char *molfile);
  char *ob_V3000_to_mol (char *molfile);
  unsigned int ob_SSS_SMARTS (const char *smarts_pattern, char *molfile);
  unsigned int ob_SSS_SMARTS_native (const char *smarts_pattern, char *smiles);
/*****************************************************************
 * This function Copyright (c) 2004
 * by Bayer Business Services GmbH
 *****************************************************************/
  double ob_molweight (char *molfile);
/*****************************************************************
 * This function Copyright (c) 2004
 * by Bayer Business Services GmbH
 *****************************************************************/
  char *ob_hillformula (char *molfile);
/*****************************************************************
 * This function Copyright (c) 2005
 * by Bayer Business Services GmbH
 *****************************************************************/
  double ob_exactmass (char *molfile);
#ifdef __cplusplus
}
#endif
