/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.ActionRunner;
import com.google.jstestdriver.Args4jFlagsParser;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.HttpServer;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.TestCase;
import com.google.jstestdriver.config.CmdFlags;
import com.google.jstestdriver.config.CmdLineFlag;
import com.google.jstestdriver.config.CmdLineFlagsFactory;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.config.InitializeModule;
import com.google.jstestdriver.config.Initializer;
import com.google.jstestdriver.config.InvalidFlagException;
import com.google.jstestdriver.config.UnreadableFilesException;
import com.google.jstestdriver.config.UserConfigurationSource;
import com.google.jstestdriver.config.YamlParser;
import com.google.jstestdriver.embedded.JsTestDriverBuilder;
import com.google.jstestdriver.guice.TestResultPrintingModule;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.model.ConcretePathPrefix;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.model.NullPathPrefix;
import com.google.jstestdriver.output.TestResultListener;
import com.google.jstestdriver.runner.RunnerMode;
import com.google.jstestdriver.util.NullStopWatch;
import com.google.jstestdriver.util.RetryException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriver {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriver.class);
    private final Configuration defaultConfiguration;
    private final PluginLoader pluginLoader;
    private final List<Class<? extends PluginInitializer>> initializers;
    private final String[] defaultFlags;
    private final RunnerMode runnerMode;
    private final int port;
    private final List<Module> pluginModules;
    private final List<ServerListener> serverListeners;
    private final List<TestResultListener> testListeners;
    private final File baseDir;
    private final String serverAddress;

    public JsTestDriver(Configuration configuration, PluginLoader pluginLoader, List<Class<? extends PluginInitializer>> initializers, RunnerMode runnerMode, String[] flags, int port, List<Module> pluginModules, List<ServerListener> serverListeners, List<TestResultListener> testListeners, File baseDir, String serverAddress) {
        this.defaultConfiguration = configuration;
        this.pluginLoader = pluginLoader;
        this.initializers = initializers;
        this.runnerMode = runnerMode;
        this.defaultFlags = flags;
        this.port = port;
        this.pluginModules = pluginModules;
        this.serverListeners = serverListeners;
        this.testListeners = testListeners;
        this.baseDir = baseDir;
        this.serverAddress = serverAddress;
    }

    public static void main(String[] args) {
        try {
            CmdFlags cmdLineFlags = new CmdLineFlagsFactory().create(args);
            List<Plugin> cmdLinePlugins = cmdLineFlags.getPlugins();
            LogManager.getLogManager().readConfiguration(cmdLineFlags.getRunnerMode().getLogConfig());
            PluginLoader pluginLoader = new PluginLoader();
            List<Module> pluginModules = pluginLoader.load(cmdLinePlugins);
            logger.debug("loaded plugins %s", pluginModules);
            LinkedList<Module> initializeModules = Lists.newLinkedList(pluginModules);
            JsTestDriverBuilder builder = new JsTestDriverBuilder();
            builder.setBaseDir(cmdLineFlags.getBasePath().getCanonicalFile());
            builder.setConfigurationSource(cmdLineFlags.getConfigurationSource());
            builder.addPluginModules(pluginModules);
            builder.withPluginInitializer(TestResultPrintingModule.TestResultPrintingInitializer.class);
            builder.setRunnerMode(cmdLineFlags.getRunnerMode());
            builder.setFlags(cmdLineFlags.getUnusedFlagsAsArgs());
            JsTestDriver jstd = builder.build();
            jstd.runConfiguration();
            logger.info("Finished action run.");
        }
        catch (InvalidFlagException e) {
            e.printErrorMessages(System.out);
            CmdFlags.printUsage(System.out);
            System.exit(1);
        }
        catch (UnreadableFilesException e) {
            System.out.println("Configuration Error: \n" + e.getMessage());
            System.exit(1);
        }
        catch (RetryException e) {
            System.out.println("Tests failed due to unexpected environment issue: " + e.getCause().getMessage());
            System.exit(1);
        }
        catch (FailureException e) {
            System.out.println("Tests failed: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            logger.debug("Error {}", e);
            e.printStackTrace();
            System.out.println("Unexpected Runner Condition: " + e.getMessage() + "\n Use --runnerMode DEBUG for more information.");
            System.exit(1);
        }
    }

    public void startServer() {
        if (this.port == -1) {
            throw new ConfigurationException("Port not defined, cannot start local server.");
        }
        this.runConfigurationWithFlags(this.defaultConfiguration, this.createFlagsArray("--port", String.valueOf(this.port)));
    }

    private String[] createFlagsArray(String ... coreflags) {
        ArrayList<String> flags = Lists.newArrayList(coreflags);
        CmdLineFlag handlerPrefixFlag = this.findServerHandlerPrefixFlag();
        if (handlerPrefixFlag != null) {
            handlerPrefixFlag.addToArgs(flags);
        }
        String[] flagsArray = flags.toArray(new String[flags.size()]);
        return flagsArray;
    }

    public void stopServer() {
        CmdLineFlag handlerPrefixFlag = this.findServerHandlerPrefixFlag();
        HandlerPathPrefix prefix = new NullPathPrefix();
        if (handlerPrefixFlag != null) {
            prefix = new ConcretePathPrefix(handlerPrefixFlag.value);
        }
        StringBuilder urlBuilder = new StringBuilder(this.defaultConfiguration.getServer(this.serverAddress, this.port, prefix));
        urlBuilder.append("/");
        urlBuilder.append("quit");
        new HttpServer(new NullStopWatch()).ping(urlBuilder.toString());
    }

    public List<TestCase> runConfiguration() {
        this.runConfigurationWithFlags(this.defaultConfiguration, this.defaultFlags);
        return null;
    }

    public List<TestCase> runAllTests(String path) {
        return this.runAllTests(this.parseConfiguration(path));
    }

    public List<TestCase> runAllTests(Configuration config) {
        this.runConfigurationWithFlags(config, this.createFlagsArray("--tests", "all"));
        return null;
    }

    public List<TestCase> getTestCasesFor(String path) {
        return this.getTestCasesFor(this.parseConfiguration(path));
    }

    public List<TestCase> getTestCasesFor(Configuration config) {
        this.runConfigurationWithFlags(config, this.createFlagsArray("--dryRunFor", "all"));
        return null;
    }

    private Configuration parseConfiguration(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            throw new ConfigurationException("Could not find " + configFile);
        }
        return new UserConfigurationSource(configFile).parse(this.baseDir, new YamlParser());
    }

    private void runConfigurationWithFlags(Configuration config, String[] flags) {
        ArrayList<Module> initializeModules = Lists.newArrayList();
        try {
            LogManager.getLogManager().readConfiguration(this.runnerMode.getLogConfig());
            File basePath = config.getBasePath().getCanonicalFile();
            initializeModules.add(new InitializeModule(this.pluginLoader, basePath, new Args4jFlagsParser(), this.runnerMode));
            initializeModules.add(new PluginInitializerModule());
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not find " + config.getBasePath(), e);
        }
        Injector initializeInjector = Guice.createInjector(initializeModules);
        List<Module> actionRunnerModules = initializeInjector.getInstance(Initializer.class).initialize(this.pluginModules, this.defaultConfiguration, this.runnerMode, flags);
        Injector injector = Guice.createInjector(actionRunnerModules);
        injector.getInstance(ActionRunner.class).runActions();
    }

    private CmdLineFlag findServerHandlerPrefixFlag() {
        for (int i = 0; i < this.defaultFlags.length; ++i) {
            if (!this.defaultFlags[i].startsWith("--serverHandlerPrefix")) continue;
            String flag = this.defaultFlags[i];
            String value = "";
            if (i + 1 < this.defaultFlags.length) {
                value = this.defaultFlags[i + 1];
            }
            return new CmdLineFlag(flag, value);
        }
        return null;
    }

    private final class PluginInitializerModule
    implements Module {
        private PluginInitializerModule() {
        }

        public void configure(Binder binder) {
            Multibinder<PluginInitializer> setBinder = Multibinder.newSetBinder(binder, PluginInitializer.class);
            for (Class initializer : JsTestDriver.this.initializers) {
                setBinder.addBinding().to(initializer);
            }
        }
    }
}

