--
-- create table.
--
DROP TABLE IF EXISTS tbl_cluster1;
DROP TABLE IF EXISTS tbl_cluster2;
DROP TABLE IF EXISTS tbl_gistkey;
DROP TABLE IF EXISTS tbl_pkey_only;
DROP TABLE IF EXISTS tbl_ckey_only;

BEGIN;
CREATE TABLE tbl_cluster1 (
	col1 int,
	":-)" text,
	col3 timestamp,
	primary key(":-)", col1)
) WITH (fillfactor = 70);

CREATE TABLE tbl_cluster2 (
	col1 int,
	":-)" text,
	col3 timestamp,
	primary key(":-)", col1)
) WITH (fillfactor = 70);

CREATE INDEX cidx_cluster1 ON tbl_cluster1 (col3, ":-)", length(":-)"));
ALTER TABLE tbl_cluster1 CLUSTER ON cidx_cluster1;

CREATE INDEX cidx_cluster2 ON tbl_cluster2 (col3, ":-)", length(":-)"));
ALTER TABLE tbl_cluster2 CLUSTER ON cidx_cluster2;


-- check for option -o 
-- vC}L[̂ݑ
CREATE TABLE tbl_pkey_only (
	col1 int PRIMARY KEY,
	":-)" text
);

-- NX^L[̂ݑ
CREATE TABLE tbl_ckey_only (
	col1 int,
	":-)" text,
	col3 timestamp
) WITH (fillfactor = 70);

CREATE INDEX cidx_ckey_only ON tbl_ckey_only (col3, ":-)");
ALTER TABLE tbl_ckey_only CLUSTER ON cidx_ckey_only;

-- GIST
CREATE TABLE tbl_gistkey (
	id integer PRIMARY KEY,
	c circle
);

CREATE INDEX cidx_circle ON tbl_gistkey USING gist (c);
ALTER TABLE tbl_gistkey CLUSTER ON cidx_circle;

INSERT INTO tbl_cluster1 VALUES(1, 'admin', '2008/12/31 10:00:00'::timestamp);
INSERT INTO tbl_cluster1 VALUES(2, 'king', '2008/01/01 00:00:00'::timestamp);
INSERT INTO tbl_cluster1 VALUES(3, 'joker', '2008/03/04 12:00:00'::timestamp);
INSERT INTO tbl_cluster1 VALUES(4, 'queen', '2008/03/05 15:00:00'::timestamp);
INSERT INTO tbl_cluster1 VALUES(5, 'joker', '2008/01/01 00:00:00'::timestamp);

INSERT INTO tbl_cluster2 VALUES(1, 'admin', '2008/12/31 10:00:00'::timestamp);
INSERT INTO tbl_cluster2 VALUES(2, 'king', '2008/01/01 00:00:00'::timestamp);
INSERT INTO tbl_cluster2 VALUES(3, 'joker', '2008/03/04 12:00:00'::timestamp);
INSERT INTO tbl_cluster2 VALUES(4, 'queen', '2008/03/05 15:00:00'::timestamp);
INSERT INTO tbl_cluster2 VALUES(5, 'joker', '2008/01/01 00:00:00'::timestamp);

COMMIT;
