--
-- reorg_indexdef()
--
BEGIN;

CREATE SCHEMA reorg_test;
CREATE SCHEMA """reorg"" _ ""test""";

-- none quote ident
CREATE TABLE tbl (col1 int, col2 text, col3 tsvector);
CREATE INDEX idx ON tbl USING gist (col3) WITH (FILLFACTOR=70) TABLESPACE pg_default;
CREATE UNIQUE INDEX idx_unique ON tbl USING btree (col1 DESC NULLS LAST, col2 ASC NULLS FIRST) WITH (FILLFACTOR=70) TABLESPACE pg_default;

-- quote ident pattern
CREATE TABLE " t b l " (" c o l 1 " int, " c o l 2 " text);
CREATE TABLE """t""b""l""" ("""c""o""l""1""" int, """c""o""l""2""" text);
CREATE TABLE """" ("""" int, " " text);
CREATE TABLE " "" "" "" " (" "" " int, """ """ text);
CREATE INDEX " i d x " ON " t b l " (" c o l 1 ", " c o l 2 ");
CREATE INDEX """i""d""x""" ON """t""b""l""" ("""c""o""l""1""", """c""o""l""2""");
CREATE INDEX " " ON """" ("""", " ");
CREATE INDEX """ "" """ ON " "" "" "" " (" "" ", """ """);

-- with schema pattern
CREATE TABLE reorg_test.tbl (col1 text, col2 text);
CREATE TABLE """reorg"" _ ""test""".tbl (col1 text, col2 text);
CREATE TABLE """reorg"" _ ""test"""."t"" b""l" ("((col()1((" text, "))col)(2((" text);
CREATE INDEX idx1 ON reorg_test.tbl (col1, ('a' || 'b'));
CREATE INDEX idx2 ON """reorg"" _ ""test""".tbl (textcat('a', 'b'), col2);
CREATE INDEX idx3 ON """reorg"" _ ""test"""."t"" b""l" (("((col()1((" || 'a'), ("))col)(2((" || 'b'));

COMMIT;

-- show oid of target index
SELECT
	indexrelid::regclass AS idxname,
	indrelid AS indrelid,
	indexrelid AS indexrelid
FROM pg_index WHERE indexrelid IN(
	'public.idx'::regclass,
	'public.idx_unique'::regclass,
	'public." i d x "'::regclass,
	'public."""i""d""x"""'::regclass,
	'public." "'::regclass,
	'public.""" "" """'::regclass,
	'reorg_test.idx1'::regclass,
	'"""reorg"" _ ""test""".idx2'::regclass,
	'"""reorg"" _ ""test""".idx3'::regclass
);

-- execute reorg_indexdef()
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = 'idx'::regclass),
	(SELECT oid FROM pg_class WHERE oid = 'tbl'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = 'idx_unique'::regclass),
	(SELECT oid FROM pg_class WHERE oid = 'tbl'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '" i d x "'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '" t b l "'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '"""i""d""x"""'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '"""t""b""l"""'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '" "'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '""""'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '""" "" """'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '" "" "" "" "'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = 'reorg_test.idx1'::regclass),
	(SELECT oid FROM pg_class WHERE oid = 'reorg_test.tbl'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test""".idx2'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test""".tbl'::regclass));
SELECT reorg.reorg_indexdef(
	(SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test""".idx3'::regclass),
	(SELECT oid FROM pg_class WHERE oid = '"""reorg"" _ ""test"""."t"" b""l"'::regclass));

-- clean up
DROP TABLE IF EXISTS public.tbl;
DROP TABLE IF EXISTS public." t b l ";
DROP TABLE IF EXISTS public."""t""b""l""";
DROP TABLE IF EXISTS public."""";
DROP TABLE IF EXISTS public." "" "" "" ";
DROP TABLE IF EXISTS reorg_test.tbl;
DROP TABLE IF EXISTS """reorg"" _ ""test""".tbl;
DROP TABLE IF EXISTS """reorg"" _ ""test"""."t"" b""l";

DROP SCHEMA reorg_test CASCADE;
DROP SCHEMA """reorg"" _ ""test""" CASCADE;
