/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.tasklist.internal;

import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListItem;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.Set;

public class TaskListNodeRenderer
implements NodeRenderer {
    public static final AttributablePart TASK_ITEM_PARAGRAPH = new AttributablePart("TASK_ITEM_PARAGRAPH");
    final String doneMarker;
    final String notDoneMarker;
    private final String tightItemClass;
    private final String looseItemClass;
    private final String itemDoneClass;
    private final String itemNotDoneClass;
    final String paragraphClass;
    private final ListOptions listOptions;

    public TaskListNodeRenderer(DataHolder options) {
        this.doneMarker = (String)options.get(TaskListExtension.ITEM_DONE_MARKER);
        this.notDoneMarker = (String)options.get(TaskListExtension.ITEM_NOT_DONE_MARKER);
        this.tightItemClass = (String)options.get(TaskListExtension.TIGHT_ITEM_CLASS);
        this.looseItemClass = (String)options.get(TaskListExtension.LOOSE_ITEM_CLASS);
        this.itemDoneClass = (String)options.get(TaskListExtension.ITEM_DONE_CLASS);
        this.itemNotDoneClass = (String)options.get(TaskListExtension.ITEM_NOT_DONE_CLASS);
        this.paragraphClass = (String)options.get(TaskListExtension.PARAGRAPH_CLASS);
        this.listOptions = ListOptions.getFrom((DataHolder)options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(TaskListItem.class, (CustomNodeRenderer)new CustomNodeRenderer<TaskListItem>(){

            public void render(TaskListItem node, NodeRendererContext context, HtmlWriter html) {
                TaskListNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    void render(final TaskListItem node, final NodeRendererContext context, final HtmlWriter html) {
        String itemDoneStatusClass;
        final BasedSequence sourceText = context.getHtmlOptions().sourcePositionParagraphLines || node.getFirstChild() == null ? node.getChars() : node.getFirstChild().getChars();
        String string = itemDoneStatusClass = node.isItemDoneMarker() ? this.itemDoneClass : this.itemNotDoneClass;
        if (this.listOptions.isTightListItem((ListItem)node)) {
            if (!this.tightItemClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)this.tightItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.tightItemClass)) {
                html.attr((CharSequence)"class", (CharSequence)itemDoneStatusClass);
            }
            ((HtmlWriter)html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"li", new Runnable(){

                @Override
                public void run() {
                    html.raw((CharSequence)(node.isItemDoneMarker() ? TaskListNodeRenderer.this.doneMarker : TaskListNodeRenderer.this.notDoneMarker));
                    context.renderChildren((Node)node);
                }
            });
        } else {
            if (!this.looseItemClass.isEmpty()) {
                html.attr((CharSequence)"class", (CharSequence)this.looseItemClass);
            }
            if (!itemDoneStatusClass.isEmpty() && !itemDoneStatusClass.equals(this.looseItemClass)) {
                html.attr((CharSequence)"class", (CharSequence)itemDoneStatusClass);
            }
            html.withAttr(CoreNodeRenderer.LOOSE_LIST_ITEM).tagIndent((CharSequence)"li", new Runnable(){

                @Override
                public void run() {
                    if (!TaskListNodeRenderer.this.paragraphClass.isEmpty()) {
                        html.attr((CharSequence)"class", (CharSequence)TaskListNodeRenderer.this.paragraphClass);
                    }
                    html.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset()).withAttr(TASK_ITEM_PARAGRAPH).tagLine((CharSequence)"p", new Runnable(){

                        @Override
                        public void run() {
                            html.raw((CharSequence)(node.isItemDoneMarker() ? TaskListNodeRenderer.this.doneMarker : TaskListNodeRenderer.this.notDoneMarker));
                            context.renderChildren((Node)node);
                        }
                    });
                }
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new TaskListNodeRenderer(options);
        }
    }
}

