/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.wagon.git;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.trajano.wagon.git.internal.AbstractGitWagon;
import net.trajano.wagon.git.internal.GitUri;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.TextParseException;

@Component(role=Wagon.class, hint="github", instantiationStrategy="per-lookup")
public class GitHubPagesWagon
extends AbstractGitWagon {
    private static final Pattern GITHUB_PAGES_HOST_PATTERN = Pattern.compile("([a-z0-9-]+)\\.github\\.io.?");
    private static final Pattern GITHUB_PAGES_PATH_PATTERN = Pattern.compile("/([^/]+)(/.*)?");
    private static final Logger LOG = Logger.getLogger("net.trajano.wagon.git", "META-INF/Messages");
    private static final String MESSAGES = "META-INF/Messages";
    private static final ResourceBundle R = ResourceBundle.getBundle("META-INF/Messages");

    @Override
    public GitUri buildGitUri(URI uri) throws IOException, URISyntaxException {
        String username;
        URI finalUri;
        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
            HttpURLConnection urlConnection = (HttpURLConnection)uri.toURL().openConnection();
            urlConnection.connect();
            urlConnection.getResponseCode();
            finalUri = urlConnection.getURL().toURI();
            urlConnection.disconnect();
        } else {
            finalUri = uri;
        }
        Matcher m = GITHUB_PAGES_HOST_PATTERN.matcher(finalUri.getHost());
        if (m.matches()) {
            username = m.group(1);
        } else {
            String cnameHost = this.getCnameForHost(finalUri.getHost());
            Matcher m2 = GITHUB_PAGES_HOST_PATTERN.matcher(cnameHost);
            if (!m2.matches()) {
                throw new URISyntaxException(finalUri.toASCIIString(), String.format(R.getString("invalidGitHubPagesHost"), uri));
            }
            username = m2.group(1);
        }
        if ("".equals(finalUri.getPath()) || "/".equals(finalUri.getPath())) {
            return this.buildRootUri(username);
        }
        return this.buildProjectUri(username, finalUri.getPath());
    }

    private GitUri buildProjectUri(String username, String path) {
        Matcher pathMatcher = GITHUB_PAGES_PATH_PATTERN.matcher(path);
        pathMatcher.matches();
        String resource = pathMatcher.group(2);
        return new GitUri("ssh://git@github.com/" + username + "/" + pathMatcher.group(1) + ".git", "gh-pages", resource);
    }

    private GitUri buildRootUri(String username) {
        return new GitUri("ssh://git@github.com/" + username + "/" + username + ".github.io.git", "master", "/");
    }

    private String getCnameForHost(String host) throws TextParseException {
        Lookup lookup = new Lookup(host, 5);
        lookup.run();
        if (lookup.getAnswers().length == 0) {
            LOG.log(Level.SEVERE, "unableToFindCNAME", new Object[]{host});
            return null;
        }
        return ((CNAMERecord)lookup.getAnswers()[0]).getTarget().toString();
    }

    @Override
    public File getFileForResource(String resourceName) throws GitAPIException, IOException, URISyntaxException {
        Git resourceGit;
        GitUri resolved = this.buildGitUri(URI.create(URI.create(this.getRepository().getUrl()).getSchemeSpecificPart()).resolve(resourceName.replace(" ", "%20")));
        try {
            resourceGit = this.getGit(resolved.getGitRepositoryUri());
        }
        catch (ResourceDoesNotExistException e) {
            LOG.throwing(((Object)((Object)this)).getClass().getName(), "getFileForResource", e);
            return null;
        }
        File workTree = resourceGit.getRepository().getWorkTree();
        File resolvedFile = new File(workTree, resolved.getResource());
        if (!resolvedFile.getCanonicalPath().startsWith(workTree.getCanonicalPath())) {
            throw new IOException(String.format("The resolved file '%s' is not in work tree '%s'", resolvedFile, workTree));
        }
        return resolvedFile;
    }
}

