/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codehaus.plexus.util.FileUtils;

public class Expand {
    private File dest;
    private File source;
    private boolean overwrite = true;

    public void execute() throws Exception {
        this.expandFile(this.source, this.dest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void expandFile(File srcF, File dir) throws Exception {
        ZipInputStream zis = null;
        try {
            try {
                zis = new ZipInputStream(new FileInputStream(srcF));
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    this.extractFile(srcF, dir, zis, ze.getName(), new Date(ze.getTime()), ze.isDirectory());
                }
                Object var6_6 = null;
                if (zis == null) return;
            }
            catch (IOException ioe) {
                throw new Exception("Error while expanding " + srcF.getPath(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zis == null) throw throwable;
            try {
                zis.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        zis.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory) throws Exception {
        File f = FileUtils.resolveFile(dir, entryName);
        try {
            block11: {
                if (!this.overwrite && f.exists() && f.lastModified() >= entryDate.getTime()) {
                    return;
                }
                File dirF = f.getParentFile();
                dirF.mkdirs();
                if (isDirectory) {
                    f.mkdirs();
                } else {
                    byte[] buffer = new byte[1024];
                    int length = 0;
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(f);
                        while ((length = compressedInputStream.read(buffer)) >= 0) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        fos = null;
                        Object var13_13 = null;
                        if (fos == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        if (fos == null) throw throwable;
                        try {
                            fos.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException e) {}
                    fos.close();
                }
            }
            f.setLastModified(entryDate.getTime());
            return;
        }
        catch (FileNotFoundException ex) {
            throw new Exception("Can't extract file " + srcF.getPath(), ex);
        }
    }

    public void setDest(File d) {
        this.dest = d;
    }

    public void setSrc(File s) {
        this.source = s;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }
}

