/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.CompileRegexNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToRegExpNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNode;
import com.oracle.truffle.js.runtime.JSContext;

public abstract class JSToRegExpNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    @Node.Child
    private CreateRegExpNode createRegExpNode;

    protected JSToRegExpNode(JSContext context) {
        this.context = context;
    }

    public abstract DynamicObject execute(Object var1);

    public static JSToRegExpNode create(JSContext context) {
        return JSToRegExpNodeGen.create(context);
    }

    @Specialization(guards={"isJSRegExp(regExp)"})
    protected DynamicObject returnRegExp(DynamicObject regExp) {
        return regExp;
    }

    @Specialization(guards={"!isJSRegExp(patternObj)"})
    protected DynamicObject createRegExp(Object patternObj, @Cached(value="createUndefinedToEmpty()") JSToStringNode toStringNode, @Cached(value="create(context)") CompileRegexNode compileRegexNode) {
        String pattern = toStringNode.executeString(patternObj);
        Object regex = compileRegexNode.compile(pattern);
        return this.getCreateRegExpNode().createRegExp(regex);
    }

    private CreateRegExpNode getCreateRegExpNode() {
        if (this.createRegExpNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.createRegExpNode = (CreateRegExpNode)this.insert(CreateRegExpNode.create(this.context));
        }
        return this.createRegExpNode;
    }
}

