/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.NumberFunctionBuiltins;
import com.oracle.truffle.js.builtins.NumberPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSPrimitiveObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import java.util.EnumSet;

public final class JSNumber
extends JSPrimitiveObject
implements JSConstructorFactory.WithFunctions {
    public static final String TYPE_NAME = "number";
    public static final String CLASS_NAME = "Number";
    public static final String PROTOTYPE_NAME = "Number.prototype";
    public static final JSNumber INSTANCE = new JSNumber();
    private static final Property VALUE_PROPERTY;
    private static final HiddenKey VALUE_ID;
    private static final double NUMBER_EPSILON = 2.220446049250313E-16;
    private static final double MAX_SAFE_INTEGER = 9.007199254740991E15;
    private static final double MIN_SAFE_INTEGER = -9.007199254740991E15;

    private JSNumber() {
    }

    public static DynamicObject create(JSContext context, Number value) {
        DynamicObject obj = JSObject.create(context, context.getNumberFactory(), value);
        assert (JSNumber.isJSNumber(obj));
        return obj;
    }

    private static Number getNumberField(DynamicObject obj) {
        assert (JSNumber.isJSNumber(obj));
        return (Number)VALUE_PROPERTY.get(obj, JSNumber.isJSNumber(obj));
    }

    public static Number valueOf(DynamicObject obj) {
        return JSNumber.getNumberField(obj);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject numberPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)INSTANCE);
        JSObjectUtil.putHiddenProperty(numberPrototype, VALUE_PROPERTY, 0);
        JSObjectUtil.putConstructorProperty(context, numberPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, numberPrototype, NumberPrototypeBuiltins.BUILTINS);
        return numberPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(VALUE_PROPERTY);
        return initialShape;
    }

    @Override
    public void fillConstructor(JSRealm realm, DynamicObject constructor) {
        JSConstructorFactory.WithFunctions.super.fillConstructor(realm, constructor);
        JSContext context = realm.getContext();
        JSObjectUtil.putDataProperty(context, constructor, "NaN", (Object)Double.NaN);
        JSObjectUtil.putDataProperty(context, constructor, "POSITIVE_INFINITY", (Object)Double.POSITIVE_INFINITY);
        JSObjectUtil.putDataProperty(context, constructor, "NEGATIVE_INFINITY", (Object)Double.NEGATIVE_INFINITY);
        JSObjectUtil.putDataProperty(context, constructor, "MAX_VALUE", (Object)Double.MAX_VALUE);
        JSObjectUtil.putDataProperty(context, constructor, "MIN_VALUE", (Object)Double.MIN_VALUE);
        if (context.getEcmaScriptVersion() >= 6) {
            JSObjectUtil.putDataProperty(context, constructor, "EPSILON", (Object)2.220446049250313E-16);
            JSObjectUtil.putDataProperty(context, constructor, "MAX_SAFE_INTEGER", (Object)9.007199254740991E15);
            JSObjectUtil.putDataProperty(context, constructor, "MIN_SAFE_INTEGER", (Object)-9.007199254740991E15);
        }
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, NumberFunctionBuiltins.BUILTINS);
    }

    public static boolean isJSNumber(Object obj) {
        return JSObject.isDynamicObject(obj) && JSNumber.isJSNumber((DynamicObject)obj);
    }

    public static boolean isJSNumber(DynamicObject obj) {
        return JSNumber.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return super.safeToString(obj, depth, context);
        }
        Number primitiveValue = JSNumber.valueOf(obj);
        return JSRuntime.objectToConsoleString(obj, this.getBuiltinToStringTag(obj), depth, new String[]{"PrimitiveValue"}, new Object[]{primitiveValue});
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getNumberPrototype();
    }

    static {
        VALUE_ID = new HiddenKey("value");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        VALUE_PROPERTY = JSObjectUtil.makeHiddenProperty(VALUE_ID, allocator.locationForType(Number.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
    }
}

