/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.surefire.booter.BiProperty;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.MasterProcessCommand;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandReader {
    private static final String LAST_TEST_SYMBOL = "";
    private static final CommandReader READER = new CommandReader();
    private final Queue<BiProperty<MasterProcessCommand, CommandListener>> listeners = new ConcurrentLinkedQueue<BiProperty<MasterProcessCommand, CommandListener>>();
    private final Thread commandThread = DaemonThreadFactory.newDaemonThread(new CommandRunnable(), "surefire-forkedjvm-command-thread");
    private final AtomicReference<Thread.State> state = new AtomicReference<Thread.State>(Thread.State.NEW);
    private final CountDownLatch startMonitor = new CountDownLatch(1);
    private final Semaphore nextCommandNotifier = new Semaphore(0);
    private final CopyOnWriteArrayList<String> testClasses = new CopyOnWriteArrayList();
    private volatile Shutdown shutdown;
    private int iteratedCount;

    public static CommandReader getReader() {
        CommandReader reader = READER;
        if (reader.state.compareAndSet(Thread.State.NEW, Thread.State.RUNNABLE)) {
            reader.commandThread.start();
        }
        return reader;
    }

    public CommandReader setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
        return this;
    }

    public boolean awaitStarted() throws TestSetFailedException {
        if (this.state.get() == Thread.State.RUNNABLE) {
            try {
                this.startMonitor.await();
                return true;
            }
            catch (InterruptedException e) {
                throw new TestSetFailedException(e.getLocalizedMessage());
            }
        }
        return false;
    }

    public void addListener(CommandListener listener) {
        this.listeners.add(new BiProperty<Object, CommandListener>(null, listener));
    }

    public void addTestListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.RUN_CLASS, listener);
    }

    public void addTestsFinishedListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.TEST_SET_FINISHED, listener);
    }

    public void addSkipNextTestsListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.SKIP_SINCE_NEXT_TEST, listener);
    }

    public void addShutdownListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.SHUTDOWN, listener);
    }

    public void addNoopListener(CommandListener listener) {
        this.addListener(MasterProcessCommand.NOOP, listener);
    }

    private void addListener(MasterProcessCommand cmd, CommandListener listener) {
        this.listeners.add(new BiProperty<MasterProcessCommand, CommandListener>(cmd, listener));
    }

    public void removeListener(CommandListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            BiProperty listenerWrapper = (BiProperty)it.next();
            if (listener != listenerWrapper.getP2()) continue;
            it.remove();
        }
    }

    Iterator<String> iterated() {
        return this.testClasses.subList(0, this.iteratedCount).iterator();
    }

    Iterable<String> getIterableClasses(PrintStream originalOutStream) {
        return new ClassesIterable(originalOutStream);
    }

    public void stop() {
        if (this.state.compareAndSet(Thread.State.NEW, Thread.State.TERMINATED) || this.state.compareAndSet(Thread.State.RUNNABLE, Thread.State.TERMINATED)) {
            this.makeQueueFull();
            this.listeners.clear();
            this.commandThread.interrupt();
        }
    }

    private boolean isStopped() {
        return this.state.get() == Thread.State.TERMINATED;
    }

    private boolean isQueueFull() {
        int searchFrom = StrictMath.max(0, this.testClasses.size() - 1);
        return this.testClasses.indexOf(LAST_TEST_SYMBOL, searchFrom) != -1;
    }

    private void makeQueueFull() {
        this.testClasses.addIfAbsent(LAST_TEST_SYMBOL);
    }

    private boolean insertToQueue(String test) {
        return StringUtils.isNotBlank(test) && !this.isQueueFull() && this.testClasses.add(test);
    }

    private void awaitNextTest() {
        this.nextCommandNotifier.acquireUninterruptibly();
    }

    private void wakeupIterator() {
        this.nextCommandNotifier.release();
    }

    private final class CommandRunnable
    implements Runnable {
        private CommandRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            CommandReader.this.startMonitor.countDown();
            DataInputStream stdIn = new DataInputStream(System.in);
            boolean isTestSetFinished = false;
            try {
                block12: while (CommandReader.this.state.get() == Thread.State.RUNNABLE) {
                    Command command = MasterProcessCommand.decode(stdIn);
                    if (command == null) {
                        System.err.println("[SUREFIRE] std/in stream corrupted: first sequence not recognized");
                        return;
                    }
                    switch (command.getCommandType()) {
                        case RUN_CLASS: {
                            String test = command.getData();
                            boolean inserted = CommandReader.this.insertToQueue(test);
                            if (!inserted) continue block12;
                            CommandReader.this.wakeupIterator();
                            this.insertToListeners(command);
                            continue block12;
                        }
                        case TEST_SET_FINISHED: {
                            CommandReader.this.makeQueueFull();
                            isTestSetFinished = true;
                            CommandReader.this.wakeupIterator();
                            this.insertToListeners(command);
                            continue block12;
                        }
                        case SHUTDOWN: {
                            CommandReader.this.makeQueueFull();
                            CommandReader.this.wakeupIterator();
                            this.insertToListeners(command);
                            continue block12;
                        }
                    }
                    this.insertToListeners(command);
                }
                return;
            }
            catch (EOFException e) {
                CommandReader.this.state.set(Thread.State.TERMINATED);
                if (isTestSetFinished) return;
                this.exitByConfiguration();
                return;
            }
            catch (IOException e) {
                CommandReader.this.state.set(Thread.State.TERMINATED);
                if (e.getCause() instanceof InterruptedException) return;
                System.err.println("[SUREFIRE] std/in stream corrupted");
                e.printStackTrace();
                return;
            }
            finally {
                if (!isTestSetFinished) {
                    CommandReader.this.makeQueueFull();
                }
                CommandReader.this.wakeupIterator();
            }
        }

        private void insertToListeners(Command cmd) {
            MasterProcessCommand expectedCommandType = cmd.getCommandType();
            for (BiProperty listenerWrapper : CommandReader.this.listeners) {
                MasterProcessCommand commandType = (MasterProcessCommand)((Object)listenerWrapper.getP1());
                CommandListener listener = (CommandListener)listenerWrapper.getP2();
                if (commandType != null && commandType != expectedCommandType) continue;
                listener.update(cmd);
            }
        }

        private void exitByConfiguration() {
            Shutdown shutdown = CommandReader.this.shutdown;
            if (shutdown != null) {
                CommandReader.this.makeQueueFull();
                CommandReader.this.wakeupIterator();
                this.insertToListeners(Command.toShutdown(shutdown));
                switch (shutdown) {
                    case EXIT: {
                        System.exit(1);
                    }
                    case KILL: {
                        Runtime.getRuntime().halt(1);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassesIterator
    implements Iterator<String> {
        private final PrintStream originalOutStream;
        private String clazz;
        private int nextQueueIndex;

        private ClassesIterator(PrintStream originalOutStream) {
            this.originalOutStream = originalOutStream;
        }

        @Override
        public boolean hasNext() {
            this.popUnread();
            return StringUtils.isNotBlank(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            this.popUnread();
            try {
                if (StringUtils.isBlank(this.clazz)) {
                    throw new NoSuchElementException(CommandReader.this.isStopped() ? "stream was stopped" : CommandReader.LAST_TEST_SYMBOL);
                }
                String string = this.clazz;
                return string;
            }
            finally {
                this.clazz = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void popUnread() {
            if (this.shouldFinish()) {
                this.clazz = null;
                return;
            }
            if (StringUtils.isBlank(this.clazz)) {
                this.requestNextTest();
                CommandReader.this.awaitNextTest();
                if (this.shouldFinish()) {
                    this.clazz = null;
                    return;
                }
                this.clazz = (String)CommandReader.this.testClasses.get(this.nextQueueIndex++);
                CommandReader.this.iteratedCount = this.nextQueueIndex;
            }
            if (CommandReader.this.isStopped()) {
                this.clazz = null;
            }
        }

        private void requestNextTest() {
            byte[] encoded = StringUtils.encodeStringForForkCommunication("N,0,want more!\n");
            this.originalOutStream.write(encoded, 0, encoded.length);
        }

        private boolean shouldFinish() {
            boolean wasLastTestRead = this.isEndSymbolAt(this.nextQueueIndex);
            return CommandReader.this.isStopped() || wasLastTestRead;
        }

        private boolean isEndSymbolAt(int index) {
            return CommandReader.this.isQueueFull() && 1 + index == CommandReader.this.testClasses.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassesIterable
    implements Iterable<String> {
        private final PrintStream originalOutStream;

        ClassesIterable(PrintStream originalOutStream) {
            this.originalOutStream = originalOutStream;
        }

        @Override
        public Iterator<String> iterator() {
            return new ClassesIterator(this.originalOutStream);
        }
    }
}

