/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CP16BitMatchers;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.charset.ImmutableSortedListOfRanges;
import com.oracle.truffle.regex.charset.Range;
import com.oracle.truffle.regex.charset.RangesBuffer;
import com.oracle.truffle.regex.charset.SortedListOfRanges;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import java.util.Arrays;
import java.util.Iterator;

public final class CodePointSet
implements ImmutableSortedListOfRanges,
Comparable<CodePointSet>,
Iterable<Range>,
JsonConvertible {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    private static final CodePointSet CONSTANT_EMPTY;
    private static final CodePointSet CONSTANT_FULL;
    private static final CodePointSet[] CONSTANT_ASCII;
    private static final CodePointSet[] CONSTANT_INVERSE_ASCII;
    private static final CodePointSet[] CONSTANT_CASE_FOLD_ASCII;
    private final int[] ranges;

    private CodePointSet(int[] ranges) {
        this.ranges = ranges;
        assert (ranges.length == 0 || ranges[0] >= 0 && ranges[ranges.length - 1] <= 0x10FFFF);
        assert ((ranges.length & 1) == 0) : "ranges array must have an even length!";
        assert (this.rangesAreSortedAndDisjoint());
    }

    public int[] getRanges() {
        return this.ranges;
    }

    public static CodePointSet getEmpty() {
        return CONSTANT_EMPTY;
    }

    public static CodePointSet getFull() {
        return CONSTANT_FULL;
    }

    public static CodePointSet createNoDedup(int ... ranges) {
        return new CodePointSet(ranges);
    }

    public static CodePointSet create(int single) {
        if (single < 128) {
            return CONSTANT_ASCII[single];
        }
        return new CodePointSet(new int[]{single, single});
    }

    public static CodePointSet create(int ... ranges) {
        CodePointSet constant = CodePointSet.checkConstants(ranges, ranges.length);
        if (constant == null) {
            return new CodePointSet(ranges);
        }
        return constant;
    }

    public static CodePointSet create(IntRangesBuffer buf) {
        CodePointSet constant = CodePointSet.checkConstants(buf.getBuffer(), buf.length());
        if (constant == null) {
            return new CodePointSet(buf.toArray());
        }
        return constant;
    }

    private static CodePointSet checkConstants(int[] ranges, int length) {
        if (length == 0) {
            return CONSTANT_EMPTY;
        }
        if (length == 2) {
            if (ranges[0] == ranges[1] && ranges[0] < 128) {
                return CONSTANT_ASCII[ranges[0]];
            }
            if (ranges[0] == 0 && ranges[1] == 0x10FFFF) {
                return CONSTANT_FULL;
            }
        }
        if (length == 4) {
            if (ranges[0] == 0 && ranges[3] == 0x10FFFF && ranges[2] <= 128 && ranges[1] + 2 == ranges[2]) {
                return CONSTANT_INVERSE_ASCII[ranges[1] + 1];
            }
            if (ranges[0] == ranges[1] && ranges[0] >= 65 && ranges[0] <= 90 && ranges[2] == ranges[3] && ranges[2] == (ranges[0] | 0x20)) {
                return CONSTANT_CASE_FOLD_ASCII[ranges[0] - 65];
            }
        }
        for (CodePointSet predefCC : Constants.CONSTANT_CODE_POINT_SETS) {
            if (predefCC.ranges.length != length || !CodePointSet.rangesEqual(predefCC.ranges, ranges, length)) continue;
            return predefCC;
        }
        return null;
    }

    private static boolean rangesEqual(int[] a, int[] b, int length) {
        for (int i = 0; i < length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public CodePointSet createEmpty() {
        return CodePointSet.getEmpty();
    }

    public CodePointSet createFull() {
        return CodePointSet.getFull();
    }

    public CodePointSet create(RangesBuffer buffer) {
        assert (buffer instanceof IntRangesBuffer);
        return CodePointSet.create((IntRangesBuffer)buffer);
    }

    @Override
    public int getMinValue() {
        return 0;
    }

    @Override
    public int getMaxValue() {
        return 0x10FFFF;
    }

    @Override
    public int getLo(int i) {
        return this.ranges[i * 2];
    }

    @Override
    public int getHi(int i) {
        return this.ranges[i * 2 + 1];
    }

    @Override
    public int size() {
        return this.ranges.length / 2;
    }

    public int size16() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.getLo(this.size() - 1) > 65535) {
            assert (this.getLo(this.size() - 1) == 65536 && this.getHi(this.size() - 1) == 0x10FFFF);
            return this.size() - 1;
        }
        return this.size();
    }

    public char getLo16(int i) {
        int lo = this.getLo(i);
        assert (lo <= 65535) : this;
        return (char)lo;
    }

    public char getHi16(int i) {
        int hi = this.getHi(i);
        assert (hi <= 65535 || hi == 0x10FFFF) : this;
        return (char)hi;
    }

    @Override
    public IntRangesBuffer getBuffer1(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer1();
    }

    @Override
    public IntRangesBuffer getBuffer2(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer2();
    }

    @Override
    public IntRangesBuffer getBuffer3(CompilationBuffer compilationBuffer) {
        return compilationBuffer.getIntRangesBuffer3();
    }

    @Override
    public IntRangesBuffer createTempBuffer() {
        return new IntRangesBuffer();
    }

    @Override
    public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
        int bulkLength = (endIndex - startIndex) * 2;
        if (bulkLength == 0) {
            return;
        }
        assert (buffer instanceof IntRangesBuffer);
        IntRangesBuffer buf = (IntRangesBuffer)buffer;
        int newSize = buf.length() + bulkLength;
        buf.ensureCapacity(newSize);
        assert (buf.isEmpty() || this.rightOf(startIndex, buf, buf.size() - 1));
        System.arraycopy(this.ranges, startIndex * 2, buf.getBuffer(), buf.length(), bulkLength);
        buf.setLength(newSize);
    }

    @Override
    public boolean equalsBuffer(RangesBuffer buffer) {
        assert (buffer instanceof IntRangesBuffer);
        IntRangesBuffer buf = (IntRangesBuffer)buffer;
        return this.ranges.length == buf.length() && CodePointSet.rangesEqual(this.ranges, buf.getBuffer(), this.ranges.length);
    }

    public CodePointSet createInverse() {
        return CodePointSet.createInverse(this);
    }

    public static CodePointSet createInverse(SortedListOfRanges src) {
        assert (src.getMinValue() == 0);
        assert (src.getMaxValue() == 0x10FFFF);
        if (src.matchesNothing()) {
            return CodePointSet.getFull();
        }
        if (src.matchesSingleAscii()) {
            return CONSTANT_INVERSE_ASCII[src.getMin()];
        }
        int[] invRanges = new int[src.sizeOfInverse() * 2];
        int i = 0;
        if (src.getLo(0) > src.getMinValue()) {
            CodePointSet.setRange(invRanges, i++, src.getMinValue(), src.getLo(0) - 1);
        }
        for (int ia = 1; ia < src.size(); ++ia) {
            CodePointSet.setRange(invRanges, i++, src.getHi(ia - 1) + 1, src.getLo(ia) - 1);
        }
        if (src.getHi(src.size() - 1) < src.getMaxValue()) {
            CodePointSet.setRange(invRanges, i++, src.getHi(src.size() - 1) + 1, src.getMaxValue());
        }
        return new CodePointSet(invRanges);
    }

    private static void setRange(int[] arr, int i, int lo, int hi) {
        arr[i * 2] = lo;
        arr[i * 2 + 1] = hi;
    }

    public boolean inverseIsSameHighByte16Bit() {
        int last = this.numberOf16BitRanges() - 1;
        if (last <= 0) {
            return false;
        }
        if (CP16BitMatchers.highByte(this.getMin()) == CP16BitMatchers.highByte(this.getHi(last))) {
            return false;
        }
        return this.matchesMinAndMax() && CP16BitMatchers.highByte(this.getHi(0) + 1) == CP16BitMatchers.highByte(this.getLo(last) - 1);
    }

    @Override
    public int compareTo(CodePointSet o) {
        if (this == o) {
            return 0;
        }
        if (this.matchesEverything()) {
            if (o.matchesEverything()) {
                return 0;
            }
            return 1;
        }
        if (this.matchesNothing()) {
            if (o.matchesNothing()) {
                return 0;
            }
            return -1;
        }
        if (o.matchesEverything()) {
            return -1;
        }
        if (o.matchesNothing()) {
            return 1;
        }
        int cmp = this.size() - o.size();
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < this.size(); ++i) {
            cmp = this.getLo(i) - o.getLo(i);
            if (cmp == 0) continue;
            return cmp;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CodePointSet) {
            return Arrays.equals(this.ranges, ((CodePointSet)obj).ranges);
        }
        if (obj instanceof SortedListOfRanges) {
            return this.equalsListOfRanges((SortedListOfRanges)obj);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranges);
    }

    @Override
    public Iterator<Range> iterator() {
        return new ImmutableListOfIntRangesIterator(this);
    }

    public int numberOf16BitRanges() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.getLo(this.size() - 1) > 65535) {
            assert (this.getLo(this.size() - 1) == 65536 && this.getHi(this.size() - 1) == 0x10FFFF);
            return this.size() - 1;
        }
        return this.size();
    }

    public Iterator<Range> iterator16Bit() {
        return new ImmutableListOf16BitIntRangesIterator(this);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.array(this.ranges);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.defaultToString();
    }

    @CompilerDirectives.TruffleBoundary
    public String dumpRaw() {
        StringBuilder sb = new StringBuilder(this.size() * 20);
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.format("0x%06x, 0x%06x", this.getLo(i), this.getHi(i)));
        }
        return sb.toString();
    }

    public char[] inverseToCharArray() {
        char[] array = new char[this.inverseValueCount()];
        int index = 0;
        int lastHi = -1;
        for (int i = 0; i < this.size(); ++i) {
            for (int j = lastHi + 1; j < this.getLo(i); ++j) {
                array[index++] = (char)j;
            }
            lastHi = this.getHi(i);
        }
        for (int j = lastHi + 1; j <= this.getMaxValue(); ++j) {
            array[index++] = (char)j;
        }
        return array;
    }

    static {
        int i;
        CONSTANT_EMPTY = new CodePointSet(new int[0]);
        CONSTANT_FULL = new CodePointSet(new int[]{0, 0x10FFFF});
        CONSTANT_ASCII = new CodePointSet[128];
        CONSTANT_INVERSE_ASCII = new CodePointSet[128];
        CONSTANT_CASE_FOLD_ASCII = new CodePointSet[26];
        CodePointSet.CONSTANT_ASCII[0] = new CodePointSet(new int[]{0, 0});
        CodePointSet.CONSTANT_INVERSE_ASCII[0] = new CodePointSet(new int[]{1, 0x10FFFF});
        for (i = 1; i < 128; ++i) {
            CodePointSet.CONSTANT_ASCII[i] = new CodePointSet(new int[]{i, i});
            CodePointSet.CONSTANT_INVERSE_ASCII[i] = new CodePointSet(new int[]{0, i - 1, i + 1, 0x10FFFF});
        }
        for (i = 65; i <= 90; ++i) {
            CodePointSet.CONSTANT_CASE_FOLD_ASCII[i - 65] = new CodePointSet(new int[]{i, i, Character.toLowerCase(i), Character.toLowerCase(i)});
        }
    }

    private static final class ImmutableListOf16BitIntRangesIterator
    implements Iterator<Range> {
        private final CodePointSet ranges;
        private final int size;
        private int i = 0;

        private ImmutableListOf16BitIntRangesIterator(CodePointSet ranges) {
            this.ranges = ranges;
            this.size = ranges.numberOf16BitRanges();
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public Range next() {
            assert (this.hasNext());
            Range ret = new Range(this.ranges.getLo16(this.i), this.ranges.getHi16(this.i));
            ++this.i;
            return ret;
        }
    }

    private static final class ImmutableListOfIntRangesIterator
    implements Iterator<Range> {
        private final CodePointSet ranges;
        private int i = 0;

        private ImmutableListOfIntRangesIterator(CodePointSet ranges) {
            this.ranges = ranges;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.ranges.size();
        }

        @Override
        public Range next() {
            Range ret = new Range(this.ranges.getLo(this.i), this.ranges.getHi(this.i));
            ++this.i;
            return ret;
        }
    }
}

