/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.jekyll.front.matter.internal;

import com.vladsch.flexmark.ext.jekyll.front.matter.JekyllFrontMatterBlock;
import com.vladsch.flexmark.ext.jekyll.front.matter.internal.JekyllFrontMatterOptions;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParser;
import com.vladsch.flexmark.parser.block.AbstractBlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockContinue;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockParserFactory;
import com.vladsch.flexmark.parser.block.BlockStart;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.MatchedBlockParser;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.DocumentBlockParser;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JekyllFrontMatterBlockParser
extends AbstractBlockParser {
    private static String COL = "\\s*:?-{3,}:?\\s*";
    static Pattern JEKYLL_FRONT_MATTER_BLOCK_START = Pattern.compile("^-{3}(\\s.*)?");
    private static Pattern JEKYLL_FRONT_MATTER_BLOCK_END = Pattern.compile("^(-{3}|\\.{3})(\\s.*)?");
    private final JekyllFrontMatterBlock block = new JekyllFrontMatterBlock();
    private BlockContent content = new BlockContent();
    private final JekyllFrontMatterOptions options;
    private boolean inYAMLBlock;

    JekyllFrontMatterBlockParser(DataHolder options, BasedSequence openingMarker) {
        this.options = new JekyllFrontMatterOptions(options);
        this.inYAMLBlock = true;
        this.block.setOpeningMarker(openingMarker);
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        BasedSequence line = state.getLine();
        if (this.inYAMLBlock) {
            Matcher matcher = JEKYLL_FRONT_MATTER_BLOCK_END.matcher((CharSequence)line);
            if (matcher.matches()) {
                this.block.setClosingMarker(line.subSequence(matcher.start(1), matcher.end(1)));
                return BlockContinue.finished();
            }
            return BlockContinue.atIndex((int)state.getIndex());
        }
        if (JEKYLL_FRONT_MATTER_BLOCK_START.matcher((CharSequence)line).matches()) {
            this.inYAMLBlock = true;
            return BlockContinue.atIndex((int)state.getIndex());
        }
        return BlockContinue.none();
    }

    public void addLine(ParserState state, BasedSequence line) {
        this.content.add(line, state.getIndent());
    }

    public void closeBlock(ParserState state) {
        this.block.setContent(this.content.getLines().subList(1, this.content.getLineCount()));
        this.block.setCharsFromContent();
        this.content = null;
    }

    public void parseInlines(InlineParser inlineParser) {
    }

    private static class BlockFactory
    extends AbstractBlockParserFactory {
        private final JekyllFrontMatterOptions options;

        private BlockFactory(DataHolder options) {
            super(options);
            this.options = new JekyllFrontMatterOptions(options);
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            Matcher matcher;
            BasedSequence line = state.getLine();
            BlockParser parentParser = matchedBlockParser.getBlockParser();
            if (parentParser instanceof DocumentBlockParser && parentParser.getBlock().getFirstChild() == null && (matcher = JEKYLL_FRONT_MATTER_BLOCK_START.matcher((CharSequence)line)).matches()) {
                BasedSequence openingMarker = line.subSequence(0, 3);
                JekyllFrontMatterBlockParser parser = new JekyllFrontMatterBlockParser((DataHolder)state.getProperties(), openingMarker);
                return BlockStart.of((BlockParser[])new BlockParser[]{parser}).atIndex(-1);
            }
            return BlockStart.none();
        }
    }

    public static class Factory
    implements CustomBlockParserFactory {
        public Set<Class<? extends CustomBlockParserFactory>> getAfterDependents() {
            return null;
        }

        public Set<Class<? extends CustomBlockParserFactory>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public BlockParserFactory create(DataHolder options) {
            return new BlockFactory(options);
        }
    }
}

