/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.math.AbsNode;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=AbsNode.class)
public final class AbsNodeGen
extends AbsNode
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile abs0_negative_;

    private AbsNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0xC) == 0 && (state & 0xF) != 0) {
            return this.execute_int0(frameValue, state);
        }
        if ((state & 0xB) == 0 && (state & 0xF) != 0) {
            return this.execute_double1(frameValue, state);
        }
        return this.execute_generic2(frameValue, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_int0(VirtualFrame frameValue, int state) {
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        if ((state & 1) != 0) {
            try {
                return AbsNode.abs(arguments0Value_, this.abs0_negative_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 1;
                    this.state_ &= 0xFFFFFFFE;
                }
                finally {
                    lock.unlock();
                }
                return this.executeAndSpecialize(arguments0Value_);
            }
        }
        if ((state & 2) != 0) {
            return AbsNode.absIntSpecial(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    private Object execute_double1(VirtualFrame frameValue, int state) {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state & 4) != 0);
        return AbsNode.abs(arguments0Value_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execute_generic2(VirtualFrame frameValue, int state) {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 3) != 0 && arguments0Value_ instanceof Integer) {
            int arguments0Value__ = (Integer)arguments0Value_;
            if ((state & 1) != 0) {
                try {
                    return AbsNode.abs(arguments0Value__, this.abs0_negative_);
                }
                catch (ArithmeticException ex) {
                    Lock lock = this.getLock();
                    lock.lock();
                    try {
                        this.exclude_ |= 1;
                        this.state_ &= 0xFFFFFFFE;
                    }
                    finally {
                        lock.unlock();
                    }
                    return this.executeAndSpecialize(arguments0Value__);
                }
            }
            if ((state & 2) != 0) {
                return AbsNode.absIntSpecial(arguments0Value__);
            }
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, arguments0Value_);
            return AbsNode.abs(arguments0Value__);
        }
        if ((state & 8) != 0) {
            return this.abs(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_);
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        int state = this.state_;
        if ((state & 0xC) == 0 && (state & 0xE) != 0) {
            return this.executeDouble_int3(frameValue, state);
        }
        if ((state & 0xA) == 0 && (state & 0xE) != 0) {
            return this.executeDouble_double4(frameValue, state);
        }
        return this.executeDouble_generic5(frameValue, state);
    }

    private double executeDouble_int3(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        int arguments0Value_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 2) != 0);
        return AbsNode.absIntSpecial(arguments0Value_);
    }

    private double executeDouble_double4(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        double arguments0Value_;
        int arguments0Value_int = 0;
        long arguments0Value_long = 0L;
        try {
            if ((state & 0xE0) == 0 && (state & 0xF) != 0) {
                arguments0Value_long = this.arguments0_.executeLong(frameValue);
                arguments0Value_ = JSTypes.longToDouble(arguments0Value_long);
            } else if ((state & 0xD0) == 0 && (state & 0xF) != 0) {
                arguments0Value_int = this.arguments0_.executeInt(frameValue);
                arguments0Value_ = JSTypes.intToDouble(arguments0Value_int);
            } else if ((state & 0xB0) == 0 && (state & 0xF) != 0) {
                arguments0Value_ = this.arguments0_.executeDouble(frameValue);
            } else {
                Object arguments0Value__ = this.arguments0_.execute(frameValue);
                arguments0Value_ = JSTypesGen.expectImplicitDouble((state & 0xF0) >>> 4, arguments0Value__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(ex.getResult()));
        }
        assert ((state & 4) != 0);
        return AbsNode.abs(arguments0Value_);
    }

    private double executeDouble_generic5(VirtualFrame frameValue, int state) throws UnexpectedResultException {
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        if ((state & 2) != 0 && arguments0Value_ instanceof Integer) {
            int arguments0Value__ = (Integer)arguments0Value_;
            return AbsNode.absIntSpecial(arguments0Value__);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitDouble((state & 0xF0) >>> 4, arguments0Value_)) {
            double arguments0Value__ = JSTypesGen.asImplicitDouble((state & 0xF0) >>> 4, arguments0Value_);
            return AbsNode.abs(arguments0Value__);
        }
        if ((state & 8) != 0) {
            return this.abs(arguments0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(arguments0Value_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int arguments0Value_;
        int state = this.state_;
        try {
            arguments0Value_ = this.arguments0_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(ex.getResult()));
        }
        if ((state & 1) != 0) {
            try {
                return AbsNode.abs(arguments0Value_, this.abs0_negative_);
            }
            catch (ArithmeticException ex) {
                Lock lock = this.getLock();
                lock.lock();
                try {
                    this.exclude_ |= 1;
                    this.state_ &= 0xFFFFFFFE;
                }
                finally {
                    lock.unlock();
                }
                return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(arguments0Value_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0xE) == 0 && (state & 0xF) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 1) == 0 && (state & 0xF) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object executeAndSpecialize(Object arguments0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                if (exclude == 0) {
                    this.abs0_negative_ = ConditionProfile.createBinaryProfile();
                    this.state_ = state |= 1;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Integer n = AbsNode.abs(arguments0Value_, this.abs0_negative_);
                        return n;
                    }
                    catch (ArithmeticException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 1;
                            this.state_ &= 0xFFFFFFFE;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = this.executeAndSpecialize(arguments0Value_);
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                Double ex = AbsNode.absIntSpecial(arguments0Value_);
                return ex;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arguments0Value);
            if (doubleCast0 != 0) {
                double arguments0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arguments0Value);
                state |= doubleCast0 << 4;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                Double d = AbsNode.abs(arguments0Value_);
                return d;
            }
            this.state_ = state |= 8;
            lock.unlock();
            hasLock = false;
            Double d = this.abs(arguments0Value);
            return d;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xF & (state & 0xF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[5];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "abs";
        if ((state & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<ConditionProfile>> cached = new ArrayList<List<ConditionProfile>>();
            cached.add(Arrays.asList(this.abs0_negative_));
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "absIntSpecial";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "abs";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "abs";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static AbsNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new AbsNodeGen(context, builtin, arguments);
    }
}

