/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSLogicalNode;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@NodeInfo(shortName="||")
public class JSOrNode
extends JSLogicalNode {
    public JSOrNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right, false);
    }

    public static JSOrNode create(JavaScriptNode left, JavaScriptNode right) {
        return new JSOrNode(left, right);
    }

    public static JSOrNode createNotUndefinedOr(JavaScriptNode left, JavaScriptNode right) {
        return new NotUndefinedOrNode(left, right);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return this.getLeft().isResultAlwaysOfType(clazz) && this.getRight().isResultAlwaysOfType(clazz);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new JSOrNode(JSOrNode.cloneUninitialized(this.getLeft(), materializedTags), JSOrNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static class NotUndefinedOrNode
    extends JSOrNode {
        public NotUndefinedOrNode(JavaScriptNode left, JavaScriptNode right) {
            super(left, right);
        }

        @Override
        protected boolean toBoolean(Object operand) {
            return operand != Undefined.instance;
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new NotUndefinedOrNode(NotUndefinedOrNode.cloneUninitialized(this.getLeft(), materializedTags), NotUndefinedOrNode.cloneUninitialized(this.getRight(), materializedTags));
        }
    }
}

