/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.bridge;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout2;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.bridge.MirrorSelector;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.repository.Proxy;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;

@Component(role=MavenRepositorySystem.class, hint="default")
public class MavenRepositorySystem {
    @Requirement
    private Logger logger;
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> layouts;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private SettingsDecrypter settingsDecrypter;

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createProjectArtifact(String groupId, String artifactId, String metaVersionId) {
        return this.XcreateProjectArtifact(groupId, artifactId, metaVersionId);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        if (d.getVersion() == null) {
            return null;
        }
        try {
            versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        Artifact artifact = this.XcreateDependencyArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : d.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ':' + exclusion.getArtifactId());
            }
            artifact.setDependencyFilter((ArtifactFilter)new ExcludesArtifactFilter(exclusions));
        }
        return artifact;
    }

    public Artifact createExtensionArtifact(String groupId, String artifactId, String version) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.XcreateExtensionArtifact(groupId, artifactId, versionRange);
    }

    public Artifact createParentArtifact(String groupId, String artifactId, String version) {
        return this.XcreateParentArtifact(groupId, artifactId, version);
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            String version = plugin.getVersion();
            if (StringUtils.isEmpty((String)version)) {
                version = "RELEASE";
            }
            versionRange = VersionRange.createFromVersionSpec((String)version);
        }
        catch (InvalidVersionSpecificationException e) {
            return null;
        }
        return this.XcreatePluginArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange);
    }

    public List<ArtifactRepository> getEffectiveRepositories(List<ArtifactRepository> repositories) {
        if (repositories == null) {
            return null;
        }
        LinkedHashMap<String, ArrayList<ArtifactRepository>> reposByKey = new LinkedHashMap<String, ArrayList<ArtifactRepository>>();
        for (ArtifactRepository repository : repositories) {
            String key = repository.getId();
            ArrayList<ArtifactRepository> aliasedRepos = (ArrayList<ArtifactRepository>)reposByKey.get(key);
            if (aliasedRepos == null) {
                aliasedRepos = new ArrayList<ArtifactRepository>();
                reposByKey.put(key, aliasedRepos);
            }
            aliasedRepos.add(repository);
        }
        ArrayList<ArtifactRepository> effectiveRepositories = new ArrayList<ArtifactRepository>();
        for (List aliasedRepos : reposByKey.values()) {
            ArtifactRepository aliasedRepo3;
            ArrayList mirroredRepos = new ArrayList();
            ArrayList<ArtifactRepositoryPolicy> releasePolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo2 : aliasedRepos) {
                releasePolicies.add(aliasedRepo2.getReleases());
                mirroredRepos.addAll(aliasedRepo2.getMirroredRepositories());
            }
            ArtifactRepositoryPolicy releasePolicy = this.getEffectivePolicy(releasePolicies);
            ArrayList<ArtifactRepositoryPolicy> snapshotPolicies = new ArrayList<ArtifactRepositoryPolicy>(aliasedRepos.size());
            for (ArtifactRepository aliasedRepo3 : aliasedRepos) {
                snapshotPolicies.add(aliasedRepo3.getSnapshots());
            }
            ArtifactRepositoryPolicy snapshotPolicy = this.getEffectivePolicy(snapshotPolicies);
            aliasedRepo3 = (ArtifactRepository)aliasedRepos.get(0);
            ArtifactRepository effectiveRepository = MavenRepositorySystem.createArtifactRepository(aliasedRepo3.getId(), aliasedRepo3.getUrl(), aliasedRepo3.getLayout(), snapshotPolicy, releasePolicy);
            effectiveRepository.setAuthentication(aliasedRepo3.getAuthentication());
            effectiveRepository.setProxy(aliasedRepo3.getProxy());
            effectiveRepository.setMirroredRepositories(mirroredRepos);
            effectiveRepositories.add(effectiveRepository);
        }
        return effectiveRepositories;
    }

    private ArtifactRepositoryPolicy getEffectivePolicy(Collection<ArtifactRepositoryPolicy> policies) {
        ArtifactRepositoryPolicy effectivePolicy = null;
        for (ArtifactRepositoryPolicy policy : policies) {
            if (effectivePolicy == null) {
                effectivePolicy = new ArtifactRepositoryPolicy(policy);
                continue;
            }
            effectivePolicy.merge(policy);
        }
        return effectivePolicy;
    }

    public Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        return MirrorSelector.getMirror(repository, mirrors);
    }

    public void injectMirror(List<ArtifactRepository> repositories, List<Mirror> mirrors) {
        if (repositories != null && mirrors != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(repository, mirrors);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private Mirror getMirror(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.MirrorSelector selector;
        if (session != null && (selector = session.getMirrorSelector()) != null && (repo = selector.getMirror(RepositoryUtils.toRepo(repository))) != null) {
            Mirror mirror = new Mirror();
            mirror.setId(repo.getId());
            mirror.setUrl(repo.getUrl());
            mirror.setLayout(repo.getContentType());
            return mirror;
        }
        return null;
    }

    public void injectMirror(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                Mirror mirror = this.getMirror(session, repository);
                this.injectMirror(repository, mirror);
            }
        }
    }

    private void injectMirror(ArtifactRepository repository, Mirror mirror) {
        if (mirror != null) {
            ArtifactRepository original = MavenRepositorySystem.createArtifactRepository(repository.getId(), repository.getUrl(), repository.getLayout(), repository.getSnapshots(), repository.getReleases());
            repository.setMirroredRepositories(Collections.singletonList(original));
            repository.setId(mirror.getId());
            repository.setUrl(mirror.getUrl());
            if (StringUtils.isNotEmpty((String)mirror.getLayout())) {
                repository.setLayout(this.getLayout(mirror.getLayout()));
            }
        }
    }

    public void injectAuthentication(List<ArtifactRepository> repositories, List<Server> servers) {
        if (repositories != null) {
            HashMap<String, Server> serversById = new HashMap<String, Server>();
            if (servers != null) {
                for (Server server : servers) {
                    if (serversById.containsKey(server.getId())) continue;
                    serversById.put(server.getId(), server);
                }
            }
            for (ArtifactRepository repository : repositories) {
                Server server = (Server)serversById.get(repository.getId());
                if (server != null) {
                    DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
                    SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
                    server = result.getServer();
                    if (this.logger.isDebugEnabled()) {
                        for (SettingsProblem problem : result.getProblems()) {
                            this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
                        }
                    }
                    org.apache.maven.artifact.repository.Authentication authentication = new org.apache.maven.artifact.repository.Authentication(server.getUsername(), server.getPassword());
                    authentication.setPrivateKey(server.getPrivateKey());
                    authentication.setPassphrase(server.getPassphrase());
                    repository.setAuthentication(authentication);
                    continue;
                }
                repository.setAuthentication(null);
            }
        }
    }

    private org.apache.maven.artifact.repository.Authentication getAuthentication(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        Authentication auth;
        AuthenticationSelector selector;
        if (session != null && (selector = session.getAuthenticationSelector()) != null && (auth = selector.getAuthentication(repo = RepositoryUtils.toRepo(repository))) != null) {
            repo = new RemoteRepository.Builder(repo).setAuthentication(auth).build();
            AuthenticationContext authCtx = AuthenticationContext.forRepository((RepositorySystemSession)session, (RemoteRepository)repo);
            org.apache.maven.artifact.repository.Authentication result = new org.apache.maven.artifact.repository.Authentication(authCtx.get("username"), authCtx.get("password"));
            result.setPrivateKey(authCtx.get("privateKey.path"));
            result.setPassphrase(authCtx.get("privateKey.passphrase"));
            authCtx.close();
            return result;
        }
        return null;
    }

    public void injectAuthentication(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setAuthentication(this.getAuthentication(session, repository));
            }
        }
    }

    private Proxy getProxy(RepositorySystemSession session, ArtifactRepository repository) {
        RemoteRepository repo;
        org.eclipse.aether.repository.Proxy proxy;
        ProxySelector selector;
        if (session != null && (selector = session.getProxySelector()) != null && (proxy = selector.getProxy(repo = RepositoryUtils.toRepo(repository))) != null) {
            Proxy p = new Proxy();
            p.setHost(proxy.getHost());
            p.setProtocol(proxy.getType());
            p.setPort(proxy.getPort());
            if (proxy.getAuthentication() != null) {
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
                AuthenticationContext authCtx = AuthenticationContext.forProxy((RepositorySystemSession)session, (RemoteRepository)repo);
                p.setUserName(authCtx.get("username"));
                p.setPassword(authCtx.get("password"));
                p.setNtlmDomain(authCtx.get("ntlm.domain"));
                p.setNtlmHost(authCtx.get("ntlm.workstation"));
                authCtx.close();
            }
            return p;
        }
        return null;
    }

    public void injectProxy(RepositorySystemSession session, List<ArtifactRepository> repositories) {
        if (repositories != null && session != null) {
            for (ArtifactRepository repository : repositories) {
                repository.setProxy(this.getProxy(session, repository));
            }
        }
    }

    private ArtifactRepositoryLayout getLayout(String id) {
        ArtifactRepositoryLayout layout = this.layouts.get(id);
        return layout;
    }

    public static org.apache.maven.model.Repository fromSettingsRepository(Repository settingsRepository) {
        org.apache.maven.model.Repository modelRepository = new org.apache.maven.model.Repository();
        modelRepository.setId(settingsRepository.getId());
        modelRepository.setLayout(settingsRepository.getLayout());
        modelRepository.setName(settingsRepository.getName());
        modelRepository.setUrl(settingsRepository.getUrl());
        modelRepository.setReleases(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getReleases()));
        modelRepository.setSnapshots(MavenRepositorySystem.fromSettingsRepositoryPolicy(settingsRepository.getSnapshots()));
        return modelRepository;
    }

    public static RepositoryPolicy fromSettingsRepositoryPolicy(org.apache.maven.settings.RepositoryPolicy settingsRepositoryPolicy) {
        RepositoryPolicy modelRepositoryPolicy = new RepositoryPolicy();
        if (settingsRepositoryPolicy != null) {
            modelRepositoryPolicy.setEnabled(settingsRepositoryPolicy.isEnabled());
            modelRepositoryPolicy.setUpdatePolicy(settingsRepositoryPolicy.getUpdatePolicy());
            modelRepositoryPolicy.setChecksumPolicy(settingsRepositoryPolicy.getChecksumPolicy());
        }
        return modelRepositoryPolicy;
    }

    public static ArtifactRepository buildArtifactRepository(Repository repo) throws InvalidRepositoryException {
        return MavenRepositorySystem.buildArtifactRepository(MavenRepositorySystem.fromSettingsRepository(repo));
    }

    public static ArtifactRepository buildArtifactRepository(org.apache.maven.model.Repository repo) throws InvalidRepositoryException {
        if (repo != null) {
            String id = repo.getId();
            if (StringUtils.isEmpty((String)id)) {
                throw new InvalidRepositoryException("Repository identifier missing", "");
            }
            String url = repo.getUrl();
            if (StringUtils.isEmpty((String)url)) {
                throw new InvalidRepositoryException("URL missing for repository " + id, id);
            }
            ArtifactRepositoryPolicy snapshots = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getSnapshots());
            ArtifactRepositoryPolicy releases = MavenRepositorySystem.buildArtifactRepositoryPolicy(repo.getReleases());
            DefaultRepositoryLayout layout = new DefaultRepositoryLayout();
            return MavenRepositorySystem.createArtifactRepository(id, url, layout, snapshots, releases);
        }
        return null;
    }

    public static ArtifactRepositoryPolicy buildArtifactRepositoryPolicy(RepositoryPolicy policy) {
        boolean enabled = true;
        String updatePolicy = null;
        String checksumPolicy = null;
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updatePolicy = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksumPolicy = policy.getChecksumPolicy();
            }
        }
        return new ArtifactRepositoryPolicy(enabled, updatePolicy, checksumPolicy);
    }

    public static ArtifactRepository createArtifactRepository(String id, String url, ArtifactRepositoryLayout repositoryLayout, ArtifactRepositoryPolicy snapshots, ArtifactRepositoryPolicy releases) {
        if (snapshots == null) {
            snapshots = new ArtifactRepositoryPolicy();
        }
        if (releases == null) {
            releases = new ArtifactRepositoryPolicy();
        }
        Object repository = repositoryLayout instanceof ArtifactRepositoryLayout2 ? ((ArtifactRepositoryLayout2)repositoryLayout).newMavenArtifactRepository(id, url, snapshots, releases) : new MavenArtifactRepository(id, url, repositoryLayout, snapshots, releases);
        return repository;
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, type, null, null);
    }

    private Artifact XcreateDependencyArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, boolean optional) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, null, optional);
    }

    private Artifact XcreateProjectArtifact(String groupId, String artifactId, String version) {
        return this.XcreateProjectArtifact(groupId, artifactId, version, null);
    }

    private Artifact XcreateParentArtifact(String groupId, String artifactId, String version) {
        return this.XcreateProjectArtifact(groupId, artifactId, version);
    }

    private Artifact XcreatePluginArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, "maven-plugin", null, "runtime", null);
    }

    private Artifact XcreateProjectArtifact(String groupId, String artifactId, String version, String scope) {
        return this.XcreateArtifact(groupId, artifactId, version, scope, "pom");
    }

    private Artifact XcreateExtensionArtifact(String groupId, String artifactId, VersionRange versionRange) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, "jar", null, "runtime", null);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, String version, String scope, String type, String classifier, String inheritedScope) {
        VersionRange versionRange = null;
        if (version != null) {
            versionRange = VersionRange.createFromVersion((String)version);
        }
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope) {
        return this.XcreateArtifact(groupId, artifactId, versionRange, type, classifier, scope, inheritedScope, false);
    }

    private Artifact XcreateArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope)) {
            desiredScope = "system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }
}

