/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateUncached
public abstract class KeyInfoNode
extends JavaScriptBaseNode {
    public static final int READABLE = 1;
    public static final int MODIFIABLE = 2;
    public static final int INSERTABLE = 4;
    public static final int INVOCABLE = 8;
    public static final int REMOVABLE = 16;
    public static final int READ_SIDE_EFFECTS = 32;
    public static final int WRITE_SIDE_EFFECTS = 64;
    public static final int WRITABLE = 6;

    KeyInfoNode() {
    }

    public abstract boolean execute(DynamicObject var1, String var2, int var3);

    public abstract boolean execute(DynamicObject var1, long var2, int var4);

    @Specialization
    static boolean member(DynamicObject target, String key, int query) {
        boolean writeSideEffects;
        PropertyDescriptor desc = null;
        boolean isProxy = false;
        DynamicObject proto = target;
        while (proto != Null.instance) {
            desc = JSObject.getOwnProperty(proto, key);
            if (JSProxy.isProxy(proto)) {
                isProxy = true;
                break;
            }
            if (desc != null) break;
            proto = JSObject.getPrototype(proto);
        }
        if (desc == null) {
            return (query & 4) != 0 && JSObject.isExtensible(target);
        }
        boolean hasGet = desc.hasGet() && desc.getGet() != Undefined.instance;
        boolean hasSet = desc.hasSet() && desc.getSet() != Undefined.instance;
        boolean readable = hasGet || !hasSet;
        boolean writable = hasSet || !hasGet && desc.getIfHasWritable(true);
        boolean readSideEffects = isProxy || hasGet;
        boolean bl = writeSideEffects = isProxy || hasSet;
        if ((query & 1) != 0 && readable) {
            return true;
        }
        if ((query & 2) != 0 && writable) {
            return true;
        }
        if ((query & 0x20) != 0 && readSideEffects) {
            return true;
        }
        if ((query & 0x40) != 0 && writeSideEffects) {
            return true;
        }
        if ((query & 8) != 0 && desc.isDataDescriptor() && JSRuntime.isCallable(desc.getValue())) {
            return true;
        }
        return (query & 0x10) != 0 && desc.getConfigurable();
    }

    @Specialization
    static boolean element(DynamicObject target, long index, int query) {
        boolean writable;
        assert (query == (query & 0x17));
        String key = Boundaries.stringValueOf(index);
        PropertyDescriptor desc = null;
        DynamicObject proto = target;
        while (proto != Null.instance) {
            desc = JSObject.getOwnProperty(proto, key);
            if (JSProxy.isProxy(proto) || desc != null) break;
            proto = JSObject.getPrototype(proto);
        }
        if (desc == null) {
            return (query & 4) != 0 && JSObject.isExtensible(target);
        }
        boolean hasGet = desc.hasGet() && desc.getGet() != Undefined.instance;
        boolean hasSet = desc.hasSet() && desc.getSet() != Undefined.instance;
        boolean readable = hasGet || !hasSet;
        boolean bl = writable = hasSet || !hasGet && desc.getIfHasWritable(true);
        if ((query & 1) != 0 && readable) {
            return true;
        }
        if ((query & 2) != 0 && writable) {
            return true;
        }
        return (query & 0x10) != 0 && desc.getConfigurable();
    }
}

