/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.properties.PropertyResolver;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="read-project-properties", defaultPhase=LifecyclePhase.NONE, requiresProject=true, threadSafe=true)
public class ReadPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private File[] files = new File[0];
    @Parameter
    private String[] urls = new String[0];
    @Parameter(defaultValue="false")
    private boolean quiet;
    private final PropertyResolver resolver = new PropertyResolver();

    public void setFiles(File[] files) {
        if (files == null) {
            this.files = new File[0];
        } else {
            this.files = new File[files.length];
            System.arraycopy(files, 0, this.files, 0, files.length);
        }
    }

    public void setUrls(String[] urls) {
        if (urls == null) {
            this.urls = null;
        } else {
            this.urls = new String[urls.length];
            System.arraycopy(urls, 0, this.urls, 0, urls.length);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.checkParameters();
        this.loadFiles();
        this.loadUrls();
        this.resolveProperties();
    }

    private void checkParameters() throws MojoExecutionException {
        if (this.files.length > 0 && this.urls.length > 0) {
            throw new MojoExecutionException("Set files or URLs but not both - otherwise no order of precedence can be guaranteed");
        }
    }

    private void loadFiles() throws MojoExecutionException {
        for (int i = 0; i < this.files.length; ++i) {
            this.load(new FileResource(this.files[i]));
        }
    }

    private void loadUrls() throws MojoExecutionException {
        for (int i = 0; i < this.urls.length; ++i) {
            this.load(new UrlResource(this.urls[i]));
        }
    }

    private void load(Resource resource) throws MojoExecutionException {
        if (resource.canBeOpened()) {
            this.loadProperties(resource);
        } else {
            this.missing(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Resource resource) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Loading properties from " + resource));
            InputStream stream = resource.getInputStream();
            try {
                this.project.getProperties().load(stream);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading properties from " + resource, (Exception)e);
        }
    }

    private void missing(Resource resource) throws MojoExecutionException {
        if (!this.quiet) {
            throw new MojoExecutionException("Properties could not be loaded from " + resource);
        }
        this.getLog().info((CharSequence)("Quiet processing - ignoring properties cannot be loaded from " + resource));
    }

    private void resolveProperties() throws MojoExecutionException, MojoFailureException {
        Properties environment = this.loadSystemEnvironmentPropertiesWhenDefined();
        Properties projectProperties = this.project.getProperties();
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            projectProperties.setProperty(k, this.getPropertyValue(k, projectProperties, environment));
        }
    }

    private Properties loadSystemEnvironmentPropertiesWhenDefined() throws MojoExecutionException {
        Properties projectProperties = this.project.getProperties();
        boolean useEnvVariables = false;
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            String p = (String)projectProperties.get(k);
            if (p.indexOf("${env.") == -1) continue;
            useEnvVariables = true;
            break;
        }
        Properties environment = null;
        if (useEnvVariables) {
            try {
                environment = this.getSystemEnvVars();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error getting system environment variables: ", (Exception)e);
            }
        }
        return environment;
    }

    private String getPropertyValue(String k, Properties p, Properties environment) throws MojoFailureException {
        try {
            return this.resolver.getPropertyValue(k, p, environment);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars();
    }

    void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    private static class UrlResource
    extends Resource {
        private static final String CLASSPATH_PREFIX = "classpath:";
        private static final String SLASH_PREFIX = "/";
        private final URL url;
        private boolean isMissingClasspathResouce = false;
        private String classpathUrl;

        public UrlResource(String url) throws MojoExecutionException {
            if (url.startsWith(CLASSPATH_PREFIX)) {
                String resource = url.substring(CLASSPATH_PREFIX.length(), url.length());
                if (resource.startsWith(SLASH_PREFIX)) {
                    resource = resource.substring(1, resource.length());
                }
                this.url = this.getClass().getClassLoader().getResource(resource);
                if (this.url == null) {
                    this.isMissingClasspathResouce = true;
                    this.classpathUrl = url;
                }
            } else {
                try {
                    this.url = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Badly formed URL " + url + " - " + e.getMessage());
                }
            }
        }

        public boolean canBeOpened() {
            if (this.isMissingClasspathResouce) {
                return false;
            }
            try {
                this.openStream();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(this.url.openStream());
        }

        public String toString() {
            if (!this.isMissingClasspathResouce) {
                return "URL " + this.url.toString();
            }
            return this.classpathUrl;
        }
    }

    private static class FileResource
    extends Resource {
        private final File file;

        public FileResource(File file) {
            this.file = file;
        }

        public boolean canBeOpened() {
            return this.file.exists();
        }

        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        public String toString() {
            return "File: " + this.file;
        }
    }

    private static abstract class Resource {
        private InputStream stream;

        private Resource() {
        }

        public abstract boolean canBeOpened();

        protected abstract InputStream openStream() throws IOException;

        public InputStream getInputStream() throws IOException {
            if (this.stream == null) {
                this.stream = this.openStream();
            }
            return this.stream;
        }
    }
}

