/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.runorder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.runorder.PrioritizedTest;
import org.apache.maven.surefire.api.runorder.Priority;
import org.apache.maven.surefire.api.runorder.RunEntryStatistics;
import org.apache.maven.surefire.api.runorder.ThreadedExecutionScheduler;
import org.apache.maven.surefire.api.util.internal.ClassMethod;
import org.apache.maven.surefire.api.util.internal.StringUtils;

public final class RunEntryStatisticsMap {
    private final Map<ClassMethod, RunEntryStatistics> runEntryStatistics;

    private RunEntryStatisticsMap(Map<ClassMethod, RunEntryStatistics> runEntryStatistics) {
        this.runEntryStatistics = new ConcurrentHashMap<ClassMethod, RunEntryStatistics>(runEntryStatistics);
    }

    public RunEntryStatisticsMap() {
        this.runEntryStatistics = new ConcurrentHashMap<ClassMethod, RunEntryStatistics>();
    }

    public static RunEntryStatisticsMap fromFile(File file) {
        if (file.exists()) {
            try {
                return RunEntryStatisticsMap.fromStream(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new RunEntryStatisticsMap();
    }

    public static RunEntryStatisticsMap fromStream(InputStream fileReader) {
        HashMap<ClassMethod, RunEntryStatistics> result = new HashMap<ClassMethod, RunEntryStatistics>();
        try (Scanner scanner = new Scanner(fileReader, "UTF-8");){
            RunEntryStatistics previous = null;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.charAt(0) == ' ') {
                    previous = new RunEntryStatistics(previous.getRunTime(), previous.getSuccessfulBuilds(), previous.getClassMethod().getClazz(), previous.getClassMethod().getMethod() + StringUtils.NL + line.substring(1));
                    continue;
                }
                if (previous != null) {
                    result.put(previous.getClassMethod(), previous);
                }
                int to = line.indexOf(44);
                String successfulBuildsString = line.substring(0, to);
                int successfulBuilds = Integer.parseInt(successfulBuildsString);
                int from = 1 + to;
                to = line.indexOf(44, from + 1);
                String runTimeString = line.substring(from, to);
                int runTime = Integer.parseInt(runTimeString);
                from = 1 + to;
                String className = (to = line.indexOf(44, from + 1)) == -1 ? line.substring(from) : line.substring(from, to);
                from = 1 + to;
                String methodName = to == -1 ? null : line.substring(from);
                ClassMethod classMethod = new ClassMethod(className, methodName);
                previous = new RunEntryStatistics(runTime, successfulBuilds, classMethod);
            }
            if (previous != null) {
                result.put(previous.getClassMethod(), previous);
            }
        }
        return new RunEntryStatisticsMap(result);
    }

    public void serialize(File statsFile) throws IOException {
        if (statsFile.isFile()) {
            statsFile.delete();
        }
        FileOutputStream os = new FileOutputStream(statsFile);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8), 65536);){
            ArrayList<RunEntryStatistics> items = new ArrayList<RunEntryStatistics>(this.runEntryStatistics.values());
            Collections.sort(items, new RunCountComparator());
            Iterator it = items.iterator();
            while (it.hasNext()) {
                RunEntryStatistics item = (RunEntryStatistics)it.next();
                ClassMethod test = item.getClassMethod();
                String line = item.getSuccessfulBuilds() + "," + item.getRunTime() + "," + test.getClazz() + ",";
                writer.write(line);
                boolean wasFirstLine = false;
                String method = test.getMethod();
                if (method == null) continue;
                Scanner scanner = new Scanner(method);
                while (scanner.hasNextLine()) {
                    String methodLine = scanner.nextLine();
                    if (wasFirstLine) {
                        writer.write(32);
                    }
                    writer.write(methodLine);
                    if (scanner.hasNextLine()) {
                        writer.newLine();
                    }
                    wasFirstLine = true;
                }
                if (!it.hasNext()) continue;
                writer.newLine();
            }
        }
    }

    private RunEntryStatistics findOrCreate(ReportEntry reportEntry) {
        ClassMethod classMethod = new ClassMethod(reportEntry.getSourceName(), reportEntry.getName());
        RunEntryStatistics item = this.runEntryStatistics.get(classMethod);
        return item != null ? item : new RunEntryStatistics(reportEntry.getElapsed(0), 0, classMethod);
    }

    public RunEntryStatistics createNextGeneration(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        return newItem.nextGeneration(reportEntry.getElapsed(0));
    }

    public RunEntryStatistics createNextGenerationFailure(ReportEntry reportEntry) {
        RunEntryStatistics newItem = this.findOrCreate(reportEntry);
        return newItem.nextGenerationFailure(reportEntry.getElapsed(0));
    }

    public void add(RunEntryStatistics item) {
        this.runEntryStatistics.put(item.getClassMethod(), item);
    }

    public List<Class<?>> getPrioritizedTestsClassRunTime(List<Class<?>> testsToRun, int threadCount) {
        List<PrioritizedTest> prioritizedTests = this.getPrioritizedTests(testsToRun, new TestRuntimeComparator());
        ThreadedExecutionScheduler threadedExecutionScheduler = new ThreadedExecutionScheduler(threadCount);
        for (PrioritizedTest prioritizedTest1 : prioritizedTests) {
            threadedExecutionScheduler.addTest(prioritizedTest1);
        }
        return threadedExecutionScheduler.getResult();
    }

    public List<Class<?>> getPrioritizedTestsByFailureFirst(List<Class<?>> testsToRun) {
        List<PrioritizedTest> prioritizedTests = this.getPrioritizedTests(testsToRun, new LeastFailureComparator());
        return RunEntryStatisticsMap.transformToClasses(prioritizedTests);
    }

    private List<PrioritizedTest> getPrioritizedTests(List<Class<?>> testsToRun, Comparator<Priority> priorityComparator) {
        Map<String, Priority> classPriorities = this.getPriorities(priorityComparator);
        ArrayList<PrioritizedTest> tests = new ArrayList<PrioritizedTest>();
        for (Class<?> clazz : testsToRun) {
            Priority pri = classPriorities.get(clazz.getName());
            if (pri == null) {
                pri = Priority.newTestClassPriority(clazz.getName());
            }
            PrioritizedTest prioritizedTest = new PrioritizedTest(clazz, pri);
            tests.add(prioritizedTest);
        }
        Collections.sort(tests, new PrioritizedTestComparator());
        return tests;
    }

    private static List<Class<?>> transformToClasses(List<PrioritizedTest> tests) {
        ArrayList result = new ArrayList();
        for (PrioritizedTest test : tests) {
            result.add(test.getClazz());
        }
        return result;
    }

    private Map<String, Priority> getPriorities(Comparator<Priority> priorityComparator) {
        HashMap<String, Priority> priorities = new HashMap<String, Priority>();
        for (Map.Entry<ClassMethod, RunEntryStatistics> testNames : this.runEntryStatistics.entrySet()) {
            String clazzName = testNames.getKey().getClazz();
            Priority priority = (Priority)priorities.get(clazzName);
            if (priority == null) {
                priority = new Priority(clazzName);
                priorities.put(clazzName, priority);
            }
            priority.addItem(testNames.getValue());
        }
        ArrayList items = new ArrayList(priorities.values());
        Collections.sort(items, priorityComparator);
        HashMap<String, Priority> result = new HashMap<String, Priority>();
        int i = 0;
        for (Priority pri : items) {
            pri.setPriority(i++);
            result.put(pri.getClassName(), pri);
        }
        return result;
    }

    static final class LeastFailureComparator
    implements Comparator<Priority> {
        LeastFailureComparator() {
        }

        @Override
        public int compare(Priority o, Priority o1) {
            return o.getMinSuccessRate() - o1.getMinSuccessRate();
        }
    }

    static final class TestRuntimeComparator
    implements Comparator<Priority> {
        TestRuntimeComparator() {
        }

        @Override
        public int compare(Priority o, Priority o1) {
            return o1.getTotalRuntime() - o.getTotalRuntime();
        }
    }

    static final class PrioritizedTestComparator
    implements Comparator<PrioritizedTest> {
        PrioritizedTestComparator() {
        }

        @Override
        public int compare(PrioritizedTest o, PrioritizedTest o1) {
            return o.getPriority() - o1.getPriority();
        }
    }

    static final class RunCountComparator
    implements Comparator<RunEntryStatistics> {
        RunCountComparator() {
        }

        @Override
        public int compare(RunEntryStatistics o, RunEntryStatistics o1) {
            int runtime = o.getSuccessfulBuilds() - o1.getSuccessfulBuilds();
            return runtime == 0 ? o.getRunTime() - o1.getRunTime() : runtime;
        }
    }
}

