/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.apache.maven.plugin.surefire.JdkAttributes;
import org.apache.maven.surefire.booter.SystemUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;

public final class Platform {
    private final RunnableFuture<Long> pluginPidJob;
    private volatile JdkAttributes jdk;

    public Platform() {
        this(new FutureTask<Long>(Platform.pidJob()), null);
        DaemonThreadFactory.newDaemonThread(this.pluginPidJob).start();
    }

    private Platform(RunnableFuture<Long> pluginPidJob, JdkAttributes jdk) {
        this.pluginPidJob = pluginPidJob;
        this.jdk = jdk;
    }

    public Long getPluginPid() {
        try {
            return (Long)this.pluginPidJob.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public JdkAttributes getJdkExecAttributesForTests() {
        return this.jdk;
    }

    public Platform withJdkExecAttributesForTests(JdkAttributes jdk) {
        return new Platform(this.pluginPidJob, jdk);
    }

    private static Callable<Long> pidJob() {
        return new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                return SystemUtils.pid();
            }
        };
    }
}

