/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputCharAtNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputStartsWithNodeGen;

public abstract class InputStartsWithNode
extends Node {
    public static InputStartsWithNode create() {
        return InputStartsWithNodeGen.create();
    }

    public abstract boolean execute(Object var1, String var2, String var3);

    @Specialization(guards={"mask == null"})
    public boolean startsWith(String input, String prefix, String mask) {
        return input.startsWith(prefix);
    }

    @Specialization(guards={"mask != null"})
    public boolean startsWithWithMask(String input, String prefix, String mask) {
        return ArrayUtils.regionEqualsWithOrMask((String)input, (int)0, (String)prefix, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean startsWithTruffleObjNoMask(TruffleObject input, String prefix, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean startsWithTruffleObjWithMask(TruffleObject input, String prefix, String mask, @Cached(value="create()") InputLengthNode lengthNode, @Cached(value="create()") InputCharAtNode charAtNode) {
        assert (mask.length() == prefix.length());
        return InputStartsWithNode.startsWithTruffleObj(input, prefix, mask, lengthNode, charAtNode);
    }

    private static boolean startsWithTruffleObj(TruffleObject input, String prefix, String mask, InputLengthNode lengthNode, InputCharAtNode charAtNode) {
        if (lengthNode.execute(input) < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (InputCharAtNode.charAtWithMask(input, i, mask, i, charAtNode) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

